; (certify-book "systemcalls" ? t :ttags (:syscall-raw-impl :include-raw))

(in-package "ACL2")

; (include-book "models/y86/y86-basic/y86/y86" :dir :system)
(include-book "y86-basic-new/y86/y86")

(defttag :syscall-raw-impl)

(defun syscall-open-logic (pathname flags x86-32)
  (declare (xargs :stobjs x86-32))
  (declare (ignore pathname flags))
  (mv-let (val x86-32)
          (pop-x86-32-oracle x86-32)
          (mv (list (ifix val)) x86-32)))

(defun syscall-open (pathname flags x86-32)
  (declare (xargs :stobjs x86-32
                  :guard (i32p flags))
           (type string pathname))
  (syscall-open-logic pathname flags x86-32))

(defun syscall-close-logic (flags x86-32)
  (declare (xargs :stobjs x86-32)
           (ignore flags))
  (mv-let (val x86-32)
          (pop-x86-32-oracle x86-32)
          (mv (list (ifix val)) x86-32)))

(defun syscall-close (filedes x86-32)
  (declare (xargs :stobjs x86-32
                  :guard (i32p filedes)))
  (syscall-close-logic filedes x86-32))

(defun sfix (x)
  (declare (xargs :guard t))
  (if (stringp x) x ""))

(defun syscall-read-logic (filedes nbytes x86-32)
  (declare (xargs :stobjs x86-32)
           (ignore filedes nbytes))
  (mv-let (val x86-32)
          (pop-x86-32-oracle x86-32)
          (mv-let (str x86-32)
                  (pop-x86-32-oracle x86-32)
                  (mv (list (ifix val) (sfix str)) x86-32))))

(defun syscall-read (filedes nbytes x86-32)
  (declare (xargs :stobjs x86-32
                  :guard (and (i32p filedes)
                              (n32p nbytes))))
  (syscall-read-logic filedes nbytes x86-32))

(defun syscall-write-logic (filedes buffer nbytes x86-32)
  (declare (xargs :stobjs x86-32)
           (ignore filedes buffer nbytes))
  (mv-let (val x86-32)
          (pop-x86-32-oracle x86-32)
          (mv (list (ifix val)) x86-32)))

(defun syscall-write (filedes buffer nbytes x86-32)
  (declare (xargs :stobjs x86-32
                  :guard (and (i32p filedes)
                              (n32p nbytes)))
           (type string buffer))
  (syscall-write-logic filedes buffer nbytes x86-32))

(include-book "tools/include-raw" :dir :system)

(include-raw "systemcalls-raw.lsp")

; Test:
#||

; Critical first step:
(update-x86-32-oracle-from-state x86-32 state)

(syscall-write 1 ; stdout
               "hello" ; buffer, a string
               (1+ (length "hello")) ; might not need 1+
               x86-32
               )

(mv-let (result x86-32)
        (syscall-write 1               ; stdout
                       "hello"         ; buffer, a string
                       (1+ (length "hello")) ; might not need 1+
                       x86-32)
        (mv (equal '(6)
                   (prog2$ (cw "~%~%some newlines~%~%") result))
            x86-32))

; The following had better fail!
(thm (mv-let (result x86-32)
             (syscall-write 1               ; stdout
                            "hello"         ; buffer, a string
                            (1+ (length "hello")) ; might not need 1+
                            x86-32)
             (declare (ignore x86-32))
             (equal '(6) result)))

||#
