var xdata = {"COMMON-LISP____DEFUN":[["Events","Programming"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> app (x y)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A      (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (app (<see topic=\"COMMON-LISP____CDR\">cdr</see> x) y))\u000A      y))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n)\u000A                              (<see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see> n 0))))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A      1\u000A      (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n)))))\u000A\u000AGeneral Form:\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fn (var1 ... varn) doc-string dcl ... dcl body),</code> \u000A \u000A <p>where <v>fn</v> is the symbol you wish to define and is a new symbolic name \u000A (see <see topic=\"ACL2____NAME\">name</see>), <v>(var1 ... varn)</v> is its list of formal parameters (see \u000A <see topic=\"ACL2____NAME\">name</see>), and <v>body</v> is its body.  The definitional axiom is logically \u000A admissible provided certain restrictions are met.  These are sketched \u000A below.</p> \u000A \u000A <p>Note that ACL2 does not support the use of <v>lambda-list</v> keywords (such \u000A as <v>&amp;optional</v>) in the formals list of functions.  We do support some such \u000A keywords in macros and often you can achieve the desired syntax by defining a \u000A macro in addition to the general version of your function.  See <see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see>.  <v>Doc-string</v>, if non-<v>nil</v>, is an optional string that can \u000A provide documentation but is essentially ignored by ACL2.</p> \u000A \u000A <p>The <i>declarations</i> (see <see topic=\"COMMON-LISP____DECLARE\">declare</see>), <v>dcl</v>, are also optional. \u000A If more than one <v>dcl</v> form appears, they are effectively grouped together \u000A as one.  Perhaps the most commonly used ACL2 specific declaration is of the \u000A form <v>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard g :measure m))</v>.  This declaration in the \u000A <v>defun</v> of some function <v>fn</v> has the effect of making the ``<see topic=\"ACL2____GUARD\">guard</see>'' for <v>fn</v> be the term <v>g</v> and the ``measure'' be the term \u000A <v>m</v>.  The notion of ``measure'' is crucial to ACL2's definitional \u000A principle.  The notion of ``guard'' is not, and is discussed elsewhere; see \u000A <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> and see <see topic=\"ACL2____SET-VERIFY-GUARDS-EAGERNESS\">set-verify-guards-eagerness</see>.  Note that \u000A the <v>:measure</v> is ignored in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode; see <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>.</p> \u000A \u000A <p>We now briefly discuss the ACL2 definitional principle, using the following \u000A definition form which is offered as a more or less generic example.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fn (x y)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (g x y)\u000A                  :measure (m x y)))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (test x y)\u000A      (stop x y)\u000A    (step (fn (d x) y))))</code> \u000A \u000A <p>Note that in our generic example, <v>fn</v> has just two arguments, <v>x</v> \u000A and <v>y</v>, the <see topic=\"ACL2____GUARD\">guard</see> and measure terms involve both of them, and the \u000A body is a simple case split on <v>(test x y)</v> leading to a ``non-recursive'' \u000A branch, <v>(stop x y)</v>, and a ``recursive'' branch.  In the recursive branch, \u000A <v>fn</v> is called after ``decrementing'' <v>x</v> to <v>(d x)</v> and some step \u000A function is applied to the result.  Of course, this generic example is quite \u000A specific in form but is intended to illustrate the more general case.</p> \u000A \u000A <p>Provided this definition is admissible under the logic, as outlined below, \u000A it adds the following axiom to the logic.</p> \u000A \u000A <code>Defining Axiom:\u000A(fn x y)\u000A  =\u000A(<see topic=\"COMMON-LISP____IF\">if</see> (test x y)\u000A    (stop x y)\u000A  (step (fn (d x) y)))</code> \u000A \u000A <p>Note that the <see topic=\"ACL2____GUARD\">guard</see> of <v>fn</v> has no bearing on this logical \u000A axiom.</p> \u000A \u000A <p>This defining axiom is actually implemented in the ACL2 system by a \u000A <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> rule, namely</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (fn x y)\u000A       (<see topic=\"COMMON-LISP____IF\">if</see> (test a b)\u000A           (stop a b)\u000A         (step (fn (d a) b)))).</code> \u000A \u000A <p>See <see topic=\"ACL2____DEFINITION\">definition</see> for a discussion of how definition rules are applied. \u000A Roughly speaking, the rule causes certain instances of <v>(fn x y)</v> to be \u000A replaced by the corresponding instances of the body above.  This is called \u000A ``opening up'' <v>(fn x y)</v>.  The instances of <v>(fn x y)</v> opened are \u000A chosen primarily by heuristics which determine that the recursive calls of \u000A <v>fn</v> in the opened body (after simplification) are more desirable than the \u000A unopened call of <v>fn</v>.</p> \u000A \u000A <p>This discussion has assumed that the definition of <v>fn</v> was admissible. \u000A Exactly what does that mean?  First, <v>fn</v> must be a previously \u000A unaxiomatized function symbol (however, see <see topic=\"ACL2____LD-REDEFINITION-ACTION\">ld-redefinition-action</see>). \u000A Second, the formal parameters must be distinct variable names.  Third, the \u000A <see topic=\"ACL2____GUARD\">guard</see>, measure, and body should all be terms and should mention no free \u000A variables except the formal parameters.  Thus, for example, body may not \u000A contain references to ``global'' or ``special'' variables; ACL2 constants or \u000A additional formals should be used instead.</p> \u000A \u000A <p>The final conditions on admissibility concern the termination of the \u000A recursion.  Roughly put, all applications of <v>fn</v> must terminate.  In \u000A particular, there must exist a binary relation, <v>rel</v>, and some unary \u000A predicate <v>mp</v> such that <v>rel</v> is well-founded on objects satisfying \u000A <v>mp</v>, the measure term <v>m</v> must always produce something satisfying \u000A <v>mp</v>, and the measure term must decrease according to <v>rel</v> in each \u000A recursive call, under the hypothesis that all the tests governing the call are \u000A satisfied.  By the meaning of well-foundedness, we know there are no \u000A infinitely descending chains of successively <v>rel</v>-smaller <v>mp</v>-objects. \u000A Thus, the recursion must terminate.</p> \u000A \u000A <p>The only primitive well-founded relation in ACL2 is <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt> (see <see topic=\"ACL2____O_C3\">o&lt;</see>), which is known to be well-founded on the <tt><see topic=\"ACL2____O-P\">o-p</see></tt>s (see <see topic=\"ACL2____O-P\">o-p</see>). \u000A For the proof of well-foundedness, see <see topic=\"ACL2____PROOF-OF-WELL-FOUNDEDNESS\">proof-of-well-foundedness</see>. \u000A However it is possible to add new well-founded relations.  For details, see \u000A <see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see>.  We discuss later how to specify which \u000A well-founded relation is selected by <v>defun</v> and in the present discussion \u000A we assume, without loss of generality, that it is <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt> on the <tt><see topic=\"ACL2____O-P\">o-p</see></tt>s.</p> \u000A \u000A <p>For example, for our generic definition of <v>fn</v> above, with measure term \u000A <v>(m x y)</v>, two theorems must be proved.  The first establishes that <v>m</v> \u000A produces an ordinal:</p> \u000A \u000A <code>(<see topic=\"ACL2____O-P\">o-p</see> (m x y)).</code> \u000A \u000A <p>The second shows that <v>m</v> decreases in the (only) recursive call of \u000A <v>fn</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (test x y))\u000A         (<see topic=\"ACL2____O_C3\">o&lt;</see> (m (d x) y) (m x y))).</code> \u000A \u000A <p>Observe that in the latter formula we must show that the ``<v>m</v>-size'' of \u000A <v>(d x)</v> and <v>y</v> is ``smaller than'' the <v>m</v>-size of <v>x</v> and \u000A <v>y</v>, provided the test, <v>(test x y)</v>, in the body fails, thus leading to \u000A the recursive call <v>(fn (d x) y)</v>.</p> \u000A \u000A <p>See <see topic=\"ACL2____O_C3\">o&lt;</see> for a discussion of this notion of ``smaller than.''  It \u000A should be noted that the most commonly used ordinals are the natural numbers \u000A and that on natural numbers, <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt> is just the familiar ``less than'' \u000A relation (<tt><see topic=\"COMMON-LISP_____C3\">&lt;</see></tt>).  Thus, it is very common to use a measure <v>m</v> that \u000A returns a nonnegative integer, for then <v>(<see topic=\"ACL2____O-P\">o-p</see> (m x y))</v> becomes a simple \u000A conjecture about the type of <v>m</v> and the second formula above becomes a \u000A conjecture about the less-than relationship of nonnegative integer \u000A arithmetic.</p> \u000A \u000A <p>The most commonly used measure function is <tt><see topic=\"ACL2____ACL2-COUNT\">ACL2-count</see></tt>, which \u000A computes a nonnegative integer size for all ACL2 objects.  See <see topic=\"ACL2____ACL2-COUNT\">ACL2-count</see>.</p> \u000A \u000A <p>Probably the most common recursive scheme in Lisp <see topic=\"ACL2____PROGRAMMING\">programming</see> is \u000A when some formal is supposed to be a list and in the recursive call it is \u000A replaced by its <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>.  For example, <v>(test x y)</v> might be simply \u000A <v>(<see topic=\"COMMON-LISP____ATOM\">atom</see> x)</v> and <v>(d x)</v> might be <v>(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)</v>.  In that case, \u000A <v>(<see topic=\"ACL2____ACL2-COUNT\">acl2-count</see> x)</v> is a suitable measure because the <tt><see topic=\"ACL2____ACL2-COUNT\">ACL2-count</see></tt> of a \u000A <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> is strictly larger than the <tt><see topic=\"ACL2____ACL2-COUNT\">ACL2-count</see></tt>s of its <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> and <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>.  Thus, ``recursion by <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt>'' and ``recursion by \u000A <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>'' are trivially admitted if <tt><see topic=\"ACL2____ACL2-COUNT\">ACL2-count</see></tt> is used as the \u000A measure and the definition protects every recursive call by a test insuring \u000A that the decremented argument is a <tt><see topic=\"COMMON-LISP____CONSP\">consp</see></tt>.  Similarly, ``recursion by \u000A <tt><see topic=\"COMMON-LISP____1-\">1-</see></tt>'' in which a positive integer formal is decremented by one in \u000A recursion, is also trivially admissible.  See <see topic=\"ACL2____BUILT-IN-CLAUSE\">built-in-clause</see> to extend \u000A the class of trivially admissible recursive schemes.</p> \u000A \u000A <p>We now turn to the question of which well-founded relation <v>defun</v> uses. \u000A It should first be observed that <v>defun</v> must actually select both a \u000A relation (e.g., <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt>) and a domain predicate (e.g., <tt><see topic=\"ACL2____O-P\">o-p</see></tt>) on \u000A which that relation is known to be well-founded.  But, as noted elsewhere (see \u000A <see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see>), every known well-founded relation has a unique \u000A domain predicate associated with it and so it suffices to identify simply the \u000A relation here.</p> \u000A \u000A <p>The <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> field of a <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> permits the explicit \u000A specification of any known well-founded relation with the keyword <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt>.  An example is given below.  If the <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> for \u000A a <v>defun</v> specifies a well-founded relation, that relation and its \u000A associated domain predicate are used in generating the termination conditions \u000A for the definition.</p> \u000A \u000A <p>If no <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt> is specified, <v>defun</v> uses the \u000A <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt> specified in the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt>.  See <see topic=\"ACL2____SET-WELL-FOUNDED-RELATION\">set-well-founded-relation</see> to see how to set \u000A the default well-founded relation (and, implicitly, its domain predicate). \u000A The initial default well-founded relation is <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt> (with domain predicate \u000A <tt><see topic=\"ACL2____O-P\">o-p</see></tt>).</p> \u000A \u000A <p>This completes the brief sketch of the ACL2 definitional principle. \u000A Optionally, see <see topic=\"ACL2____RULER-EXTENDERS\">ruler-extenders</see> for a more detailed discussion of the \u000A termination analysis and resulting proof obligations for admissibility, as \u000A well as a discussion of the relation to how ACL2 stores induction schemes.</p> \u000A \u000A <p>On very rare occasions ACL2 will seem to \"hang\" when processing a \u000A definition, especially if there are many subexpressions of the body whose \u000A function symbol is <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> (or which macroexpand to such an expression). \u000A In those cases you may wish to supply the following to <tt><see topic=\"ACL2____XARGS\">xargs</see></tt>: \u000A <v>:normalize nil</v>.  This is an advanced feature that turns off ACL2's usual \u000A propagation upward of <v>if</v> tests.</p> \u000A \u000A <p>The following example illustrates all of the available declarations and \u000A most hint keywords, but is completely nonsensical.  For documentation, see \u000A <see topic=\"ACL2____XARGS\">xargs</see> and see <see topic=\"ACL2____HINTS\">hints</see>.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> example (x y z a b c i j)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> a b c)\u000A           (<see topic=\"COMMON-LISP____TYPE\">type</see> integer i j)\u000A           (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____SYMBOLP\">symbolp</see> x)\u000A                  :measure (<see topic=\"COMMON-LISP____-\">-</see> i j)\u000A                  :ruler-extenders :basic\u000A                  :well-founded-relation my-wfr\u000A                  :hints ((&quot;Goal&quot;\u000A                           :do-not-induct t\u000A                           :do-not '(<see topic=\"ACL2____GENERALIZE\">generalize</see> fertilize)\u000A                           :expand ((<see topic=\"COMMON-LISP____ASSOC\">assoc</see> x a) (<see topic=\"COMMON-LISP____MEMBER\">member</see> y z))\u000A                           :restrict ((&lt;-trans ((x x) (y (foo x)))))\u000A                           :hands-off (<see topic=\"COMMON-LISP____LENGTH\">length</see> binary-append)\u000A                           :in-theory (<see topic=\"ACL2____SET-DIFFERENCE-THEORIES\">set-difference-theories</see>\u000A                                        (<see topic=\"ACL2____CURRENT-THEORY\">current-theory</see> :here)\u000A                                        '(<see topic=\"COMMON-LISP____ASSOC\">assoc</see>))\u000A                           :induct (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n a) (<see topic=\"COMMON-LISP____NTH\">nth</see> n b))\u000A                           :use ((:instance assoc-of-append\u000A                                            (x a) (y b) (z c))\u000A                                 (:functional-instance\u000A                                   (:instance p-f (x a) (y b))\u000A                                   (p consp)\u000A                                   (f assoc)))))\u000A                  :guard-hints ((&quot;Subgoal *1/3'&quot;\u000A                                 :use ((:instance assoc-of-append\u000A                                                  (x a) (y b) (z c)))))\u000A                  :mode :logic\u000A                  :normalize nil\u000A                  :verify-guards nil\u000A                  :non-executable t\u000A                  :otf-flg t))\u000A  (example-body x y z i j))</code>"],

 "ACL2____WORLD":[["State"],"ACL2 Sources","ACL2","<p>The ACL2 logical world is a data structure that includes all \u000A logical content resulting from the <see topic=\"ACL2____COMMAND\">command</see>s evaluated, back through and \u000A including initialization, but not including commands that have been \u000A undone (see <see topic=\"ACL2____UBT\">ubt</see>).  Thus in particular, the world includes a \u000A represention of the current logical theory, as well as some extra-logical \u000A information such as the values of ACL2 <see topic=\"ACL2____TABLE\">table</see>s.  The rest of this topic \u000A focuses on the structure of the the ACL2 world and, more generally, the \u000A ``world'' data structure.</p> \u000A \u000A <p>A ``world'' is a list of triples, each of the form <v>(sym prop . val)</v>, \u000A implementing the ACL2 notion of property lists.  ACL2 permits the simultaneous \u000A existence of many property list worlds.  ``The world'' is often used as a \u000A shorthand for ``the ACL2 logical world'' which is the particular property list \u000A world used within the ACL2 system to maintain a database that contiains rules, \u000A <see topic=\"ACL2____TABLE\">table</see>s, and so on.</p> \u000A \u000A <p>Common Lisp provides the notion of ``property lists'' by which one can \u000A attach ``properties'' and their corresponding ``values'' to symbols.  For \u000A example, one can arrange for the <v>'color</v> property of the symbol \u000A <v>'box-14</v> to be <v>'purple</v> and the <v>'color</v> property of the symbol \u000A <v>'triangle-7</v> to be <v>'yellow</v>.  Access to property lists is given via \u000A the Common Lisp function <v>get</v>.  Thus, <v>(get 'box-14 'color)</v> might \u000A return <v>'purple</v>.  Property lists can be changed via the special form \u000A <v>setf</v>.  Thus, <v>(setf (get 'box-14 'color) 'blue)</v> changes the Common \u000A Lisp property list configuration so that <v>(get 'box-14 'color)</v> returns \u000A <v>'blue</v>.  It should be obvious that ACL2 cannot provide this facility, \u000A because Common Lisp's <v>get</v> ``function'' is not a function of its argument, \u000A but instead a function of some implicit state object representing the property \u000A list settings for all symbols.</p> \u000A \u000A <p>ACL2 provides the functions <v>getprop</v> and <v>putprop</v> which allow one \u000A to mimic the Common Lisp property list facility.  However, ACL2's <v>getprop</v> \u000A takes as one of its arguments a list that is a direct encoding of what was \u000A above called the ``state object representing the property list settings for \u000A all symbols.''  Because ACL2 already has a notion of ``<see topic=\"ACL2____STATE\">state</see>'' that is \u000A quite distinct from that used here, we call this property list object a \u000A ``world.''  A world is just a true list of triples.  Each triple is of the \u000A form <v>(sym prop . val)</v>.  This world can be thought of as a slightly \u000A elaborated form of association list and <v>getprop</v> is a slightly elaborated \u000A form of <tt><see topic=\"COMMON-LISP____ASSOC\">assoc</see></tt> that takes two keys.  When <v>getprop</v> is called on a \u000A symbol, <v>s</v>, property <v>p</v>, and world, <v>w</v>, it scans <v>w</v> for the \u000A first triple whose <v>sym</v> is <v>s</v> and <v>prop</v> is <v>p</v> and returns the \u000A corresponding <v>val</v>. <v>Getprop</v> has two additional arguments: one \u000A controls what it returns if no such <v>sym</v> and <v>prop</v> exist in <v>w</v>, \u000A and the other allows an extremely efficient implementation.  To set some \u000A property's value for some symbol, ACL2 provides <v>putprop</v>.  <v>(<see topic=\"ACL2____PUTPROP\">putprop</see> sym\u000A prop val w)</v> merely returns a new world, <v>w'</v>, in which <v>(sym prop\u000A . val)</v> has been <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt>ed onto the front of <v>w</v>, thus \u000A ``overwriting'' the <v>prop</v> value of <v>sym</v> in <v>w</v> to <v>val</v> and \u000A leaving all other properties in <v>w</v> unchanged.</p> \u000A \u000A <p>One aspect of ACL2's property list arrangement is that it is possible to \u000A have many different property list worlds.  For example, <v>'box-14</v> can have \u000A <v>'color</v> <v>'purple</v> in one world and can have <v>'color</v> <v>'yes</v> in \u000A another, and these two worlds can exist simultaneously because <v>getprop</v> is \u000A explicitly provided the world from which the property value is to be \u000A extracted.</p> \u000A \u000A <p>The efficiency alluded to above stems from the fact that Common Lisp \u000A provides property lists.  Using Common Lisp's provisions behind the scenes, \u000A ACL2 can ``install'' the properties of a given world into the Common Lisp \u000A property list state so as to make retrieval via <v>getprop</v> very fast in the \u000A special case that the world provided to <v>getprop</v> has been installed.  To \u000A permit more than one installed world, each of which is permitted to be changed \u000A via <v>putprop</v>, ACL2 requires that worlds be named and these names are used \u000A to distinquish installed versions of the various worlds.  At the moment we do \u000A not further document <v>getprop</v> and <v>putprop</v>.</p> \u000A \u000A <p>However, the ACL2 system uses a property list world, named \u000A <v>'current-acl2-world</v>, in which to store the succession of user <see topic=\"ACL2____COMMAND\">command</see>s and their effects on the logic.  This world is often referred to in \u000A our <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> as ``the world'' though it should be stressed that \u000A the user is permitted to have worlds and ACL2's is in no way distinguished \u000A except that the user is not permitted to modify it except via event <see topic=\"ACL2____COMMAND\">command</see>s.  The ACL2 world is part of the ACL2 <see topic=\"ACL2____STATE\">state</see> and may be \u000A obtained via <v>(w state)</v>.</p> \u000A \u000A <p><b>Warning</b>: The ACL2 world is very large.  Its length as of this \u000A writing (Version 2.5) is over <v>40,000</v> and it grows with each release. \u000A Furthermore, some of the values stored in it are pointers to old versions of \u000A itself.  Printing <v>(w state)</v> is something you should avoid because you \u000A likely will not have the patience to await its completion.  For these \u000A practical reasons, the only thing you should do with <v>(w state)</v> is provide \u000A it to <v>getprop</v>, as in the form</p> \u000A \u000A <code>(<see topic=\"ACL2____GETPROP\">getprop</see> sym prop default 'current-acl2-world (w state))</code> \u000A \u000A <p>to inspect properties within it, or to pass it to ACL2 primitives, such as \u000A theory functions, where it is expected.</p> \u000A \u000A <p>Some ACL2 <see topic=\"ACL2____COMMAND\">command</see> forms, such as theory expressions (see <see topic=\"ACL2____THEORIES\">theories</see>) and the values to be stored in tables (see <see topic=\"ACL2____TABLE\">table</see>), are \u000A permitted to use the variable symbol <v>world</v> freely with the understanding \u000A that when these forms are evaluated that variable is bound to <v>(w state)</v>. \u000A Theoretically, this gives those forms complete knowledge of the current \u000A logical configuration of ACL2.  However, at the moment, few world scanning \u000A functions have been documented for the ACL2 user.  Instead, supposedly \u000A convenient macro forms have been created and documented.  For example, \u000A <v>(<see topic=\"ACL2____CURRENT-THEORY\">current-theory</see> :here)</v>, which is the theory expression which returns the \u000A currently <see topic=\"ACL2____ENABLE\">enable</see>d theory, actually macroexpands to \u000A <v>(current-theory-fn :here world)</v>.  When evaluated with <v>world</v> bound to \u000A <v>(w state)</v>, <v>current-theory-fn</v> scans the current ACL2 world and \u000A computes the set of <see topic=\"ACL2____RUNE\">rune</see>s currently <see topic=\"ACL2____ENABLE\">enable</see>d in it.</p>"],

 "ACL2____THEORIES":[["ACL2"],"ACL2 Sources","ACL2","<code>Example: '((:definition app) ; or (:d app)\u000A           (:executable-counterpart app)\u000A           (:i app)\u000A           rv\u000A           (rv)\u000A           assoc-of-app)</code> \u000A \u000A <p>See:</p> \u000A \u000A <p>A theory is a list of ``runic designators'' as described below.  Each runic \u000A designator denotes a set of ``runes'' (see <see topic=\"ACL2____RUNE\">rune</see>) and by unioning \u000A together the runes denoted by each member of a theory we define the set of \u000A runes corresponding to a theory.  Theories are used to control which rules are \u000A ``<see topic=\"ACL2____ENABLE\">enable</see>d,'' i.e., available for automatic application by the theorem \u000A prover.  There is always a ``current'' theory.  A rule is <see topic=\"ACL2____ENABLE\">enable</see>d \u000A precisely if its <see topic=\"ACL2____RUNE\">rune</see> is an element of the set of <see topic=\"ACL2____RUNE\">rune</see>s \u000A corresponding to the current theory.  At the top-level, the current theory is \u000A the theory selected by the most recent <tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt> event, extended with \u000A the rule names introduced since then.  Inside the theorem prover, the \u000A <v>:</v><tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt> hint (see <see topic=\"ACL2____HINTS\">hints</see>) can be used to select a \u000A particular theory as current during the proof attempt for a particular \u000A goal.</p> \u000A \u000A <p>Theories are generally constructed by ``theory expressions.''  Formally, a \u000A theory expression is any term, containing at most the single free variable \u000A <tt><see topic=\"ACL2____WORLD\">world</see></tt>, that when evaluated with <tt><see topic=\"ACL2____WORLD\">world</see></tt> bound to the current \u000A ACL2 world (see <see topic=\"ACL2____WORLD\">world</see>) produces a theory.  ACL2 provides various \u000A functions for the convenient construction and manipulation of theories.  These \u000A are called ``theory functions''(see <see topic=\"ACL2____THEORY-FUNCTIONS\">theory-functions</see>).  For example, \u000A the theory function <tt><see topic=\"ACL2____UNION-THEORIES\">union-theories</see></tt> takes two theories and produces \u000A their union.  The theory function <tt><see topic=\"ACL2____UNIVERSAL-THEORY\">universal-theory</see></tt> returns the theory \u000A containing all known rule names as of the introduction of a given logical \u000A name.  But a theory expression can contain constants, e.g.,</p> \u000A \u000A <code>'(<see topic=\"ACL2____LEN\">len</see> (<see topic=\"ACL2____LEN\">len</see>) (:rewrite car-cons) car-cdr-elim)</code> \u000A \u000A <p>and user-defined functions.  The only important criterion is that a theory \u000A expression mention no variable freely except <tt><see topic=\"ACL2____WORLD\">world</see></tt> and evaluate to a \u000A theory.</p> \u000A \u000A <p>More often than not, theory expressions typed by the user do not mention \u000A the variable <tt><see topic=\"ACL2____WORLD\">world</see></tt>.  This is because user-typed theory expressions are \u000A generally composed of applications of ACL2's theory functions.  These \u000A ``functions'' are actually macros that expand into terms in which <tt><see topic=\"ACL2____WORLD\">world</see></tt> is used freely and appropriately.  Thus, the technical definition of \u000A ``theory expression'' should not mislead you into thinking that interestng \u000A theory expressions must mention <tt><see topic=\"ACL2____WORLD\">world</see></tt>; they probably do and you just \u000A didn't know it!</p> \u000A \u000A <p>One aspect of this arrangement is that theory expressions cannot generally \u000A be evaluated at the top-level of ACL2, because <tt><see topic=\"ACL2____WORLD\">world</see></tt> is not bound.  To \u000A see the value of a theory expression, <v>expr</v>, at the top-level, type</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____LET\">LET</see> ((<see topic=\"ACL2____WORLD\">WORLD</see> (W STATE))) expr).</code> \u000A \u000A <p>However, because the built-in theories are quite long, you may be sorry you \u000A printed the value of a theory expression!</p> \u000A \u000A <p>A theory is a true list of runic designators and to each theory there \u000A corresponds a set of <see topic=\"ACL2____RUNE\">rune</see>s, obtained by unioning together the sets of \u000A <see topic=\"ACL2____RUNE\">rune</see>s denoted by each runic designator.  For example, the theory \u000A constant</p> \u000A \u000A <code>'(<see topic=\"ACL2____LEN\">len</see> (<see topic=\"ACL2____LEN\">len</see>) (:e nth) (:rewrite car-cons) car-cdr-elim)</code> \u000A \u000A <p>corresponds to the set of <see topic=\"ACL2____RUNE\">rune</see>s</p> \u000A \u000A <code>{(:definition len)\u000A (:induction len)\u000A (:executable-counterpart len)\u000A (:executable-counterpart nth)\u000A (:elim car-cdr-elim)\u000A (:rewrite car-cons)} .</code> \u000A \u000A <p>Observe that the theory contains five elements but its runic correspondent \u000A contains six.  That is because runic designators can denote sets of several \u000A <see topic=\"ACL2____RUNE\">rune</see>s, as is the case for the first designator, <v>len</v>.  If the above \u000A theory were selected as current then the six rules named in its runic \u000A counterpart would be <see topic=\"ACL2____ENABLE\">enable</see>d and all other rules would be <see topic=\"ACL2____DISABLE\">disable</see>d.</p> \u000A \u000A <p>We now precisely define the runic designators and the set of <see topic=\"ACL2____RUNE\">rune</see>s \u000A denoted by each.  When we refer below to the ``macro-aliases dereference of'' \u000A a symbol, <v>symb</v>, we mean the (function) symbol corresponding <v>symb</v> in \u000A the macro-aliases-table if there is such a symbol, else <v>symb</v> itself; see \u000A <see topic=\"ACL2____MACRO-ALIASES-TABLE\">macro-aliases-table</see>.  For example, the macro-aliases dereference of \u000A <tt><see topic=\"COMMON-LISP____APPEND\">append</see></tt> is <tt><see topic=\"ACL2____BINARY-APPEND\">binary-append</see></tt>, and the macro-aliases dereference of \u000A <tt><see topic=\"COMMON-LISP____NTH\">nth</see></tt> is <v>nth</v>.</p> \u000A \u000A <ul> \u000A \u000A <li>A <see topic=\"ACL2____RUNE\">rune</see> is a runic designator and denotes the singleton set \u000A containing that rune.</li> \u000A \u000A <li>Suppose that <v>symb</v> is a symbol and <v>symb'</v> is the macro-aliases \u000A dereference of <v>symb</v>, where <v>symb'</v> is a function symbol introduced \u000A with a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> (or <tt><see topic=\"ACL2____DEFUNS\">defuns</see></tt>) event.  Then <v>symb</v> is a runic \u000A designator and denotes the set containing the runes <tt>(:definition \u000A symb')</tt> and <tt>(:induction symb')</tt>, omitting the latter if no such \u000A <see topic=\"ACL2____INDUCTION\">induction</see> rune exists (presumably because the definition of <v>symb'</v> \u000A is not singly recursive).</li> \u000A \u000A <li>Suppose that <v>symb</v> is a symbol and <v>symb'</v> is the macro-aliases \u000A dereference of <v>symb</v>, where <v>symb'</v> is a function symbol introduced \u000A with a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> (or <tt><see topic=\"ACL2____DEFUNS\">defuns</see></tt>) event.  Then <v>(symb)</v> is a runic \u000A designator and denotes the singleton set containing the rune \u000A <tt>(:executable-counterpart symb')</tt>.</li> \u000A \u000A <li>If <v>symb</v> is the name of a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> (or <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt>) event \u000A that introduced at least one rule, then <v>symb</v> is a runic designator and \u000A denotes the set of the names of all rules introduced by the named event.</li> \u000A \u000A <li>If <v>str</v> is the string naming some <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> event and <v>symb</v> \u000A is the symbol returned by <v>(<see topic=\"COMMON-LISP____INTERN\">intern</see> str &quot;ACL2&quot;)</v>, then <v>symb</v> is a \u000A runic designator and denotes the singleton set containing <v>(:rewrite\u000A symb)</v>, which is the name of the rule stating the conditions under which the \u000A <tt><see topic=\"ACL2____SYMBOL-PACKAGE-NAME\">symbol-package-name</see></tt> of <v>(<see topic=\"COMMON-LISP____INTERN\">intern</see> x str)</v> is <v>str</v>.</li> \u000A \u000A <li>If <v>symb</v> is the name of a <tt><see topic=\"ACL2____DEFTHEORY\">deftheory</see></tt> event, then <v>symb</v> is \u000A a runic designator and denotes the runic theory corresponding to \u000A <v>symb</v>.</li> \u000A \u000A <li>Finally, suppose that <v>symb</v> is a symbol and <v>symb'</v> is the \u000A macro-aliases dereference of <v>symb</v>.  Then <v>(:KWD symb . rest)</v> is a \u000A runic designator, known as a ``runic abbreviation'', if <v>(:KWD' symb'\u000A . rest)</v> is a <see topic=\"ACL2____RUNE\">rune</see>, where: <v>:KWD</v> is one of <v>:d</v>, <v>:e</v>, \u000A <v>:i</v>, or <v>:t</v>; and <v>:KWD'</v> is <v>:definition</v>, \u000A <v>:executable-counterpart</v>, <v>:induction</v>, or <v>:type-prescription</v>, \u000A respectively.  In this case, <v>(:KWD symb . rest)</v> denotes the runic theory \u000A corresponding to the rune <v>(:KWD' symb' . rest)</v>.</li> \u000A \u000A </ul> \u000A \u000A <p>Note that including a function name, e.g., <tt><see topic=\"ACL2____LEN\">len</see></tt>, in the current \u000A theory <see topic=\"ACL2____ENABLE\">enable</see>s that function but does not <see topic=\"ACL2____ENABLE\">enable</see> the executable \u000A counterpart.  Similarly, including <v>(<see topic=\"ACL2____LEN\">len</see>)</v> or <v>(:e len)</v> <see topic=\"ACL2____ENABLE\">enable</see>s \u000A the executable counterpart but not the symbolic definition.  And including the \u000A name of a proved lemma <see topic=\"ACL2____ENABLE\">enable</see>s all of the rules added by the event.  Of \u000A course, one can include explicitly the <see topic=\"ACL2____RUNE\">rune</see>s naming the rules in \u000A question and so can avoid entirely the use of non-runic elements in \u000A theories.</p> \u000A \u000A <p>Because a <see topic=\"ACL2____RUNE\">rune</see> is a runic designator denoting the set containing \u000A that <see topic=\"ACL2____RUNE\">rune</see>, a list of <see topic=\"ACL2____RUNE\">rune</see>s is a theory and denotes itself.  We \u000A call such theories ``runic theories.''  To every theory there corresponds a \u000A runic theory obtained by unioning together the sets denoted by each designator \u000A in the theory.  When a theory is selected as ``current'' it is actually its \u000A runic correspondent that is effectively used.  That is, a <see topic=\"ACL2____RUNE\">rune</see> is <see topic=\"ACL2____ENABLE\">enable</see>d iff it is a member of the runic correspondent of the current theory. \u000A The value of a theory defined with <tt><see topic=\"ACL2____DEFTHEORY\">deftheory</see></tt> is the runic \u000A correspondent of the theory computed by the defining theory expression.  The \u000A theory manipulation functions, e.g., <tt><see topic=\"ACL2____UNION-THEORIES\">union-theories</see></tt>, actually convert \u000A their theory arguments to their runic correspondents before performing the \u000A required set operation.  The manipulation functions always return runic \u000A theories.  Thus, it is sometimes convenient to think of (non-runic) theories \u000A as merely abbreviations for their runic correspondents, abbreviations which \u000A are ``expanded'' at the first opportunity by theory manipulation functions and \u000A the ``theory consumer'' functions such as <tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt> and <tt><see topic=\"ACL2____DEFTHEORY\">deftheory</see></tt>.</p>"],

 "ACL2____TABLE":[["Events"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____TABLE\">table</see> tests 1 '(...))                ; set contents of tests[1] to '(...)\u000A(<see topic=\"ACL2____TABLE\">table</see> tests 25)                      ; get contents of tests[25]\u000A(<see topic=\"ACL2____TABLE\">table</see> tests)                         ; return table tests as an alist\u000A(<see topic=\"ACL2____TABLE\">table</see> tests nil nil :clear)          ; clear table tests\u000A(<see topic=\"ACL2____TABLE\">table</see> tests nil '((foo . 7)) :clear) ; set table tests to ((foo . 7))\u000A(<see topic=\"ACL2____TABLE\">table</see> tests nil nil :guard)          ; fetch the table guard\u000A(<see topic=\"ACL2____TABLE\">table</see> tests nil nil :guard term)     ; set the table guard\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____TABLE\">table</see> table-name key-term value-term op term)</code> \u000A \u000A <p>where <v>table-name</v> is a symbol that is the name of a (possibly new) \u000A table, <v>key-term</v> and <v>value-term</v>, if present, are arbitrary terms \u000A involving (at most) the single variable <tt><see topic=\"ACL2____WORLD\">world</see></tt>, <v>op</v>, if present, is \u000A one of the table operations below, and <v>term</v>, if present, is a term. \u000A <v>Table</v> returns an ACL2 ``error triple'' (see <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>).  The \u000A effect of <v>table</v> on <tt><see topic=\"ACL2____STATE\">state</see></tt> depends on <v>op</v> and how many \u000A arguments are presented.  Some invocations actually have no effect on the ACL2 \u000A <see topic=\"ACL2____WORLD\">world</see> and hence an invocation of <v>table</v> is not always an ``event''. \u000A We explain below, after giving some background information.</p> \u000A \u000A <p><b>Important Note:</b> The <v>table</v> forms above are calls of a macro that \u000A expand to involve the special variable <tt><see topic=\"ACL2____STATE\">state</see></tt>.  This will prevent you \u000A from accessing a table from within a hint or theory where you do not have the \u000A <tt><see topic=\"ACL2____STATE\">state</see></tt> variable.  However, the form</p> \u000A \u000A <code>(table-alist 'tests world)</code> \u000A \u000A <p>returns the alist representation of the table named <v>test</v> in the given \u000A world.  Often you have access to <v>world</v>.</p> \u000A \u000A <p>The ACL2 system provides ``tables'' by which the user can associate one \u000A object with another.  Tables are in essence just conventional association \u000A lists &mdash; lists of pairs &mdash; but the ACL2 environment provides a means \u000A of storing these lists in the ``ACL2 world'' of the current <tt><see topic=\"ACL2____STATE\">state</see></tt>. \u000A The ACL2 user could accomplish the same ends by using ACL2 ``global \u000A variables;'' however, limitations on global variable names are imposed to \u000A ensure ACL2's soundness.  By convention, no table is important to ACL2's \u000A soundness, even though some features of the system use tables, and the user is \u000A invited to make free use of tables.  Because tables are stored in the ACL2 \u000A <see topic=\"ACL2____WORLD\">world</see> they are restored by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> and undone by \u000A <v>:</v><tt><see topic=\"ACL2____UBT\">ubt</see></tt>.  Many users of Nqthm requested a facility by which user \u000A data could be saved in Nqthm ``lib files'' and tables are ACL2's answer to \u000A that request.</p> \u000A \u000A <p>Abstractly, each table is an association list mapping ``keys'' to \u000A ``values.'' In addition, each table has a ``<v>:guard</v>,'' which is a term \u000A that must be true of any key and value used.  By setting the <v>:guard</v> on a \u000A table you may enforce an invariant on the objects in the table, e.g., that all \u000A keys are positive integers and all values are symbols.  Each table has a \u000A ``name,'' which must be a symbol.  Given a table name, the following \u000A operations can be performed on the table.</p> \u000A \u000A <p><v>:put</v> &mdash; associate a value with a key (possibly changing the value \u000A currently associated with that key).</p> \u000A \u000A <p><v>:get</v> &mdash; retrieve the value associated with a key (or nil if no \u000A value has been associated with that key).</p> \u000A \u000A <p><v>:alist</v> &mdash; return an alist showing all keys and non-nil values in \u000A the table.</p> \u000A \u000A <p><v>:clear</v> &mdash; clear the table (so that every value is nil), or if val \u000A is supplied then set table to that value (which must be an alist).</p> \u000A \u000A <p><v>:guard</v> &mdash; fetch or set the :guard of the table.</p> \u000A \u000A <p>When the operations above suggest that the table or its <v>:guard</v> are \u000A modified, what is actually meant is that the current <see topic=\"ACL2____STATE\">state</see> is redefined \u000A so that in it, the affected table name has the appropriate properties.  in \u000A such cases, the <v>table</v> form is an event (see <see topic=\"ACL2____EVENTS\">events</see>).  In the \u000A <v>:put</v> case, if the key is already in the table and associated with the \u000A proposed value, then the <v>table</v> event is redundant (see <see topic=\"ACL2____REDUNDANT-EVENTS\">redundant-events</see>).</p> \u000A \u000A <p><v>Table</v> forms are commonly typed by the user while interacting with the \u000A system.  <v>:Put</v> and <v>:get</v> forms are especially common.  Therefore, we \u000A have adopted a positional syntax that is intended to be convenient for most \u000A applications.  Essentially, some operations admit a ``short form'' of \u000A invocation.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name key-term value-term :put)   ; long form\u000A(<see topic=\"ACL2____TABLE\">table</see> name key-term value-term)        ; short form</code> \u000A \u000A <p>evaluates the key- and value-terms, obtaining two objects that we call \u000A <v>key</v> and <v>value</v>, checks that the <v>key</v> and <v>value</v> satisfy the \u000A <v>:guard</v> on the named table and then ``modifies'' the named table so that \u000A the value associated with <v>key</v> is <v>value</v>.  When used like this, \u000A <v>table</v> is actually an event in the sense that it changes the ACL2 <see topic=\"ACL2____WORLD\">world</see>.  In general, the forms evaluated to obtain the <v>key</v> and <v>value</v> \u000A may involve the variable <tt><see topic=\"ACL2____WORLD\">world</see></tt>, which is bound to the then-current \u000A <see topic=\"ACL2____WORLD\">world</see> during the evaluation of the forms.  However, in the special case \u000A that the table in question is named <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt>, the <v>key</v> \u000A and <v>value</v> terms may not contain any variables.  Essentially, the keys and \u000A values used in <see topic=\"ACL2____EVENTS\">events</see> setting the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> must be \u000A explicitly given constants.  See <see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see>.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name key-term nil :get)          ; long form\u000A(<see topic=\"ACL2____TABLE\">table</see> name key-term)                   ; short form</code> \u000A \u000A <p>evaluates the key-term (see note below), obtaining an object, <v>key</v>, and \u000A returns the value associated with <v>key</v> in the named table (or, <v>nil</v> if \u000A there is no value associated with <v>key</v>).  When used like this, <v>table</v> \u000A is not an event; the value is simply returned.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name nil nil :alist)             ; long form\u000A(<see topic=\"ACL2____TABLE\">table</see> name)                            ; short form</code> \u000A \u000A <p>returns an alist representing the named table; for every key in the table \u000A with a non-<v>nil</v> associated value, the alist pairs the key and its value. \u000A The order in which the keys are presented is unspecified.  When used like \u000A this, <v>table</v> is not an event; the alist is simply returned.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name nil val :clear)</code> \u000A \u000A <p>sets the named table to the alist <v>val</v>, making the checks that \u000A <v>:put</v> makes for each key and value of <v>val</v>.  When used like this, \u000A <v>table</v> is an event because it changes the ACL2 <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name nil nil :guard)</code> \u000A \u000A <p>returns the translated form of the guard of the named table.</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> name nil nil :guard term)</code> \u000A \u000A <p>Provided the named table is empty and has not yet been assigned a \u000A <v>:guard</v> and <v>term</v> (which is not evaluated) is a term that mentions at \u000A most the variables <v>key</v>, <v>val</v> and <tt><see topic=\"ACL2____WORLD\">world</see></tt>, this event sets the \u000A <v>:guard</v> of the named table to <v>term</v>.  Whenever a subsequent <v>:put</v> \u000A occurs, <v>term</v> will be evaluated with <v>key</v> bound to the key argument of \u000A the <v>:put</v>, <v>val</v> bound to the <v>val</v> argument of the <v>:put</v>, and \u000A <tt><see topic=\"ACL2____WORLD\">world</see></tt> bound to the then current <see topic=\"ACL2____WORLD\">world</see>.  An error will be caused \u000A by the <v>:put</v> if the result of the evaluation is <v>nil</v>.</p> \u000A \u000A <p>Note that it is not allowed to change the <v>:guard</v> on a table once it \u000A has been explicitly set.  Before the <v>:guard</v> is explicitly set, it is \u000A effectively just <v>t</v>.  After it is set it can be changed only by undoing \u000A the event that set it.  The purpose of this restriction is to prevent the user \u000A from changing the <v>:guards</v> on tables provided by other people or the \u000A system.</p> \u000A \u000A <p>The intuition behind the <v>:guard</v> mechanism on tables is to enforce \u000A invariants on the keys and values in a table, so that the values, say, can be \u000A used without run-time checking.  But if the <v>:guard</v> of a table is \u000A sensitive to the ACL2 <see topic=\"ACL2____WORLD\">world</see>, it may be possible to cause some value in \u000A the table to cease satisfying the <v>:guard</v> without doing any operations on \u000A the table.  Consider for example the <v>:guard</v> ``no value in this table is \u000A the name of an event.'' As described, that is enforced each time a value is \u000A stored.  Thus, <v>'bang</v> can be <v>:put</v> in the table provided there is no \u000A event named <v>bang</v>.  But once it is in the table, there is nothing to \u000A prevent the user from defining <v>bang</v> as a function, causing the table to \u000A contain a value that could not be <v>:put</v> there anymore.  Observe that not \u000A all state-sensitive <v>:guard</v>s suffer this problem.  The <v>:guard</v> ``every \u000A value is an event name'' remains invariant, courtesy of the fact that undoing \u000A back through an event name in the table would necessarily undo the <v>:put</v> \u000A of the name into the table.</p> \u000A \u000A <p><v>Table</v> was designed primarily for convenient top-level use.  Tables are \u000A not especially efficient.  Each table is represented by an alist stored on the \u000A property list of the table name.  <v>:Get</v> is just a <v>getprop</v> and <tt><see topic=\"ACL2____ASSOC-EQUAL\">assoc-equal</see></tt>.  <v>:Put</v> does a <v>getprop</v> to the get the table alist, a \u000A <v>put-assoc-equal</v> to record the new association, and a <v>putprop</v> to \u000A store the new table alist &mdash; plus the overhead associated with \u000A <v>:guard</v>s and undoable <see topic=\"ACL2____EVENTS\">events</see>, and checking (for redundancy) if the \u000A key is already bound to its proposed value.  Note that there are never \u000A duplicate keys in the resulting <v>alist</v>; in particular, when the operation \u000A <v>:clear</v> is used to install new <v>alist</v>, duplicate keys are removed from \u000A that alist.</p> \u000A \u000A <p>A table name may be any symbol whatsoever.  Symbols already in use as \u000A function or theorem names, for example, may be used as table names.  Symbols \u000A in use only as table names may be defined with <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, etc.  Because \u000A there are no restrictions on the user's choice of table names, table names are \u000A not included among the logical names.  Thus, <v>:pe name</v> will never display \u000A a table event (for a logical name other than <v>:here</v>).  Either <v>:pe\u000A name</v> will display a ``normal'' event such as <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> name ...)</v> or \u000A <v>(<see topic=\"ACL2____DEFTHM\">defthm</see> name ...)</v> or else <v>:pe name</v> will cause an error indicating \u000A that <v>name</v> is not a logical name.  This happens even if <v>name</v> is in \u000A use as a table name.  Similarly, we do not permit table names to have <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> strings, since the same name might already have a <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> string.  If you want to associate a <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> string \u000A with a table name that is being used no other way, define the name as a label \u000A and use the <v>:</v><tt><see topic=\"ACL2____DOC\">doc</see></tt> feature of <tt><see topic=\"ACL2____DEFLABEL\">deflabel</see></tt> (see <see topic=\"ACL2____DEFLABEL\">deflabel</see>); also see <see topic=\"ACL2____DEFDOC\">defdoc</see>.</p>"],

 "ACL2____STOBJ":[["Programming"],"ACL2 Sources","ACL2","<p>In ACL2, a ``single-threaded object'' is a data structure whose use \u000A is so syntactically restricted that only one instance of the object need ever \u000A exist and its fields can be updated by destructive assignments.</p> \u000A \u000A <p>Note: Novices are advised to avoid using single-threaded objects, perhaps \u000A instead using <see topic=\"STD____DEFAGGREGATE\">std::defaggregate</see> or community book \u000A <v>books/data-structures/structures.lisp</v>.  At the least, consider using \u000A <v>(</v><tt><see topic=\"ACL2____SET-VERIFY-GUARDS-EAGERNESS\">set-verify-guards-eagerness</see></tt><v> 0)</v> to avoid <see topic=\"ACL2____GUARD\">guard</see> \u000A verification.</p> \u000A \u000A <p>The documentation in this section is laid out in the form of a tour that \u000A visits the documented topics in a reasonable order.  We recommend that you \u000A follow the tour the first time you read about stobjs.  The list of all stobj \u000A topics is shown below.  The tour starts immediately afterwards.  Also see \u000A <see topic=\"ACL2____DEFSTOBJ\">defstobj</see> and, for so-called abstract stobjs, see <see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see>.</p> \u000A \u000A <p>As noted, a ``single-threaded object'' is a data structure whose use is so \u000A syntactically restricted that only one instance of the object need ever exist. \u000A Updates to the object must be sequentialized.  This allows us to update its \u000A fields with destructive assignments without wrecking the axiomatic semantics \u000A of update-by-copy.  For this reason, single-threaded objects are sometimes \u000A called ``von Neumann bottlenecks.''</p> \u000A \u000A <p>From the logical perspective, a single-threaded object is an ordinary ACL2 \u000A object, e.g., composed of integers and conses.  Logically speaking, ordinary \u000A ACL2 functions are defined to allow the user to ``access'' and ``update'' its \u000A fields.  Logically speaking, when fields in the object, obj, are ``updated'' \u000A with new values, a new object, obj', is constructed.</p> \u000A \u000A <p>But suppose that by syntactic means we could ensure that there were no more \u000A references to the ``old'' object, obj.  Then we could create obj' by \u000A destructively modifying the memory locations involved in the representation of \u000A obj.  The syntactic means is pretty simple but draconian: the only reference \u000A to obj is in the variable named <v>OBJ</v>.</p> \u000A \u000A <p>The consequences of this simple rule are far-reaching and require some \u000A getting used to.  For example, if <v>OBJ</v> has been declared as a \u000A single-threaded object name, then the following consequences ensue (but see \u000A the discussion of congruent stobjs below for a slight relaxation).</p> \u000A \u000A <ul> \u000A \u000A <li><v>OBJ</v> is a top-level global variable that contains the current object, \u000A obj.</li> \u000A \u000A <li>If a function uses the formal parameter <v>OBJ</v>, the only ``actual \u000A expression'' that can be passed into that slot is the variable <v>OBJ</v>, not \u000A merely a term that ``evaluates to an obj''; thus, such functions can only \u000A operate on the current object.  So for example, instead of <v>(FOO\u000A (UPDATE-FIELD1 3 ST))</v> write <v>(<see topic=\"COMMON-LISP____LET\">LET</see> ((ST (UPDATE-FIELD1 3 ST))) (FOO\u000A ST))</v>.</li> \u000A \u000A <li>The accessors and updaters have a formal parameter named <v>OBJ</v>, so by \u000A the rule just above, those functions can only be applied to the current \u000A object.  The recognizer is the one exception to the rule: it may be applied \u000A either the <v>OBJ</v> or to an ordinary (non-stobj) object.</li> \u000A \u000A <li>The ACL2 primitives, such as <v>CONS</v>, <v>CAR</v> and <v>CDR</v>, may not be \u000A applied to the variable <v>OBJ</v>.  Thus, for example, obj may not be consed \u000A into a list (which would create another pointer to it) or accessed or copied \u000A via ``unapproved'' means.</li> \u000A \u000A <li>The updaters return a ``new <v>OBJ</v> object'', i.e., obj'; thus, when an \u000A updater is called, the only variable which can hold its result is \u000A <v>OBJ</v>.</li> \u000A \u000A <li>If a function calls an <v>OBJ</v> updater, it must return an <v>OBJ</v> \u000A object (either as the sole value returned, or in <v>(<see topic=\"ACL2____MV\">mv</see> ... OBJ ...)</v>; see \u000A <see topic=\"ACL2____MV\">mv</see>).</li> \u000A \u000A <li>When a top-level expression involving <v>OBJ</v> returns an <v>OBJ</v> \u000A object, that object becomes the new current value of <v>OBJ</v>.</li> \u000A \u000A </ul> \u000A \u000A <p>There are other functional languages supporting single-threadedness, for \u000A example Haskell's ``monads'' and Clean's ``uniqueness type system''.  Of \u000A course, ACL2 provides a theorem prover that can prove theorems that involve \u000A such constructs.</p> \u000A \u000A <p>Note that the syntactic restrictions noted above are enforced only when \u000A single-threaded objects are encountered directly in the top-level loop or are \u000A used in function definitions; the accessor and update functions for \u000A single-threaded objects may be used without restriction in formulas to be \u000A proved.  Since function evaluation is sometimes necessary during proofs, ACL2 \u000A must be able to evaluate these functions on logical constants representing the \u000A object, even when the constant is not ``the current object.''  Thus, ACL2 \u000A supports both the efficient von Neumann semantics and the clean applicative \u000A semantics, and uses the first in contexts where execution speed is paramount \u000A and the second during proofs.</p> \u000A \u000A <p><tt><see topic=\"ACL2____DEFSTOBJ\">Defstobj</see></tt> and <tt><see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see></tt> <see topic=\"ACL2____EVENTS\">events</see> introduce stobjs. \u000A See <see topic=\"ACL2____DEFSTOBJ\">defstobj</see> for more details about stobjs.  In particular, a \u000A relatively advanced notion of ``congruent stobjs'' is discussed there.  The \u000A idea is to allow a stobj, <v>st2</v>, of the same ``shape'' as a given stobj, \u000A <v>st1</v>, to be used in place of <v>st1</v>.  Other <tt><see topic=\"ACL2____DEFSTOBJ\">defstobj</see></tt> keywords \u000A allow inlining and renaming of stobj accessors and updaters.</p> \u000A \u000A <p>But we are getting ahead of ourselves.  To start the stobj tour, see <see topic=\"ACL2____STOBJ-EXAMPLE-1\">stobj-example-1</see>.</p>"],

 "ACL2____STATE":[["Programming"],"ACL2 Sources","ACL2","<p>Note: If you are interested in programming with state, see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see> after reading the information below.</p> \u000A \u000A <p>The ACL2 state object is used extensively in programming the ACL2 system, \u000A and has been used in other ACL2 programs as well.  However, most users, \u000A especially those interested in specification and verification (as opposed to \u000A programming <i>per se</i>), need not be aware of the role of the state object \u000A in ACL2, and will not write functions that use it explicitly.  We say more \u000A about this point at the end of this documentation topic.</p> \u000A \u000A <p>The ACL2 state object is an example of a single-threaded object or <see topic=\"ACL2____STOBJ\">stobj</see>.  ACL2 allows the user to define new single-threaded objects. \u000A Generally, ACL2 may need to access the ACL2 state but should not (cannot) \u000A change it except via a certain set of approved functions such as <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> \u000A and <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>.  If you need a state-like object to which you have \u000A complete rights, you may want a <see topic=\"ACL2____STOBJ\">stobj</see>.</p> \u000A \u000A <p>Key to the idea of our <v>state</v> is the notion of single-threadedness. \u000A For an explanation, see <see topic=\"ACL2____STOBJ\">stobj</see>.  The upshot of it is that <v>state</v> is \u000A a variable symbol with severe restrictions on its use, so that it can be \u000A passed into only certain functions in certain slots, and must be returned by \u000A those functions that ``modify'' it.  Henceforth, we do not discuss \u000A single-threaded objects in general (which the user can introduce with <tt><see topic=\"ACL2____DEFSTOBJ\">defstobj</see></tt> and <tt><see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see></tt>) but one in particular, namely ACL2's \u000A <v>state</v> object.</p> \u000A \u000A <p>The <i>global table</i> is perhaps the most visible portion of the state \u000A object.  Using the interface functions <v>@</v> and <v>assign</v>, a user may bind \u000A global variables to the results of function evaluations (much as an Nqthm user \u000A exploits the Nqthm utility <v>r-loop</v>).  See <see topic=\"ACL2_____04\">@</see>, and see <see topic=\"ACL2____ASSIGN\">assign</see>. \u000A A particularly interesting global is <v>'current-acl2-world</v>, whose value is \u000A the ACL2 logical <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <p>ACL2 supports several facilities of a truly von Neumannesque state machine \u000A character, including file <see topic=\"ACL2____IO\">io</see> and global variables.  Logically speaking, \u000A the state is a true list of the 14 components described below.  There is a \u000A ``current'' state object at the top-level of the ACL2 <see topic=\"ACL2____COMMAND\">command</see> loop. \u000A This object is understood to be the value of what would otherwise be the free \u000A variable <v>state</v> appearing in top-level input.  When any <see topic=\"ACL2____COMMAND\">command</see> \u000A returns a state object as one of its values, that object becomes the new \u000A current state.  But ACL2 provides von Neumann style speed for state operations \u000A by maintaining only one physical (as opposed to logical) state object. \u000A Operations on the state are in fact destructive.  This implementation does not \u000A violate the applicative semantics because we enforce certain draconian \u000A syntactic rules regarding the use of state objects.  For example, one cannot \u000A ``hold on'' to an old state, access the components of a state arbitrarily, or \u000A ``modify'' a state object without passing it on to subsequent state-sensitive \u000A functions.</p> \u000A \u000A <p>Every routine that uses the state facilities (e.g. does <see topic=\"ACL2____IO\">io</see>, or calls \u000A a routine that does <see topic=\"ACL2____IO\">io</see>), must be passed a ``state object.'' And a \u000A routine must return a state object if the routine modifies the state in any \u000A way.  Rigid syntactic rules governing the use of state objects are enforced by \u000A the function <v>translate</v>, through which all ACL2 user input first passes. \u000A State objects can only be ``held'' in the formal parameter <v>state</v>, never \u000A in any other formal parameter and never in any structure (excepting a \u000A multiple-value return list field which is always a state object).  State \u000A objects can only be accessed with the primitives we specifically permit. \u000A Thus, for example, one cannot ask, in code to be executed, for the length of \u000A <v>state</v> or the <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> of <v>state</v>.  In the statement and proof of \u000A theorems, there are no syntactic rules prohibiting arbitrary treatment of \u000A state objects.</p> \u000A \u000A <p>Logically speaking, a state object is a true list whose members are as \u000A follows:</p> \u000A \u000A <blockquote> \u000A \u000A <p><v>Open-input-channels</v>, an alist with keys that are symbols in package \u000A <v>&quot;ACL2-INPUT-CHANNEL&quot;</v>.  The value (<tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>) of each pair has the \u000A form <v>((:header type file-name open-time) . elements)</v>, where <v>type</v> is \u000A one of <v>:character</v>, <v>:byte</v>, or <v>:object</v> and <v>elements</v> is a \u000A list of things of the corresponding <v>type</v>, i.e. characters, integers of \u000A type <v>(<see topic=\"COMMON-LISP____MOD\">mod</see> 255)</v>, or lisp objects in our theory.  <v>File-name</v> is a \u000A string.  <v>Open-time</v> is an integer.  See <see topic=\"ACL2____IO\">io</see>.</p> \u000A \u000A <p><v>Open-output-channels</v>, an alist with keys that are symbols in package \u000A <v>&quot;ACL2-OUTPUT-CHANNEL&quot;</v>.  The value of a pair has the form <v>((:header\u000A type file-name open-time) .  current-contents)</v>.  See <see topic=\"ACL2____IO\">io</see>.</p> \u000A \u000A <p><v>Global-table</v>, an alist associating symbols (to be used as ``global \u000A variables'') with values.  See <see topic=\"ACL2_____04\">@</see>, and see <see topic=\"ACL2____ASSIGN\">assign</see>.</p> \u000A \u000A <p><v>T-stack</v>, a list of arbitrary objects accessed and changed by the \u000A functions <v>aref-t-stack</v> and <v>aset-t-stack</v>.</p> \u000A \u000A <p><v>32-bit-integer-stack</v>, a list of arbitrary 32-bit-integers accessed and \u000A changed by the functions <v>aref-32-bit-integer-stack</v> and \u000A <v>aset-32-bit-integer-stack</v>.</p> \u000A \u000A <p><v>Big-clock-entry</v>, an integer, that is used logically to bound the \u000A amount of effort spent to evaluate a quoted form.</p> \u000A \u000A <p><v>Idates</v>, a list of dates and times, used to implement the function \u000A <v>print-current-idate</v>, which prints the date and time.</p> \u000A \u000A <p><v>Acl2-oracle</v>, a list of objects, used for example to implement the \u000A functions that let ACL2 report how much time was used, but inaccessible to the \u000A user.  See <tt><see topic=\"ACL2____READ-ACL2-ORACLE\">read-ACL2-oracle</see></tt> and also see <tt><see topic=\"ACL2____WITH-PROVER-TIME-LIMIT\">with-prover-time-limit</see></tt>.</p> \u000A \u000A <p><v>File-clock</v>, an integer that is increased on every file opening and \u000A closing, and is used to maintain the consistency of the <tt><see topic=\"ACL2____IO\">io</see></tt> \u000A primitives.</p> \u000A \u000A <p><v>Readable-files</v>, an alist whose keys have the form <v>(<see topic=\"COMMON-LISP____STRING\">string</see> type\u000A time)</v>, where <tt><see topic=\"COMMON-LISP____STRING\">string</see></tt> is a file name and <v>time</v> is an integer.  The \u000A value associated with such a key is a list of characters, bytes, or objects, \u000A according to <v>type</v>.  The <v>time</v> field is used in the following way: \u000A when it comes time to open a file for input, we will only look for a file of \u000A the specified name and <v>type</v> whose time field is that of <v>file-clock</v>. \u000A This permits us to have a ``probe-file'' aspect to <v>open-file</v>: one can ask \u000A for a file, find it does not exist, but come back later and find that it does \u000A now exist.</p> \u000A \u000A <p><v>Written-files</v>, an alist whose keys have the form <v>(<see topic=\"COMMON-LISP____STRING\">string</see> type time1\u000A time2)</v>, where <tt><see topic=\"COMMON-LISP____STRING\">string</see></tt> is a file name, <v>type</v> is one of \u000A <v>:character</v>, <v>:byte</v> or <v>:object</v>, and <v>time1</v> and <v>time2</v> are \u000A integers.  <v>Time1</v> and <v>time2</v> correspond to the <v>file-clock</v> time at \u000A which the channel for the file was opened and closed.  This field is \u000A write-only; the only operation that affects this field is \u000A <v>close-output-channel</v>, which <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt>es a new entry on the front.</p> \u000A \u000A <p><v>Read-files</v>, a list of the form <v>(<see topic=\"COMMON-LISP____STRING\">string</see> type time1 time2)</v>, where \u000A <tt><see topic=\"COMMON-LISP____STRING\">string</see></tt> is a file name and <v>time1</v> and <v>time2</v> were the times at \u000A which the file was opened for reading and closed.  This field is write \u000A only.</p> \u000A \u000A <p><v>Writeable-files</v>, an alist whose keys have the form <v>(<see topic=\"COMMON-LISP____STRING\">string</see> type\u000A time)</v>.  To open a file for output, we require that the name, type, and time \u000A be on this list.</p> \u000A \u000A <p><v>List-all-package-names-lst</v>, a list of <v>true-listps</v>.  Roughly \u000A speaking, the <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> of this list is the list of all package names known \u000A to this Common Lisp right now and the <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt> of this list is the value of \u000A this <v>state</v> variable after you look at its <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt>.  The function, \u000A <v>list-all-package-names</v>, which takes the state as an argument, returns the \u000A <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> and <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>s the list (returning a new state too).  This \u000A essentially gives ACL2 access to what is provided by CLTL's \u000A <v>list-all-packages</v>.  <tt><see topic=\"ACL2____DEFPKG\">Defpkg</see></tt> uses this feature to ensure that the \u000A about-to-be-created package is new in this lisp.  Thus, for example, in \u000A <v>akcl</v> it is impossible to create the package <v>&quot;COMPILER&quot;</v> with <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> because it is on the list, while in Lucid that package name is not \u000A initially on the list.</p> \u000A \u000A <p><v>User-stobj-alist</v>, an alist which associates user-defined \u000A single-threaded objects (see <see topic=\"ACL2____STOBJ\">stobj</see>) with their values.</p></blockquote> \u000A \u000A <p>We recommend avoiding the use of the state object when writing ACL2 code \u000A intended to be used as a formal model of some system, for several reasons. \u000A First, the state object is complicated and contains many components that are \u000A oriented toward implementation and are likely to be irrelevant to the model in \u000A question.  Second, there is currently not much support for reasoning about \u000A ACL2 functions that manipulate the state object, beyond their logical \u000A definitions.  Third, the documentation about state is not as complete as one \u000A might wish.</p> \u000A \u000A <p>User-defined single-threaded objects offer the speed of <v>state</v> while \u000A giving the user complete access to all the fields.  See <see topic=\"ACL2____STOBJ\">stobj</see>.</p> \u000A \u000A <p>Again, if you are interested in programming with state see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see>.</p>"],

 "ACL2____RUNE":[["Theories"],"ACL2 Sources","ACL2","<code>Examples:\u000A(:rewrite assoc-of-app)\u000A(:linear delta-aref . 2)\u000A(:definition length)\u000A(:executable-counterpart length)</code> \u000A \u000A <p>Note: This topic discusses a basic notion of ``rule name'', or ``rune'' for \u000A short.  Users often use abbrevitions for runes; for example, a <see topic=\"ACL2____THEORY\">theory</see> \u000A expression <v>(<see topic=\"ACL2____DISABLE\">DISABLE</see> APPEND)</v> abbreviates the following set of runes: \u000A <v>{(:DEFINITION BINARY-APPEND), (:INDUCTION BINARY-APPEND)}</v>.  See <see topic=\"ACL2____THEORIES\">theories</see> for a discussion of so-called ``runic designators'', which include \u000A expressions like <v>APPEND</v> (as above) as well as <v>(<see topic=\"COMMON-LISP____APPEND\">APPEND</see>)</v> (for the \u000A executable-counterpart of <v>BINARY-APPEND</v>.  Runic designators can also be \u000A ``runic abbreviations'' such as <v>(:d APPEND)</v>, <v>(:e APPEND)</v>, <v>(:i\u000A APPEND)</v>, and <v>(:t APPEND)</v>, which designate the definition, \u000A executable-counterpart, induction, and type-prescription rules for \u000A <v>BINARY-APPEND</v>.  For a complete description of runic designators, see \u000A <see topic=\"ACL2____THEORIES\">theories</see>; we return now to the more basic notion of a rune.</p> \u000A \u000A <p>Background: The theorem prover is driven from a database of rules.  The \u000A most common rules are <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules, which cause the simplifier \u000A to replace one term with another.  <see topic=\"ACL2____EVENTS\">Events</see> introduce rules into the \u000A database.  For example, a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> event may introduce runes for \u000A symbolically replacing a function call by its instantiated body, for \u000A evaluating the function on constants, for determining the type of a call of \u000A the function, and for the induction scheme introduced upon defining the \u000A function.  <tt><see topic=\"ACL2____DEFTHM\">Defthm</see></tt> may introduce several rules, one for each of the \u000A <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> specified (where one rule class is specified if \u000A <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> is omitted, namely, <v>:rewrite</v>).</p> \u000A \u000A <p>Every rule in the system has a name.  Each name is a structured object \u000A called a ``rune,'' which is short for ``rule name''.  Runes are always of the \u000A form <v>(:token symbol . x)</v>, where <v>:token</v> is some keyword symbol \u000A indicating what kind of rule is named, <v>symbol</v> is the event name that \u000A created the rule (and is called the ``base symbol'' of the rune), and <v>x</v> \u000A is either <v>nil</v> or a natural number that makes the rule name distinct from \u000A that of rules generated by other <see topic=\"ACL2____EVENTS\">events</see> or by other <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> within the same event.</p> \u000A \u000A <p>For example, an event of the form</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> name thm\u000A  :rule-classes ((:REWRITE :COROLLARY term1)\u000A                 (:REWRITE :COROLLARY term2)\u000A                 (:ELIM    :COROLLARY term3)))</code> \u000A \u000A <p>typically creates three rules, each with a unique rune.  The runes are</p> \u000A \u000A <code>(:REWRITE name . 1), (:REWRITE name . 2), and (:ELIM name).</code> \u000A \u000A <p>However, a given formula may create more than one rule, and all rules \u000A generated by the same <v>:corollary</v> formula will share the same rune. \u000A Consider the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> my-thm\u000A  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar x)) x)\u000A       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo x)) x)))</code> \u000A \u000A <p>This is treated identically to the following.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> my-thm\u000A  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar x)) x)\u000A       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo x)) x))\u000A  :rule-classes ((:rewrite\u000A                  :corollary\u000A                  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar x)) x)\u000A                       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo x)) x)))))</code> \u000A \u000A <p>In either case, two rules are created: one rewriting <v>(foo (bar x))</v> to \u000A <v>x</v>, and one rewriting <v>(bar (foo x))</v> to <v>x</v>.  However, only a \u000A single rune is created, <v>(:REWRITE MY-THM)</v>, because there is only one rule \u000A class.  But now consider the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> my-thm2\u000A  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar x)) x)\u000A       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo x)) x))\u000A  :rule-classes ((:rewrite\u000A                  :corollary\u000A                  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar x)) x)\u000A                       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo x)) x)))\u000A                 (:rewrite\u000A                  :corollary\u000A                  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (foo (bar (foo x))) (foo x))\u000A                       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar (foo (bar x))) (bar x))))))</code> \u000A \u000A <p>This time there are four rules created.  The first two rules are as before, \u000A and are assigned the rune <v>(:REWRITE MY-THM . 1)</v>.  The other two rules are \u000A similarly generated for the second <v>:corollary</v>, and are assigned the rune \u000A <v>(:REWRITE MY-THM . 2)</v>.</p> \u000A \u000A <p>The function <tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> will return the <see topic=\"ACL2____COROLLARY\">corollary</see> term \u000A associated with a given rune in a given <see topic=\"ACL2____WORLD\">world</see>.  Example:</p> \u000A \u000A <code>(<see topic=\"ACL2____COROLLARY\">corollary</see> '(:TYPE-PRESCRIPTION DIGIT-TO-CHAR) (w state))</code> \u000A \u000A <p>However, the preferred way to see the corollary term associated with a rune \u000A or a name is to use <v>:pf</v>; see <see topic=\"ACL2____PF\">pf</see>.</p> \u000A \u000A <p>The <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> event creates as many as four rules.  <v>(:definition\u000A fn)</v> is the rune given to the equality axiom defining the function, <v>fn</v>. \u000A <v>(:executable-counterpart fn)</v> is the rune given to the rule for computing \u000A <v>fn</v> on known arguments.  A type prescription rule may be created under the \u000A name <v>(:type-prescription fn)</v>, and an <see topic=\"ACL2____INDUCTION\">induction</see> rule may be created \u000A under the name <v>(:induction fn)</v>.</p> \u000A \u000A <p>Runes may be individually <see topic=\"ACL2____ENABLE\">enable</see>d and <see topic=\"ACL2____DISABLE\">disable</see>d, according to \u000A whether they are included in the current theory.  See <see topic=\"ACL2____THEORIES\">theories</see>.  Thus, \u000A it is permitted to <see topic=\"ACL2____DISABLE\">disable</see> <v>(:elim name)</v>, say, while enabling the \u000A other rules derived from name.  Similarly, <v>(:definition fn)</v> may be <see topic=\"ACL2____DISABLE\">disable</see>d while <v>(:executable-counterpart fn)</v> and the type prescriptions \u000A for <v>fn</v> are <see topic=\"ACL2____ENABLE\">enable</see>d.</p> \u000A \u000A <p>Associated with most runes is the formula justifying the rule named.  This \u000A is called the ``<see topic=\"ACL2____COROLLARY\">corollary</see> formula'' of the rune and may be obtained via \u000A the function <tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt>, which takes as its argument a rune and a \u000A property list <see topic=\"ACL2____WORLD\">world</see>.  Also see <see topic=\"ACL2____PF\">pf</see>.  The <see topic=\"ACL2____COROLLARY\">corollary</see> formula \u000A for <v>(:rewrite name . 1)</v> after the <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event above is \u000A <v>term1</v>.  The corollary formulas for <v>(:definition fn)</v> and \u000A <v>(:executable-counterpart fn)</v> are always identical: the defining axiom. \u000A Some runes, e.g., <v>(:definition car)</v>, do not have corollary formulas. \u000A <tt><see topic=\"ACL2____COROLLARY\">Corollary</see></tt> returns <v>nil</v> on such runes.  In any case, the corollary \u000A formula of a rune, when it is non-<v>nil</v>, is a theorem and may be used in \u000A the <v>:use</v> and <v>:by</v> <see topic=\"ACL2____HINTS\">hints</see>.</p> \u000A \u000A <p>Note: The system has built-in rules that, for regularity, ought to have \u000A names but don't because they can never be <see topic=\"ACL2____DISABLE\">disable</see>d.  One such rule is \u000A that implemented by the <see topic=\"ACL2____LINEAR\">linear</see> arithmetic package.  Because many of our \u000A subroutines are required by their calling conventions to return the justifying \u000A rune, we have invented the notion of ``fake runes.''  Fake runes always have \u000A the base symbol <v>nil</v>, use a keyword token that includes the phrase \u000A ``fake-rune'', and are always <see topic=\"ACL2____ENABLE\">enable</see>d.  Here is the list of fake \u000A runes.</p> \u000A \u000A <p><code>((:fake-rune-for-linear nil)\u000A (:fake-rune-for-type-set nil))</code></p> \u000A \u000A <p>Occasionally the system will print a fake rune where a rune is expected. \u000A For example, when <v>(:FAKE-RUNE-FOR-LINEAR NIL)</v> is reported among the rules \u000A used in a proof, it is an indication that the linear arithmetic package was \u000A used.  However, fake runes are not allowed in <see topic=\"ACL2____THEORIES\">theories</see>, they cannot be \u000A <see topic=\"ACL2____ENABLE\">enable</see>d or <see topic=\"ACL2____DISABLE\">disable</see>d, and they do not have associated <see topic=\"ACL2____COROLLARY\">corollary</see> formulas.  In short, despite the fact that the user may sometimes \u000A see fake runes printed, they should never be typed.</p>"],

 "ACL2____RULE-CLASSES":[["ACL2"],"ACL2 Sources","ACL2","<code>Example Form (from community book finite-set-theory/total-ordering.lisp):\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> &lt;&lt;-trichotomy\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (ordinaryp x)\u000A                (ordinaryp y))\u000A           (<see topic=\"COMMON-LISP____OR\">or</see> (&lt;&lt; x y)\u000A               (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x y)\u000A               (&lt;&lt; y x)))\u000A  :rule-classes\u000A  ((:rewrite :corollary\u000A             (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (ordinaryp x)\u000A                           (ordinaryp y)\u000A                           (<see topic=\"COMMON-LISP____NOT\">not</see> (&lt;&lt; x y))\u000A                           (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x y)))\u000A                      (&lt;&lt; y x)))))\u000A\u000AGeneral Form:\u000Aa true list of rule class objects as defined below\u000A\u000ASpecial Cases:\u000Aa symbol abbreviating a single rule class object</code> \u000A \u000A <p>When <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> is used to prove a named theorem, rules may be derived \u000A from the proved formula and stored in the database.  The user specifies which \u000A kinds of rules are to be built, by providing a list of rule class <i>names</i> \u000A or, more generally, rule class <i>objects</i>, which name the kind of rule to \u000A build and optionally specify various attributes of the desired rule.  The rule \u000A class names are <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, <v>:</v><tt><see topic=\"ACL2____BUILT-IN-CLAUSE\">built-in-clause</see></tt>, \u000A <v>:</v><tt><see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see></tt>, <v>:</v><tt><see topic=\"ACL2____COMPOUND-RECOGNIZER\">compound-recognizer</see></tt>, \u000A <v>:</v><tt><see topic=\"ACL2____CONGRUENCE\">congruence</see></tt>, <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt>, <v>:</v><tt><see topic=\"ACL2____ELIM\">elim</see></tt>, \u000A <v>:</v><tt><see topic=\"ACL2____EQUIVALENCE\">equivalence</see></tt>, <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt>, <v>:</v><tt><see topic=\"ACL2____GENERALIZE\">generalize</see></tt>, <v>:</v><tt><see topic=\"ACL2____INDUCTION\">induction</see></tt>, <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>, <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt>, <v>:</v><tt><see topic=\"ACL2____REFINEMENT\">refinement</see></tt>, <v>:</v><tt><see topic=\"ACL2____TAU-SYSTEM\">tau-system</see></tt>, <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt>, <v>:</v><tt><see topic=\"ACL2____TYPE-SET-INVERTER\">type-set-inverter</see></tt>, and <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt>.  Some classes <i>require</i> the user-specification of \u000A certain class-specific attributes.  Each class of rule affects the theorem \u000A prover's behavior in a different way, as discussed in the corresponding \u000A documentation topic.  In this topic we discuss the various attributes that may \u000A be attached to rule classes.</p> \u000A \u000A <p>Note that not all <see topic=\"ACL2____EVENTS\">events</see> generate rules.  For example, a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event that specifies <v>:rule-classes nil</v> does not generate a rule. \u000A Similarly, a <tt><see topic=\"ACL2____DEFCHOOSE\">defchoose</see></tt> event generates an axiom that can be referenced \u000A by name in <v>:use</v> <see topic=\"ACL2____HINTS\">hints</see>, but it does not generate a rule.</p> \u000A \u000A <p>A rule class object is either one of the <v>:class</v> keywords or else is a \u000A list of the form shown below.  Those fields marked with ``(!)''  are required \u000A when the <v>:class</v> is as indicated.</p> \u000A \u000A <code>(:class\u000A  :COROLLARY term\u000A  :TRIGGER-FNS (fn1 ... fnk) ; provided :class = :META (!)\u000A  :TRIGGER-TERMS (t1 ... tk) ; provided :class = :FORWARD-CHAINING\u000A                             ;       or :class = :LINEAR\u000A  :TYPE-SET n                ; provided :class = :TYPE-SET-INVERTER\u000A  :TYPED-TERM term           ; provided :class = :TYPE-PRESCRIPTION\u000A  :CLIQUE (fn1 ... fnk)      ; provided :class = :DEFINITION\u000A  :CONTROLLER-ALIST alist    ; provided :class = :DEFINITION\u000A  :INSTALL-BODY directive    ; provided :class = :DEFINITION\u000A  :LOOP-STOPPER alist        ; provided :class = :REWRITE\u000A  :PATTERN term              ; provided :class = :INDUCTION (!)\u000A  :CONDITION term            ; provided :class = :INDUCTION\u000A  :SCHEME term               ; provided :class = :INDUCTION (!)\u000A  :MATCH-FREE all-or-once    ; provided :class = :REWRITE\u000A                                     or :class = :LINEAR\u000A                                     or :class = :FORWARD-CHAINING\u000A  :BACKCHAIN-LIMIT-LST limit ; provided :class = :REWRITE\u000A                                     or :class = :META\u000A                                     or :class = :LINEAR\u000A                                     or :class = :TYPE-PRESCRIPTION\u000A  :HINTS hints               ; provided instrs = nil\u000A  :INSTRUCTIONS instrs       ; provided  hints = nil\u000A  :OTF-FLG flg)</code> \u000A \u000A <p>When rule class objects are provided by the user, most of the fields are \u000A optional and their values are computed in a context sensitive way.  When a \u000A <v>:class</v> keyword is used as a rule class object, all relevant fields are \u000A determined contextually.  Each rule class object in <v>:rule-classes</v> causes \u000A one or more rules to be added to the database.  The <v>:class</v> keywords are \u000A documented individually under the following names.  Note that when one of \u000A these names is used as a <v>:class</v>, it is expected to be in the keyword \u000A package (i.e., the names below should be preceded by a colon but the ACL2 \u000A <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> facilities do not permit us to use keywords below).</p> \u000A \u000A <p>See also <tt><see topic=\"ACL2____FORCE\">force</see></tt>, <see topic=\"ACL2____CASE-SPLIT\">case-split</see>, <tt><see topic=\"ACL2____SYNTAXP\">syntaxp</see></tt>, and <tt><see topic=\"ACL2____BIND-FREE\">bind-free</see></tt> for ``pragmas'' one can wrap around individual hypotheses of \u000A certain classes of rules to affect how the hypothesis is relieved.</p> \u000A \u000A <p>Before we get into the discussion of rule classes, let us return to an \u000A important point.  In spite of the large variety of rule classes available, at \u000A present we recommend that new ACL2 users rely almost exclusively on \u000A (conditional) rewrite rules.  A reasonable but slightly bolder approach is to \u000A use <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt> and <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt> rules \u000A for ``type-theoretic'' rules, especially ones whose top-level function symbol \u000A is a common one like <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt> or <tt><see topic=\"COMMON-LISP____CONSP\">consp</see></tt>; see <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> and see <see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see>.  However, the rest of the \u000A rule classes are really not intended for widespread use, but rather are mainly \u000A for experts.</p> \u000A \u000A <p>We expect that we will write more about the question of which kind of rule \u000A to use.  For now: when in doubt, use a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule.</p> \u000A \u000A <p><v>:Rule-classes</v> is an optional keyword argument of the <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> \u000A (and <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt>) event.  In the following, let <v>name</v> be the name of \u000A the event and let <v>thm</v> be the formula to be proved or added as an \u000A axiom.</p> \u000A \u000A <p>If <v>:rule-classes</v> is not specified in a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> (or <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt>) event, it is as though what was specified was to make one or more \u000A <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules, i.e., as though <v>:rule-classes</v> \u000A <v>((:rewrite))</v> had been used.  Use <v>:rule-classes</v> <v>nil</v> to specify \u000A that no rules are to be generated.</p> \u000A \u000A <p>If <v>:rule-classes</v> class is specified, where class is a non-<v>nil</v> \u000A symbol, it is as though <v>:rule-classes</v> <v>((class))</v> had been used. \u000A Thus, <v>:rule-classes</v> <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt> is equivalent to \u000A <v>:rule-classes</v> <v>((:forward-chaining))</v>.</p> \u000A \u000A <p>We therefore now consider <v>:rule-classes</v> as a true list.  If any \u000A element of that list is a keyword, replace it by the singleton list containing \u000A that keyword.  Thus, <v>:rule-classes</v> <v>(:rewrite :elim)</v> is the same as \u000A <v>:rule-classes</v> <v>((:rewrite) (:elim))</v>.</p> \u000A \u000A <p>Each element of the expanded value of <v>:rule-classes</v> must be a true \u000A list whose <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is one of the rule class keyword tokens listed above, \u000A e.g., <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, <v>:</v><tt><see topic=\"ACL2____ELIM\">elim</see></tt>, etc., and whose <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt> \u000A is a ``keyword alist'' alternately listing keywords and values.  The keywords \u000A in this alist must be taken from those shown below.  They may be listed in any \u000A order and most may be omitted, as specified below.</p> \u000A \u000A <blockquote> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____COROLLARY\">Corollary</see></tt> &mdash; its value, <v>term</v>, must be a term.  If \u000A omitted, this field defaults to <v>thm</v>.  The <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> of a \u000A rule class object is the formula actually used to justify the rule created and \u000A thus determines the form of the rule.  Nqthm provided no similar capability: \u000A each rule was determined by <v>thm</v>, the theorem or axiom added.  ACL2 \u000A permits <v>thm</v> to be stated ``elegantly'' and then allows the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> of a rule class object to specify how that elegant statement is to \u000A be interpreted as a rule.  For the rule class object to be well-formed, its \u000A (defaulted) <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt>, <v>term</v>, must follow from <v>thm</v>. \u000A Unless <v>term</v> follows trivially from <v>thm</v> using little more than \u000A propositional logic, the formula <v>(<see topic=\"ACL2____IMPLIES\">implies</see> thm term)</v> is submitted to the \u000A theorem prover and the proof attempt must be successful.  During that proof \u000A attempt the values of <v>:</v><tt><see topic=\"ACL2____HINTS\">hints</see></tt>, <v>:</v><tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt>, and \u000A <v>:</v><tt><see topic=\"ACL2____OTF-FLG\">otf-flg</see></tt>, as provided in the rule class object, are provided as \u000A arguments to the prover.  Such auxiliary proofs give the sort of output that \u000A one expects from the prover.  However, as noted above, corollaries that follow \u000A trivially are not submitted to the prover; thus, such corollaries cause no \u000A prover output.</p> \u000A \u000A <p>Note that before <v>term</v> is stored, all calls of macros in it are \u000A expanded away.  See <see topic=\"ACL2____TRANS\">trans</see>.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____HINTS\">Hints</see></tt>, <v>:</v><tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt>, <v>:</v><tt><see topic=\"ACL2____OTF-FLG\">otf-flg</see></tt> \u000A &mdash; the values of these fields must satisfy the same restrictions placed \u000A on the fields of the same names in <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>.  These values are passed to \u000A the recursive call of the prover used to establish that the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> of the rule class object follows from the theorem or axiom \u000A <v>thm</v>.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____TYPE-SET\">Type-set</see></tt> &mdash; this field may be supplied only if the \u000A <v>:class</v> is <v>:</v><tt><see topic=\"ACL2____TYPE-SET-INVERTER\">type-set-inverter</see></tt>.  When provided, the value must \u000A be a type-set, an integer in a certain range.  If not provided, an attempt is \u000A made to compute it from the corollary.  See <see topic=\"ACL2____TYPE-SET-INVERTER\">type-set-inverter</see>.</p> \u000A \u000A <p><v>:Typed-term</v> &mdash; this field may be supplied only if the <v>:class</v> \u000A is <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt>.  When provided, the value is the term for \u000A which the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> is a type-prescription lemma.  If no \u000A <v>:typed-term</v> is provided in a <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt> rule class \u000A object, we try to compute heuristically an acceptable term.  See <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see>.</p> \u000A \u000A <p><v>:Trigger-terms</v> &mdash; this field may be supplied only if the \u000A <v>:class</v> is <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt> or <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>.  When \u000A provided, the value is a list of terms, each of which is to trigger the \u000A attempted application of the rule.  If no <v>:trigger-terms</v> is provided, we \u000A attempt to compute heuristically an appropriate set of triggers.  See <see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see> or see <see topic=\"ACL2____LINEAR\">linear</see>.</p> \u000A \u000A <p><v>:Trigger-fns</v> &mdash; this field must (and may only) be supplied if the \u000A <v>:class</v> is <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt>.  Its value must be a list of function \u000A symbols (except that a macro alias can stand in for a function symbol; see \u000A <see topic=\"ACL2____ADD-MACRO-ALIAS\">add-macro-alias</see>).  Terms with these symbols trigger the application of \u000A the rule.  See <see topic=\"ACL2____META\">meta</see>.</p> \u000A \u000A <p><v>:Clique</v> and <v>:controller-alist</v> &mdash; these two fields may only \u000A be supplied if the <v>:class</v> is <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt>.  If they are \u000A omitted, then ACL2 will attempt to guess them.  Suppose the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> of the rule is <v>(<see topic=\"ACL2____IMPLIES\">implies</see> hyp (equiv (fn a1 ... an) body))</v>.  The \u000A value of the <v>:clique</v> field should be a true list of function symbols, and \u000A if non-<v>nil</v> must include <v>fn</v>.  These symbols are all the members of \u000A the mutually recursive clique containing this definition of <v>fn</v>.  That is, \u000A a call of any function in <v>:clique</v> is considered a ``recursive call'' for \u000A purposes of the expansion heuristics.  The value of the <v>:controller-alist</v> \u000A field should be an alist that maps each function symbol in the <v>:clique</v> to \u000A a list of <v>t</v>'s and <v>nil</v>'s of length equal to the arity of the \u000A function.  For example, if <v>:clique</v> consists of just two symbols, <v>fn1</v> \u000A and <v>fn2</v>, of arities <v>2</v> and <v>3</v> respectively, then <v>((fn1 t nil)\u000A (fn2 nil t t))</v> is a legal value of <v>:controller-alist</v>.  The value \u000A associated with a function symbol in this alist is a ``mask'' specifying which \u000A argument slots of the function ``control'' the recursion for heuristic \u000A purposes.  Sloppy choice of <v>:clique</v> or <v>:controller-alist</v> can result \u000A in infinite expansion and stack overflow.</p> \u000A \u000A <p><v>:Install-body</v> &mdash; this field may only be supplied if the \u000A <v>:class</v> is <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt>.  Its value must be <v>t</v>, <v>nil</v>, \u000A or the default, <v>:normalize</v>.  A value of <v>t</v> or <v>:normalize</v> will \u000A cause ACL2 to install this rule as the new body of the function being \u000A ``defined'' (<v>fn</v> in the paragraph just above); hence this definition will \u000A be installed for future <v>:expand</v> <see topic=\"ACL2____HINTS\">hints</see>.  Furthermore, if this field \u000A is omitted or the value is <v>:normalize</v>, then this definition will be \u000A simplified using the so-called ``normalization'' procedure that is used when \u000A processing definitions made with <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.  You must explicitly specify \u000A <v>:install-body nil</v> in the following cases: <v>fn</v> (as above) is a member \u000A of the value of constant <v>*definition-minimal-theory*</v>, the arguments are \u000A not a list of distinct variables, <v>equiv</v> (as above) is not <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt>, \u000A or there are free variables in the hypotheses or right-hand side (see <see topic=\"ACL2____FREE-VARIABLES\">free-variables</see>).  However, supplying <v>:install-body nil</v> will not affect \u000A the rewriter's application of the <v>:definition</v> rule, other than to avoid \u000A using the rule to apply <v>:expand</v> hints.  If a definition rule equates \u000A <v>(f a1 ... ak)</v> with <v>body</v> but there are hypotheses, <v>hyps</v>, then \u000A <v>:expand</v> <see topic=\"ACL2____HINTS\">hints</see> will replace terms <v>(f term1 ... termk)</v> by \u000A corresponding terms <v>(<see topic=\"COMMON-LISP____IF\">if</see> hyps body (<see topic=\"ACL2____HIDE\">hide</see> (f term1 ... termk)))</v>.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____LOOP-STOPPER\">Loop-stopper</see></tt> &mdash; this field may only be supplied if the \u000A class is <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>.  Its value must be a list of entries each \u000A consisting of two variables followed by a (possibly empty) list of function \u000A symbols, for example <v>((x y binary-+) (<see topic=\"ACL2____U\">u</see> v foo bar))</v>.  It will be used to \u000A restrict application of rewrite rules by requiring that the list of instances \u000A of the second variables must be ``smaller'' than the list of instances of the \u000A first variables in a sense related to the corresponding functions listed; see \u000A <see topic=\"ACL2____LOOP-STOPPER\">loop-stopper</see>.  The list as a whole is allowed to be <v>nil</v>, \u000A indicating that no such restriction shall be made.  Note that any such entry \u000A that contains a variable not being instantiated, i.e., not occurring on the \u000A left side of the rewrite rule, will be ignored.  However, for simplicity we \u000A merely require that every variable mentioned should appear somewhere in the \u000A corresponding <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> formula.</p> \u000A \u000A <p><v>:Pattern</v>, <v>:Condition</v>, <v>:Scheme</v> &mdash; the first and last of \u000A these fields must (and may only) be supplied if the class is <v>:</v><tt><see topic=\"ACL2____INDUCTION\">induction</see></tt>.  <v>:Condition</v> is optional but may only be supplied if the class \u000A is <v>:</v><tt><see topic=\"ACL2____INDUCTION\">induction</see></tt>.  The values must all be terms and indicate, \u000A respectively, the pattern to which a new induction scheme is to be attached, \u000A the condition under which the suggestion is to be made, and a term which \u000A suggests the new scheme.  See <see topic=\"ACL2____INDUCTION\">induction</see>.</p> \u000A \u000A <p><v>:Match-free</v> &mdash; this field must be <v>:all</v> or <v>:once</v> and may \u000A be supplied only if the <v>:class</v> is either <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, \u000A <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>, or <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt>.  (This field is not \u000A implemented for other rule classes, including the <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt> rule class.)  See <see topic=\"ACL2____FREE-VARIABLES\">free-variables</see> for a description \u000A of this field.  Note: Although this field is intended to be used for \u000A controlling retries of matching free variables in hypotheses, it is legal to \u000A supply it even if there are no such free variables.  This can simplify the \u000A automated generation of rules, but note that when <v>:match-free</v> is \u000A supplied, the warning otherwise provided for the presence of free variables in \u000A hypotheses will be suppressed.</p> \u000A \u000A <p><v>:Backchain-limit-lst</v> &mdash; this field may be supplied only if the \u000A <v>:class</v> is either <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt>, <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>, or <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt>.  It is further required either \u000A only one rule is generated from the formula or, at least, every such rule has \u000A the same list of hypotheses.  The value for <v>:backchain-limit-lst</v> must be \u000A <v>nil</v>; a non-negative integer; or, except in the case of <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt> \u000A rules, a true list each element of which is either <v>nil</v> or a non-negative \u000A integer.  If it is a list, its length must be equal to the number of \u000A hypotheses of the rule and each item in the list is the ``backchain limit'' \u000A associated with the corresponding hypothesis.  If <v>backchain-limit-lst</v> is \u000A a non-negative integer, it is defaulted to a list of the appropriate number of \u000A repetitions of that integer.  The backchain limit of a hypothesis is used to \u000A limit the effort that ACL2 will expend when relieving the hypothesis.  If it \u000A is <v>NIL</v>, no new limits are imposed; if it is an integer, the hypothesis \u000A will be limited to backchaining at most that many times.  Note that \u000A backchaining may be further limited by a global <v>backchain-limit</v>; see \u000A <see topic=\"ACL2____BACKCHAIN-LIMIT\">backchain-limit</see> for details.  For different ways to reign in the \u000A rewriter, see <see topic=\"ACL2____REWRITE-STACK-LIMIT\">rewrite-stack-limit</see> and see <see topic=\"ACL2____SET-PROVER-STEP-LIMIT\">set-prover-step-limit</see>. \u000A Jared Davis has pointed out that you can set the <v>:backchain-limit-lst</v> to \u000A 0 to avoid any attempt to relieve <tt><see topic=\"ACL2____FORCE\">force</see></tt>d hypotheses, which can lead to \u000A a significant speed-up in some cases.</p> \u000A \u000A </blockquote> \u000A \u000A <p>Once <v>thm</v> has been proved (in the case of <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>) and each rule \u000A class object has been checked for well-formedness (which might require \u000A additional proofs), we consider each rule class object in turn to generate and \u000A add rules.  Let <v>:class</v> be the class keyword token of the <v>i</v>th class \u000A object (counting from left to right).  Generate the <see topic=\"ACL2____RUNE\">rune</see> <v>(:class\u000A name . x)</v>, where <v>x</v> is <v>nil</v> if there is only one class and otherwise \u000A <v>x</v> is <v>i</v>.  Then, from the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> of that object, \u000A generate one or more rules, each of which has the name <v>(:class name . x)</v>. \u000A See the <v>:</v><tt><see topic=\"ACL2____DOC\">doc</see></tt> entry for each rule class to see how formulas \u000A determine rules.  Note that it is in principle possible for several rules to \u000A share the same name; it happens whenever a <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> determines \u000A more than one rule.  This in fact only occurs for <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, \u000A <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>, and <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt> class rules and only \u000A then if the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> is essentially a conjunction.  (See the \u000A documentation for <see topic=\"ACL2____REWRITE\">rewrite</see>, <see topic=\"ACL2____LINEAR\">linear</see>, or <see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see> \u000A for details.)</p>"],

 "ACL2____REWRITE":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <p>This doc topic discusses the rule-class <v>:rewrite</v>.  If you want a \u000A general discussion of how rewriting works in ACL2 and some guidance on how to \u000A construct effective rewrite rules, see <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-1\">introduction-to-rewrite-rules-part-1</see> and then see <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-2\">introduction-to-rewrite-rules-part-2</see>.</p> \u000A \u000A <code>Examples:\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> plus-commutes                 ; Replace (<see topic=\"COMMON-LISP_____B2\">+</see> a b) by (<see topic=\"COMMON-LISP_____B2\">+</see> b a) provided\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP_____B2\">+</see> x y) (<see topic=\"COMMON-LISP_____B2\">+</see> y x)))            ; certain heuristics approve the\u000A                                      ; permutation.\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> plus-commutes                 ; equivalent to the above\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP_____B2\">+</see> x y) (<see topic=\"COMMON-LISP_____B2\">+</see> y x))\u000A  :rule-classes ((:rewrite :corollary (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP_____B2\">+</see> x y) (<see topic=\"COMMON-LISP_____B2\">+</see> y x))\u000A                           :loop-stopper ((x y binary-+))\u000A                           :match-free :all)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> append-nil                    ; Replace (<see topic=\"COMMON-LISP____APPEND\">append</see> a nil) by a, if\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)             ; (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> a) rewrites to t.\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x nil) x)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> append-nil                    ; as above, but with defaults and\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)             ; a backchain limit\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x nil) x))\u000A  :rule-classes ((:rewrite :corollary (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)\u000A                                               (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x nil) x))\u000A                           :backchain-limit-lst (3) ; or equivalently, 3\u000A                           :match-free :all)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> member-append                 ; Replace (<see topic=\"COMMON-LISP____MEMBER\">member</see> e (<see topic=\"COMMON-LISP____APPEND\">append</see> b c)) by\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see>                            ; (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____MEMBER\">member</see> e b) (<see topic=\"COMMON-LISP____MEMBER\">member</see> e c) in\u000A   (<see topic=\"COMMON-LISP____AND\">and</see>                               ; contexts in which propositional\u000A    (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)                    ; equivalence is sufficient, provided\u000A    (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> y))                   ; b and c are true-lists.\u000A   (<see topic=\"ACL2____IFF\">iff</see> (<see topic=\"COMMON-LISP____MEMBER\">member</see> e (<see topic=\"COMMON-LISP____APPEND\">append</see> x y))\u000A        (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____MEMBER\">member</see> e x) (<see topic=\"COMMON-LISP____MEMBER\">member</see> e y)))))\u000A\u000AGeneral Form:\u000A(<see topic=\"COMMON-LISP____AND\">and</see> ...\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> ...hi...)\u000A              (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> ...hk...)\u000A                       (<see topic=\"COMMON-LISP____AND\">and</see> ...\u000A                            (equiv lhs rhs)\u000A                            ...)))\u000A     ...)</code> \u000A \u000A <p>Note: One <v>:rewrite</v> rule class object might create many rewrite rules \u000A from the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> formula.  To create the rules, we first \u000A translate the formula, expanding all macros (see <see topic=\"ACL2____TRANS\">trans</see>) and also \u000A removing <see topic=\"ACL2____GUARD-HOLDERS\">guard-holders</see>.  Next, we eliminate all <v>lambda</v>s; one may \u000A think of this step as simply substituting away every <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>, <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>, and <tt><see topic=\"ACL2____MV-LET\">mv-let</see></tt> in the formula.  We then flatten the <tt><see topic=\"COMMON-LISP____AND\">and</see></tt> and \u000A <tt><see topic=\"ACL2____IMPLIES\">implies</see></tt> structure of the formula; for example, if the hypothesis or \u000A conclusion is of the form <v>(<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____AND\">and</see> term1 term2) term3)</v>, then we replace \u000A that by the ``flat'' term <v>(<see topic=\"COMMON-LISP____AND\">and</see> term1 term2 term3)</v>.  (The latter is \u000A actually an abbreviation for the right-associated term <v>(<see topic=\"COMMON-LISP____AND\">and</see> term1 (<see topic=\"COMMON-LISP____AND\">and</see>\u000A term2 term3))</v>.)  The result is a conjunction of formulas, each of the \u000A form</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> h1 ... hn) concl)</code> \u000A \u000A <p>where no hypothesis is a conjunction and <v>concl</v> is neither a \u000A conjunction nor an implication.  If necessary, the hypothesis of such a \u000A conjunct may be vacuous.  We then further coerce each <v>concl</v> into the form \u000A <v>(equiv lhs rhs)</v>, where <v>equiv</v> is a known <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> relation, \u000A by replacing any <v>concl</v> not of that form by <v>(<see topic=\"ACL2____IFF\">iff</see> concl t)</v>.  A \u000A <v>concl</v> of the form <v>(<see topic=\"COMMON-LISP____NOT\">not</see> term)</v> is considered to be of the form <v>(<see topic=\"ACL2____IFF\">iff</see>\u000A term nil)</v>.  By these steps we reduce the given <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> to a \u000A sequence of conjuncts, each of which is of the form</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> h1 ... hn)\u000A         (equiv lhs rhs))</code> \u000A \u000A <p>where <v>equiv</v> is a known <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> relation.  See <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> for a general discussion of the introduction of new <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> relations.  At this point, we check whether <v>lhs</v> and <v>rhs</v> \u000A are the same term; if so, we cause an error, since this rule will loop.  (But \u000A this is just a basic check; the rule could loop in other cases, for example if \u000A <v>rhs</v> is an instance of <v>lhs</v>; see <see topic=\"ACL2____LOOP-STOPPER\">loop-stopper</see>.)</p> \u000A \u000A <p>We create a <v>:rewrite</v> rule for each such conjunct, if possible, and \u000A otherwise cause an error.  It is possible to create a rewrite rule from such a \u000A conjunct provided <v>lhs</v> is not a variable, a quoted constant, a <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>-expression, a <v>lambda</v> application, or an <tt><see topic=\"COMMON-LISP____IF\">if</see></tt>-expression.</p> \u000A \u000A <p>A <v>:rewrite</v> rule is used when any instance of the <v>lhs</v> occurs in a \u000A context in which the <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> relation is an admissible <see topic=\"ACL2____CONGRUENCE\">congruence</see> relation.  First, we find a substitution that makes <v>lhs</v> equal \u000A to the target term.  Then we attempt to relieve the instantiated hypotheses of \u000A the rule.  Hypotheses that are fully instantiated are relieved by recursive \u000A rewriting.  Hypotheses that contain ``free variables'' (variables not assigned \u000A by the unifying substitution) are relieved by attempting to guess a suitable \u000A instance so as to make the hypothesis equal to some known assumption in the \u000A context of the target.  If the hypotheses are relieved, and certain \u000A restrictions that prevent some forms of infinite regress are met (see <see topic=\"ACL2____LOOP-STOPPER\">loop-stopper</see>), the target is replaced by the instantiated <v>rhs</v>, which is \u000A then recursively rewritten.</p> \u000A \u000A <p>ACL2's rewriting process has undergone some optimization.  In particular, \u000A when a term <v>t1</v> is rewritten to a new term <v>t2</v>, the rewriter is then \u000A immediately applied to <v>t2</v>.  On rare occasions you may find that you do \u000A not want this behavior, in which case you may wish to use a trick involving \u000A <tt><see topic=\"ACL2____HIDE\">hide</see></tt>; see <see topic=\"ACL2____META\">meta</see>, near the end of that documentation.</p> \u000A \u000A <p>In another optimization, when the hypotheses and right-hand side are \u000A rewritten, ACL2 does not really first apply the substitution and then rewrite; \u000A instead, it as it rewrites those terms it looks up the <i>already \u000A rewritten</i> values of the bound variables.  Sometimes you may want those \u000A bindings rewritten again, e.g., because the variables occur in slots that \u000A admit additional equivalence relations.  See <i>double-rewrite</i>.</p> \u000A \u000A <p>See <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-1\">introduction-to-rewrite-rules-part-1</see> and see <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-2\">introduction-to-rewrite-rules-part-2</see> for an extended discussion of how to \u000A create effective rewrite rules.</p>"],

 "ACL2____MAKE-EVENT":[["Events","Macros"],"ACL2 Sources","ACL2","<p><v>Make-event</v> is a utility for generating <see topic=\"ACL2____EVENTS\">events</see>.  It \u000A provides a capability not offered by Lisp macros (see <see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see>), as it \u000A allows access to the ACL2 <tt><see topic=\"ACL2____STATE\">state</see></tt> and logical <see topic=\"ACL2____WORLD\">world</see>.  In essence, \u000A the expression <v>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> form)</v> replaces itself with the result of \u000A evaluating <v>form</v>, say, <v>ev</v>, as though one had submitted <v>ev</v> \u000A instead of the <v>make-event</v> call.  For example, \u000A <v>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (<see topic=\"COMMON-LISP____QUOTE\">quote</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x) x)))</v> is equivalent to the event <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see>\u000A f (x) x)</v>.</p> \u000A \u000A <p>We break this documentation into the following sections.</p> \u000A \u000A <p><b>Introduction</b><br></br> \u000A \u000A <b>Detailed Documentation</b><br></br> \u000A \u000A <b>Error Reporting</b><br></br> \u000A \u000A <b>Restriction to Event Contexts</b><br></br> \u000A \u000A <b>Examples Illustrating How to Access State</b><br></br> \u000A \u000A <b>Advanced Expansion Control</b></p> \u000A \u000A <p>We begin with an informal introduction, which focuses on examples and \u000A introduces the key notion of ``expansion phase''.</p> \u000A \u000A <p><b>Introduction</b></p> \u000A \u000A <p><v>Make-event</v> is particularly useful for those who program using the ACL2 \u000A <tt><see topic=\"ACL2____STATE\">state</see></tt>; see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see>.  That is because the \u000A evaluation of <v>form</v> may read and even modify the ACL2 <tt><see topic=\"ACL2____STATE\">state</see></tt>.</p> \u000A \u000A <p>Suppose for example that we want to define a constant <v>*world-length*</v>, \u000A that is the length of the current ACL2 <see topic=\"ACL2____WORLD\">world</see>.  A <v>make-event</v> form \u000A can accomplish this task, as follows.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98883\u000AACL2 !&gt;(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A        (<see topic=\"COMMON-LISP____LIST\">list</see> 'defconst '*world-length* (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))))\u000A\u000ASummary\u000AForm:  ( DEFCONST *WORLD-LENGTH* ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A\u000ASummary\u000AForm:  ( MAKE-EVENT (<see topic=\"COMMON-LISP____LIST\">LIST</see> ...))\u000ARules: NIL\u000ATime:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)\u000A *WORLD-LENGTH*\u000AACL2 !&gt;*world-length*\u000A98883\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98890\u000AACL2 !&gt;</code> \u000A \u000A <p>How did this work?  First, evaluation of the form <v>(<see topic=\"COMMON-LISP____LIST\">list</see> 'defconst\u000A '*world-length* (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)))</v> returned the event form <v>(<see topic=\"ACL2____DEFCONST\">defconst</see>\u000A *world-length* 98883)</v>.  Then that event form was automatically submitted to \u000A ACL2.  Of course, that changed the ACL2 logical <see topic=\"ACL2____WORLD\">world</see>, which is why the \u000A final value of <v>(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))</v> is greater than its initial value.</p> \u000A \u000A <p>The example above illustrates how the evaluation of a <v>make-event</v> call \u000A takes place in two phases.  The first phase evaluates the argument of the \u000A call, in this case <v>(<see topic=\"COMMON-LISP____LIST\">list</see> 'defconst '*world-length* (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)))</v>, \u000A to compute an event form, in this case <v>(<see topic=\"ACL2____DEFCONST\">defconst</see> *world-length* 98883)</v>. \u000A We call this evaluation the ``expansion'' phase.  Then the resulting event \u000A form is evaluated, which in this case defines the constant \u000A <v>*world-length*</v>.</p> \u000A \u000A <p>Now suppose we would like to introduce such a <tt><see topic=\"ACL2____DEFCONST\">defconst</see></tt> form any \u000A time we like.  It is common practice to define macros to automate such tasks. \u000A Now we might be tempted simply to make the following definition.</p> \u000A \u000A <code>; WRONG!\u000A(<see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see> define-world-length-constant (<see topic=\"ACL2____NAME\">name</see> state)\u000A  (<see topic=\"COMMON-LISP____LIST\">list</see> 'defconst name (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))))</code> \u000A \u000A <p>But ACL2 rejects such a definition, because a macro cannot take the ACL2 \u000A state as a parameter; instead, the formal parameter to this macro named \u000A <v>&quot;STATE&quot;</v> merely represents an ordinary object.  You can try to \u000A experiment with other such direct methods to define such a macro, but they \u000A won't work.</p> \u000A \u000A <p>Instead, however, you can use the approach illustrated by the \u000A <v>make-event</v> example above to define the desired macro, as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see> define-world-length-constant (<see topic=\"ACL2____NAME\">name</see>)\u000A  `(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (<see topic=\"COMMON-LISP____LIST\">list</see> 'defconst ',name (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)))))</code> \u000A \u000A <p>Here are example uses of this macro.</p> \u000A \u000A <code>ACL2 !&gt;(define-world-length-constant *foo*)\u000A\u000ASummary\u000AForm:  ( DEFCONST *FOO* ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A\u000ASummary\u000AForm:  ( MAKE-EVENT (<see topic=\"COMMON-LISP____LIST\">LIST</see> ...))\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A *FOO*\u000AACL2 !&gt;*foo*\u000A98891\u000AACL2 !&gt;:pe *foo*\u000A          2:x(DEFINE-WORLD-LENGTH-CONSTANT *FOO*)\u000A\u000A&gt;             (<see topic=\"ACL2____DEFCONST\">DEFCONST</see> *FOO* 98891)\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98897\u000AACL2 !&gt;(define-world-length-constant *bar*)\u000A\u000ASummary\u000AForm:  ( DEFCONST *BAR* ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A\u000ASummary\u000AForm:  ( MAKE-EVENT (<see topic=\"COMMON-LISP____LIST\">LIST</see> ...))\u000ARules: NIL\u000ATime:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)\u000A *BAR*\u000AACL2 !&gt;*bar*\u000A98897\u000AACL2 !&gt;:pe *bar*\u000A          3:x(DEFINE-WORLD-LENGTH-CONSTANT *BAR*)\u000A\u000A&gt;             (<see topic=\"ACL2____DEFCONST\">DEFCONST</see> *BAR* 98897)\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98903\u000AACL2 !&gt;</code> \u000A \u000A <p>Finally, we note that the expansion phase can be used for computation that \u000A has side effects, generally by modifying state.  Here is a modification of the \u000A above example that does not change the world at all, but instead saves the \u000A length of the world in a state global.</p> \u000A \u000A <code>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A (<see topic=\"ACL2____PPROGN\">pprogn</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'my-world-length (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)) state)\u000A         (value '(<see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see> nil))))</code> \u000A \u000A <p>Notice that this time, the value returned by the expansion phase is not an \u000A event form, but rather, is an error triple (see <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>) whose \u000A value component is an event form, namely, the event form <v>(<see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see>\u000A nil)</v>.  Evaluation of that event form does not change the ACL2 world (see \u000A <see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see>).  Thus, the sole purpose of the <v>make-event</v> call \u000A above is to change the <see topic=\"ACL2____STATE\">state</see> by associating the length of the current \u000A logical world with the state global named <v>'my-world-length</v>.  After \u000A evaluating this form, <v>(<see topic=\"ACL2_____04\">@</see> my-world-length)</v> provides the length of the ACL2 \u000A world, as illustrated by the following transcript.</p> \u000A \u000A <code>ACL2 !&gt;:pbt 0\u000A          0:x(<see topic=\"ACL2____EXIT-BOOT-STRAP-MODE\">EXIT-BOOT-STRAP-MODE</see>)\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98883\u000AACL2 !&gt;(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A        (<see topic=\"ACL2____PPROGN\">pprogn</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'my-world-length (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)) state)\u000A                (value '(<see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see> nil))))\u000A\u000ASummary\u000AForm:  ( MAKE-EVENT (<see topic=\"ACL2____PPROGN\">PPROGN</see> ...))\u000ARules: NIL\u000ATime:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)\u000A NIL\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))\u000A98883\u000AACL2 !&gt;:pbt 0\u000A          0:x(<see topic=\"ACL2____EXIT-BOOT-STRAP-MODE\">EXIT-BOOT-STRAP-MODE</see>)\u000AACL2 !&gt;</code> \u000A \u000A <p>When <v>make-event</v> is invoked by a book, it is expanded during book \u000A certification but not, by default, when the book is included.  So for the \u000A example <v>(define-world-length-constant *foo*)</v> given above, if that form is \u000A in a book, then the value of <v>*foo*</v> will be the length of the world at the \u000A time this form was invoked during book certification, regardless of world \u000A length at <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> time.  (The expansion is recorded in the book's \u000A <see topic=\"ACL2____CERTIFICATE\">certificate</see>, and re-used.)  To overcome this default, you can specify \u000A keyword value <v>:CHECK-EXPANSION t</v>.  This will cause an error if the \u000A expansion is different, but it can be useful for side effects.  For example, \u000A if you insert the following form in a book, then the length of the world will \u000A be printed when the form is encountered, whether during <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> \u000A or during <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.</p> \u000A \u000A <code>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A (<see topic=\"ACL2____PPROGN\">pprogn</see> (<see topic=\"ACL2____FMS\">fms</see> &quot;Length of current world: ~x0~|&quot;\u000A              (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))))\u000A              *standard-co* state nil)\u000A         (value '(<see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see> nil)))\u000A :check-expansion t)</code> \u000A \u000A <p><b>Detailed Documentation</b></p> \u000A \u000A <code>Examples:\u000A\u000A; Trivial example: evaluate (<see topic=\"COMMON-LISP____QUOTE\">quote</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)) to obtain\u000A; (<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x), which is then evaluated.\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (<see topic=\"COMMON-LISP____QUOTE\">quote</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)))\u000A\u000A; Evaluate (generate-form state) to obtain (<see topic=\"ACL2____MV\">mv</see> nil val state), and\u000A; then evaluate val.  (Generate-form is not specified here, but\u000A; imagine for example that it explores the state and then generates\u000A; some desired definition or theorem.)\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (generate-form state))\u000A\u000A; As above, but make sure that if this form is in a book, then when\u000A; we include the book, the evaluation of (generate-form state)\u000A; should return the same value as it did when the book was\u000A; certified.\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (generate-form state)\u000A            :CHECK-EXPANSION t)\u000A\u000A; As above (where the :CHECK-EXPANSION value can be included or\u000A; not), where if there is an error during expansion, then the error\u000A; message will explain that expansion was on behalf of the indicated\u000A; object, typically specified as the first argument.\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> (generate-form state)\u000A            :ON-BEHALF-OF (generate-form state))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> form :CHECK-EXPANSION chk :ON-BEHALF-OF obj :EXPANSION? form)</code> \u000A \u000A <p>where <v>chk</v> is <v>nil</v> (the default), <v>t</v>, or the intended \u000A ``expansion result'' from the evaluation of <v>form</v> (as explained below); \u000A and if supplied, <v>obj</v> is an arbitrary ACL2 object, used only in reporting \u000A errors in expansion, i.e., in the evaluation of form.  The <v>:EXPANSION?</v> \u000A keyword is discussed in the final section, on Advanced Expansion Control.</p> \u000A \u000A <p>We strongly recommend that you browse some <v>.lisp</v> files in the \u000A community books directory <v>books/make-event/</v>.  You may even find it \u000A helpful, in order to understand <v>make-event</v>, to do so before continuing to \u000A read this documentation.  You may also find it useful to browse community book \u000A <v>books/misc/eval.lisp</v>, which contains definitions of macros \u000A <v>must-succeed</v> and <v>must-fail</v> that are useful for testing and are used \u000A in many books in the <v>books/make-event/</v> directory, especially \u000A <v>eval-tests.lisp</v>.  Another example, <v>books/make-event/defrule.lisp</v>, \u000A shows how to use macros whose calls expand to <v>make-event</v> forms, which in \u000A turn can generate <see topic=\"ACL2____EVENTS\">events</see>.  For more examples, see file \u000A <v>books/make-event/Readme.lsp</v>.  Other than the examples, the explanations \u000A here should suffice for most users.  If you want explanations of subtler \u000A details, see <see topic=\"ACL2____MAKE-EVENT-DETAILS\">make-event-details</see>.</p> \u000A \u000A <p>Note that <v>make-event</v> may only be used at the ``top level'' or where an \u000A event is expected.  See the section ``Restriction to Event Contexts'', \u000A below.</p> \u000A \u000A <p><v>Make-event</v> is related to Lisp macroexpansion in the sense that its \u000A argument is evaluated to obtain an expansion result, which is evaluated again. \u000A Let us elaborate on each of these notions in turn: ``is evaluated,'' \u000A ``expansion result'', and ``evaluated again.''  The final section, on Advanced \u000A Expansion Control, will generalize these processes in a way that we ignore for \u000A now.</p> \u000A \u000A <blockquote> \u000A \u000A <p>``is evaluated'' &mdash; The argument can be any expression, which is \u000A evaluated as would be any expression submitted to ACL2's top level loop. \u000A Thus, <tt><see topic=\"ACL2____STATE\">state</see></tt> and user-defined <tt><see topic=\"ACL2____STOBJ\">stobj</see></tt>s may appear in the form \u000A supplied to <v>make-event</v>.  Henceforth, we will refer to this evaluation as \u000A ``expansion.''  Expansion is actually done in a way that restores ACL2's \u000A built-in <tt><see topic=\"ACL2____STATE\">state</see></tt> global variables, including the logical <see topic=\"ACL2____WORLD\">world</see>, \u000A to their pre-expansion values (with a few exceptions &mdash; see <see topic=\"ACL2____MAKE-EVENT-DETAILS\">make-event-details</see> &mdash; and where we note that changes to user-defined \u000A <tt><see topic=\"ACL2____STATE\">state</see></tt> global variables (see <see topic=\"ACL2____ASSIGN\">assign</see>) are preserved).  So, for \u000A example, events might be evaluated during expansion, but they will disappear \u000A from the logical <see topic=\"ACL2____WORLD\">world</see> after expansion returns its result.  Moreover, \u000A proofs are enabled by default at the start of expansion (see <see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see>) if keyword <v>:CHECK-EXPANSION</v> is supplied and has a \u000A non-<v>nil</v> value.</p> \u000A \u000A <p>``expansion result'' &mdash; The above expansion may result in an ordinary \u000A (non-<tt><see topic=\"ACL2____STATE\">state</see></tt>, non-<tt><see topic=\"ACL2____STOBJ\">stobj</see></tt>) value, which we call the ``expansion \u000A result.''  Or, expansion may result in a multiple value of the form <v>(<see topic=\"ACL2____MV\">mv</see> erp\u000A val state)</v>, or, more generally, <v>(<see topic=\"ACL2____MV\">mv</see> erp val state stobj-1 ... stobj-k)</v> \u000A where each <v>stobj-i</v> is a <see topic=\"ACL2____STOBJ\">stobj</see>; then the expansion result is \u000A <v>val</v> unless <v>erp</v> is not <v>nil</v>, in which case there is no expansion \u000A result, and the original <v>make-event</v> evaluates to a soft error.  In either \u000A case (single or multiple value), either <v>val</v> is an embedded event form \u000A (see <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see>), or else the original <v>make-event</v> \u000A evaluates to a soft error, printed as described under ``Error Reporting'' \u000A below.<br/> \u000A (<i>Technical remark</i>: The expansion result described above may be modified \u000A for <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, <tt><see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR\">add-include-book-dir</see></tt>, and <tt><see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR_12\">add-include-book-dir!</see></tt>, replacing book names by full pathnames, using syntax \u000A <v>(:system . relative-pathname)</v> for <see topic=\"ACL2____COMMUNITY-BOOKS\">community-books</see> (i.e., system \u000A books); see <see topic=\"ACL2____FULL-BOOK-NAME\">full-book-name</see>, and for further details see comments in \u000A source function <v>make-include-books-absolute</v>.  End of technical \u000A remark.)</p> \u000A \u000A <p>``evaluated again'' &mdash; the expansion result is evaluated in place of \u000A the original <v>make-event</v>.</p> \u000A \u000A </blockquote> \u000A \u000A <p>The expansion process can invoke subsidiary calls of <v>make-event</v>, and \u000A the expansion result can (perhaps after macroexpansion) be a call of \u000A <v>make-event</v>.  It can be useful to track all these <v>make-event</v> calls. \u000A The <see topic=\"ACL2____STATE\">state</see> global variable <v>make-event-debug</v> may be set to a \u000A non-<v>nil</v> value, for example <v>(<see topic=\"ACL2____ASSIGN\">assign</see> make-event-debug t)</v>, in order to \u000A see a trace of the expansion process, where a level is displayed (as in \u000A ``<v>3&gt;</v>'') to indicate the depth of subsidiary expansions.</p> \u000A \u000A <p>Expansion of a <v>make-event</v> call will yield an event that replaces the \u000A original <v>make-event</v> call.  In particular, if you put a <v>make-event</v> \u000A form in a book, then in essence it is replaced by its expansion result, \u000A created during the proof pass of the <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> process.  We now \u000A elaborate on this idea of keeping the original expansion.</p> \u000A \u000A <p>A <v>make-event</v> call generates a ``<v>make-event</v> replacement'' that may \u000A be stored by the system.  In the simplest case, this replacement is the \u000A expansion result.  When a book is certified, these replacements are stored in \u000A a book's certificate (technically, in the <v>:EXPANSION-ALIST</v> field).  Thus, \u000A although the book is not textually altered during certification, one may \u000A imagine a ``book expansion'' corresponding to the original book, in which \u000A events are substituted by replacements that were generated during the proof \u000A phase of certification.  A subsequent <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> will then include \u000A the book expansion corresponding to the indicated book.  When a book is \u000A compiled during <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>, it is actually the corresponding book \u000A expansion, stored as a temporary file, that is compiled instead.  That \u000A temporary file is deleted after compilation unless one first evaluates the \u000A form <v>(<see topic=\"ACL2____ASSIGN\">assign</see> keep-tmp-files t)</v>.  Note however that all of the original \u000A forms must still be legal <see topic=\"ACL2____EVENTS\">events</see>; see <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see>.  So \u000A for example, if the first event in a book is <v>(<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see> my-id (x)\u000A x))</v>, and is followed by <v>(my-id (<see topic=\"ACL2____MAKE-EVENT\">make-event</see> ...))</v>, the final \u000A ``<v>include-book</v>'' pass of <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> will fail because \u000A <v>my-id</v> is not defined when the <v>my-id</v> call is encountered.</p> \u000A \u000A <p>A <v>make-event</v> replacement might not be the expansion when either of the \u000A keyword arguments <v>:CHECK-EXPANSION</v> or <v>:EXPANSION?</v> is supplied.  We \u000A deal with the latter in the final section, on Advanced Expansion Control.  If \u000A <v>:CHECK-EXPANSION t</v> is supplied and the expansion is <v>exp</v>, then the \u000A replacement is obtained from the original <v>make-event</v> call, by \u000A substituting <v>exp</v> for <v>t</v> as the value of keyword \u000A <v>:CHECK-EXPANSION</v>.  Such a <v>make-event</v> call &mdash; during the second \u000A pass of an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>, or during event processing on behalf of <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> other than when including a book near the end of its \u000A certification process &mdash; will do the expansion again and check that the \u000A expansion result is equal to the original expansion result, <v>exp</v>.  In the \u000A unusual case that you know the expected expansion result, <v>res</v>, you can \u000A specify <v>:CHECK-EXPANSION res</v> in the first place, so that the check is \u000A also done during the initial evaluation of the <v>make-event</v> form. \u000A IMPORTANT BUT OBSCURE DETAIL: That expansion check is only done when \u000A processing events, not during a preliminary load of a book's compiled file. \u000A The following paragraph elaborates.</p> \u000A \u000A <p>(Here are details on the point made just above, for those who use the \u000A <v>:CHECK-EXPANSION</v> argument to perform side-effects on the <see topic=\"ACL2____STATE\">state</see>. \u000A When you include a book, ACL2 generally loads a compiled file before \u000A processing the events in the book; see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>.  While it is \u000A true that a non-<v>nil</v> <v>:CHECK-EXPANSION</v> argument causes <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> to perform expansion of the <v>make-event</v> form during event \u000A processing it does <i>not</i> perform expansion when the compiled file (or \u000A expansion file; again, see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>) is loaded.)</p> \u000A \u000A <p>ACL2 performs the following space-saving optimization: when the expansion \u000A result is a <tt><see topic=\"ACL2____LOCAL\">local</see></tt> event, then the <v>make-event</v> replacement is \u000A <v>(<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see> :ELIDED))</v>.</p> \u000A \u000A <p>The notion of ``expansion'' and ``replacement'' extend to the case that a \u000A call of <v>make-event</v> is found in the course of macroexpansion.  The \u000A following example illustrates this point.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A ()\u000A (<see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see> my-mac ()\u000A   '(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> '(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)))\u000A (my-mac))\u000A:pe :here</code> \u000A \u000A <p>The above call of <tt><see topic=\"ACL2____PE\">pe</see></tt> shows that the form <v>(my-mac)</v> has a \u000A <v>make-event</v> expansion (and replacement) of <v>(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) X)</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">ENCAPSULATE</see> NIL\u000A             (<see topic=\"COMMON-LISP____DEFMACRO\">DEFMACRO</see> MY-MAC\u000A                       NIL\u000A                       '(<see topic=\"ACL2____MAKE-EVENT\">MAKE-EVENT</see> '(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) X)))\u000A             (RECORD-EXPANSION (MY-MAC)\u000A                               (<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) X)))</code> \u000A \u000A <p><b>Error Reporting</b></p> \u000A \u000A <p>Suppose that expansion produces a soft error as described above.  That is, \u000A suppose that the argument of a <v>make-event</v> call evaluates to a multiple \u000A value <v>(<see topic=\"ACL2____MV\">mv</see> erp val state ...)</v> where <v>erp</v> is not <v>nil</v>.  If <v>erp</v> \u000A is a string, then that string is printed in the error message.  If <v>erp</v> is \u000A a <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> pair whose <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is a string, then the error prints \u000A <v>&quot;~@0&quot;</v> with <v>#\\0</v> bound to that <v>cons</v> pair; see <see topic=\"ACL2____FMT\">fmt</see>.  Any \u000A other non-<v>nil</v> value of <v>erp</v> causes a generic error message to be \u000A printed.</p> \u000A \u000A <p><b>Restriction to Event Contexts</b></p> \u000A \u000A <p>A <v>make-event</v> call must occur either at the top level, or during \u000A <v>make-event</v> expansion, or as an argument of an event constructor.  We \u000A explain in more detail below.  This restriction is imposed to enable ACL2 to \u000A track expansions produced by <v>make-event</v>.</p> \u000A \u000A <p>The following examples illustrate this restriction.</p> \u000A \u000A <code>; Legal:\u000A(<see topic=\"COMMON-LISP____PROGN\">progn</see> (<see topic=\"ACL2____WITH-OUTPUT\">with-output</see>\u000A        :on summary\u000A        (<see topic=\"ACL2____MAKE-EVENT\">make-event</see> '(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x))))\u000A\u000A; Illegal:\u000A(<see topic=\"ACL2____MV-LET\">mv-let</see> (erp val state)\u000A        (<see topic=\"ACL2____MAKE-EVENT\">make-event</see> '(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x))\u000A        (<see topic=\"ACL2____MV\">mv</see> erp val state))</code> \u000A \u000A <p>More precisely: a <v>make-event</v> call that is not itself evaluated during \u000A <v>make-event</v> expansion is subject to the following requirement.  After \u000A macroexpansion has taken place, such a <v>make-event</v> call must be in an \u000A ``event context'', defined recursively as follows.  (All but the first two \u000A cases below correspond to similar cases for constructing events; see <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see>.)</p> \u000A \u000A <ul> \u000A \u000A <li>A form submitted at the top level, or more generally, supplied to a call \u000A of <tt><see topic=\"ACL2____LD\">ld</see></tt>, is in an event context.</li> \u000A \u000A <li>A form occurring at the top level of a book is in an event context.</li> \u000A \u000A <li>If <v>(</v><tt><see topic=\"ACL2____LOCAL\">local</see></tt><v> x1)</v> is in an event context, then so is \u000A <v>x1</v>.</li> \u000A \u000A <li>If <v>(</v><tt><see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see></tt><v> x1)</v> is in an event context, then so is \u000A <v>x1</v>.</li> \u000A \u000A <li>If <v>(</v><tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt><v> x ...)</v> is in an event context and its \u000A expansion <v>x1</v> is an embedded event form, then <v>x1</v> is in an event \u000A context.</li> \u000A \u000A <li>If <v>(</v><tt><see topic=\"ACL2____WITH-OUTPUT\">with-output</see></tt><v> ... x1)</v>, <v>(</v><tt><see topic=\"ACL2____WITH-PROVER-STEP-LIMIT\">with-prover-step-limit</see></tt><v> ... x1 ...)</v>, or <v>(</v><tt><see topic=\"ACL2____WITH-PROVER-TIME-LIMIT\">with-prover-time-limit</see></tt><v> ... x1)</v> is in an event context, then so is \u000A <v>x1</v>.</li> \u000A \u000A <li>For any call of <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> or <tt><see topic=\"ACL2____PROGN_12\">progn!</see></tt>, each of its arguments is \u000A in an event context.</li> \u000A \u000A <li>For any call of <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>, each of its arguments except the \u000A first (the signature list) is in an event context.</li> \u000A \u000A <li>If <v>(RECORD-EXPANSION x1 x2)</v> is in an event context, then <v>x1</v> and \u000A <v>x2</v> are in event contexts.  Note: <v>record-expansion</v> is intended for \u000A use only by the implementation, which imposes the additional restriction that \u000A <v>x1</v> and its subsidiary <v>make-event</v> calls (if any) must specify a \u000A <v>:CHECK-EXPANSION</v> argument that is a <see topic=\"COMMON-LISP____CONSP\">consp</see>.</li> \u000A \u000A </ul> \u000A \u000A <p>Low-level remark, for system implementors.  There is the one exception to \u000A the above restriction: a single <tt><see topic=\"ACL2____STATE-GLOBAL-LET_A2\">state-global-let*</see></tt> form immediately \u000A under a <v>progn!</v> call.  For example:</p> \u000A \u000A <code>(<see topic=\"ACL2____PROGN_12\">progn!</see> (<see topic=\"ACL2____STATE-GLOBAL-LET_A2\">state-global-let*</see> &lt;bindings&gt; (<see topic=\"ACL2____MAKE-EVENT\">make-event</see> ...)))</code> \u000A \u000A <p>However, the following form may be preferable (see <see topic=\"ACL2____PROGN_12\">progn!</see>):</p> \u000A \u000A <code>(<see topic=\"ACL2____PROGN_12\">progn!</see> :STATE-GLOBAL-BINDINGS &lt;bindings&gt; (<see topic=\"ACL2____MAKE-EVENT\">make-event</see> ...))</code> \u000A \u000A <p>Also see <see topic=\"ACL2____REMOVE-UNTOUCHABLE\">remove-untouchable</see> for an interesting use of this \u000A exception.</p> \u000A \u000A <p><b>Examples Illustrating How to Access State</b></p> \u000A \u000A <p>You can modify the ACL2 <see topic=\"ACL2____STATE\">state</see> by doing your state-changing \u000A computation during the expansion phase, before expansion returns the event \u000A that is submitted.  Here are some examples.</p> \u000A \u000A <p>First consider the following.  Notice that expansion modifies state global \u000A <v>my-global</v> during <v>make-event</v> expansion, and then expansion returns a \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> event to be evaluated.</p> \u000A \u000A <code>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A  (<see topic=\"ACL2____ER-PROGN\">er-progn</see> (<see topic=\"ACL2____ASSIGN\">assign</see> my-global (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)))\u000A            (value '(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) (<see topic=\"COMMON-LISP____CONS\">cons</see> x x)))))</code> \u000A \u000A <p>Then we get:</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2_____04\">@</see> my-global)\u000A72271\u000AACL2 !&gt;:pe foo\u000A L        1:x(<see topic=\"ACL2____MAKE-EVENT\">MAKE-EVENT</see> (<see topic=\"ACL2____ER-PROGN\">ER-PROGN</see> # #))\u000A\u000A&gt;L            (<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) (<see topic=\"COMMON-LISP____CONS\">CONS</see> X X))\u000AACL2 !&gt;</code> \u000A \u000A <p>Here's a slightly fancier example, where the computation affects the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.  In a new session, execute:</p> \u000A \u000A <code>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A  (<see topic=\"ACL2____ER-PROGN\">er-progn</see> (<see topic=\"ACL2____ASSIGN\">assign</see> my-global (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state)))\u000A            (value `(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) (<see topic=\"COMMON-LISP____CONS\">cons</see> x ,(<see topic=\"ACL2_____04\">@</see> my-global))))))</code> \u000A \u000A <p>Then:</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2_____04\">@</see> my-global)\u000A72271\u000AACL2 !&gt;:pe foo\u000A L        1:x(<see topic=\"ACL2____MAKE-EVENT\">MAKE-EVENT</see> (<see topic=\"ACL2____ER-PROGN\">ER-PROGN</see> # #))\u000A\u000A&gt;L            (<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) (<see topic=\"COMMON-LISP____CONS\">CONS</see> X 72271))\u000AACL2 !&gt;</code> \u000A \u000A <p>Note that ACL2 <see topic=\"ACL2____TABLE\">table</see> <see topic=\"ACL2____EVENTS\">events</see> may avoid the need to use <see topic=\"ACL2____STATE\">state</see> globals.  For example, instead of the example above, consider this \u000A example in a new session.</p> \u000A \u000A <code>(<see topic=\"ACL2____MAKE-EVENT\">make-event</see>\u000A  (<see topic=\"COMMON-LISP____LET\">let</see> ((world-len (<see topic=\"COMMON-LISP____LENGTH\">length</see> (w state))))\u000A    `(<see topic=\"COMMON-LISP____PROGN\">progn</see> (<see topic=\"ACL2____TABLE\">table</see> my-table :STORED-WORLD-LENGTH ,world-len)\u000A            (<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) (<see topic=\"COMMON-LISP____CONS\">cons</see> x ,world-len)))))</code> \u000A \u000A <p>Then:</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TABLE\">table</see> my-table)\u000A ((:STORED-WORLD-LENGTH . 72271))\u000AACL2 !&gt;:pe foo\u000A          1:x(<see topic=\"ACL2____MAKE-EVENT\">MAKE-EVENT</see> (<see topic=\"COMMON-LISP____LET\">LET</see> # #))\u000A\u000A&gt;L            (<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> FOO (X) (<see topic=\"COMMON-LISP____CONS\">CONS</see> X 72271))\u000AACL2 !&gt;</code> \u000A \u000A <p>By the way, most built-in <see topic=\"ACL2____STATE\">state</see> globals revert after expansion.  But \u000A your own global (like <v>my-global</v> above) can be set during expansion, and \u000A the new value will persist.</p> \u000A \u000A <p><b>Advanced Expansion Control</b></p> \u000A \u000A <p>We conclude this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> section by discussing three kinds of \u000A additional control over <v>make-event</v> expansion.  These are all illustrated \u000A in community book <v>books/make-event/make-event-keywords-or-exp.lisp</v>.  The \u000A discussion below is split into the following three parts.</p> \u000A \u000A <p>(1) The value produced by expansion may have the form <v>(:DO-PROOFS\u000A exp)</v>, which specifies <v>exp</v> as the expansion result, to be evaluated \u000A without skipping proofs even when including a book.</p> \u000A \u000A <p>(2) The value produced by expansion may have the form <v>(:OR exp-1\u000A ... exp-k)</v>, which specifies that the first form <v>exp-i</v> to evaluate \u000A without error is the expansion result.</p> \u000A \u000A <p>(3) The keyword argument <v>:EXPANSION?</v> can serve to eliminate the \u000A storing of <v>make-event</v> replacements, as described above for the ``book \u000A expansion'' of a book.</p> \u000A \u000A <p>We now elaborate on each of these.</p> \u000A \u000A <p>(1) <v>:DO-PROOFS</v> ``call'' produced by expansion.</p> \u000A \u000A <p>We have discussed the expansion result produced by the expansion phase of \u000A evaluating a <v>make-event</v> call.  However, if the expansion phase produces \u000A an expression of the form <v>(:DO-PROOFS exp)</v>, then the expansion result is \u000A actually <v>exp</v>.  The <v>:DO-PROOFS</v> wrapper indicates that even if proofs \u000A are currently being skipped (see <see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see>), then evaluation of \u000A <v>exp</v> should take place with proofs not skipped.  For example, proofs will \u000A be performed when evaluating the <v>make-event</v> expansion, namely the \u000A indicated <v>defthm</v> event, in the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____SET-LD-SKIP-PROOFSP\">set-ld-skip-proofsp</see> t state)\u000A(<see topic=\"ACL2____MAKE-EVENT\">make-event</see> '(:DO-PROOFS\u000A              (<see topic=\"ACL2____DEFTHM\">defthm</see> app-assoc (<see topic=\"COMMON-LISP____EQUAL\">equal</see>\u000A                                 (<see topic=\"COMMON-LISP____APPEND\">append</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x y) z)\u000A                                 (<see topic=\"COMMON-LISP____APPEND\">append</see> x y z)))))</code> \u000A \u000A <p>Note that such use of <v>:DO-PROOFS</v> causes proofs to be performed when \u000A evaluating the expansion while including an uncertified book.  But when \u000A including a certified book, then unless <v>:CHECK-EXPANSION</v> is supplied a \u000A non-<v>nil</v> value, the <v>make-event</v> replacement will just be the \u000A expansion, which does not include the <v>:DO-PROOFS</v> wrapper and hence will \u000A be evaluated with proofs skipped.</p> \u000A \u000A <p>(2) <v>:OR</v> ``call'' produced by expansion.</p> \u000A \u000A <p>There may be times where you want to try different expansions.  For \u000A example, the community book <v>books/make-event/proof-by-arith.lisp</v> attempts \u000A to admit a given event, which we'll denote <v>EV</v>, by trying events of the \u000A following form as <v>BOOK</v> varies over different community books.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A ()\u000A (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> BOOK :DIR :SYSTEM))\u000A EV)</code> \u000A \u000A <p>A naive implementation of this macro would evaluate all such <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> events until one succeeds, and then return that successful event \u000A as the expansion.  Then that event would need to be evaluated again!  With \u000A some hacking one could avoid that re-evaluation by using <tt><see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see></tt>, \u000A but that won't work if you are trying to create a certified book without \u000A skipped proofs.  Instead, the implementation creates an expansion of the form \u000A <v>(:OR ev-1 ev-2 ... ev-k)</v>, where the list <v>(ev-1 ev-2 ... ev-k)</v> \u000A enumerates the generated encapsulate events.  In general, for this \u000A ``disjunctive case'' of a result from expansion, each <v>ev-i</v> is evaluated \u000A in sequence, and the first that succeeds without error is considered to be the \u000A expansion result &mdash; and a repeat evaluation is avoided.  If evaluation of \u000A each <v>ev-i</v> results in an error, then so does the <v>make-event</v> call.</p> \u000A \u000A <p>This special use of <v>:OR</v> in a value produced by expansion is only \u000A supported at the top level.  That is, the result can be <v>(:OR ev-1 ev-2\u000A ... ev-k)</v> but then each <v>ev-i</v> must be a legal expansion result, without \u000A such further use of <v>:OR</v> &mdash; except, <v>ev-i</v> may be <tt>(:DO-PROOFS \u000A ev-i')</tt>, where <v>ev-i'</v> then would serve as the expansion rather than \u000A <v>ev-i</v>.</p> \u000A \u000A <p>(3) The <v>:EXPANSION?</v> keyword argument.</p> \u000A \u000A <p>If keyword argument <v>:EXPANSION?</v> has a non<v>nil</v> value, then the \u000A <v>:CHECK-EXPANSION</v> keyword must be omitted or have value <v>nil</v> or \u000A <v>t</v>, hence not a cons pair.</p> \u000A \u000A <p>The idea of the <v>:EXPANSION?</v> keyword is to give you a way to avoid \u000A storing expansion results in a book's <see topic=\"ACL2____CERTIFICATE\">certificate</see>.  Roughly speaking, \u000A when the expansion result matches the value of <v>:EXPANSION?</v>, then no \u000A expansion result is stored for the event by book certification; then when the \u000A book is later included, the value of <v>:EXPANSION?</v> is used as the \u000A expansion, thus bypassing the expansion phase.  One could say that the event \u000A is its own make-event replacement, but it is more accurate to say that there \u000A is no make-event replacement at all, since nothing is stored in the \u000A certificate for this event.  Below, we elaborate on make-event replacements \u000A when <v>:EXPANSION</v> is used and also discuss other properties of this \u000A keyword.</p> \u000A \u000A <p>We modify the notion of ``expansion result'' for <v>make-event</v> forms to \u000A comprehend the use of the <v>:EXPANSION?</v> keyword.  For that purpose, let's \u000A consider a call of <v>make-event</v> to be ``reducible'' if it has an \u000A <v>:EXPANSION?</v> keyword with non-<v>nil</v> value, <v>exp</v>, and its \u000A <v>:CHECK-EXPANSION</v> keyword is missing or has value <v>nil</v>, in which case \u000A the ``reduction'' of this <v>make-event</v> call is defined to be <v>exp</v>.  The \u000A expansion result as originally defined is modified by the following \u000A ``recursive reduction'' process: recur through the original expansion, passing \u000A through calls of <tt><see topic=\"ACL2____LOCAL\">local</see></tt>, <tt><see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see></tt>, <tt><see topic=\"ACL2____WITH-OUTPUT\">with-output</see></tt>, \u000A <tt><see topic=\"ACL2____WITH-PROVER-STEP-LIMIT\">with-prover-step-limit</see></tt>, and <tt><see topic=\"ACL2____WITH-PROVER-TIME-LIMIT\">with-prover-time-limit</see></tt>, and \u000A replacing (recursively) any reducible call of <v>make-event</v> by its \u000A reduction.  Furthermore, we refer to two forms as ``reduction equivalent'' if \u000A their recursive reductions are equal.  Note that the recursive reduction \u000A process does not pass through <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> or <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>, but that \u000A process is applied to the computation of expansions for their subsidiary \u000A <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> calls.</p> \u000A \u000A <p>To explain further the effect of <v>:EXPANSION? exp</v>, we split into the \u000A following two cases.</p> \u000A \u000A <p><b>Case 1</b>: Evaluation is not taking place when including a book or \u000A evaluating the second pass of an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> event; more precisely, \u000A the value of <v>(<see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see> state)</v> is not the symbol <v>INCLUDE-BOOK</v>. \u000A There are two subcases.</p> \u000A \u000A <ul> \u000A \u000A <li>Case 1a: The expansion result is not reduction-equivalent to <v>exp</v>. \u000A Then the <v>make-event</v> call is processed as though the <v>:EXPANSION?</v> \u000A keyword had been omitted.</li> \u000A \u000A <li>Case 2a: The expansion result is reduction-equivalent to <v>exp</v>.  Then \u000A there is no <v>make-event</v> replacement for this call of <v>make-event</v>; no \u000A replacement will be put into the <see topic=\"ACL2____CERTIFICATE\">certificate</see> file for a book containing \u000A this <v>make-event</v> call.  When that book is subsequently included, the \u000A original form will be evaluated in the manner described in the next \u000A case.</li> \u000A \u000A </ul> \u000A \u000A <p><b>Case 2</b>: Evaluation is taking place when including a book or evaluating \u000A the second pass of an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> event; more precisely, the value of \u000A <v>(<see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see> state)</v> is the symbol <v>INCLUDE-BOOK</v>.  Then the \u000A expansion is <v>exp</v>.  The expansion phase is skipped unless \u000A <v>:CHECK-EXPANSION</v> is <v>t</v>.</p> \u000A \u000A <p>The <v>:EXPANSION?</v> keyword can be particularly useful in concert with the \u000A disjunctive (``<v>:OR</v>'') case (2) discussed above.  Suppose that expansion \u000A produces a value as discussed in (2) above, <v>(:OR exp-1 ... exp-k)</v>.  If \u000A one of these expressions <v>exp-i</v> is more likely than the others to be the \u000A expansion, then you may wish to specify <v>:EXPANSION? exp-i</v>, as this will \u000A avoid storing a <v>make-event</v> replacement in that common case.  This could \u000A be useful if the expressions are large, to avoid enlarging the <see topic=\"ACL2____CERTIFICATE\">certificate</see> file for a book containing the <v>make-event</v> call.</p> \u000A \u000A <p>It is legal to specify both <v>:EXPANSION? exp</v> and <v>:CHECK-EXPANSION\u000A t</v>.  When either <v>(<see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see> state)</v> is the symbol \u000A <v>INCLUDE-BOOK</v>, or evaluation is taking place in raw Lisp, then this \u000A combination is treated the same as if <v>:EXPANSION?</v> is omitted and the \u000A value of <v>:CHECK-EXPANSION</v> is <v>exp</v>.  Otherwise, this combination is \u000A treated the same as <v>:CHECK-EXPANSION t</v>, modified to accommodate the \u000A effect of <v>:EXPANSION?</v>  as discussed above: if the expansion is indeed the \u000A value of <v>:EXPANSION?</v>, then no <v>make-event</v> replacement is \u000A generated.</p>"],

 "ACL2____LD":[["Miscellaneous"],"ACL2 Sources","ACL2","<code>Examples: \u000A(LD \"foo.lisp\")              ; read and evaluate each form in file \u000A                             ; \"foo.lisp\", in order \u000A(LD \"foo.lisp\" :ld-pre-eval-print t) \u000A                             ; as above, but print each form to standard \u000A                             ; character output just before it is evaluated \u000A \u000AGeneral Form: \u000A(LD standard-oi                  ; open obj in channel, stringp file name \u000A                                 ; to open and close, or list of forms \u000A                                 ; Optional keyword arguments: \u000A    :dir                ...      ; use this add-include-book-dir directory \u000A    :standard-co        ...      ; open char out or file to open and close \u000A    :proofs-co          ...      ; open char out or file to open and close \u000A    :current-package    ...      ; known package name \u000A    :ld-skip-proofsp    ...      ; nil, 'include-book, or t \u000A                                 ;   (see <see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see>) \u000A    :ld-redefinition-action ...  ; nil or '(:a . :b) \u000A    :ld-prompt          ...      ; nil, t, or some prompt printer fn \u000A    :ld-missing-input-ok ...     ; nil, t, :warn, or warning message \u000A    :ld-pre-eval-filter ...      ; :all, :query, or some new name \u000A    :ld-pre-eval-print  ...      ; nil, t, or :never \u000A    :ld-post-eval-print ...      ; nil, t, or :command-conventions \u000A    :ld-evisc-tuple     ...      ; nil or '(alist nil nil level length) \u000A    :ld-error-triples   ...      ; nil or t \u000A    :ld-error-action    ...      ; :return!, :return, :continue, :error, \u000A                                 ;   or (:exit N) \u000A    :ld-query-control-alist ...  ; alist supplying default responses \u000A    :ld-verbose         ...)     ; nil or t \u000A \u000A</code> \u000A \u000A <p><v>Ld</v> is the top-level ACL2 read-eval-print loop.  (When you call <tt><see topic=\"ACL2____LP\">lp</see></tt>, a little initialization is done in raw Common Lisp and then <v>ld</v> is \u000A called.)  <v>Ld</v> is also a general-purpose ACL2 file loader and a <see topic=\"ACL2____COMMAND\">command</see> interpreter.  <v>Ld</v> is actually a macro that expands to a function \u000A call involving <tt><see topic=\"ACL2____STATE\">state</see></tt>.  <v>Ld</v> returns an ``error triple'' <v>(<see topic=\"ACL2____MV\">mv</see> erp\u000A val state)</v> as explained below.  (For much more on error triples, see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see>.)</p> \u000A \u000A <p>See <see topic=\"ACL2____REBUILD\">rebuild</see> for a variant of <v>ld</v> that skips proofs.  See <see topic=\"ACL2____OUTPUT-TO-FILE\">output-to-file</see> for examples showing how to redirect output to a file.</p> \u000A \u000A <p>The arguments to <v>ld</v>, except for <v>:dir</v>, all happen to be global \u000A variables in <tt><see topic=\"ACL2____STATE\">state</see></tt> (see <see topic=\"ACL2____STATE\">state</see> and see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see>).  For example, <v>'</v><tt><see topic=\"ACL2____CURRENT-PACKAGE\">current-package</see></tt> and \u000A <v>'</v><tt><see topic=\"ACL2____LD-VERBOSE\">ld-verbose</see></tt> are global variables, which may be accessed via <v>(<see topic=\"ACL2_____04\">@</see>\u000A current-package)</v> and <v>(<see topic=\"ACL2_____04\">@</see> ld-verbose)</v>.  When <v>ld</v> is called, it \u000A ``binds'' these variables.  By ``binds'' we actually mean the variables are \u000A globally set but restored to their old values on exit.  Because <v>ld</v> \u000A provides the illusion of <see topic=\"ACL2____STATE\">state</see> global variables being bound, they are \u000A called ``<v>ld</v> specials'' (after the Lisp convention of calling a variable \u000A ``special'' if it is referenced freely after having been bound).</p> \u000A \u000A <p>Note that all arguments but the first are passed via keyword.  Any variable \u000A not explicitly given a value in a call retains its pre-call value, with the \u000A exception of <v>:</v><tt><see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see></tt>, which generally defaults to \u000A <v>:return!</v> if not explicitly specified.</p> \u000A \u000A <p>Just as an example to drive the point home: If <tt><see topic=\"ACL2____CURRENT-PACKAGE\">current-package</see></tt> is \u000A <v>&quot;ACL2&quot;</v> and you typed</p> \u000A \u000A <code>(<see topic=\"ACL2____LD\">ld</see> *standard-oi* :current-package &quot;MY-PKG&quot;)</code> \u000A \u000A <p>you would find yourself in (an inner) read-eval-print loop in which the \u000A <see topic=\"ACL2____CURRENT-PACKAGE\">current-package</see> was <v>&quot;MY-PKG&quot;</v>.  You could operate there as long \u000A as you wished, changing the current package at will.  But when you typed \u000A <v>:</v><tt><see topic=\"ACL2____Q\">q</see></tt> you would return to the outer read-eval-print loop where the \u000A current package would still be <v>&quot;ACL2&quot;</v>.</p> \u000A \u000A <p>Roughly speaking, <v>ld</v> repeatedly reads a form from <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>, \u000A evaluates it, and prints its result to <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt>.  It does this \u000A until the form is <v>:</v><tt><see topic=\"ACL2____Q\">q</see></tt> or evaluates to an error triple whose value \u000A component is <v>:</v><tt><see topic=\"ACL2____Q\">q</see></tt>, or until the input channel or list is emptied. \u000A However, <v>ld</v> has many bells and whistles controlled by the <v>ld</v> \u000A specials.  Each such special is documented individually.  For example, see the \u000A documentation for <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>, <tt><see topic=\"ACL2____CURRENT-PACKAGE\">current-package</see></tt>, <tt><see topic=\"ACL2____LD-PRE-EVAL-PRINT\">ld-pre-eval-print</see></tt>, etc.</p> \u000A \u000A <p>A more precise description of <v>ld</v> is as follows.  In the description \u000A below we use the <v>ld</v> specials as variables, e.g., we say ``a form is read \u000A from <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>.''  By this usage we refer to the current value of \u000A the named <see topic=\"ACL2____STATE\">state</see> global variable, e.g., we mean ``a form is read from \u000A the current value of <v>'</v><tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>.'' This technicality has an \u000A important implication: If while interacting with <v>ld</v> you change the value \u000A of one of the <v>ld</v> specials, e.g., <v>'</v><tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>, you will \u000A change the behavior of <v>ld</v>, e.g., subsequent input will be taken from the \u000A new value.</p> \u000A \u000A <p>Three <v>ld</v> specials are treated as channels: <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is \u000A treated as an object input channel and is the source of forms evaluated by \u000A <v>ld</v>; <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt> and <tt><see topic=\"ACL2____PROOFS-CO\">proofs-co</see></tt> are treated as character \u000A output channels and various flavors of output are printed to them.  However, \u000A the supplied values of these specials need not actually be channels; several \u000A special cases are recognized.</p> \u000A \u000A <p>If the supplied value of one of these is in fact an open channel of the \u000A appropriate type, that channel is used and is not closed by <v>ld</v>.  If the \u000A supplied value of one of these specials is a string, the string is treated as \u000A a file name in (essentially) Unix syntax (see <see topic=\"COMMON-LISP____PATHNAME\">pathname</see>) and a channel \u000A of the appropriate type is opened to/from that file.  Any channel opened by \u000A <v>ld</v> during the binding of the <v>ld</v> specials is automatically closed by \u000A <v>ld</v> upon termination.  If <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt> and <tt><see topic=\"ACL2____PROOFS-CO\">proofs-co</see></tt> are \u000A equal strings, only one channel to that file is opened and is used for \u000A both.</p> \u000A \u000A <p>As a special convenience, when <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is a string and the \u000A <v>:dir</v> argument provided and not <v>nil</v>, we look up <v>:dir</v> in the \u000A table of directories maintained by <tt><see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR\">add-include-book-dir</see></tt>, and prepend \u000A this directory to <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> to create the filename.  (In this case, \u000A however, we require that <v>standard-oi</v> is a relative pathname, not an \u000A absolute pathname.)  For example, one can write <v>(<see topic=\"ACL2____LD\">ld</see>\u000A &quot;arithmetic/top-with-meta.lisp&quot; :dir :system)</v> to <v>ld</v> that particular \u000A community books library.  (Of course, you should almost always load books like \u000A <v>arithmetic/top-with-meta</v> using <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> instead of <v>ld</v>.) \u000A If <v>:dir</v> is not specified, then a relative pathname is resolved using the \u000A connected book directory; see <see topic=\"ACL2____CBD\">cbd</see>.</p> \u000A \u000A <p>Several other alternatives are allowed for <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>.  If <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is a true list then it is taken as the list of forms to be \u000A processed.  If <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is a list ending in an open channel, then \u000A <v>ld</v> processes the forms in the list and then reads and processes the forms \u000A from the channel.  Analogously, if <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is a list ending a \u000A string, an object input channel from the named file is opened and <v>ld</v> \u000A processes the forms in the list followed by the forms in the file.  That \u000A channel is closed upon termination of <v>ld</v>.</p> \u000A \u000A <p>In the cases that a string is to be converted to an object input channel \u000A &mdash; that is, when <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt> is a string or is a list ending in a \u000A string &mdash; an error occurs by default if the conversion fails, presumably \u000A because the file named by the string does not exist.  However, if keyword \u000A argument <v>:ld-missing-input-ok</v> is <v>t</v>, then <v>ld</v> immediately returns \u000A without error in this case, but without reading or executing any forms, as \u000A though <v>standard-oi</v> is <v>nil</v> and keyword arguments <v>:ld-verbose</v> and \u000A <v>ld-prompt</v> both have value <v>nil</v>.  The other legal values for \u000A <v>:ld-missing-input-ok</v> are <v>nil</v>, which gives the default behavior, and \u000A <v>:warn</v>, which behaves the same as <v>t</v> except that a warning is printed, \u000A which contains the same information as would be printed for the default error \u000A described above.</p> \u000A \u000A <p>The remaining <v>ld</v> specials are handled more simply and generally have \u000A to be bound to one of a finite number of tokens described in the <v>:</v><tt><see topic=\"ACL2____DOC\">doc</see></tt> entries for each <v>ld</v> special.  Should any <v>ld</v> special be supplied \u000A an inappropriate value, an error message is printed.</p> \u000A \u000A <p>Next, if <tt><see topic=\"ACL2____LD-VERBOSE\">ld-verbose</see></tt> is <v>t</v>, <v>ld</v> prints the message ``ACL2 \u000A loading name'' where <v>name</v> names the file or channel from which forms are \u000A being read.  At the conclusion of <v>ld</v>, it will print ``Finished loading \u000A name'' if <tt><see topic=\"ACL2____LD-VERBOSE\">ld-verbose</see></tt> is <v>t</v>.</p> \u000A \u000A <p>Finally, <v>ld</v> repeatedly executes the ACL2 read-eval-print step, which \u000A may be described as follows.  A <see topic=\"ACL2____PROMPT\">prompt</see> is printed to <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt> if <tt><see topic=\"ACL2____LD-PROMPT\">ld-prompt</see></tt> is non-<v>nil</v>.  The format of the <see topic=\"ACL2____PROMPT\">prompt</see> is determined by <tt><see topic=\"ACL2____LD-PROMPT\">ld-prompt</see></tt>.  If it is <v>t</v>, the default ACL2 \u000A <see topic=\"ACL2____PROMPT\">prompt</see> is used.  If it is any other non-<v>nil</v> value then it is \u000A treated as an ACL2 function that will print the desired <see topic=\"ACL2____PROMPT\">prompt</see>.  See \u000A <see topic=\"ACL2____LD-PROMPT\">ld-prompt</see>.  In the exceptional case where <v>ld</v>'s input is coming \u000A from the terminal <v>(<see topic=\"ACL2_____A2STANDARD-OI_A2\">*standard-oi*</see>)</v> but its output is going to a different \u000A sink (i.e., <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt> is not <tt><see topic=\"ACL2_____A2STANDARD-CO_A2\">*standard-co*</see></tt>), we also print \u000A the <see topic=\"ACL2____PROMPT\">prompt</see> to the terminal.</p> \u000A \u000A <p><v>Ld</v> then reads a form from <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>.  If the object read is \u000A a keyword, <v>ld</v> constructs a ``keyword command form'' by possibly reading \u000A several more objects.  See <see topic=\"ACL2____KEYWORD-COMMANDS\">keyword-commands</see>.  This construction process \u000A is sensitive to the value of <tt><see topic=\"ACL2____LD-KEYWORD-ALIASES\">ld-keyword-aliases</see></tt>.  See <see topic=\"ACL2____LD-KEYWORD-ALIASES\">ld-keyword-aliases</see>.  Otherwise, the object read is treated as the command \u000A form.</p> \u000A \u000A <p><v>Ld</v> next decides whether to evaluate or skip this form, depending on \u000A <tt><see topic=\"ACL2____LD-PRE-EVAL-FILTER\">ld-pre-eval-filter</see></tt>.  Initially, the filter must be either <v>:all</v>, \u000A <v>:query</v>, or a new name.  If it is <v>:all</v>, it means all forms are \u000A evaluated.  If it is <v>:query</v>, it means each form that is read is displayed \u000A and the user is queried.  Otherwise, the filter is a name and each form that \u000A is read is evaluated as long as the name remains new, but if the name is ever \u000A introduced then no more forms are read and <v>ld</v> terminates.  See <see topic=\"ACL2____LD-PRE-EVAL-FILTER\">ld-pre-eval-filter</see>.</p> \u000A \u000A <p>If the form is to be evaluated, then <v>ld</v> first prints the form to \u000A <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt>, if <tt><see topic=\"ACL2____LD-PRE-EVAL-PRINT\">ld-pre-eval-print</see></tt> is <v>t</v>.  With this \u000A feature, <v>ld</v> can process an input file or form list and construct a script \u000A of the session that appears as though each form was typed in.  See <see topic=\"ACL2____LD-PRE-EVAL-PRINT\">ld-pre-eval-print</see>.</p> \u000A \u000A <p><v>Ld</v> then evaluates the form, with <tt><see topic=\"ACL2____STATE\">state</see></tt> bound to the current \u000A <see topic=\"ACL2____STATE\">state</see>.  The result is some list of (multiple) values.  If a <see topic=\"ACL2____STATE\">state</see> is among the values, then <v>ld</v> uses that <see topic=\"ACL2____STATE\">state</see> as the \u000A subsequent current <see topic=\"ACL2____STATE\">state</see>.</p> \u000A \u000A <p>Depending on <tt><see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see></tt>, <v>ld</v> may interpret the result as \u000A an ``error.''  See <see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see>.  We first discuss <v>ld</v>'s \u000A behavior if no error signal is detected (either because none was sent or \u000A because <v>ld</v> is ignoring them because <tt><see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see></tt> is \u000A <v>nil</v>).</p> \u000A \u000A <p>In the case of a non-erroneous result, <v>ld</v> does two things: First, if \u000A the logical <see topic=\"ACL2____WORLD\">world</see> in the now current <see topic=\"ACL2____STATE\">state</see> is different than the \u000A <see topic=\"ACL2____WORLD\">world</see> before execution of the form, <v>ld</v> adds to the <see topic=\"ACL2____WORLD\">world</see> a \u000A ``<see topic=\"ACL2____COMMAND\">command</see> landmark'' containing the form evaluated.  See <see topic=\"ACL2____COMMAND-DESCRIPTOR\">command-descriptor</see>.  Second, <v>ld</v> prints the result to <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt>, but only if <tt><see topic=\"ACL2____LD-POST-EVAL-PRINT\">ld-post-eval-print</see></tt> is not <v>nil</v>.  The \u000A result is printed as a list of (multiple) values unless <tt><see topic=\"ACL2____LD-POST-EVAL-PRINT\">ld-post-eval-print</see></tt> is <v>:command-conventions</v>, <tt><see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see></tt> is \u000A <v>t</v>, and the result is an ``error triple'', i.e., of the form <v>(<see topic=\"ACL2____MV\">mv</see> * *\u000A state)</v> (see <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>).  In that case, only the non-erroneous \u000A ``value'' component of the result is printed.  See <see topic=\"ACL2____LD-POST-EVAL-PRINT\">ld-post-eval-print</see>.</p> \u000A \u000A <p>Whenever <v>ld</v> prints anything (whether the input form, a query, or some \u000A results) it ``eviscerates'' it if <v>ld-evisc-tuple</v> is non-<v>nil</v>. \u000A Essentially, evisceration is a generalization of Common Lisp's use of \u000A <v>*print-level*</v> and <v>*print-length*</v> to hide large substructures.  See \u000A <see topic=\"ACL2____EVISC-TUPLE\">evisc-tuple</see> and also see <see topic=\"ACL2____SET-IPRINT\">set-iprint</see>.</p> \u000A \u000A <p>We now return to the case of a form whose evaluation signals an error.  In \u000A this case, <v>ld</v> first restores the ACL2 logical <see topic=\"ACL2____WORLD\">world</see> to what it was \u000A just before the erroneous form was evaluated.  Thus, a form that partially \u000A changes the <see topic=\"ACL2____WORLD\">world</see> (i.e., begins to store properties) and then signals \u000A an error, has no effect on the <see topic=\"ACL2____WORLD\">world</see>.  You may see this happen on <see topic=\"ACL2____COMMAND\">command</see>s that execute several <see topic=\"ACL2____EVENTS\">events</see> (e.g., an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> or \u000A a <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> of several <tt><see topic=\"ACL2____DEFUNS\">defuns</see></tt>): even though the output makes it \u000A appear that the initial <see topic=\"ACL2____EVENTS\">events</see> were executed, if an error is signalled \u000A by a later event the entire block of <see topic=\"ACL2____EVENTS\">events</see> is discarded.</p> \u000A \u000A <p>After rolling back, <v>ld</v> takes an action determined by <tt><see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see></tt>.  If the action is <v>:continue</v>, <v>ld</v> merely iterates \u000A the read-eval-print step.  Note that nothing suggestive of the value of the \u000A ``erroneous'' form is printed.  If the action is <v>:return</v>, <v>ld</v> \u000A terminates normally; similarly if the action is <v>:return!</v>, but a special \u000A value is returned that can cause superior <v>ld</v> commands to terminate; see \u000A <see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see> for details.  If the action is <v>:error</v>, <v>ld</v> \u000A terminates signalling an error to its caller.  If its caller is in fact \u000A another instance of <v>ld</v> and that instance is watching out for error \u000A signals, the entire <see topic=\"ACL2____WORLD\">world</see> created by the inner <v>ld</v> will be \u000A discarded by the outer <v>ld</v> if the inner <v>ld</v> terminates with an \u000A error.  Note that if the action is <v>(:exit N)</v>, then there is no rolling \u000A back, because ACL2 quits immediately with exit status <v>N</v>.</p> \u000A \u000A <p><v>Ld</v> returns an error triple, <v>(<see topic=\"ACL2____MV\">mv</see> erp val state)</v>.  <v>Erp</v> is \u000A <v>t</v> or <v>nil</v> indicating whether an error is being signalled.  If no \u000A error is signalled, <v>val</v> is the ``reason'' <v>ld</v> terminated and is one \u000A of <v>:exit</v> (meaning <v>:</v><tt><see topic=\"ACL2____Q\">q</see></tt> was read), <v>:eof</v> (meaning the input \u000A source was exhausted), <v>:error</v> (meaning an error occurred but has been \u000A suppressed), <v>:filter</v> (meaning the <tt><see topic=\"ACL2____LD-PRE-EVAL-FILTER\">ld-pre-eval-filter</see></tt> terminated \u000A <v>ld</v>), or a cons pair whose first component is the symbol <v>:STOP-LD</v>, \u000A which typically indicates that an error occurred while the value of variable \u000A <v>'</v><tt><see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see></tt> was <v>:RETURN!</v>.  See <see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see> \u000A for details of this last case.</p>"],

 "ACL2____IO":[["Interfacing-tools","State","Programming"],"ACL2 Sources","ACL2","<code>Example:\u000A(<see topic=\"ACL2____MV-LET\">mv-let</see>\u000A  (channel state)\u000A  (<see topic=\"ACL2____OPEN-INPUT-CHANNEL\">open-input-channel</see> &quot;foo.lisp&quot; :object state)\u000A  (<see topic=\"ACL2____MV-LET\">mv-let</see> (eofp obj state)\u000A          (<see topic=\"ACL2____READ-OBJECT\">read-object</see> channel state)\u000A          (.\u000A            .\u000A             (<see topic=\"COMMON-LISP____LET\">let</see> ((<see topic=\"ACL2____STATE\">state</see> (<see topic=\"ACL2____CLOSE-INPUT-CHANNEL\">close-input-channel</see> channel state)))\u000A                   (<see topic=\"ACL2____MV\">mv</see> final-ans state))..)))</code> \u000A \u000A <p>Also see <see topic=\"ACL2____STD_F2IO\">std/io</see> and <see topic=\"ACL2____FILE-READING-EXAMPLE\">file-reading-example</see>.</p> \u000A \u000A <p>For advanced ways to control printing, see <see topic=\"ACL2____PRINT-CONTROL\">print-control</see>.</p> \u000A \u000A <p>For a discussion of formatted printing, see <see topic=\"ACL2____FMT\">fmt</see>.</p> \u000A \u000A <p>To control ACL2 abbreviation (``evisceration'') of objects before printing \u000A them, see <see topic=\"ACL2____SET-EVISC-TUPLE\">set-evisc-tuple</see>, see <see topic=\"ACL2____WITHOUT-EVISC\">without-evisc</see>, and see <see topic=\"ACL2____SET-IPRINT\">set-iprint</see>.</p> \u000A \u000A <p>To redirect output to a file, see <see topic=\"ACL2____OUTPUT-TO-FILE\">output-to-file</see>.</p> \u000A \u000A <p>ACL2 supports input and output facilities equivalent to a subset of those \u000A found in Common Lisp.  ACL2 does not support random access to files or \u000A bidirectional streams.  In Common Lisp, input and output are to or from \u000A objects of type <v>stream</v>.  In ACL2, input and output are to or from objects \u000A called ``channels,'' which are actually symbols.  Although a channel is a \u000A symbol, one may think of it intuitively as corresponding to a Common Lisp \u000A stream.  Channels are in one of two ACL2 packages, <v>&quot;ACL2-INPUT-CHANNEL&quot;</v> \u000A and <v>&quot;ACL2-OUTPUT-CHANNEL&quot;</v>.  When one ``opens'' a file one gets back a \u000A channel whose <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> is the file name passed to ``open,'' \u000A postfixed with <v>-n</v>, where <v>n</v> is a counter that is incremented every \u000A time an open or close occurs.</p> \u000A \u000A <p>There are three channels which are open from the beginning and which cannot \u000A be closed:</p> \u000A \u000A <code>acl2-input-channel::standard-character-input-0\u000Aacl2-input-channel::standard-object-input-0\u000Aacl2-input-channel::standard-character-output-0</code> \u000A \u000A <p>All three of these are really Common Lisp's <v>*standard-input*</v> or \u000A <v>*standard-output*</v>, appropriately.</p> \u000A \u000A <p>For convenience, three global variables are bound to these rather tedious \u000A channel names:</p> \u000A \u000A <code>*standard-ci*\u000A*standard-oi*\u000A*standard-co*</code> \u000A \u000A <p>Common Lisp permits one to open a stream for several different kinds of \u000A <v>io</v>, e.g. character or byte.  ACL2 permits an additional type called \u000A ``object''.  In ACL2 an ``io-type'' is a keyword, either <v>:character</v>, \u000A <v>:byte</v>, or <v>:object</v>.  When one opens a file, one specifies a type, \u000A which determines the kind of io operations that can be done on the channel \u000A returned.  The types <v>:character</v> and <v>:byte</v> are familiar.  Type \u000A <v>:object</v> is an abstraction not found in Common Lisp.  An <v>:object</v> file \u000A is a file of Lisp objects.  One uses <v>read-object</v> to read from \u000A <v>:object</v> files and <v>print-object$</v> (or <v>print-object$-ser</v>) to print \u000A to <v>:object</v> files.  (The reading and printing are really done with the \u000A Common Lisp <v>read</v> and <v>print</v> functions.  For those familiar with \u000A <v>read</v>, we note that the <v>recursive-p</v> argument is <v>nil</v>.)  The \u000A function <v>read-object-suppress</v> is logically the same as <v>read-object</v> \u000A except that <v>read-object-suppress</v> throws away the second returned value, \u000A i.e. the value that would normally be read, simply returning <v>(<see topic=\"ACL2____MV\">mv</see> eof\u000A state)</v>; under the hood, <v>read-object-suppress</v> avoids errors, for example \u000A those caused by encountering symbols in packages unknown to ACL2.</p> \u000A \u000A <p>File-names are strings.  ACL2 does not support the Common Lisp type <tt><see topic=\"COMMON-LISP____PATHNAME\">pathname</see></tt>.  However, for the <v>file-name</v> argument of the output-related \u000A functions listed below, ACL2 supports a special value, <v>:STRING</v>.  For this \u000A value, the channel connects (by way of a Common Lisp output string stream) to \u000A a string rather than to a file: as characters are written to the channel they \u000A can be retrieved by using <v>get-output-stream-string$</v>.</p> \u000A \u000A <p>Here are the names, formals and output descriptions of the ACL2 io \u000A functions.</p> \u000A \u000A <code>Input Functions:\u000A  (<see topic=\"ACL2____OPEN-INPUT-CHANNEL\">open-input-channel</see> (file-name io-type state) (<see topic=\"ACL2____MV\">mv</see> channel state))\u000A  (<see topic=\"ACL2____OPEN-INPUT-CHANNEL-P\">open-input-channel-p</see> (channel io-type state) boolean)\u000A  (<see topic=\"ACL2____CLOSE-INPUT-CHANNEL\">close-input-channel</see> (channel state) state)\u000A  (<see topic=\"ACL2____READ-CHAR_42\">read-char$</see> (channel state) (<see topic=\"ACL2____MV\">mv</see> char/nil state)) ; nil for EOF\u000A  (<see topic=\"ACL2____PEEK-CHAR_42\">peek-char$</see> (channel state) boolean)\u000A  (<see topic=\"ACL2____READ-BYTE_42\">read-byte$</see> (channel state) (<see topic=\"ACL2____MV\">mv</see> byte/nil state)) ; nil for EOF\u000A  (<see topic=\"ACL2____READ-OBJECT\">read-object</see> (channel state) (<see topic=\"ACL2____MV\">mv</see> eof-read-flg obj-read state))\u000A  (read-object-suppress (channel state) (<see topic=\"ACL2____MV\">mv</see> eof-read-flg state))\u000A\u000AOutput Functions:\u000A  (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL\">open-output-channel</see>  (file-name io-type state) (<see topic=\"ACL2____MV\">mv</see> channel state))\u000A  (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL_12\">open-output-channel!</see> (file-name io-type state) (<see topic=\"ACL2____MV\">mv</see> channel state))\u000A  (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL-P\">open-output-channel-p</see> (channel io-type state) boolean)\u000A  (<see topic=\"ACL2____CLOSE-OUTPUT-CHANNEL\">close-output-channel</see> (channel state) state)\u000A  (<see topic=\"ACL2____PRINC_42\">princ$</see> (obj channel state) state)\u000A  (<see topic=\"ACL2____WRITE-BYTE_42\">write-byte$</see> (byte channel state) state)\u000A  (<see topic=\"ACL2____PRINT-OBJECT_42\">print-object$</see> (obj channel state) state)\u000A  (print-object$-ser (obj serialize-character channel state) state)\u000A  (<see topic=\"ACL2____FMS\">fms</see>  (<see topic=\"COMMON-LISP____STRING\">string</see> alist channel state evisc-tuple) state)\u000A  (<see topic=\"ACL2____FMS_12\">fms!</see> (<see topic=\"COMMON-LISP____STRING\">string</see> alist channel state evisc-tuple) state)\u000A  (<see topic=\"ACL2____FMT\">fmt</see>  (<see topic=\"COMMON-LISP____STRING\">string</see> alist channel state evisc-tuple) (<see topic=\"ACL2____MV\">mv</see> col state))\u000A  (<see topic=\"ACL2____FMT_12\">fmt!</see> (<see topic=\"COMMON-LISP____STRING\">string</see> alist channel state evisc-tuple) (<see topic=\"ACL2____MV\">mv</see> col state))\u000A  (<see topic=\"ACL2____FMT1\">fmt1</see> (<see topic=\"COMMON-LISP____STRING\">string</see> alist col channel state evisc-tuple) (<see topic=\"ACL2____MV\">mv</see> col state))\u000A  (<see topic=\"ACL2____FMT1_12\">fmt1!</see> (<see topic=\"COMMON-LISP____STRING\">string</see> alist col channel state evisc-tuple) (<see topic=\"ACL2____MV\">mv</see> col state))\u000A  (<see topic=\"ACL2____CW\">cw</see> (<see topic=\"COMMON-LISP____STRING\">string</see> arg0 arg1 ... argn) nil)\u000A  (<see topic=\"ACL2____GET-OUTPUT-STREAM-STRING_42\">get-output-stream-string$</see> (channel state\u000A                              &amp;optional (close-p 't)\u000A                                        (ctx ''get-output-stream-string$))\u000A                             (<see topic=\"ACL2____MV\">mv</see> erp string state))</code> \u000A \u000A <p>The ``formatting'' functions are particularly useful; see <see topic=\"ACL2____FMT\">fmt</see> and \u000A see <see topic=\"ACL2____CW\">cw</see>.  In particular, <tt><see topic=\"ACL2____CW\">cw</see></tt> prints to a ``comment window'' and \u000A does not involve the ACL2 <tt><see topic=\"ACL2____STATE\">state</see></tt>, so many may find it easier to use \u000A than <tt><see topic=\"ACL2____FMT\">fmt</see></tt> and its variants.  The functions <tt><see topic=\"ACL2____FMS_12\">fms!</see></tt>, <tt><see topic=\"ACL2____FMT_12\">fmt!</see></tt>, \u000A and <tt><see topic=\"ACL2____FMT1_12\">fmt1!</see></tt> are the same as their respective functions without the \u000A ``<v>!</v>,'' except that the ``<v>!</v>'' functions are guaranteed to print forms \u000A that can be read back in (at a slight readability cost).</p> \u000A \u000A <p>When one enters ACL2 with <v>(<see topic=\"ACL2____LP\">lp</see>)</v>, input and output are taken from <tt><see topic=\"ACL2_____A2STANDARD-OI_A2\">*standard-oi*</see></tt> to <tt><see topic=\"ACL2_____A2STANDARD-CO_A2\">*standard-co*</see></tt>.  Because these are synonyms for \u000A <v>*standard-input*</v> and <v>*standard-output*</v>, one can drive ACL2 io off of \u000A arbitrary Common Lisp streams, bound to <v>*standard-input*</v> and \u000A <v>*standard-output*</v> before entry to ACL2.</p> \u000A \u000A <p>The macro <v>get-output-stream-string$</v> returns the string accumulated \u000A into the given channel.  By default, a call of this macro closes the supplied \u000A output channel.  However, a third argument is optional (default <v>t</v>), and \u000A if it evaluates to <v>nil</v> then the channel remains open.  The fourth \u000A argument is an optional context, which generally evaluates to a symbol, for \u000A error reporting.  The following example illustrates.</p> \u000A \u000A <code>ACL2 !&gt;\u000A(<see topic=\"ACL2____MV-LET\">mv-let</see>\u000A   (channel state)\u000A   (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL\">open-output-channel</see> :string :object state)\u000A   (<see topic=\"ACL2____PPROGN\">pprogn</see> (print-object$-ser 17 nil channel state)\u000A           (print-object$-ser '(a b (c d)) nil channel state)\u000A           (er-let*\u000A             ((str1 (<see topic=\"ACL2____GET-OUTPUT-STREAM-STRING_42\">get-output-stream-string$</see>\u000A                     channel state\u000A                     nil))) ; keep the channel open\u000A             (<see topic=\"ACL2____PPROGN\">pprogn</see> (print-object$-ser 23 nil channel state)\u000A                     (print-object$-ser '((e f)) nil channel state)\u000A                     (er-let* ; close the channel\u000A                       ((str2 (<see topic=\"ACL2____GET-OUTPUT-STREAM-STRING_42\">get-output-stream-string$</see> channel state)))\u000A                       (value (<see topic=\"COMMON-LISP____CONS\">cons</see> str1 str2)))))))\u000A (&quot;\u000A17\u000A(A B (C D))&quot; . &quot;\u000A23\u000A((E F))&quot;)\u000AACL2 !&gt;</code> \u000A \u000A <p>Also see <see topic=\"ACL2____PRINTING-TO-STRINGS\">printing-to-strings</see> for a discussion of formatted printing \u000A functions such as <v>fmt-to-string</v> that do not take a channel or <tt><see topic=\"ACL2____STATE\">state</see></tt> argument and return a string.</p> \u000A \u000A <p>By default, symbols are printed in upper case when vertical bars are not \u000A required, as specified by Common Lisp.  See <see topic=\"ACL2____SET-PRINT-CASE\">set-print-case</see> for how to \u000A get ACL2 to print symbols in lower case.</p> \u000A \u000A <p>By default, numbers are printed in radix 10 (base 10).  See <see topic=\"ACL2____SET-PRINT-BASE-RADIX\">set-print-base-radix</see> for how to get ACL2 to print numbers in radix 2, 8, or \u000A 16.</p> \u000A \u000A <p>To see the <see topic=\"ACL2____GUARD\">guard</see> of an IO function, or indeed any function, see \u000A <see topic=\"ACL2____ARGS\">args</see> or call the function <v>guard</v>; but some built-in functions \u000A (including some IO functions) will print the result using the variable \u000A <v>STATE-STATE</v>.  While that is logically correct, if you want to execute the \u000A guard then you should replace that variable by <v>STATE</v> and also replace \u000A each built-in function symbol of the form <v>xxx-p1</v> by corresponding \u000A function symbol <v>xxx-p</v>.  Consider the following example.</p> \u000A \u000A <code>ACL2 !&gt;:args princ$\u000A\u000AFunction         PRINC$\u000AFormals:         (X CHANNEL STATE-STATE)\u000ASignature:       (<see topic=\"ACL2____PRINC_42\">PRINC$</see> * * STATE)\u000A                 =&gt; STATE\u000AGuard:           (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____OR\">OR</see> (<see topic=\"ACL2____ACL2-NUMBERP\">ACL2-NUMBERP</see> X)\u000A                          (<see topic=\"COMMON-LISP____CHARACTERP\">CHARACTERP</see> X)\u000A                          (<see topic=\"COMMON-LISP____STRINGP\">STRINGP</see> X)\u000A                          (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> X))\u000A                      (STATE-P1 STATE-STATE)\u000A                      (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> CHANNEL)\u000A                      (OPEN-OUTPUT-CHANNEL-P1 CHANNEL\u000A                                              :CHARACTER STATE-STATE))\u000AGuards Verified: T\u000ADefun-Mode:      :logic\u000AType:            (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> (<see topic=\"ACL2____PRINC_42\">PRINC$</see> X CHANNEL STATE-STATE))\u000ADocumentation available via :DOC\u000A PRINC$\u000AACL2 !&gt;(<see topic=\"ACL2____UNTRANSLATE\">untranslate</see> (<see topic=\"ACL2____GUARD\">guard</see> 'princ$ nil (w state)) t (w state))\u000A(<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____OR\">OR</see> (<see topic=\"ACL2____ACL2-NUMBERP\">ACL2-NUMBERP</see> X)\u000A         (<see topic=\"COMMON-LISP____CHARACTERP\">CHARACTERP</see> X)\u000A         (<see topic=\"COMMON-LISP____STRINGP\">STRINGP</see> X)\u000A         (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> X))\u000A     (STATE-P1 STATE-STATE)\u000A     (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> CHANNEL)\u000A     (OPEN-OUTPUT-CHANNEL-P1 CHANNEL\u000A                             :CHARACTER STATE-STATE))\u000AACL2 !&gt;</code> \u000A \u000A <p>If you want to execute the guard for <tt><see topic=\"ACL2____PRINC_42\">princ$</see></tt>, then according to the \u000A suggestion above, you should consider the guard for <v>(<see topic=\"ACL2____PRINC_42\">princ$</see> x channel\u000A state)</v> to be as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____OR\">OR</see> (<see topic=\"ACL2____ACL2-NUMBERP\">ACL2-NUMBERP</see> X)\u000A         (<see topic=\"COMMON-LISP____CHARACTERP\">CHARACTERP</see> X)\u000A         (<see topic=\"COMMON-LISP____STRINGP\">STRINGP</see> X)\u000A         (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> X))\u000A     (STATE-P STATE)\u000A     (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> CHANNEL)\u000A     (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL-P\">OPEN-OUTPUT-CHANNEL-P</see> CHANNEL :CHARACTER STATE))</code> \u000A \u000A <p>For example, we can check the guard for a given value and channel as \u000A follows.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____LET\">let</see> ((x 3) (channel *standard-co*))\u000A         (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____OR\">OR</see> (<see topic=\"ACL2____ACL2-NUMBERP\">ACL2-NUMBERP</see> X)\u000A                  (<see topic=\"COMMON-LISP____CHARACTERP\">CHARACTERP</see> X)\u000A                  (<see topic=\"COMMON-LISP____STRINGP\">STRINGP</see> X)\u000A                  (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> X))\u000A              (STATE-P STATE)\u000A              (<see topic=\"COMMON-LISP____SYMBOLP\">SYMBOLP</see> CHANNEL)\u000A              (<see topic=\"ACL2____OPEN-OUTPUT-CHANNEL-P\">OPEN-OUTPUT-CHANNEL-P</see> CHANNEL :CHARACTER STATE)))\u000AT\u000AACL2 !&gt;</code> \u000A \u000A <p>Comment for advanced users: Function <tt><see topic=\"ACL2____OPEN-OUTPUT-CHANNEL_12\">open-output-channel!</see></tt> is \u000A identical as a function to <v>open-output-channel</v>, except that the former \u000A may be called even during <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> expansion and <tt><see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see></tt> <see topic=\"ACL2____HINTS\">hints</see>, but requires that there is an active trust tag \u000A (see <see topic=\"ACL2____DEFTTAG\">defttag</see>).</p> \u000A \u000A <p>Finally, we note that the <see topic=\"ACL2____STD_F2IO\">std/io</see> library contains useful file io \u000A functions whose definitions illustrate some of the features described \u000A above.</p>"],

 "ACL2____INTRODUCTION-TO-THE-THEOREM-PROVER":[["ACL2-tutorial"],"ACL2 Sources","ACL2","<p>Software is complex, and ACL2 is a piece of software that is used \u000A to analyze software -- adding another layer of complexity.  Furthermore, \u000A instead of being limited to static analysis for certain fixed properties, ACL2 \u000A allows you -- indeed, forces you -- to formalize the problem and the \u000A questions.  It ``knows'' nothing inherent about your problem before you start \u000A to interact with it.  But it can be used to help answer the most complicated \u000A questions you can ask about software.</p> \u000A \u000A <p>All this is to say that it is not the kind of tool that you just install \u000A and then start to use effectively.  So OK, you've installed it or confirmed \u000A that you can invoke it.  Good for you.  Now you have to learn how to use it! \u000A Your success ultimately comes down to your understanding of your problem \u000A domain and your appropriate exploitation of ACL2's strengths and avoidance of \u000A its weaknesses.  So put aside the idea of sitting down and interacting with \u000A it.  Instead, learn about it.</p> \u000A \u000A <p>We assume you know some of the <see topic='ACL2____INTERESTING-APPLICATIONS'>industrial applications</see> of ACL2.  Realizing \u000A that such things can be done may sustain you during the long learning curve! \u000A We also assume you have taken both the <see topic='ACL2____A_02Flying_02Tour_02of_02ACL2'>Flying Tour</see> and the <see topic='ACL2____A_02Walking_02Tour_02of_02ACL2'>Walking Tour</see>.  The tours give you a good \u000A overview of the whole system where this tutorial focuses on how to use the \u000A prover itself.</p> \u000A \u000A <p>If you haven't visited these links, please do so now.</p> \u000A \u000A <p>This tutorial will take you several hours -- maybe several days -- to work \u000A through.  Do not breeze through it as you might a blog.  <i>Think</i> your way \u000A through it.  <i>Remember</i> what you read.  Do not take short cuts.  If you \u000A start to use ACL2 before you really know how, it will only frustrate you.</p> \u000A \u000A <p>We recommend that you read this tutorial with an HTML browser so that you \u000A can see which links you've followed and which you have not.  To give you a \u000A sense of what is in store, here is a map of this document.  But don't navigate \u000A through it from here! Read it linearly, following the links when the text \u000A directs you to.</p> \u000A \u000A <code><see topic=\"ACL2____INTRODUCTION-TO-THE-THEOREM-PROVER\">introduction-to-the-theorem-prover</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-1\">introduction-to-rewrite-rules-part-1</see> \u000A        <see topic=\"ACL2____SPECIAL-CASES-FOR-REWRITE-RULES\">special-cases-for-rewrite-rules</see> \u000A        <see topic=\"ACL2____EQUIVALENT-FORMULAS-DIFFERENT-REWRITE-RULES\">equivalent-formulas-different-rewrite-rules</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-KEY-CHECKPOINTS\">introduction-to-key-checkpoints</see> \u000A        <see topic=\"ACL2____DEALING-WITH-KEY-COMBINATIONS-OF-FUNCTION-SYMBOLS\">dealing-with-key-combinations-of-function-symbols</see> \u000A        <see topic=\"ACL2____GENERALIZING-KEY-CHECKPOINTS\">generalizing-key-checkpoints</see> \u000A        <see topic=\"ACL2____POST-INDUCTION-KEY-CHECKPOINTS\">post-induction-key-checkpoints</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-2\">introduction-to-rewrite-rules-part-2</see> \u000A        <see topic=\"ACL2____STRONG-REWRITE-RULES\">strong-rewrite-rules</see> \u000A            <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES\">practice-formulating-strong-rules</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-1\">practice-formulating-strong-rules-1</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-2\">practice-formulating-strong-rules-2</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-3\">practice-formulating-strong-rules-3</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-4\">practice-formulating-strong-rules-4</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-5\">practice-formulating-strong-rules-5</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-6\">practice-formulating-strong-rules-6</see> \u000A        <see topic=\"ACL2____SPECIFIC-KINDS-OF-FORMULAS-AS-REWRITE-RULES\">specific-kinds-of-formulas-as-rewrite-rules</see> \u000A        <see topic=\"ACL2____FURTHER-INFORMATION-ON-REWRITING\">further-information-on-rewriting</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-THE-DATABASE\">introduction-to-the-database</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-HINTS\">introduction-to-hints</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-A-FEW-SYSTEM-CONSIDERATIONS\">introduction-to-a-few-system-considerations</see> \u000A    <see topic=\"ACL2____INTRODUCTORY-CHALLENGES\">introductory-challenges</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-1\">introductory-challenge-problem-1</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-2\">introductory-challenge-problem-2</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-3\">introductory-challenge-problem-3</see> \u000A        <i>(there are others but at least do a few)</i> \u000A    <see topic=\"ACL2____FREQUENTLY-ASKED-QUESTIONS-BY-NEWCOMERS\">frequently-asked-questions-by-newcomers</see> \u000A </code> \u000A \u000A <p>If any of the links above are marked as ``visited'' by your browser, use \u000A your browser's tools menu to mark all links as unvisited.  As you can see, we \u000A really think you'll get the most out of this document if you take it \u000A seriously.  As you read, you will see some links to ``advanced'' topics. \u000A These are marked with a tiny warning sign, ``<see \u000A topic='ACL2____A_02Tiny_02Warning_02Sign'><icon src='res/tours/twarning.gif'/></see>''. \u000A They lead out of this linear tutorial and into ACL2's hypertext reference \u000A manual.  We recommend that you <i>not</i> visit any of these advanced links \u000A until you have read the entire tutorial at least once.</p> \u000A \u000A <p>After you finish this tutorial material, we recommend that you look at the \u000A ACL2 Demos, at the ``Demos'' link of the <a \u000A href='http://www.cs.utexas.edu/users/moore/acl2'>ACL2 home page</a>.</p> \u000A \u000A <p>Most users of ACL2 have bought the book</p> \u000A \u000A <p><i>Computer-Aided Reasoning: An Approach</i>, Kaufmann, Manolios, and \u000A Moore, Kluwer Academic Publishers, June, 2000</p> \u000A \u000A <p>which is available <a href='http://www.lulu.com/content/1746161'>in \u000A paperback</a> from Lulu for approximately $20 (as of 2010).  That book \u000A contains hundreds of exercises in programming, proof, and using The Method \u000A described here to prove theorems.  Solutions to the exercises are online, as \u000A are <a \u000A href='http://link.springer.com/content/pdf/bbm%3A978-1-4615-4449-4%2F1.pdf'>appendices</a> \u000A that focus on some practical usage aspects.  See this <a \u000A href='http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html#Books'> \u000A web page about the book</a>, which also includes information about its \u000A companion (also available on Lulu) describing applications of ACL2, some of \u000A which are from industry.</p> \u000A \u000A <p>Using ACL2 is akin to having a partner in the theorem proving enterprise. \u000A It will do some of the work and you will do some of the work.  It can't really \u000A be any other way because theorem proving is undecidable.  You bring a quirkly, \u000A error-prone, creative insight to the problem, and ACL2 brings accuracy, logic, \u000A and perserverance.</p> \u000A \u000A <p>Here we describe a ``model'' of how the system works and introduce some of \u000A the ideas and terminology you'll use repeatedly when interacting with it.</p> \u000A \u000A <p>This article is about the <i>theorem prover</i> itself, not the programming \u000A language and not the logic.  We assume you know enough about the ACL2 \u000A programming language that you can define simple functions, run them, and read \u000A and write ACL2 constants and terms.  For some examples of what we'll take for \u000A granted about ACL2 programming, see <see topic=\"ACL2____PROGRAMMING-KNOWLEDGE-TAKEN-FOR-GRANTED\">programming-knowledge-taken-for-granted</see>.</p> \u000A \u000A <p>We also assume you know enough about logic to understand, for example, the \u000A words we use to talk about formulas and proofs.  To see some examples of what \u000A we'll take for granted about your knowledge of logic terminology, see <see topic=\"ACL2____LOGIC-KNOWLEDGE-TAKEN-FOR-GRANTED\">logic-knowledge-taken-for-granted</see>.</p> \u000A \u000A <p>When you give the theorem prover a goal formula to prove, it tries to prove \u000A it by breaking it down into subgoals, each of which must be proved in order to \u000A prove the original goal.  This breaking apart of the goal is done by various \u000A <i>proof techniques</i> built into ACL2.  Different proof techniques break the \u000A formula apart in different ways.  For example, the <i>simplifier</i> rips \u000A apart the propositional structure to isolate the various cases and applies \u000A rewrite rules to simplify the subterms of the formula, while the \u000A <i>induction</i> <i>engine</i> will attempt to break the goal into some base \u000A cases and some induction steps.</p> \u000A \u000A <p>The theorem prover's behavior is affected by a <i>database</i> of \u000A <i>rules</i> derived from axioms, definitions, and previously proved theorems. \u000A The database also records the <i>enabled status</i> of each rule; only enabled \u000A rules are seen by the prover and you can set the status of a rule.  There are \u000A many other user-settable switches and parameters affecting the behavior of the \u000A prover; you'll learn about some of them later.</p> \u000A \u000A <p>You guide the theorem prover most of the time simply by identifying lemmas \u000A for it to prove.  (A <i>lemma</i> is just a theorem that you think is useful \u000A in the proofs of other theorems.)</p> \u000A \u000A <p>Why does this guide the theorem prover?  Because every time you get the \u000A system to prove a theorem, it turns the theorem into a rule (unless you tell \u000A it not to) and stores the rule in the database.  That changes how the prover \u000A behaves subsequently.  But <i>you</i> determine the kind of rule ACL2 \u000A stores.</p> \u000A \u000A <p>To learn to ``drive'' the theorem prover you have to learn how various \u000A rules affect the system's behavior and how it turns proved formulas into \u000A rules.  But before we discuss this, we discuss a more mathematical activity: \u000A how do you figure out the lemmas ACL2 will need in order for it to prove \u000A interesting theorems?  ACL2 can often help you in this activity, if you use it \u000A in the right way.</p> \u000A \u000A <p>Here is the way we recommend you use ACL2.</p> \u000A \u000A <p><b>The Method</b>.</p> \u000A \u000A <p>(1) you present ACL2 with the goal conjecture to prove</p> \u000A \u000A <p>(2) typically, it fails to prove it (or you abort its attempt), but it \u000A prints some <i>Key Checkpoints</i></p> \u000A \u000A <p>(3) you look at the Key Checkpoints and decide that you know a fact that \u000A will help; this tutorial will present some helpful questions to keep in \u000A mind</p> \u000A \u000A <p>(4) you formalize your knowledge as a formula, along with directions for \u000A how ACL2 should turn the formula into a rule; this tutorial will tell you \u000A about the most commonly used rule, the <i>rewrite</i> rule</p> \u000A \u000A <p>(5) you recursively apply The Method to get ACL2 to prove your formula and \u000A to store it as the kind of rule you specified</p> \u000A \u000A <p>(6) go to step (1)</p> \u000A \u000A <p>Caveat: This approach simply won't work on some theorems!  Basically, this \u000A is a ``troubleshooting'' approach, where you're letting ACL2 determine the \u000A basic strategy and you're just helping with the subgoals.  But for some \u000A theorems, ACL2's approach will be misguided and no amount of troubleshooting \u000A will salvage its strategy.  You'll have a sense that this is happening when it \u000A happens because the formulas ACL2 presents to you will raise issues that feel \u000A irrelevant to you.  The basic truth is that if you think a formula is always \u000A true there are usually strong intuitive reasons behind your belief.  If you \u000A were asked to defend your belief, you'd start to explain your reasons and with \u000A training you can turn that into a proof.  So when ACL2's formulas present you \u000A with things you haven't thought of either (a) you'll have an ``Ah ha!'' \u000A moment when you realize you hadn't considered that case or (b) you'll realize \u000A that ACL2's approach is different from your intuitive ``proof.''</p> \u000A \u000A <p>But, surprisingly often, the troubleshooting approach to finding proofs \u000A works quite well, especially as you rein in your expectations and develop a \u000A sense of what ACL2 can handle on its own.  Of course, if you can decompose the \u000A proof into a couple of main lemmas before you start, so much the better: write \u000A down your sequence of lemmas, thinking about the rules you want them to \u000A generate, and get ACL2 to prove each of them before giving it the main \u000A theorem.  This <i>proof planning</i> approach will gradually become an \u000A integral part of your use of The Method.</p> \u000A \u000A <p>The only mechanized help we can offer with The Method, aside from the \u000A theorem prover itself, are tools to help you manage the stack of subgoals it \u000A generates when, in step (5) you recursively apply The Method to a lemma. \u000A There are both Emacs and Eclipse tools available.</p> \u000A \u000A <p>To use The Method you have to read the Key Checkpoints printed at the very \u000A end of <i>failed</i> proof attempts, just after the line that reads:</p> \u000A \u000A <code>The key checkpoint goals, below, may help you to debug this failure.</code> \u000A \u000A <p>Most users do not read the output from successful proofs and do not read \u000A the output <i>during</i> a proof -- they just let it stream by as a sort of \u000A gestalt meter on the theorem prover's progress or lack thereof.  For example, \u000A you'll be able to tell it is in a loop and needs to be interrupted.</p> \u000A \u000A <p>You will respond to most Key Checkpoints by formulating new lemmas for the \u000A system to prove and store as rules designed by you to alter ACL2's behavior so \u000A that it proves the Key Checkpoints.  You will give each lemma a <i>name</i> \u000A and write some <i>formula</i> to express the mathematical idea.  You'll \u000A command ACL2 to prove it by typing:</p> \u000A \u000A <code>(defthm <i>name</i> \u000A        <i>formula</i> \u000A        ...) \u000A</code> \u000A \u000A <p>In the ``...'' you may provide two other kinds of information: <i>hints</i> \u000A for how to prove <i>formula</i> and directives, called <i>rule-classes</i>, \u000A for how to convert <i>formula</i> into a rule after it has proved \u000A <i>formula</i>.  Note that <i>you</i> are in charge of determining what kind \u000A of rule ACL2 generates!  There are over a dozen different types of rules with \u000A many opportunities to specialize each type.  But the most common kind of rule \u000A you'll want to generate is a <i>rewrite</i> rule.</p> \u000A \u000A <p>We recommend that you read the following topics in the following order, \u000A without skipping anything except links into the ACL2 User's Manual, which are \u000A marked by the little warning sign, ``<see \u000A topic='ACL2____A_02Tiny_02Warning_02Sign'><icon \u000A src='res/tours/twarning.gif'/></see>''.</p> \u000A \u000A <p>(1) See <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-1\">introduction-to-rewrite-rules-part-1</see> to read about the use \u000A and design of rewrite rules.</p> \u000A \u000A <p>(2) See <see topic=\"ACL2____INTRODUCTION-TO-KEY-CHECKPOINTS\">introduction-to-key-checkpoints</see> to see how to use The Method \u000A to help you design rules.</p> \u000A \u000A <p>(3) See <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-2\">introduction-to-rewrite-rules-part-2</see> for general guidance on \u000A how to turn formulas into effective rules.</p> \u000A \u000A <p>(4) See <see topic=\"ACL2____INTRODUCTION-TO-THE-DATABASE\">introduction-to-the-database</see> to see how to issue commands \u000A that build different kinds of rules and that affect the enabled status of \u000A existing rules.</p> \u000A \u000A <p>(5) See <see topic=\"ACL2____INTRODUCTION-TO-HINTS\">introduction-to-hints</see> to see how to give the prover hints \u000A for how to prove specific theorems or even subgoals of specific proof \u000A attempts.</p> \u000A \u000A <p>(6) See <see topic=\"ACL2____INTRODUCTION-TO-A-FEW-SYSTEM-CONSIDERATIONS\">introduction-to-a-few-system-considerations</see> for a few words \u000A about system aspects of interacting with ACL2.</p> \u000A \u000A <p>(7) See <see topic=\"ACL2____INTRODUCTORY-CHALLENGES\">introductory-challenges</see> for a graduated sequence of good \u000A challenge problems for the new user to tackle.  <b>Do not skip this \u000A section!</b> It is here that you <i>really</i> learn how to use ACL2 -- by \u000A using it.</p> \u000A \u000A <p>(8) See <see topic=\"ACL2____FREQUENTLY-ASKED-QUESTIONS-BY-NEWCOMERS\">frequently-asked-questions-by-newcomers</see> for a list of \u000A questions that new users frequently ask, answered mainly by providing links \u000A into the ACL2 User's Manual.  We recommend that you skim through these \u000A questions and remember that you can find the answers here later.  We are very \u000A interested in receiving suggestions for how to improve this FAQ and this \u000A tutorial.  See the ACL2 home page, specifically the link ``Mailing \u000A Lists''.</p> \u000A \u000A <p>Please read all of the material cited above (skipping only the ACL2 User's \u000A Manual links (``<see topic='ACL2____A_02Tiny_02Warning_02Sign'><icon \u000A src='res/tours/twarning.gif'/></see>'')) before you try to use ACL2 on problems of your \u000A own.</p> \u000A \u000A <p>By this point you should have read, at least, the following topics from \u000A this tutorial introduction to the theorem prover:</p> \u000A \u000A <code><see topic=\"ACL2____INTRODUCTION-TO-THE-THEOREM-PROVER\">introduction-to-the-theorem-prover</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-1\">introduction-to-rewrite-rules-part-1</see> \u000A        <see topic=\"ACL2____SPECIAL-CASES-FOR-REWRITE-RULES\">special-cases-for-rewrite-rules</see> \u000A        <see topic=\"ACL2____EQUIVALENT-FORMULAS-DIFFERENT-REWRITE-RULES\">equivalent-formulas-different-rewrite-rules</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-KEY-CHECKPOINTS\">introduction-to-key-checkpoints</see> \u000A        <see topic=\"ACL2____DEALING-WITH-KEY-COMBINATIONS-OF-FUNCTION-SYMBOLS\">dealing-with-key-combinations-of-function-symbols</see> \u000A        <see topic=\"ACL2____GENERALIZING-KEY-CHECKPOINTS\">generalizing-key-checkpoints</see> \u000A        <see topic=\"ACL2____POST-INDUCTION-KEY-CHECKPOINTS\">post-induction-key-checkpoints</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-REWRITE-RULES-PART-2\">introduction-to-rewrite-rules-part-2</see> \u000A        <see topic=\"ACL2____STRONG-REWRITE-RULES\">strong-rewrite-rules</see> \u000A            <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES\">practice-formulating-strong-rules</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-1\">practice-formulating-strong-rules-1</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-2\">practice-formulating-strong-rules-2</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-3\">practice-formulating-strong-rules-3</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-4\">practice-formulating-strong-rules-4</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-5\">practice-formulating-strong-rules-5</see> \u000A                <see topic=\"ACL2____PRACTICE-FORMULATING-STRONG-RULES-6\">practice-formulating-strong-rules-6</see> \u000A        <see topic=\"ACL2____SPECIFIC-KINDS-OF-FORMULAS-AS-REWRITE-RULES\">specific-kinds-of-formulas-as-rewrite-rules</see> \u000A        <see topic=\"ACL2____FURTHER-INFORMATION-ON-REWRITING\">further-information-on-rewriting</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-THE-DATABASE\">introduction-to-the-database</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-HINTS\">introduction-to-hints</see> \u000A    <see topic=\"ACL2____INTRODUCTION-TO-A-FEW-SYSTEM-CONSIDERATIONS\">introduction-to-a-few-system-considerations</see> \u000A    <see topic=\"ACL2____INTRODUCTORY-CHALLENGES\">introductory-challenges</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-1\">introductory-challenge-problem-1</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-2\">introductory-challenge-problem-2</see> \u000A        <see topic=\"ACL2____INTRODUCTORY-CHALLENGE-PROBLEM-3\">introductory-challenge-problem-3</see> \u000A        <i>(there are others but at least do a few)</i> \u000A    <see topic=\"ACL2____FREQUENTLY-ASKED-QUESTIONS-BY-NEWCOMERS\">frequently-asked-questions-by-newcomers</see> \u000A </code> \u000A \u000A <p>We also recommend that you look at the ACL2 Demos mentioned in the <see topic=\"ACL2____ACL2-TUTORIAL\">ACL2-tutorial</see>.</p> \u000A \u000A <p>Most users of ACL2 have bought the book</p> \u000A \u000A <p><i>Computer-Aided Reasoning: An Approach</i>, Kaufmann, Manolios, and \u000A Moore, Kluwer Academic Publishers, June, 2000</p> \u000A \u000A <p>which is <a href='http://www.lulu.com/content/1746161'>available in \u000A paperback from Lulu</a> for approximately $20 (as of 2010).  That book \u000A contains hundreds of exercises in programming, proof, and using The Method to \u000A prove theorems.  Solutions to the exercises are online.  See also this <a \u000A href='http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html#Books'> \u000A web page about the book</a>, which also includes information about its \u000A companion (also available on Lulu) describing applications of ACL2, some of \u000A which are from industry.</p> \u000A \u000A <p>Thank you for spending the time to get acquainted with the basics of the \u000A ACL2 theorem prover.  Don't hesitate to send further questions to the ACL2 \u000A Help address on the ``Mailing Lists'' link of the ACL2 home page.</p> \u000A \u000A <p><b>End of Tutorial Introduction to the Theorem Prover</b></p> \u000A \u000A <p>Below is a list of all of the topics cited on this page.</p>"],

 "ACL2____INCLUDE-BOOK":[["Books-reference","Books-tour","Events"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;my-arith&quot;)\u000A(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;/home/smith/my-arith&quot;)\u000A(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;/../../my-arith&quot;)\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> file :load-compiled-file action\u000A                   :uncertified-okp t/nil/:ignore-certs  ; [default t]\u000A                   :defaxioms-okp t/nil                  ; [default t]\u000A                   :skip-proofs-okp t/nil                ; [default t]\u000A                   :ttags ttags                          ; [default nil]\u000A                   :dir directory\u000A                   :doc doc-string)</code> \u000A \u000A <p>where <v>file</v> is a book name.  See <see topic=\"ACL2____BOOKS\">books</see> for general information, \u000A see <see topic=\"ACL2____BOOK-NAME\">book-name</see> for information about book names, and see <see topic=\"COMMON-LISP____PATHNAME\">pathname</see> \u000A for information about file names.  <v>Action</v> is one of <v>t</v>, <v>nil</v>, \u000A <v>:default</v>, <v>:warn</v>, or <v>:comp</v>; these values are explained below, \u000A and the default is <v>:default</v>.  The three <v>-okp</v> keyword arguments, \u000A which default to <v>t</v>, determine whether errors or warnings are generated \u000A under certain conditions explained below; when the argument is <v>t</v>, \u000A warnings are generated.  The <v>dir</v> argument, if supplied, is a keyword that \u000A represents an absolute pathname for a directory (see <see topic=\"COMMON-LISP____PATHNAME\">pathname</see>), to be \u000A used instead of the current book directory (see <see topic=\"ACL2____CBD\">cbd</see>) for resolving the \u000A given <v>file</v> argument to an absolute pathname.  In particular, by default \u000A <v>:dir :system</v> resolves <v>file</v> using the <v>books/</v> directory of your \u000A ACL2 installation, unless your ACL2 executable was built somewhere other than \u000A where it currently resides; please see the ``Books Directory'' below.  To \u000A define other keywords that can be used for <v>dir</v>, see <see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR\">add-include-book-dir</see>.  <v>Doc-string</v>, if non-<v>nil</v>, is an optional \u000A string that can provide documentation but is essentially ignored by ACL2.  If \u000A the book has no <tt><see topic=\"ACL2____CERTIFICATE\">certificate</see></tt>, if its <tt><see topic=\"ACL2____CERTIFICATE\">certificate</see></tt> is invalid or \u000A if the certificate was produced by a different <see topic=\"ACL2____VERSION\">version</see> of ACL2, a \u000A warning is printed and the book is included anyway; see <see topic=\"ACL2____CERTIFICATE\">certificate</see>. \u000A This can lead to serious errors, perhaps mitigated by the presence of a \u000A <v>.port</v> file from an earlier certification; see <see topic=\"ACL2____UNCERTIFIED-BOOKS\">uncertified-books</see>. \u000A If the portcullis of the <see topic=\"ACL2____CERTIFICATE\">certificate</see> (see <see topic=\"ACL2____PORTCULLIS\">portcullis</see>) cannot be \u000A raised in the host logical <see topic=\"ACL2____WORLD\">world</see>, an error is caused and no change \u000A occurs to the logic.  Otherwise, the non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> in file \u000A are assumed.  Then the <see topic=\"ACL2____KEEP\">keep</see> of the <see topic=\"ACL2____CERTIFICATE\">certificate</see> is checked to \u000A ensure that the correct files were read; see <see topic=\"ACL2____KEEP\">keep</see>.  A warning is \u000A printed if uncertified <see topic=\"ACL2____BOOKS\">books</see> were included.  Even if no warning is \u000A printed, <v>include-book</v> places a burden on you; see <see topic=\"ACL2____CERTIFICATE\">certificate</see>.</p> \u000A \u000A <p>If you use <see topic=\"ACL2____GUARD\">guard</see>s, please note <v>include-book</v> is executed as \u000A though <v>(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> nil)</v> has been evaluated; see <see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see>.  If you want guards checked, please see <see topic=\"ACL2____LD\">ld</see> and/or \u000A see <see topic=\"ACL2____REBUILD\">rebuild</see>.</p> \u000A \u000A <p>The value of <v>:load-compiled-file</v> controls whether a compiled file for \u000A the given <v>file</v> is loaded by <v>include-book</v>.  Note that this keyword \u000A applies only to the given <v>file</v>, not to any included sub-books.  In order \u000A to skip loading all compiled files, for the given <v>file</v> as well as all \u000A included sub-books &mdash; for example, to avoid Lisp errors such as ``Wrong \u000A FASL version'' &mdash; use <v>(<see topic=\"ACL2____SET-COMPILER-ENABLED\">set-compiler-enabled</see> nil state)</v>; see <see topic=\"ACL2____COMPILATION\">compilation</see>.  Otherwise, if keyword argument <v>:load-compiled-file</v> is \u000A missing or its value is the keyword <v>:default</v>, then it is treated as \u000A <v>:warn</v>.  If its value is <v>nil</v>, no attempt is made to load the compiled \u000A file for the book provided.  In order to load the compiled file, it must be \u000A more recent than the book's <see topic=\"ACL2____CERTIFICATE\">certificate</see> (except in raw mode, where it \u000A must be more recent than the book itself; see <see topic=\"ACL2____SET-RAW-MODE\">set-raw-mode</see>).  For \u000A non-<v>nil</v> values of <v>:load-compiled-file</v> that do not result in a loaded \u000A compiled file, ACL2 proceeds as follows.  Note that a load of a compiled file \u000A or expansion file aborts partway through whenever an <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> form \u000A is encountered for which no suitable compiled or expansion file can be loaded. \u000A For much more detail, see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>.</p> \u000A \u000A <blockquote> \u000A \u000A <p><v>t</v>: Cause an error if the compiled file is not loaded.  This same \u000A requirement is imposed on every <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> form evaluated during the \u000A course of evaluation of the present <v>include-book</v> form, except that for \u000A those subsidiary <v>include-book</v>s that do not themselves specify \u000A <v>:load-compiled-file t</v>, it suffices to load the expansion file (see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>).</p> \u000A \u000A <p><v>:warn</v>: An attempt is made to load the compiled file, and a warning is \u000A printed if that load fails to run to completion.</p> \u000A \u000A <p><v>:comp</v>: A compiled file is loaded as with value <v>t</v>, except that if \u000A a suitable ``expansion file'' exists but the compiled file does not, then the \u000A compiled file is first created.  See <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>.</p></blockquote> \u000A \u000A <p>The three <v>-okp</v> arguments, <v>:uncertified-okp</v>, <v>defaxioms-okp</v>, \u000A and <v>skip-proofs-okp</v>, determine the system's behavior when the book or any \u000A sub-book is found to be uncertified, when the book or any sub-book is found to \u000A contain <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> events, and when the book or any sub-book is found to \u000A contain <tt><see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see></tt> events, respectively.  All three default to \u000A <v>t</v>, which means it is ``ok'' for the condition to arise.  In this case, a \u000A warning is printed but the processing to load the book is allowed to proceed. \u000A When one of these arguments is <v>nil</v> and the corresponding condition \u000A arises, an error is signaled and processing is aborted.  <b>Exceptions</b>: \u000A <v>:uncertified-okp t</v> is ignored if the <v>include-book</v> is being performed \u000A on behalf of a <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>, and <v>:uncertified-okp :ignore-certs</v> \u000A is an advanced option explained later in this topic.</p> \u000A \u000A <p>The keyword argument <v>:ttags</v> may normally be omitted.  A few \u000A constructs, used for example if you are building your own system based on \u000A ACL2, may require it.  See <see topic=\"ACL2____DEFTTAG\">defttag</see> for an explanation of this \u000A argument.</p> \u000A \u000A <p><v>Include-book</v> is similar in spirit to <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> in that it is \u000A a single event that ``contains'' other <see topic=\"ACL2____EVENTS\">events</see>, in this case the <see topic=\"ACL2____EVENTS\">events</see> listed in the file named.  <v>Include-book</v> processes the non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> event forms in the file, assuming that each is admissible.  <tt><see topic=\"ACL2____LOCAL\">Local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> in the file are ignored.  You may use <v>include-book</v> \u000A to load several <see topic=\"ACL2____BOOKS\">books</see>, creating the logical <see topic=\"ACL2____WORLD\">world</see> that contains \u000A the definitions and theorems of all of them.</p> \u000A \u000A <p>If any non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> event of the book attempts to define a <see topic=\"ACL2____NAME\">name</see> \u000A that has already been defined &mdash; and the book's definition is not \u000A syntactically identical to the existing definition &mdash; the attempt to \u000A include the book fails, an error message is printed, and no change to the \u000A logical <see topic=\"ACL2____WORLD\">world</see> occurs.  See <see topic=\"ACL2____REDUNDANT-EVENTS\">redundant-events</see> for the details.</p> \u000A \u000A <p>When a book is included, the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> (see <see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see>) for the first event is always <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  That \u000A is, the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> ``outside'' the book &mdash; in the \u000A environment in which <v>include-book</v> was called &mdash; is irrelevant to the \u000A book.  <see topic=\"ACL2____EVENTS\">Events</see> that change the <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> are permitted within a \u000A book (provided they are not in <tt><see topic=\"ACL2____LOCAL\">local</see></tt> forms).  However, such changes \u000A within a book are not exported, i.e., at the conclusion of an \u000A <v>include-book</v>, the ``outside'' default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> is always the \u000A same as it was before the <v>include-book</v>.</p> \u000A \u000A <p>Unlike every other event in ACL2, <v>include-book</v> puts a burden on you. \u000A Used improperly, <v>include-book</v> can be unsound in the sense that it can \u000A create an inconsistent extension of a consistent logical <see topic=\"ACL2____WORLD\">world</see>.  A \u000A certification mechanism is available to help you carry this burden &mdash; but \u000A it must be understood up front that even certification is no guarantee against \u000A inconsistency here.  The fundamental problem is one of file system security. \u000A See <see topic=\"ACL2____CERTIFICATE\">certificate</see> for a discussion of the security issues.</p> \u000A \u000A <p>At the beginning of execution of an <v>include-book</v> form, even before \u000A executing <see topic=\"ACL2____PORTCULLIS\">portcullis</see> <see topic=\"ACL2____COMMAND\">command</see>s, the value of <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> is restored to the value it had at startup.  After \u000A execution of an <v>include-book</v> form, the value of <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> is restored to what it was immediately before that \u000A <v>include-book</v> form was executed.  See <see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see>.</p> \u000A \u000A <p>An advanced option is <v>:uncertified-okp :ignore-certs</v>.  This tells ACL2 \u000A to ignore all <see topic=\"ACL2____CERTIFICATE\">certificate</see> files while including the book and its \u000A sub-books, thus treating all these books as uncertified.  This option may be \u000A useful when writing a <v>.acl2x</v> file for the first ``run'' of a ``two-runs \u000A approach'' to certification; see <see topic=\"ACL2____SET-WRITE-ACL2X\">set-write-ACL2x</see>.  Note however that \u000A ordinary certification (the second ``run'') will then fail unless care is \u000A taken to avoid <v>:uncertified-okp :ignore-certs</v> during that second \u000A certification run.  Finally (and speaking in general, not particularly about a \u000A <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> context), we emphasize that the option \u000A <v>:uncertified-okp :ignore-certs</v> applies when including all sub-books, not \u000A only for the current book.  In particular, a subsidiary <v>include-book</v> call \u000A specifying <v>:uncertified-okp nil</v> will fail, because the superior \u000A <v>:ignore-certs</v> value causes the subsidiary book to be treated as \u000A uncertified, which conflicts with the requirement of <v>:uncertified-okp\u000A nil</v>.</p> \u000A \u000A <p><b>Books Directory.</b> We refer to the ``books directory'' of an \u000A executable image as the full pathname string of the directory associated with \u000A <v>include-book</v> keyword option <v>:dir :system</v> for that image.  By \u000A default, it is the <v>books/</v> subdirectory of the directory where the sources \u000A reside and the executable image is thus built (except for ACL2(r) &mdash; see \u000A <see topic=\"COMMON-LISP____REAL\">real</see> &mdash;, where it is <v>books/nonstd/</v>).  If those books reside \u000A elsewhere, the environment variable <v>ACL2_SYSTEM_BOOKS</v> can be set to the \u000A <v>books/</v> directory under which they reside (a Unix-style pathname, \u000A typically ending in <v>books/</v> or <v>books</v>, is permissible).  In most \u000A cases, your ACL2 executable is a small script in which you can set this \u000A environment variable just above the line on which the actual ACL2 image is \u000A invoked, for example:</p> \u000A \u000A <code>export ACL2_SYSTEM_BOOKS\u000AACL2_SYSTEM_BOOKS=/home/acl2/4-0/acl2-sources/books</code> \u000A \u000A <p>If you follow suggestions in the installation instructions, these books \u000A will be the ACL2 community books; see <see topic=\"ACL2____COMMUNITY-BOOKS\">community-books</see>.</p> \u000A \u000A <p>This concludes the guided tour through <see topic=\"ACL2____BOOKS\">books</see>.  See <see topic=\"ACL2____SET-COMPILE-FNS\">set-compile-fns</see> for a subtle point about the interaction between \u000A <v>include-book</v> and on-the-fly <see topic=\"ACL2____COMPILATION\">compilation</see>.  See <see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> \u000A for a discussion of how to certify a book.</p>"],

 "ACL2____HINTS":[["Miscellaneous"],"ACL2 Sources","ACL2","<code>Examples: \u000AThe following :hints value is nonsensical.  Nevertheless, it \u000Aillustrates all of the available hint keywords except the \u000A``custom keywords'' (see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>) definable \u000Aby the user. \u000A \u000A:hints ((\"Goal\" \u000A         :do-not-induct t \u000A         :do-not '(generalize fertilize) \u000A         :expand ((assoc x a) \u000A                  :lambdas \u000A                  (:free (y) (:with member (member y z)))) \u000A         :restrict ((&lt;-trans ((x x) (y (foo x))))) \u000A         :hands-off (length binary-append) \u000A         :in-theory (set-difference-theories \u000A                      (current-theory :here) \u000A                      '(assoc)) \u000A         :induct (and (nth n a) (nth n b)) \u000A         :use ((:instance assoc-of-append \u000A                          (x a) (y b) (z c)) \u000A               (:functional-instance \u000A                 (:instance p-f (x a) (y b)) \u000A                 (p consp) \u000A                 (f assoc))) \u000A         :bdd (:vars (c a0 b0 a1 b1) :prove nil :bdd-constructors (cons)) \u000A         :clause-processor (:function cl-proc :hint (my-hint clause)) \u000A         :instructions (:x :prove) \u000A         :cases ((true-listp a) (consp a)) \u000A         :by (:instance rev-rev (x (cdr z))) \u000A         :nonlinearp t \u000A         :backchain-limit-rw 3 \u000A         :reorder (4 7 2) \u000A         :case-split-limitations (20 10) \u000A         :no-op t \u000A         :no-thanks t \u000A         :error (\"Bad value ~x0.\" 123) \u000A         :or (hint-kwd-alist-1 ... hint-kwd-alist-k) \u000A         :rw-cache-state nil \u000A         :backtrack (my-computed-hint clause processor clause-list))) \u000A</code> \u000A \u000A <p>A very common hint is the <v>:use</v> hint, which in general takes as its \u000A value a list of ``lemma instances'' (see <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>) but which \u000A allows a single lemma name as a special case.  Here are two examples, one \u000A using a single lemma name and one using a lemma instance:</p> \u000A \u000A <code>; Attach :use hint to the top-level goal, which is named &quot;Goal&quot;:\u000A:hints ((&quot;Goal&quot; :use lemma23))\u000A\u000A; Equivalent to the above: use the trivial instance (i.e., with the empty\u000A; substitution of lemma23:\u000A:hints ((&quot;Goal&quot; :use ((:instance lemma23))))\u000A\u000A; Attach :use hint to the named subgoal, where the indicated lemma is used\u000A; with the substitution that maps x to 17 and y to (foo z):\u000A:hints ((&quot;[1]Subgoal *1/1.2'&quot; :use ((:instance lemma23\u000A                                                 (x 17)\u000A                                                 (y (foo z))))))\u000A\u000A; Equivalent to the above: ACL2 allows you to omit the outer parentheses if\u000A; there is only one lemma used.\u000A:hints ((&quot;[1]Subgoal *1/1.2'&quot; :use (:instance lemma23\u000A                                                (x 17)\u000A                                                (y (foo z)))))</code> \u000A \u000A <p>ACL2 also provides ``custom keyword'' hints (see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>) and even more general ``computed hints'' for the \u000A advanced user (see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>).</p> \u000A \u000A <p>Only the first hint applicable to a goal, as specified in the user-supplied \u000A list of <v>:hints</v> followed by the default hints (see <see topic=\"ACL2____DEFAULT-HINTS-TABLE\">default-hints-table</see>), will be applied to that goal.  For an advanced \u000A exception, see <see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see>.  For a detailed discussion of how hints \u000A fit into the ACL2 waterfall, see <see topic=\"ACL2____HINTS-AND-THE-WATERFALL\">hints-and-the-waterfall</see>.  For examples \u000A of the sophisticated use of hints, primarily for experts, see community book \u000A <v>books/hints/basic-tests.lisp</v>.</p> \u000A \u000A <p>Background: <v>Hints</v> are allowed in all <see topic=\"ACL2____EVENTS\">events</see> that use the \u000A theorem prover.  During <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> <see topic=\"ACL2____EVENTS\">events</see> there are two different \u000A uses of the theorem prover: one to prove termination and another to verify the \u000A <see topic=\"ACL2____GUARD\">guard</see>s.  To pass a hint to the theorem prover during termination \u000A proofs, use the <v>:hints</v> keyword in the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>'s <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> \u000A declaration.  To pass a hint to the theorem prover during the <see topic=\"ACL2____GUARD\">guard</see> \u000A verification portion of admitting a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, use the <v>:guard-hints</v> \u000A keyword in the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>'s <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> declaration.  The <tt><see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see></tt> event and the <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event also use the theorem prover. \u000A To pass hints to them, use the <v>:hints</v> keyword argument to the event.</p> \u000A \u000A <code>General Form of Common :hints:\u000A  ((<see topic=\"ACL2____GOAL-SPEC\">goal-spec</see> :key1 val1 ... :keyn valn)\u000A   ...\u000A   (<see topic=\"ACL2____GOAL-SPEC\">goal-spec</see> :key1 val1 ... :keyn valn))</code> \u000A \u000A <p>where <tt><see topic=\"ACL2____GOAL-SPEC\">goal-spec</see></tt> is as described elsewhere (see <see topic=\"ACL2____GOAL-SPEC\">goal-spec</see>) \u000A and the keys and their respective values are shown below with their \u000A interpretations.  We also provide ``computed hints'' but discuss them \u000A separately; see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>.  The hint keywords below are considered \u000A in alphabetical order.</p> \u000A \u000A <dl> \u000A \u000A <dt><v>:backchain-limit-rw</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a natural number or <v>nil</v>, indicating the level of \u000A backchaining for <see topic=\"ACL2____REWRITE\">rewrite</see>, <see topic=\"ACL2____META\">meta</see>, and <see topic=\"ACL2____LINEAR\">linear</see> rules.  This \u000A overrides, for the current goal and (as with <v>:</v><tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt> hints) \u000A descendent goals, the default <see topic=\"ACL2____BACKCHAIN-LIMIT\">backchain-limit</see> \u000A (see <see topic=\"ACL2____SET-BACKCHAIN-LIMIT\">set-backchain-limit</see>).</p></dd> \u000A \u000A <dt><v>:backtrack</v></dt><p/> \u000A \u000A <dd><p>This is an advanced hint.  You can probably accomplish its effect by \u000A the use of ordinary computed hints; see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>.  But if you are \u000A an expert, read on.  (See <see topic=\"ACL2____HINTS-AND-THE-WATERFALL\">hints-and-the-waterfall</see> for some relevant \u000A background.)</p> \u000A \u000A <p><v>Value</v> is a computed hint, which is an expression that evaluates either \u000A to <v>nil</v> &mdash; indicating that the <v>:backtrack</v> hint is to have no \u000A effect &mdash; or to a non-empty alternating list of <v>:keyi :vali</v> pairs, \u000A as expected for a hint.  However, unlike ordinary computed hints, \u000A <v>:backtrack</v> hints are evaluated <b>after</b> a goal has been processed to \u000A yield zero or more subgoals, not before.  Moreover, variables <v>PROCESSOR</v> \u000A and <v>CLAUSE-LIST</v> are allowed, but variable \u000A <v>STABLE-UNDER-SIMPLIFICATIONP</v> is not.  We explain in more detail below, \u000A but first consider the following simple example.  First we define a standard \u000A list reversal function:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> rev (x)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A      (<see topic=\"COMMON-LISP____APPEND\">append</see> (rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) nil))\u000A    nil))</code> \u000A \u000A <p>Now we prove:</p> \u000A \u000A <code>(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> (rev x)))</code> \u000A \u000A <p>The successful proof includes the following output.</p> \u000A \u000A <code>Subgoal *1/1'\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see>\u000A  (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X)\u000A       (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (REV (<see topic=\"COMMON-LISP____CDR\">CDR</see> X))))\u000A  (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (REV (<see topic=\"COMMON-LISP____CDR\">CDR</see> X)) (<see topic=\"COMMON-LISP____LIST\">LIST</see> (<see topic=\"COMMON-LISP____CAR\">CAR</see> X))))).\u000A\u000AThe destructor terms (<see topic=\"COMMON-LISP____CAR\">CAR</see> X) and (<see topic=\"COMMON-LISP____CDR\">CDR</see> X) can be\u000Aeliminated by using CAR-CDR-ELIM to replace X\u000Aby (<see topic=\"COMMON-LISP____CONS\">CONS</see> X1 X2), (<see topic=\"COMMON-LISP____CAR\">CAR</see> X) by X1 and (<see topic=\"COMMON-LISP____CDR\">CDR</see> X) by\u000AX2.  This produces the following goal.\u000A\u000ASubgoal *1/1''\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> (<see topic=\"COMMON-LISP____CONS\">CONS</see> X1 X2))\u000A              (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (REV X2)))\u000A         (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (REV X2) (<see topic=\"COMMON-LISP____LIST\">LIST</see> X1)))).</code> \u000A \u000A <p>But suppose that we attach a <v>:backtrack</v> hint to the goal above at \u000A which destructor elimination was applied:</p> \u000A \u000A <code>(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> (rev x))\u000A     :hints ((&quot;Subgoal *1/1'&quot;\u000A              :backtrack\u000A              (<see topic=\"COMMON-LISP____QUOTE\">quote</see> (:do-not '(eliminate-destructors))))))</code> \u000A \u000A <p>Then when ACL2 applies destructor elimination as displayed above, this time \u000A the <v>:backtrack</v> hint applies, evaluating to <v>(:do-not\u000A '(eliminate-destructors))</v>.  Since this list is not <v>nil</v>, the prover \u000A decides not to keep the new subgoal, and instead supplies this <v>:do-not</v> \u000A hint before attacking the goal again.  In this example, ACL2 happens to use a \u000A technique later in its ``waterfall'' arsenal than destructor elimination, \u000A namely, generalization:</p> \u000A \u000A <code>Subgoal *1/1'\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see>\u000A  (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X)\u000A       (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (REV (<see topic=\"COMMON-LISP____CDR\">CDR</see> X))))\u000A  (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (REV (<see topic=\"COMMON-LISP____CDR\">CDR</see> X)) (<see topic=\"COMMON-LISP____LIST\">LIST</see> (<see topic=\"COMMON-LISP____CAR\">CAR</see> X))))).\u000A\u000A[Note:  A hint was supplied for our processing\u000Aof the goal above, because of a :backtrack hint\u000Athat is preventing destructor elimination.\u000AThanks!]\u000A\u000AWe generalize this conjecture, replacing\u000A(REV (<see topic=\"COMMON-LISP____CDR\">CDR</see> X)) by RV.  This produces\u000A\u000ASubgoal *1/1''\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X) (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> RV))\u000A         (<see topic=\"ACL2____TRUE-LISTP\">TRUE-LISTP</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> RV (<see topic=\"COMMON-LISP____LIST\">LIST</see> (<see topic=\"COMMON-LISP____CAR\">CAR</see> X))))).</code> \u000A \u000A <p>We now provide a careful explanation of how <v>:backtrack</v> hints work, but \u000A we suggest that you keep the example above in mind.  If ``<v>:backtrack\u000A form</v>'' is part of the hint that has been selected for a goal, then <v>form</v> \u000A is evaluated when one of ACL2's clause processors successfully applies to the \u000A current goal to produce a list of subgoals.  This evaluation takes place in an \u000A environment just like that for any computed hint (see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>), \u000A with the following exceptions.  First, the variable \u000A <v>STABLE-UNDER-SIMPLIFICATIONP</v> is not allowed to occur free in <v>form</v>, \u000A but instead the following new variables are allowed to occur free and are \u000A bound for this evaluation as follows: <v>PROCESSOR</v> is bound to the processor \u000A in the list <v>*preprocess-clause-ledge*</v> that has applied to the goal, and \u000A <v>CLAUSE-LIST</v> is bound to the list of clauses (each a list of literals that \u000A is implicitly disjoined) returned by that clause processor.  Second, the \u000A variables <v>HIST</v> and <v>PSPV</v> are bound to the history and pspv returned \u000A by the clause processor, <b>not</b> the ones that were passed to the clause \u000A processor.  If this evaluation returns an error, then the proof aborts, as for \u000A any computed hint whose evaluation returns an error.  If this evaluation \u000A returns <v>nil</v>, then the <v>:backtrack</v> hint has no effect, and the goal is \u000A replaced by the list of goals (the value of <v>CLAUSE-LIST</v> described above), \u000A as usual.  Otherwise, the clause processor is deemed to have failed, and the \u000A goal clause is tried again starting at the top of the waterfall after \u000A selecting the hint returned by the above evaluation.  That hint will normally \u000A be an alternating list of hint keywords and their values, but if it is a \u000A custom keyword hint (see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>), then it will be handled \u000A in the usual manner but with the first three variables above bound to the \u000A symbol <v>:OMITTED</v>.  Of course, if the new hint includes a value for \u000A <v>:BACKTRACK</v> then this process can loop; care should be taken to keep that \u000A from happening.</p> \u000A \u000A <p>A final note about <v>:BACKTRACK</v> hints: since these are a form of \u000A computed hints, <see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see> (if any) are applied to their evaluation \u000A result just as with any computed hint.  That is, the backtrack hint is \u000A successively modified with each override-hint, to produce a final hint that is \u000A actually used (or, ignored if that final hint is <v>nil</v>).  See <see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see>.</p></dd> \u000A \u000A <dt><v>:</v><tt><see topic=\"ACL2____BDD\">bdd</see></tt></dt><p/> \u000A \u000A <dd><p>This hint indicates that ACL2's built-in ordered binary decision \u000A diagrams (BDDs) with rewriting are to be used to prove or simplify the goal. \u000A See <see topic=\"ACL2____BDD\">bdd</see> for an introduction to the ACL2 BDD algorithm.</p> \u000A \u000A <p><v>Value</v> is a list of even length, such that every other element, \u000A starting with the first, is one of the keywords <v>:vars</v>, \u000A <v>:bdd-constructors</v>, <v>:prove</v>, or <v>:literal</v>.  Each keyword that is \u000A supplied should be followed by a value of the appropriate form, as shown \u000A below; for others, a default is used.  Although <v>:vars</v> must always be \u000A supplied, we expect that most users will be content with the defaults used for \u000A the other values.</p> \u000A \u000A <blockquote> \u000A \u000A <p><v>:vars</v> &mdash; A list of ACL2 variables, which are to be treated as \u000A Boolean variables.  The prover must be able to check, using trivial reasoning \u000A (see <see topic=\"ACL2____TYPE-SET\">type-set</see>), that each of these variables is Boolean in the context \u000A of the current goal.  Note that the prover will use very simple heuristics to \u000A order any variables that do not occur in <v>:vars</v> (so that they are \u000A ``greater than'' the variables that do occur in <v>:vars</v>), and these \u000A heuristics are often far from optimal.  In addition, any variables not listed \u000A may fail to be assumed Boolean by the prover, which is likely to seriously \u000A impede the effectiveness of ACL2's BDD algorithm.  Thus, users are encouraged \u000A <i>not</i> to rely on the default order, but to supply a list of variables \u000A instead.  Finally, it is allowed to use a value of <v>t</v> for <v>vars</v>.  This \u000A means the same as a <v>nil</v> value, except that the BDD algorithm is directed \u000A to fail unless it can guarantee that all variables in the input term are known \u000A to be Boolean (in a sense discussed elsewhere; see <see topic=\"ACL2____BDD-ALGORITHM\">bdd-algorithm</see>).</p> \u000A \u000A <p><v>:literal</v> &mdash; An indication of which part of the current goal \u000A should receive BDD processing.  Possible values are:</p> \u000A \u000A <code>:all     treat entire goal as a single literal (<see topic=\"COMMON-LISP____THE\">the</see> default)\u000A:conc    process the conclusion\u000An        process the hypothesis with index n (1, 2, ...)</code> \u000A \u000A <p><v>:bdd-constructors</v> &mdash; When supplied, this value should be a list \u000A of function symbols in the current ACL2 <see topic=\"ACL2____WORLD\">world</see>; it is <v>(<see topic=\"COMMON-LISP____CONS\">cons</see>)</v> by \u000A default, unless <v>:bdd-constructors</v> has a value in the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> by default, in which case that value is the default.  We \u000A expect that most users will be content with the default.  See <see topic=\"ACL2____BDD-ALGORITHM\">bdd-algorithm</see> for information about how this value is used.</p> \u000A \u000A <p><v>:prove</v> &mdash; When supplied, this value should be <v>t</v> or <v>nil</v>; \u000A it is <v>t</v> by default.  When the goal is not proved and this value is \u000A <v>t</v>, the entire proof will abort.  Use the value <v>nil</v> if you are happy \u000A to the proof to go on with the simplified term.</p> \u000A \u000A </blockquote></dd> \u000A \u000A <dt><v>:by</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>, <v>nil</v>, or a new event \u000A name. If the value is a <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see> (see <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>), \u000A then it indicates that the goal (when viewed as a clause) is either equal to \u000A the proposition denoted by the instance, or is subsumed by that proposition \u000A when both are viewed as clauses.  To view a formula as a clause, union \u000A together the negations of the hypotheses and add the conclusion.  For \u000A example,</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____AND\">AND</see> (h1 t1) (h2 t2)) (c t1))</code> \u000A \u000A <p>may be viewed as the clause</p> \u000A \u000A <code>{~(h1 t1) ~(h2 t2) (c t1)}.</code> \u000A \u000A <p>Clause <v>c1</v> is ``subsumed'' by clause <v>c2</v> iff some instance of \u000A <v>c2</v> is a subset of <v>c1</v>.  For example, the clause above is subsumed by \u000A <v>{~(h1 x) (c x)}</v>, which when viewed as a formula is <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (h1 x) (c\u000A x))</v>.</p> \u000A \u000A <p>Note that if the value is the name of a function symbol introduced by \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, then the original form of the body of that definition is used. \u000A This behavior differs from that provided by a <v>:use</v> hint, where the \u000A so-called ``normalized'' body, for which ACL2 has propagated <v>IF</v> tests \u000A upward.</p> \u000A \u000A <p>If the value is <v>nil</v> or a new name, the prover does not even attempt to \u000A prove the goal to which this hint is attached.  Instead the goal is given a \u000A ``bye'', i.e., it is skipped and the proof attempt continues as though the \u000A goal had been proved.  If the prover terminates without error then it reports \u000A that the proof would have succeeded had the indicated goals been proved and it \u000A prints an appropriate <see topic=\"ACL2____DEFTHM\">defthm</see> form to define each of the <v>:by</v> names. \u000A The ``name'' <v>nil</v> means ``make up a name.''  Here is an example \u000A (admittedly contrived for illustration purposes).</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x y) z)\u000A                   (<see topic=\"COMMON-LISP____APPEND\">append</see> x y z))\u000A            :hints ((&quot;Subgoal *1/2'&quot; :by nil)))\u000A\u000AName the formula above *1.\u000A\u000A[[... output omitted here ...]]\u000A\u000A[Note:  A hint was supplied for our processing of the goal below.\u000AThanks!]\u000A\u000ASubgoal *1/2'\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____AND\">AND</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X)\u000A              (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (<see topic=\"COMMON-LISP____CDR\">CDR</see> X) Y) Z)\u000A                     (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (<see topic=\"COMMON-LISP____CDR\">CDR</see> X) Y Z)))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> X Y) Z)\u000A                (<see topic=\"COMMON-LISP____APPEND\">APPEND</see> X Y Z))).\u000A\u000ABut we have been asked to pretend that this goal is subsumed by the\u000Ayet-to-be-proved |THM Subgoal *1/2'|.\u000A\u000ASubgoal *1/1\u000A[[... proof goes on; further output omitted here ...]]</code> \u000A \u000A <p>The system does not attempt to check the uniqueness of the <v>:by</v> names \u000A (supplied or made up), since by the time those goals are proved the namespace \u000A will be cluttered still further.  Therefore, the final list of ``appropriate'' \u000A <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> forms may be impossible to admit without some renaming by the \u000A user.  If you must invent new names, remember to substitute the new ones for \u000A the old ones in the <v>:by</v> hints themselves.</p></dd> \u000A \u000A <dt><v>:</v><tt><see topic=\"ACL2____CASE-SPLIT-LIMITATIONS\">case-split-limitations</see></tt></dt><p/> \u000A \u000A <dd><p><v>Value</v> is the same as for <tt><see topic=\"ACL2____SET-CASE-SPLIT-LIMITATIONS\">set-case-split-limitations</see></tt>.  The \u000A simplifier will behave as though the value had instead been supplied to \u000A <v>set-case-split-limitations</v>; see <see topic=\"ACL2____SET-CASE-SPLIT-LIMITATIONS\">set-case-split-limitations</see>.  This \u000A behavior will persist through subgoals unless overridden by another \u000A <v>:CASE-SPLIT-LIMITATIONS</v> hint.</p></dd> \u000A \u000A <dt><v>:cases</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a non-empty list of terms.  For each term in the list, a \u000A new goal is created from the current goal by assuming that term; and also, in \u000A essence, one additional new goal is created by assuming all the terms in the \u000A list false.  We say ``in essence'' because if the disjunction of the terms \u000A supplied is a tautology, then that final goal will be a tautology and hence \u000A will in fact never actually be created.</p></dd> \u000A \u000A <dt><v>:</v><tt><see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see></tt></dt><p/> \u000A \u000A <dd><p><v>Value</v> specifies the application of a user-defined simplifier to \u000A the current goal.  See <see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see>, which provides necessary \u000A background and hint syntax.  Also see <see topic=\"ACL2____DEFINE-TRUSTED-CLAUSE-PROCESSOR\">define-trusted-clause-processor</see> \u000A for a discussion of ``trusted clause-processors'': goal-level simplifiers that \u000A may be external to ACL2 and do not need to be proved correct in ACL2.</p> \u000A \u000A <p>You can see all current <v>:clause-processor</v> rules by issuing the command \u000A <v>(print-clause-processor-rules)</v>, and you can see the names of all trusted \u000A clause-processors by issuing the command <v>(<see topic=\"ACL2____TABLE\">table</see>\u000A trusted-clause-processor-table)</v>.</p></dd> \u000A \u000A <dt><v>:do-not</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a term having at most the single free variable <tt><see topic=\"ACL2____WORLD\">world</see></tt>, which when evaluated (with <tt><see topic=\"ACL2____WORLD\">world</see></tt> bound to the current ACL2 \u000A logical <see topic=\"ACL2____WORLD\">world</see>) produces a list of symbols that is a subset of the \u000A list</p> \u000A \u000A <code>(preprocess ;propositional logic, simple rules\u000A simplify   ;as above plus rewriting, linear arithmetic\u000A eliminate-destructors\u000A fertilize  ;use of equalities\u000A generalize\u000A eliminate-irrelevance).</code> \u000A \u000A <p>The hint indicates that the ``processes'' named should not be used at or \u000A below the goal in question.  Thus, to prevent generalization and \u000A fertilization, say, include the hint</p> \u000A \u000A <code>:do-not '(<see topic=\"ACL2____GENERALIZE\">generalize</see> fertilize)</code> \u000A \u000A <p>If <v>value</v> is a single symbol, as in</p> \u000A \u000A <code>:do-not generalize,</code> \u000A \u000A <p>it is taken to be <v>'(value)</v>.</p></dd> \u000A \u000A <dd>See also <see topic=\"ACL2____DO-NOT-HINT\">do-not-hint</see> for a way to automatically provide \u000A <v>:do-not</v> hints across several theorems.</dd> \u000A \u000A <dt><v>:do-not-induct</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is <v>t</v>, <v>:otf-flg-override</v>, <v>:otf</v>, <v>name</v> or \u000A <v>nil</v>, indicating whether <see topic=\"ACL2____INDUCTION\">induction</see> is permitted under the specified \u000A goal.  If <v>value</v> is <v>t</v> or <v>:otf-flg-override</v>, then the attempt to \u000A apply <see topic=\"ACL2____INDUCTION\">induction</see> to the indicated goal or any subgoal under the \u000A indicated goal will immediately cause the theorem prover to report <see topic=\"ACL2____FAILURE\">failure</see>, except that if <v>:otf-flg t</v> is specified (see <see topic=\"ACL2____OTF-FLG\">otf-flg</see>) and \u000A <v>value</v> is <v>t</v>, then the proof will continue until the time at which the \u000A goal pushed for induction is finally considered.  The latter behavior is also \u000A what occurs if <v>value</v> is <v>:otf</v>.  Thus, any non-<v>nil</v> value requires \u000A the indicated goal to be proved entirely by simplification, destructor \u000A elimination, and the other ``waterfall'' processes.  <see topic=\"ACL2____INDUCTION\">Induction</see> to prove \u000A the indicated goal (or any subgoal) is not permitted.  See however the \u000A <v>:induct</v> hint below.  If <v>value</v> is a symbol other than <v>t</v>, \u000A <v>:otf-flg-override</v>, <v>:otf</v> or <v>nil</v>, the theorem prover will give a \u000A ``bye'' to any subgoal that would otherwise be attacked with induction.  This \u000A will cause the theorem prover to fail eventually but will collect the \u000A necessary subgoals.  If <v>value</v> is <v>nil</v>, this hint means <see topic=\"ACL2____INDUCTION\">induction</see> is permitted.  Since that is the default, there is no reason to use \u000A the value <v>nil</v>.  Note that a <v>:do-not-induct</v> hint is ignored for any \u000A goal on which an <v>:induct</v> hint is supplied.  For an advanced example of \u000A the use of value <v>:otf</v> with <see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see>, see community book \u000A <v>books/hints/basic-tests.lisp</v>.</p></dd> \u000A \u000A <dt><v>:error</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is typically a ``fmt message'' to be printed by the <tt><see topic=\"ACL2____FMT\">fmt</see></tt> tilde-directive ~@ but may be any object.  The effect of this hint is to \u000A cause an error when the hint is translated.  There is no reason to include an \u000A <v>:ERROR</v> hint in any user-typein, since it will only cause an error when \u000A the form is evaluated.  <v>:ERROR</v> hints are useful in the definition of \u000A functions that generate custom keyword hints (<see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>) and \u000A computed hints (<see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>).  For example, if you wish to define a \u000A custom keyword hint <v>:my-hint val</v> and you wish the hint to signal an error \u000A if there is something inappropriate about <v>val</v> in the context of the hint, \u000A use the following code to generate the hint</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LIST\">list</see> :ERROR (<see topic=\"COMMON-LISP____CONS\">cons</see> &quot;Your specified value, ~x0, is inappropriate&quot;\u000A                   (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #0 val))))</code> \u000A \u000A <p>which is equivalent to</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LIST\">list</see> :ERROR (<see topic=\"ACL2____MSG\">msg</see> &quot;Your specified value, ~x0, is inappropriate&quot;\u000A                  val))</code> \u000A \u000A <p>which, if <v>val</v> has the value <v>123</v>, would evaluate to the hint</p> \u000A \u000A <code>(:ERROR (&quot;Your specified value, ~x0, is inappropriate&quot; (#0 . 123))).</code> \u000A \u000A <p>Note that any time an <v>:ERROR</v> keyword is produced during hint \u000A processing, including iterations of the expansions of custom keyword hints or \u000A of <see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see>, an error will occur.</p></dd> \u000A \u000A <dt><v>:expand</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a true list of terms, each of which is of one of the \u000A forms <v>(<see topic=\"COMMON-LISP____LET\">let</see> ((v1 t1)...) b)</v> or <v>(fn t1 ... tn)</v>, where <v>fn</v> is a \u000A defined function symbol with formals <v>v1, ..., vn,</v> and <v>body</v> <v>b</v>. \u000A Such a term is said to be ``expandable:'' it can be replaced by the result of \u000A substituting the <v>ti</v>'s for the <v>vi</v>'s in <v>b</v>.  The terms listed in \u000A the <v>:expand</v> hint are expanded when they are encountered by the simplifier \u000A while working on the specified goal or any of its subgoals.  We permit \u000A <v>value</v> to be a single such term instead of a singleton list. \u000A <b>Remarks</b>: (1) Allowed are ``terms'' of the form <v>(:free (var1 var2 ...\u000A varn) pattern)</v> where the indicated variables are distinct and <v>pattern</v> \u000A is a term.  Such ``terms'' indicate that we consider the indicated variables \u000A to be instantiatable, in the following sense: whenever the simplifier \u000A encounters a term that can be obtained from <v>pattern</v> by instantiating the \u000A variables <v>(var1 var2 ...  varn)</v>, then it expands that term.  (2) Also \u000A allowed are ``terms'' of the form <v>(:with name term)</v>, where <v>name</v> is a \u000A function symbol, a macro name that denotes a function symbol (see <see topic=\"ACL2____MACRO-ALIASES-TABLE\">macro-aliases-table</see>), or a <see topic=\"ACL2____RUNE\">rune</see>.  The corresponding rule of class \u000A <v>:rewrite</v>, which is often a <see topic=\"ACL2____DEFINITION\">definition</see> rule but need not be, is \u000A then used in place of the current body for the function symbol of <v>term</v>; \u000A see <see topic=\"ACL2____SHOW-BODIES\">show-bodies</see> and see <see topic=\"ACL2____SET-BODY\">set-body</see>.  If the rule is of the form \u000A <v>(<see topic=\"ACL2____IMPLIES\">implies</see> hyp (equiv lhs rhs))</v>, then after matching <v>lhs</v> to the \u000A current term in a context that is maintaining equivalence relation <v>equiv</v>, \u000A ACL2 will replace the current term with <v>(<see topic=\"COMMON-LISP____IF\">if</see> hyp rhs (<see topic=\"ACL2____HIDE\">hide</see> term))</v>, or just \u000A <v>rhs</v> if the rule is just <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> lhs rhs)</v>.  (3) A combination of both \u000A <v>:free</v> and <v>:with</v>, as described above, is legal.  (4) The term \u000A <v>:LAMBDAS</v> is treated specially.  It denotes the list of all lambda \u000A applications (i.e., <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> expressions) encountered during the proof. \u000A Conceptually, this use of <v>:LAMBDAS</v> tells ACL2 to treat lambda \u000A applications as a notation for substitutions, rather than as function calls \u000A whose opening is subject to the ACL2 rewriter's heuristics (specifically, not \u000A allowing lambda applications to open when they introduce ``too many'' if \u000A terms).</p></dd> \u000A \u000A <dt><v>:hands-off</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a true list of function symbols or lambda expressions, \u000A indicating that under the specified goal applications of these functions are \u000A not to be rewritten.  Note however that subterms will still be rewritten; see \u000A <see topic=\"ACL2____HIDE\">hide</see> if that is not what is intended.  (The community book \u000A <v>books/clause-processors/autohide.lisp</v> from Jared Davis may also be \u000A helpful in that case.) <v>Value</v> may also be a single function symbol or \u000A lambda expression instead of a list.</p></dd> \u000A \u000A <dt><v>:</v><tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a ``theory expression,'' i.e., a term having at most the \u000A single free variable <tt><see topic=\"ACL2____WORLD\">world</see></tt> which when evaluated (with <tt><see topic=\"ACL2____WORLD\">world</see></tt> \u000A bound to the current ACL2 logical world (see <see topic=\"ACL2____WORLD\">world</see>)) will produce a \u000A theory to use as the current theory for the goal specified.  See <see topic=\"ACL2____THEORIES\">theories</see>.</p> \u000A \u000A <p>Note that an <v>:</v><tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt> hint will always be evaluated relative \u000A to the current ACL2 logical <see topic=\"ACL2____WORLD\">world</see>, not relative to the theory of a \u000A previous goal.  Consider the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> prop\u000A  (p (f (g x)))\u000A  :hints ((&quot;Goal&quot;      :in-theory (<see topic=\"ACL2____DISABLE\">disable</see> f))\u000A          (&quot;Subgoal 3&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see>  g))))</code> \u000A \u000A <p>Consider in particular the theory in effect at <v>Subgoal 3</v>.  This call \u000A of the <tt><see topic=\"ACL2____ENABLE\">enable</see></tt> macro enables <v>g</v> relative to the <tt><see topic=\"ACL2____CURRENT-THEORY\">current-theory</see></tt> of the current logical <see topic=\"ACL2____WORLD\">world</see>, <i>not</i> relative to \u000A the theory produced by the hint at <v>Goal</v>.  Thus, the <tt><see topic=\"ACL2____DISABLE\">disable</see></tt> of \u000A <v>f</v> on behalf of the hint at <v>Goal</v> will be lost at <v>Subgoal 3</v>, and \u000A <v>f</v> will be enabled at <v>Subgoal 3</v> if was enabled globally when \u000A <v>prop</v> was submitted.</p></dd> \u000A \u000A <dt><v>:induct</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is either <v>t</v> or a term containing at least one \u000A recursively defined function symbol; if <v>t</v>, this hint indicates that the \u000A system should proceed to apply its induction heuristic to the specified goal \u000A produced (without trying simplification, etc.); if <v>value</v> is a term other \u000A than <v>t</v>, then not only should the system apply induction immediately, but \u000A it should analyze <v>value</v> rather than the goal to generate its <see topic=\"ACL2____INDUCTION\">induction</see> scheme.  Merging and the other <see topic=\"ACL2____INDUCTION\">induction</see> heuristics are \u000A applied.  Thus, if <v>value</v> contains several mergeable <see topic=\"ACL2____INDUCTION\">induction</see>s, \u000A the ``best'' will be created and chosen.  E.g., the <v>:induct</v> hint</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> i a) (<see topic=\"COMMON-LISP____NTH\">nth</see> j a))</code> \u000A \u000A <p>suggests simultaneous <see topic=\"ACL2____INDUCTION\">induction</see> on <v>i</v>, <v>j</v>, and <v>a</v>.</p> \u000A \u000A <p>If both an <v>:induct</v> and a <v>:do-not-induct</v> hint are supplied for a \u000A given goal then the indicated <see topic=\"ACL2____INDUCTION\">induction</see> is applied to the goal and the \u000A <v>:do-not-induct</v> hint is inherited by all subgoals generated.</p></dd> \u000A \u000A <dt><v>:</v><tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a list of <see topic=\"ACL2____PROOF-CHECKER\">proof-checker</see> instructions; see <see topic=\"ACL2____INSTRUCTIONS\">instructions</see>.  Unlike other hint keywords described here, this one is \u000A actually a custom keyword hint (see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>) that \u000A generates a suitable <v>:</v><tt><see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see></tt> hint.</p></dd> \u000A \u000A <dt><v>:no-op</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is any object and is irrelevant.  This hint does nothing. \u000A But empty hints, such as <v>(&quot;Goal&quot;)</v>, are illegal and there are occasions, \u000A especially when writing custom keyword hints \u000A (see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>) and computed hints (see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>) where it is convenient to be able to generate a non-empty \u000A no-op hint.  The standard idiom is <v>(&quot;Goal&quot; :NO-OP T)</v> but the <v>T</v> is \u000A completely ignored.  Unlike other hint keywords, multiple occurrences of the \u000A keyword <v>:NO-OP</v> are tolerated.</p></dd> \u000A \u000A <dt><v>:no-thanks</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is any object.  This hint does nothing, except that if \u000A <v>value</v> is non-<v>nil</v> then the usual ``[Note: A hint was \u000A supplied... Thanks!]'' is not printed.</p></dd> \u000A \u000A <dt><v>:nonlinearp</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is <v>t</v> or <v>nil</v>, indicating whether <see topic=\"ACL2____NON-LINEAR-ARITHMETIC\">non-linear-arithmetic</see> is active.  The default value is <v>nil</v>.  See <see topic=\"ACL2____NON-LINEAR-ARITHMETIC\">non-linear-arithmetic</see>.</p></dd> \u000A \u000A <dt><v>:or</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a list <v>(kwd-val-listp-1 ... kwd-val-listp-k)</v>, where \u000A each <v>kwd-val-listp-i</v> is a list satisfying <tt><see topic=\"ACL2____KEYWORD-VALUE-LISTP\">keyword-value-listp</see></tt>, \u000A i.e., an alternating list of keywords and values.  This hint causes an attempt \u000A to prove the specified goal using hints <v>kwd-val-listp-i</v> in \u000A sequence (first <v>kwd-val-listp-1</v>, then <v>kwd-val-listp-2</v>, and so on), \u000A until the first of these succeeds.  If none succeeds, then the prover proceeds \u000A after heuristically choosing the ``best'' result, taking into account the \u000A goals pushed in each case for proof by induction.</p> \u000A \u000A <p>The following (contrived but illustrative example illustrates how <v>:or</v> \u000A hints work.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____THM\">thm</see> (f x)\u000A            :hints\u000A            ((&quot;Goal&quot;\u000A              :expand ((<see topic=\"COMMON-LISP____NTH\">nth</see> x 3))\u000A              :or ((:in-theory (<see topic=\"ACL2____DISABLE\">disable</see> car-cons))\u000A                   (:use cdr-cons :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> append)))\u000A              :do-not '(<see topic=\"ACL2____GENERALIZE\">generalize</see>))))\u000A\u000A[Note:  A hint was supplied for our processing of the goal above.\u000AThanks!]\u000A\u000AThe :OR hint for Goal gives rise to two disjunctive branches.  Proving\u000Aany one of these branches would suffice to prove Goal.  We explore\u000Athem in turn, describing their derivations as we go.\u000A\u000A---\u000ASubgoal D2\u000A( same formula as Goal ).\u000A\u000AThe first disjunctive branch (of 2) for Goal can be created by applying\u000Athe hint:\u000A(&quot;Subgoal D2&quot; :EXPAND ((<see topic=\"COMMON-LISP____NTH\">NTH</see> X 3))\u000A              :IN-THEORY (<see topic=\"ACL2____DISABLE\">DISABLE</see> CAR-CONS)\u000A              :DO-NOT '(<see topic=\"ACL2____GENERALIZE\">GENERALIZE</see>)).\u000A\u000A[Note:  A hint was supplied for our processing of the goal above.\u000AThanks!]\u000A\u000ANormally we would attempt to prove this formula by induction.  However,\u000Awe prefer in this instance to focus on the original input conjecture\u000Arather than this simplified special case.  We therefore abandon our\u000Aprevious work on this conjecture and reassign the name *1 to the original\u000Aconjecture.  (See :DOC otf-flg.)  [Note:  Thanks again for the hint.]\u000A\u000A---\u000ASubgoal D1\u000A( same formula as Goal ).\u000A\u000AThe second disjunctive branch (of 2) for Goal can be created by applying\u000Athe hint:\u000A(&quot;Subgoal D1&quot; :EXPAND ((<see topic=\"COMMON-LISP____NTH\">NTH</see> X 3))\u000A              :USE CDR-CONS\u000A              :IN-THEORY (<see topic=\"ACL2____ENABLE\">ENABLE</see> APPEND)\u000A              :DO-NOT '(<see topic=\"ACL2____GENERALIZE\">GENERALIZE</see>)).\u000A\u000A[Note:  A hint was supplied for our processing of the goal above.\u000AThanks!]\u000A\u000AACL2 Warning [Use] in ( THM ...):  It is unusual to :USE an enabled\u000A:REWRITE or :DEFINITION rule, so you may want to consider disabling\u000A(:REWRITE CDR-CONS).\u000A\u000AWe augment the goal with the hypothesis provided by the :USE hint.\u000AThe hypothesis can be obtained from CDR-CONS.  We are left with the\u000Afollowing subgoal.\u000A\u000ASubgoal D1'\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP____CDR\">CDR</see> (<see topic=\"COMMON-LISP____CONS\">CONS</see> X Y)) Y)\u000A         (F X)).\u000A\u000ABy the simple :rewrite rule CDR-CONS we reduce the conjecture to\u000A\u000ASubgoal D1''\u000A(F X).</code> \u000A \u000A <p>... and so on.  This example illustrates how ACL2 processes <v>:or</v> hints \u000A in general.  For each <v>i</v> from 1 to <v>k</v>, a so-called ``disjunctive'' \u000A subgoal is created by splicing <v>kwd-val-listp-i</v> into the other hint values \u000A (if any) supplied for the given goal, in order.  A corresponding subgoal is \u000A created for each <v>i</v>, numbered in the usual manner (hence, counting down) \u000A except that the ``<v>D</v>'' is prefixed to each resulting goal.</p></dd> \u000A \u000A <dt><v>:reorder</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is a list of positive integers without duplicates, \u000A corresponding to the numbering of subgoals generated for the <see topic=\"ACL2____GOAL-SPEC\">goal-spec</see> \u000A <v>&quot;G&quot;</v>, say <v>&quot;G.k&quot;</v> down to <v>&quot;G.1&quot;</v>.  Those subgoals are \u000A reordered so that if <v>value</v> is <v>(n1 n2 ... nk)</v>, then the goal now \u000A numbered <v>&quot;G.k&quot;</v> will be the goal originally numbered <v>&quot;G.n1&quot;</v>; the \u000A goal now numbered <v>&quot;G.k-1&quot;</v> will be the goal formerly numbered \u000A <v>&quot;G.n2&quot;</v>; and so on, down the list of <v>ni</v>, after which the goals not \u000A yet printed are printed in their original order.  Note that reordering for \u000A subgoals of a goal to be proved by induction, such as <v>*1</v>, is not \u000A supported.</p></dd> \u000A \u000A <dt><v>:restrict</v></dt><p/> \u000A \u000A <dd><p>Warning: This is a sophisticated hint, suggested by Bishop Brock, that \u000A is intended for advanced users.  In particular, <v>:restrict</v> hints are \u000A ignored by the preprocessor, so you might find it useful to give the hint \u000A <v>:do-not '(preprocess)</v> when using any <v>:restrict</v> hints, at least if \u000A the rules in question are abbreviations (see <see topic=\"ACL2____SIMPLE\">simple</see>).</p> \u000A \u000A <p><v>Value</v> is an association list.  Its members are of the form <v>(x\u000A subst1 subst2 ...)</v>, where: <v>x</v> is either (1) a <see topic=\"ACL2____RUNE\">rune</see> whose <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> or <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> or (2) an event name \u000A corresponding to one or more such <see topic=\"ACL2____RUNE\">rune</see>s; and <v>(subst1 subst2 ...)</v> \u000A is a non-empty list of substitutions, i.e., of association lists pairing \u000A variables with terms.  First consider the case that <v>x</v> is a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> or <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> <see topic=\"ACL2____RUNE\">rune</see>.  Recall that without this \u000A hint, the rule named <v>x</v> is used by matching its left-hand side (call it \u000A <v>lhs</v>) against the term currently being considered by the rewriter, that \u000A is, by attempting to find a substitution <v>s</v> such that the instantiation of \u000A <v>lhs</v> using <v>s</v> is equal to that term.  If however the <v>:restrict</v> \u000A hint contains <v>(x subst1 subst2 ...)</v>, then this behavior will be modified \u000A by restricting <v>s</v> so that it must extend <v>subst1</v>; and if there is no \u000A such <v>s</v>, then <v>s</v> is restricted so that it must extend <v>subst2</v>; and \u000A so on, until the list of substitutions is exhausted.  If no such <v>s</v> is \u000A found, then the rewrite or definition rule named <v>x</v> is not applied to that \u000A term.  Finally, if <v>x</v> is an event name corresponding to one or more \u000A <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> or <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> <see topic=\"ACL2____RUNE\">rune</see>s (that is, \u000A <v>x</v> is the ``base symbol'' of such <see topic=\"ACL2____RUNE\">rune</see>s; see <see topic=\"ACL2____RUNE\">rune</see>), say \u000A <see topic=\"ACL2____RUNE\">rune</see>s <v>r1</v>, ... <v>rn</v>, then the meaning is the same except that \u000A <v>(x subst1 subst2 ...)</v> is replaced by <v>(ri subst1 subst2 ...)</v> for each \u000A <v>i</v>.  Once this replacement is complete, the hint may not contain two \u000A members whose <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is the same <see topic=\"ACL2____RUNE\">rune</see>.</p> \u000A \u000A <p>Note that the substitutions in <v>:restrict</v> hints refer to the variables \u000A actually appearing in the goals, not to the variables appearing in the rule \u000A being restricted.</p> \u000A \u000A <p>Here is an example, supplied by Bishop Brock.  Suppose that the database \u000A includes the following rewrite rule, which is probably kept <see topic=\"ACL2____DISABLE\">disable</see>d. \u000A (We ignore the question of how to prove this rule.)</p> \u000A \u000A <code>cancel-&lt;-*$free:\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> x)\u000A              (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> y)\u000A              (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> z))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP_____C3\">&lt;</see> y z)\u000A                (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP_____C3\">&lt;</see> x 0)\u000A                    (<see topic=\"COMMON-LISP_____E3\">&gt;</see> (<see topic=\"COMMON-LISP_____A2\">*</see> x y) (<see topic=\"COMMON-LISP_____A2\">*</see> x z))\u000A                  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP_____E3\">&gt;</see> x 0)\u000A                      (<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP_____A2\">*</see> x y) (<see topic=\"COMMON-LISP_____A2\">*</see> x z))\u000A                    (<see topic=\"ACL2____HIDE\">hide</see> (<see topic=\"COMMON-LISP_____C3\">&lt;</see> y z))))))</code> \u000A \u000A <p>Then ACL2 can prove the following theorem (unless other rules get in the \u000A way), essentially by multiplying both sides by <v>x</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____THM\">thm</see>\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> x)\u000A                (<see topic=\"COMMON-LISP_____C3\">&lt;</see> 1 x))\u000A           (<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP_____F2\">/</see> x) 1))\u000A  :hints\u000A  ((&quot;Goal&quot;\u000A    :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> cancel-&lt;-*$free)\u000A    :restrict ((cancel-&lt;-*$free ((x x) (y (<see topic=\"COMMON-LISP_____F2\">/</see> x)) (z 1)))))))</code> \u000A \u000A <p>The <v>:restrict</v> hint above says that the variables <v>x</v>, <v>y</v>, and \u000A <v>z</v> in the rewrite rule <v>cancel-&lt;-*$free</v> above should be instantiated \u000A respectively by <v>x</v>, <v>(<see topic=\"COMMON-LISP_____F2\">/</see> x)</v>, and <v>1</v>.  Thus <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> y z)</v> becomes \u000A <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP_____F2\">/</see> x) 1)</v>, and this inequality is replaced by the corresponding \u000A instance of the right-hand-side of <v>cancel-&lt;-*$free</v>.  Since the current \u000A conjecture assumes <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> 1 x)</v>, that instance of the right-hand side \u000A simplifies to</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP_____A2\">*</see> x (<see topic=\"COMMON-LISP_____F2\">/</see> x)) (<see topic=\"COMMON-LISP_____A2\">*</see> x 1))</code> \u000A \u000A <p>which in turn simplifies to <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> 1 x)</v>, a hypothesis in the present \u000A theorem.</p></dd> \u000A \u000A <dt><v>:rw-cache-state</v></dt><p/> \u000A \u000A <dd><p><v>Value</v> is an element of the list constant \u000A <v>*legal-rw-cache-states*</v>: <v>:atom</v> (the default), <v>nil</v>, <v>t</v>, or \u000A <v>:disabled</v>.  This hint applies to the indicated goal and all its \u000A descendents, to set the so-called ``rw-cache-state'' to the indicated value; \u000A see <see topic=\"ACL2____SET-RW-CACHE-STATE\">set-rw-cache-state</see>.</p></dd> \u000A \u000A <dt><v>:use</v></dt><p/> \u000A \u000A <dd><p>Examples of <v>:USE</v> hints are shown near the top of this \u000A documentation topic.</p> \u000A \u000A <p><v>Value</v> is a <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see> or a true list of <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>s, indicating that the propositions denoted by the instances be \u000A added as hypotheses to the specified goal.  See <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>.  Note \u000A that <v>:use</v> makes the given instances available as ordinary hypotheses of \u000A the formula to be proved.  The <v>:instance</v> form of a <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see> \u000A permits you to instantiate the free variables of previously proved theorems \u000A any way you wish; but it is up to you to provide the appropriate \u000A instantiations because once the instances are added as hypotheses their \u000A variables are no longer instantiable.  These new hypotheses participate fully \u000A in all subsequent rewriting, etc.  If the goal in question is in fact an \u000A instance of a previously proved theorem, you may wish to use <v>:by</v> below. \u000A Note that <see topic=\"ACL2____THEORIES\">theories</see> may be helpful when employing <v>:use</v> hints; see \u000A <see topic=\"ACL2____MINIMAL-THEORY\">minimal-theory</see>.</p> \u000A \u000A <p>Note that if the value is the name of a function symbol introduced by \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, then the ``normalized'' body of that definition is used, for \u000A which ACL2 has propagated <v>IF</v> tests upward.  This behavior differs from \u000A that provided by a <v>:by</v> hint, where the original body of the definition is \u000A used.</p></dd> \u000A \u000A </dl>"],

 "ACL2____FORCE":[["Rewrite","Linear","Type-prescription","Definition","Meta"],"ACL2 Sources","ACL2","<p><v>Force</v> is the identity function: <v>(<see topic=\"ACL2____FORCE\">force</see> x)</v> is equal to \u000A <v>x</v>.  However, for rules of many classes (see <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see>), a \u000A hypothesis of the form <v>(<see topic=\"ACL2____FORCE\">force</see> term)</v> is given special treatment, as \u000A described below.  This treatment takes place for rule classes <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>, <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt>, <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt>, <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt> (actually in that case, the result of \u000A evaluating the hypothesis metafunction call), and <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt>.</p> \u000A \u000A <p>When a hypothesis of a conditional rule (of one of the classes listed \u000A above) has the form <v>(<see topic=\"ACL2____FORCE\">force</see> hyp)</v>, it is logically equivalent to <v>hyp</v> \u000A but has a pragmatic effect.  In particular, when the rule is considered, the \u000A needed instance of the hypothesis, <v>hyp'</v>, may be assumed if the usual \u000A process fails to prove it or its negation.  In that situation, if the rule is \u000A eventually applied, then a special case is generated, requiring the system to \u000A prove that <v>hyp'</v> is true in the current context.  The proofs of all such \u000A ``forced assumptions'' are, by default, delayed until the successful \u000A completion of the main goal.  See <see topic=\"ACL2____FORCING-ROUND\">forcing-round</see> and see <see topic=\"ACL2____IMMEDIATE-FORCE-MODEP\">immediate-force-modep</see>.</p> \u000A \u000A <p>Note that the only time that ACL2 gives special treatment to calls of \u000A <v>force</v> is when it is considering the hypotheses of a conditional rule, as \u000A discussed above.  In particular, when the rewriter encounters a subterm of the \u000A goal currently being simplified, a call of <v>force</v> is not treated \u000A specially.  For example, if you provide a <v>:use</v> hint (see <see topic=\"ACL2____HINTS\">hints</see>) \u000A that replaces a goal <v>G</v> by the goal</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> ... (<see topic=\"ACL2____FORCE\">force</see> HYP) ...)\u000A                  concl)\u000A         G)</code> \u000A \u000A <p>then the rewriter will not give any special treatment to <tt>(force \u000A HYP)</tt>.  Instead, it will first rewrite <v>HYP</v> to, say, <v>HYP'</v>; and \u000A then, using the fact that <v>force</v> is the identity function, the rewriter \u000A will return <v>HYP'</v> as the rewritten value for <tt>(force HYP)</tt>.</p> \u000A \u000A <p>Forcing is generally used on hypotheses that are always expected to be \u000A true, as is commonly the case for <see topic=\"ACL2____GUARD\">guard</see>s of functions.  All the power \u000A of the theorem prover is brought to bear on a forced hypothesis and no \u000A backtracking is possible.  Forced goals can be attacked immediately (see <see topic=\"ACL2____IMMEDIATE-FORCE-MODEP\">immediate-force-modep</see>) or in a subsequent forcing round (see <see topic=\"ACL2____FORCING-ROUND\">forcing-round</see>).  Also see <see topic=\"ACL2____CASE-SPLIT\">case-split</see> for a related utility.  If the \u000A <v>:</v><tt><see topic=\"ACL2____EXECUTABLE-COUNTERPART\">executable-counterpart</see></tt> of the function <v>force</v> is <see topic=\"ACL2____DISABLE\">disable</see>d, then no hypothesis is forced.  For more on enabling and disabling \u000A forcing, see <see topic=\"ACL2____ENABLE-FORCING\">enable-forcing</see> and see <see topic=\"ACL2____DISABLE-FORCING\">disable-forcing</see>.</p> \u000A \u000A <p>It sometimes happens that a conditional rule is not applied because some \u000A hypothesis, <v>hyp</v>, could not be relieved, even though the required instance \u000A of <v>hyp</v>, <v>hyp'</v>, can be shown true in the context.  This happens when \u000A insufficient resources are brought to bear on <v>hyp'</v> at the time we try to \u000A relieve it.  A sometimes desirable alternative behavior is for the system to \u000A assume <v>hyp'</v>, apply the rule, and to generate explicitly a special case to \u000A show that <v>hyp'</v> is true in the context.  This is called ``forcing'' \u000A <v>hyp</v>.  It can be arranged by restating the rule so that the offending \u000A hypothesis, <v>hyp</v>, is embedded in a call of <v>force</v>, as in <v>(<see topic=\"ACL2____FORCE\">force</see>\u000A hyp)</v>.  By using the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> field of the <tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> entry, a hypothesis can be forced without changing the statement \u000A of the theorem from which the rule is derived.</p> \u000A \u000A <p>Technically, <v>force</v> is just a function of one argument that returns \u000A that argument.  It is generally <see topic=\"ACL2____ENABLE\">enable</see>d and hence evaporates during \u000A simplification.  But its presence among the hypotheses of a conditional rule \u000A causes case splitting to occur if the hypothesis cannot be conventionally \u000A relieved.</p> \u000A \u000A <p>Since a forced hypothesis must be provable whenever the rule is otherwise \u000A applicable, forcing should be used only on hypotheses that are expected always \u000A to be true.</p> \u000A \u000A <p>A particularly common situation in which some hypotheses should be forced \u000A is in ``most general'' <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> lemmas.  If a single lemma \u000A describes the ``expected'' type of a function, for all ``expected'' arguments, \u000A then it is probably a good idea to force the hypotheses of the lemma.  Thus, \u000A every time a term involving the function arises, the term will be given the \u000A expected type and its arguments will be required to be of the expected type. \u000A In applying this advice it might be wise to avoid forcing those hypotheses \u000A that are in fact just type predicates on the arguments, since the routine that \u000A applies <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> lemmas has fairly thorough knowledge of the \u000A types of all terms.</p> \u000A \u000A <p><v>Force</v> can have the additional benefit of causing the ACL2 typing \u000A mechanism to interact with the ACL2 rewriter to establish the hypotheses of \u000A <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules.  To understand this remark, think of the ACL2 \u000A type reasoning system as a rather primitive rule-based theorem prover for \u000A questions about Common Lisp types, e.g., ``does this expression produce a \u000A <tt><see topic=\"COMMON-LISP____CONSP\">consp</see></tt>?''  ``does this expression produce some kind of ACL2 number, \u000A e.g., an <tt><see topic=\"COMMON-LISP____INTEGERP\">integerp</see></tt>, a <tt><see topic=\"COMMON-LISP____RATIONALP\">rationalp</see></tt>, or a <tt><see topic=\"ACL2____COMPLEX-RATIONALP\">complex-rationalp</see></tt>?'' etc.  It is driven by <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules. \u000A To relieve the hypotheses of such rules, the type system recursively invokes \u000A itself.  This can be done for any hypothesis, whether it is ``type-like'' or \u000A not, since any proposition, <v>p</v>, can be phrased as the type-like question \u000A ``does <v>p</v> produce an object of type <v>nil</v>?''  However, as you might \u000A expect, the type system is not very good at establishing hypotheses that are \u000A not type-like, unless they happen to be assumed explicitly in the context in \u000A which the question is posed, e.g., ``If <v>p</v> produces a <tt><see topic=\"COMMON-LISP____CONSP\">consp</see></tt> then \u000A does <v>p</v> produce <v>nil</v>?''  If type reasoning alone is insufficient to \u000A prove some instance of a hypothesis, then the instance will not be proved by \u000A the type system and a <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rule with that hypothesis will \u000A be inapplicable in that case.  But by embedding such hypotheses in <v>force</v> \u000A expressions you can effectively cause the type system to ``punt'' them to the \u000A rest of the theorem prover.  Of course, as already noted, this should only be \u000A done on hypotheses that are ``always true.''  In particular, if rewriting is \u000A required to establish some hypothesis of a <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rule, then \u000A the rule will be found inapplicable because the hypothesis will not be \u000A established by type reasoning alone.</p> \u000A \u000A <p>The ACL2 rewriter uses the type reasoning system as a subsystem.  It is \u000A therefore possible that the type system will force a hypothesis that the \u000A rewriter could establish.  Before a forced hypothesis is reported out of the \u000A rewriter, we try to establish it by rewriting.</p> \u000A \u000A <p>This makes the following surprising behavior possible: A <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rule fails to apply because some true hypothesis is not \u000A being relieved.  The user changes the rule so as to <b>force</b> the \u000A hypothesis.  The system then applies the rule but reports no forcing.  How can \u000A this happen?  The type system ``punted'' the forced hypothesis to the \u000A rewriter, which established it.</p> \u000A \u000A <p>Finally, we should mention that the rewriter is never willing to force when \u000A there is an <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> term present in the goal being simplified.  Since \u000A <tt><see topic=\"COMMON-LISP____AND\">and</see></tt> terms and <tt><see topic=\"COMMON-LISP____OR\">or</see></tt> terms are merely abbreviations for <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> \u000A terms, they also prevent forcing.  Note that <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> terms are ultimately \u000A eliminated using the ordinary flow of the proof (but see <see topic=\"ACL2____SET-CASE-SPLIT-LIMITATIONS\">set-case-split-limitations</see>), allowing <v>force</v> ultimately to function as \u000A intended.  Moreover, forcing can be disabled, as described above; also see \u000A <see topic=\"ACL2____DISABLE-FORCING\">disable-forcing</see>.</p> \u000A \u000A <p><b>Function: </b><srclink>force</srclink></p><code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> force (x)\u000A       (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t))\u000A       x)</code>"],

 "ACL2____ENCAPSULATE":[["Events"],"ACL2 Sources","ACL2","<p><v>Encapsulate</v> provides a way to execute a sequence of <see topic=\"ACL2____EVENTS\">events</see> and then hide some of the resulting effects.  There are two kinds of \u000A encapsulations: ``trivial'' and ``non-trivial''.  We discuss these briefly \u000A before providing detailed <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.</p> \u000A \u000A <p>A trivial encapsulation is an event of the following form.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A () ; nil here indicates &quot;trivial&quot;\u000A &lt;event-1&gt;\u000A ...\u000A &lt;event-k&gt;)</code> \u000A \u000A <p>We use the term ``sub-events'' to refer to <v>&lt;event-1&gt;</v> through \u000A <v>&lt;event-k&gt;</v>.  Each sub-event <v>&lt;event-i&gt;</v> may be ``<see topic=\"ACL2____LOCAL\">local</see>'', that \u000A is, of the form <v>(<see topic=\"ACL2____LOCAL\">local</see> &lt;event-i'&gt;)</v>; the other sub-events are called \u000A ``non-local''.  When this <v>encapsulate</v> form is submitted to ACL2, it is \u000A processed in two passes.  On the first pass, each sub-event is printed (by \u000A default) and processed in sequence; admission of the <v>encapsulate</v> fails if \u000A any <v>&lt;event-i&gt;</v> fails to be admitted.  Then a second pass is made after \u000A rolling back the logical <see topic=\"ACL2____WORLD\">world</see> to what it was just before executing the \u000A <v>encapsulate</v> form.  In the second pass, only the non-<see topic=\"ACL2____LOCAL\">local</see> forms \u000A <v>&lt;event-i&gt;</v> are evaluated, again in order, and proofs are skipped.</p> \u000A \u000A <p>For example, the following trivial encapsulation exports a single event, \u000A <v>member-equal-reverse</v>.  The lemma <v>member-revappend</v> is used (as a \u000A <see topic=\"ACL2____REWRITE\">rewrite</see> rule) to prove <v>member-equal-reverse</v> on the first pass, but \u000A since <v>member-revappend</v> is <see topic=\"ACL2____LOCAL\">local</see>, it is ignored on the second \u000A (final) pass.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A ()\u000A\u000A (<see topic=\"ACL2____LOCAL\">local</see>\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> member-revappend\u000A    (<see topic=\"ACL2____IFF\">iff</see> (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a (<see topic=\"COMMON-LISP____REVAPPEND\">revappend</see> x y))\u000A         (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a x)\u000A             (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a y)))\u000A    :hints ((&quot;Goal&quot; :induct (<see topic=\"COMMON-LISP____REVAPPEND\">revappend</see> x y)))))\u000A\u000A (<see topic=\"ACL2____DEFTHM\">defthm</see> member-equal-reverse\u000A   (<see topic=\"ACL2____IFF\">iff</see> (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a (<see topic=\"COMMON-LISP____REVERSE\">reverse</see> x))\u000A        (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a x))))</code> \u000A \u000A <p>Of course, one might prefer to prove these <see topic=\"ACL2____EVENTS\">events</see> at the top level, \u000A rather than within an encapsulation; but the point here is to illustrate that \u000A you can have <see topic=\"ACL2____LOCAL\">local</see> <see topic=\"ACL2____EVENTS\">events</see> that do not become part of the logical \u000A <see topic=\"ACL2____WORLD\">world</see>.  (Such a capability is also provided at the level of <see topic=\"ACL2____BOOKS\">books</see>; in particular, see <see topic=\"ACL2____INCLUDE-BOOK\">include-book</see>.)</p> \u000A \u000A <p>Note that trivial encapsulates must introduce at least one sub-event, or \u000A else they are treated as no-ops, with no effect on the logical <see topic=\"ACL2____WORLD\">world</see>. \u000A Consider the following example.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> nil (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x) x)))\u000A\u000ATo verify that the encapsulated event correctly extends the current\u000Atheory we will evaluate it.  The theory thus constructed is only ephemeral.\u000A\u000AEncapsulated Event:\u000A\u000A\u000AACL2 !&gt;&gt;(<see topic=\"ACL2____LOCAL\">LOCAL</see> (<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> F (X) X))\u000A\u000ASince F is non-recursive, its admission is trivial.  We observe that\u000Athe type of F is described by the theorem (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (F X) X).\u000A\u000ASummary\u000AForm:  ( DEFUN F ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000AF\u000A\u000AEnd of Encapsulated Event.\u000A\u000AACL2 Observation in ( ENCAPSULATE NIL (<see topic=\"ACL2____LOCAL\">LOCAL</see> ...) ...):  The submitted\u000Aencapsulate event has created no new ACL2 events, and thus is leaving\u000Athe ACL2 logical world unchanged.  See :DOC encapsulate.\u000A\u000ASummary\u000AForm:  ( ENCAPSULATE NIL (<see topic=\"ACL2____LOCAL\">LOCAL</see> ...) ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A :EMPTY-ENCAPSULATE\u000AACL2 !&gt;</code> \u000A \u000A <p>After the above evaluation, we are left in the <see topic=\"ACL2____WORLD\">world</see> with which we \u000A began.  For example, if you evaluate the above form in the initial ACL2 world, \u000A you can see the following both before and after that evaluation.</p> \u000A \u000A <code>ACL2 !&gt;:pbt 0\u000A           0:x(<see topic=\"ACL2____EXIT-BOOT-STRAP-MODE\">EXIT-BOOT-STRAP-MODE</see>)\u000AACL2 !&gt;</code> \u000A \u000A <p>On the other hand, non-trivial encapsulations provide a way to introduce \u000A axioms about new function symbols, without introducing inconsistency and \u000A without introducing complete definitions.  The following example illustrates \u000A how that works.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A\u000A; The following list has a single signature, introducing a function foo of\u000A; one argument that returns one value.  (<see topic=\"COMMON-LISP____THE\">The</see> list is non-empty, so we call\u000A; this a &quot;non-trivial&quot; encapsulation.)\u000A ( ((foo *) =&gt; *) )\u000A\u000A; Introduce a ``witness'' (example) for foo, marked as local so that\u000A; it is not exported:\u000A (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x))\u000A\u000A; Introduce a non-local property to be exported:\u000A (<see topic=\"ACL2____DEFTHM\">defthm</see> foo-preserves-consp\u000A   (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A            (<see topic=\"COMMON-LISP____CONSP\">consp</see> (foo x))))\u000A)</code> \u000A \u000A <p>The form above introduces a new function symbol, <v>foo</v>, with the \u000A indicated property and no definition.  In fact, the output from ACL2 concludes \u000A as follows.</p> \u000A \u000A <code>The following constraint is associated with the function FOO:\u000A\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X) (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> (FOO X)))</code> \u000A \u000A <p>To understand this example, we consider how non-trivial encapsulations are \u000A processed.  The same two passes are made as for trivial encapsulations, and \u000A the (<see topic=\"ACL2____LOCAL\">local</see>) definition of <v>foo</v> is ignored on the second pass, and \u000A hence does not appear in the resulting ACL2 logical <see topic=\"ACL2____WORLD\">world</see>.  But before \u000A the second pass, each <see topic=\"ACL2____SIGNATURE\">signature</see> is stored in the <see topic=\"ACL2____WORLD\">world</see>.  Thus, \u000A when the theorem <v>foo-preserves-consp</v> is encountered in the second pass, \u000A <v>foo</v> is a known function symbol with the indicated signature.</p> \u000A \u000A <p>If any event fails while evaluating a call of <v>encapsulate</v>, the entire \u000A <v>encapsulate</v> call is deemed to have failed, and the logical <see topic=\"ACL2____WORLD\">world</see> \u000A is rolled back to what it was immediately before the <v>encapsulate</v> \u000A call.</p> \u000A \u000A <p>We now provide detailed documentation.  But discussion of redundancy for \u000A <v>encapsulate</v> events may be found elsewhere; see <see topic=\"ACL2____REDUNDANT-ENCAPSULATE\">redundant-encapsulate</see>.</p> \u000A \u000A <code>Other Examples:\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> (((an-element *) =&gt; *))\u000A\u000A; The list of signatures above could also be written\u000A;            ((an-element (lst) t))\u000A\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> an-element (lst)\u000A           (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> lst) (<see topic=\"COMMON-LISP____CAR\">car</see> lst) nil)))\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"ACL2____DEFTHM\">defthm</see> member-equal-car\u000A            (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> lst (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> lst))\u000A                     (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> lst) lst))))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> thm1\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NULL\">null</see> lst) (<see topic=\"COMMON-LISP____NULL\">null</see> (an-element lst))))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> thm2\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> lst)\u000A                   (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____NULL\">null</see> lst)))\u000A              (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> (an-element lst) lst))))\u000A\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A () ; empty signature: no constrained functions indicated\u000A\u000A (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"ACL2____DEFTHM\">defthm</see> hack\u000A          (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____SYNTAXP\">syntaxp</see> (quotep x))\u000A                        (<see topic=\"ACL2____SYNTAXP\">syntaxp</see> (quotep y)))\u000A                   (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP_____B2\">+</see> x y z)\u000A                          (<see topic=\"COMMON-LISP_____B2\">+</see> (<see topic=\"COMMON-LISP_____B2\">+</see> x y) z)))))\u000A\u000A (<see topic=\"ACL2____DEFTHM\">defthm</see> nthcdr-add1-conditional\u000A   (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"ACL2____ZP\">zp</see> (<see topic=\"COMMON-LISP____1_B2\">1+</see> n)))\u000A            (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____NTHCDR\">nthcdr</see> (<see topic=\"COMMON-LISP____1_B2\">1+</see> n) x)\u000A                   (<see topic=\"COMMON-LISP____NTHCDR\">nthcdr</see> n (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))))))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> (<see topic=\"ACL2____SIGNATURE\">signature</see> ... signature)\u000A  ev1\u000A  ...\u000A  evn)</code> \u000A \u000A <p>where each <tt><see topic=\"ACL2____SIGNATURE\">signature</see></tt> is a well-formed signature, each \u000A <v>signature</v> describes a different function symbol, and each <v>evi</v> is an \u000A embedded event form (See <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see>).  Also see <see topic=\"ACL2____SIGNATURE\">signature</see>, in particular for a discussion of how a signature can assign a \u000A <see topic=\"ACL2____GUARD\">guard</see> to a function symbol.  There must be at least one <v>evi</v>.  The \u000A <v>evi</v> inside <tt><see topic=\"ACL2____LOCAL\">local</see></tt> special forms are called ``local'' <see topic=\"ACL2____EVENTS\">events</see> \u000A below.  <see topic=\"ACL2____EVENTS\">Events</see> that are not <tt><see topic=\"ACL2____LOCAL\">local</see></tt> are sometimes said to be \u000A ``exported'' by the encapsulation.  We make the further restriction that no \u000A <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> event may be introduced in the scope of an <v>encapsulate</v> \u000A (not even by <v>encapsulate</v> or <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> events that are among \u000A the <v>evi</v>).  Furthermore, no non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> event \u000A is permitted in the scope of any <v>encapsulate</v> with a non-empty list of \u000A signatures.</p> \u000A \u000A <p>To be well-formed, an <v>encapsulate</v> event must have the properties that \u000A each event in the body (including the <tt><see topic=\"ACL2____LOCAL\">local</see></tt> ones) can be successfully \u000A executed in sequence and that in the resulting theory, each function mentioned \u000A among the <see topic=\"ACL2____SIGNATURE\">signature</see>s was introduced via a <tt><see topic=\"ACL2____LOCAL\">local</see></tt> event and has \u000A the <see topic=\"ACL2____SIGNATURE\">signature</see> listed.  (A utility is provided to assist in debugging \u000A failures of such execution; see <see topic=\"ACL2____REDO-FLAT\">redo-flat</see>.)  In addition, the body may \u000A contain no ``local incompatibilities'' which, roughly stated, means that the \u000A <see topic=\"ACL2____EVENTS\">events</see> that are not <tt><see topic=\"ACL2____LOCAL\">local</see></tt> must not syntactically require \u000A symbols defined by <tt><see topic=\"ACL2____LOCAL\">local</see></tt> <tt><see topic=\"ACL2____EVENTS\">events</see></tt>, except for the functions \u000A listed in the <see topic=\"ACL2____SIGNATURE\">signature</see>s.  See <see topic=\"ACL2____LOCAL-INCOMPATIBILITY\">local-incompatibility</see>.  Finally, \u000A no non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> recursive definition in the body may involve in its \u000A suggested induction scheme any function symbol listed among the <see topic=\"ACL2____SIGNATURE\">signature</see>s.  See <see topic=\"ACL2____SUBVERSIVE-RECURSIONS\">subversive-recursions</see>.</p> \u000A \u000A <p>Observe that if the <see topic=\"ACL2____SIGNATURE\">signature</see>s list is empty, the resulting \u000A ``trivial'' <v>encapsulate</v> may still be useful for deriving theorems to be \u000A exported whose proofs require lemmas you prefer to hide (i.e., made <tt><see topic=\"ACL2____LOCAL\">local</see></tt>).  Whether trivial or not (i.e., whether the signature is empty or \u000A not), <v>encapsulate</v> exports the results of evaluating its non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> \u000A <see topic=\"ACL2____EVENTS\">events</see>, but its <tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> are ignored for the \u000A resulting logical <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <p>The result of a non-trivial <v>encapsulate</v> event is an extension of the \u000A logic in which, roughly speaking, the functions listed in the <see topic=\"ACL2____SIGNATURE\">signature</see>s are constrained to have the <see topic=\"ACL2____SIGNATURE\">signature</see>s listed and to \u000A satisfy the non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> theorems proved about them.  In fact, other \u000A functions introduced in the <v>encapsulate</v> event may be considered to have \u000A ``<see topic=\"ACL2____CONSTRAINT\">constraint</see>s'' as well.  (See <see topic=\"ACL2____CONSTRAINT\">constraint</see> for details, which are \u000A only relevant to functional instantiation.)  Since the <see topic=\"ACL2____CONSTRAINT\">constraint</see>s were \u000A all theorems in the ``ephemeral'' or ``local'' theory, we are assured that the \u000A extension produced by <v>encapsulate</v> is sound.  In essence, the <tt><see topic=\"ACL2____LOCAL\">local</see></tt> definitions of the constrained functions are just ``witness functions'' \u000A that establish the consistency of the <see topic=\"ACL2____CONSTRAINT\">constraint</see>s.  Because those \u000A definitions are <tt><see topic=\"ACL2____LOCAL\">local</see></tt>, they are not present in the theory produced by \u000A encapsulation.  After a non-trivial <v>encapsulate</v> event is admitted, \u000A theorems about the constrained function symbols may then be proved &mdash; \u000A theorems whose proofs necessarily employ only the <see topic=\"ACL2____CONSTRAINT\">constraint</see>s.  Thus, \u000A those theorems may be later functionally instantiated, as with the \u000A <v>:functional-instance</v> lemma instance (see <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>), to \u000A derive analogous theorems about different functions, provided the constraints \u000A (see <see topic=\"ACL2____CONSTRAINT\">constraint</see>) can be proved about the new functions.</p> \u000A \u000A <p>The <see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see> for the first event in an encapsulation is \u000A the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> ``outside'' the encapsulation.  But since <see topic=\"ACL2____EVENTS\">events</see> changing the <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> are permitted within the body of an \u000A <v>encapsulate</v>, the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> may be changed.  However, \u000A <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> changes occurring within the body of the <v>encapsulate</v> \u000A are not exported.  In particular, the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> after an \u000A <v>encapsulate</v> is always the same as it was before the <v>encapsulate</v>, \u000A even though the <v>encapsulate</v> body might contain <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> changing \u000A <see topic=\"ACL2____EVENTS\">events</see>, <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> and <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  See <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>.  More generally, after execution of an <v>encapsulate</v> event, \u000A the value of <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> is restored to what it was \u000A immediately before that event was executed.  See <see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see>.</p> \u000A \u000A <p>We make some remarks on <see topic=\"ACL2____GUARD\">guard</see>s and evaluation.  Calls of functions \u000A introduced in the <see topic=\"ACL2____SIGNATURE\">signature</see>s list cannot be evaluated in the ACL2 \u000A read-eval-print loop.  See <see topic=\"ACL2____DEFATTACH\">defattach</see> for a way to overcome this \u000A limitation.  Moreover, any <v>:</v><tt><see topic=\"ACL2____GUARD\">guard</see></tt> supplied in the signature is \u000A automatically associated in the <see topic=\"ACL2____WORLD\">world</see> with its corresponding function \u000A symbol, with no requirement other than that the guard is a legal term all of \u000A whose function symbols are in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode with their <see topic=\"ACL2____GUARD\">guard</see>s verified.  In particular, there need not be any relationship between a \u000A guard in a signature and the guard in a <v>local</v> witness function.  Finally, \u000A note that for functions introduced non-<see topic=\"ACL2____LOCAL\">local</see>ly inside a non-trivial \u000A <v>encapsulate</v> event, <see topic=\"ACL2____GUARD\">guard</see> verification is illegal unless ACL2 \u000A determines that the proof obligations hold outside the <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> \u000A event as well.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A ((f (x) t))\u000A (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x) (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t)) (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)))\u000A ;; ERROR!\u000A (<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x)\u000A   (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (f x)))\u000A   (<see topic=\"COMMON-LISP____CAR\">car</see> x)))</code> \u000A \u000A <p>The order of the <see topic=\"ACL2____EVENTS\">events</see> in the vicinity of an <v>encapsulate</v> is \u000A confusing.  We discuss it in some detail here because when logical names are \u000A being used with theory functions to compute sets of rules, it is sometimes \u000A important to know the order in which <see topic=\"ACL2____EVENTS\">events</see> were executed.  (See <see topic=\"ACL2____LOGICAL-NAME\">logical-name</see> and see <see topic=\"ACL2____THEORY-FUNCTIONS\">theory-functions</see>.)  What, for example, is the set \u000A of function names extant in the middle of an encapsulation?</p> \u000A \u000A <p>If the most recent event is <v>previous</v> and then you execute an \u000A <v>encapsulate</v> constraining <v>an-element</v> with two non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> in its body, <v>thm1</v> and <v>thm2</v>, then the order of the <see topic=\"ACL2____EVENTS\">events</see> after the encapsulation is (reading chronologically forward): \u000A <v>previous</v>, <v>thm1</v>, <v>thm2</v>, <v>an-element</v> (the <v>encapsulate</v> \u000A itself).  Actually, between <v>previous</v> and <v>thm1</v> certain extensions \u000A were made to the <see topic=\"ACL2____WORLD\">world</see> by the superior <v>encapsulate</v>, to permit \u000A <v>an-element</v> to be used as a function symbol in <v>thm1</v>.</p> \u000A \u000A <p>Remark for ACL2(r) (see <see topic=\"COMMON-LISP____REAL\">real</see>).  For ACL2(r), <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> can \u000A be used to introduce classical and non-classical functions, as determined by \u000A the signatures; see <see topic=\"ACL2____SIGNATURE\">signature</see>.  Those marked as classical (respectively \u000A non-classical) must have classical (respectively, non-classical) <tt><see topic=\"ACL2____LOCAL\">local</see></tt> \u000A witness functions.  A related requirement applies to functional instantiation; \u000A see <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>.</p>"],

 "ACL2____CERTIFY-BOOK":[["Books-reference","Books-tour"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot;)          ; certify in a world with 0 commands\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 3)        ; ... in a world with 3 commands\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; ?)        ; ... in a world without checking the\u000A                                   ;     number of commands\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 0 nil)    ; ... without compilation\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 0 t)      ; ... with compilation (<see topic=\"ACL2____DEFAULT\">default</see>)\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 0 t :ttags (foo))\u000A                                   ; ... allowing trust tag (<see topic=\"ACL2____TTAG\">ttag</see>) foo\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 0 t :ttags :all)\u000A                                   ; ... allowing all trust tags (ttags)\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; t)        ; ... from world of old certificate\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;my-arith&quot; 0 nil :acl2x t)\u000A                                   ; ... writing or reading a .acl2x file\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> book-name\u000A              k                       ; [default 0]\u000A              compile-flg             ; [default t]\u000A              :defaxioms-okp t/nil    ; [default nil]\u000A              :skip-proofs-okp t/nil  ; [default nil]\u000A              :ttags ttags            ; [default nil]\u000A              :acl2x t/nil            ; [default nil]\u000A              :ttagsx ttags           ; [default nil]\u000A              :pcert pcert            ; [default nil]\u000A              :write-port t/nil       ; [default t unless pcert is non-nil]\u000A              )</code> \u000A \u000A <p>where <v>book-name</v> is a book name (see <see topic=\"ACL2____BOOK-NAME\">book-name</see>), <v>k</v> is used \u000A to indicate your approval of the ``certification <see topic=\"ACL2____WORLD\">world</see>,'' and \u000A <v>compile-flg</v> can control whether the book is to be compiled.  The defaults \u000A for <v>compile-flg</v>, <v>skip-proofs-okp</v>, <v>acl2x</v>, <v>write-port</v>, and \u000A <v>pcert</v> can be affected by environment variables.  All of these arguments \u000A are described in detail below, except for <v>:pcert</v>.  (We assume below that \u000A the value of <v>:pcert</v> is <v>nil</v> (and environment variable \u000A <v>ACL2_PCERT_ARG</v> is unset or the empty string).  For a discussion of this \u000A argument, see <see topic=\"ACL2____PROVISIONAL-CERTIFICATION\">provisional-certification</see>.)</p> \u000A \u000A <p>Certification occurs in some logical <see topic=\"ACL2____WORLD\">world</see>, called the \u000A ``certification <see topic=\"ACL2____WORLD\">world</see>.''  That <see topic=\"ACL2____WORLD\">world</see> must contain the <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt>s needed to read and execute the forms in the book.  The <see topic=\"ACL2____COMMAND\">command</see>s necessary to recreate that <see topic=\"ACL2____WORLD\">world</see> from the ACL2 initial <see topic=\"ACL2____WORLD\">world</see> are called the ``<see topic=\"ACL2____PORTCULLIS\">portcullis</see> commands,'' and will be copied into \u000A the <see topic=\"ACL2____CERTIFICATE\">certificate</see> created for the book.  Those <see topic=\"ACL2____COMMAND\">command</see>s will be \u000A re-executed whenever the book is included, to ensure that the appropriate \u000A packages (and all other names used in the certification <see topic=\"ACL2____WORLD\">world</see>) are \u000A correctly defined.  Note that Step 1 of <v>certify-book</v> will fail if a \u000A package mentioned in the book is not defined before attempting the \u000A certification, i.e., defined by a portcullis command in the certification \u000A world.  For example, suppose that your book contains the symbol <v>FOO::X</v>, \u000A but the package \"FOO\" is not currently defined.  Then an error message will \u000A likely complain either about a missing package <v>&quot;FOO&quot;</v>, or about a symbol \u000A <v>FOO::X</v> that is ``not in any of the packages known to ACL2.''  A solution \u000A is to define the package \"FOO\", perhaps directly using <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> or by \u000A including a book that defines this package, before attempting the \u000A certification.</p> \u000A \u000A <p>The certified book will be more often usable if the certification <see topic=\"ACL2____WORLD\">world</see> is kept to a minimal extension of the ACL2 initial <see topic=\"ACL2____WORLD\">world</see> (for \u000A example, to prevent name clashes with functions defined in other books). \u000A Thus, before you call <v>certify-book</v> for the first time on a book, you may \u000A wish to get into the initial ACL2 <see topic=\"ACL2____WORLD\">world</see> (e.g., with <v>:ubt 1</v> or just \u000A starting a new version of ACL2), <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> the desired packages, and then \u000A invoke <v>certify-book</v>.</p> \u000A \u000A <p>The <v>k</v> argument to <v>certify-book</v> must be either a nonnegative \u000A integer or else one of the symbols <v>t</v> or <v>?</v> in any package.  If <v>k</v> \u000A is an integer, then it must be the number of <see topic=\"ACL2____COMMAND\">command</see>s that have been \u000A executed after the initial ACL2 <see topic=\"ACL2____WORLD\">world</see> to create the <see topic=\"ACL2____WORLD\">world</see> in \u000A which <v>certify-book</v> was called.  One way to obtain this number is by doing \u000A <v>:pbt :start</v> to see all the <see topic=\"ACL2____COMMAND\">command</see>s back to the first one.</p> \u000A \u000A <p>If <v>k</v> is <v>t</v> (or any symbol whose <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> is \u000A <v>&quot;T&quot;</v>), it means that <v>certify-book</v> should use the same <see topic=\"ACL2____WORLD\">world</see> \u000A used in the last certification of this book.  <v>K</v> may have such a value \u000A only if you call <v>certify-book</v> in the initial ACL2 <see topic=\"ACL2____WORLD\">world</see> and there \u000A is a <see topic=\"ACL2____CERTIFICATE\">certificate</see> on file for the book being certified.  (Of course, the \u000A <see topic=\"ACL2____CERTIFICATE\">certificate</see> is probably invalid.)  In this case, <v>certify-book</v> \u000A reads the old <see topic=\"ACL2____CERTIFICATE\">certificate</see> to obtain the <see topic=\"ACL2____PORTCULLIS\">portcullis</see> <see topic=\"ACL2____COMMAND\">command</see>s and executes them to recreate the certification <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <p>Finally, <v>k</v> may be <v>?</v> (or any symbol whose <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> is \u000A <v>&quot;?&quot;</v>), in which case there is no check made on the certification world. \u000A That is, if <v>k</v> is such a value then no action related to the preceding two \u000A paragraphs is performed, which can be a nice convenience but at the cost of \u000A eliminating a potentially valuable check that the certification <see topic=\"ACL2____WORLD\">world</see> \u000A may be as expected.</p> \u000A \u000A <p>We next describe the meaning of <v>compile-flg</v> and how it defaults.  If \u000A explicit compilation has been suppressed by <v>(<see topic=\"ACL2____SET-COMPILER-ENABLED\">set-compiler-enabled</see> nil\u000A state)</v>, then <v>compile-flg</v> is coerced to <v>nil</v>; see <see topic=\"ACL2____COMPILATION\">compilation</see>.  Otherwise <v>compile-flg</v> may be given the value of <v>t</v> (or \u000A <v>:all</v>, which is equivalent to <v>t</v> except during provisional \u000A certification; see <see topic=\"ACL2____PROVISIONAL-CERTIFICATION\">provisional-certification</see>), indicating that the book \u000A is to be compiled, or else <v>nil</v>.  (Note that compilation initially creates \u000A a compiled file with a temporary file name, and then moves that temporary file \u000A to the final compiled file name obtained by adding a suitable extension to the \u000A book name.  Thus, a compiled file will appear atomically in its intended \u000A location.)  Finally, suppose that <v>compile-flg</v> is not supplied (or is \u000A <v>:default</v>).  If environment variable <v>ACL2_COMPILE_FLG</v> is defined and \u000A not the empty string, then its value should be <v>T</v>, <v>NIL</v>, or <v>ALL</v> \u000A after converting to upper case, in which case <v>compile-flg</v> is considered \u000A to have value <v>t</v>, <v>nil</v>, or <v>:all</v> (respectively).  Otherwise \u000A <v>compile-flg</v> defaults to <v>t</v>.  Note that the value <v>:all</v> is \u000A equivalent to <v>t</v> except for during the Convert procedure of provisional \u000A certification; see <see topic=\"ACL2____PROVISIONAL-CERTIFICATION\">provisional-certification</see>.</p> \u000A \u000A <p>Two keyword arguments, <v>:defaxioms-okp</v> and <v>:skip-proofs-okp</v>, \u000A determine how the system handles the inclusion of <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> events and \u000A <tt><see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see></tt> events, respectively, in the book.  The value <v>t</v> \u000A allows such events, but prints a warning message.  The value <v>nil</v> causes \u000A an error if such an event is found.  <v>Nil</v> is the default unless keyword \u000A argument <v>:acl2x t</v> is provided and state global <v>'write-acl2x</v> is a \u000A cons (see <see topic=\"ACL2____SET-WRITE-ACL2X\">set-write-ACL2x</see>), in which case the default is <v>t</v>.</p> \u000A \u000A <p>The keyword argument <v>:ttags</v> may normally be omitted.  A few \u000A constructs, used for example if you are building your own system based on \u000A ACL2, may require it.  See <see topic=\"ACL2____DEFTTAG\">defttag</see> for an explanation of this \u000A argument.</p> \u000A \u000A <p>When book <v>B</v> is certified with value <v>t</v> (the default, unless the \u000A value used for <v>pcert</v> is non-<v>nil</v>) for keyword argument \u000A <v>:write-port</v>, a file <v>B.port</v> is written by certification process. \u000A This file contains all of the <see topic=\"ACL2____PORTCULLIS\">portcullis</see> <see topic=\"ACL2____COMMAND\">command</see>s for <v>B</v>, \u000A i.e., all user commands present in the ACL2 logical <see topic=\"ACL2____WORLD\">world</see> at the time \u000A <v>certify-book</v> is called.  if <v>B.lisp</v> later becomes uncertified, say \u000A because <see topic=\"ACL2____EVENTS\">events</see> from that file or an included book have been edited, \u000A then <v>(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;B&quot;)</v> will consult <v>B.port</v> to evaluate forms in \u000A that file before evaluating the events in <v>B.lisp</v>.  On the other hand, \u000A <v>B.port</v> is ignored when including <v>B</v> if <v>B</v> is certified.</p> \u000A \u000A <p>If you use <see topic=\"ACL2____GUARD\">guard</see>s, please note <v>certify-book</v> is executed as \u000A though <v>(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> nil)</v> has been evaluated; see <see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see>.  If you want guards checked, consider using <v>ld</v> \u000A instead, or in addition; see <see topic=\"ACL2____LD\">ld</see>.</p> \u000A \u000A <p>For a general discussion of books, see <see topic=\"ACL2____BOOKS\">books</see>.  <v>Certify-book</v> is \u000A akin to what we have historically called a ``proveall'': all the forms in the \u000A book are ``proved'' to guarantee their admissibility.  More precisely, \u000A <v>certify-book</v> (1) reads the forms in the book, confirming that the \u000A appropriate packages are defined in the certification <see topic=\"ACL2____WORLD\">world</see>; (2) does \u000A the full admissibility checks on each form (proving termination of recursive \u000A functions, proving theorems, etc.), checking as it goes that each form is an \u000A embedded event form (see <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see>); (3) may roll back the \u000A <see topic=\"ACL2____WORLD\">world</see> (how far? ~-[] see below) and perform an <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> to \u000A check for <tt><see topic=\"ACL2____LOCAL\">local</see></tt> incompatibilities (see <see topic=\"ACL2____LOCAL-INCOMPATIBILITY\">local-incompatibility</see>); (4) writes a <see topic=\"ACL2____CERTIFICATE\">certificate</see> recording not only \u000A that the book was certified but also recording the <see topic=\"ACL2____COMMAND\">command</see>s necessary \u000A to recreate the certification <see topic=\"ACL2____WORLD\">world</see> (so the appropriate packages can be \u000A defined when the book is included in other <see topic=\"ACL2____WORLD\">world</see>s) and the check sums \u000A of all the <see topic=\"ACL2____BOOKS\">books</see> involved (see <see topic=\"ACL2____CERTIFICATE\">certificate</see>); (5) compiles the \u000A book if so directed (and then loads the object file in that case).  The result \u000A of executing a <v>certify-book</v> <see topic=\"ACL2____COMMAND\">command</see> is the creation of a single \u000A new event, which is actually an <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> event.  If you don't want \u000A its included <see topic=\"ACL2____EVENTS\">events</see> in your present <see topic=\"ACL2____WORLD\">world</see>, simply execute \u000A <v>:</v><tt><see topic=\"ACL2____UBT\">ubt</see></tt> <v>:here</v> afterwards.</p> \u000A \u000A <p>Technical Remark.  Step 3 above mentions rolling the logical <see topic=\"ACL2____WORLD\">world</see> \u000A back to check for local incompatibilies.  For efficiency, this retraction to \u000A an initial segment of the the world is skipped if a local event is not \u000A encountered as described below; otherwise, the world is rolled back to the \u000A point just before the first such event was admitted.  For this purpose, a \u000A relevant local event is one at the top level of the book or under a sequences \u000A of <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> calls in the book.  Here, we include forms generated by \u000A <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt>.  But this category does not include local <see topic=\"ACL2____EVENTS\">events</see> \u000A within an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> event, since those are ignored in the final \u000A processing of the <v>encapsulate</v> event.  We also do not consider local \u000A events within an <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> event.  End of Technical Remark.</p> \u000A \u000A <p>A utility is provided to assist in debugging failures of <v>certify-book</v>; \u000A see <see topic=\"ACL2____REDO-FLAT\">redo-flat</see>.)</p> \u000A \u000A <p><v>Certify-book</v> requires that the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> (see <see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see>) be <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> when certification is attempted. \u000A If the mode is not <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>, an error is signalled.</p> \u000A \u000A <p>An error will occur if <v>certify-book</v> has to deal with any uncertified \u000A book other than the one on which it was called.  For example, if the book \u000A being certified includes another book, that sub-book must already have been \u000A certified; that is, that sub-book must have a valid <see topic=\"ACL2____CERTIFICATE\">certificate</see> \u000A file.</p> \u000A \u000A <p>If you have a certified book that has remained unchanged for some time you \u000A might well not remember the appropriate <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt>s for it, though they \u000A are stored in the <see topic=\"ACL2____CERTIFICATE\">certificate</see> file and (by default) also in the \u000A <v>.port</v> file.  If you begin to change the book, don't throw away its <see topic=\"ACL2____CERTIFICATE\">certificate</see> file just because it has become invalid!  It is an important \u000A historical document until the book is re-certified.  More important, don't \u000A throw away the <v>.port</v> file, as it will provide the <see topic=\"ACL2____PORTCULLIS\">portcullis</see> \u000A commands when including the book as an uncertified book; see <see topic=\"ACL2____INCLUDE-BOOK\">include-book</see>.</p> \u000A \u000A <p>When <v>certify-book</v> is directed to produce a compiled file, it calls the \u000A Common Lisp function <v>compile-file</v> on the original source file.  This \u000A creates a compiled file with an extension known to ACL2, e.g., if the book is \u000A named <v>&quot;my-book&quot;</v> then the source file is <v>&quot;my-book.lisp&quot;</v> and the \u000A compiled file under GCL will be <v>&quot;my-book.o&quot;</v> while under SBCL it will be \u000A <v>&quot;my-book.fasl&quot;</v>.  The compiled file is then loaded.  When <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> is used later on <v>&quot;my-book&quot;</v> it will automatically load the \u000A compiled file, provided the compiled file has a later write date than the \u000A source file.  The only effect of such <see topic=\"ACL2____COMPILATION\">compilation</see> and loading is that \u000A the functions defined in the book execute faster.  See <see topic=\"ACL2____GUARD\">guard</see> for a \u000A discussion of the issues, and if you want more details about <see topic=\"ACL2____BOOKS\">books</see> and \u000A compilation, see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see>.</p> \u000A \u000A <p>When <v>certify-book</v> is directed not to produce a compiled file, it will \u000A delete any existing compiled file for the book, so as not to mislead <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> into loading the now outdated compiled file.  Otherwise, \u000A <v>certify-book</v> will create a temporary ``expansion file'' to compile, \u000A obtained by appending the string \"@expansion.lsp\" to the end of the book \u000A name.  Remark: Users may ignore that file, which is automatically deleted \u000A unless <see topic=\"ACL2____STATE\">state</see> global variable <v>'save-expansion-file</v> has been set, \u000A presumably by a system developer, to a non-<v>nil</v> value; see <see topic=\"ACL2____BOOK-COMPILED-FILE\">book-compiled-file</see> for more information about hit issue, including the role \u000A of environment variable <v>ACL2_SAVE_EXPANSION</v>.</p> \u000A \u000A <p>After execution of a <v>certify-book</v> form, the value of <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> is restored to what it was immediately before that \u000A <v>certify-book</v> form was executed.  See <see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see>.</p> \u000A \u000A <p>Those who use the relatively advanced features of trust tags (see <see topic=\"ACL2____DEFTTAG\">defttag</see>) and <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> may wish to know how to create a <see topic=\"ACL2____CERTIFICATE\">certificate</see> file that avoids dependence on trust tags that are used only \u000A during <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> expansion.  For this, including documentation of the \u000A <v>:acl2x</v> and <v>:ttagsx</v> keyword arguments for <v>certify-book</v>, see \u000A <see topic=\"ACL2____SET-WRITE-ACL2X\">set-write-ACL2x</see>.</p> \u000A \u000A <p>This completes the tour through the <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> of <see topic=\"ACL2____BOOKS\">books</see>.</p>"],

 "ACL2____DEFUN-MODE":[["Defun"],"ACL2 Sources","ACL2","<p>Two ``<see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>s'' are supported, <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> and \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  Roughly speaking, <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode allows you \u000A to prototype a function for execution without any proof burdens, while \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode allows you to add a new definitional axiom to the \u000A logic.  The system comes up in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode.  Execution of \u000A functions whose <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> is <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> may render ACL2 \u000A unsound!  See <see topic=\"ACL2____DEFUN-MODE-CAVEAT\">defun-mode-caveat</see>.</p> \u000A \u000A <p>Note that calls of <tt><see topic=\"ACL2____LOCAL\">local</see></tt> and of many <see topic=\"ACL2____EVENTS\">events</see> are skipped in \u000A <v>:program</v> mode; see <see topic=\"ACL2____PROGRAM\">program</see>.</p> \u000A \u000A <p>When you define a function in the ACL2 logic, that function can be run on \u000A concrete data.  But it is also possible to reason deductively about the \u000A function because each definition extends the underlying logic with a \u000A definitional axiom.  To ensure that the logic is sound after the addition of \u000A this axiom, certain restrictions have to be met, namely that the recursion \u000A terminates.  This can be quite challenging.</p> \u000A \u000A <p>Because ACL2 is a <see topic=\"ACL2____PROGRAMMING\">programming</see> language, you often may wish simply to \u000A program in ACL2.  For example, you may wish to define your system and test it, \u000A without any logical burden.  Or, you may wish to define ``utility'' functions \u000A &mdash; functions that are executed to help manage the task of building your \u000A system but functions whose logical properties are of no immediate concern. \u000A Such functions might be used to generate test data or help interpret the \u000A results of tests.  They might create files or explore the ACL2 database.  The \u000A termination arguments for such functions are an unnecessary burden provided no \u000A axioms about the functions are ever used in deductions.</p> \u000A \u000A <p>Thus, ACL2 introduces the idea of the ``<see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>'' of a function. \u000A The <v>:mode</v> keyword of <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>'s <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> <v>xarg</v> allows you \u000A to specify the <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> of a given definition.  If no <v>:mode</v> \u000A keyword is supplied, the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> is used; see <see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see>.</p> \u000A \u000A <p>There are two <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>s, each of which is written as a \u000A keyword:</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> &mdash; logically undefined but executable outside \u000A deductive contexts.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> &mdash; axiomatically defined as per the ACL2 \u000A definitional principle.</p> \u000A \u000A <p>It is possible to change the <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> of a function from \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> to <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  We discuss this below.</p> \u000A \u000A <p>We think of functions having <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode as ``dangerous'' \u000A functions, while functions having <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode are ``safe.''  The \u000A only requirement enforced on <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode functions is the \u000A syntactic one: each definition must be well-formed ACL2.  Naively speaking, if \u000A a <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function fails to terminate then no harm is done \u000A because no axiom is added (so inconsistency is avoided) and some invocations \u000A of the function may simply never return.  This simplistic justification of \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode execution is faulty because it ignores the damage \u000A that might be caused by ``mis-guarded'' functions.  See <see topic=\"ACL2____DEFUN-MODE-CAVEAT\">defun-mode-caveat</see>.</p> \u000A \u000A <p>We therefore implicitly describe an imagined implementation of <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>s that is safe and, we think, effective.  But please see <see topic=\"ACL2____DEFUN-MODE-CAVEAT\">defun-mode-caveat</see>.</p> \u000A \u000A <p>The default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> is <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  This means that when \u000A you <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> a function the system will try to prove termination.  If you \u000A wish to introduce a function of a different <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> use the \u000A <v>:mode</v> <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> keyword.  Below we show <v>fact</v> introduced as a \u000A function in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :mode :program))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n)) (<see topic=\"COMMON-LISP_____D3\">=</see> n 0))\u000A      1\u000A    (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n)))))</code> \u000A \u000A <p>No axiom is added to the logic as a result of this definition.  By \u000A introducing <v>fact</v> in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode we avoid the burden of a \u000A termination proof, while still having the option of executing the function. \u000A For example, you can type</p> \u000A \u000A <code>ACL2 !&gt;(fact 3)</code> \u000A \u000A <p>and get the answer <v>6</v>.  If you type <v>(fact -1)</v> you will get a hard \u000A lisp error due to ``infinite recursion.''</p> \u000A \u000A <p>However, the ACL2 theorem prover knows no axioms about <v>fact</v>.  In \u000A particular, if the term <v>(fact 3)</v> arises in a proof, the theorem prover is \u000A unable to deduce that it is <v>6</v>.  From the perspective of the theorem \u000A prover it is as though <v>fact</v> were an undefined function symbol of arity \u000A <v>1</v>.  Thus, modulo certain important issues (see <see topic=\"ACL2____DEFUN-MODE-CAVEAT\">defun-mode-caveat</see>), \u000A the introduction of this function in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode does not \u000A imperil the soundness of the system &mdash; despite the fact that the \u000A termination argument for <v>fact</v> was omitted &mdash; because nothing of \u000A interest can be proved about <v>fact</v>.  Indeed, we do not allow <v>fact</v> to \u000A be used in logical contexts such as conjectures submitted for proof.</p> \u000A \u000A <p>It is possible to convert a function from <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode to \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode at the cost of proving that it is admissible.  This \u000A can be done by invoking</p> \u000A \u000A <code>(<see topic=\"ACL2____VERIFY-TERMINATION\">verify-termination</see> fact)</code> \u000A \u000A <p>which is equivalent to submitting the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> of <v>fact</v>, again, \u000A but in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :mode :logic))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n)) (<see topic=\"COMMON-LISP_____D3\">=</see> n 0))\u000A      1\u000A    (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n)))))</code> \u000A \u000A <p>This particular event will fail because the termination argument requires \u000A that <v>n</v> be nonnegative.  A repaired <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, for example with <tt><see topic=\"COMMON-LISP_____D3\">=</see></tt> replaced by <tt><see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see></tt>, will succeed, and an axiom about <v>fact</v> will \u000A henceforth be available.</p> \u000A \u000A <p>Technically, <tt><see topic=\"ACL2____VERIFY-TERMINATION\">verify-termination</see></tt> submits a redefinition of the \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function.  This is permitted, even when <tt><see topic=\"ACL2____LD-REDEFINITION-ACTION\">ld-redefinition-action</see></tt> is <v>nil</v>, because the new definition is identical \u000A to the old (except for its <v>:mode</v> and, possibly, other non-logical \u000A properties).</p> \u000A \u000A <p>See <see topic=\"ACL2____GUARD\">guard</see> for a discussion of how to restrict the execution of \u000A functions.  <see topic=\"ACL2____GUARD\">Guard</see>s may be ``verified'' for functions in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode; see <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see>.</p>"],

 "ACL2____LINEAR":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <code>Example:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> length-member-leq-length       If inequality reasoning begins to\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____EQLABLEP\">eqlablep</see> e)           consider how (<see topic=\"COMMON-LISP____LENGTH\">length</see> (<see topic=\"COMMON-LISP____MEMBER\">member</see> a b))\u000A                (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x))        compares to any other term, add to\u000A           (<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> (<see topic=\"COMMON-LISP____LENGTH\">length</see> (<see topic=\"COMMON-LISP____MEMBER\">member</see> e x))   the set of known inequalities the fact\u000A               (<see topic=\"COMMON-LISP____LENGTH\">length</see> x)))            that it is no larger than (<see topic=\"COMMON-LISP____LENGTH\">length</see> b),\u000A  :rule-classes :linear)               provided (<see topic=\"ACL2____EQLABLEP\">eqlablep</see> a) and\u000A                                       (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> b) rewrite to t.\u000A\u000AGeneral Form:\u000A(<see topic=\"COMMON-LISP____AND\">and</see> ...\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> ...hi...)\u000A              (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> ...hk...)\u000A                       (<see topic=\"COMMON-LISP____AND\">and</see> ...\u000A                            (rel lhs rhs)\u000A                            ...)))\u000A     ...)</code> \u000A \u000A <p>We process the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> formula of one <v>:linear</v> rule \u000A class object to create one or more <v>:linear</v> rules.  The first step is to \u000A flatten the <tt><see topic=\"COMMON-LISP____AND\">and</see></tt> and <tt><see topic=\"ACL2____IMPLIES\">implies</see></tt> structure of the formula, \u000A transforming it into a conjunction of formulas, each of the form</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> h1 ... hn) (rel lhs rhs))</code> \u000A \u000A <p>where no hypothesis is a conjunction and <v>rel</v> is one of the inequality \u000A relations <tt><see topic=\"COMMON-LISP_____C3\">&lt;</see></tt>, <tt><see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see></tt>, <tt><see topic=\"COMMON-LISP_____D3\">=</see></tt>, <tt><see topic=\"COMMON-LISP_____F2_D3\">/=</see></tt>, <tt><see topic=\"COMMON-LISP_____E3\">&gt;</see></tt>, or <tt><see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see></tt>.  If necessary, the hypothesis of such a conjunct may be vacuous.  We \u000A create a <v>:linear</v> rule for each such conjunct, if possible, and otherwise \u000A cause an error.  To create a <v>:linear</v> rule from a term (i.e., from a \u000A single such conjunct), we apply the following sequence of transformations.</p> \u000A \u000A <ol> \u000A \u000A <li>Remove <see topic=\"ACL2____GUARD-HOLDERS\">guard-holders</see> such as <tt><see topic=\"ACL2____PROG2_42\">prog2$</see></tt> from the term to obtain \u000A <v>(<see topic=\"ACL2____IMPLIES\">implies</see> hyp concl)</v>, where <v>hyp</v> is <v>t</v> in the case of an \u000A unconditional rule.</li> \u000A \u000A <li>If <v>concl</v> is <v>(<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____NOT\">not</see> concl2))</v>, replace <v>concl</v> by \u000A <v>concl2</v>.</li> \u000A \u000A <li>For the resulting <v>concl</v>, replace <tt><see topic=\"COMMON-LISP_____D3\">=</see></tt> and <tt><see topic=\"COMMON-LISP_____F2_D3\">/=</see></tt> by <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt> and <v>not equal</v>, respectively.</li> \u000A \u000A <li>Finally, the resulting <v>concl</v> is processed (``linearized'') to attempt \u000A to create a corresponding polynomial or disjunction of two polynomials.  This \u000A process includes the evaluation of ground subexpressions, for example \u000A replacing <v>(<see topic=\"COMMON-LISP_____A2\">*</see> '3 '4)</v> by <v>'12</v>, and employs techniques that include \u000A <see topic=\"ACL2____TYPE-SET\">type-set</see> reasoning.</li> \u000A \u000A </ol> \u000A \u000A <p>Each rule has one or more ``trigger terms'' which may be specified by the \u000A user using the <v>:trigger-terms</v> field of the rule class or which may be \u000A defaulted to values chosen by the system.  We discuss the determination of \u000A trigger terms after discussing how linear rules are used.</p> \u000A \u000A <p><v>:Linear</v> rules are used by an arithmetic decision procedure during \u000A rewriting.  See <see topic=\"ACL2____LINEAR-ARITHMETIC\">linear-arithmetic</see> and see <see topic=\"ACL2____NON-LINEAR-ARITHMETIC\">non-linear-arithmetic</see>. \u000A Here we assume that the reader is familiar with the material described in \u000A <tt><see topic=\"ACL2____LINEAR-ARITHMETIC\">linear-arithmetic</see></tt>.</p> \u000A \u000A <p>Recall that we eliminate the unknowns of an inequality in term-order, \u000A largest unknowns first.  (See <see topic=\"ACL2____TERM-ORDER\">term-order</see>.)  In order to facilitate this \u000A strategy, we store the inequalities in ``linear pots''.  For purposes of the \u000A present discussion, let us say that an inequality is ``about'' its largest \u000A unknown.  Then, all of the inequalities about a particular unknown are stored \u000A in the same linear pot, and the pot is said to be ``labeled'' with that \u000A unknown.  This storage layout groups all of the inequalities which are \u000A potential candidates for cancellation with each other into one place.  It is \u000A also key to the efficient operation of <v>:linear</v> rules.</p> \u000A \u000A <p>If the arithmetic decision procedure has stabilized and not yielded a \u000A contradiction, we scan through the list of linear pots examining each label as \u000A we go.  If the trigger term of some <v>:linear</v> rule can be instantiated to \u000A match the label, we so instantiate that rule and attempt to relieve the \u000A hypotheses with general-purpose rewriting.  If we are successful, we rewrite \u000A each of the two terms being compared by the conclusion (which is an equality \u000A or inequality), under the substitution produced by the rule's instantation. \u000A We then add the resulting equality or inequality to our set of \u000A inequalities. This may let cancellation continue.</p> \u000A \u000A <p>Note: Problems may arise if you explicitly store a linear lemma under a \u000A trigger term that, when instantiated, is not the largest unknown in the \u000A instantiated concluding inequality.  Suppose for example you store the linear \u000A rule <v>(<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> (fn i j) (<see topic=\"COMMON-LISP_____F2\">/</see> i (<see topic=\"COMMON-LISP_____A2\">*</see> j j)))</v> under the trigger term <v>(fn i j)</v>. \u000A Then when the system ``needs'' an inequality about <v>(fn a b)</v>, (i.e., \u000A because <v>(fn a b)</v> is the label of some linear pot, and hence the largest \u000A unknown in some inequality), it will appeal to the rule and deduce <v>(<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> (fn\u000A a b) (<see topic=\"COMMON-LISP_____F2\">/</see> a (<see topic=\"COMMON-LISP_____A2\">*</see> b b)))</v>.  However, the largest unknown in this inequality is \u000A <v>(<see topic=\"COMMON-LISP_____F2\">/</see> a (<see topic=\"COMMON-LISP_____A2\">*</see> b b))</v> and hence it will be stored in a linear pot labeled with \u000A <v>(<see topic=\"COMMON-LISP_____F2\">/</see> a (<see topic=\"COMMON-LISP_____A2\">*</see> b b))</v>.  The original, triggering inequality which is in a pot \u000A about <v>(fn a b)</v> will therefore not be cancelled against the new one.  It \u000A is generally best to specify as a trigger term one of the ``maximal'' terms of \u000A the polynomial, as described below.</p> \u000A \u000A <p>We now describe how the trigger terms are determined.  Most of the time, \u000A the trigger terms are not specified by the user and are instead selected by \u000A the system.  However, the user may specify the terms by including an explicit \u000A <v>:trigger-terms</v> field in the rule class, e.g.,</p> \u000A \u000A <code>General Form of a Linear Rule Class:\u000A(:LINEAR :COROLLARY formula\u000A         :TRIGGER-TERMS (term1 ... termk))</code> \u000A \u000A <p>Each <v>termi</v> must be a term and must not be a variable, quoted constant, \u000A lambda application, <v>let-expression</v> or <v>if-expression</v>.  In addition, \u000A each <v>termi</v> must be such that if all the variables in the term are \u000A instantiated and then the hypotheses of the corollary formula are relieved \u000A (possibly instantiating additional free variables), then all the variables in \u000A the concluding inequality are instantiated.  We generate a linear rule for \u000A each conjuctive branch through the corollary and store each rule under each of \u000A the specified triggers.  Thus, if the corollary formula contains several \u000A conjuncts, the variable restrictions on the <v>termi</v> must hold for each \u000A conjunct.</p> \u000A \u000A <p>If <v>:trigger-terms</v> is omitted the system computes a set of trigger \u000A terms.  Each conjunct of the corollary formula may be given a unique set of \u000A triggers depending on the variables that occur in the conjunct and the addends \u000A that occur in the concluding inequality.  In particular, the trigger terms for \u000A a conjunct is the list of all ``maximal addends'' in the concluding \u000A inequality.</p> \u000A \u000A <p>The ``addends'' of <v>(<see topic=\"COMMON-LISP_____B2\">+</see> x y)</v> and <v>(<see topic=\"COMMON-LISP____-\">-</see> x y)</v> are the union of the \u000A addends of <v>x</v> and <v>y</v>.  The addends of <v>(<see topic=\"COMMON-LISP____-\">-</see> x)</v> and <v>(<see topic=\"COMMON-LISP_____A2\">*</see> n x)</v>, \u000A where <v>n</v> is a rational constant, is just <v>{x}</v>.  The addends of an \u000A inequality are the union of the addends of the left- and right-hand sides. \u000A The addends of any other term, <v>x</v>, is <v>{x}</v>.</p> \u000A \u000A <p>A term is maximal for a conjunct <v>(<see topic=\"ACL2____IMPLIES\">implies</see> hyps concl)</v> of the corollary \u000A if (a) the term is a non-variable, non-quote, non-lambda application, \u000A non-<tt><see topic=\"COMMON-LISP____LET\">let</see></tt> and non-<tt><see topic=\"COMMON-LISP____IF\">if</see></tt> expression, (b) the term contains enough \u000A variables so that when they are instantiated and the hypotheses are relieved \u000A (which may bind some free variables; see <see topic=\"ACL2____FREE-VARIABLES\">free-variables</see>) then all the \u000A variables in <v>concl</v> are instantiated, and (c) no other addend is always \u000A ``bigger'' than the term, in the technical sense described below.</p> \u000A \u000A <p>The technical notion referenced above depends on the notion of \u000A <i>fn-count</i>, the number of function symbols in a term, and \u000A <i>pseudo-fn-count</i>, which is essentially the number of function symbols \u000A implicit in a constant (see <see topic=\"ACL2____TERM-ORDER\">term-order</see>, specifically the discussion of \u000A ``pseudo-function application count'' at the end).  We say <v>term1</v> is \u000A always bigger than <v>term2</v> if all instances of <v>term1</v> have a larger \u000A fn-count (actually lexicographic order of fn-count and pseudo-fn-count) than \u000A the corresponding instances of <v>term2</v>.  This is equivalent to saying that \u000A the fn-count of <v>term1</v> is larger than that of <v>term2</v> (by ``fn-count'' \u000A here we mean the lexicographic order of fn-count and pseudo-fn-count) and the \u000A variable bag for <v>term2</v> is a subbag of that for <v>term1</v>.  For example, \u000A <v>(<see topic=\"COMMON-LISP_____F2\">/</see> a (<see topic=\"COMMON-LISP_____A2\">*</see> b b))</v> is always bigger than <v>(fn a b)</v> because the first has \u000A two function applications and <v>{a b}</v> is a subbag of <v>{a b b}</v>, but \u000A <v>(<see topic=\"COMMON-LISP_____F2\">/</see> a (<see topic=\"COMMON-LISP_____A2\">*</see> b b))</v> is not always bigger than <v>(fn a x)</v>.</p>"],

 "ACL2____DEFTTAG":[["Interfacing-tools","Events"],"ACL2 Sources","ACL2","<p><b>Introduction</b>.  This event is intended for advanced users \u000A who, in essence, want to build extensions of ACL2.  The typical intended use \u000A is to create <see topic=\"ACL2____BOOKS\">books</see> that extend the functionality of ACL2 in ways not \u000A allowed without a so-called ``active trust tag''.  A trust tag thus represents \u000A a contract: The writer of such a book is guaranteeing that the book extends \u000A ACL2 in a ``correct'' way as defined by the writer of the book.  The writer of \u000A the book will often have a small section of the book in the scope of an active \u000A trust tag that can be inspected by potential users of that book:</p> \u000A \u000A <code>&lt;initial part of book, which does not use trust tags&gt;\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> :some-ttag) ; install :some-ttag as an active trust tag\u000A&lt;various code that requires an active trust tag&gt;\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> nil)        ; remove active trust tag\u000A&lt;final part of book, which does not use trust tags&gt;</code> \u000A \u000A <p>Why might trust tags be needed?  The evaluation of certain functions can \u000A introduce bugs and even unsoundness, but can be useful in restricted ways that \u000A avoid such issues.  For example, <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt> can be used in an unsafe \u000A way, for example to overwrite files, or worse; see <see topic=\"ACL2____SYS-CALL\">sys-call</see> for a \u000A frightening example from Bob Boyer.  The following example shows that the \u000A function <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt> is restricted by default, but can be called after \u000A installing an active trust tag.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____SYS-CALL\">sys-call</see> &quot;pwd&quot; nil)\u000A\u000AACL2 Error in TOP-LEVEL:  The SYS-CALL function cannot be called unless\u000Aa trust tag is in effect.  See :DOC defttag.\u000A\u000AACL2 !&gt;(<see topic=\"ACL2____DEFTTAG\">defttag</see> t) ; Install :T as an active trust tag.\u000A\u000ATTAG NOTE: Adding ttag :T from the top level loop.\u000A T\u000AACL2 !&gt;(<see topic=\"ACL2____SYS-CALL\">sys-call</see> &quot;pwd&quot; nil) ; print the current directory and return NIL\u000A/u/kaufmann\u000ANIL\u000AACL2 !&gt;(<see topic=\"ACL2____DEFTTAG\">defttag</see> nil) ; Remove the active trust tag (using value NIL).\u000A NIL\u000AACL2 !&gt;(<see topic=\"ACL2____SYS-CALL\">sys-call</see> &quot;pwd&quot; nil) ; Now we get the error again:\u000A\u000AACL2 Error in TOP-LEVEL:  The SYS-CALL function cannot be called unless\u000Aa trust tag is in effect.  See :DOC defttag.\u000A\u000AACL2 !&gt;</code> \u000A \u000A <p>Of course, using <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt> with the Linux command <v>pwd</v> is not \u000A likely to cause any soundness problems!  So suppose we want to create a \u000A function that prints the working directory.  We might put the following <see topic=\"ACL2____EVENTS\">events</see> into a book that is to be certified.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IN-PACKAGE\">in-package</see> &quot;ACL2&quot;)\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> :pwd-ttag)\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> print-working-dir ()\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :mode :program))\u000A  (<see topic=\"ACL2____SYS-CALL\">sys-call</see> &quot;pwd&quot; nil))\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> nil) ; optional (<see topic=\"ACL2____BOOKS\">books</see> end with this implicitly)</code> \u000A \u000A <p>We can certify this book with a specification that <v>:pwd-ttag</v> is a \u000A legal trust tag:</p> \u000A \u000A <code>(<see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see> &quot;pwd&quot; 0 t :ttags (:pwd-ttag))</code> \u000A \u000A <p>One can now use this book by executing <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> with keyword \u000A parameter <v>:ttags (:pwd-ttag)</v> and then calling function \u000A <v>print-working-dir</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;pwd&quot; :ttags (:pwd-ttag))\u000A(print-working-dir) ; working directory is printed to terminal</code> \u000A \u000A <p><b>Detailed documentation.</b></p> \u000A \u000A <code>General Forms:\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> tag-name)\u000A(<see topic=\"ACL2____DEFTTAG\">defttag</see> tag-name :doc doc-string)</code> \u000A \u000A <p>where <v>tag-name</v> is a symbol.  <v>Doc-string</v>, if non-<v>nil</v>, is an \u000A optional string that can provide documentation but is essentially ignored by \u000A ACL2.  (For the rest of this discussion we ignore the <v>:doc</v> argument.)</p> \u000A \u000A <p>Note however that (other than the <v>:doc</v> argument), if <v>tag-name</v> is \u000A not <v>nil</v> then it is converted to a ``corresponding <see topic=\"COMMON-LISP____KEYWORD\">keyword</see>'': a \u000A symbol in the <v>&quot;KEYWORD&quot;</v> package with the same <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> as \u000A <v>tag-name</v>.  Thus, for example, <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> foo)</v> is equivalent to \u000A <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :foo)</v>.  Moreover, a non-<v>nil</v> symbol with a <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> of <v>&quot;NIL&quot;</v> is illegal for trust tags; thus, for example, \u000A <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :nil)</v> is illegal.</p> \u000A \u000A <p>This event introduces or removes a so-called active trust tag (or ``ttag'', \u000A pronounced ``tee tag'').  An active ttag is a <see topic=\"COMMON-LISP____KEYWORD\">keyword</see> symbol that is \u000A associated with potentially unsafe evaluation.  For example, calls of <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt> are illegal unless there is an active trust tag.  An active trust \u000A tag can be installed using a <v>defttag</v> event.  If one introduces an active \u000A ttag and then writes definitions with calls <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt>, presumably in a \u000A defensibly ``safe'' way, then responsibility for those calls is attributed to \u000A that ttag.  This attribution (or blame!) is at the level of <see topic=\"ACL2____BOOKS\">books</see>; a \u000A book's <see topic=\"ACL2____CERTIFICATE\">certificate</see> contains a list of ttags that are active in that \u000A book, or in a book that is included (possibly <see topic=\"ACL2____LOCAL\">local</see>ly), or in a book \u000A included in a book that is included (either inclusion being potentially <see topic=\"ACL2____LOCAL\">local</see>), and so on.  We explain all this in more detail below.</p> \u000A \u000A <p><v>(<see topic=\"ACL2____DEFTTAG\">Defttag</see> :tag-name)</v> is essentially equivalent to</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :ttag :tag-name)</code> \u000A \u000A <p>and hence is <tt><see topic=\"ACL2____LOCAL\">local</see></tt> to any <see topic=\"ACL2____BOOKS\">books</see> and <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> \u000A <see topic=\"ACL2____EVENTS\">events</see> in which it occurs; see <see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see>.  We say more \u000A about the scope of <v>defttag</v> forms below.</p> \u000A \u000A <p>Note: This is an event!  It does not print the usual event summary but \u000A nevertheless executes the above <tt><see topic=\"ACL2____TABLE\">table</see></tt> event and hence changes the ACL2 \u000A logical <see topic=\"ACL2____WORLD\">world</see>, and is so recorded.  Although no event summary is \u000A printed, it is important to note that the ``TTAG NOTE'', discussed below, is \u000A always printed for a non-nil <v>:tag-name</v> (unless deferred; see <see topic=\"ACL2____SET-DEFERRED-TTAG-NOTES\">set-deferred-ttag-notes</see>).</p> \u000A \u000A <p><b>Active ttags.</b> Suppose <v>tag-name</v> is a non-<v>nil</v> symbol.  Then \u000A <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :tag-name)</v> sets <v>:tag-name</v> to be the (unique) ``active \u000A ttag.''  There must be an active ttag in order for there to be any mention of \u000A certain function and macro symbols, including <tt><see topic=\"ACL2____SYS-CALL\">sys-call</see></tt>; evaluate the \u000A form <v>(<see topic=\"ACL2____STRIP-CARS\">strip-cars</see> *ttag-fns-and-macros*)</v> to see the full list of such \u000A symbols.  On the other hand, <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> nil)</v> removes the active ttag, if \u000A any; there is then no active ttag.  The scope of a <v>defttag</v> form in a book \u000A being certified or included is limited to subsequent forms in the same book \u000A before the next <v>defttag</v> (if any) in that book.  Similarly, if a \u000A <v>defttag</v> form is evaluated in the top-level loop, then its effect is \u000A limited to subsequent forms in the top-level loop before the next <v>defttag</v> \u000A in the top-level loop (if any).  Moreover, <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> is illegal \u000A when a ttag is active; of course, in such a circumstance one can execute \u000A <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> nil)</v> in order to allow book certification.</p> \u000A \u000A <p><b>Ttag notes and the ``certifier.''</b> When a <v>defttag</v> is executed \u000A with an argument other than <v>nil</v>, output is printed, starting on a fresh \u000A line with: <v>TTAG NOTE</v>.  For example:</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____DEFTTAG\">defttag</see> :foo)\u000A\u000ATTAG NOTE: Adding ttag :FOO from the top level loop.\u000A :FOO\u000AACL2 !&gt;</code> \u000A \u000A <p>If the <v>defttag</v> occurs in an included book, the message looks like \u000A this.</p> \u000A \u000A <code>TTAG NOTE (for included book): Adding ttag :FOO from file /u/smith/acl2/my-book.lisp.</code> \u000A \u000A <p>The ``<v>TTAG NOTE</v>'' message is always printed on a single line.  The \u000A intention is that one can search the standard output for all such notes in \u000A order to find all <i>defttag</i> events.  In a sense, <i>defttag</i> events \u000A can allow you to define your own system on top of ACL2 (for example, see <see topic=\"ACL2____PROGN_12\">progn!</see>).  So in order for someone else (who we might call the ``certifier'') \u000A to be confident that your collection of <see topic=\"ACL2____BOOKS\">books</see> is meaningful, that \u000A certifier should certify all the user-supplied books from scratch and check \u000A either that no <v>:ttags</v> were supplied to <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>, or else look \u000A for every <v>TTAG NOTE</v> in the standard output in order to locate all \u000A <v>defttag</v> <see topic=\"ACL2____EVENTS\">events</see> with non-<v>nil</v> tag name.  In this way, the \u000A certifier can in principle decide whether to be satisfied that those \u000A <v>defttag</v> events did not allow inappropriate forms in the user-supplied \u000A books.</p> \u000A \u000A <p>In order to eliminate much of the output from <v>TTAG NOTE</v>s, see <see topic=\"ACL2____SET-DEFERRED-TTAG-NOTES\">set-deferred-ttag-notes</see>.  Note however that the resulting security is \u000A somewhat less; therefore, a <v>TTAG NOTE</v> is printed when invoking \u000A <v>set-deferred-ttag-notes</v> to defer printing of ttag notes.</p> \u000A \u000A <p><b>Allowed ttags when certifying and including books.</b> A <v>defttag</v> \u000A form may not be evaluated unless its argument is a so-called ``allowed'' ttag. \u000A All ttags are allowed in the interactive top-level loop.  However, during \u000A <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> and <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, the set of allowed ttags is \u000A restricted according to the <v>:ttags</v> keyword argument.  If this argument is \u000A omitted then no ttag is allowed, so a <v>defttag</v> call will fail during book \u000A certification or inclusion in this case.  This restriction applies even to \u000A <v>defttag</v> forms already evaluated in the so-called certification <see topic=\"ACL2____WORLD\">world</see> at the time <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> is called.  But note that <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see>\u000A nil)</v> is always legal.</p> \u000A \u000A <p>A <v>:ttags</v> argument of <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> and <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> can \u000A have value <v>:all</v>, indicating that every ttag is allowed, i.e., no \u000A restriction is being placed on the arguments, just as in the interactive \u000A top-level loop.  In the case of <v>include-book</v>, an omitted <v>:ttags</v> \u000A argument or an argument of <v>:default</v> is treated as <v>:all</v>, except that \u000A warnings will occur when the book's <see topic=\"ACL2____CERTIFICATE\">certificate</see> includes ttags; but for \u000A <v>certify-book</v>, an omitted <v>ttags</v> argument is treated as <v>nil</v>. \u000A Otherwise, if the <v>:ttags</v> argument is supplied but not <v>:all</v>, then its \u000A value is a true list of ttag specifications, each having one of the following \u000A forms, where <v>sym</v> is a non-<v>nil</v> symbol which is treated as the \u000A corresponding <see topic=\"COMMON-LISP____KEYWORD\">keyword</see>.</p> \u000A \u000A <blockquote> \u000A \u000A <p>(1) <v>:sym</v></p> \u000A \u000A <p>(2) <v>(:sym)</v></p> \u000A \u000A <p>(3) <v>(:sym x1 x2 ... xk)</v>, where k &gt; 0 and each <v>xi</v> is a string, \u000A except that one <v>xi</v> may be <v>nil</v>.</p></blockquote> \u000A \u000A <p>In Case (1), <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :sym)</v> is allowed to occur in at most one book or \u000A else in the top-level loop (i.e., the certification world for a book under \u000A certification or a book being included).  Case (2) allows <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :sym)</v> \u000A to occur in an unlimited number of books.  For case (3) the <v>xi</v> specify \u000A where <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :sym)</v> may occur, as follows.  The case that <v>xi</v> is \u000A <v>nil</v> refers to the top-level loop, while all other <v>xi</v> are filenames, \u000A where the <v>&quot;.lisp&quot;</v> extension is optional and relative pathnames are \u000A considered to be relative to the connected book directory (see <see topic=\"ACL2____CBD\">cbd</see>). \u000A Note that the restrictions on <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :sym)</v> apply equally to any \u000A equivalent for based on the notion of ``corresponding keyword'' discussed \u000A above, e.g., <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> acl2::sym)</v>.</p> \u000A \u000A <p>An error message, as shown below, illustrates how ACL2 enforcess the notion \u000A of allowed ttags.  Suppose that you call <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> with argument \u000A <v>:ttags (:foo)</v>, where you have already executed <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> :foo)</v> in the \u000A certification world (i.e., before calling <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>).  Then ACL2 \u000A immediately associates the ttag <v>:foo</v> with <v>nil</v>, where again, <v>nil</v> \u000A refers to the top-level loop.  If ACL2 then encounters <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> foo)</v> \u000A inside that book, you will get the following error (using the full book name \u000A for the book, as shown):</p> \u000A \u000A <code>ACL2 Error in ( TABLE ACL2-DEFAULTS-TABLE ...):  The ttag :FOO associated\u000Awith file /u/smith/work/my-book.lisp is not among the set of ttags permitted\u000Ain the current context, specified as follows:\u000A  ((:FOO NIL)).\u000ASee :DOC defttag.</code> \u000A \u000A <p>In general the structure displayed by the error message, which is <v>((:FOO\u000A NIL))</v> in this case, represents the currently allowed ttags with elements as \u000A discussed in (1) through (3) above.  In this case, that list's unique element \u000A is <v>(:FOO NIL)</v>, meaning that ttag <v>:FOO</v> is only allowed at the top \u000A level (as represented by <v>NIL</v>).</p> \u000A \u000A <p><b>Associating ttags with books and with the top-level loop.</b> When a \u000A book is certified, each form <v>(<see topic=\"ACL2____DEFTTAG\">defttag</see> tag)</v> that is encountered for \u000A non-<v>nil</v> <v>tag</v> in that book or an included book is recorded in the \u000A generated <see topic=\"ACL2____CERTIFICATE\">certificate</see>, which associates the keyword corresponding to \u000A <v>tag</v> with the <see topic=\"ACL2____FULL-BOOK-NAME\">full-book-name</see> of the book containing that \u000A <v>deftag</v>.  If such a <v>defttag</v> form is encountered outside a book, hence \u000A in the <see topic=\"ACL2____PORTCULLIS\">portcullis</see> of the book being certified or one of its included \u000A books, then that keyword is associated with <v>nil</v> in the generated <see topic=\"ACL2____CERTIFICATE\">certificate</see>.  Note that the notion of ``included book'' here applies to the \u000A recursive notion of a book either included directly in the book being \u000A certified or else included in such a book, where we account even for <see topic=\"ACL2____LOCAL\">local</see>ly included books.</p> \u000A \u000A <p>For examples of ways to take advantage of ttags, see <see topic=\"ACL2____HACKER\">hacker</see>, <see topic=\"ACL2____INCLUDE-RAW\">include-raw</see>, <see topic=\"ACL2____QUICKLISP\">quicklisp</see>, and more generally <see topic=\"ACL2____INTERFACING-TOOLS\">interfacing-tools</see>. \u000A See also <see topic=\"ACL2____TTAGS-SEEN\">ttags-seen</see>, <see topic=\"ACL2____PROGN_12\">progn!</see>, <see topic=\"ACL2____REMOVE-UNTOUCHABLE\">remove-untouchable</see>, <see topic=\"ACL2____SET-RAW-MODE\">set-raw-mode</see>, and <see topic=\"ACL2____SYS-CALL\">sys-call</see>.</p>"],

 "COMMON-LISP____DOCUMENTATION":[["ACL2"],"ACL2 Sources","ACL2","<h3>Available Documentation</h3> \u000A \u000A <p>If you are new to ACL2, see the <see topic=\"ACL2____ACL2-TUTORIAL\">ACL2-tutorial</see> for introductory \u000A tours, tutorials, and information about textbooks about ACL2.  The <a \u000A href='http://www.cs.utexas.edu/users/moore/acl2'>ACL2 home page</a> also \u000A provides many links to academic publications about ACL2, including the ACL2 \u000A Workshop series.</p> \u000A \u000A <p>Beyond these resources, ACL2 has a vast <b>ACL2+Books Manual</b> with \u000A reference material covering the ACL2 system itself and also many <see topic=\"ACL2____COMMUNITY-BOOKS\">community-books</see>.  There are a few ways to access the manual:</p> \u000A \u000A <ul> \u000A \u000A <li><b>The online version (recommended).</b> If you expect to have an internet \u000A connection while using the documentation, you may prefer to use the online \u000A version of the <a href='http://www.cs.utexas.edu/users/moore/acl2/v7-1/combined-manual/index.html'>ACL2+Books Manual</a>.</li> \u000A \u000A <li><b>A local version.</b> If you sometimes work without an internet \u000A connection, you can <a href='download/'>download</a> a local copy of any \u000A web-based XDOC manual using the \"down arrow\" icon at the top of the page. \u000A You can alternately build your own copy of the manual; see <see topic=\"ACL2____Building_02the_02ACL2_B2Books_02Manual\">Building the ACL2+Books Manual</see>.</li> \u000A \u000A <li><b>The ACL2-Doc Emacs version.</b> If you would like to view the \u000A documentation using Emacs instead of a web browser, there is a feature-rich \u000A Emacs-based documentation browser provided by the ACL2 system.  See <see topic=\"ACL2____ACL2-DOC\">ACL2-doc</see> for details.</li> \u000A \u000A </ul> \u000A \u000A <p>While you are using ACL2, you can get documentation at the terminal with \u000A the <v>:</v><tt><see topic=\"ACL2____DOC\">doc</see></tt> command, e.g., by typing <v>:doc rewrite</v>.  This is \u000A often handy, but note that it won't show you any documentation for books that \u000A you haven't loaded yet!</p> \u000A \u000A <p>Separately from the ACL2+Books Manual, the <u>ACL2 User's Manual</u> is \u000A distributed with ACL2.  This is much like the ACL2+Books Manual but it does \u000A not include documentation from the books.  A web-based copy is included with \u000A the ACL2 distribution in directory <v>doc/manual/</v>, and you can easily get to \u000A it by opening file <v>doc/home-page.html</v> in your browser.</p> \u000A \u000A \u000A <h3>Documenting Your Books</h3> \u000A \u000A <p>ACL2's documentation is written using <see topic=\"ACL2____XDOC\">xdoc</see>.  You can use XDOC to \u000A document your own books and to build custom manuals for your organization.</p> \u000A \u000A <p>ACL2's documentation is found in the <see topic=\"ACL2____COMMUNITY-BOOKS\">community-books</see> and everyone is \u000A welcome to edit and contribute to it.  See in particular the file \u000A <v>books/system/doc/acl2-doc.lisp</v>.</p> \u000A \u000A \u000A <h3>Other Resources</h3> \u000A \u000A <p>If you want documentation on an ACL2 function or macro that is not \u000A documented, there are still several alternatives.</p> \u000A \u000A <code>ACL2 !&gt;:args fn</code> \u000A \u000A <p>will print the arguments and some other relevant information about the \u000A named function or macro.  This information is all gleaned from the definition \u000A and hence this is a definitive way to determine if <v>fn</v> is defined as a \u000A function or macro.</p> \u000A \u000A <p>You might also want to type:</p> \u000A \u000A <code>ACL2 !&gt;:pc fn</code> \u000A \u000A <p>which will print the <see topic=\"ACL2____COMMAND\">command</see> that introduced <v>fn</v>.  You should \u000A see <see topic=\"ACL2____COMMAND-DESCRIPTOR\">command-descriptor</see> for details on the kinds of input you can give \u000A the <v>:</v><tt><see topic=\"ACL2____PC\">pc</see></tt> command.</p>"],

 "ACL2____META":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <p>Meta rules extend the ACL2 simplifier with hand-written code to transform \u000A certain terms to equivalent ones.  To add a meta rule, the <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> formula must establish that the hand-written ``metafunction'' \u000A preserves the meaning of the transformed term.</p> \u000A \u000A <code>Examples:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-correct-1                ; Modify the rewriter to use fn to\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (evl x a)                  ; transform terms that are calls of\u000A         (evl (fn x) a))            ; nth or of foo.\u000A  :rule-classes ((:meta :trigger-fns (<see topic=\"COMMON-LISP____NTH\">nth</see> foo))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-correct-2                ; As above, but this illustrates\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)    ; that without loss of generality we\u000A                (<see topic=\"ACL2____ALISTP\">alistp</see> a))         ; may restrict x to be shaped like a\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (evl x a)         ; term and a to be an alist.\u000A                  (evl (fn x) a)))\u000A  :rule-classes ((:meta :trigger-fns (<see topic=\"COMMON-LISP____NTH\">nth</see> foo))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-correct-3                ; As above (with or without the\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)    ; hypotheses on x and a), with the\u000A                (<see topic=\"ACL2____ALISTP\">alistp</see> a)          ; additional restriction that the\u000A                (evl (hyp-fn x) a)) ; meaning of (hyp-fn x) is true in\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (evl x a)         ; the current context.  That is, the\u000A                  (evl (fn x) a)))  ; applicability of the transformation\u000A  :rule-classes                     ; may be dependent upon some computed\u000A  ((:meta :trigger-fns (<see topic=\"COMMON-LISP____NTH\">nth</see> foo)))) ; hypotheses.</code> \u000A \u000A <p>While our intention is that the set of ACL2 documentation topics is \u000A self-contained, readers might find it useful to see the following paper for an \u000A introduction to meta reasoning in ACL2.</p> \u000A \u000A <blockquote><p>W. A. Hunt, Jr., R. B. Krug, M. Kaufmann, J S. Moore and \u000A E. W. Smith, ``Meta Reasoning in ACL2.''  TPHOLs 2005, ed. J. Hurd and \u000A T. F. Melham, LNCS 3603, Springer-Verlag, Berlin, 2005, \u000A pp. 163-178.</p></blockquote> \u000A \u000A <p>A non-<v>nil</v> list of function symbols must be supplied as the value of \u000A the <v>:trigger-fns</v> field in a <v>:meta</v> rule class object (except that a \u000A macro alias can stand in for a function symbol; see <see topic=\"ACL2____ADD-MACRO-ALIAS\">add-macro-alias</see>).</p> \u000A \u000A <code>General Forms:\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)        ; this hyp is optional\u000A              (<see topic=\"ACL2____ALISTP\">alistp</see> a)              ; this hyp is optional\u000A              (ev (hyp-fn x ...) a)   ; this hyp is optional\u000A              ; meta-extract hyps may also be included (see below)\u000A              )\u000A         (equiv (ev x a)\u000A                (ev (fn x ...) a)))</code> \u000A \u000A <p>where <v>equiv</v> is a known <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> relation, <v>x</v> and <v>a</v> \u000A are distinct variable names, and <v>ev</v> is an evaluator function (see below), \u000A and <v>fn</v> is a function symbol, as is <v>hyp-fn</v> when provided.  The \u000A arguments to <v>fn</v> and <v>hyp-fn</v> should be identical.  In the most common \u000A case, both take a single argument, <v>x</v>, which denotes the term to be \u000A simplified.  If <v>fn</v> and/or <v>hyp-fn</v> are <see topic=\"ACL2____GUARD\">guard</see>ed, their <see topic=\"ACL2____GUARD\">guard</see>s should be trivially implied by <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt>.  We say the \u000A theorem above is a ``metatheorem'' or ``metalemma'' and <v>fn</v> is a \u000A ``metafunction'', and <v>hyp-fn</v> is a ``hypothesis metafunction''.</p> \u000A \u000A <p>If ``<v>...</v>'' is empty, i.e., the metafunctions take just one argument, \u000A we say they are ``vanilla flavored.''  If ``<v>...</v>'' is non-empty, we say \u000A the metafunctions are ``extended.''  Extended metafunctions can access <tt><see topic=\"ACL2____STATE\">state</see></tt> and context sensitive information to compute their results, within \u000A certain limits.  We discuss vanilla metafunctions here and recommend a \u000A thorough understanding of them before proceeding (at which time see <see topic=\"ACL2____EXTENDED-METAFUNCTIONS\">extended-metafunctions</see>).</p> \u000A \u000A <p>If a metafunction application to a term, <v>u</v>, evaluates to a result of \u000A the form <v>(<see topic=\"COMMON-LISP____IF\">if</see> TEST NEW-TERM u)</v>, then <v>TEST</v> is treated as an ``implicit \u000A hypothesis''.  For discussion of this relatively advanced feature, see <see topic=\"ACL2____META-IMPLICIT-HYPOTHESIS\">meta-implicit-hypothesis</see>.</p> \u000A \u000A <p>Additional hypotheses are supported, called ``meta-extract hypotheses''. \u000A These allow metafunctions to depend on the validity of certain terms extracted \u000A from the context or the logical <see topic=\"ACL2____WORLD\">world</see>.  These hypotheses provide a \u000A relatively advanced form of metatheorem so we explain them elsewhere; see \u000A <see topic=\"ACL2____META-EXTRACT\">meta-extract</see>.</p> \u000A \u000A <p>One might think that metafunctions and (if supplied) hypothesis \u000A metafunctions must be executable: that is, not constrained (i.e., introduced \u000A in the <see topic=\"ACL2____SIGNATURE\">signature</see> of <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> <see topic=\"ACL2____EVENTS\">events</see>), and not <see topic=\"COMMON-LISP____DECLARE\">declare</see>d <v>:</v><tt><see topic=\"ACL2____NON-EXECUTABLE\">non-executable</see></tt>.  After all, there is no point in \u000A installing a simplifier that cannot be run!  However, such a restriction is \u000A not enforced, because one could introduce a metafunction using <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> and then use <tt><see topic=\"ACL2____DEFATTACH\">defattach</see></tt> to attach it to an executable \u000A function; see <see topic=\"ACL2____DEFATTACH\">defattach</see>.</p> \u000A \u000A <p>We defer discussion of the case in which there is a hypothesis metafunction \u000A and for now address the case in which the other two hypotheses are \u000A present.</p> \u000A \u000A <p>In the discussion below, we refer to the argument, <v>x</v>, of <v>fn</v> and \u000A <v>hyp-fn</v> as a ``(translated) term,'' i.e., an object satisfying the ACL2 \u000A built-in predicate <v>termp</v>.  When these metafunctions are executed by the \u000A simplifier, they will be applied to (the quotations of) terms.  But during the \u000A proof of the metatheorem itself, <v>x</v> may not be the quotation of a term. \u000A If the <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> hypothesis is omitted, <v>x</v> may be any object. \u000A Even with the <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> hypothesis, <v>x</v> may merely ``look like a \u000A term'' but use non-function symbols or function symbols of incorrect arity. \u000A In any case, the metatheorem is stronger than necessary to allow us to apply \u000A the metafunctions to terms, as we do in the discussion below.  We return later \u000A to the question of proving the metatheorem.</p> \u000A \u000A <p>Suppose the general form of the metatheorem above is proved with the <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> and <tt><see topic=\"ACL2____ALISTP\">alistp</see></tt> hypotheses.  Then when the simplifier \u000A encounters a term, <v>(h t1 ... tn)</v>, that begins with a function symbol, \u000A <v>h</v>, listed in <v>:trigger-fns</v>, it applies the metafunction, <v>fn</v>, to \u000A the quotation of the term, i.e., it evaluates <v>(fn '(h t1 ... tn))</v> to \u000A obtain some result, which can be written as <v>'val</v>.  If <v>'val</v> is \u000A different from <v>'(h t1 ... tn)</v> and <v>val</v> is a term, then <v>(h t1\u000A ... tn)</v> is replaced by <v>val</v>, which is then passed along for further \u000A rewriting.  Because the metatheorem establishes the correctness of <v>fn</v> for \u000A all terms (even non-terms!), there is no restriction on which function symbols \u000A are listed in the <v>:trigger-fns</v>.  Generally, of course, they should be the \u000A symbols that head up the terms simplified by the metafunction <v>fn</v>.</p> \u000A \u000A <p>Note that the result of applying a metafunction (or a hypothesis \u000A metafunction) must be a term.  If not, then an error occurs.  See <see topic=\"ACL2____TERM-TABLE\">term-table</see> for how one obtains some assistance towards guaranteeing that \u000A <v>val</v> is indeed a term.  ACL2 actually enforces a stronger requirement, \u000A disallowing calls of certain ``forbidden'' function symbols; see <see topic=\"ACL2____SET-SKIP-META-TERMP-CHECKS\">set-skip-meta-termp-checks</see>.</p> \u000A \u000A <p>The ``evaluator'' function, <v>ev</v>, is a function that can evaluate a \u000A certain class of expressions, namely, all of those composed of variables, \u000A constants, and applications of a fixed, finite set of function symbols, \u000A <v>g1</v>, ..., <v>gk</v>.  Generally speaking, the set of function symbols \u000A handled by <v>ev</v> is chosen to be exactly the function symbols recognized and \u000A manipulated by the metafunctions being introduced.  For example, if <v>fn</v> \u000A manipulates expressions in which <v>'</v><tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt> and <v>'</v><tt><see topic=\"ACL2____BINARY-APPEND\">binary-append</see></tt> occur as function symbols, then <v>ev</v> is generally specified \u000A to handle <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt> and <tt><see topic=\"ACL2____BINARY-APPEND\">binary-append</see></tt>.  The actual requirements on \u000A <v>ev</v> become clear when the metatheorem is proved.  The standard way to \u000A introduce an evaluator is to use the ACL2 macro <tt><see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see></tt>, though \u000A this is not strictly necessary.  See <see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see> if you want \u000A details.</p> \u000A \u000A <p>[Aside for the logic-minded.] Why are we justified in using metafunctions \u000A this way?  Suppose <v>(fn 'term1)</v> is <v>'term2</v>.  What justifies replacing \u000A <v>term1</v> by <v>term2</v>?  The first step is to assert that <v>term1</v> is \u000A <v>(ev 'term1 a)</v>, where <v>a</v> is an alist that maps <v>'var</v> to <v>var</v>, \u000A for each variable <v>var</v> in <v>term1</v>.  This step is incorrect, because \u000A <v>'term1</v> may contain function symbols other than the ones, <v>g1</v>, ..., \u000A <v>gk</v>, that <v>ev</v> knows how to handle.  But we can grow <v>ev</v> to a \u000A ``larger'' evaluator, <v>ev*</v>, an evaluator for all of the symbols that occur \u000A in <v>term1</v> or <v>term2</v>.  We can prove that <v>ev*</v> satisfies the <see topic=\"ACL2____CONSTRAINT\">constraint</see>s on <v>ev</v>, provided no <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> events are adding \u000A constraints to <v>ev</v> (or callers of <v>ev</v>, and recursively); ACL2 checks \u000A this additional property.  Hence, the metatheorem holds for <v>ev*</v> in place \u000A of <v>ev</v>, by functional instantiation.  We can then carry out the proof of \u000A the <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> of <v>term1</v> and <v>term2</v> as follows: Fix <v>a</v> to \u000A be an alist that maps the quotations of the variables of <v>term1</v> and \u000A <v>term2</v> to themselves.  Then,</p> \u000A \u000A <code>term1 = (ev* 'term1 a)      ; (1) by construction of ev* and a\u000A      = (ev* (fn 'term1) a) ; (2) by the metatheorem for ev*\u000A      = (ev* 'term2 a)      ; (3) by evaluation of fn\u000A      = term2               ; (4) by construction of ev* and a</code> \u000A \u000A <p>Note that in line (2) above, where we appeal to the (functional \u000A instantiation of the) metatheorem, we can relieve its (optional) <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> and <tt><see topic=\"ACL2____ALISTP\">alistp</see></tt> hypotheses by appealing to the facts that \u000A <v>term1</v> is a term and <v>a</v> is an alist by construction.  [End of Aside \u000A for the logic-minded.]</p> \u000A \u000A <p>There are subtleties related to the notion of ``growing'' <v>ev</v> to a \u000A ``larger'' evaluator, as mentioned in the paragraph just above.  For \u000A corresponding restrictions on <v>:meta</v> rules, see <see topic=\"ACL2____EVALUATOR-RESTRICTIONS\">evaluator-restrictions</see>.</p> \u000A \u000A <p>Finally, we turn to the second case, in which there is a hypothesis \u000A metafunction.  In that case, consider as before what happens when the \u000A simplifier encounters a term, <v>(h t1 ... tn)</v>, where <v>h</v> is listed in \u000A <v>:trigger-fns</v>.  This time, after it applies <v>fn</v> to <v>'(h t1 ... tn)</v> \u000A to obtain the quotation of some new term, <v>'val</v>, it then applies the \u000A hypothesis metafunction, <v>hyp-fn</v>.  That is, it evaluates <v>(hyp-fn '(h t1\u000A ... tn))</v> to obtain some result, which can be written as <v>'hyp-val</v>.  If \u000A <v>hyp-val</v> is not in fact a term, the metafunction is not used.  Provided \u000A <v>hyp-val</v> is a term, the simplifier attempts to establish (by conventional \u000A backchaining) that this term is non-<v>nil</v> in the current context.  Note \u000A that this backchaining is done just as it is done for hypotheses of <see topic=\"ACL2____REWRITE\">rewrite</see> (and <see topic=\"ACL2____LINEAR\">linear</see>) rules, namely, by rewriting with special \u000A attention to calls of certain functions including <tt><see topic=\"ACL2____FORCE\">force</see></tt>, <tt><see topic=\"ACL2____CASE-SPLIT\">case-split</see></tt>, <tt><see topic=\"ACL2____SYNTAXP\">syntaxp</see></tt>, and <tt><see topic=\"ACL2____BIND-FREE\">bind-free</see></tt>.  If this attempt to \u000A establish this term fails, then the meta rule is not applied.  Otherwise, \u000A <v>(h t1...tn)</v> is replaced by <v>val</v> as in the previous case (where there \u000A was no hypothesis metafunction).</p> \u000A \u000A <p>Why is it justified to make this extension to the case of hypothesis \u000A metafunctions?  First, note that the rule</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)\u000A              (<see topic=\"ACL2____ALISTP\">alistp</see> a)\u000A              (ev (hyp-fn x) a))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (ev x a)\u000A                (ev (fn x) a)))</code> \u000A \u000A <p>is logically equivalent to the rule</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)\u000A              (<see topic=\"ACL2____ALISTP\">alistp</see> a))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (ev x a)\u000A                (ev (new-fn x) a)))</code> \u000A \u000A <p>where <v>(new-fn x)</v> is defined to be <v>(<see topic=\"COMMON-LISP____LIST\">list</see> 'if (hyp-fn x) (fn x) x)</v>. \u000A (If we're careful, we realize that this argument depends on making an \u000A extension of <v>ev</v> to an evaluator <v>ev*</v> that handles <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> and the \u000A functions manipulated by <v>hyp-fn</v>.)  If we write <v>'term</v> for the \u000A quotation of the present term, and if <v>(hyp-fn 'term)</v> and <v>(fn 'term)</v> \u000A are both terms, say <v>hyp1</v> and <v>term1</v>, then by the previous argument we \u000A know it is sound to rewrite term to <v>(<see topic=\"COMMON-LISP____IF\">if</see> hyp1 term1 term)</v>.  But since we \u000A have established in the current context that <v>hyp1</v> is non-<v>nil</v>, we may \u000A simplify <v>(<see topic=\"COMMON-LISP____IF\">if</see> hyp1 term1 term)</v> to <v>term1</v>, as desired.</p> \u000A \u000A <p>We now discuss the role of the <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> hypothesis. \u000A <v>(<see topic=\"ACL2____PSEUDO-TERMP\">Pseudo-termp</see> x)</v> checks that <v>x</v> has the shape of a term.  Roughly \u000A speaking, it ensures that <v>x</v> is a symbol, a quoted constant, or a true \u000A list consisting of a <v>lambda</v> expression or symbol followed by some \u000A pseudo-terms.  Among the properties of terms not checked by <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> are that variable symbols never begin with ampersand, \u000A <v>lambda</v> expressions are closed, and function symbols are applied to the \u000A correct number of arguments.  See <see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see>.</p> \u000A \u000A <p>There are two possible roles for <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> in the development of \u000A a metatheorem: it may be used as the <see topic=\"ACL2____GUARD\">guard</see> of the metafunction and/or \u000A hypothesis metafunction and it may be used as a hypothesis of the metatheorem. \u000A Generally speaking, the <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> hypothesis is included in a \u000A metatheorem only if it makes it easier to prove.  The choice is yours.  (An \u000A extreme example of this is when the metatheorem is invalid without the \u000A hypothesis!)  We therefore address ourselves the question: should a \u000A metafunction have a <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> <see topic=\"ACL2____GUARD\">guard</see>?  A <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> \u000A <see topic=\"ACL2____GUARD\">guard</see> for a metafunction, in connection with other considerations \u000A described below, improves the efficiency with which the metafunction is used \u000A by the simplifier.</p> \u000A \u000A <p>To make a metafunction maximally efficient you should (a) provide it with a \u000A <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> <see topic=\"ACL2____GUARD\">guard</see> and exploit the <see topic=\"ACL2____GUARD\">guard</see> when possible \u000A in coding the body of the function (see <see topic=\"ACL2____GUARDS-AND-EVALUATION\">guards-and-evaluation</see>, \u000A especially the section on efficiency issues), (b) verify the <see topic=\"ACL2____GUARD\">guard</see>s of \u000A the metafunction (see <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see>), and (c) compile the metafunction \u000A (see <see topic=\"ACL2____COMP\">comp</see>).  When these three steps have been taken the simplifier can \u000A evaluate <v>(fn 'term1)</v> by running the compiled ``primary code'' (see <see topic=\"ACL2____GUARDS-AND-EVALUATION\">guards-and-evaluation</see>) for <v>fn</v> directly in Common Lisp.  (Note however \u000A that explicit compilation may be suppressed; see <see topic=\"ACL2____COMPILATION\">compilation</see>.)</p> \u000A \u000A <p>Before discussing efficiency issues further, let us review for a moment the \u000A general case in which we wish to evaluate <v>(fn 'obj)</v> for some <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> function.  We must first ask whether the <see topic=\"ACL2____GUARD\">guard</see>s of <v>fn</v> have \u000A been verified.  If not, we must evaluate <v>fn</v> by executing its logic \u000A definition.  This effectively checks the <see topic=\"ACL2____GUARD\">guard</see>s of every subroutine and \u000A so can be slow.  If, on the other hand, the <see topic=\"ACL2____GUARD\">guard</see>s of <v>fn</v> have been \u000A verified, then we can run the primary code for <v>fn</v>, provided <v>'obj</v> \u000A satisfies the <see topic=\"ACL2____GUARD\">guard</see> of <v>fn</v>.  So we must next evaluate the <see topic=\"ACL2____GUARD\">guard</see> of <v>fn</v> on <v>'obj</v>.  If the <see topic=\"ACL2____GUARD\">guard</see> is met, then we run the \u000A primary code for <v>fn</v>, otherwise we run the logic code.</p> \u000A \u000A <p>Now in the case of a metafunction for which the three steps above have been \u000A followed, we know the <see topic=\"ACL2____GUARD\">guard</see> is (implied by) <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> and \u000A that it has been verified.  Furthermore, we know without checking that the \u000A <see topic=\"ACL2____GUARD\">guard</see> is met (because <v>term1</v> is a term and hence <v>'term1</v> is a \u000A <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt>).  Hence, we can use the compiled primary code \u000A directly.</p> \u000A \u000A <p>We strongly recommend that you compile your metafunctions, as well as all \u000A their subroutines (unless explicit compilation is suppressed; see <see topic=\"ACL2____COMPILATION\">compilation</see>).  Guard verification is also recommended.</p> \u000A \u000A <p>Finally, we present a very simple example of the use of <v>:meta</v> rules, \u000A based on one provided by Robert Krug.  This example illustrates a trick for \u000A avoiding undesired rewriting after applying a metafunction or any other form \u000A of rewriting.  To elaborate: in general, the term <v>t2</v> obtained by applying \u000A a metafunction to a term <v>t1</v> is then handed immediately to the rewriter, \u000A which descends recursively through the arguments of function calls to rewrite \u000A <v>t2</v> completely.  But if <v>t2</v> shares a lot of structure with <v>t1</v>, \u000A then it might not be worthwhile to rewrite <v>t2</v> immediately.  (A rewrite of \u000A <v>t2</v> will occur anyhow the next time a goal is generated.)  The trick \u000A involves avoiding this rewrite by wrapping <v>t2</v> inside a call of <tt><see topic=\"ACL2____HIDE\">hide</see></tt>, which in turn is inside a call of a user-defined ``unhiding'' function, \u000A <v>unhide</v>.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> unhide (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t))\u000A  x)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> unhide-hide\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (unhide (<see topic=\"ACL2____HIDE\">hide</see> x))\u000A         x)\u000A  :hints ((&quot;Goal&quot; :expand ((<see topic=\"ACL2____HIDE\">hide</see> x)))))\u000A\u000A(<see topic=\"ACL2____IN-THEORY\">in-theory</see> (<see topic=\"ACL2____DISABLE\">disable</see> unhide))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> my-plus (x y)\u000A  (<see topic=\"COMMON-LISP_____B2\">+</see> x y))\u000A\u000A(<see topic=\"ACL2____IN-THEORY\">in-theory</see> (<see topic=\"ACL2____DISABLE\">disable</see> my-plus))\u000A\u000A(<see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see> evl evl-list\u000A  ((my-plus x y)\u000A   (<see topic=\"ACL2____BINARY-_B2\">binary-+</see> x y)\u000A   (unhide x)\u000A   (<see topic=\"ACL2____HIDE\">hide</see> x)))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> meta-fn (<see topic=\"ACL2____TERM\">term</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> term)))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> term)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____LENGTH\">length</see> term) 3)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> term) 'my-plus))\u000A      `(UNHIDE (<see topic=\"ACL2____HIDE\">HIDE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> ,(<see topic=\"COMMON-LISP____CADR\">cadr</see> term) ,(<see topic=\"COMMON-LISP____CADDR\">caddr</see> term))))\u000A    term))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> my-meta-lemma\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (evl term a)\u000A         (evl (meta-fn term) a))\u000A  :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> my-plus)))\u000A  :rule-classes ((:meta :trigger-fns (my-plus))))</code> \u000A \u000A <p>Notice that in the following (silly) conjecture, ACL2 initially does only \u000A does the simplification directed by the metafunction; a second goal is \u000A generated before the commuativity of addition can be applied.  If the above \u000A calls of <v>UNHIDE</v> and <v>HIDE</v> had been stripped off, then <v>Goal'</v> \u000A would have been the term printed in <v>Goal''</v> below.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____THM\">thm</see>\u000A        (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (my-plus b a)\u000A               ccc))\u000A\u000AThis simplifies, using the :meta rule MY-META-LEMMA and the :rewrite\u000Arule UNHIDE-HIDE, to\u000A\u000AGoal'\u000A(<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP_____B2\">+</see> B A) CCC).\u000A\u000AThis simplifies, using the :rewrite rule COMMUTATIVITY-OF-+, to\u000A\u000AGoal''\u000A(<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP_____B2\">+</see> A B) CCC).</code> \u000A \u000A <p>The discussion above probably suffices to make good use of this <v>(UNHIDE\u000A (<see topic=\"ACL2____HIDE\">HIDE</see> ...))</v> trick.  However, we invite the reader who wishes to understand \u000A the trick in depth to evaluate the following form before submitting the <tt><see topic=\"ACL2____THM\">thm</see></tt> form above.</p> \u000A \u000A <code>(<see topic=\"ACL2____TRACE_42\">trace$</see> (<see topic=\"ACL2____REWRITE\">rewrite</see> :entry (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"ACL2____TAKE\">take</see> 2 arglist))\u000A                 :exit (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CAR\">car</see> values)))\u000A        (rewrite-with-lemma :entry (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"ACL2____TAKE\">take</see> 2 arglist))\u000A                            :exit (<see topic=\"ACL2____TAKE\">take</see> 2 values)))</code> \u000A \u000A <p>The following annotated subset of the trace output (which may appear a bit \u000A different depending on the underlying Common Lisp implementation) explains how \u000A the trick works.</p> \u000A \u000A <code>    2&gt; (<see topic=\"ACL2____REWRITE\">REWRITE</see> ((MY-PLUS B A) NIL))&gt;\u000A      3&gt; (REWRITE-WITH-LEMMA\u000A              ((MY-PLUS B A)\u000A               (REWRITE-RULE (:META MY-META-LEMMA)\u000A                             1822\u000A                             NIL EQUAL META-FN NIL META NIL NIL)))&gt;\u000A\u000AWe apply the meta rule, then recursively rewrite the result, which is the\u000A(UNHIDE (<see topic=\"ACL2____HIDE\">HIDE</see> ...)) term shown just below.\u000A\u000A        4&gt; (<see topic=\"ACL2____REWRITE\">REWRITE</see> ((UNHIDE (<see topic=\"ACL2____HIDE\">HIDE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A)))\u000A                     ((A . A) (B . B))))&gt;\u000A          5&gt; (<see topic=\"ACL2____REWRITE\">REWRITE</see> ((<see topic=\"ACL2____HIDE\">HIDE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))\u000A                       ((A . A) (B . B))))&gt;\u000A\u000AThe HIDE protects its argument from being touched by the rewriter.\u000A\u000A          &lt;5 (<see topic=\"ACL2____REWRITE\">REWRITE</see> (<see topic=\"ACL2____HIDE\">HIDE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A)))&gt;\u000A          5&gt; (REWRITE-WITH-LEMMA\u000A                  ((UNHIDE (<see topic=\"ACL2____HIDE\">HIDE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A)))\u000A                   (REWRITE-RULE (:REWRITE UNHIDE-HIDE)\u000A                                 1806 NIL EQUAL (UNHIDE (<see topic=\"ACL2____HIDE\">HIDE</see> X))\u000A                                 X ABBREVIATION NIL NIL)))&gt;\u000A\u000ANow we apply UNHIDE-HIDE, then recursively rewrite its right-hand\u000Aside in an environment where X is bound to (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A).\u000A\u000A            6&gt; (<see topic=\"ACL2____REWRITE\">REWRITE</see> (X ((X BINARY-+ B A))))&gt;\u000A\u000ANotice that at this point X is cached, so REWRITE just returns\u000A(<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A).\u000A\u000A            &lt;6 (<see topic=\"ACL2____REWRITE\">REWRITE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))&gt;\u000A          &lt;5 (REWRITE-WITH-LEMMA T (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))&gt;\u000A        &lt;4 (<see topic=\"ACL2____REWRITE\">REWRITE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))&gt;\u000A      &lt;3 (REWRITE-WITH-LEMMA T (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))&gt;\u000A    &lt;2 (<see topic=\"ACL2____REWRITE\">REWRITE</see> (<see topic=\"ACL2____BINARY-_B2\">BINARY-+</see> B A))&gt;</code>"],

 "ACL2____XARGS":[["Defun","Declare"],"ACL2 Sources","ACL2","<p>Common Lisp's <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> function does not easily allow one to \u000A pass extra arguments such as ``<see topic=\"ACL2____HINTS\">hints</see>''.  ACL2 therefore supports a \u000A peculiar new declaration (see <see topic=\"COMMON-LISP____DECLARE\">declare</see>) designed explicitly for passing \u000A additional arguments to <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> via a keyword-like syntax.  This \u000A declaration can also be used with <tt><see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see></tt>, but only for <v>xargs</v> \u000A keyword <v>:GUARD</v>; so we restrict attention below to use of <v>xargs</v> in \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> <see topic=\"ACL2____EVENTS\">events</see>.</p> \u000A \u000A <p>The following declaration is nonsensical but does illustrate all of the \u000A <v>xargs</v> keywords for <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> (which are the members of the list \u000A <v>*xargs-keywords*</v>).</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____SYMBOLP\">symbolp</see> x)\u000A                :guard-hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____THEORY\">theory</see> batch1)))\u000A                :guard-debug t\u000A                :measure-debug t\u000A                :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____THEORY\">theory</see> batch1)))\u000A                :measure (<see topic=\"COMMON-LISP____-\">-</see> i j)\u000A                :ruler-extenders :basic\u000A                :mode :logic\u000A                :non-executable t\u000A                :normalize nil\u000A                :otf-flg t\u000A                :stobjs ($s)\u000A                :verify-guards t\u000A                :split-types t\u000A                :well-founded-relation my-wfr))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____XARGS\">xargs</see> :key1 val1 ... :keyn valn)</code> \u000A \u000A <p>where the keywords and their respective values are as shown below.  Note \u000A that once ``inside'' the xargs form, the ``extra arguments'' to <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> \u000A are passed exactly as though they were keyword arguments.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____GUARD\">guard</see></tt><br></br> \u000A <v>:GUARD</v><br></br> \u000A <v>:</v><v>GUARD</v><br></br> \u000A \u000A <v>Value</v> is a term involving only the formals of the function being defined. \u000A The actual <see topic=\"ACL2____GUARD\">guard</see> used for the definition is the conjunction of all the \u000A <see topic=\"ACL2____GUARD\">guard</see>s and types (see <see topic=\"COMMON-LISP____DECLARE\">declare</see>) <see topic=\"COMMON-LISP____DECLARE\">declare</see>d.</p> \u000A \u000A <p><v>:GUARD-HINTS</v><br></br> \u000A \u000A <v>Value</v>: hints (see <see topic=\"ACL2____HINTS\">hints</see>), to be used during the <see topic=\"ACL2____GUARD\">guard</see> \u000A verification proofs as opposed to the termination proofs of the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.</p> \u000A \u000A <p><v>:GUARD-DEBUG</v><br></br> \u000A \u000A <v>Value</v>: <v>nil</v> by default, else directs ACL2 to decorate each guard \u000A proof obligation with hypotheses indicating its sources.  See <see topic=\"ACL2____GUARD-DEBUG\">guard-debug</see>.</p> \u000A \u000A <p><v>:MEASURE-DEBUG</v><br></br> \u000A \u000A <v>Value</v>: <v>nil</v> by default, else directs ACL2 to decorate each measure \u000A proof obligation with hypotheses indicating its sources.  See <see topic=\"ACL2____MEASURE-DEBUG\">measure-debug</see>.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____HINTS\">hints</see></tt><br></br> \u000A \u000A Value: hints (see <see topic=\"ACL2____HINTS\">hints</see>), to be used during the termination proofs as \u000A opposed to the <see topic=\"ACL2____GUARD\">guard</see> verification proofs of the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.</p> \u000A \u000A <p><v>:MEASURE</v><br></br> \u000A \u000A <v>Value</v> is a term involving only the formals of the function being defined. \u000A This term is indicates what is getting smaller in the recursion.  The \u000A well-founded relation with which successive measures are compared is <tt><see topic=\"ACL2____O_C3\">o&lt;</see></tt>.  Also allowed is a special case, <v>(:? v1 ... vk)</v>, where <v>(v1\u000A ... vk)</v> enumerates a subset of the formal parameters such that some valid \u000A measure involves only those formal parameters.  However, this special case is \u000A only allowed for definitions that are redundant \u000A (see <see topic=\"ACL2____REDUNDANT-EVENTS\">redundant-events</see>) or are executed when skipping proofs \u000A (see <see topic=\"ACL2____SKIP-PROOFS\">skip-proofs</see>).  Another special case is <v>:MEASURE nil</v>, which is \u000A treated the same as if <v>:MEASURE</v> is omitted.</p> \u000A \u000A <p><v>:RULER-EXTENDERS</v><br></br> \u000A \u000A For recursive definitions (possibly mutually recursive), <v>value</v> controls \u000A termination analysis and the resulting stored induction scheme.  See <see topic=\"ACL2____RULER-EXTENDERS\">ruler-extenders</see> for a discussion of legal values and their effects.</p> \u000A \u000A <p><v>:MODE</v><br></br> \u000A \u000A <v>Value</v> is <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> or <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>, indicating the \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> mode of the function introduced.  See <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>.  If \u000A unspecified, the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> mode defaults to the default <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> mode \u000A of the current <see topic=\"ACL2____WORLD\">world</see>.  To convert a function from <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> \u000A mode to <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode, see <see topic=\"ACL2____VERIFY-TERMINATION\">verify-termination</see>.</p> \u000A \u000A <p><v>:NON-EXECUTABLE</v><br></br> \u000A \u000A <v>Value</v> is normally <v>t</v> or <v>nil</v> (the default).  Rather than stating \u000A <v>:non-executable t</v> directly, which requires <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode and \u000A that the definitional body has a certain form, we suggest using the macro \u000A <v>defun-nx</v> or <v>defund-nx</v>; see <see topic=\"ACL2____DEFUN-NX\">defun-nx</see>.  A third value of \u000A <v>:non-executable</v> for advanced users is <v>:program</v>, which is generated \u000A by expansion of <v>defproxy</v> forms; see <see topic=\"ACL2____DEFPROXY\">defproxy</see>.  For another way to \u000A deal with non-executability, see <see topic=\"ACL2____NON-EXEC\">non-exec</see>.</p> \u000A \u000A <p><v>:NORMALIZE</v><br></br> \u000A \u000A Value is a flag telling <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> whether to propagate <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> tests \u000A upward.  Since the default is to do so, the value supplied is only of interest \u000A when it is <v>nil</v>. \u000A (See <see topic=\"COMMON-LISP____DEFUN\">defun</see>).</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____OTF-FLG\">otf-flg</see></tt><br></br> \u000A \u000A Value is a flag indicating ``onward through the fog'' \u000A (see <see topic=\"ACL2____OTF-FLG\">otf-flg</see>).</p> \u000A \u000A <p><v>:STOBJS</v><br></br> \u000A \u000A <v>Value</v> is either a single <tt><see topic=\"ACL2____STOBJ\">stobj</see></tt> name or a true list of stobj names \u000A (see <see topic=\"ACL2____STOBJ\">stobj</see> and see <see topic=\"ACL2____DEFSTOBJ\">defstobj</see>, and perhaps see <see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see>).  Every stobj name among the formals of the function must be \u000A listed, if the corresponding actual is to be treated as a stobj.  That is, if \u000A a function uses a stobj name as a formal parameter but the name is not \u000A declared among the <v>:stobjs</v> then the corresponding argument is treated as \u000A ordinary.  The only exception to this rule is <tt><see topic=\"ACL2____STATE\">state</see></tt>: whether you \u000A include it or not, <v>state</v> is always treated as a single-threaded object. \u000A This declaration has two effects.  One is to enforce the syntactic \u000A restrictions on single-threaded objects.  The other is to strengthen the \u000A <tt><see topic=\"ACL2____GUARD\">guard</see></tt> of the function being defined so that it includes conjuncts \u000A specifying that each declared single-threaded object argument satisfies the \u000A recognizer for the corresponding single-threaded object.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see></tt><br></br> \u000A \u000A <v>Value</v> is <v>t</v> or <v>nil</v>, indicating whether or not <see topic=\"ACL2____GUARD\">guard</see>s are \u000A to be verified upon completion of the termination proof.  This flag should \u000A only be <v>t</v> if the <v>:mode</v> is unspecified but the default <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> \u000A mode is <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>, or else the <v>:mode</v> is <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.</p> \u000A \u000A <p><v>:</v><v>SPLIT-TYPES</v><br></br> \u000A \u000A <v>Value</v> is <v>t</v> or <v>nil</v>, indicating whether or not <see topic=\"COMMON-LISP____TYPE\">type</see>s are \u000A to be proved from the <see topic=\"ACL2____GUARD\">guard</see>s.  The default is <v>nil</v>, indicating that \u000A type declarations (see <see topic=\"COMMON-LISP____DECLARE\">declare</see>) contribute to the <see topic=\"ACL2____GUARD\">guard</see>s.  If \u000A the value is <v>t</v>, then instead, the expressions corresponding to the type \u000A declarations (see <see topic=\"ACL2____TYPE-SPEC\">type-spec</see>) are conjoined into a ``split-type \u000A expression,'' and guard verification insists that this term is implied by the \u000A specified <v>:guard</v>.  Suppose for example that a definition has the \u000A following <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> form.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (p x y) :split-types t)\u000A         (<see topic=\"COMMON-LISP____TYPE\">type</see> integer x)\u000A         (<see topic=\"COMMON-LISP____TYPE\">type</see> (satisfies good-bar-p) y))</code> \u000A \u000A <p>Then for guard verification, <v>(p x y)</v> is assumed, and in addition to \u000A the usual proof obligations derived from the body of the definition, guard \u000A verification requires a proof that <v>(p x y)</v> implies both <v>(<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x)</v> \u000A and <v>(good-bar-p y)</v>.  See community book \u000A <v>demos/split-types-examples.lisp</v> for small examples.</p> \u000A \u000A <p><v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt><br></br> \u000A \u000A <v>Value</v> is a function symbol that is known to be a well-founded relation in \u000A the sense that a rule of class <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt> has been \u000A proved about it.  See <see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see>.</p>"],

 "ACL2____DEFPKG":[["Events","Packages","Programming"],"ACL2 Sources","ACL2","<code>Example:\u000A(<see topic=\"ACL2____DEFPKG\">defpkg</see> &quot;MY-PKG&quot;\u000A        (<see topic=\"ACL2____UNION-EQ\">union-eq</see> *acl2-exports*\u000A                  *common-lisp-symbols-from-main-lisp-package*))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____DEFPKG\">defpkg</see> &quot;name&quot; term doc-string)</code> \u000A \u000A <p>where <v>&quot;name&quot;</v> is a non-empty string consisting of standard characters \u000A (see <see topic=\"COMMON-LISP____STANDARD-CHAR-P\">standard-char-p</see>), none of which is lower case, that names the \u000A package to be created; <v>term</v> is a variable-free expression that evaluates \u000A to a list of symbols, where no two distinct symbols in the list may have the \u000A same <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt>, to be imported into the newly created package; and \u000A <v>doc-string</v>, if non-<v>nil</v>, is an optional string that can provide \u000A documentation but is essentially ignored by ACL2.  The name of the new package \u000A must be ``new'': the host lisp must not contain any package of that name. \u000A There are two exceptions to this newness rule, discussed at the end of this \u000A documentation.</p> \u000A \u000A <p>(There is actually an additional argument, book-path, that is used for \u000A error reporting but has no logical content.  Users should generally ignore \u000A this argument, as well as the rest of this sentence: a book-path will be \u000A specified for <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> events added by ACL2 to the <see topic=\"ACL2____PORTCULLIS\">portcullis</see> of \u000A a book's <see topic=\"ACL2____CERTIFICATE\">certificate</see>; see <see topic=\"ACL2____HIDDEN-DEATH-PACKAGE\">hidden-death-package</see>.)</p> \u000A \u000A <p><v>Defpkg</v> forms can be entered at the top-level of the ACL2 <see topic=\"ACL2____COMMAND\">command</see> loop.  They should not occur in <see topic=\"ACL2____BOOKS\">books</see> (see <see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see>).</p> \u000A \u000A <p>After a successful <v>defpkg</v> it is possible to ``intern'' a string into \u000A the package using <tt><see topic=\"ACL2____INTERN-IN-PACKAGE-OF-SYMBOL\">intern-in-package-of-symbol</see></tt>.  The result is a symbol \u000A that is in the indicated package, provided the imports allow it.  For example, \u000A suppose <v>'my-pkg::abc</v> is a symbol whose <tt><see topic=\"ACL2____SYMBOL-PACKAGE-NAME\">symbol-package-name</see></tt> is \u000A <v>&quot;MY-PKG&quot;</v>.  Suppose further that the imports specified in the \u000A <v>defpkg</v> for <v>&quot;MY-PKG&quot;</v> do not include a symbol whose <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> is <v>&quot;XYZ&quot;</v>.  Then</p> \u000A \u000A <code>(<see topic=\"ACL2____INTERN-IN-PACKAGE-OF-SYMBOL\">intern-in-package-of-symbol</see> &quot;XYZ&quot; 'my-pkg::abc)</code> \u000A \u000A <p>returns a symbol whose <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> is <v>&quot;XYZ&quot;</v> and whose <tt><see topic=\"ACL2____SYMBOL-PACKAGE-NAME\">symbol-package-name</see></tt> is <v>&quot;MY-PKG&quot;</v>.  On the other hand, if the imports to \u000A the <v>defpkg</v> does include a symbol with the name <v>&quot;XYZ&quot;</v>, say in the \u000A package <v>&quot;LISP&quot;</v>, then</p> \u000A \u000A <code>(<see topic=\"ACL2____INTERN-IN-PACKAGE-OF-SYMBOL\">intern-in-package-of-symbol</see> &quot;XYZ&quot; 'my-pkg::abc)</code> \u000A \u000A <p>returns that symbol (which is uniquely determined by the restriction on the \u000A imports list above).  See <see topic=\"ACL2____INTERN-IN-PACKAGE-OF-SYMBOL\">intern-in-package-of-symbol</see>.</p> \u000A \u000A <p>Upon admission of a <v>defpkg</v> event, the function <v>pkg-imports</v> is \u000A extended to compute a list of all symbols imported into the given package, \u000A without duplicates.</p> \u000A \u000A <p><v>Defpkg</v> is the only means by which an ACL2 user can create a new \u000A package or specify what it imports.  That is, ACL2 does not support the Common \u000A Lisp functions <v>make-package</v> or <v>import</v>.  Currently, ACL2 does not \u000A support exporting at all.</p> \u000A \u000A <p>The Common Lisp function <tt><see topic=\"COMMON-LISP____INTERN\">intern</see></tt> is weakly supported by ACL2; see \u000A <see topic=\"COMMON-LISP____INTERN\">intern</see>.  A more general form of that function is also provided: see \u000A <see topic=\"ACL2____INTERN_42\">intern$</see>.</p> \u000A \u000A <p>We now explain the two exceptions to the newness rule for package names. \u000A The careful experimenter will note that if a package is created with a \u000A <v>defpkg</v> that is subsequently undone, the host lisp system will contain the \u000A created package even after the undo.  Because ACL2 hangs onto <see topic=\"ACL2____WORLD\">world</see>s \u000A after they have been undone, e.g., to implement <v>:</v><tt><see topic=\"ACL2____OOPS\">oops</see></tt> but, more \u000A importantly, to implement error recovery, we cannot actually destroy a package \u000A upon undoing it.  Thus, the first exception to the newness rule is that \u000A <v>name</v> is allowed to be the name of an existing package if that package was \u000A created by an undone <v>defpkg</v> and the newly proposed set of imports is \u000A identical to the old one.  See <see topic=\"ACL2____PACKAGE-REINCARNATION-IMPORT-RESTRICTIONS\">package-reincarnation-import-restrictions</see>.  This exception does not violate \u000A the spirit of the newness rule, since one is disinclined to believe in the \u000A existence of undone packages.  The second exception is that <v>name</v> is \u000A allowed to be the name of an existing package if the package was created by a \u000A <v>defpkg</v> with identical set of imports.  That is, it is permissible to \u000A execute ``redundant'' <v>defpkg</v> <see topic=\"ACL2____COMMAND\">command</see>s.  The redundancy test is \u000A based on the values of the two import forms (comparing them after sorting and \u000A removing duplicates), not on the forms themselves.</p> \u000A \u000A <p>Finally, we explain why we require the package name to contain standard \u000A characters, none of which is lower case.  We have seen at least one \u000A implementation that handled lower-case package names incorrectly.  Since we \u000A see no need for lower-case characters in package names, which can lead to \u000A confusion anyhow (note for example that <v>foo::bar</v> is a symbol whose <tt><see topic=\"ACL2____SYMBOL-PACKAGE-NAME\">symbol-package-name</see></tt> is <v>&quot;FOO&quot;</v>, not <v>&quot;foo&quot;</v>), we simply disallow \u000A them.  Since the notion of ``lower case'' is only well-specified in Common \u000A Lisp for standard characters, we restrict to these.</p> \u000A \u000A <p>NOTE: Also see <see topic=\"ACL2____MANAGING-ACL2-PACKAGES\">managing-ACL2-packages</see> for contributed documentation \u000A on managing ACL2 packages.</p>"],

 "ACL2____TYPE-PRESCRIPTION":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <code>Examples:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> integerp-foo                       ; Assumes that foo has been\u000A  (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (foo x y))                     ; defined; then, states that\u000A  :rule-classes :type-prescription)        ; (foo x y) is of type integer.\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> characterp-nth-type-prescription   ; (<see topic=\"COMMON-LISP____NTH\">Nth</see> n lst) is of type character\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see>                                 ; provided the hypotheses can be\u000A   (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____CHARACTER-LISTP\">character-listp</see> lst)              ; established by type reasoning.\u000A        (<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> 0 n)\u000A        (<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> lst)))\u000A   (<see topic=\"COMMON-LISP____CHARACTERP\">characterp</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n lst)))\u000A  :rule-classes :type-prescription)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> characterp-nth-type-prescription-alt ; equivalent to the above\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see>\u000A   (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____CHARACTER-LISTP\">character-listp</see> lst)\u000A        (<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> 0 n)\u000A        (<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> lst)))\u000A   (<see topic=\"COMMON-LISP____CHARACTERP\">characterp</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n lst)))\u000A  :rule-classes ((:type-prescription :typed-term (<see topic=\"COMMON-LISP____NTH\">nth</see> n lst))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> demodulize-type-for-quote-value  ; (Demodulize a lst 'value ans) is\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see>                               ; either a nonnegative integer or\u000A   (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____ATOM\">atom</see> a)                         ; of the same type as ans, provided\u000A        (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> lst)                 ; the hyps can be established by type\u000A        (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> a lst))            ; reasoning\u000A   (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (demodulize a lst 'value ans))\u000A            (<see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see> (demodulize a lst 'value ans) 0))\u000A     (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (demodulize a lst 'value ans) ans)))\u000A  :rule-classes :type-prescription)</code> \u000A \u000A <p>To specify the term whose type (see <see topic=\"ACL2____TYPE-SET\">type-set</see>) is described by the \u000A rule, provide that term as the value of the <v>:typed-term</v> field of the rule \u000A class object.</p> \u000A \u000A <code>General Form (after preprocessing; see below):\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> hyps\u000A         (<see topic=\"COMMON-LISP____OR\">or</see> type-restriction1-on-pat\u000A             ...\u000A             type-restrictionk-on-pat\u000A             (<see topic=\"COMMON-LISP____EQUAL\">equal</see> pat var1)\u000A             ...\u000A             (<see topic=\"COMMON-LISP____EQUAL\">equal</see> pat varj)))</code> \u000A \u000A <p>where <v>pat</v> is the application of some function symbol to some \u000A arguments, each <v>type-restrictioni-on-pat</v> is a term involving <v>pat</v> and \u000A containing no variables outside of the occurrences of <v>pat</v>, and each \u000A <v>vari</v> is one of the variables of <v>pat</v>.  Generally speaking, the \u000A <v>type-restriction</v> terms ought to be terms that inform us as to the type of \u000A <v>pat</v>.  Ideally, they should be ``primitive recognizing expressions'' about \u000A <v>pat</v>; see <see topic=\"ACL2____COMPOUND-RECOGNIZER\">compound-recognizer</see>.  We describe preprocessing at the \u000A end of this topic.</p> \u000A \u000A <p>If the <v>:typed-term</v> is not provided in the rule class object, it is \u000A computed heuristically by looking for a term in the conclusion whose type is \u000A being restricted.  An error is caused if no such term is found.</p> \u000A \u000A <p>Roughly speaking, the effect of adding such a rule is to inform the ACL2 \u000A typing mechanism that <v>pat</v> has the type described by the conclusion, when \u000A the hypotheses are true.  In particular, the type of <v>pat</v> is within the \u000A union of the types described by the several disjuncts.  The ``type described \u000A by'' <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> pat vari)</v> is the type of <v>vari</v>.</p> \u000A \u000A <p>More operationally, when asked to determine the type of a term that is an \u000A instance of <v>pat</v>, ACL2 will first attempt to establish the hypotheses. \u000A <b>This is done by type reasoning alone, not rewriting!</b> However, if some \u000A hypothesis is a call of <tt><see topic=\"ACL2____FORCE\">force</see></tt>, then forcing may occur, which may \u000A ultimately invoke the rewriter; see <see topic=\"ACL2____FORCE\">force</see> and see <see topic=\"ACL2____CASE-SPLIT\">case-split</see>. \u000A So-called free variables in hypotheses are treated specially; see <see topic=\"ACL2____FREE-VARIABLES\">free-variables</see>.  Provided the hypotheses are established by type reasoning, \u000A ACL2 then unions the types described by the <v>type-restrictioni-on-pat</v> \u000A terms together with the types of those subexpressions of <v>pat</v> identified \u000A by the <v>vari</v>.  The final type computed for a term is the intersection of \u000A the types implied by each applicable rule.  Type prescription rules may be \u000A disabled.</p> \u000A \u000A <p>You can limit the recursive establishment of hypotheses of rules; see <see topic=\"ACL2____SET-BACKCHAIN-LIMIT\">set-backchain-limit</see>.</p> \u000A \u000A <p>Because only type reasoning is used to establish the hypotheses of \u000A <v>:type-prescription</v> rules, some care must be taken with the hypotheses. \u000A Suppose, for example, that the non-recursive function <v>my-statep</v> is \u000A defined as</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> my-statep (x)\u000A  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)\u000A       (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____LEN\">len</see> x) 2)))</code> \u000A \u000A <p>and suppose <v>(my-statep s)</v> occurs as a hypothesis of a \u000A <v>:type-prescription</v> rule that is being considered for use in the proof \u000A attempt for a conjecture with the hypothesis <v>(my-statep s)</v>.  Since the \u000A hypothesis in the conjecture is rewritten, it will become the conjunction of \u000A <v>(<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> s)</v> and <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____LEN\">len</see> s) 2)</v>.  Those two terms will be \u000A assumed to have type <v>t</v> in the context in which the \u000A <v>:type-prescription</v> rule is tried.  But type reasoning will be unable to \u000A deduce that <v>(my-statep s)</v> has type <v>t</v> in this context.  Thus, either \u000A <v>my-statep</v> should be disabled (see <see topic=\"ACL2____DISABLE\">disable</see>) during the proof \u000A attempt or else the occurrence of <v>(my-statep s)</v> in the \u000A <v>:type-prescription</v> rule should be replaced by the conjunction into which \u000A it rewrites.</p> \u000A \u000A <p>While this example makes it clear how non-recursive predicates can cause \u000A problems, non-recursive functions in general can cause problems.  For example, \u000A if <v>(mitigate x)</v> is defined to be <v>(<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> x) (<see topic=\"COMMON-LISP____1-\">1-</see> x) x)</v> then \u000A the hypothesis <v>(pred (mitigate s))</v> in the conjecture will rewrite, \u000A opening <v>mitigate</v> and splitting the conjecture into two subgoals, one in \u000A which <v>(<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> s)</v> and <v>(pred (<see topic=\"COMMON-LISP____1-\">1-</see> x))</v> are assumed and the other in \u000A which <v>(<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> s))</v> and <v>(pred x)</v> are assumed.  But <v>(pred\u000A (mitigate s))</v> will not be typed as <v>t</v> in either of these contexts.  The \u000A moral is: beware of non-recursive functions occuring in the hypotheses of \u000A <v>:type-prescription</v> rules.</p> \u000A \u000A <p>Because of the freedom one has in forming the conclusion of a \u000A type-prescription, we have to use heuristics to recover the pattern, <v>pat</v>, \u000A whose type is being specified.  In some cases our heuristics may not identify \u000A the intended term and the <v>:type-prescription</v> rule will be rejected as \u000A illegal because the conclusion is not of the correct form.  When this happens \u000A you may wish to specify the <v>pat</v> directly.  This may be done by using a \u000A suitable rule class token.  In particular, when the token \u000A <v>:type-prescription</v> is used it means ACL2 is to compute pat with its \u000A heuristics; otherwise the token should be of the form <v>(:type-prescription\u000A :typed-term pat)</v>, where <v>pat</v> is the term whose type is being \u000A specified.</p> \u000A \u000A <p>The defun event may generate a <v>:type-prescription</v> rule.  Suppose \u000A <v>fn</v> is the name of the function concerned.  Then <v>(:type-prescription\u000A fn)</v> is the rune given to the type-prescription, if any, generated for \u000A <v>fn</v> by <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.  (The trivial rule, saying <v>fn</v> has unknown type, \u000A is not stored, but <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> still allocates the rune and the corollary of \u000A this rune is known to be <v>t</v>.)</p> \u000A \u000A <p>We close with a discussion of how, before a term is parsed into a \u000A <v>:type-prescription</v> rule, it is preprocessed.  We describe this \u000A preprocessing in some detail below, but first consider the following \u000A (contrived) example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> append-tp-example\u000A  (<see topic=\"COMMON-LISP____LET\">let</see> ((result (<see topic=\"COMMON-LISP____APPEND\">append</see> x y)))\u000A    (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____NAT-LISTP\">nat-listp</see> x)\u000A             (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____LET\">let</see> ((second-hyp (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> y)))\u000A                        second-hyp)\u000A                      (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> result))))\u000A  :rule-classes :type-prescription)</code> \u000A \u000A <p>This theorem is parsed into a type-prescription rule with the following \u000A hypotheses and conclusion.</p> \u000A \u000A <code>(<see topic=\"ACL2____NAT-LISTP\">nat-listp</see> x) ; first hypothesis\u000A((<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (second-hyp) second-hyp) (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> y)) ; second hypothesis\u000A(<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> (<see topic=\"ACL2____BINARY-APPEND\">binary-append</see> x y)) ; conclusion</code> \u000A \u000A <p>Notice that the top-level <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> was expanded, i.e., <v>(<see topic=\"COMMON-LISP____APPEND\">append</see> x y)</v> \u000A was substituted for <v>result</v> &mdash; more accurately, <v>(<see topic=\"ACL2____BINARY-APPEND\">binary-append</see> x\u000A y)</v> was substituted for <v>result</v>, since <tt><see topic=\"COMMON-LISP____APPEND\">append</see></tt> is a macro that \u000A abbreviates <tt><see topic=\"ACL2____BINARY-APPEND\">binary-append</see></tt>.  Also notice that the two hypotheses were \u000A ``flattened'' in the sense that they were gathered up into a list.  Finally, \u000A notice that the <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> in the second hypothesis was not expanded (it was \u000A merely translated to internal form, using <v>LAMBDA</v>).  If you actually \u000A submit the theorem above, you will get warnings, which you may choose to \u000A ignore; the application of <v>type-prescription</v> rules is somewhat subtle, so \u000A if you use them then you may wish to experiment to see which forms work best \u000A for you.</p> \u000A \u000A <p>Here is the detail promised above, for parsing a term into a \u000A <v>:type-prescription</v> rule.  There are two steps.  (1) ACL2 first translates \u000A the term, expanding all macros (see <see topic=\"ACL2____TRANS\">trans</see>) and also removing <see topic=\"ACL2____GUARD-HOLDERS\">guard-holders</see>.  (2) Then the the translated term is traversed top-down, \u000A expanding away <v>lambda</v>s (<tt><see topic=\"COMMON-LISP____LET\">let</see></tt>, <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>, and <tt><see topic=\"ACL2____MV-LET\">mv-let</see></tt> \u000A expressions) and flattening the <tt><see topic=\"ACL2____IMPLIES\">implies</see></tt> structure, until the \u000A conclusion is exposed; then the conclusion's <v>lambda</v>s are also expanded \u000A away.  The simplest way to understand (2) may be to look at the definition of \u000A ACL2 source function <v>unprettyify-tp</v>, which implements Step (2), say by \u000A evaluating <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt><v> unprettyify-tp</v>.</p>"],

 "ACL2____DEFINITION":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes \u000A and how they are used to build rules from formulas.  An example <v>:</v><tt><see topic=\"ACL2____COROLLARY\">corollary</see></tt> formula from which a <v>:definition</v> rule might be built is:</p> \u000A \u000A <code>Examples:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> open-len-twice\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____LEN\">len</see> x)\u000A                  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____NULL\">null</see> x)\u000A                      0\u000A                    (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____NULL\">null</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A                        1\u000A                      (<see topic=\"COMMON-LISP_____B2\">+</see> 2 (<see topic=\"ACL2____LEN\">len</see> (<see topic=\"COMMON-LISP____CDDR\">cddr</see> x)))))))\u000A  :rule-classes :definition)\u000A\u000A; Same as above, with :controller-alist made explicit:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> open-len-twice\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____LEN\">len</see> x)\u000A                  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____NULL\">null</see> x)\u000A                      0\u000A                    (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____NULL\">null</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A                        1\u000A                      (<see topic=\"COMMON-LISP_____B2\">+</see> 2 (<see topic=\"ACL2____LEN\">len</see> (<see topic=\"COMMON-LISP____CDDR\">cddr</see> x)))))))\u000A  :rule-classes ((:definition :controller-alist ((<see topic=\"ACL2____LEN\">len</see> t)))))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> hyp (equiv (fn a1 ... an) body))</code> \u000A \u000A <p>where <v>equiv</v> is an equivalence relation and <v>fn</v> is a function \u000A symbol other than <tt><see topic=\"COMMON-LISP____IF\">if</see></tt>, <tt><see topic=\"ACL2____HIDE\">hide</see></tt>, <tt><see topic=\"ACL2____FORCE\">force</see></tt> or <tt><see topic=\"ACL2____CASE-SPLIT\">case-split</see></tt>.  Such rules allow ``alternative'' definitions of <v>fn</v> to be \u000A proved as theorems but used as definitions.  These rules are not true \u000A ``definitions'' in the sense that they (a) cannot introduce new function \u000A symbols and (b) do not have to be terminating recursion schemes.  They are \u000A just conditional rewrite rules that are controlled the same way we control \u000A recursive definitions.  We call these ``definition rules'' or ``generalized \u000A definitions''.</p> \u000A \u000A <p>Consider the general form above.  Generalized definitions are stored among \u000A the <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules for the function ``defined,'' <v>fn</v> above, \u000A but the procedure for applying them is a little different.  During rewriting, \u000A instances of <v>(fn a1 ... an)</v> are replaced by corresponding instances of \u000A <v>body</v> provided the <v>hyp</v>s can be established as for a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule and the result of rewriting <v>body</v> satisfies the criteria for \u000A function expansion.  There are two primary criteria, either of which permits \u000A expansion.  The first is that the ``recursive'' calls of <v>fn</v> in the \u000A rewritten body have arguments that already occur in the goal conjecture.  The \u000A second is that the ``controlling'' arguments to <v>fn</v> are simpler in the \u000A rewritten body.</p> \u000A \u000A <p>The notions of ``recursive call'' and ``controllers'' are complicated by \u000A the provisions for mutually recursive definitions.  Consider a ``clique'' of \u000A mutually recursive definitions.  Then a ``recursive call'' is a call to any \u000A function defined in the clique and an argument is a ``controller'' if it is \u000A involved in the measure that decreases in all recursive calls.  These notions \u000A are precisely defined by the definitional principle and do not necessarily \u000A make sense in the context of generalized definitional equations as implemented \u000A here.</p> \u000A \u000A <p>But because the heuristics governing the use of generalized definitions \u000A require these notions, it is generally up to the user to specify which calls \u000A in body are to be considered recursive and what the controlling arguments are. \u000A This information is specified in the <v>:clique</v> and <v>:controller-alist</v> \u000A fields of the <v>:definition</v> rule class.</p> \u000A \u000A <p>The <v>:clique</v> field is the list of function symbols to be considered \u000A recursive calls of <v>fn</v>.  In the case of a non-recursive definition, the \u000A <v>:clique</v> field is empty; in a singly recursive definition, it should \u000A consist of the singleton list containing <v>fn</v>; otherwise it should be a \u000A list of all of the functions in the mutually recursive clique with this \u000A definition of <v>fn</v>.</p> \u000A \u000A <p>If the <v>:clique</v> field is not provided it defaults to <v>nil</v> if \u000A <v>fn</v> does not occur as a function symbol in <v>body</v> and it defaults to \u000A the singleton list containing <v>fn</v> otherwise.  Thus, <v>:clique</v> must be \u000A supplied by the user only when the generalized definition rule is to be \u000A treated as one of several in a mutually recursive clique.</p> \u000A \u000A <p>The <v>:controller-alist</v> is an alist that maps each function symbol in \u000A the <v>:clique</v> to a mask specifying which arguments are considered \u000A controllers.  The mask for a given member of the clique, <v>fn</v>, must be a \u000A list of <v>t</v>'s and <v>nil</v>'s of length equal to the arity of <v>fn</v>.  A \u000A <v>t</v> should be in each argument position that is considered a ``controller'' \u000A of the recursion.  For a function admitted under the principle of definition, \u000A an argument controls the recursion if it is one of the arguments measured in \u000A the termination argument for the function.  But in generalized definition \u000A rules, the user is free to designate any subset of the arguments as \u000A controllers.  Failure to choose wisely may result in the ``infinite \u000A expansion'' of definitional rules but cannot render ACL2 unsound since the \u000A rule being misused is a theorem.</p> \u000A \u000A <p>If the <v>:controller-alist</v> is omitted it can sometimes be defaulted \u000A automatically by the system.  If the <v>:clique</v> is <v>nil</v>, the \u000A <v>:controller-alist</v> defaults to <v>nil</v>.  If the <v>:clique</v> is a \u000A singleton containing <v>fn</v>, the <v>:controller-alist</v> defaults to the \u000A controller alist computed by <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fn args body)</v>.  (The user can obtain \u000A some control over this analysis by setting the default ruler-extenders; see \u000A <see topic=\"ACL2____RULER-EXTENDERS\">ruler-extenders</see>.)  If the <v>:clique</v> contains more than one function, \u000A the user must supply the <v>:controller-alist</v> specifying the controllers for \u000A each function in the clique.  This is necessary since the system cannot \u000A determine and thus cannot analyze the other definitional equations to be \u000A included in the clique.</p> \u000A \u000A <p>For example, suppose <v>fn1</v> and <v>fn2</v> have been defined one way and it \u000A is desired to make ``alternative'' mutually recursive definitions available to \u000A the rewriter.  Then one would prove two theorems and store each as a \u000A <v>:definition</v> rule.  These two theorems would exhibit equations \u000A ``defining'' <v>fn1</v> and <v>fn2</v> in terms of each other.  No provision is \u000A here made for exhibiting these two equations as a system of equations.  One is \u000A proved and then the other.  It just so happens that the user intends them to \u000A be treated as mutually recursive definitions.  To achieve this end, both \u000A <v>:definition</v> rules should specify the <v>:clique</v> <v>(fn1 fn2)</v> and \u000A should specify a suitable <v>:controller-alist</v>.  If, for example, the new \u000A definition of <v>fn1</v> is controlled by its first argument and the new \u000A definition of <v>fn2</v> is controlled by its second and third (and they each \u000A take three arguments) then a suitable <v>:controller-alist</v> would be <v>((fn1\u000A t nil nil) (fn2 nil t t))</v>.  The order of the pairs in the alist is \u000A unimportant, but there must be a pair for each function in the clique.</p> \u000A \u000A <p>Inappropriate heuristic advice via <v>:clique</v> and <v>:controller-alist</v> \u000A can cause ``infinite expansion'' of generalized definitions, but cannot render \u000A ACL2 unsound.</p> \u000A \u000A <p>Note that the actual definition of <v>fn1</v> has the runic name \u000A <v>(:definition fn1)</v>.  The runic name of the alternative definition is \u000A <v>(:definition lemma)</v>, where <v>lemma</v> is the name given to the event that \u000A created the generalized <v>:definition</v> rule.  This allows theories to switch \u000A between various ``definitions'' of the functions.</p> \u000A \u000A <p>By default, a <v>:definition</v> rule establishes the so-called ``body'' of a \u000A function.  The body is used by <v>:expand</v> <see topic=\"ACL2____HINTS\">hints</see>, and it is also used \u000A heuristically by the theorem prover's preprocessing (the initial \u000A simplification using ``simple'' rules that is controlled by the \u000A <v>preprocess</v> symbol in <v>:do-not</v> <see topic=\"ACL2____HINTS\">hints</see>), induction analysis, and \u000A the determination for when to warn about non-recursive functions in rules. \u000A The body is also used by some heuristics involving whether a function is \u000A recursively defined, and by the <v>expand</v>, <v>x</v>, and <v>x-dumb</v> commands \u000A of the <see topic=\"ACL2____PROOF-CHECKER\">proof-checker</see>.</p> \u000A \u000A <p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a discussion of the optional field \u000A <v>:install-body</v> of <v>:definition</v> rules, which controls whether a \u000A <v>:definition</v> rule is used as described in the paragraph above.  Note that \u000A even if <v>:install-body nil</v> is supplied, the rewriter will still rewrite \u000A with the <v>:definition</v> rule; in that case, ACL2 just won't install a new \u000A body for the top function symbol of the left-hand side of the rule, which for \u000A example affects the application of <v>:expand</v> hints as described in the \u000A preceding paragraph.  Also see <see topic=\"ACL2____SET-BODY\">set-body</see> and see <see topic=\"ACL2____SHOW-BODIES\">show-bodies</see> for \u000A how to change the body of a function symbol.</p> \u000A \u000A <p>Note only that if you prove a definition rule for function <v>foo</v>, say, \u000A <v>foo-new-def</v>, you will need to refer to that definition as \u000A <v>foo-new-def</v> or as <v>(:DEFINITION foo-new-def)</v>.  That is because a \u000A <v>:definition</v> rule does not change the meaning of the symbol <v>foo</v> for \u000A <v>:use</v> <see topic=\"ACL2____HINTS\">hints</see>, nor does it change the meaning of the symbol <v>foo</v> \u000A in theory expressions; see <see topic=\"ACL2____THEORIES\">theories</see>, in particular the discussion there \u000A of runic designators.  Similarly <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt> <v>foo</v> and <v>:</v><tt><see topic=\"ACL2____PF\">pf</see></tt> <v>foo</v> will still show the original definition of <v>foo</v>.</p> \u000A \u000A <p>The definitional principle, <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, actually adds <v>:definition</v> \u000A rules.  Thus the handling of generalized definitions is exactly the same as \u000A for ``real'' definitions because no distinction is made in the implementation. \u000A Suppose <v>(fn x y)</v> is <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>'d to be <v>body</v>.  Note that <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> (or <tt><see topic=\"ACL2____DEFUNS\">defuns</see></tt> or <tt><see topic=\"ACL2____MUTUAL-RECURSION\">mutual-recursion</see></tt>) can compute the clique \u000A for <v>fn</v> from the syntactic presentation and it can compute the controllers \u000A from the termination analysis.  Provided the definition is admissible, <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> adds the <v>:definition</v> rule <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (fn x y) body)</v>.</p>"],

 "COMMON-LISP____DECLARE":[["Programming","ACL2-built-ins"],"ACL2 Sources","ACL2","<p>Common Lisp provides a declaration mechanism that allows the \u000A programmer to explain additional information to the compiler.  For \u000A instance:</p> \u000A \u000A <ul> \u000A \u000A <li>The programmer might declare that some variable always has some particular \u000A type.  The compiler might then, depending on its optimization/safety settings, \u000A either add run-time checks to ensure that this really is true, or optimize the \u000A compiled code by assuming the variable has the correct type.</li> \u000A \u000A <li>The programmer might declare that some variable is <v>ignore</v>d.  The \u000A compiler might then, instead of warning the programmer that the variable is \u000A never used, explicitly check to make sure that it really is never used.</li> \u000A \u000A </ul> \u000A \u000A <p>ACL2 supports the above kinds of declarations, and also adds its own kinds \u000A of declarations for specifying things like the <see topic=\"ACL2____GUARD\">guard</see>s and <see topic=\"ACL2____MEASURE\">measure</see>s of functions, as described in <see topic=\"ACL2____XARGS\">xargs</see>.</p> \u000A \u000A <p>There are also other kinds of Common Lisp declarations that ACL2 does not \u000A support, e.g., pertaining to inlining, safety settings, variable lifetime, and \u000A so forth.</p> \u000A \u000A <h3>Usage</h3> \u000A \u000A <p>Examples:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> x y z))\u000A(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORABLE\">ignorable</see> x y z)\u000A         (<see topic=\"COMMON-LISP____TYPE\">type</see> integer i j k)\u000A         (<see topic=\"COMMON-LISP____TYPE\">type</see> (satisfies integerp) m1 m2))\u000A(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> i)\u000A                            (&amp;lt;= 0 i))\u000A                :guard-hints ((&quot;Goal&quot; :use (:instance lemma3\u000A                                              (x (<see topic=\"COMMON-LISP_____B2\">+</see> i j)))))))</code> \u000A \u000A <p>General Form:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> d1 ... dn)</code> \u000A \u000A <p>where, in ACL2, each <v>di</v> is of one of the following forms:</p> \u000A \u000A <dl> \u000A \u000A <dt><v>(<see topic=\"COMMON-LISP____IGNORE\">ignore</see> v1 ... vn)</v></dt> \u000A \u000A <dd>where each <v>vi</v> is a variable introduced in the immediately superior \u000A lexical environment.  These variables must not occur free in the scope of the \u000A declaration.  This declaration can be useful for inhibiting compiler warnings; \u000A see also <see topic=\"ACL2____SET-IGNORE-OK\">set-ignore-ok</see>.</dd> \u000A \u000A <dt><v>(<see topic=\"COMMON-LISP____IGNORABLE\">ignorable</see> v1 ... vn)</v></dt> \u000A \u000A <dd>where each <v>vi</v> is a variable introduced in the immediately superior \u000A lexical environment.  These variables need not occur free in the scope of the \u000A declaration.  This declaration can be useful for inhibiting compiler warnings; \u000A see also <see topic=\"ACL2____SET-IGNORE-OK\">set-ignore-ok</see>.</dd> \u000A \u000A <dt><v>(<see topic=\"COMMON-LISP____TYPE\">type</see> type-spec v1 ... vn)</v></dt> \u000A \u000A <dd>where each <v>vi</v> is a variable introduced in the immediately superior \u000A lexical environment and <v>type-spec</v> is a type specifier (as described in \u000A the documentation for <see topic=\"ACL2____TYPE-SPEC\">type-spec</see>).  This declaration can be useful for \u000A optimizing Common Lisp execution speed.  See also <see topic=\"COMMON-LISP____THE\">the</see>.</dd> \u000A \u000A <dt><v>(<see topic=\"ACL2____XARGS\">xargs</see> :key1 val1 ... :keyn valn)</v></dt> \u000A \u000A <dd>where the legal values of the keys and values are described in the \u000A documentation for <see topic=\"ACL2____XARGS\">xargs</see>.  These declarations are only allowed at the \u000A top level of definitions (<tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> and <tt><see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see></tt>, as shown below), \u000A and convey information such as the <see topic=\"ACL2____GUARD\">guard</see> and <see topic=\"ACL2____MEASURE\">measure</see> for a \u000A function.</dd> \u000A \u000A <dt><v>(<see topic=\"COMMON-LISP____OPTIMIZE\">optimize</see> ...)</v></dt> \u000A \u000A <dd>for example, <v>(<see topic=\"COMMON-LISP____OPTIMIZE\">optimize</see> (safety 3))</v>.  This is allowed only at the top \u000A level of <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> forms and is probably only rarely of any interest.  See \u000A any Common Lisp documentation for more information.</dd> \u000A \u000A </dl> \u000A \u000A <p>Declarations in ACL2 may occur only where <v>dcl</v> occurs below:</p> \u000A \u000A <ul> \u000A <li><v>(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> name args doc-string dcl ... dcl body)</v></li> \u000A <li><v>(<see topic=\"COMMON-LISP____DEFMACRO\">DEFMACRO</see> name args doc-string dcl ... dcl body)</v></li> \u000A <li><v>(<see topic=\"COMMON-LISP____LET\">LET</see> ((v1 t1) ...) dcl ... dcl body)</v></li> \u000A <li><v>(<see topic=\"ACL2____MV-LET\">MV-LET</see> (v1 ...) term dcl ... dcl body)</v></li> \u000A <li><v>(<see topic=\"COMMON-LISP____FLET\">FLET</see> ((<see topic=\"ACL2____NAME\">name</see> args dcl ... dcl body) ...))</v></li> \u000A </ul> \u000A \u000A <p>Of course, if a form macroexpands into one of these (e.g., as <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> \u000A expands into nested <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>s and our <v>er-let*</v> expands into nested \u000A <tt><see topic=\"ACL2____MV-LET\">mv-let</see></tt>s) then declarations are permitted as handled by the macros \u000A involved.</p> \u000A \u000A <p><v>Declare</v> is defined in Common Lisp.  See any Common Lisp documentation \u000A for more information.</p>"],

 "ACL2____CERTIFICATE":[["Books-tour"],"ACL2 Sources","ACL2","<p>A book, say <v>&quot;arith&quot;</v>, is said to have a ``certificate'' if \u000A there is a file named <v>&quot;arith.cert&quot;</v>.  Certificates are created by the \u000A function <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> and inspected by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.  Check \u000A sums are used to help ensure that certificates are legitimate and that the \u000A corresponding book has not been modified since certification.  But because the \u000A file system is insecure and check sums are not perfect it is possible for the \u000A inclusion of a book to cause inconsistency even though the book carries an \u000A impeccable certificate.</p> \u000A \u000A <p>The certificate includes the version number of the certifying ACL2.  A book \u000A is considered uncertified if it is included in an ACL2 with a different <see topic=\"ACL2____VERSION\">version</see> number.</p> \u000A \u000A <p>The presence of a ``valid'' certificate file for a book attests to two \u000A things: all of the <see topic=\"ACL2____EVENTS\">events</see> of the book are admissible in a certain \u000A extension of the initial ACL2 logic, and the non-<tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> \u000A of the book are independent of the <tt><see topic=\"ACL2____LOCAL\">local</see></tt> ones (see <see topic=\"ACL2____LOCAL-INCOMPATIBILITY\">local-incompatibility</see>).  In addition, the certificate contains the <see topic=\"ACL2____COMMAND\">command</see>s used to construct the <see topic=\"ACL2____WORLD\">world</see> in which certification occurred. \u000A Among those <see topic=\"ACL2____COMMAND\">command</see>s, of course, are the <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt>s defining the \u000A packages used in the book.  When a book is included into a host <see topic=\"ACL2____WORLD\">world</see>, \u000A that <see topic=\"ACL2____WORLD\">world</see> is first extended by the <see topic=\"ACL2____COMMAND\">command</see>s listed in the \u000A certificate for the book.  Unless that causes an error due to name conflicts, \u000A the extension ensures that all the packages used by the book are identically \u000A defined in the host <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <p><i>Security:</i></p> \u000A \u000A <p>Because the host file system is insecure, there is no way ACL2 can \u000A guarantee that the contents of a book remain the same as when its certificate \u000A was written.  That is, between the time a book is certified and the time it is \u000A used, it may be modified.  Furthermore, certificates can be counterfeited. \u000A Check sums (see <see topic=\"ACL2____CHECK-SUM\">check-sum</see>) are used to help detect such problems.  But \u000A check sums provide imperfect security: two different files can have the same \u000A check sum.</p> \u000A \u000A <p>Therefore, from the strictly logical point of view, one must consider even \u000A the inclusion of certified <see topic=\"ACL2____BOOKS\">books</see> as placing a burden on the user:</p> \u000A \u000A <blockquote> \u000A \u000A <p>The non-erroneous inclusion of a certified book is consistency preserving \u000A provided (a) the objects read by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> from the certificate \u000A were the objects written there by a <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt> and (b) the forms \u000A read by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> from the book itself are the forms read by the \u000A corresponding <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>.</p> \u000A \u000A </blockquote> \u000A \u000A <p>We say that a given execution of <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> is ``certified'' if a \u000A certificate file for the book is present and well-formed and the check sum \u000A information contained within it supports the conclusion that the <see topic=\"ACL2____EVENTS\">events</see> \u000A read by the <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> are the ones checked by <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>. \u000A When an uncertified <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> occurs, warnings are printed or \u000A errors are caused.  But even if no warning is printed, you must accept burdens \u000A (a) and (b) if you use <see topic=\"ACL2____BOOKS\">books</see>.  These burdens are easier to live with if \u000A you protect your <see topic=\"ACL2____BOOKS\">books</see> so that other users cannot write to them, you \u000A abstain from running concurrent ACL2 jobs, and you abstain from counterfeiting \u000A certificates.  But even on a single user uniprocessor, you can shoot yourself \u000A in the foot by using the ACL2 <see topic=\"ACL2____IO\">io</see> primitives to fabricate an \u000A inconsistent book and the corresponding certificate.</p> \u000A \u000A <p>Note that part (a) of the burden described above implies, in particular, \u000A that there are no guarantees when a certificate is copied.  When <see topic=\"ACL2____BOOKS\">books</see> \u000A are renamed (as by copying them), it is recommended that their certificates be \u000A removed and the <see topic=\"ACL2____BOOKS\">books</see> be recertified.  The expectation is that \u000A recertification will go through without a hitch if relative <see topic=\"COMMON-LISP____PATHNAME\">pathname</see>s \u000A are used.  See <see topic=\"COMMON-LISP____PATHNAME\">pathname</see>, which is not on the guided tour.</p> \u000A \u000A <p>Certificates essentially contain two parts, a <see topic=\"ACL2____PORTCULLIS\">portcullis</see> and a <see topic=\"ACL2____KEEP\">keep</see>.  There is a third part, an <v>expansion-alist</v>, in order to record \u000A expansions if <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> has been used, but the user need not be \u000A concerned with that level of detail.</p> \u000A \u000A <p>See <see topic=\"ACL2____PORTCULLIS\">portcullis</see> to continue the guided tour through <see topic=\"ACL2____BOOKS\">books</see>.</p>"],

 "ACL2____BOOKS":[["ACL2","Note1"],"ACL2 Sources","ACL2","<p>This <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic is about ACL2 <a \u000A href='https://en.wikipedia.org/wiki/Source_code'>source code</a> files. \u000A However, there are also <a \u000A href='http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html#Books'>traditional, \u000A paper books</a> published about ACL2 and its applications.</p> \u000A \u000A <p>You will almost surely want to organize your own ACL2 work into books. \u000A They facilitate reuse, allow you to reload proofs more quickly, allow you to \u000A rebuild parts of your proof in parallel, and so forth.  You will also want to \u000A be aware of the many <i>community books</i>, which provide useful tools and \u000A lemmas to build upon.  See <see topic=\"ACL2____COMMUNITY-BOOKS\">community-books</see> for more information, \u000A including how to contribute.</p> \u000A \u000A <h3>Introduction</h3> \u000A \u000A <p>A <b>book</b> is a file of ACL2 forms.  Books are prepared entirely by the \u000A user of the system, i.e., they are <i>source files</i> not <i>object \u000A files</i>.  Some of the forms in a book are marked <tt><see topic=\"ACL2____LOCAL\">local</see></tt> and the \u000A others are considered ``non-local.''</p> \u000A \u000A <p><tt><see topic=\"ACL2____INCLUDE-BOOK\">Include-book</see></tt> lets you load a book into any ACL2 <see topic=\"ACL2____WORLD\">world</see>.  A \u000A successful <v>include-book</v> extends the logic of the host <see topic=\"ACL2____WORLD\">world</see> by \u000A adding just the non-local <see topic=\"ACL2____EVENTS\">events</see> in the book.  Ordinarily, you might \u000A include a variety of books to load all of their definitions and rules.</p> \u000A \u000A <p>Successful book inclusion is consistency preserving, provided that the book \u000A itself is consistent, as discussed later.  However, <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> \u000A assumes the <see topic=\"ACL2____EVENTS\">events</see> in a book are valid, so if you include a book that \u000A contains an inconsistency (e.g., an inadmissible definition) then the \u000A resulting theory is inconsistent!</p> \u000A \u000A <p><tt><see topic=\"ACL2____CERTIFY-BOOK\">Certify-book</see></tt> lets you <i>certify</i> a book to guarantee that its \u000A successful inclusion is consistency preserving.  During certification, both \u000A the <tt><see topic=\"ACL2____LOCAL\">local</see></tt> and non-local forms are processed.  This lets you mark as \u000A <tt><see topic=\"ACL2____LOCAL\">local</see></tt> any <see topic=\"ACL2____EVENTS\">events</see> you need for certification, but that you want \u000A to hide from users of the book&mdash;e.g., the hacks, crocks, and kludges on \u000A the way to a good set of <see topic=\"ACL2____REWRITE\">rewrite</see> rules.</p> \u000A \u000A <p>Certification can also <see topic='ACL2____COMPILATION'>compile</see> a book \u000A to speed up the execution of the functions defined within it.  The desire to \u000A compile books is largely responsible for the restrictions we put on the forms \u000A allowed in books.</p> \u000A \u000A <p>Extensive <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> is available on the various aspects of \u000A books.  We recommend that you read it all before using books.  It has been \u000A written so as to make sense when read in a certain linear sequence, called the \u000A ``guided tour'', though in general you may browse through it randomly.  If you \u000A are on the guided tour, you should next read <see topic=\"ACL2____BOOK-EXAMPLE\">book-example</see>.</p>"],

 "ACL2____WORMHOLE":[["State","Ld"],"ACL2 Sources","ACL2","<code>Example Form: \u000A; The following form enters a recursive read-eval-print loop on a \u000A; copy of the current state, allowing you to interact with that loop. \u000A; Note that the form does not mention the ACL2 state variable! \u000A; Evaluate the form below. Inside the resulting loop, define some function, \u000A; e.g., with <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)</v>.  Then exit with <v>:q</v> and observe, \u000A; e.g., with <v>:pe foo</v>, that the external state did not change. \u000A \u000A(wormhole 'foo \u000A          '(lambda (whs) (set-wormhole-entry-code whs :ENTER)) \u000A          nil \u000A          '(list 'hello 'there)) \u000A</code> \u000A \u000A <code>General Form:\u000A(<see topic=\"ACL2____WORMHOLE\">wormhole</see> name entry-lambda input form\u000A  :current-package    ...  ; known package name\u000A  :ld-skip-proofsp    ...  ; nil, t or 'include-book\u000A  :ld-redefinition-action  ; nil or '(:a . :b)\u000A  :ld-prompt          ...  ; nil, t, or some prompt printer fn\u000A  :ld-missing-input-ok ... ; nil, t, :warn, or warning message\u000A  :ld-pre-eval-filter ...  ; :all, :query, or some new name\u000A  :ld-pre-eval-print  ...  ; nil, t, or :never\u000A  :ld-post-eval-print ...  ; nil, t, or :command-conventions\u000A  :ld-evisc-tuple     ...  ; nil or '(alist level length hiding-cars)\u000A  :ld-error-triples   ...  ; nil or t\u000A  :ld-error-action    ...  ; :return!, :return, :continue, :error,\u000A                           ;   or (:exit N)\u000A  :ld-query-control-alist  ; alist supplying default responses\u000A  :ld-verbose         ...) ; nil or t</code> \u000A \u000A <p>The keyword arguments above are exactly those of <tt><see topic=\"ACL2____LD\">ld</see></tt> (see <see topic=\"ACL2____LD\">ld</see>) \u000A except that three of <tt><see topic=\"ACL2____LD\">ld</see></tt>'s keyword arguments are missing: the three \u000A that specify the channels <tt><see topic=\"ACL2____STANDARD-OI\">standard-oi</see></tt>, <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt> and <tt><see topic=\"ACL2____PROOFS-CO\">proofs-co</see></tt>, which default in <v>wormhole</v> to ACL2's comment window.</p> \u000A \u000A <p>There are two ways to create and enter a wormhole: <v>wormhole</v> as \u000A described here and the simpler <tt><see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see></tt>.  We recommend you read \u000A this full account of wormholes before using <v>wormhole-eval</v>.</p> \u000A \u000A <p>Ignoring the use of <v>entry-lambda</v>, <v>wormhole</v> manufactures a named \u000A ``wormhole <see topic=\"ACL2____STATE\">state</see>'' and calls the general-purpose ACL2 read-eval-print \u000A loop <tt><see topic=\"ACL2____LD\">ld</see></tt> on it.  However, when <v>ld</v> exits, the wormhole evaporates \u000A and the function <v>wormhole</v> returns <v>nil</v>.  The manufactured state is \u000A like the ``current'' ACL2 <see topic=\"ACL2____STATE\">state</see> except for two things.  First, some \u000A information from the last wormhole state of this name is transferred into the \u000A new state; this allows a wormhole to maintain some state from one call to the \u000A next.  Second, some information from the wormhole call itself is transferred \u000A into the new state; this allows the wormhole to be sensitive to context. \u000A These two changes to the current state are reflected in the settings <v>(<see topic=\"ACL2_____04\">@</see>\u000A wormhole-status)</v> and <v>(<see topic=\"ACL2_____04\">@</see> wormhole-input)</v> discussed in detail below.</p> \u000A \u000A <p>Note that <v>wormhole</v> may be called from environments in which <tt><see topic=\"ACL2____STATE\">state</see></tt> is not bound.  It is still applicative because it always returns \u000A <v>nil</v>.</p> \u000A \u000A <p>There are some restrictions about what can be done inside a wormhole.  As \u000A you may imagine, we really do not ``copy the current state'' but rather just \u000A keep track of how we modified it and undo those modifications upon exit.  An \u000A error is signalled if you try to modify state in an unsupported way.  For this \u000A same reason, wormholes do not allow updating of any user-defined \u000A single-threaded objects.  See <see topic=\"ACL2____STOBJ\">stobj</see>.</p> \u000A \u000A <p>One example wormhole is the implementation of the ACL2 <tt><see topic=\"ACL2____ACCUMULATED-PERSISTENCE\">accumulated-persistence</see></tt> facility for tracking the frequency with which rules \u000A are tried.  To implement this feature directly the theorem prover would have \u000A to take the tracking data as an argument and pass it around so that updates \u000A could be accumulated.  This would greatly clutter the code.  Instead, the \u000A tracking data is maintained in a wormhole.  The theorem prover enters the \u000A wormhole to update the data as rules are tried.  When you request a display of \u000A the data, <tt><see topic=\"ACL2____SHOW-ACCUMULATED-PERSISTENCE\">show-accumulated-persistence</see></tt> enters the wormhole and prints \u000A the data.  But the data is never available outside that wormhole.  The ACL2 \u000A system uses a second wormhole to implement the <tt><see topic=\"ACL2____BRR\">brr</see></tt> facility, allowing \u000A the user to interact with the rewriter as rules are applied.</p> \u000A \u000A <p>We now specify the arguments and behavior of <v>wormhole</v>.</p> \u000A \u000A <p>The <v>name</v> argument must be a quoted constant and is typically a symbol. \u000A It will be the ``name'' of the wormhole.  A wormhole of that name will be \u000A created the first time either <v>wormhole</v> or <tt><see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see></tt> is \u000A called.</p> \u000A \u000A <p>Every wormhole name has a ``status.''  The status of a wormhole is stored \u000A outside of ACL2; it is inaccessible to the ACL2 user except when in the named \u000A wormhole.  But the status of a wormhole may be set by the user from within the \u000A wormhole.</p> \u000A \u000A <p>Upon the first call of <v>wormhole</v> or <v>wormhole-eval</v> on a name, the \u000A status of that name is <v>nil</v>.  But in general you should arrange for the \u000A status to be a cons.  The status is set by the quoted <v>lambda</v> every time \u000A <v>wormhole</v> is called; but it may also be set in the <v>form</v> argument (the \u000A first form evaluated in the interactive loop) by assigning to the state global \u000A variable <v>wormhole-status</v>, as with</p> \u000A \u000A <code>(<see topic=\"ACL2____ASSIGN\">assign</see> wormhole-status ...)</code> \u000A \u000A <p>or even by the user interacting with the loop if you do not exit the loop \u000A with the first form.  The <v>car</v> of the cons should be either <v>:ENTER</v> or \u000A <v>:SKIP</v> and is called the wormhole's ``entry code.''  The entry code of \u000A <v>nil</v> or an unexpectedly shaped status is <v>:ENTER</v>.  The <v>cdr</v> of the \u000A cons is arbitrary data maintained by you.</p> \u000A \u000A <p>When <v>wormhole</v> is invoked, the status of the specified name is \u000A incorporated into the manufactured wormhole state.  In particular, inside the \u000A wormhole, the status is the value of the state global variable \u000A <v>wormhole-status</v>.  That is, inside the wormhole, the status may be \u000A accessed by <v>(<see topic=\"ACL2_____04\">@</see> wormhole-status)</v> and set by <v>(<see topic=\"ACL2____ASSIGN\">assign</see> wormhole-status\u000A ...)</v>, <v>f-get-global</v> and <v>f-put-global</v>.  When <v>ld</v> exits -- \u000A typically because the form <v>:q</v> was read by <v>ld</v> -- the then-current \u000A value of wormhole-status is hidden away so that it can be restored when this \u000A wormhole is entered again.  The rest of the wormhole state is lost.</p> \u000A \u000A <p>This allows a sequence of entries and exits to a wormhole to maintain some \u000A history in the status and this information can be manipulated by ACL2 \u000A functions executing inside the wormhole.</p> \u000A \u000A <p>The second argument to <v>wormhole</v> must be a quoted lambda expression. \u000A We explain it later.</p> \u000A \u000A <p>The third argument, <v>input</v>, may be any term.  The value of the term is \u000A passed into the manufactured wormhole state, allowing you to pass in \u000A information about the calling context.  Inside the wormhole, the <v>input</v> is \u000A available via <v>(<see topic=\"ACL2_____04\">@</see> wormhole-input)</v>.  It could be reassigned via <v>(<see topic=\"ACL2____ASSIGN\">assign</see>\u000A wormhole-input ...)</v>, but there is no reason to do that.</p> \u000A \u000A <p>The fourth argument, <v>form</v>, may be any term; when <tt><see topic=\"ACL2____LD\">ld</see></tt> is called \u000A on the manufactured wormhole state, the first form evaluated by <v>ld</v> will \u000A be the value of <v>form</v>.  Note that <v>form</v> will be translated by <v>ld</v>. \u000A Errors, including guard violations, in the translation or execution of that \u000A first form will leave you in the interactive loop of the wormhole state.</p> \u000A \u000A <p>When used properly, the first form allows you to greet your user before \u000A reading the first interactive command or simply to do whatever computation you \u000A want to do inside the wormhole and exit silently.  We give examples below.</p> \u000A \u000A <p>Manufacturing a wormhole state is relatively expensive; in addition, the \u000A forms executed by <v>ld</v> must be read, translated, and interpreted as with \u000A any user type-in.  The <v>entry-lambda</v> offers a way to avoid this or, at \u000A least, to decide whether to incur that expense.</p> \u000A \u000A <p>Before the wormhole state is manufactured and entered, the \u000A <v>entry-lambda</v> is applied to the current wormhole status with <tt><see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see></tt>.  That <v>lambda</v> application must produce a new wormhole \u000A status, which is stored as the wormhole's status.  The entry code for the new \u000A status determines whether <v>wormhole</v> actually manufactures a wormhole state \u000A and calls <v>ld</v>.</p> \u000A \u000A <p>If the entry code for that new status is <v>:ENTER</v> the wormhole state is \u000A manufactured and entered; otherwise, the new status is simply saved as the \u000A most recent status but the wormhole state is not manufactured or entered. \u000A Note therefore that the <v>entry-lambda</v> may be used to perform two \u000A functions: (a) to determine if it is really necessary to manufacture a state \u000A and (b) to update the data in the wormhole status as a function of the old \u000A status without invoking <v>ld</v>.</p> \u000A \u000A <p>The <v>entry-lambda</v> must be a quoted lambda expression of at most one \u000A argument.  Thus, the argument must be either</p> \u000A \u000A <code>'(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (whs) &lt;body&gt;)</code> \u000A \u000A <p>or</p> \u000A \u000A <code>'(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> () &lt;body&gt;)</code> \u000A \u000A <p>Note the quote.  If a formal, e.g., <v>whs</v>, is provided, it must be used \u000A as a variable in the <v>lambda</v> body.  The <v>lambda</v>-expression may contain \u000A free variables, that is, the body may mention variables other than the \u000A <v>lambda</v> formal.  These free variables are understood in the caller's \u000A environment.  These conventions allow us to compile the <v>entry-lambda</v> \u000A application very efficiently when the guard has been verified.</p> \u000A \u000A <p>The guard on a call of <v>wormhole</v> is the conjunction of the guards on \u000A the arguments conjoined with the guard on the body of the <v>entry-lambda</v>. \u000A See <see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see> for a discussion of the guard on the \u000A <v>lambda</v>-expression.</p> \u000A \u000A <p>The functions <tt><see topic=\"ACL2____WORMHOLE-STATUSP\">wormhole-statusp</see></tt>, <tt><see topic=\"ACL2____WORMHOLE-ENTRY-CODE\">wormhole-entry-code</see></tt>, <tt><see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see></tt>, <tt><see topic=\"ACL2____SET-WORMHOLE-ENTRY-CODE\">set-wormhole-entry-code</see></tt>, <tt><see topic=\"ACL2____SET-WORMHOLE-DATA\">set-wormhole-data</see></tt>, \u000A and <tt><see topic=\"ACL2____MAKE-WORMHOLE-STATUS\">make-wormhole-status</see></tt> may be useful in manipulating entry codes and \u000A data in the <v>entry-lambda</v>.</p> \u000A \u000A <p>Note that you access and manipulate the wormhole's status in two different \u000A ways depending on whether you're ``outside'' of the wormhole applying the \u000A quoted <v>lambda</v> or ``inside'' the read-eval-print loop of the wormhole.</p> \u000A \u000A <p>OUTSIDE (<v>wormhole-eval</v>): access via the value of the <v>lambda</v> \u000A formal and set by returning the new status as the value of the <v>lambda</v> \u000A body.</p> \u000A \u000A <p>INSIDE (<v>ld</v> phase of <v>wormhole</v>): access via <v>(<see topic=\"ACL2_____04\">@</see>\u000A wormhole-status)</v>, and set via <v>(<see topic=\"ACL2____ASSIGN\">assign</see> wormhole-status ...)</v>.</p> \u000A \u000A <p>Pragmatic Advice on Designing a Wormhole: Suppose you are using wormholes \u000A to implement some extra-logical utility.  You must contemplate how you will \u000A use your wormhole's status to store hidden information.  You might be tempted \u000A to exploit the entry code as part of the status.  For example, you may think \u000A of <v>:ENTER</v> as indicating that your utility is ``turned on'' and <v>:SKIP</v> \u000A as indicating that your utility is ``turned off.''  We advise against such a \u000A design.  We recommend you base your decisions on the wormhole data.  We \u000A recommend that you set but not read the wormhole entry code to signal whether \u000A you wish to enter a full-fledged wormhole.  To use the entry code as a flag \u000A overloads it and invites confusion when your facility is ``turned off'' but \u000A you have to enter the wormhole for some reason.</p> \u000A \u000A <p>For a behind-the-scenes description of how wormholes work, See <see topic=\"ACL2____WORMHOLE-IMPLEMENTATION\">wormhole-implementation</see>.</p> \u000A \u000A <p>Here are some sample situations handled by <v>wormhole-eval</v> and \u000A <v>wormhole</v>.  Let the wormhole in question be named <v>DEMO</v>.  Initially \u000A its status is <v>NIL</v>.  The functions below all maintain the convention that \u000A the status is either <v>nil</v> or of the form <v>(:key . lst)</v>, where \u000A <v>:key</v> is either <v>:SKIP</v> or <v>:ENTER</v> and <v>lst</v> is a true-list of \u000A arbitrary objects.  But since there is no way to prevent the user from \u000A entering the <v>DEMO</v> wormhole interactively and doing something to the \u000A status, this convention cannot be enforced.  Thus, the functions below do what \u000A we say they do, e.g., remember all the values of <v>x</v> ever seen, only if \u000A they're the only functions messing with the <v>DEMO</v> status.  On the other \u000A hand, the guards of all the functions below can be verified.  We have \u000A explicitly declared that the guards on the functions below are to be verified, \u000A to confirm that they can be.  Guard verification is optional but wormholes \u000A (and <v>wormhole-eval</v> in particular) are more efficient when guards have \u000A been verified.  All of the functions defined below return <v>nil</v>.</p> \u000A \u000A <p>The examples below build on each other.  If you really want to understand \u000A wormholes we recommend that you evaluate each of the forms below, in the order \u000A they are discussed.</p> \u000A \u000A <p><b>Q.</b> How do I create a wormhole that prints its status to the comment \u000A window?</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> demo-status ()\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :verify-guards t))\u000A  (<see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see> 'demo\u000A                 '(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (whs)\u000A                    (<see topic=\"ACL2____PROG2_42\">prog2$</see> (<see topic=\"ACL2____CW\">cw</see> &quot;DEMO status:~%~x0~%&quot; whs)\u000A                            whs))\u000A                 nil))</code> \u000A \u000A <p>Note above that after printing the status to the comment window we return \u000A the new (unchanged) status <v>whs</v>.  Had we just written the call of <v>cw</v>, \u000A which returns <v>nil</v>, the function would print the status and then set it to \u000A <v>nil</v>!</p> \u000A \u000A <p><b>Q.</b> How do I use a wormhole to collect every symbol, <v>x</v>, passed \u000A to the function?</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> demo-collect (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :verify-guards t))\u000A  (<see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see> 'demo\u000A                 '(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (whs)\u000A                    (<see topic=\"ACL2____MAKE-WORMHOLE-STATUS\">make-wormhole-status</see> whs\u000A                                          (<see topic=\"ACL2____WORMHOLE-ENTRY-CODE\">wormhole-entry-code</see> whs)\u000A                                          (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____SYMBOLP\">symbolp</see> x)\u000A                                              (<see topic=\"COMMON-LISP____CONS\">cons</see> x (<see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see> whs))\u000A                                              (<see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see> whs))))\u000A                 nil))</code> \u000A \u000A <p>We could have also defined this function this way:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> demo-collect (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :verify-guards t))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____SYMBOLP\">symbolp</see> x)\u000A      (<see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see> 'demo\u000A                     '(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (whs)\u000A                        (<see topic=\"ACL2____SET-WORMHOLE-DATA\">set-wormhole-data</see> whs\u000A                                           (<see topic=\"COMMON-LISP____CONS\">cons</see> x (<see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see> whs))))\u000A                     nil)\u000A      nil))</code> \u000A \u000A <p>Both versions always return <v>nil</v> and both versions collect into the \u000A wormhole data field just the symbols <v>x</v> upon which <v>demo-collect</v> is \u000A called.</p> \u000A \u000A <p><b>Q.</b> How do I use <v>demo-collect</v>?  Below is a function that maps \u000A over a list and computes its length.  But it has been annotated with a call to \u000A <v>demo-collect</v> on every element.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> my-len (lst)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____ENDP\">endp</see> lst)\u000A      0\u000A      (<see topic=\"COMMON-LISP_____B2\">+</see> 1\u000A         (<see topic=\"ACL2____PROG2_42\">prog2$</see> (demo-collect (<see topic=\"COMMON-LISP____CAR\">car</see> lst))\u000A                 (my-len (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst))))))</code> \u000A \u000A <p>Thus, for example:</p> \u000A \u000A <code>ACL2 !&gt;(my-len '(4 temp car &quot;Hi&quot; rfix))\u000A5\u000AACL2 !&gt;(demo-status)\u000ADEMO status:\u000A(:ENTER RFIX CAR TEMP)\u000ANIL\u000AACL2 !&gt;</code> \u000A \u000A <p><b>Q.</b> How do I set the entry code to <v>:ENTER</v> or <v>:SKIP</v> \u000A according to whether <v>name</v> is a <v>member-equal</v> of the list of things \u000A seen so far?  Note that we cannot check this condition outside the wormhole, \u000A because it depends on the list of things collected so far.  We make the \u000A decision inside the <v>lambda</v>-expression.  Note that we explicitly check \u000A that the guard of <v>member-equal</v> is satisfied by the current wormhole \u000A status, since we cannot rely on the invariant that no other function \u000A interferes with the status of the <v>DEMO</v> wormhole.  In the case that the \u000A status is ``unexpected'' we act like the status is <v>nil</v> and set it to \u000A <v>(:SKIP . NIL)</v>.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> demo-set-entry-code (<see topic=\"ACL2____NAME\">name</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :verify-guards t))\u000A  (<see topic=\"ACL2____WORMHOLE-EVAL\">wormhole-eval</see> 'demo\u000A                 '(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (whs)\u000A                    (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> (<see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see> whs))\u000A                        (<see topic=\"ACL2____SET-WORMHOLE-ENTRY-CODE\">set-wormhole-entry-code</see>\u000A                         whs\u000A                         (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____MEMBER-EQUAL\">member-equal</see> name (<see topic=\"ACL2____WORMHOLE-DATA\">wormhole-data</see> whs))\u000A                             :ENTER\u000A                             :SKIP))\u000A                        '(:SKIP . NIL)))\u000A                 nil))</code> \u000A \u000A <p>Thus</p> \u000A \u000A <code>ACL2 !&gt;(demo-set-entry-code 'monday)\u000ANIL\u000AACL2 !&gt;(demo-status)\u000ADEMO status:\u000A(:SKIP RFIX CAR TEMP)\u000ANIL\u000AACL2 !&gt;(demo-set-entry-code 'rfix)\u000ANIL\u000AACL2 !&gt;(demo-status)\u000ADEMO status:\u000A(:ENTER RFIX CAR TEMP)\u000ANIL\u000AACL2 !&gt;</code> \u000A \u000A <p><b>Q.</b> Suppose I want to collect every symbol and then, if the symbol \u000A has an <v>ABSOLUTE-EVENT-NUMBER</v> property in the ACL2 logical world, print \u000A the defining event with <v>:pe</v> and then enter an interactive loop; but if \u000A the symbol does not have an <v>ABSOLUTE-EVENT-NUMBER</v>, don't print anything \u000A and don't enter an interactive loop.</p> \u000A \u000A <p>Here it is not important to know what <v>ABSOLUTE-EVENT-NUMBER</v> is; this \u000A example just shows that we can use a wormhole to access the ACL2 logical \u000A world, even in a function that does not take the state as an argument.</p> \u000A \u000A <p>In the code below, we use <v>wormhole</v> instead of <v>wormhole-eval</v>, \u000A because we might have to access the logical world and enter an interactive \u000A loop.  But for efficiency we do as much as we can inside the entry \u000A <v>lambda</v>, where we can check whether <v>x</v> is symbol and collect it into \u000A the data field of the wormhole status.  Note that if we collect <v>x</v>, we \u000A also set the entry code to <v>:ENTER</v>.  If we don't collect <v>x</v>, we set \u000A the entry code to <v>:SKIP</v>.</p> \u000A \u000A <code>(defun collect-symbols-and-print-events (x) \u000A  (declare (xargs :guard t)) \u000A  (wormhole 'demo \u000A            '(lambda (whs) \u000A               (if (symbolp x) \u000A                   (make-wormhole-status whs \u000A                                         :ENTER \u000A                                         (cons x (wormhole-data whs))) \u000A                   (set-wormhole-entry-code whs :SKIP))) \u000A \u000A; The wormhole will not get past here is unless the entry code is \u000A; :ENTER.  If we get past here, we manufacture a state, put \u000A; x into <v>(<see topic=\"ACL2_____04\">@</see> wormhole-input)</v> and call ld in such a way that the \u000A; first form executed is the quoted if-expression below. \u000A \u000A            x \u000A            '(if (getprop (@ wormhole-input) \u000A                          'absolute-event-number \u000A                          nil \u000A                          'CURRENT-ACL2-WORLD (w state)) \u000A                 (er-progn \u000A                  (mv-let (col state) \u000A                          (fmt \"~%Entering a wormhole on the event name ~x0~%\" \u000A                               (list (cons #\\0 (@ wormhole-input))) \u000A                               *standard-co* state nil) \u000A                          (declare (ignore col)) \u000A                          (value nil)) \u000A                  (pe (@ wormhole-input)) \u000A                  (set-ld-prompt 'wormhole-prompt state) \u000A                  (value :invisible)) \u000A                 (value :q)) \u000A            :ld-verbose nil \u000A            :ld-prompt nil)) \u000A</code> \u000A \u000A <p>The ``first form'' (the <v>if</v>) asks whether the <v>wormhole-input</v> \u000A (i.e., <v>x</v>) has an <v>ABSOLUTE-EVENT-NUMBER</v> property.  If so, it enters \u000A an <tt><see topic=\"ACL2____ER-PROGN\">er-progn</see></tt> to perform a sequence of commands, each of which returns \u000A an ACL2 error triple (see <see topic=\"ACL2____PROGRAMMING-WITH-STATE\">programming-with-state</see>).  The first form uses \u000A <tt><see topic=\"ACL2____FMT\">fmt</see></tt> to print a greeting.  Since <v>fmt</v> returns <v>(<see topic=\"ACL2____MV\">mv</see> col state)</v> \u000A and we must return an error triple, we embed the <v>fmt</v> term in an \u000A <v>(<see topic=\"ACL2____MV-LET\">mv-let</see> (col state) ... (value nil))</v>.  The macro <v>value</v> takes an \u000A object and returns a ``normal return'' error triple.  The second form in the \u000A <v>er-progn</v> uses the ACL2 history macro <v>pe</v> (see <see topic=\"ACL2____PE\">pe</see>) to print the \u000A defining event for a name.  The third form sets the prompt of this \u000A read-eval-print loop to the standard function for printing the wormhole \u000A prompt.  We silenced the printing of the prompt when we called <v>ld</v>, thanks \u000A to the <v>:ld-prompt nil</v> keyword option.  More on this below.  The fourth \u000A form returns the error triple value <v>:invisible</v> as the value of the first \u000A form.  This prevents <v>ld</v> from printing the value of the first form.  Since \u000A we have not exited <v>ld</v>, that function just continues by reading the next \u000A form from the comment window.  The user perceives this as entering a \u000A read-eval-print loop.  We continue in the loop until the user types \u000A <v>:q</v>.</p> \u000A \u000A <p>On the other branch of the <v>if</v>, if the symbol has no \u000A <v>ABSOLUTE-EVENT-NUMBER</v> property, we execute the form <v>(value :q)</v>, \u000A which is the programming equivalent of typing <v>:q</v>.  That causes the \u000A <v>ld</v> to exit.</p> \u000A \u000A <p>The <v>ld</v> special variables set in the call to <v>wormhole</v> and further \u000A manipulated inside the first form to <v>ld</v> may require explanation.  By \u000A setting <v>:</v><tt><see topic=\"ACL2____LD-VERBOSE\">ld-verbose</see></tt> to <v>nil</v>, we prevent <v>ld</v> from printing \u000A the familiar ACL2 banner when <v>ld</v> is called.  If <v>:ld-verbose nil</v> is \u000A deleted, then you would see something like</p> \u000A \u000A <code>ACL2 Version  4.0.  Level 2.\u000A...\u000AType (<see topic=\"ACL2____GOOD-BYE\">good-bye</see>) to quit completely out of ACL2.</code> \u000A \u000A <p>before the first form is read and evaluated.</p> \u000A \u000A <p>By setting <v>:</v><tt><see topic=\"ACL2____LD-PROMPT\">ld-prompt</see></tt> to <v>nil</v> we prevent <v>ld</v> from \u000A printing the prompt before reading and evaluating the first form.</p> \u000A \u000A <p>As this example shows, to use full-blown wormholes you must understand the \u000A protocol for using wormhole status to control whether a wormhole state is \u000A manufactured for <v>ld</v> and you must also understand programming with <tt><see topic=\"ACL2____STATE\">state</see></tt> and the effects of the various <tt><see topic=\"ACL2____LD\">ld</see></tt> ``special variables.''</p> \u000A \u000A <p>From the discussion above we see that wormholes can be used to create \u000A formatted output without passing in the ACL2 <tt><see topic=\"ACL2____STATE\">state</see></tt>.  For examples see \u000A <see topic=\"ACL2____CW\">cw</see>, in particular the discussion at the end of that documentation \u000A topic.</p>"],

 "ACL2____TERM":[["Miscellaneous"],"ACL2 Sources","ACL2","<code>Examples of Terms:\u000A(<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____CAAR\">caar</see> x) (<see topic=\"COMMON-LISP____CONS\">cons</see> t x)) (t 0))   ; an untranslated term\u000A\u000A(<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)) (<see topic=\"COMMON-LISP____CONS\">cons</see> 't x) '0)    ; a translated term\u000A\u000A(<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> x y) 'nil v)              ; a pseudo-term</code> \u000A \u000A <p>In traditional first-order predicate calculus a ``term'' is a syntactic \u000A entity denoting some object in the universe of individuals.  Often, for \u000A example, the syntactic characterization of a term is that it is either a \u000A variable symbol or the application of a function symbol to the appropriate \u000A number of argument terms.  Traditionally, ``atomic formulas'' are built from \u000A terms with predicate symbols such as ``equal'' and ``member;'' ``formulas'' \u000A are then built from atomic formulas with propositional ``operators'' like \u000A ``not,'' ``and,'' and ``implies.'' Theorems are formulas.  Theorems are \u000A ``valid'' in the sense that the value of a theorem is true, in any model of \u000A the axioms and under all possible assignments of individuals to variables.</p> \u000A \u000A <p>However, in ACL2, terms are used in place of both atomic formulas and \u000A formulas.  ACL2 does not have predicate symbols or propositional operators as \u000A distinguished syntactic entities.  The ACL2 universe of individuals includes a \u000A ``true'' object (denoted by <v>t</v>) and a ``false'' object (denoted by \u000A <v>nil</v>), predicates and propositional operators are functions that return \u000A these objects.  Theorems in ACL2 are terms and the ``validity'' of a term \u000A means that, under no assignment to the variables does the term evaluate to \u000A <v>nil</v>.</p> \u000A \u000A <p>We use the word ``term'' in ACL2 in three distinct senses.  We will speak \u000A of ``translated'' terms, ``untranslated'' terms, and ``pseudo-'' terms.</p> \u000A \u000A <p><i>Translated Terms: The Strict Sense and Internal Form</i></p> \u000A \u000A <p>In its most strict sense, a ``term'' is either a legal variable symbol, a \u000A quoted constant, or the application of an n-ary function symbol or closed \u000A <v>lambda</v> expression to a true list of n terms.</p> \u000A \u000A <p>The legal variable symbols are symbols other than <v>t</v> or <v>nil</v> which \u000A are not in the keyword package, do not start with ampersand, do not start and \u000A end with asterisks, and if in the main Lisp package, do not violate an \u000A appropriate restriction (see <see topic=\"ACL2____NAME\">name</see>).</p> \u000A \u000A <p>Quoted constants are expressions of the form <v>(<see topic=\"COMMON-LISP____QUOTE\">quote</see> x)</v>, where <v>x</v> \u000A is any ACL2 object.  Such expressions may also be written <v>'x</v>.</p> \u000A \u000A <p>Closed <v>lambda</v> expressions are expressions of the form <v>(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (v1\u000A ... vn) body)</v> where the <v>vi</v> are distinct legal variable symbols, \u000A <v>body</v> is a term, and the only free variables in <v>body</v> are among the \u000A <v>vi</v>.</p> \u000A \u000A <p>The function <v>termp</v>, which takes two arguments, an alleged term <v>x</v> \u000A and a logical world <v>w</v> (see <see topic=\"ACL2____WORLD\">world</see>), recognizes terms of a given \u000A extension of the logic.  <v>Termp</v> is defined in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode. \u000A Its definition may be inspected with <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt> <v>termp</v> for a \u000A complete specification of what we mean by ``term'' in the most strict sense. \u000A Most ACL2 term-processing functions deal with terms in this strict sense and \u000A use <v>termp</v> as a <see topic=\"ACL2____GUARD\">guard</see>.  That is, the ``internal form'' of a term \u000A satisfies <v>termp</v>, the strict sense of the word ``term.''</p> \u000A \u000A <p><i>Untranslated Terms: What the User Types</i></p> \u000A \u000A <p>While terms in the strict sense are easy to explore (because their \u000A structure is so regular and simple) they can be cumbersome to type.  Thus, \u000A ACL2 supports a more sugary syntax that includes uses of macros and constant \u000A symbols.  Very roughly speaking, macros are functions that produce terms as \u000A their results.  Constants are symbols that are associated with quoted objects. \u000A Terms in this sugary syntax are ``translated'' to terms in the strict sense; \u000A the sugary syntax is more often called ``untranslated.''  Roughly speaking, \u000A translation just implements macroexpansion, the replacement of constant \u000A symbols by their quoted values, and the checking of all the rules governing \u000A the strict sense of ``term.''</p> \u000A \u000A <p>More precisely, macro symbols are as described in the documentation for \u000A <tt><see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see></tt>.  A macro, <v>mac</v>, can be thought of as a function, \u000A <v>mac-fn</v>, from ACL2 objects to an ACL2 object to be treated as an \u000A untranslated term.  For example, <tt><see topic=\"COMMON-LISP____CAAR\">caar</see></tt> is defined as a macro symbol; \u000A the associated macro function maps the object <v>x</v> into the object <v>(<see topic=\"COMMON-LISP____CAR\">car</see>\u000A (<see topic=\"COMMON-LISP____CAR\">car</see> x))</v>.  A macro form is a ``call'' of a macro symbol, i.e., a list whose \u000A <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is the macro symbol and whose <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt> is an arbitrary true \u000A list of objects, used as a term.  Macroexpansion is the process of replacing \u000A in an untranslated term every occurrence of a macro form by the result of \u000A applying the macro function to the appropriate arguments.  The ``appropriate'' \u000A arguments are determined by the exact form of the definition of the macro; \u000A macros support positional, keyword, optional and other kinds of arguments. \u000A See <see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see>.</p> \u000A \u000A <p>In addition to macroexpansion and constant symbol dereferencing, \u000A translation implements the mapping of <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> and <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> forms into \u000A applications of <v>lambda</v> expressions and closes <v>lambda</v> expressions \u000A containing free variables.  Thus, the translation of</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((x (<see topic=\"COMMON-LISP____1_B2\">1+</see> i))) (<see topic=\"COMMON-LISP____CONS\">cons</see> x k))</code> \u000A \u000A <p>can be seen as a two-step process that first produces</p> \u000A \u000A <code>((<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (x) (<see topic=\"COMMON-LISP____CONS\">cons</see> x k)) (<see topic=\"COMMON-LISP____1_B2\">1+</see> i))</code> \u000A \u000A <p>and then</p> \u000A \u000A <code>((<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (x k) (<see topic=\"COMMON-LISP____CONS\">cons</see> x k)) (<see topic=\"COMMON-LISP____1_B2\">1+</see> i) k) .</code> \u000A \u000A <p>Observe that the body of the <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> and of the first <v>lambda</v> \u000A expression contains a free <v>k</v> which is finally bound and passed into the \u000A second <v>lambda</v> expression.</p> \u000A \u000A <p>Translation also maps <tt><see topic=\"COMMON-LISP____FLET\">flet</see></tt> forms into applications of <v>lambda</v> \u000A expressions.  See <see topic=\"COMMON-LISP____FLET\">flet</see>.</p> \u000A \u000A <p>When we say, of an event-level function such as <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> or <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>, that some argument ``must be a term'' we mean an untranslated term. \u000A The event functions translate their term-like arguments.</p> \u000A \u000A <p>To better understand the mapping between untranslated terms and translated \u000A terms it is convenient to use the keyword command <v>:</v><tt><see topic=\"ACL2____TRANS\">trans</see></tt> to see \u000A examples of translations.  See <see topic=\"ACL2____TRANS\">trans</see> and also see <see topic=\"ACL2____TRANS1\">trans1</see>.</p> \u000A \u000A <p>Finally, we note that the theorem prover prints terms in untranslated form. \u000A But there can be more than one correct untranslated term corresponding to a \u000A given translated term.  For example, the translated term <v>(<see topic=\"COMMON-LISP____IF\">if</see> x y 'nil)</v> \u000A can be untranslated as <v>(<see topic=\"COMMON-LISP____IF\">if</see> x y nil)</v> and can also be untranslated as \u000A <v>(<see topic=\"COMMON-LISP____AND\">and</see> x y)</v>.  The theorem prover attempts to print an untranslated term \u000A that is as helpful to the user as possible.  In particular, consider a term of \u000A the form <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> k st)</v> where <v>st</v> is a single-threaded object (see <see topic=\"ACL2____STOBJ\">stobj</see>) and the <v>kth</v> accessor of <v>st</v> is, say, <v>kn</v>.  The theorem \u000A prover typically would expand <v>(kn st)</v> to <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> k st)</v>.  If <v>k</v> is \u000A large then it could be difficult for the user to make sense out of a proof \u000A transcript that mentions the expanded term.  Fortunately, the untranslation of \u000A <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> k st)</v> would be <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> *kn* st)</v>; here <v>*kn*</v> would be a \u000A constant (see <see topic=\"ACL2____DEFCONST\">defconst</see>) added by the <tt><see topic=\"ACL2____DEFSTOBJ\">defstobj</see></tt> event introducing \u000A <v>st</v>, defined to have value <v>k</v>.  The user can extend this user-friendly \u000A style of printing applications of <tt><see topic=\"COMMON-LISP____NTH\">nth</see></tt> to stobjs; see <see topic=\"ACL2____ADD-NTH-ALIAS\">add-nth-alias</see>.  These remarks about printing applications of function <tt><see topic=\"COMMON-LISP____NTH\">nth</see></tt> extend naturally to function <tt><see topic=\"ACL2____UPDATE-NTH\">update-nth</see></tt>.  Moreover, the prover \u000A will attempt to treat terms as <see topic=\"ACL2____STOBJ\">stobj</see>s for the above purpose when \u000A appropriate.  For example, if function <v>foo</v> has <see topic=\"ACL2____SIGNATURE\">signature</see> <v>((foo\u000A * st) =&gt; (<see topic=\"ACL2____MV\">mv</see> * * * st))</v>, where <v>st</v> is introduced with <v>(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> st f0\u000A f1)</v>, then the <see topic=\"ACL2____TERM\">term</see> <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> '1 (<see topic=\"ACL2____MV-NTH\">mv-nth</see> '3 (foo x st0)))</v> will be \u000A printed as <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> *f1* (<see topic=\"ACL2____MV-NTH\">mv-nth</see> 3 (foo x st0)))</v>.</p> \u000A \u000A <p><i>Pseudo-Terms: A Common Guard for Metafunctions</i></p> \u000A \u000A <p>Because <v>termp</v> is defined in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode, it cannot be \u000A used effectively in conjectures to be proved.  Furthermore, from the \u000A perspective of merely guarding a term processing function, <v>termp</v> often \u000A checks more than is required.  Finally, because <v>termp</v> requires the \u000A logical <see topic=\"ACL2____WORLD\">world</see> as one of its arguments it is impossible to use \u000A <v>termp</v> as a <see topic=\"ACL2____GUARD\">guard</see> in places where the logical <see topic=\"ACL2____WORLD\">world</see> is not \u000A itself one of the arguments.</p> \u000A \u000A <p>For these reasons we support the idea of ``pseudo-terms.''  A pseudo-term \u000A is either a symbol (but not necessarily one having the syntax of a legal \u000A variable symbol), a true list beginning with <v>quote</v> (but not necessarily \u000A well-formed), or the ``application of'' a symbol or pseudo <v>lambda</v> \u000A expression to a true list of pseudo-terms.  A pseudo <v>lambda</v> expression is \u000A an expression of the form <v>(<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (v1 ... vn) body)</v> where the <v>vi</v> are \u000A all symbols and <v>body</v> is a pseudo-term.</p> \u000A \u000A <p>Pseudo-terms are recognized by the unary function <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt>.  If \u000A <v>(termp x w)</v> is true, then <v>(<see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see> x)</v> is true.  However, if \u000A <v>x</v> fails to be a (strict) term it may nevertheless still be a pseudo-term. \u000A For example, <v>(<see topic=\"COMMON-LISP____CAR\">car</see> a b)</v> is not a term, because <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is applied to \u000A the wrong number of arguments, but it is a pseudo-term.</p> \u000A \u000A <p>The structures recognized by <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> can be recursively \u000A explored with the same simplicity that terms can be.  In particular, if <v>x</v> \u000A is not a <v>variablep</v> or an <v>fquotep</v>, then <v>(ffn-symb x)</v> is the \u000A function (<v>symbol</v> or <v>lambda</v> expression) and <v>(fargs x)</v> is the \u000A list of argument pseudo-terms.  A metafunction (see <see topic=\"ACL2____META\">meta</see>) or \u000A clause-processor (see <see topic=\"ACL2____CLAUSE-PROCESSOR\">clause-processor</see>) may use <tt><see topic=\"ACL2____PSEUDO-TERMP\">pseudo-termp</see></tt> as \u000A the <see topic=\"ACL2____GUARD\">guard</see>.</p>"],

 "ACL2____DEFSTOBJ":[["Events","Stobj"],"ACL2 Sources","ACL2","<p>Note: Novices are advised to avoid <v>defstobj</v>, perhaps instead \u000A using community books <see topic=\"STD____DEFAGGREGATE\">std::defaggregate</see> or \u000A <v>books/data-structures/structures.lisp</v>.  At the least, consider using \u000A <v>(</v><tt><see topic=\"ACL2____SET-VERIFY-GUARDS-EAGERNESS\">set-verify-guards-eagerness</see></tt><v> 0)</v> to avoid <see topic=\"ACL2____GUARD\">guard</see> \u000A verification.  On the other hand, after you learn to use <v>defstobj</v>, see \u000A <see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see> for another way to introduce single-threaded objects.</p> \u000A \u000A <code>Example:\u000A(<see topic=\"ACL2____DEFCONST\">defconst</see> *mem-size* 10) ; for use of *mem-size* just below\u000A(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> st\u000A          (reg :type (array (unsigned-byte 31) (8))\u000A               :initially 0)\u000A          (p-c :type (unsigned-byte 31)\u000A               :initially 555)\u000A          halt                  ; = (halt :type t :initially nil)\u000A          (mem :type (array (unsigned-byte 31) (*mem-size*))\u000A               :initially 0 :resizable t))\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> name\u000A          (field1 :type type1 :initially val1 :resizable b1)\u000A          ...\u000A          (fieldk :type typek :initially valk :resizable bk)\u000A          :renaming alist\u000A          :doc doc-string\u000A          :inline flg\u000A          :congruent-to old-stobj-name\u000A          :non-memoizable nm-flg)</code> \u000A \u000A <p>where <v>name</v> is a new symbol, each <v>fieldi</v> is a symbol, each \u000A <v>typei</v> is either a type-indicator (a <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt> or <see topic=\"ACL2____STOBJ\">stobj</see> \u000A name) or of the form <v>(ARRAY type-indicator max)</v>, each <v>vali</v> is an \u000A object satisfying <v>typei</v>, and each <v>bi</v> is <v>t</v> or <v>nil</v>.  Each \u000A pair <v>:initially vali</v> and <v>:resizable bi</v> may be omitted; more on this \u000A below.  The <v>:renaming alist</v> argument is optional and allows the user to \u000A override the default function names introduced by this event.  The \u000A <v>doc-string</v> is also optional.  The <v>:inline flg</v> Boolean argument is \u000A also optional and declares to ACL2 that the generated access and update \u000A functions for the stobj should be implemented as macros under the hood (which \u000A has the effect of inlining the function calls).  The optional <v>:congruent-to\u000A old-stobj-name</v> argument specifies an existing stobj with exactly the same \u000A structure, and is discussed below.  The optional <v>:non-memoizable nm-flg</v> \u000A Boolean argument is ignored when <v>nm-flg</v> is <v>nil</v> and is uninteresting \u000A when using classic ACL2 rather than a (default) <see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> ACL2 \u000A executable; otherwise, it instructs ACL2 to lay down faster code for functions \u000A that return the new stobj but disallows memoization of any function that takes \u000A the new stobj as an argument.  We describe further restrictions on the \u000A <v>fieldi</v>, <v>typei</v>, <v>vali</v>, and on <v>alist</v> below.  We recommend \u000A that you read about single-threaded objects (stobjs) in ACL2 before \u000A proceeding; see <see topic=\"ACL2____STOBJ\">stobj</see>.</p> \u000A \u000A <p>The effect of this event is to introduce a new single-threaded object \u000A (i.e., a ``<see topic=\"ACL2____STOBJ\">stobj</see>''), named <v>name</v>, and the associated recognizers, \u000A creator, accessors, updaters, constants, and, for fields of <v>ARRAY</v> type, \u000A length and resize functions.</p> \u000A \u000A <p><i>The Single-Threaded Object Introduced</i></p> \u000A \u000A <p>The <v>defstobj</v> event effectively introduces a new global variable, named \u000A <v>name</v>, which has as its initial logical value a list of <v>k</v> elements, \u000A where <v>k</v> is the number of ``field descriptors'' provided.  The elements \u000A are listed in the same order in which the field descriptors appear.  If the \u000A <v>:type</v> of a field is <v>(ARRAY type-indicator (<see topic=\"COMMON-LISP____MAX\">max</see>))</v> then <v>max</v> is a \u000A non-negative integer or a symbol introduced by <tt><see topic=\"ACL2____DEFCONST\">defconst</see></tt>) whose value \u000A is a non-negative integer, and the corresponding element of the stobj is \u000A initially of length specified by <v>max</v>.</p> \u000A \u000A <p>Whether the value <v>:type</v> is of the form <v>(ARRAY type-indicator\u000A (<see topic=\"COMMON-LISP____MAX\">max</see>))</v> or, otherwise, just <v>type-indicator</v>, then <v>type-indicator</v> is \u000A typically a type-spec; see <see topic=\"ACL2____TYPE-SPEC\">type-spec</see>.  However, <v>type-indicator</v> can \u000A also be the name of a stobj that was previously introduced (by <v>defstobj</v> \u000A or <tt><see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see></tt>).  We ignore this ``nested stobj'' case below; see \u000A <see topic=\"ACL2____NESTED-STOBJS\">nested-stobjs</see> for a discussion of stobjs within stobjs.</p> \u000A \u000A <p>The keyword value <v>:initially val</v> specifies the initial value of a \u000A field, except for the case of a <v>:type</v> <v>(ARRAY type-indicator (<see topic=\"COMMON-LISP____MAX\">max</see>))</v>, \u000A in which case <v>val</v> is the initial value of the corresponding array.</p> \u000A \u000A <p>Note that the actual representation of the stobj in the underlying Lisp may \u000A be quite different; see <see topic=\"ACL2____STOBJ-EXAMPLE-2\">stobj-example-2</see>.  For the moment we focus \u000A entirely on the logical aspects of the object.</p> \u000A \u000A <p>In addition, the <v>defstobj</v> event introduces functions for recognizing \u000A and creating the stobj and for recognizing, accessing, and updating its \u000A fields.  For fields of <v>ARRAY</v> type, length and resize functions are also \u000A introduced.  Constants are introduced that correspond to the accessor \u000A functions.</p> \u000A \u000A <p><i>Restrictions on the Field Descriptions in Defstobj</i></p> \u000A \u000A <p>Each field descriptor is of the form:</p> \u000A \u000A <code>(fieldi :TYPE typei :INITIALLY vali)</code> \u000A \u000A <p>Note that the type and initial value are given in ``keyword argument'' \u000A format and may be given in either order.  The <v>typei</v> and <v>vali</v> \u000A ``arguments'' are not evaluated.  If omitted, the type defaults to <v>t</v> \u000A (unrestricted) and the initial value defaults to <v>nil</v>.</p> \u000A \u000A <p>Each <v>typei</v> must be either a <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt> or else a list of the \u000A form <v>(ARRAY type-spec (<see topic=\"COMMON-LISP____MAX\">max</see>))</v>.  (Again, we are ignoring the case of nested \u000A stobjs, discussed elsewhere; see <see topic=\"ACL2____NESTED-STOBJS\">nested-stobjs</see>.)  The latter forms are \u000A said to be ``array types.''  Examples of legal <v>typei</v> are:</p> \u000A \u000A <code>(INTEGER 0 31)\u000A(SIGNED-BYTE 31)\u000A(ARRAY (SIGNED-BYTE 31) (16))\u000A(ARRAY (SIGNED-BYTE 31) (*c*)) ; where *c* has a non-negative integer value</code> \u000A \u000A <p>The <v>typei</v> describes the objects which are expected to occupy the given \u000A field.  Those objects in <v>fieldi</v> should satisfy <v>typei</v>.  We are more \u000A precise below about what we mean by ``expected.''  We first present the \u000A restrictions on <v>typei</v> and <v>vali</v>.</p> \u000A \u000A <p>Non-Array Types</p> \u000A \u000A <p>When <v>typei</v> is a <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt> it restricts the contents, <v>x</v>, \u000A of <v>fieldi</v> according to the ``meaning'' formula given in the table for \u000A <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt>.  For example, the first <v>typei</v> above restricts the \u000A field to be an integer between 0 and 31, inclusive.  The second restricts the \u000A field to be an integer between -2^30 and (2^30)-1, inclusive.</p> \u000A \u000A <p>The initial value, <v>vali</v>, of a field description may be any ACL2 object \u000A but must satisfy <v>typei</v>.  Note that <v>vali</v> is not a form to be \u000A evaluated but an object.  A form that evaluates to <v>vali</v> could be written \u000A <v>'vali</v>, but <v>defstobj</v> does not expect you to write the quote mark. \u000A For example, the field description</p> \u000A \u000A <code>(days-off :initially (saturday sunday))</code> \u000A \u000A <p>describes a field named <v>days-off</v> whose initial value is the list \u000A consisting of the two symbols <v>SATURDAY</v> and <v>SUNDAY</v>.  In particular, \u000A the initial value is NOT obtained by applying the function <v>saturday</v> to \u000A the variable <v>sunday</v>!  Had we written</p> \u000A \u000A <code>(days-off :initially '(saturday sunday))</code> \u000A \u000A <p>it would be equivalent to writing</p> \u000A \u000A <code>(days-off :initially (<see topic=\"COMMON-LISP____QUOTE\">quote</see> (saturday sunday)))</code> \u000A \u000A <p>which would initialize the field to a list of length two, whose first \u000A element is the symbol <v>quote</v> and whose second element is a list containing \u000A the symbols <v>saturday</v> and <v>sunday</v>.</p> \u000A \u000A <p>Array Types</p> \u000A \u000A <p>When <v>typei</v> is of the form <v>(ARRAY type-spec (<see topic=\"COMMON-LISP____MAX\">max</see>))</v>, the field is \u000A supposed to be a list of items, initially of length specified by <v>max</v>, \u000A each of which satisfies the indicated <v>type-spec</v>.  <v>Max</v> must be a \u000A non-negative integer or a defined constant evaluating to a non-negative \u000A integer. Thus, each of</p> \u000A \u000A <code>(ARRAY (SIGNED-BYTE 31) (16))\u000A(ARRAY (SIGNED-BYTE 31) (*c*)) ; given previous event (<see topic=\"ACL2____DEFCONST\">defconst</see> *c* 16)</code> \u000A \u000A <p>restricts the field to be a list of integers, initially of length 16, where \u000A each integer in the list is a <v>(SIGNED-BYTE 31)</v>.  We sometimes call such a \u000A list an ``array'' (because it is represented as an array in the underlying \u000A Common Lisp).  The elements of an array field are indexed by position, \u000A starting at 0.  Thus, the maximum legal index of an array field one less than \u000A is specified by <v>max</v>.  Note that the value of <v>max</v> must be less than \u000A the Common Lisp constant <v>array-dimension-limit</v>, and also (though this \u000A presumably follows) less than the Common Lisp constant \u000A <v>array-total-size-limit</v>.</p> \u000A \u000A <p>Note also that the <v>ARRAY</v> type requires that the <v>max</v> be enclosed \u000A in parentheses.  This makes ACL2's notation consistent with the Common Lisp \u000A convention of describing the (multi-)dimensionality of arrays.  But ACL2 \u000A currently supports only single dimensional arrays in stobjs.</p> \u000A \u000A <p>For array fields, the initial value <v>vali</v> must be an object satisfying \u000A the <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt> of the <v>ARRAY</v> description.  The initial value of the \u000A field is a list of <v>max</v> repetitions of <v>vali</v>.</p> \u000A \u000A <p>Array fields can be ``resized,'' that is, their lengths can be changed, if \u000A <v>:resizable t</v> is supplied as shown in the example and General Form above. \u000A The new length must satisfy the same restriction as does <v>max</v>, as \u000A described above.  Each array field in a <v>defstobj</v> event gives rise to a \u000A length function, which gives the length of the field, and a resize function, \u000A which modifies the length of the field if <v>:resizable t</v> was supplied with \u000A the field when the <v>defstobj</v> was introduced and otherwise causes an error. \u000A If <v>:resizable t</v> was supplied and the resize function specifies a new \u000A length <v>k</v>, then: if <v>k</v> is less than the existing array length, the \u000A array is shortened simply by dropping elements with index at least <v>k</v>; \u000A otherwise, the array is extended to length <v>k</v> by mapping the new indices \u000A to the initial value (supplied by <v>:initially</v>, else default <v>nil</v>).</p> \u000A \u000A <p>Array resizing is relatively slow, so we recommend using it somewhat \u000A sparingly.</p> \u000A \u000A <p><i>The Default Function Names</i></p> \u000A \u000A <p>To recap, in</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> name\u000A          (field1 :type type1 :initially val1)\u000A          ...\u000A          (fieldk :type typek :initially valk)\u000A          :renaming alist\u000A          :doc doc-string\u000A          :inline inline-flag)</code> \u000A \u000A <p><v>name</v> must be a new symbol, each <v>fieldi</v> must be a symbol, each \u000A <v>typei</v> must be a <tt><see topic=\"ACL2____TYPE-SPEC\">type-spec</see></tt> or <v>(ARRAY type-spec (<see topic=\"COMMON-LISP____MAX\">max</see>))</v>, and \u000A each <v>vali</v> must be an object satisfying <v>typei</v>.</p> \u000A \u000A <p>Roughly speaking, for each <v>fieldi</v>, a <v>defstobj</v> introduces a \u000A recognizer function, an accessor function, and an updater function.  The \u000A accessor function, for example, takes the stobj and returns the indicated \u000A component; the updater takes a new component value and the stobj and return a \u000A new stobj with the component replaced by the new value.  But that summary is \u000A inaccurate for array fields.</p> \u000A \u000A <p>The accessor function for an array field does not take the stobj and return \u000A the indicated component array, which is a list of length specified by \u000A <v>max</v>.  Instead, it takes an additional index argument and returns the \u000A indicated element of the array component.  Similarly, the updater function for \u000A an array field takes an index, a new value, and the stobj, and returns a new \u000A stobj with the indicated element replaced by the new value.</p> \u000A \u000A <p>These functions &mdash; the recognizer, accessor, and updater, and also \u000A length and resize functions in the case of array fields &mdash; have ``default \u000A names.''  The default names depend on the field name, <v>fieldi</v>, and on \u000A whether the field is an array field or not.  For clarity, suppose <v>fieldi</v> \u000A is named <v>c</v>. The default names are shown below in calls, which also \u000A indicate the arities of the functions.  In the expressions, we use <v>x</v> as \u000A the object to be recognized by field recognizers, <v>i</v> as an array index, \u000A <v>v</v> as the ``new value'' to be installed by an updater, and <v>name</v> as \u000A the single-threaded object.</p> \u000A \u000A <code>                 non-array field        array field\u000Arecognizer         (cP x)                (cP x)\u000Aaccessor           (c name)              (cI i name)\u000Aupdater            (UPDATE-c v name)     (UPDATE-cI i v name)\u000Alength                                   (c-LENGTH name)\u000Aresize                                   (RESIZE-c k name)</code> \u000A \u000A <p>Finally, a recognizer and a creator for the entire single-threaded object \u000A are introduced.  The creator returns the initial stobj, but may only be used \u000A in limited contexts; see <see topic=\"ACL2____WITH-LOCAL-STOBJ\">with-local-stobj</see>.  If the single-threaded \u000A object is named <v>name</v>, then the default names and arities are as shown \u000A below.</p> \u000A \u000A <code>top recognizer     (nameP x)\u000Acreator            (CREATE-name)</code> \u000A \u000A <p>For example, the event</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTOBJ\">DEFSTOBJ</see> $S\u000A  (X :TYPE INTEGER :INITIALLY 0)\u000A  (A :TYPE (ARRAY (INTEGER 0 9) (3)) :INITIALLY 9))</code> \u000A \u000A <p>introduces a stobj named <v>$S</v>.  The stobj has two fields, <v>X</v> and \u000A <v>A</v>.  The <v>A</v> field is an array.  The <v>X</v> field contains an integer \u000A and is initially 0.  The <v>A</v> field contains a list of integers, each \u000A between 0 and 9, inclusively.  Initially, each of the three elements of the \u000A <v>A</v> field is 9.</p> \u000A \u000A <p>This event introduces the following sequence of definitions:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> XP (X) ...)               ; recognizer for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> AP (X) ...)               ; recognizer of A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> $SP ($S) ...)             ; top-level recognizer for stobj $S\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> CREATE-$S () ...)         ; creator for stobj $S\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> X ($S) ...)               ; accessor for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> UPDATE-X (V $S) ...)      ; updater for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> A-LENGTH ($S) ...)        ; length of A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> RESIZE-A (K $S) ...)      ; resizer for A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> AI (I $S) ...)            ; accessor for A field at index I\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> UPDATE-AI (I V $S) ...)   ; updater for A field at index I</code> \u000A \u000A <p><i>Avoiding the Default Function Names</i></p> \u000A \u000A <p>If you do not like the default names listed above you may use the optional \u000A <v>:renaming</v> alist to substitute names of your own choosing.  Each element \u000A of <v>alist</v> should be of the form <v>(fn1 fn2)</v>, where <v>fn1</v> is a \u000A default name and <v>fn2</v> is your choice for that name.</p> \u000A \u000A <p>For example</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTOBJ\">DEFSTOBJ</see> $S\u000A  (X :TYPE INTEGER :INITIALLY 0)\u000A  (A :TYPE (ARRAY (INTEGER 0 9) (3)) :INITIALLY 9)\u000A  :renaming ((X XACCESSOR) (CREATE-$S MAKE$S)))</code> \u000A \u000A <p>introduces the following definitions</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> XP (X) ...)               ; recognizer for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> AP (X) ...)               ; recognizer of A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> $SP ($S) ...)             ; top-level recognizer for stobj $S\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> MAKE$S () ...)            ; creator for stobj $S\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> XACCESSOR ($S) ...)       ; accessor for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> UPDATE-X (V $S) ...)      ; updater for X field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> A-LENGTH ($S) ...)        ; length of A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> RESIZE-A (K $S) ...)      ; resizer for A field\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> AI (I $S) ...)            ; accessor for A field at index I\u000A(<see topic=\"COMMON-LISP____DEFUN\">DEFUN</see> UPDATE-AI (I V $S) ...)   ; updater for A field at index I</code> \u000A \u000A <p>Note that even though the renaming alist substitutes ``<v>XACCESSOR</v>'' for \u000A ``<v>X</v>'' the updater for the <v>X</v> field is still called ``<v>UPDATE-X</v>.'' \u000A That is because the renaming is applied to the default function names, not to \u000A the field descriptors in the event.</p> \u000A \u000A <p>Use of the <v>:renaming</v> alist may be necessary to avoid name clashes \u000A between the default names and and pre-existing function symbols.</p> \u000A \u000A <p><i>Constants</i></p> \u000A \u000A <p><v>Defstobj</v> events also introduce constant definitions (see <see topic=\"ACL2____DEFCONST\">defconst</see>).  One constant is introduced for each accessor function by \u000A prefixing and suffixing a `<v>*</v>' character on the function name.  The value \u000A of that constant is the position of the field being accessed.  For example, if \u000A the accessor functions are <v>a</v>, <v>b</v>, and <v>c</v>, in that order, then the \u000A following constant definitions are introduced.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFCONST\">defconst</see> *a* 0)\u000A(<see topic=\"ACL2____DEFCONST\">defconst</see> *b* 1)\u000A(<see topic=\"ACL2____DEFCONST\">defconst</see> *c* 2)</code> \u000A \u000A <p>These constants are used for certain calls of <tt><see topic=\"COMMON-LISP____NTH\">nth</see></tt> and <tt><see topic=\"ACL2____UPDATE-NTH\">update-nth</see></tt> that are displayed to the user in proof output.  For example, for \u000A stobj <v>st</v> with accessor functions <v>a</v>, <v>b</v>, and <v>c</v>, in that \u000A order, the term <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> '2 st)</v> would be printed during a proof as <v>(<see topic=\"COMMON-LISP____NTH\">nth</see>\u000A *c* st)</v>.  Also see <see topic=\"ACL2____TERM\">term</see>, in particular the discussion there of \u000A untranslated terms, and see <see topic=\"ACL2____NTH-ALIASES-TABLE\">nth-aliases-table</see>.</p> \u000A \u000A <p><i>Inspecting the Effects of a Defstobj</i></p> \u000A \u000A <p>Because the stobj functions are introduced as ``sub-events'' of the \u000A <v>defstobj</v> the history commands <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt> and <v>:</v><tt><see topic=\"ACL2____PC\">pc</see></tt> will \u000A not print the definitions of these functions but will print the superior \u000A <v>defstobj</v> event.  To see the definitions of these functions use the \u000A history command <v>:</v><tt><see topic=\"ACL2____PCB_12\">pcb!</see></tt>.</p> \u000A \u000A <p>To see an s-expression containing the definitions what constitute the raw \u000A Lisp implementation of the event, evaluate the form</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____NTH\">nth</see> 4 (global-val 'cltl-command (w state)))</code> \u000A \u000A <p><i>immediately after</i> the <v>defstobj</v> event has been processed.</p> \u000A \u000A <p>A <v>defstobj</v> is considered redundant only if the name, field \u000A descriptors, renaming alist, and inline flag are identical to a previously \u000A executed <v>defstobj</v>.  Note that a redundant <v>defstobj</v> does not reset \u000A the <see topic=\"ACL2____STOBJ\">stobj</see> fields to their initial values.</p> \u000A \u000A <p><i>Inlining and Performance</i></p> \u000A \u000A <p>The <v>:inline</v> keyword argument controls whether or not accessor, \u000A updater, and length functions are inlined (as macros under the hood, in raw \u000A Lisp).  If <v>:inline t</v> is provided then these are inlined; otherwise they \u000A are not.  The advantage of inlining is potentially better performance; there \u000A have been contrived examples, doing essentially nothing except accessing and \u000A updating array fields, where inlining reduced the time by a factor of 10 or \u000A more; and inlining has sped up realistic examples by a factor of at least 2. \u000A Inlining may get within a factor of 2 of C execution times for such contrived \u000A examples, and within a few percent of C execution times on realistic \u000A examples.</p> \u000A \u000A <p>A drawback to inlining is that redefinition may not work as expected, much \u000A as redefinition may not work as expected for macros: defined functions that \u000A call a macro, or inlined stobj function, will not see a subsequent \u000A redefinition of the macro or inlined function.  Another drawback to inlining \u000A is that because inlined functions are implemented as macros in raw Lisp, \u000A tracing (see <see topic=\"ACL2____TRACE_42\">trace$</see>) will not show their calls.  These drawbacks are \u000A avoided by default, but the user who is not concerned about them is advised to \u000A specify <v>:inline t</v>.</p> \u000A \u000A <p><i>Specifying Congruent Stobjs</i></p> \u000A \u000A <p>Two stobjs are may be considered to be ``congruent'' if they have the same \u000A structure, that is, their <v>defstobj</v> events are identical when ignoring \u000A field names.  In particular, every stobj is congruent to itself.  In order to \u000A tell ACL2 that a new stobj <v>st2</v> is indeed to be considered as congruent to \u000A an existing stobj <v>st1</v>, the <v>defstobj</v> event introducing <v>st2</v> is \u000A given the keyword argument <v>:congruent-to st1</v>.  Congruence is an \u000A equivalence relation: when you specify a new stobj to be congruent to an old \u000A one, you are also specifying that the new stobj is congruent to all other \u000A stobjs that are congruent to the old one.  Thus, continuing the example above, \u000A if you specify that <v>st3</v> is <v>:congruent-to st2</v>, then <v>st1</v>, \u000A <v>st2</v>, and <v>st3</v> will all be congruent to each other.</p> \u000A \u000A <p>When two stobjs are congruent, ACL2 allows you to substitute one for \u000A another in a function call.  Any number of stobjs may be replaced with \u000A congruent stobjs in the call, provided no two get replaced with the same \u000A stobj.  The return values are correspondingly modified: if stobj <v>st1</v> is \u000A replaced by <v>st2</v> at an argument position, and if <v>st1</v> is returned in \u000A the output <see topic=\"ACL2____SIGNATURE\">signature</see> of the function, then <v>st2</v> is returned in \u000A place of <v>st1</v>.</p> \u000A \u000A <p>The following example illustrates congruent stobjs.  For more examples of \u000A how to take advantage of congruent stobjs, and also of how to misuse them, see \u000A community book <v>books/misc/congruent-stobjs-test.lisp</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> st1 fld1)\u000A(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> st2 fld2 :congruent-to st1)\u000A(<see topic=\"ACL2____DEFSTOBJ\">defstobj</see> st3 fld3 :congruent-to st2) ; equivalently, :congruent-to st1\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (st1 st2 st3)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :stobjs (st1 st2 st3)))\u000A  (<see topic=\"COMMON-LISP____LIST\">list</see> (fld2 st1) (fld3 st2) (fld1 st3)))\u000A(update-fld1 1 st1)\u000A(update-fld1 2 st2) ; notice use of update-fld1 on st2\u000A(update-fld1 3 st3) ; notice use of update-fld1 on st3\u000A(<see topic=\"ACL2____ASSERT-EVENT\">assert-event</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f st3 st2 st1) '(3 2 1)))</code> \u000A \u000A <p>The following example shows an error that occurs when stobj arguments are \u000A repeated, i.e., at least two stobj arguments (in this case, three) get \u000A replaced by the same stobj.</p> \u000A \u000A <code>ACL2 !&gt;(f st1 st1 st1)\u000A\u000AACL2 Error in TOP-LEVEL:  The form ST1 is being used, as an argument\u000Ato a call of F, where the single-threaded object ST2 was expected,\u000Aeven though these are congruent stobjs.  See :DOC defstobj, in particular\u000Athe discussion of congruent stobjs.  Note:  this error occurred in\u000Athe context (F ST1 ST1 ST1).\u000A\u000AACL2 !&gt;</code>"],

 "ACL2____VERIFY-GUARDS":[["Events","Guard"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____GUARD\">guard</see> for a general discussion of guards.</p> \u000A \u000A <p>Before discussing the <v>verify-guards</v> event, we first discuss guard \u000A verification, which can take place at definition time or, later, using \u000A <v>verify-guards</v>.  Typically, guard verification takes place at definition \u000A time if a guard (or type, or <see topic=\"ACL2____STOBJS\">stobjs</see>) has been supplied explicitly \u000A unless <v>:verify-guards nil</v> has been specified; see <see topic=\"COMMON-LISP____DEFUN\">defun</see> and see \u000A <see topic=\"ACL2____XARGS\">xargs</see>, and see <see topic=\"ACL2____SET-VERIFY-GUARDS-EAGERNESS\">set-verify-guards-eagerness</see> for how to change \u000A this default.  The point of guard verification is to ensure that during \u000A evaluation of an expression without free variables, no guard violation takes \u000A place.</p> \u000A \u000A <p>Technical note: the first argument of <v>verify-guards</v> must be a function \u000A symbol or the name of a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> or <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> event, not a \u000A macro-alias for a function symbol (see <see topic=\"ACL2____MACRO-ALIASES-TABLE\">macro-aliases-table</see>).  See <see topic=\"ACL2____VERIFY-GUARDS_B2\">verify-guards+</see> for a utility that does not have this restriction.</p> \u000A \u000A <p>Guard verification is intended to guarantee that for any call of a given \u000A function, if its <see topic=\"ACL2____GUARD\">guard</see> holds for that call then the <see topic=\"ACL2____GUARD\">guard</see> will \u000A hold for every function call in the body of that function.  Moreover, in order \u000A to avoid guard violations during evaluation of the function's guard itself, \u000A guard verification also is intended to guarantee that the guards are satisfied \u000A for all calls in the guard itself.  Consider the following simple example.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A                              (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)))))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A      (<see topic=\"COMMON-LISP_____B2\">+</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A    17))</code> \u000A \u000A <p>If you evaluate <v>(f t)</v>, for example, in the top-level loop, you will \u000A (by default) get a guard error.  The point of guard verification is to \u000A guarantee the absence of guard errors, and we start by using this example to \u000A illustrate the proof obligations that guarantee such absence.</p> \u000A \u000A <p>The body of the above definition has the following function calls, where \u000A the first is the entire body.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A    (<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A  17)\u000A(<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) ; the test of the top-level IF call\u000A(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)             ; from (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A(<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) ; the true branch of the top-level IF call\u000A(<see topic=\"COMMON-LISP____CAR\">car</see> x)             ; from (<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)             ; from (<see topic=\"COMMON-LISP_____C3\">&lt;</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))</code> \u000A \u000A <p>We thus see potentially six conditions to prove, one for each call.  The \u000A guards of the function symbols of those calls are <v>t</v> for <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> and \u000A <tt><see topic=\"COMMON-LISP____RATIONALP\">rationalp</see></tt>, <v>(<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x nil))</v> for both <v>(<see topic=\"COMMON-LISP____CAR\">car</see> x)</v> and \u000A <v>(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)</v>, and finally that both arguments are rationals for <v>&lt;</v>. \u000A Moreover, we can take advantage of ``contextual assumptions'': the \u000A <v>if</v>-test conditions and the top-level <v>:guard</v>.  Thus, for \u000A <v>verify-guards</v> the proof obligation from the body of <v>f</v> is as \u000A follows.</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see>\u000A (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x))) ; from the :guard\u000A (<see topic=\"COMMON-LISP____AND\">and</see> t ; from the top-level IF call\u000A      t ; from (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A      (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x nil)) ; from the first (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)\u000A      (<see topic=\"ACL2____IMPLIES\">implies</see>\u000A       (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) ; IF-test for calls in the true branch\u000A       (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x nil)) ; from (<see topic=\"COMMON-LISP____CAR\">car</see> x)\u000A            (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x nil)) ; from the second (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)\u000A            (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)) (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))) ; from the &lt; call\u000A            ))))</code> \u000A \u000A <p>But the <v>:guard</v> itself generates a similar sort of proof obligation. \u000A Note that the guard <v>(<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)))</v> is really an \u000A abbreviation (i.e. via the macro <tt><see topic=\"COMMON-LISP____AND\">and</see></tt>) for the term <v>(<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)) nil)</v>.  The guard proof obligation for the guard itself is \u000A thus as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____AND\">and</see> t ; from (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A              (<see topic=\"COMMON-LISP____AND\">and</see> t         ; from (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)) ;\u000A                   (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) ; from (<see topic=\"COMMON-LISP____CAR\">car</see> x) ;\u000A                   )))</code> \u000A \u000A <p>All of the above proof obligations are indeed theorems, and guard \u000A verification succeeds for the above definition of <v>f</v>.</p> \u000A \u000A <p>The example above illustrates the general procedure for generating the \u000A guard proof obligation.  Each function call is considered in the body or guard \u000A of the function, and it is required that the guard is met for that call, under \u000A certain ``contextual assumptions'', which are as follows.  In the case of the \u000A body of the named function, it is assumed that the guard holds for that \u000A function on its formal parameters.  And in both cases &mdash; the body of the \u000A named function and also its guard &mdash; the governing tests from superior \u000A calls of <tt><see topic=\"COMMON-LISP____IF\">if</see></tt> are also assumed.</p> \u000A \u000A <p>As mentioned above, if the guard on a function is not <v>t</v>, then guard \u000A verification requires not only consideration of the body under the assumption \u000A that the guard is true, but also consideration of the guard itself.  Thus, for \u000A example, guard verification fails in the following example, even though there \u000A are no proof obligations arising from the body, because the guard itself can \u000A cause a guard violation when evaluated for an arbitrary value of <v>x</v>:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____CAR\">car</see> x)))\u000A  x)</code> \u000A \u000A <p>We turn now to the <v>verify-guards</v> event as a way of verifying the <see topic=\"ACL2____GUARD\">guard</see>s for a function or theorem.</p> \u000A \u000A <code>Examples:\u000A(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> flatten)\u000A(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> flatten\u000A               :hints ((&quot;Goal&quot; :use (:instance assoc-of-app)))\u000A               :otf-flg t\u000A               :guard-debug t ; default = nil\u000A               :doc &quot;string&quot;)\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> name\u000A        :hints        hints\u000A        :otf-flg      otf-flg\u000A        :guard-debug  t ; typically t, but any value is legal\u000A        :doc          doc-string)</code> \u000A \u000A <p>In the General Form above, <v>name</v> is the name of a <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> \u000A function (see <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>) or of a theorem or axiom.  In the most common \u000A case <v>name</v> is the name of a function that has not yet had its <see topic=\"ACL2____GUARD\">guard</see>s verified, each subroutine of which has had its <see topic=\"ACL2____GUARD\">guard</see>s verified. \u000A The values <tt><see topic=\"ACL2____HINTS\">hints</see></tt>, <tt><see topic=\"ACL2____OTF-FLG\">otf-flg</see></tt>, and <tt><see topic=\"ACL2____GUARD-DEBUG\">guard-debug</see></tt> are as \u000A described in the corresponding <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> entries; and \u000A <v>doc-string</v>, if non-<v>nil</v>, is an optional string that can provide \u000A documentation but is essentially ignored by ACL2.  The four keyword arguments \u000A above are all optional.  To admit this event, the conjunction of the guard \u000A proof obligations must be proved.  If that proof is successful, <v>name</v> is \u000A considered to have had its <see topic=\"ACL2____GUARD\">guard</see>s verified.</p> \u000A \u000A <p>See <see topic=\"ACL2____VERIFY-GUARDS-FORMULA\">verify-guards-formula</see> for a utility that lets you view the \u000A formula to be proved by <v>verify-guards</v>, but without creating an event.</p> \u000A \u000A <p>If <v>name</v> is one of several functions in a mutually recursive clique, \u000A <v>verify-guards</v> will attempt to verify the <see topic=\"ACL2____GUARD\">guard</see>s of all of the \u000A functions.</p> \u000A \u000A <p>If <v>name</v> is a theorem or axiom name, <v>verify-guards</v> verifies the \u000A guards of the associated formula.  When a theorem has had its guards verified \u000A then you know that the theorem will evaluate to non-<v>nil</v> in all Common \u000A Lisps, without causing a runtime error (other than possibly a resource error). \u000A In particular, you know that the theorem's validity does not depend upon \u000A ACL2's arbitrary completion of the domains of partial Common Lisp \u000A functions.</p> \u000A \u000A <p>For example, if <v>app</v> is defined as</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> app (x y)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____ENDP\">endp</see> x)\u000A      y\u000A      (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (app (<see topic=\"COMMON-LISP____CDR\">cdr</see> x) y))))</code> \u000A \u000A <p>then we can verify the guards of <v>app</v> and we can prove the theorem:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> assoc-of-app\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app a b) c) (app a (app b c))))</code> \u000A \u000A <p>However, if you go into almost any Common Lisp in which <v>app</v> is defined \u000A as shown and evaluate</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app 1 2) 3) (app 1 (app 2 3)))</code> \u000A \u000A <p>we get an error or, perhaps, something worse like <v>nil</v>!  How can this \u000A happen since the formula is an instance of a theorem?  It is supposed to be \u000A true!</p> \u000A \u000A <p>It happens because the theorem exploits the fact that ACL2 has completed \u000A the domains of the partially defined Common Lisp functions like <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> \u000A and <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt>, defining them to be <v>nil</v> on all non-conses.  The formula \u000A above violates the guards on <v>app</v>.  It is therefore ``unreasonable'' to \u000A expect it to be valid in Common Lisp.</p> \u000A \u000A <p>But the following formula is valid in Common Lisp:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> a)\u000A         (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> b))\u000A    (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app a b) c) (app a (app b c)))\u000A    t)</code> \u000A \u000A <p>That is, no matter what the values of <v>a</v>, <v>b</v> and <v>c</v> the formula \u000A above evaluates to <v>t</v> in all Common Lisps (unless the Lisp engine runs out \u000A of memory or stack computing it).  Furthermore the above formula is a \u000A theorem:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> guarded-assoc-of-app\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> a)\u000A           (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> b))\u000A      (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app a b) c) (app a (app b c)))\u000A      t))</code> \u000A \u000A <p>This formula, <v>guarded-assoc-of-app</v>, is very easy to prove from \u000A <v>assoc-of-app</v>.  So why prove it?  The interesting thing about \u000A <v>guarded-assoc-of-app</v> is that we can verify the guards of the formula. \u000A That is, <v>(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> guarded-assoc-of-app)</v> succeeds.  Note that it has \u000A to prove that if <v>a</v> and <v>b</v> are true lists then so is <v>(app a b)</v> to \u000A establish that the guard on the outermost <v>app</v> on the left is satisfied. \u000A By verifying the guards of the theorem we know it will evaluate to true in all \u000A Common Lisps.  Put another way, we know that the validity of the formula does \u000A not depend on ACL2's completion of the partial functions or that the formula \u000A is ``well-typed.''</p> \u000A \u000A <p>One last complication: The careful reader might have thought we could state \u000A <v>guarded-assoc-of-app</v> as</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> a)\u000A              (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> b))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app a b) c)\u000A                (app a (app b c))))</code> \u000A \u000A <p>rather than using the <v>if</v> form of the theorem.  We cannot!  The reason \u000A is technical: <tt><see topic=\"ACL2____IMPLIES\">implies</see></tt> is defined as a function in ACL2.  When it is \u000A called, both arguments are evaluated and then the obvious truth table is \u000A checked.  That is, <v>implies</v> is not ``lazy.''  Hence, when we write the \u000A guarded theorem in the <v>implies</v> form we have to prove the guards on the \u000A conclusion without knowing that the hypothesis is true.  It would have been \u000A better had we defined <v>implies</v> as a macro that expanded to the <v>if</v> \u000A form, making it lazy.  But we did not and after we introduced guards we did \u000A not want to make such a basic change.</p> \u000A \u000A <p>Recall however that <v>verify-guards</v> is almost always used to verify the \u000A guards on a function definition rather than a theorem.  We now return to that \u000A discussion.</p> \u000A \u000A <p><v>Verify-guards</v> must often be used when the value of a recursive call of \u000A a defined function is given as an argument to a subroutine that is <see topic=\"ACL2____GUARD\">guard</see>ed.  An example of such a situation is given below.  Suppose <v>app</v> \u000A (read ``append'') has a <see topic=\"ACL2____GUARD\">guard</see> requiring its first argument to be a \u000A <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>.  Consider</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> rev (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)))\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ENDP\">endp</see> x) nil)\u000A        (t (app (rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x))))))</code> \u000A \u000A <p>Observe that the value of a recursive call of <v>rev</v> is being passed into \u000A a <see topic=\"ACL2____GUARD\">guard</see>ed subroutine, <v>app</v>.  In order to verify the <see topic=\"ACL2____GUARD\">guard</see>s \u000A of this definition we must show that <v>(rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))</v> produces a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>, since that is what the <see topic=\"ACL2____GUARD\">guard</see> of <v>app</v> requires.  How do \u000A we know that <v>(rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))</v> is a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>?  The most elegant \u000A argument is a two-step one, appealing to the following two lemmas: (1) When \u000A <v>x</v> is a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>, <v>(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)</v> is a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>.  (2) \u000A When <v>z</v> is a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>, <v>(rev z)</v> is a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>. \u000A But the second lemma is a generalized property of <v>rev</v>, the function we \u000A are defining.  This property could not be stated before <v>rev</v> is defined \u000A and so is not known to the theorem prover when <v>rev</v> is defined.</p> \u000A \u000A <p>Therefore, we might break the admission of <v>rev</v> into three steps: \u000A define <v>rev</v> without addressing its <see topic=\"ACL2____GUARD\">guard</see> verification, prove some \u000A general properties about <v>rev</v>, and then verify the <see topic=\"ACL2____GUARD\">guard</see>s.  This \u000A can be done as follows:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> rev (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)\u000A                  :verify-guards nil))    ; Note this additional xarg.\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ENDP\">endp</see> x) nil)\u000A        (t (app (rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x))))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> true-listp-rev\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x2)\u000A           (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> (rev x2))))\u000A\u000A(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> rev)</code> \u000A \u000A <p>The ACL2 system can actually admit the original definition of <v>rev</v>, \u000A verifying the <see topic=\"ACL2____GUARD\">guard</see>s as part of the <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> event.  The reason is \u000A that, in this particular case, the system's heuristics just happen to hit upon \u000A the lemma <v>true-listp-rev</v>.  But in many more complicated functions it is \u000A necessary for the user to formulate the inductively provable properties before \u000A <see topic=\"ACL2____GUARD\">guard</see> verification is attempted.</p> \u000A \u000A <p><b>Remark on computation of guard conjectures and evaluation</b>.  When \u000A ACL2 computes the <see topic=\"ACL2____GUARD\">guard</see> conjecture for the body of a function, it \u000A evaluates any ground subexpressions (those with no free variables), for calls \u000A of functions whose <v>:</v><tt><see topic=\"ACL2____EXECUTABLE-COUNTERPART\">executable-counterpart</see></tt> <see topic=\"ACL2____RUNE\">rune</see>s are \u000A <tt><see topic=\"ACL2____ENABLE\">enable</see></tt>d.  Note that here, ``enabled'' refers to the current global \u000A <see topic=\"ACL2____THEORY\">theory</see>, not to any <v>:</v><tt><see topic=\"ACL2____HINTS\">hints</see></tt> given to the guard verification \u000A process; after all, the guard conjecture is computed even before its initial \u000A goal is produced.  Also note that this evaluation is done in an environment as \u000A though <v>:set-guard-checking :all</v> had been executed, so that we can trust \u000A that this evaluation takes place without guard violations; see <see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see>.</p> \u000A \u000A <p>If you want to verify the <see topic=\"ACL2____GUARD\">guard</see>s on functions that are built into \u000A ACL2, you will first need to put them into <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode.  See \u000A <see topic=\"ACL2____VERIFY-TERMINATION\">verify-termination</see>, specifically the ``Remark on system functions'' in \u000A that <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.</p>"],

 "ACL2____ACL2-DEFAULTS-TABLE":[["Table"],"ACL2 Sources","ACL2","<code>Example Forms:\u000A(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode) ; current default defun-mode\u000A(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode :program)\u000A           ; set default defun-mode to :program</code> \u000A \u000A <p>See <see topic=\"ACL2____TABLE\">table</see> for a discussion of tables in general.  The legal keys for \u000A this <see topic=\"ACL2____TABLE\">table</see> are shown below.  They may be accessed and changed via the \u000A general mechanisms provided by <see topic=\"ACL2____TABLE\">table</see>s.  However, there are often more \u000A convenient ways to access and/or change the defaults.  (See also the note \u000A below.)</p> \u000A \u000A <code>:defun-mode</code> \u000A \u000A <p>the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>, which must be <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> or \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  See <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> for a general discussion of <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>s.  The <v>:</v><tt><see topic=\"ACL2____DEFUN-MODE\">defun-mode</see></tt> key may be conveniently set by \u000A keyword commands naming the new <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see>, <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> and \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>.  See <see topic=\"ACL2____PROGRAM\">program</see> and see <see topic=\"ACL2____LOGIC\">logic</see>.</p> \u000A \u000A <code>:enforce-redundancy</code> \u000A \u000A <p>if <v>t</v>, cause ACL2 to insist that most events are redundant (see <see topic=\"ACL2____REDUNDANT-EVENTS\">redundant-events</see>); if <v>:warn</v>, cause a warning instead of an error for \u000A such non-redundant events; else, <v>nil</v>.  See <see topic=\"ACL2____SET-ENFORCE-REDUNDANCY\">set-enforce-redundancy</see>.</p> \u000A \u000A <code>:verify-guards-eagerness</code> \u000A \u000A <p>an integer between 0 and 2 indicating how eager the system is to verify the \u000A <see topic=\"ACL2____GUARD\">guard</see>s of a <see topic=\"COMMON-LISP____DEFUN\">defun</see> event.  See <see topic=\"ACL2____SET-VERIFY-GUARDS-EAGERNESS\">set-verify-guards-eagerness</see>.</p> \u000A \u000A <code>:compile-fns</code> \u000A \u000A <p>When this key's value is <v>t</v>, functions are compiled when they are \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>'d; otherwise, the value is <v>nil</v>.  (Except, this key's value \u000A is ignored when explicit compilation is suppressed; see <see topic=\"ACL2____COMPILATION\">compilation</see>.) \u000A To set the flag, see <see topic=\"ACL2____SET-COMPILE-FNS\">set-compile-fns</see>.</p> \u000A \u000A <code>:measure-function</code> \u000A \u000A <p>the default measure function used by <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> when no <v>:measure</v> is \u000A supplied in <tt><see topic=\"ACL2____XARGS\">xargs</see></tt>.  The default measure function must be a function \u000A symbol of one argument. Let <v>mfn</v> be the default measure function and \u000A suppose no <v>:measure</v> is supplied with some recursive function definition. \u000A Then <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> finds the first formal, <v>var</v>, that is tested along \u000A every branch and changed in each recursive call.  The system then ``guesses'' \u000A that <v>(mfn var)</v> is the <v>:measure</v> for that <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.</p> \u000A \u000A <code>:well-founded-relation</code> \u000A \u000A <p>the default well-founded relation used by <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> when no \u000A <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt> is supplied in <tt><see topic=\"ACL2____XARGS\">xargs</see></tt>.  The default \u000A well-founded relation must be a function symbol, <v>rel</v>, of two arguments \u000A about which a <v>:</v><tt><see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see></tt> rule has been proved.  See \u000A <see topic=\"ACL2____WELL-FOUNDED-RELATION\">well-founded-relation</see>.</p> \u000A \u000A <code>:bogus-defun-hints-ok</code> \u000A \u000A <p>When this key's value is <v>t</v>, ACL2 allows <v>:hints</v> for nonrecursive \u000A function definitions.  Otherwise, the value is the <v>nil</v> (the default) or \u000A <v>:warn</v> (which makes the check but merely warns when the check fails).  See \u000A <see topic=\"ACL2____SET-BOGUS-DEFUN-HINTS-OK\">set-bogus-defun-hints-ok</see>.</p> \u000A \u000A <code>:bogus-mutual-recursion-ok</code> \u000A \u000A <p>When this key's value is <v>t</v>, ACL2 skips the check that every function \u000A in a <tt><see topic=\"ACL2____MUTUAL-RECURSION\">mutual-recursion</see></tt> (or <tt><see topic=\"ACL2____DEFUNS\">defuns</see></tt>) ``clique'' calls at least \u000A one other function in that ``clique.''  Otherwise, the value is <v>nil</v> (the \u000A default) or <v>:warn</v> (which makes the check but merely warns when the check \u000A fails).  See <see topic=\"ACL2____SET-BOGUS-MUTUAL-RECURSION-OK\">set-bogus-mutual-recursion-ok</see>.</p> \u000A \u000A <code>:irrelevant-formals-ok</code> \u000A \u000A <p>When this key's value is <v>t</v>, the check for irrelevant formals is \u000A bypassed; otherwise, the value is the keyword <v>nil</v> (the default) or \u000A <v>:warn</v> (which makes the check but merely warns when the check fails).  See \u000A <see topic=\"ACL2____IRRELEVANT-FORMALS\">irrelevant-formals</see> and see <see topic=\"ACL2____SET-IRRELEVANT-FORMALS-OK\">set-irrelevant-formals-ok</see>.</p> \u000A \u000A <code>:ignore-ok</code> \u000A \u000A <p>When this key's value is <v>t</v>, the check for ignored variables is \u000A bypassed; otherwise, the value is the keyword <v>nil</v> (the default) or \u000A <v>:warn</v> (which makes the check but merely warns when the check fails).  See \u000A <see topic=\"ACL2____SET-IGNORE-OK\">set-ignore-ok</see>.</p> \u000A \u000A <code>:bdd-constructors</code> \u000A \u000A <p>This key's value is a list of function symbols used to define the notion of \u000A ``BDD normal form.''  See <see topic=\"ACL2____BDD-ALGORITHM\">bdd-algorithm</see> and see <see topic=\"ACL2____HINTS\">hints</see>.</p> \u000A \u000A <code>:ttag</code> \u000A \u000A <p>This key's value, when non-<v>nil</v>, allows certain operations that extend \u000A the trusted code base beyond what is provided by ACL2.  See <see topic=\"ACL2____DEFTTAG\">defttag</see>. \u000A See <see topic=\"ACL2____DEFTTAG\">defttag</see>.</p> \u000A \u000A <code>:state-ok</code> \u000A \u000A <p>This key's value is either <v>t</v> or <v>nil</v> and indicates whether the \u000A user is aware of the syntactic restrictions on the variable symbol <v>STATE</v>. \u000A See <see topic=\"ACL2____SET-STATE-OK\">set-state-ok</see>.</p> \u000A \u000A <code>:backchain-limit</code> \u000A \u000A <p>This key's value is a list of two ``numbers.''  Either ``number'' may \u000A optionally be <v>nil</v>, which is treated like positive infinity.  The numbers \u000A control backchaining through hypotheses during type-set reasoning and \u000A rewriting.  See <see topic=\"ACL2____BACKCHAIN-LIMIT\">backchain-limit</see>.</p> \u000A \u000A <code>:default-backchain-limit</code> \u000A \u000A <p>This key's value is a list of two ``numbers.''  Either ``number'' may \u000A optionally be <v>nil</v>, which is treated like positive infinity.  The numbers \u000A are used respectively to set the backchain limit of a rule if one has not been \u000A specified. See <see topic=\"ACL2____BACKCHAIN-LIMIT\">backchain-limit</see>.</p> \u000A \u000A <code>:step-limit</code> \u000A \u000A <p>This key's value is either <v>nil</v> or a natural number not exceeding the \u000A value of <v>*default-step-limit*</v>.  If the value is <v>nil</v> or the value of \u000A <v>*default-step-limit*</v>, there is no limit on the number of ``steps'' that \u000A ACL2 counts during a proof: currently, the number of top-level rewriting \u000A calls.  Otherwise, the value is the maximum number of such calls allowed \u000A during evaluation of any event.  See <see topic=\"ACL2____SET-PROVER-STEP-LIMIT\">set-prover-step-limit</see>.</p> \u000A \u000A <code>:rewrite-stack-limit</code> \u000A \u000A <p>This key's value is a nonnegative integer less than <v>(<see topic=\"COMMON-LISP____EXPT\">expt</see> 2 28)</v>.  It \u000A is used to limit the depth of calls of ACL2 rewriter functions.  See <see topic=\"ACL2____REWRITE-STACK-LIMIT\">rewrite-stack-limit</see>.</p> \u000A \u000A <code>:let*-abstractionp</code> \u000A \u000A <p>This key affects how the system displays subgoals.  The value is either \u000A <v>t</v> or <v>nil</v>.  When t, let* expressions are introduced before printing \u000A to eliminate common subexpressions.  The actual goal being worked on is \u000A unchanged.</p> \u000A \u000A <code>:case-split-limitations</code> \u000A \u000A <p>This key's value is a list of two ``numbers.''  Either ``number'' may \u000A optionally be <v>nil</v>, which is treated like positive infinity.  The numbers \u000A control how the system handles case splits in the simplifier.  See <see topic=\"ACL2____SET-CASE-SPLIT-LIMITATIONS\">set-case-split-limitations</see>.</p> \u000A \u000A <code>:include-book-dir-alist</code> \u000A \u000A <p>This key's value is used by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>'s <v>:DIR</v> argument to \u000A associate a directory with a keyword.  An exception is the keyword \u000A <v>:SYSTEM</v> for the <v>books/</v> directory; see <see topic=\"ACL2____INCLUDE-BOOK\">include-book</see>, in \u000A particular the section on ``Books Directory.''  Also see <tt><see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR\">add-include-book-dir</see></tt> and <tt><see topic=\"ACL2____ADD-INCLUDE-BOOK-DIR_12\">add-include-book-dir!</see></tt>.</p> \u000A \u000A <code>:match-free-default</code> \u000A \u000A <p>This key's value is either <v>:all</v>, <v>:once</v>, or <v>nil</v>.  See <see topic=\"ACL2____SET-MATCH-FREE-DEFAULT\">set-match-free-default</see>.</p> \u000A \u000A <code>:match-free-override</code> \u000A \u000A <p>This key's value is a list of runes.  See <see topic=\"ACL2____ADD-MATCH-FREE-OVERRIDE\">add-match-free-override</see>.</p> \u000A \u000A <code>:match-free-override-nume</code> \u000A \u000A <p>This key's value is an integer used in the implementation of <see topic=\"ACL2____ADD-MATCH-FREE-OVERRIDE\">add-match-free-override</see>, so that only existing runes are affected by that \u000A event.</p> \u000A \u000A <code>:non-linearp</code> \u000A \u000A <p>This key's value is either <v>t</v> or <v>nil</v> and indicates whether the \u000A user wishes ACL2 to extend the linear arithmetic decision procedure to include \u000A non-linear reasoning.  See <see topic=\"ACL2____NON-LINEAR-ARITHMETIC\">non-linear-arithmetic</see>.</p> \u000A \u000A <code>:tau-auto-modep</code> \u000A \u000A <p>This key's value is either <v>t</v> or <v>nil</v> and indicates whether the \u000A user wishes ACL2 to look for opportunities to create <v>:</v><tt><see topic=\"ACL2____TAU-SYSTEM\">tau-system</see></tt> \u000A rules from all suitable <v>defun</v>s and from all suitable <v>defthm</v>s (with \u000A non-<v>nil</v> <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt>).  See <see topic=\"ACL2____SET-TAU-AUTO-MODE\">set-tau-auto-mode</see>.</p> \u000A \u000A <code>:ruler-extenders</code> \u000A \u000A <p>This key's value may be a list of symbols, indicating those function \u000A symbols that are not to block the collection of rulers; see <see topic=\"COMMON-LISP____DEFUN\">defun</see>. \u000A Otherwise the value is <v>:all</v> to indicate all function symbols, i.e., so \u000A that no function symbol blocks the collection of rulers.  If a list is \u000A specified (rather than <v>:all</v>), then it may contain the keyword \u000A <v>:lambdas</v>, which has the special role of specifying all <v>lambda</v> \u000A applications.  No other keyword is permitted in the list.  See <see topic=\"ACL2____RULER-EXTENDERS\">ruler-extenders</see>.</p> \u000A \u000A <code>:memoize-ideal-okp</code> \u000A \u000A <p>This key is only legal in a <see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> executable (see <see topic=\"ACL2____HONS-AND-MEMOIZATION\">hons-and-memoization</see>).  Its value must be either <v>t</v>, <v>nil</v>, or \u000A <v>:warn</v>.  If the value is <v>nil</v> or not present, then it is illegal by \u000A default to <see topic=\"ACL2____MEMOIZE\">memoize</see> a <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode function that has not \u000A been <see topic=\"ACL2____GUARD\">guard</see>-verified (see <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see>), sometimes called an \u000A ``ideal-mode'' function.  This illegality is the default because such calls of \u000A such functions in the ACL2 loop are generally evaluated in the logic (using \u000A so-called ``executable counterpart'' definitions), rather than directly by \u000A executing calls of the corresponding (memoized) raw Lisp function.  However, \u000A such a raw Lisp call can be made when the function is called by a <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function, so we allow you to override the default behavior by \u000A associating the value <v>t</v> or <v>:warn</v> with the key \u000A <v>:memoize-ideal-okp</v>, where with <v>:warn</v> you get a suitable warning. \u000A Note that you can also allow memoization of ideal-mode functions by supplying \u000A argument <v>:ideal-okp</v> to your memoization event (see <see topic=\"ACL2____MEMOIZE\">memoize</see>), in \u000A which case the value of <v>:memoize-ideal-okp</v> in the \u000A <v>acl2-defaults-table</v> is irrelevant.</p> \u000A \u000A <p>Note: Unlike all other <see topic=\"ACL2____TABLE\">table</see>s, <v>acl2-defaults-table</v> can affect \u000A the soundness of the system.  The <see topic=\"ACL2____TABLE\">table</see> mechanism therefore enforces on \u000A it a restriction not imposed on other <see topic=\"ACL2____TABLE\">table</see>s: when <tt><see topic=\"ACL2____TABLE\">table</see></tt> is \u000A used to update the <v>acl2-defaults-table</v>, the key and value must be \u000A variable-free forms.  Thus, while</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode :program),\u000A\u000A(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode ':program), and\u000A\u000A(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode (compute-mode *my-data*))</code> \u000A \u000A <p>are all examples of legal <see topic=\"ACL2____EVENTS\">events</see> (assuming <v>compute-mode</v> is a \u000A function of one non-<tt><see topic=\"ACL2____STATE\">state</see></tt> argument that produces a <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> \u000A as its single value),</p> \u000A \u000A <code>(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode (compute-mode (w state)))</code> \u000A \u000A <p>is not legal because the value form is <tt><see topic=\"ACL2____STATE\">state</see></tt>-sensitive.</p> \u000A \u000A <p>Consider for example the following three <see topic=\"ACL2____EVENTS\">events</see> which one might make \u000A into the text of a book.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IN-PACKAGE\">in-package</see> &quot;ACL2&quot;)\u000A\u000A(<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table\u000A  :defun-mode\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see> state) :logic :program))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> crash-and-burn (x) (<see topic=\"COMMON-LISP____CAR\">car</see> x))</code> \u000A \u000A <p>The second event is illegal because its value form is <tt><see topic=\"ACL2____STATE\">state</see></tt>-sensitive.  If it were not illegal, then it would set the <v>:</v><tt><see topic=\"ACL2____DEFUN-MODE\">defun-mode</see></tt> to <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> when the book was being certified but \u000A would set the <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> to <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> when the book was being \u000A loaded by <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.  That is because during certification, <tt><see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see></tt> is <v>nil</v> (proof obligations are generated and proved), but \u000A during book inclusion <tt><see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see></tt> is non-<v>nil</v> (those \u000A obligations are assumed to have been satisfied.)  Thus, the above book, when \u000A loaded, would create a function in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode that does not \u000A actually meet the conditions for such status.</p> \u000A \u000A <p>For similar reasons, <tt><see topic=\"ACL2____TABLE\">table</see></tt> <see topic=\"ACL2____EVENTS\">events</see> affecting \u000A <v>acl2-defaults-table</v> are illegal within the scope of <tt><see topic=\"ACL2____LOCAL\">local</see></tt> forms. \u000A That is, the text</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IN-PACKAGE\">in-package</see> &quot;ACL2&quot;)\u000A\u000A(<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode :program))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> crash-and-burn (x) (<see topic=\"COMMON-LISP____CAR\">car</see> x))</code> \u000A \u000A <p>is illegal because <v>acl2-defaults-table</v> is changed locally.  If this \u000A text were acceptable as a book, then when the book was certified, \u000A <v>crash-and-burn</v> would be processed in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode, but when \u000A the certified book was included later, <v>crash-and-burn</v> would have \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode because the <tt><see topic=\"ACL2____LOCAL\">local</see></tt> event would be skipped.</p> \u000A \u000A <p>The text</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____IN-PACKAGE\">in-package</see> &quot;ACL2&quot;)\u000A\u000A(<see topic=\"ACL2____PROGRAM\">program</see>) ;which is (<see topic=\"ACL2____TABLE\">table</see> acl2-defaults-table :defun-mode :program)\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> crash-and-burn (x) (<see topic=\"COMMON-LISP____CAR\">car</see> x))</code> \u000A \u000A <p>is acceptable and defines <v>crash-and-burn</v> in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> \u000A mode, both during certification and subsequent inclusion.</p> \u000A \u000A <p>We conclude with an important observation about the relation between \u000A <v>acl2-defaults-table</v> and <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, <tt><see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see></tt>, and \u000A <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>.  Including or certifying a book never has an effect on \u000A the <v>acl2-defaults-table</v>, nor does executing an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> event; \u000A we always restore the value of this <see topic=\"ACL2____TABLE\">table</see> as a final act.  (Also see \u000A <see topic=\"ACL2____INCLUDE-BOOK\">include-book</see>, see <see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>, and see <see topic=\"ACL2____CERTIFY-BOOK\">certify-book</see>.) \u000A That is, no matter how a book fiddles with the <v>acl2-defaults-table</v>, its \u000A value immediately after including that book is the same as immediately before \u000A including that book.  If you want to set the <v>acl2-defaults-table</v> in a way \u000A that persists, you need to do so using <see topic=\"ACL2____COMMAND\">command</see>s that are not inside \u000A <see topic=\"ACL2____BOOKS\">books</see>.  It may be useful to set your favorite defaults in your <tt><see topic=\"ACL2____ACL2-CUSTOMIZATION\">ACL2-customization</see></tt> file; see <see topic=\"ACL2____ACL2-CUSTOMIZATION\">ACL2-customization</see>.</p>"],

 "ACL2____FMT":[["Io","ACL2-built-ins"],"ACL2 Sources","ACL2","<p>ACL2 provides the functions <v>fmt</v>, <tt><see topic=\"ACL2____FMT1\">fmt1</see></tt>, and <tt><see topic=\"ACL2____FMS\">fms</see></tt> \u000A as substitutes for Common Lisp's <v>format</v> function.  Also see <see topic=\"ACL2____FMT_12\">fmt!</see>, \u000A see <see topic=\"ACL2____FMT1_12\">fmt1!</see>, and see <see topic=\"ACL2____FMS_12\">fms!</see> for versions of these functions that \u000A write forms to files in a manner that allows them to be read, by avoiding \u000A using backslash (<v>\\</v>) to break long lines.  There are also analogues of \u000A these functions that return a string without taking <tt><see topic=\"ACL2____STATE\">state</see></tt> as an \u000A argument; see <see topic=\"ACL2____PRINTING-TO-STRINGS\">printing-to-strings</see>.</p> \u000A \u000A <p>All three print a given string under an alist pairing character objects \u000A with values, interpreting certain ``tilde-directives'' in the string. \u000A <v>Channel</v> must be a character output channel (e.g., <tt><see topic=\"ACL2_____A2STANDARD-CO_A2\">*standard-co*</see></tt>).</p> \u000A \u000A <code>General Forms:                                            result\u000A(<see topic=\"ACL2____FMS\">fms</see> string alist channel state evisc-tuple)         ; state\u000A(<see topic=\"ACL2____FMT\">fmt</see> string alist channel state evisc-tuple)         ; (<see topic=\"ACL2____MV\">mv</see> col state)\u000A(<see topic=\"ACL2____FMT1\">fmt1</see> string alist column channel state evisc-tuple) ; (<see topic=\"ACL2____MV\">mv</see> col state)</code> \u000A \u000A <p><tt><see topic=\"ACL2____FMS\">Fms</see></tt> and <v>fmt</v> print an initial newline to put <v>channel</v> in \u000A column <v>0</v>; <tt><see topic=\"ACL2____FMT1\">Fmt1</see></tt> requires the current column as input.  Columns are \u000A numbered from <v>0</v>.  The current column is the column into which the next \u000A character will be printed.  (Thus, the current column number is also the \u000A number of <see topic=\"ACL2____CHARACTERS\">characters</see> printed since the last newline.)  The <v>col</v> \u000A returned by <v>fmt</v> and <tt><see topic=\"ACL2____FMT1\">fmt1</see></tt> is the current column at the conclusion \u000A of the formatting.  <v>Evisc-tuple</v> must be either <v>nil</v> (meaning no \u000A abbreviations are used when objects are printed) or an ``evisceration tuple''; \u000A see <see topic=\"ACL2____EVISC-TUPLE\">evisc-tuple</see>.</p> \u000A \u000A <p>We list the tilde-directives below.  The notation is explained after the \u000A chart.</p> \u000A \u000A <code>~xx  pretty print vx (maybe after printing a newline)\u000A~yx  pretty print vx starting in current column; end with newline\u000A~Xxy like ~xx but use vy as the evisceration tuple\u000A~Yxy like ~yx but use vy as the evisceration tuple\u000A~@x  if vx is a string, &quot;str&quot;,  recursively format &quot;str&quot;\u000A     if vx is (&quot;str&quot; . a), recursively format &quot;str&quot; under a+\u000A~#x~[...~/...~/ ... ~/...~] cases on vx\u000A     ^    ^     ...   ^  if 0&lt;=vx&lt;=k, choose vxth alternative\u000A     0    1     ...   k  if vx is a list of length 1, case 0; else 1\u000A~*x  iterator: vx must be of the form\u000A     (&quot;str0&quot; &quot;str1&quot; &quot;str2&quot; &quot;str3&quot; lst . a);\u000A     if lst is initially empty, format &quot;str0&quot; under a+; otherwise,\u000A     bind #\\* successively to the elements of lst and then\u000A     recursively format &quot;stri&quot; under a+, where i=1 if there is one\u000A     element left to process, i=2 if there are two left, and i=3\u000A     otherwise.\u000A~&amp;x  print elements of vx with ~x, separated by commas and a\u000A     final ``and''\u000A~vx  print elements of vx with ~x, separated by commas and a\u000A     final ``or''\u000A~nx  if vx is a small positive integer, print it as a word, e.g.,\u000A     seven;\u000A     if vx is a singleton containing a small positive integer, print\u000A       the corresponding ordinal as a word, e.g., seventh\u000A~Nx  like ~nx but the word is capitalized, e.g., Seven or Seventh\u000A~tx  tab out to column vx; newline first if at or past column vx\u000A~cx  vx is (n . w), print integer n right justified in field of\u000A     width w\u000A~fx  print object vx flat over as many lines as necessary\u000A~Fx  same as ~f, except that subsequent lines are indented to\u000A     start one character to the right of the first character printed\u000A~sx  if vx is a symbol, print vx, breaking on hyphens (unless the\u000A     symbol would normally be printed with surrounding vertical bar\u000A     characters (|), in which case print as with ~fx); if vx is a\u000A     string, print the characters in it, breaking on hyphens; else\u000A     vx is a number, to be printed using the current print-base and\u000A     print-radix\u000A~    tilde space: print a space\u000A~_x  print vx spaces\u000A~\u000A     tilde newline: skip following whitespace\u000A~%   output a newline\u000A~|   output a newline unless already on left margin\u000A~~   print a tilde\u000A~-   if close to rightmargin, output a hyphen and newline; else\u000A     skip this char</code> \u000A \u000A <p>If <v>x</v> is a character, then <v>vx</v> is the value of <v>#\\x</v> under the \u000A current alist.  Consider for example the discussion above for <v>~y</v>, \u000A ``<v>~yx pretty print vx</v>'', applied to the following expression: <v>(<see topic=\"ACL2____FMT\">fmt</see>\u000A &quot;HELLO ~y7&quot; (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\7 'world)) *standard-co* state nil)</v>.  Then in \u000A this example: <v>#\\x</v> is 7; and <v>vx</v> is the value of character <v>#\\7</v> \u000A under the given alist, which is the symbol, <v>WORLD</v>.  Thus, ACL2 will print \u000A <v>HELLO WORLD</v>.  When we say ``format <v>str</v> under <v>a+</v>'' we mean: \u000A process the given string under an alist obtained by appending <v>a</v> to the \u000A current alist.  The following example illustrates how this works.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____FMS\">fms</see> &quot;~@0&quot;\u000A            (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 (<see topic=\"COMMON-LISP____CONS\">cons</see> &quot;~x0 ~@1&quot; (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0  'abc))))\u000A                  (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\1 &quot;-- and now: ~x0 again~%&quot;))\u000A            *standard-co* state nil)\u000A\u000AABC -- and now: ABC again\u000A&lt;state&gt;\u000AACL2 !&gt;</code> \u000A \u000A <p>Note: <v>~p</v>, <v>~q</v>, <v>~P</v>, and <v>~Q</v> are also currently supported, \u000A but are deprecated.  These are respectively the same as <v>~x</v>, <v>~y</v>, \u000A <v>~X</v>, and <v>~Y</v>, except that their arguments are expected to be terms, \u000A preferably untranslated (user-level) terms, that could be printed using infix \u000A notation in certain environments.  Infix printing is not currently supported \u000A but may be if there is sufficient need for it.</p> \u000A \u000A <p>ACL2's formatting functions print to the indicated channel, keeping track \u000A of which column they are in.  <tt><see topic=\"ACL2____FMT1\">Fmt1</see></tt> can be used if the caller knows \u000A which column the channel is in (i.e., how many <see topic=\"ACL2____CHARACTERS\">characters</see> have been \u000A printed since the last newline).  Otherwise, <v>fmt</v> or <tt><see topic=\"ACL2____FMS\">fms</see></tt> must be \u000A used, both of which output a newline so as to establish the column position at \u000A <v>0</v>.  Unlike Common Lisp's <v>format</v> routine, <v>fmt</v> and its relatives \u000A break the output into lines so that, by default, an attempt is made to avoid \u000A printing past column <v>77</v> (the value of constant \u000A <v>*fmt-hard-right-margin-default*</v>).  See <see topic=\"ACL2____SET-FMT-HARD-RIGHT-MARGIN\">set-fmt-hard-right-margin</see> \u000A for a discussion of how linebreaks are inserted and how to change the relevant \u000A default settings.</p> \u000A \u000A <p>The formatting functions scan the string from left to right, printing each \u000A successive character unless it is a tilde <v>(~)</v>.  Upon encountering tildes \u000A the formatters take action determined by the character or <see topic=\"ACL2____CHARACTERS\">characters</see> \u000A immediately following the tilde.  The typical tilde-directive is a group of \u000A three successive <see topic=\"ACL2____CHARACTERS\">characters</see> from the string being printed.  For \u000A example, <v>~x0</v> is a 3 character <v>tilde-directive</v>.  The first character \u000A in a tilde-directive is always the tilde character itself.  The next character \u000A is called the ``command'' character.  The character after that is usually \u000A taken as the name of a ``format variable'' that is bound in the alist under \u000A which the string is being printed.  Format variables are, by necessity, <see topic=\"ACL2____CHARACTERS\">characters</see>.  The objects actually printed by a tilde-directive are the \u000A objects obtained by looking up the command's format variables in the alist. \u000A Typical format variable names are <v>0</v>, <v>1</v>, <v>2</v>, ..., <v>9</v>, <v>a</v>, \u000A <v>b</v>, <v>c</v>, etc., and if a tilde-directive uses the format variable \u000A <v>0</v>, as in <v>~x0</v>, then the character <v>#\\0</v> must be bound in the \u000A alist.  Some tilde commands take no arguments and others take more than one, \u000A so some directives are of length two and others are longer.</p> \u000A \u000A <p>It should be noted that this use of <see topic=\"ACL2____CHARACTERS\">characters</see> in the string to \u000A denote arguments is another break from Common Lisp's <v>format</v> routine.  In \u000A Common Lisp, the directives refer implicitly to the ``next item to be \u000A printed.''  But in ACL2 the directives name each item explicitly with our \u000A format variables.</p> \u000A \u000A <p>The following text contains examples that can be evaluated.  To make this \u000A process easier, we use a macro which is defined as part of ACL2 just for this \u000A <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.  The macro is named <v>fmx</v> and it takes up to eleven \u000A arguments, the first of which is a format string, <v>str</v>, and the others of \u000A which are taken as the values of format variables.  The variables used are \u000A <v>#\\0</v> through <v>#\\9</v>.  The macro constructs an appropriate alist, \u000A <v>a</v>, and then evaluates <v>(<see topic=\"ACL2____FMT\">fmt</see> str a *standard-co* state nil)</v>.</p> \u000A \u000A <p>Thus,</p> \u000A \u000A <code>(fmx &quot;Here is v0, ~x0, and here is v1, ~x1.&quot;\u000A     (<see topic=\"COMMON-LISP____CONS\">cons</see> 'value 0)\u000A     (<see topic=\"COMMON-LISP____CONS\">cons</see> 'value 1))</code> \u000A \u000A <p>is just an abbreviation for</p> \u000A \u000A <code>(<see topic=\"ACL2____FMT\">fmt</see> &quot;Here is v0, ~x0, and here is v1, ~x1.&quot;\u000A     (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 (<see topic=\"COMMON-LISP____CONS\">cons</see> 'value 0))\u000A           (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\1 (<see topic=\"COMMON-LISP____CONS\">cons</see> 'value 1)))\u000A     *standard-co*\u000A     state\u000A     nil)</code> \u000A \u000A <p>which returns <v>(<see topic=\"ACL2____MV\">mv</see> 53 state)</v> after printing the line</p> \u000A \u000A <code>Here is v0, (VALUE . 0), and here is v1, (VALUE . 1).</code> \u000A \u000A <p>We now devote special attention to three of the tilde-directives whose use \u000A is non-obvious.</p> \u000A \u000A <p><i>The Case Statement</i></p> \u000A \u000A <p><v>~#x</v> is essentially a ``case statement'' in the language of <v>fmt</v>. \u000A The proper form of the statement is</p> \u000A \u000A <code>~#x~[case-0~/case-1~/ ... ~/case-k~],</code> \u000A \u000A <p>where each of the <v>case-i</v> is a format string.  In the most common use, \u000A the variable <v>x</v> has an integer value, <v>vx</v>, between <v>0</v> and <v>k</v>, \u000A inclusive.  The effect of formatting the directive is to format \u000A <v>case-vx</v>.</p> \u000A \u000A <p>For example</p> \u000A \u000A <code>(fmx &quot;Go ~#0~[North~/East~/South~/West~].~%&quot; 1)</code> \u000A \u000A <p>will print ``Go East.'' followed by a newline and will return</p> \u000A \u000A <p><v>(<see topic=\"ACL2____MV\">mv</see> 0 state)</v>, while if you change the <v>1</v> above to <v>3</v> (the \u000A maximum legal value), it will print ``Go West.''</p> \u000A \u000A <p>In order to make it easier to print such phrases as ``there are seven \u000A cases'' requiring agreement between subject and verb based on the number of \u000A elements of a list, the case statement allows its variable to take a list as \u000A its value and selects <v>case-0</v> if the list has length <v>1</v> and \u000A <v>case-1</v> otherwise.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((<see topic=\"ACL2____CASES\">cases</see> '(a b c)))\u000A  (fmx &quot;There ~#0~[is ~n1 case~/are ~n1 cases~].&quot;\u000A       cases\u000A       (<see topic=\"COMMON-LISP____LENGTH\">length</see> cases)))</code> \u000A \u000A <p>will print ``There are three cases.'' but if you change the</p> \u000A \u000A <p><v>'(a b c)</v> above simply to <v>'(a)</v> it will print ``There is one \u000A case.'' and if you change it to <v>nil</v> it will print ``There are zero \u000A cases.''</p> \u000A \u000A <p><i>Indirection</i></p> \u000A \u000A <p>Roughly speaking, <v>~@</v> will act as though the value of its argument is a \u000A format string and splice it into the current string at the current position. \u000A It is often used when the phrase to be printed must be computed.  For \u000A example,</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((ev 'DEFUN))\u000A (fmx &quot;~x0 is an event~@1.&quot;\u000A      'foo\u000A      (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____MEMBER-EQ\">member-eq</see> ev '(<see topic=\"COMMON-LISP____DEFUN\">defun</see> defstub encapsulate))\u000A          &quot; that may introduce a function symbol&quot;\u000A          &quot;&quot;)))</code> \u000A \u000A <p>will print ``<v>foo</v> is an event that may introduce a function symbol,'' \u000A but if the value of <v>ev</v> is changed from <v>'</v><tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> to \u000A <v>'</v><tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>, it prints ``<v>foo</v> is an event.''  The <v>~@</v> \u000A directive ``splices'' in the computed phrase (which might be empty).  Of \u000A course, this particular example could be done with the case statement</p> \u000A \u000A <code>~#1~[~/ that may introduce a function symbol~]</code> \u000A \u000A <p>where the value of <v>#\\1</v> is appropriately computed to be <v>0</v> or \u000A <v>1</v>.</p> \u000A \u000A <p>If the argument to <v>~@</v> is a pair, it is taken to be a format string \u000A <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt>ed onto an alist, i.e., <v>(&quot;str&quot; . a)</v>, and the alist, <v>a</v>, \u000A is used to extend the current one before <v>&quot;str&quot;</v> is recursively \u000A processed.  This feature of <v>fmt</v> can be used to pass around ``phrases'' \u000A that contain computed contextual information in <v>a</v>.  The most typical use \u000A is as ``error messages.''  For example, suppose you are writing a function \u000A which does not have access to <tt><see topic=\"ACL2____STATE\">state</see></tt> and so cannot print an error \u000A message.  It may nevertheless be necessary for it to signal an error to its \u000A caller, say by returning two results, the first of which is interpreted as an \u000A error message if non-<v>nil</v>.  Our convention is to use a <v>~@</v> pair to \u000A represent such messages.  For example, the error value might be produced by \u000A the code:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____CONS\">cons</see>\u000A  &quot;Error:  The instruction ~x0 is illegal when the stack is ~x1.~%&quot;\u000A  (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 (current-instruction st))\u000A        (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\1 (i-stack st))))</code> \u000A \u000A <p>If the <v>current-instruction</v> and <v>i-stack</v> (whatever they are) are \u000A <v>'(popi 3)</v> and <v>'(a b)</v> when the <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> above is evaluated, then \u000A it produces</p> \u000A \u000A <code>'(&quot;Error:  The instruction ~x0 is illegal when the stack is ~x1.~%&quot;\u000A  (#\\0 POPI 3)\u000A  (#\\1 A B))</code> \u000A \u000A <p>and if this pair is made the value of the <v>fmt</v> variable <v>0</v>, then \u000A <v>~@0</v> will print</p> \u000A \u000A <code>Error:  The instruction (POPI 3) is illegal when the stack is (A B).</code> \u000A \u000A <p>For example, evaluate</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see>\u000A ((pair\u000A  '(&quot;Error:  The instruction ~x0 is illegal when the stack is ~x1.~%&quot;\u000A    (#\\0 POPI 3)\u000A    (#\\1 A B))))\u000A (fmx &quot;~@0&quot; pair)).</code> \u000A \u000A <p>Thus, even though the function that produced the ``error'' could not print \u000A it, it could specify exactly what error message and data are to be \u000A printed.</p> \u000A \u000A <p>This example raises another issue.  Sometimes it is desirable to break \u000A lines in your format strings so as to make your source code more attractive. \u000A That is the purpose of the <v>tilde-newline</v> directive.  The following code \u000A produces exactly the same output as described above.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((pair '(&quot;Error:  The instruction ~x0 ~\u000A              is illegal when the stack is ~\u000A              ~x1.~%&quot;\u000A              (#\\0 POPI 3)\u000A              (#\\1 A B))))\u000A (fmx &quot;~@0&quot; pair)).</code> \u000A \u000A <p>Finally, observe that when <v>~@0</v> extends the current alist, <v>alist</v>, \u000A with the one, <v>a</v>, in its argument, the bindings from <v>a</v> are added to \u000A the front of <v>alist</v>, overriding the current values of any shared \u000A variables.  This ensures that the variable values seen by the recursively \u000A processed string, <v>&quot;str&quot;</v>, are those from <v>a</v>, but if <v>&quot;str&quot;</v> \u000A uses variables not bound in <v>a</v>, their values are as specified in the \u000A original alist.  Intuitively, variables bound in <v>a</v> are local to the \u000A processing of <v>(&quot;str&quot; . a)</v> but <v>&quot;str&quot;</v> may use ``global \u000A variables.''  The example above illustrates this because when the <v>~@0</v> is \u000A processed, <v>#\\0</v> is bound to the error message pair.  But when the \u000A <v>~x0</v> in the error string is processed, <v>#\\0</v> is bound to the illegal \u000A instruction.</p> \u000A \u000A <p><i>Iteration</i></p> \u000A \u000A <p>The <v>~*</v> directive is used to process each element of a list.  For \u000A example,</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((lst '(a b c d e f g h))) ; a true-list whose elements we exhibit\u000A (fmx &quot;~*0&quot;\u000A      `(&quot;Whoa!&quot;          ; what to print if there's nothing to print\u000A        &quot;~x*!&quot;           ; how to print the last element\u000A        &quot;~x* and &quot;       ; how to print the 2nd to last element\u000A        &quot;~x*, &quot;          ; how to print all other elements\u000A        ,lst)))          ; the list of elements to print</code> \u000A \u000A <p>will print ``<v>A, B, C, D, E, F, G and H!</v>''.  Try this example with \u000A other true list values of <v>lst</v>, such as <v>'(a b)</v>, <v>'(a)</v>, and \u000A <v>nil</v>.  The tilde-directives <v>~&amp;0</v> and <v>~v0</v>, which take a true list \u000A argument and display its elements separated by commas and a final ``and'' or \u000A ``or,'' are implemented in terms of the more general <v>~*</v>.</p> \u000A \u000A <p>The <v>~*</v> directive allows the 5-tuple to specify in its final <tt><see topic=\"COMMON-LISP____CDR\">cdr</see></tt> an alist with which to extend the current one before processing the \u000A individual elements.</p> \u000A \u000A <p>We often use <v>~*</v> to print a series of phrases, separated by suitable \u000A punctuation, whitespace and noise words.  In such use, the <v>~*</v> handles the \u000A separation of the phrases and each phrase is generally printed by <v>~@</v>.</p> \u000A \u000A <p>Here is a complex example.  In the <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>, below, we bind phrases to \u000A a list of <v>~@</v> pairs and then we create a <v>~*</v> 5-tuple to print out the \u000A conjunction of the phrases with a parenthetical ``finally!'' if the series is \u000A longer than 3.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET_A2\">let*</see> ((phrases\u000A        (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____LIST\">list</see> &quot;simplifying with the replacement rules ~&amp;0&quot;\u000A                    (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 '(rewrite-rule1\u000A                                rewrite-rule2\u000A                                rewrite-rule3)))\u000A              (<see topic=\"COMMON-LISP____LIST\">list</see> &quot;destructor elimination using ~x0&quot;\u000A                    (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 'elim-rule))\u000A              (<see topic=\"COMMON-LISP____LIST\">list</see> &quot;generalizing the terms ~&amp;0&quot;\u000A                    (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 '((rev x) (app u v))))\u000A              (<see topic=\"COMMON-LISP____LIST\">list</see> &quot;inducting on ~x0&quot;\u000A                    (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 'I))))\u000A       (5-tuple\u000A        (<see topic=\"COMMON-LISP____LIST\">list</see>\u000A         &quot;magic&quot;                            ; no phrases\u000A         &quot;~@*&quot;                              ; last phrase\u000A         &quot;~@*, and~#f~[~/ (finally!)~] &quot;    ; second to last phrase\u000A         &quot;~@*, &quot;                            ; other phrases\u000A         phrases                            ; the phrases themselves\u000A         (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\f\u000A               (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP_____E3\">&gt;</see>(<see topic=\"COMMON-LISP____LENGTH\">length</see> phrases) 3) 1 0))))) ;print ``finally''?\u000A  (fmx &quot;We did it by ~*0.&quot; 5-tuple))</code> \u000A \u000A <p>This <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> prints</p> \u000A \u000A <code>We did it by simplifying with the replacement rules REWRITE-RULE1,\u000AREWRITE-RULE2 and REWRITE-RULE3, destructor elimination using ELIM-\u000ARULE, generalizing the terms (REV X) and (APP U V), and (finally!)\u000Ainducting on I.</code> \u000A \u000A <p>You might wish to try evaluating the <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> after removing elements \u000A of phrases.</p> \u000A \u000A <p>Most of the output produced by ACL2 is produced via <v>fmt</v> statements. \u000A Thus, inspection of the source code will yield many examples.  A complicated \u000A example is the code that explains the simplifier's work.  See <v>:</v><tt><see topic=\"ACL2____PC\">pc</see></tt> \u000A <v>simplify-clause-msg1</v>.  An ad hoc example is provided by the function \u000A <v>fmt-doc-example</v>, which takes two arguments: an arbitrary true list and \u000A <tt><see topic=\"ACL2____STATE\">state</see></tt>.  To see how <v>fmt-doc-example</v> works, <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt> \u000A <v>fmt-doc-example</v>.</p> \u000A \u000A <code>(fmt-doc-example '(a b c d e f g h i j k l m n o p) state)</code> \u000A \u000A <p>will produce the output</p> \u000A \u000A <code>Here is a true list:  (A B C D E F G H I J K L M N O P).  It has 16\u000Aelements, the third of which is C.\u000A\u000AWe could print each element in square brackets:\u000A([A], [B], [C], [D], [E], [F], [G], [H], [I], [J], [K], [L], [M], [N],\u000A[almost there: O], [the end: P]).  And if we wished to itemize them\u000Ainto column 15 we could do it like this\u000A0123456789012345\u000A    0 (zeroth) A\u000A    1 (<see topic=\"COMMON-LISP____FIRST\">first</see>)  B\u000A    2 (<see topic=\"COMMON-LISP____SECOND\">second</see>) C\u000A    3 (<see topic=\"COMMON-LISP____THIRD\">third</see>)  D\u000A    4 (<see topic=\"COMMON-LISP____FOURTH\">fourth</see>) E\u000A    5 (<see topic=\"COMMON-LISP____FIFTH\">fifth</see>)  F\u000A    6 (<see topic=\"COMMON-LISP____SIXTH\">sixth</see>)  G\u000A    7 (<see topic=\"COMMON-LISP____SEVENTH\">seventh</see>)\u000A               H\u000A    8 (<see topic=\"COMMON-LISP____EIGHTH\">eighth</see>) I\u000A    9 (<see topic=\"COMMON-LISP____NINTH\">ninth</see>)  J\u000A   10 (<see topic=\"COMMON-LISP____TENTH\">tenth</see>)  K\u000A   11 (eleventh)\u000A               L\u000A   12 (twelfth)\u000A               M\u000A   13 (thirteenth)\u000A               N\u000A   14 (14th)   O\u000A   15 (15th)   P\u000AEnd of example.</code> \u000A \u000A <p>and return <v>(<see topic=\"ACL2____MV\">mv</see> 15 state)</v>.</p> \u000A \u000A <p>Finally, we should remind the reader that <v>fmt</v> and its subfunctions, \u000A most importantly <v>fmt0</v>, are written entirely in ACL2.  We make this \u000A comment for two reasons.  First, it illustrates the fact that quite low level \u000A code can be efficiently written in the language.  Second, it means that as a \u000A last resort for documentation purposes you can read the source code without \u000A changing languages.</p>"],

 "ACL2____BREAK-REWRITE":[["Debugging"],"ACL2 Sources","ACL2","<p>ACL2 allows the user to <see topic=\"ACL2____MONITOR\">monitor</see> the application of <see topic=\"ACL2____REWRITE\">rewrite</see>, <see topic=\"ACL2____DEFINITION\">definition</see>, and <see topic=\"ACL2____LINEAR\">linear</see> rules.  When <see topic=\"ACL2____MONITOR\">monitor</see>ed \u000A rules are about to be tried by the rewriter, an interactive break occurs and \u000A the user is allowed to watch and, in a limited sense, control the attempt to \u000A apply the rule.  This interactive loop, which is technically just a call of \u000A the standard top-level ACL2 read-eval-print loop, <tt><see topic=\"ACL2____LD\">ld</see></tt>, on a ``<see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>'' (see <see topic=\"ACL2____WORMHOLE\">wormhole</see>), is called ``break-rewrite.'' \u000A While in break-rewrite, certain keyword commands are available for accessing \u000A information about the context in which the lemma is being tried.  These \u000A keywords are called break-rewrite ``commands.''</p> \u000A \u000A <p>Also see <see topic=\"ACL2____DMR\">dmr</see> (Dynamically Monitor Rewrites) for a related utility, \u000A which allows you to watch progress of the rewriter in real time.</p> \u000A \u000A <p>To abort from inside break-rewrite at any time, execute</p> \u000A \u000A <p>For further information, see the related <v>:</v><tt><see topic=\"ACL2____DOC\">doc</see></tt> topics listed \u000A below.</p> \u000A \u000A <p>As explained in the documentation for <tt><see topic=\"ACL2____MONITOR\">monitor</see></tt>, it is possible to \u000A cause the ACL2 rewriter to <see topic=\"ACL2____MONITOR\">monitor</see> the attempted application of \u000A selected rules.  When such a rule is about to be tried, the rewriter evaluates \u000A its break condition and if the result is non-<v>nil</v>, break-rewrite is \u000A entered.</p> \u000A \u000A <p>Break-rewrite permits the user to inspect the current <see topic=\"ACL2____STATE\">state</see> by \u000A evaluating break-rewrite commands.  Type <v>:help</v> in break-rewrite to see \u000A what the break-rewrite commands are.  However, break-rewrite is actually just \u000A a call of the general ACL2 read-eval-print loop, <tt><see topic=\"ACL2____LD\">ld</see></tt>, on a certain \u000A <see topic=\"ACL2____STATE\">state</see> and the break-rewrite commands are simply aliases provided by \u000A <v>ld-keyword-aliases</v> <see topic=\"ACL2____TABLE\">table</see> (see <see topic=\"ACL2____LD-KEYWORD-ALIASES\">ld-keyword-aliases</see>).  See \u000A <see topic=\"ACL2____LD\">ld</see> for details about this read-eval-print loop.  Thus, with a few \u000A exceptions, anything you can do at the ACL2 top-level can be done within \u000A break-rewrite.  For example, you can evaluate arbitrary expressions, use the \u000A keyword command hack, access <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>, print <see topic=\"ACL2____EVENTS\">events</see>, and \u000A even define functions and prove theorems.  However, the ``certain <see topic=\"ACL2____STATE\">state</see>'' upon which <tt><see topic=\"ACL2____LD\">ld</see></tt> was called is a ``<see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>'' (see <see topic=\"ACL2____WORMHOLE\">wormhole</see>) because break-rewrite is not allowed to have \u000A any effect upon the behavior of rewrite.  What this means, very roughly but \u000A understandably, is that break-rewrite operates on a copy of the <see topic=\"ACL2____STATE\">state</see> \u000A being used by rewrite and when break-rewrite exits the <see topic=\"ACL2____WORMHOLE\">wormhole</see> closes \u000A and the <see topic=\"ACL2____STATE\">state</see> ``produced'' by break-rewrite disappears.  Thus, \u000A break-rewrite lets you query the state of the rewriter and even do experiments \u000A involving proofs, etc., but these experiments have no effect on the ongoing \u000A proof attempt.  In particular:</p> \u000A \u000A <p>Note that the output from break-rewrite is sometimes abbreviated by \u000A default, such as for the term causing the break.  This can be controlled by \u000A setting the <v>:term</v> evisc-tuple; see <see topic=\"ACL2____SET-EVISC-TUPLE\">set-evisc-tuple</see>.  (Another \u000A option: use iprinting.  See <see topic=\"ACL2____SET-IPRINT\">set-iprint</see>.)  But as noted above, if you \u000A use <v>set-evisc-tuple</v> from inside the break-rewrite <see topic=\"ACL2____WORMHOLE\">wormhole</see>, its \u000A effect will disappear when you exit the break.  So you might want to issue a \u000A <v>set-evisc-tuple</v> command from the top level, outside break-rewrite.</p> \u000A \u000A <p>When you first enter break-rewrite a simple herald is printed such as:</p> \u000A \u000A <code>(3 Breaking (:rewrite lemma12) on (delta a (<see topic=\"COMMON-LISP_____B2\">+</see> 1 j)):</code> \u000A \u000A <p>The integer after the open parenthesis indicates the depth of nested \u000A break-rewrite calls.  In this discussion we use <v>3</v> consistently for this \u000A integer.  Unless you abort or somehow enter unbalanced parentheses into the \u000A script, the entire session at a given depth will be enclosed in balanced \u000A parentheses, making it easy to skip over them in Emacs.</p> \u000A \u000A <p>You then will see the break-rewrite <see topic=\"ACL2____PROMPT\">prompt</see>:</p> \u000A \u000A <code>3 ACL2 !&gt;</code> \u000A \u000A <p>The leading integer is, again, the depth.  Because breaks often occur \u000A recursively it is convenient always to know the level with which you are \u000A interacting.</p> \u000A \u000A <p>You may type arbitrary commands as in the top-level ACL2 loop.  For \u000A example, you might type:</p> \u000A \u000A <code>3 ACL2 !&gt;:help</code> \u000A \u000A <p>or</p> \u000A \u000A <code>3 ACL2 !&gt;:pe lemma12</code> \u000A \u000A <p>More likely, upon entering break-rewrite you will determine the context of \u000A the attempted application.  Here are some useful commands:</p> \u000A \u000A <code>3 ACL2 &gt;:target           ; the term being rewritten\u000A3 ACL2 &gt;:unify-subst      ; the unifying substitution\u000A3 ACL2 &gt;:path             ; the stack of goals pursued by the rewriter\u000A                          ; starting at the top-level clause being simplified\u000A                          ; and ending with the current application</code> \u000A \u000A <p>At this point in the interaction the system has not yet tried to apply the \u000A <see topic=\"ACL2____MONITOR\">monitor</see>ed rule.  That is, it has not tried to establish the hypotheses, \u000A considered the heuristic cost of backchaining, rewritten the right-hand side \u000A of the conclusion, etc.  When you are ready for it to try the rule you can \u000A type one of several different ``proceed'' commands.  The basic proceed \u000A commands are <v>:ok</v>, <v>:go</v>, and <v>:eval</v>.</p> \u000A \u000A <code>:ok</code> \u000A \u000A <p>exits break-rewrite without further interaction.  When break-rewrite exits \u000A it prints ``<v>3)</v>'', closing the parenthesis that opened the level <v>3</v> \u000A interaction.</p> \u000A \u000A <code>:go</code> \u000A \u000A <p>exits break-rewrite without further interaction, but prints out the result \u000A of the application attempt, i.e., whether the application succeeded, if so, \u000A what the <v>:target</v> term was rewritten to, and if not why the rule was not \u000A applicable.</p> \u000A \u000A <code>:eval</code> \u000A \u000A <p>causes break-rewrite to attempt to apply the rule but interaction at this \u000A level of break-rewrite resumes when the attempt is complete.  When control \u000A returns to this level of break-rewrite a message indicating the result of the \u000A application attempt (just as in <v>:go</v>) is printed, followed by the <see topic=\"ACL2____PROMPT\">prompt</see> for additional user input.</p> \u000A \u000A <p>Generally speaking, <v>:ok</v> and <v>:go</v> are used when the break in \u000A question is routine or uninteresting and <v>:eval</v> is used when the break is \u000A one that the user anticipates is causing trouble.  For example, if you are \u000A trying to determine why a lemma isn't being applied to a given term and the \u000A <v>:target</v> of the current break-rewrite is the term in question, you would \u000A usually <v>:eval</v> the rule and if break-rewrite reports that the rule failed \u000A then you are in a position to determine why, for example by carefully \u000A inspecting the <v>:</v><tt><see topic=\"ACL2____TYPE-ALIST\">type-alist</see></tt> of governing assumptions or why some \u000A hypothesis of the rule could not be established.</p> \u000A \u000A <p>It is often the case that when you are in break-rewrite you wish to change \u000A the set of <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s.  This can be done by using \u000A <v>:</v><tt><see topic=\"ACL2____MONITOR\">monitor</see></tt> and <v>:</v><tt><see topic=\"ACL2____UNMONITOR\">unmonitor</see></tt> as noted above.  For \u000A example, you might want to <see topic=\"ACL2____MONITOR\">monitor</see> a certain rule, say \u000A <v>hyp-reliever</v>, just when it is being used while attempting to apply \u000A another rule, say <v>main-lemma</v>.  Typically then you would <see topic=\"ACL2____MONITOR\">monitor</see> \u000A <v>main-lemma</v> at the ACL2 top-level, start the proof-attempt, and then in \u000A the break-rewrite in which <v>main-lemma</v> is about to be tried, you would \u000A install a <see topic=\"ACL2____MONITOR\">monitor</see> on <v>hyp-reliever</v>.  If during the ensuing \u000A <v>:eval</v> <v>hyp-reliever</v> is broken you will know it is being used under \u000A the attempt to apply <v>main-lemma</v>.</p> \u000A \u000A <p>However, once <v>hyp-reliever</v> is being <see topic=\"ACL2____MONITOR\">monitor</see>ed it will be <see topic=\"ACL2____MONITOR\">monitor</see>ed even after <v>main-lemma</v> has been tried.  That is, if you let the \u000A proof attempt proceed then you may see many other breaks on <v>hyp-reliever</v>, \u000A breaks that are not ``under'' the attempt to apply <v>main-lemma</v>.  One way \u000A to prevent this is to <v>:eval</v> the application of <v>main-lemma</v> and then \u000A <v>:</v><tt><see topic=\"ACL2____UNMONITOR\">unmonitor</see></tt> <v>hyp-reliever</v> before exiting.  But this case \u000A arises so often that ACL2 supports several additional ``flavors'' of proceed \u000A commands.</p> \u000A \u000A <p><v>:Ok!</v>, <v>:go!</v>, and <v>:eval!</v> are just like their counterparts \u000A (<v>:ok</v>, <v>:go</v>, and <v>:eval</v>, respectively), except that while \u000A processing the rule that is currently broken no <see topic=\"ACL2____RUNE\">rune</see>s are <see topic=\"ACL2____MONITOR\">monitor</see>ed.  When consideration of the current rule is complete, the set of \u000A <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s is restored to its original setting.</p> \u000A \u000A <p><v>:Ok$</v>, <v>:go$</v>, and <v>:eval$</v> are similar but take an additional \u000A argument which must be a list of <see topic=\"ACL2____RUNE\">rune</see>s.  An example usage of \u000A <v>:eval$</v> is</p> \u000A \u000A <code>3 ACL2 !&gt;:eval$ ((:rewrite hyp-reliever))</code> \u000A \u000A <p>These three commands temporarily install unconditional breaks on the <see topic=\"ACL2____RUNE\">rune</see>s listed, proceed with the consideration of the currently broken rule, \u000A and then restore the set of <see topic=\"ACL2____MONITOR\">monitor</see>ed rules to its original \u000A setting.</p> \u000A \u000A <p>Thus, there are nine ways to proceed from the initial entry into \u000A break-rewrite although we often speak as though there are two, <v>:ok</v> and \u000A <v>:eval</v>, and leave the others implicit.  We group <v>:go</v> with <v>:ok</v> \u000A because in all their flavors they exit break-rewrite without further \u000A interaction (at the current level).  All the flavors of <v>:eval</v> require \u000A further interaction after the rule has been tried.</p> \u000A \u000A <p>To abort a proof attempt and return to the top-level of ACL2 you may at any \u000A time type <v>(<see topic=\"ACL2____A_12\">a!</see>)</v> followed by a carriage return.  If you are not in a raw \u000A Lisp break, you may type <v>:a!</v> instead.  The utility <v>p!</v> is completely \u000A analogous to <v>a!</v> except that it pops up only one <tt><see topic=\"ACL2____LD\">ld</see></tt> level.  If you \u000A have just entered the break-rewrite loop, this will pop you out of that loop, \u000A back to the proof.  See <see topic=\"ACL2____A_12\">a!</see> and see <see topic=\"ACL2____P_12\">p!</see>.</p> \u000A \u000A <p>We now address ourselves to the post-<v>:eval</v> interaction with \u000A break-rewrite.  As noted, that interaction begins with break-rewrite's report \u000A on the results of applying the rule: whether it worked and either what it \u000A produced or why it failed.  This information is also printed by certain \u000A keyword commands available after <v>:eval</v>, namely <v>:wonp</v>, \u000A <v>:rewritten-rhs</v> or (for <see topic=\"ACL2____LINEAR\">linear</see> rules) <v>:poly-list</v>, and \u000A <v>:failure-reason</v>.  In addition, by using <tt><see topic=\"ACL2____BRR_04\">brr@</see></tt> you can obtain this \u000A information in the form of ACL2 data objects.  This allows the development of \u000A more sophisticated ``break conditions''; see <see topic=\"ACL2____MONITOR\">monitor</see> for examples.  In \u000A this connection we point out the macro form <v>(<see topic=\"ACL2____OK-IF\">ok-if</see> term)</v>.  See <see topic=\"ACL2____OK-IF\">ok-if</see>.  This command exits break-rewrite if <v>term</v> evaluates to \u000A non-<v>nil</v> and otherwise does not exit.  Thus it is possible to define \u000A macros that provide other kinds of exits from break-rewrite.  The only way to \u000A exit break-rewrite after <v>:eval</v> is <v>:ok</v> (or, equivalently, the use of \u000A <tt><see topic=\"ACL2____OK-IF\">ok-if</see></tt>).</p> \u000A \u000A <p>ACL2 users who wish to know more about break-rewrite so that they can \u000A develop more convenient ways to <see topic=\"ACL2____MONITOR\">monitor</see> rules are encouraged to speak \u000A to J Moore.</p> \u000A \u000A <p>The rest of this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> discusses a few implementation \u000A details of break-rewrite and may not be interesting to the typical user.</p> \u000A \u000A <p>There is no ACL2 function named break-rewrite.  It is an illusion created \u000A by appropriate calls to two functions named <v>brkpt1</v> and <v>brkpt2</v>.  As \u000A previously noted, break-rewrite is <tt><see topic=\"ACL2____LD\">ld</see></tt> operating on a <see topic=\"ACL2____WORMHOLE\">wormhole</see> \u000A <see topic=\"ACL2____STATE\">state</see>.  One might therefore wonder how break-rewrite can apply a rule \u000A and then communicate the results back to the rewriter running in the external \u000A <see topic=\"ACL2____STATE\">state</see>.  The answer is that it cannot.  Nothing can be communicated \u000A through a <see topic=\"ACL2____WORMHOLE\">wormhole</see>.  In fact, <v>brkpt1</v> and <v>brkpt2</v> are each \u000A calls of <tt><see topic=\"ACL2____LD\">ld</see></tt> running on <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>s.  <v>Brkpt1</v> \u000A implements the pre-<v>:eval</v> break-rewrite and <v>brkpt2</v> implements the \u000A post-<v>:eval</v> break-rewrite.  The rewriter actually calls <v>brkpt1</v> before \u000A attempting to apply a rule and calls <v>brkpt2</v> afterwards.  In both cases, \u000A the rewriter passes into the <see topic=\"ACL2____WORMHOLE\">wormhole</see> the relevant information about \u000A the current context.  Logically <v>brkpt1</v> and <v>brkpt2</v> are no-ops and \u000A <tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> ignores the <v>nil</v> they return.  But while control is in \u000A them, the execution of <tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> is suspended and cannot proceed until \u000A the break-rewrite interactions complete.</p> \u000A \u000A <p>This design causes a certain anomoly that might be troubling.  Suppose that \u000A inside break-rewrite before <v>:evaling</v> a rule (i.e., in the <v>brkpt1</v> \u000A <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>) you define some function, <v>foo</v>.  Suppose \u000A then you <v>:eval</v> the rule and eventually control returns to break-rewrite \u000A (i.e., to <v>brkpt2</v> on a <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see> with the results of \u000A the application in it).  You will discover that <v>foo</v> is no longer defined! \u000A That is because the <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see> created during your \u000A <v>pre-:eval</v> interaction is lost when we exit the <see topic=\"ACL2____WORMHOLE\">wormhole</see> to resume \u000A the proof attempt.  The post-<v>:eval</v> <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see> is in \u000A fact identical to the initial pre-<v>:eval</v> <see topic=\"ACL2____STATE\">state</see> (except for the \u000A results of the application) because <tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> did not change the \u000A external <see topic=\"ACL2____STATE\">state</see> and both <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>s are copies of it. \u000A A similar issue occurs with the use of <see topic=\"COMMON-LISP____TRACE\">trace</see> utilities: all effects of \u000A calling <tt><see topic=\"ACL2____TRACE_42\">trace$</see></tt> and <tt><see topic=\"ACL2____UNTRACE_42\">untrace$</see></tt> are erased when you proceed from a \u000A break in the break-rewrite loop.</p> \u000A \u000A <p>There is a lot more to know about break-rewrite, most of which is fairly \u000A easy to learn from looking at the code, since it is all expressed in ACL2. \u000A Feel free to ask questions of J Moore.</p>"],

 "ACL2____ARRAYS":[["Programming"],"ACL2 Sources","ACL2","<p>Below we begin a detailed presentation of ACL2 arrays.  ACL2's \u000A single-threaded objects (see <see topic=\"ACL2____STOBJ\">stobj</see>) provide a similar functionality \u000A that is generally more efficient when there are updates (writes), but is also \u000A more restrictive.</p> \u000A \u000A <p>See <see topic=\"ACL2____ARRAYS-EXAMPLE\">arrays-example</see> for a brief introduction illustrating the use of \u000A ACL2 arrays.</p> \u000A \u000A <p>ACL2 provides relatively efficient 1- and 2-dimensional arrays.  Arrays are \u000A awkward to provide efficiently in an applicative language because the \u000A programmer rightly expects to be able to ``modify'' an array object with the \u000A effect of changing the behavior of the element accessing function on that \u000A object.  This, of course, does not make any sense in an applicative setting. \u000A The element accessing function is, after all, a function, and its behavior on \u000A a given object is immutable.  To ``modify'' an array object in an applicative \u000A setting we must actually produce a new array object.  Arranging for this to be \u000A done efficiently is a challenge to the implementors of the language.  In \u000A addition, the programmer accustomed to the von Neumann view of arrays must \u000A learn how to use immutable applicative arrays efficiently.</p> \u000A \u000A <p>In this note we explain 1-dimensional arrays.  In particular, we explain \u000A briefly how to create, access, and ``modify'' them, how they are implemented, \u000A and how to program with them.  2-dimensional arrays are dealt with by \u000A analogy.</p> \u000A \u000A <p><i>The Logical Description of ACL2 Arrays</i></p> \u000A \u000A <p>An ACL2 1-dimensional array is an object that associates arbitrary objects \u000A with certain integers, called ``indices.'' Every array has a dimension, \u000A <v>dim</v>, which is a positive integer.  The indices of an array are the \u000A consecutive integers from <v>0</v> through <v>dim-1</v>.  To obtain the object \u000A associated with the index <v>i</v> in an array <v>a</v>, one uses <v>(<see topic=\"ACL2____AREF1\">aref1</see> name a\u000A i)</v>.  <v>Name</v> is a symbol that is irrelevant to the semantics of <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> but affects the speed with which it computes.  We will talk more about \u000A array ``names'' later.  To produce a new array object that is like <v>a</v> but \u000A which associates <v>val</v> with index <v>i</v>, one uses <v>(<see topic=\"ACL2____ASET1\">aset1</see> name a i\u000A val)</v>.</p> \u000A \u000A <p>An ACL2 1-dimensional array is actually an alist.  There is no special ACL2 \u000A function for creating arrays; they are generally built with the standard list \u000A processing functions <tt><see topic=\"COMMON-LISP____LIST\">list</see></tt> and <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt>.  However, there is a \u000A special ACL2 function, called <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>, for speeding up access to the \u000A elements of such an alist.  We discuss <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> later.</p> \u000A \u000A <p>One element of the alist must be the ``header'' of the array.  The <see topic=\"ACL2____HEADER\">header</see> of a 1-dimensional array with dimension <v>dim</v> is of the form:</p> \u000A \u000A <code>(:HEADER :DIMENSIONS (dim)\u000A         :MAXIMUM-LENGTH max\u000A         :DEFAULT obj ; optional\u000A         :NAME name   ; optional\u000A         :ORDER order ; optional values are &lt; (<see topic=\"COMMON-LISP____THE\">the</see> default), &gt;, or :none/nil\u000A         ).</code> \u000A \u000A <p><v>Obj</v> may be any object and is called the ``default value'' of the \u000A array.  <tt><see topic=\"COMMON-LISP____MAX\">Max</see></tt> must be an integer greater than <v>dim</v>.  <v>Name</v> must \u000A be a symbol.  The <v>:</v><tt><see topic=\"ACL2____DEFAULT\">default</see></tt> and <v>:name</v> entries are optional; \u000A if <v>:</v><tt><see topic=\"ACL2____DEFAULT\">default</see></tt> is omitted, the default value is <v>nil</v>.  The \u000A function <tt><see topic=\"ACL2____HEADER\">header</see></tt>, when given a name and a 1- or 2-dimensional array, \u000A returns the <see topic=\"ACL2____HEADER\">header</see> of the array.  The functions <tt><see topic=\"ACL2____DIMENSIONS\">dimensions</see></tt>, \u000A <tt><see topic=\"ACL2____MAXIMUM-LENGTH\">maximum-length</see></tt>, and <tt><see topic=\"ACL2____DEFAULT\">default</see></tt> are similar and return the \u000A corresponding fields of the <see topic=\"ACL2____HEADER\">header</see> of the array.  The role of the \u000A <v>:</v><tt><see topic=\"ACL2____DIMENSIONS\">dimensions</see></tt> field is obvious: it specifies the legal indices into \u000A the array.  The roles played by the <v>:</v><tt><see topic=\"ACL2____MAXIMUM-LENGTH\">maximum-length</see></tt> and \u000A <v>:</v><tt><see topic=\"ACL2____DEFAULT\">default</see></tt> fields are described below.</p> \u000A \u000A <p>Aside from the <see topic=\"ACL2____HEADER\">header</see>, the other elements of the alist must each be \u000A of the form <v>(i . val)</v>, where <v>i</v> is an integer and <v>0 &lt;= i &lt; dim</v>, \u000A and <v>val</v> is an arbitrary object.</p> \u000A \u000A <p>The <v>:order</v> field of the header is ignored for 2-dimensional arrays. \u000A For 1-dimensional arrays, it specifies the order of keys (<v>i</v>, above) when \u000A the array is compressed as with <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>, as described below.  An \u000A <v>:order</v> of <v>:none</v> or <v>nil</v> specifies no reordering of the alist by \u000A <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>, and an order of <v>&gt;</v> specifies reordering by <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> so that keys are in descending order.  Otherwise, the alist is \u000A reordered by <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> so that keys are in ascending order.</p> \u000A \u000A <p><v>(<see topic=\"ACL2____AREF1\">Aref1</see> name a i)</v> is <see topic=\"ACL2____GUARD\">guard</see>ed so that <v>name</v> must be a symbol, \u000A <v>a</v> must be an array and <v>i</v> must be an index into <v>a</v>.  The value of \u000A <v>(<see topic=\"ACL2____AREF1\">aref1</see> name a i)</v> is either <v>(<see topic=\"COMMON-LISP____CDR\">cdr</see> (<see topic=\"COMMON-LISP____ASSOC\">assoc</see> i a))</v> or else is the default \u000A value of <v>a</v>, depending on whether there is a pair in <v>a</v> whose <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is <v>i</v>.  Note that <v>name</v> is irrelevant to the value of an <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> expression.  You might <v>:pe aref1</v> to see how simple the definition \u000A is.</p> \u000A \u000A <p><v>(<see topic=\"ACL2____ASET1\">Aset1</see> name a i val)</v> is <see topic=\"ACL2____GUARD\">guard</see>ed analogously to the <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> expression.  The value of the <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> expression is essentially \u000A <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> i val) a)</v>.  Again, <v>name</v> is irrelevant.  Note <v>(<see topic=\"ACL2____ASET1\">aset1</see>\u000A name a i val)</v> is an array, <v>a'</v>, with the property that <v>(<see topic=\"ACL2____AREF1\">aref1</see> name a'\u000A i)</v> is <v>val</v> and, except for index <v>i</v>, all other indices into <v>a'</v> \u000A produce the same value as in <v>a</v>.  Note also that if <v>a</v> is viewed as an \u000A alist (which it is) the pair ``binding'' <v>i</v> to its old value is in <v>a'</v> \u000A but ``covered up'' by the new pair.  Thus, the length of an array grows by one \u000A when <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> is done.</p> \u000A \u000A <p>Because <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> covers old values with new ones, an array produced by \u000A a sequence of <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> calls may have many irrelevant pairs in it.  The \u000A function <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> can remove these irrelevant pairs.  Thus, \u000A <v>(<see topic=\"ACL2____COMPRESS1\">compress1</see> name a)</v> returns an array that is equivalent (vis-a-vis <tt><see topic=\"ACL2____AREF1\">aref1</see></tt>) to <v>a</v> but which may be shorter.  For technical reasons, the alist \u000A returned by <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> may also list the pairs in a different order \u000A than listed in <v>a</v>.</p> \u000A \u000A <p>To prevent arrays from growing excessively long due to repeated <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> operations, <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> actually calls <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> on the new \u000A alist whenever the length of the new alist exceeds the <v>:</v><tt><see topic=\"ACL2____MAXIMUM-LENGTH\">maximum-length</see></tt> entry, <tt><see topic=\"COMMON-LISP____MAX\">max</see></tt>, in the <see topic=\"ACL2____HEADER\">header</see> of the array.  See \u000A the definition of <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> (for example by using <v>:</v><tt><see topic=\"ACL2____PE\">pe</see></tt>).  This \u000A is primarily just a mechanism for freeing up <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> space consumed while \u000A doing <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> operations.  Note however that this <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> call \u000A is replaced by a hard error if the header specifies an <v>:order</v> of \u000A <v>:none</v> or <v>nil</v>.</p> \u000A \u000A <p>This completes the logical description of 1-dimensional arrays. \u000A 2-dimensional arrays are analogous.  The <v>:</v><tt><see topic=\"ACL2____DIMENSIONS\">dimensions</see></tt> entry of the \u000A <see topic=\"ACL2____HEADER\">header</see> of a 2-dimensional array should be <v>(dim1 dim2)</v>.  A pair of \u000A indices, <v>i</v> and <v>j</v>, is legal iff <v>0 &lt;= i &lt; dim1</v> and <v>0 &lt;= j &lt;\u000A dim2</v>.  The <v>:</v><tt><see topic=\"ACL2____MAXIMUM-LENGTH\">maximum-length</see></tt> must be greater than <v>dim1*dim2</v>. \u000A <tt><see topic=\"ACL2____AREF2\">Aref2</see></tt>, <tt><see topic=\"ACL2____ASET2\">aset2</see></tt>, and <tt><see topic=\"ACL2____COMPRESS2\">compress2</see></tt> are like their \u000A counterparts but take an additional <v>index</v> argument.  Finally, the pairs \u000A in a 2-dimensional array are of the form <v>((i . j) . val)</v>.</p> \u000A \u000A <p><i>The Implementation of ACL2 Arrays</i></p> \u000A \u000A <p>Very informally speaking, the function <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> ``creates'' an \u000A ACL2 array that provides fast access, while the function <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> \u000A ``maintains'' fast access.  We now describe this informal idea more \u000A carefully.</p> \u000A \u000A <p><tt><see topic=\"ACL2____AREF1\">Aref1</see></tt> is essentially <tt><see topic=\"COMMON-LISP____ASSOC\">assoc</see></tt>.  If <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> were \u000A implemented naively the time taken to access an array element would be linear \u000A in the dimension of the array and the number of ``assignments'' to it (the \u000A number of <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> calls done to create the array from the initial \u000A alist).  This is intolerable; arrays are ``supposed'' to provide constant-time \u000A access and change.</p> \u000A \u000A <p>The apparently irrelevant names associated with ACL2 arrays allow us to \u000A provide constant-time access and change when arrays are used in \u000A ``conventional'' ways.  The implementation of arrays makes it clear what we \u000A mean by ``conventional.''</p> \u000A \u000A <p>Recall that array names are symbols.  Behind the scenes, ACL2 associates \u000A two objects with each ACL2 array name.  The first object is called the \u000A ``semantic value'' of the name and is an alist.  The second object is called \u000A the ``raw lisp array'' and is a Common Lisp array.</p> \u000A \u000A <p>When <v>(<see topic=\"ACL2____COMPRESS1\">compress1</see> name alist)</v> builds a new alist, <v>a'</v>, it sets the \u000A semantic value of <v>name</v> to that new alist.  Furthermore, it creates a \u000A Common Lisp array and writes into it all of the index/value pairs of <v>a'</v>, \u000A initializing unassigned indices with the default value.  This array becomes \u000A the raw lisp array of <v>name</v>.  <tt><see topic=\"ACL2____COMPRESS1\">Compress1</see></tt> then returns <v>a'</v>, the \u000A semantic value, as its result, as required by the definition of <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>.</p> \u000A \u000A <p>When <v>(<see topic=\"ACL2____AREF1\">aref1</see> name a i)</v> is invoked, <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> first determines \u000A whether the semantic value of <v>name</v> is <v>a</v> (i.e., is <tt><see topic=\"COMMON-LISP____EQ\">eq</see></tt> to the \u000A alist <v>a</v>).  If so, <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> can determine the <v>i</v>th element of \u000A <v>a</v> by invoking Common Lisp's <v>aref</v> function on the raw lisp array \u000A associated with name.  Note that no linear search of the alist <v>a</v> is \u000A required; the operation is done in constant time and involves retrieval of two \u000A global variables, an <tt><see topic=\"COMMON-LISP____EQ\">eq</see></tt> test and <v>jump</v>, and a raw lisp array \u000A access.  In fact, an ACL2 array access of this sort is about 5 times slower \u000A than a C array access.  On the other hand, if <v>name</v> has no semantic value \u000A or if it is different from <v>a</v>, then <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> determines the answer by \u000A linear search of <v>a</v> as suggested by the <v>assoc-like</v> definition of \u000A <tt><see topic=\"ACL2____AREF1\">aref1</see></tt>.  Thus, <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> always returns the axiomatically specified \u000A result.  It returns in constant time if the array being accessed is the \u000A current semantic value of the name used.  The ramifications of this are \u000A discussed after we deal with <tt><see topic=\"ACL2____ASET1\">aset1</see></tt>.</p> \u000A \u000A <p>When <v>(<see topic=\"ACL2____ASET1\">aset1</see> name a i val)</v> is invoked, <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> does two <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt>es to create the new array.  Call that array <v>a'</v>.  It will be \u000A returned as the answer.  (In this discussion we ignore the case in which \u000A <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> does a <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>.)  However, before returning, <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> determines if <v>name</v>'s semantic value is <v>a</v>.  If so, it makes \u000A the new semantic value of <v>name</v> be <v>a'</v> and it smashes the raw lisp \u000A array of <v>name</v> with <v>val</v> at index <v>i</v>, before returning <v>a'</v> as \u000A the result.  Thus, after doing an <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> and obtaining a new semantic \u000A value <v>a'</v>, all <tt><see topic=\"ACL2____AREF1\">aref1</see></tt>s on that new array will be fast.  Any <tt><see topic=\"ACL2____AREF1\">aref1</see></tt>s on the old semantic value, <v>a</v>, will be slow.</p> \u000A \u000A <p>To understand the performance implications of this design, consider the \u000A chronological sequence in which ACL2 (Common Lisp) evaluates expressions: \u000A basically inner-most first, left-to-right, call-by-value.  An array use, such \u000A as <v>(<see topic=\"ACL2____AREF1\">aref1</see> name a i)</v>, is ``fast'' (constant-time) if the alist supplied, \u000A <v>a</v>, is the value returned by the most recently executed <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt> \u000A or <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> on the name supplied.  In the functional expression of \u000A ``conventional'' array processing, all uses of an array are fast.</p> \u000A \u000A <p>The <v>:name</v> field of the <see topic=\"ACL2____HEADER\">header</see> of an array is completely \u000A irrelevant.  Our convention is to store in that field the symbol we mean to \u000A use as the name of the raw lisp array.  But no ACL2 function inspects \u000A <v>:name</v> and its primary value is that it allows the user, by inspecting the \u000A semantic value of the array &mdash; the alist &mdash; to recall the name of \u000A the raw array that probably holds that value.  We say ``probably'' since there \u000A is no enforcement that the alist was compressed under the name in the <see topic=\"ACL2____HEADER\">header</see> or that all <v>aset</v>s used that name.  Such enforcement would be \u000A inefficient.</p> \u000A \u000A <p><i>Some Programming Examples</i></p> \u000A \u000A <p>In the following examples we will use ACL2 ``global variables'' to hold \u000A several arrays.  See <see topic=\"ACL2_____04\">@</see>, and see <see topic=\"ACL2____ASSIGN\">assign</see>.</p> \u000A \u000A <p>Let the <tt><see topic=\"ACL2____STATE\">state</see></tt> global variable <v>a</v> be the 1-dimensional \u000A compressed array of dimension <v>5</v> constructed below.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSIGN\">assign</see> a (<see topic=\"ACL2____COMPRESS1\">compress1</see> 'demo\u000A                            '((:header :dimensions (5)\u000A                                       :maximum-length 15\u000A                                       :default uninitialized\u000A                                       :name demo)\u000A                              (0 . zero))))</code> \u000A \u000A <p>Then <v>(<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> a) 0)</v> is <v>zero</v> and <v>(<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> a) 1)</v> \u000A is <v>uninitialized</v>.</p> \u000A \u000A <p>Now execute</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSIGN\">assign</see> b (<see topic=\"ACL2____ASET1\">aset1</see> 'demo (<see topic=\"ACL2_____04\">@</see> a) 1 'one))</code> \u000A \u000A <p>Then <v>(<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 0)</v> is <v>zero</v> and <v>(<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 1)</v> \u000A is <v>one</v>.</p> \u000A \u000A <p>All of the <tt><see topic=\"ACL2____AREF1\">aref1</see></tt>s done so far have been ``fast.''</p> \u000A \u000A <p>Note that we now have two array objects, one in the global variable <v>a</v> \u000A and one in the global variable <v>b</v>.  <v>B</v> was obtained by assigning to \u000A <v>a</v>.  That assignment does not affect the alist <v>a</v> because this is an \u000A applicative language.  Thus, <v>(<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> a) 1)</v> must <b>still</b> be \u000A <v>uninitialized</v>.  And if you execute that expression in ACL2 you will see \u000A that indeed it is.  However, a rather ugly comment is printed, namely that \u000A this array access is ``slow.''  The reason it is slow is that the raw lisp \u000A array associated with the name <v>demo</v> is the array we are calling <v>b</v>. \u000A To access the elements of <v>a</v>, <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> must now do a linear search. \u000A Any reference to <v>a</v> as an array is now ``unconventional;'' in a \u000A conventional language like Ada or Common Lisp it would simply be impossible to \u000A refer to the value of the array before the assignment that produced our \u000A <v>b</v>.</p> \u000A \u000A <p>Now let us define a function that counts how many times a given object, \u000A <v>x</v>, occurs in an array.  For simplicity, we will pass in the name and \u000A highest index of the array:</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> cnt (<see topic=\"ACL2____NAME\">name</see> a i x)\u000A         (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard\u000A                         (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____ARRAY1P\">array1p</see> name a)\u000A                              (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> i)\u000A                              (<see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see> i -1)\u000A                              (<see topic=\"COMMON-LISP_____C3\">&lt;</see> i (<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"ACL2____DIMENSIONS\">dimensions</see> name a))))\u000A                         :mode :logic\u000A                         :measure (<see topic=\"ACL2____NFIX\">nfix</see> (<see topic=\"COMMON-LISP_____B2\">+</see> 1 i))))\u000A         (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"ACL2____ZP\">zp</see> (<see topic=\"COMMON-LISP____1_B2\">1+</see> i)) 0) ; return 0 if i is at most -1\u000A               ((<see topic=\"COMMON-LISP____EQUAL\">equal</see> x (<see topic=\"ACL2____AREF1\">aref1</see> name a i))\u000A                (<see topic=\"COMMON-LISP____1_B2\">1+</see> (cnt name a (<see topic=\"COMMON-LISP____1-\">1-</see> i) x)))\u000A               (t (cnt name a (<see topic=\"COMMON-LISP____1-\">1-</see> i) x))))</code> \u000A \u000A <p>To determine how many times <v>zero</v> appears in <v>(<see topic=\"ACL2_____04\">@</see> b)</v> we can \u000A execute:</p> \u000A \u000A <code>ACL2 !&gt;(cnt 'demo (<see topic=\"ACL2_____04\">@</see> b) 4 'zero)</code> \u000A \u000A <p>The answer is <v>1</v>.  How many times does <v>uninitialized</v> appear in \u000A <v>(<see topic=\"ACL2_____04\">@</see> b)</v>?</p> \u000A \u000A <code>ACL2 !&gt;(cnt 'demo (<see topic=\"ACL2_____04\">@</see> b) 4 'uninitialized)</code> \u000A \u000A <p>The answer is <v>3</v>, because positions <v>2</v>, <v>3</v> and <v>4</v> of the \u000A array contain that default value.</p> \u000A \u000A <p>Now imagine that we want to assign <v>'two</v> to index <v>2</v> and then count \u000A how many times the 2nd element of the array occurs in the array.  This \u000A specification is actually ambiguous.  In assigning to <v>b</v> we produce a new \u000A array, which we might call <v>c</v>.  Do we mean to count the occurrences in \u000A <v>c</v> of the 2nd element of <v>b</v> or the 2nd element of <v>c</v>?  That is, do \u000A we count the occurrences of <v>uninitialized</v> or the occurrences of <v>two</v>? \u000A If we mean the former the correct answer is <v>2</v> (positions <v>3</v> and \u000A <v>4</v> are <v>uninitialized</v> in <v>c</v>); if we mean the latter, the correct \u000A answer is <v>1</v> (there is only one occurrence of <v>two</v> in <v>c</v>).</p> \u000A \u000A <p>Below are ACL2 renderings of the two meanings, which we call <v>[former]</v> \u000A and <v>[latter]</v>.  (Warning: Our description of these examples, and of an \u000A example <v>[fast former]</v> that follows, assumes that only one of these three \u000A examples is actually executed; for example, they are not executed in sequence. \u000A See ``A Word of Warning'' below for more about this issue.)</p> \u000A \u000A <code>(cnt 'demo (<see topic=\"ACL2____ASET1\">aset1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 2 'two) 4 (<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 2))  ; [former]\u000A\u000A(<see topic=\"COMMON-LISP____LET\">let</see> ((c (<see topic=\"ACL2____ASET1\">aset1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 2 'two)))                           ; [latter]\u000A  (cnt 'demo c 4 (<see topic=\"ACL2____AREF1\">aref1</see> 'demo c 2)))</code> \u000A \u000A <p>Note that in <v>[former]</v> we create <v>c</v> in the second argument of the \u000A call to <v>cnt</v> (although we do not give it a name) and then refer to <v>b</v> \u000A in the fourth argument.  This is unconventional because the second reference \u000A to <v>b</v> in <v>[former]</v> is no longer the semantic value of <v>demo</v>. \u000A While ACL2 computes the correct answer, namely <v>2</v>, the execution of the \u000A <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> expression in <v>[former]</v> is done slowly.</p> \u000A \u000A <p>A conventional rendering with the same meaning is</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((x (<see topic=\"ACL2____AREF1\">aref1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 2)))                           ; [fast former]\u000A  (cnt 'demo (<see topic=\"ACL2____ASET1\">aset1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b) 2 'two) 4 x))</code> \u000A \u000A <p>which fetches the 2nd element of <v>b</v> before creating <v>c</v> by \u000A assignment.  It is important to understand that <v>[former]</v> and <v>[fast\u000A former]</v> mean exactly the same thing: both count the number of occurrences of \u000A <v>uninitialized</v> in <v>c</v>.  Both are legal ACL2 and both compute the same \u000A answer, <v>2</v>.  Indeed, we can symbolically transform <v>[fast former]</v> into \u000A <v>[former]</v> merely by substituting the binding of <v>x</v> for <v>x</v> in the \u000A body of the <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>.  But <v>[fast former]</v> can be evaluated faster than \u000A <v>[former]</v> because all of the references to <v>demo</v> use the then-current \u000A semantic value of <v>demo</v>, which is <v>b</v> in the first line and <v>c</v> \u000A throughout the execution of the <v>cnt</v> in the second line.  <v>[Fast\u000A former]</v> is the preferred form, both because of its execution speed and its \u000A clarity.  If you were writing in a conventional language you would have to \u000A write something like <v>[fast former]</v> because there is no way to refer to \u000A the 2nd element of the old value of <v>b</v> after smashing <v>b</v> unless it had \u000A been saved first.</p> \u000A \u000A <p>We turn now to <v>[latter]</v>.  It is both clear and efficient.  It creates \u000A <v>c</v> by assignment to <v>b</v> and then it fetches the 2nd element of <v>c</v>, \u000A <v>two</v>, and proceeds to count the number of occurrences in <v>c</v>.  The \u000A answer is <v>1</v>.  <v>[Latter]</v> is a good example of typical ACL2 array \u000A manipulation: after the assignment to <v>b</v> that creates <v>c</v>, <v>c</v> is \u000A used throughout.</p> \u000A \u000A <p>It takes a while to get used to this because most of us have grown \u000A accustomed to the peculiar semantics of arrays in conventional languages.  For \u000A example, in raw lisp we might have written something like the following, \u000A treating <v>b</v> as a ``global variable'':</p> \u000A \u000A <code>(cnt 'demo (aset 'demo b 2 'two) 4 (aref 'demo b 2))</code> \u000A \u000A <p>which sort of resembles <v>[former]</v> but actually has the semantics of \u000A <v>[latter]</v> because the <v>b</v> from which <v>aref</v> fetches the 2nd element \u000A is not the same <v>b</v> used in the <v>aset</v>!  The array <v>b</v> is destroyed \u000A by the <v>aset</v> and <v>b</v> henceforth refers to the array produced by the \u000A <v>aset</v>, as written more clearly in <v>[latter]</v>.</p> \u000A \u000A <p>A Word of Warning: Users must exercise care when experimenting with \u000A <v>[former]</v>, <v>[latter]</v> and <v>[fast former]</v>.  Suppose you have just \u000A created <v>b</v> with the assignment shown above,</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSIGN\">assign</see> b (<see topic=\"ACL2____ASET1\">aset1</see> 'demo (<see topic=\"ACL2_____04\">@</see> a) 1 'one))</code> \u000A \u000A <p>If you then evaluate <v>[former]</v> in ACL2 it will complain that the <tt><see topic=\"ACL2____AREF1\">aref1</see></tt> is slow and compute the answer, as discussed.  Then suppose you \u000A evaluate <v>[latter]</v> in ACL2.  From our discussion you might expect it to \u000A execute fast &mdash; i.e., issue no complaint.  But in fact you will find that \u000A it complains repeatedly.  The problem is that the evaluation of <v>[former]</v> \u000A changed the semantic value of <v>demo</v> so that it is no longer <v>b</v>.  To \u000A try the experiment correctly you must make <v>b</v> be the semantic value of \u000A <v>demo</v> again before the next example is evaluated.  One way to do that is \u000A to execute</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSIGN\">assign</see> b (<see topic=\"ACL2____COMPRESS1\">compress1</see> 'demo (<see topic=\"ACL2_____04\">@</see> b)))</code> \u000A \u000A <p>before each expression.  Because of issues like this it is often hard to \u000A experiment with ACL2 arrays at the top-level.  We find it easier to write \u000A functions that use arrays correctly and efficiently than to so use them \u000A interactively.</p> \u000A \u000A <p>This last assignment also illustrates a very common use of <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>.  While it was introduced as a means of removing irrelevant pairs \u000A from an array built up by repeated assignments, it is actually most useful as \u000A a way of insuring fast access to the elements of an array.</p> \u000A \u000A <p>Many array processing tasks can be divided into two parts.  During the \u000A first part the array is built.  During the second part the array is used \u000A extensively but not modified.  If your <see topic=\"ACL2____PROGRAMMING\">programming</see> task can be so \u000A divided, it might be appropriate to construct the array entirely with list \u000A processing, thereby saving the cost of maintaining the semantic value of the \u000A name while few references are being made.  Once the alist has stabilized, it \u000A might be worthwhile to treat it as an array by calling <tt><see topic=\"ACL2____COMPRESS1\">compress1</see></tt>, \u000A thereby gaining constant time access to it.</p> \u000A \u000A <p>ACL2's theorem prover uses this technique in connection with its \u000A implementation of the notion of whether a <see topic=\"ACL2____RUNE\">rune</see> is <see topic=\"ACL2____DISABLE\">disable</see>d or \u000A not.  Associated with every <see topic=\"ACL2____RUNE\">rune</see> is a unique integer <v>index</v>, called \u000A its ``nume.''  When each rule is stored, the corresponding nume is stored as a \u000A component of the rule.  <see topic=\"ACL2____THEORIES\">Theories</see> are lists of <see topic=\"ACL2____RUNE\">rune</see>s and \u000A membership in the ``current theory'' indicates that the corresponding rule is \u000A <see topic=\"ACL2____ENABLE\">enable</see>d.  But these lists are very long and membership is a linear-time \u000A operation.  So just before a proof begins we map the list of <see topic=\"ACL2____RUNE\">rune</see>s in \u000A the current theory into an alist that pairs the corresponding numes with \u000A <v>t</v>.  Then we compress this alist into an array.  Thus, given a rule we can \u000A obtain its nume (because it is a component) and then determine in constant \u000A time whether it is <see topic=\"ACL2____ENABLE\">enable</see>d.  The array is never modified during the \u000A proof, i.e., <tt><see topic=\"ACL2____ASET1\">aset1</see></tt> is never used in this example.  From the logical \u000A perspective this code looks quite odd: we have replaced a linear-time \u000A membership test with an apparently linear-time <tt><see topic=\"COMMON-LISP____ASSOC\">assoc</see></tt> after going to \u000A the trouble of mapping from a list of <see topic=\"ACL2____RUNE\">rune</see>s to an alist of numes.  But \u000A because the alist of numes is an array, the ``apparently linear-time <tt><see topic=\"COMMON-LISP____ASSOC\">assoc</see></tt>'' is more apparent than real; the operation is constant-time.</p>"],

 "ACL2____MEMOIZE":[["Programming","Hons-and-memoization","Events"],"ACL2 Sources","ACL2","<p>This <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic relates to <see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> ACL2 \u000A executables, which are built by default.  See <see topic=\"ACL2____HONS-AND-MEMOIZATION\">hons-and-memoization</see> for \u000A a general discussion of memoization and the related features of hash consing \u000A and applicative hash tables.</p> \u000A \u000A <code>Examples:\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo)                      ; remember the values of calls\u000A                                    ;   of foo\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :condition t)         ; same as above\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :condition '(test x)) ; memoize for args satisfying\u000A                                    ;   the given condition\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :condition-fn 'test)  ; memoize for args satisfying\u000A                                    ;   a call of the given function\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :recursive nil)       ; don't memoize recursive calls\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :aokp t)              ; attachments OK for stored results\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :stats nil)           ; don't collect info for (<see topic=\"ACL2____MEMSUM\">memsum</see>)\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'foo :ideal-okp t)         ; memoize for raw Lisp even if foo is\u000A                                    ;   in :logic but not guard-verified\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____MEMOIZE\">memoize</see> fn                         ; memoizes fn and returns fn\u000A         :condition    condition    ; optional (<see topic=\"ACL2____DEFAULT\">default</see> t)\u000A         :condition-fn condition-fn ; optional\u000A         :hints        hints        ; optional, for verifying the\u000A                                    ;   guards of condition-fn\u000A         :otf-flg      otf-flg      ; optional, for verifying the\u000A                                    ;   guards of condition-fn\u000A         :recursive    t/nil        ; optional (<see topic=\"ACL2____DEFAULT\">default</see> t)\u000A         :commutative  t/lemma-name ; optional (<see topic=\"ACL2____DEFAULT\">default</see> nil)\u000A         :forget       t/nil        ; optional (<see topic=\"ACL2____DEFAULT\">default</see> nil)\u000A         :memo-table-init-size size ; optional (<see topic=\"ACL2____DEFAULT\">default</see> *mht-default-size*)\u000A         :aokp         t/nil        ; optional (<see topic=\"ACL2____DEFAULT\">default</see> nil)\u000A         :stats        t/nil        ; optional (<see topic=\"ACL2____DEFAULT\">default</see> t)\u000A         :ideal-okp    t/:warn/nil  ; optional (<see topic=\"ACL2____DEFAULT\">default</see> nil)\u000A         :verbose      t/nil        ; optional (<see topic=\"ACL2____DEFAULT\">default</see> t)\u000A         )</code> \u000A \u000A <p>where <v>fn</v> evaluates to a user-defined function symbol; <v>condition</v> \u000A is either <v>t</v> (the default), <v>'t</v>, <v>nil</v>, or <v>'nil</v>, or else \u000A evaluates to an expression whose free variables are among the formal \u000A parameters of <v>fn</v>; and <v>condition-fn</v> is either <v>nil</v> (the default) \u000A or else evaluates to a legal function symbol.  Further restrictions and \u000A options are discussed below.  Note that all arguments are evaluated (but for \u000A the special handling of value <v>t</v> for <v>:commutative</v>, the argument must \u000A literally be <v>t</v>; see below).</p> \u000A \u000A <p>Generally <v>fn</v> must evaluate to a defined function symbol.  However, \u000A this value can be the name of a macro that is associated with such a function \u000A symbol; see <see topic=\"ACL2____MACRO-ALIASES-TABLE\">macro-aliases-table</see>.  That associated function symbol is \u000A the one called ``memoized'' in the discussion below, but we make no more \u000A mention of this subtlety.</p> \u000A \u000A <p>In the most common case, <v>memoize</v> takes a single argument, which \u000A evaluates to a function symbol.  We call this function symbol the ``memoized \u000A function'' because ``memos'' are saved and re-used, in the following sense. \u000A When a call of the memoized function is evaluated, the result is ``memoized'' \u000A by associating the call's arguments with that result, in a suitable table. \u000A But first an attempt is made to avoid such evaluation, by doing a lookup in \u000A that table on the given arguments for the result, as stored for a previous \u000A call on those arguments.  If such a result is found, then it is returned \u000A without further computation.  This paragraph also applies if <v>:condition</v> \u000A is supplied but is <v>t</v> or <v>'t</v>.</p> \u000A \u000A <p>If keyword argument <v>:condition-fn</v> is supplied, but <v>:condition</v> is \u000A not, then the result of evaluating <v>:condition-fn</v> must be a defined \u000A function symbol whose formal parameter list and <tt><see topic=\"ACL2____GUARD\">guard</see></tt> are the same as \u000A for the function being memoized.  If <v>fn</v> is in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode, \u000A then <see topic=\"ACL2____GUARD\">guard</see>s must have been verified for <v>:condition-fn</v>.  Such a \u000A ``condition function'' will be run whenever the memoized function is called, \u000A on the same parameters, and the lookup or table store described above are only \u000A performed if the result from the condition function call is non-<v>nil</v>.</p> \u000A \u000A <p>Suppose however that <v>:condition</v> is supplied.  If the value supplied is \u000A <v>t</v> or <v>'t</v>, then the lookup and table store described above are always \u000A done.  If the value is <v>nil</v> or <v>'nil</v>, then this lookup and table store \u000A are never done, although statistics may be gathered; see <see topic=\"ACL2____PROFILE\">profile</see>.  Now \u000A consider other values for <v>:condition</v>.  An attempt will be made to define \u000A a condition function whose <see topic=\"ACL2____GUARD\">guard</see> and formal parameters list are the \u000A same as those of the memoized function, and whose body is the result, <v>r</v>, \u000A of evaluating the given <v>condition</v>.  The name of that condition function \u000A is the result of evaluating <v>:condition-fn</v> if supplied, else is the result \u000A of concatenating the string <v>&quot;-MEMOIZE-CONDITION&quot;</v> to the end of the name \u000A of the memoized function.  The condition function will be defined with <see topic=\"ACL2____GUARD\">guard</see> verification turned off, but that definition will be followed \u000A immediately by a <tt><see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see></tt> event; and this is where the optional \u000A <v>:hints</v> and <v>:otf-flg</v> are attached.  At evaluation time the condition \u000A function is used as described in the preceding paragraph; so in effect, the \u000A condition (<v>r</v>, above) is evaluated, with its variables bound to the \u000A corresponding actuals of the memoized function call, and the memoized function \u000A attempts a lookup or table store if and only if the result of that evaluation \u000A is non-<v>nil</v>.</p> \u000A \u000A <p>Note that <v>fn</v> can be either a <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode function or a \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function.  However, only the corresponding raw Lisp \u000A function is actually memoized, so <see topic=\"ACL2____GUARD\">guard</see> violations can defeat \u000A memoization, and <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode functions without their <see topic=\"ACL2____GUARD\">guard</see>s verified will only be memoized when called by <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> \u000A mode functions.  (See <see topic=\"ACL2____GUARDS-AND-EVALUATION\">guards-and-evaluation</see> for more information about \u000A guards and evaluation in ACL2.)  If <v>fn</v> is a <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode \u000A function and <v>:condition</v> is supplied and not <v>t</v> or <v>nil</v>, then the \u000A condition must be a <see topic=\"ACL2____GUARD\">guard</see>-verified function.</p> \u000A \u000A <p>Calls of this macro generate events of the form <v>(<see topic=\"ACL2____TABLE\">table</see> memoize-table fn\u000A ((:condition-fn fn) ...))</v>.  When successful, the returned value is of the \u000A form <v>(<see topic=\"ACL2____MV\">mv</see> nil function-symbol state)</v>.</p> \u000A \u000A <p>Suppose that a function is already memoized.  Then it is illegal to memoize \u000A that function.  Moreover, if the function was memoized with an associated \u000A condition (i.e., was memoized with keyword <v>:condition</v> or \u000A <v>:condition-fn</v> having value other than <v>t</v> or <v>nil</v>), then it is \u000A also illegal to convert the function from <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> to \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode (see <see topic=\"ACL2____VERIFY-TERMINATION\">verify-termination</see>).  To turn off \u000A memoization, see <see topic=\"ACL2____UNMEMOIZE\">unmemoize</see>.</p> \u000A \u000A <p><v>Memoize</v> is illegal for a function if its arguments include <tt><see topic=\"ACL2____STATE\">state</see></tt> or if it returns any <see topic=\"ACL2____STOBJ\">stobj</see>s.  A stobj can be an input of a \u000A memoized function, but in that case, the memoization table for that stobj will \u000A be cleared every time that stobj is updated.</p> \u000A \u000A <p>By default, <v>memoize</v> does not store results when any attachments have \u000A been used (see <see topic=\"ACL2____DEFATTACH\">defattach</see>).  However, such results are stored when \u000A <v>memoize</v> keyword parameter <v>:aokp</v> has value <v>t</v>.  Note that for \u000A purposes of this discussion, the use of a stored value for a subsidiary \u000A function that was memoized with <v>:aokp t</v> is treated as the use of an \u000A attachment, since ACL2 does not know whether or not an attachment was actually \u000A used in that case.</p> \u000A \u000A <p>We conclude with by documenting keyword parameters not discussed above.</p> \u000A \u000A <p>Keyword parameter <v>:recursive</v> is <v>t</v> by default, which means that \u000A recursive calls of <v>fn</v> will be memoized just as ``top-level'' calls of \u000A <v>fn</v>.  When <v>:recursive</v> is instead set to <v>nil</v>, memoization is only \u000A done at the top level.  Using <v>:recursive nil</v> is similar to writing a \u000A wrapper function that just calls <v>fn</v>, and memoizing the wrapper instead of \u000A <v>fn</v>.</p> \u000A \u000A <p>If <v>:trace</v> has a non-<v>nil</v> value, then <v>memoize</v> also traces in a \u000A traditional Lisp style.  If <v>:trace</v> has value <v>notinline</v> or \u000A <v>notinline</v>, then a corresponding declaration is added at the beginning of \u000A the new definition of <v>fn</v>.</p> \u000A \u000A <p>A non-<v>nil</v> value for <v>:commutative</v> can be supplied if <v>fn</v> is a \u000A binary function in <v>:logic</v> mode.  Suppose that the <v>memoize</v> event is \u000A successful, and consider a subsequent call of <v>fn</v> for which some argument \u000A to <v>fn</v> is either a rational number or, in some host Lisps (currently \u000A either CCL, or GCL Version 2.6.12 or later) a <see topic=\"ACL2____HONS\">hons</see>.  (Indeed, for such \u000A GCL versions this is true for any cons, not just a hons.)  Then when the \u000A evaluation of <v>fn</v> on those arguments is memoized, the evaluation of \u000A <v>fn</v> on the swap of those arguments is, in essence, also memoized.  If \u000A <v>:commutative</v> is supplied and is not <v>nil</v> or <v>t</v>, then it should be \u000A the name of a previously-proved theorem whose formula states the commutativity \u000A of <v>fn</v>, i.e., is the formula <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (fn x y) (fn y x))</v> for a pair \u000A <v>{x,y}</v> of distinct variables.  If <v>:commutative</v> is <v>t</v> &mdash; but \u000A not merely an expression that evaluates to <v>t</v> &mdash; then an attempt to \u000A prove such a lemma will be made on-the-fly.  The name of the lemma is the \u000A symbol in the same package as <v>fn</v>, obtained by adding the suffix \u000A <v>&quot;-COMMUTATIVE&quot;</v> to the <tt><see topic=\"COMMON-LISP____SYMBOL-NAME\">symbol-name</see></tt> of <v>fn</v>.  If the proof \u000A attempt fails, then you may want first to prove the lemma yourself with \u000A appropriate hints and perhaps supporting lemmas, and then supply the name of \u000A that lemma as the value of <v>:commutative</v>.</p> \u000A \u000A <p>If <v>:commutative</v> is supplied, and a non-commutative condition is \u000A provided by <v>:condition</v> or <v>:condition-fn</v>, then although the results \u000A will be correct, the extra memoization afforded by <v>:commutative</v> is \u000A unspecified.</p> \u000A \u000A <p>If <v>:memo-table-init-size</v> is supplied, then it should be a positive \u000A integer specifying the initial size of an associated hash table.</p> \u000A \u000A <p>Argument <v>:aokp</v> is relevant only when attachments are used; see <see topic=\"ACL2____DEFATTACH\">defattach</see> for background on attachments.  When <v>:aokp</v> is <v>nil</v>, the \u000A default, computed values are not stored when an attachment was used, or even \u000A when an attachment may have been used because a function was called that had \u000A been memoized using <v>:aokp t</v>.  Otherwise, computed values are always \u000A stored, but saved values are not used except when attachments are allowed.  To \u000A summarize:</p> \u000A \u000A <code>aokp=nil (<see topic=\"ACL2____DEFAULT\">default</see>): ``Pure'', i.e., values do not depend on attachments\u000A- Fetch: always legal\u000A- Store: only store resulting value when attachments were not used\u000A\u000Aaokp=t: ``Impure'', i.e., values may depend on attachments\u000A- Fetch: only legal when attachments are allowed (e.g., not during proofs)\u000A- Store: always legal</code> \u000A \u000A <p>The default value for <v>:stats</v> is essentially <v>t</v>.  (Technically, \u000A this can be subverted by using raw Lisp, to change the default by changing the \u000A values of variables <v>*record-xxx*</v> introduced in ACL2 source file \u000A <v>memoize-raw.lisp</v>.)  When <v>:stats</v> has its default value (assuming the \u000A above raw Lisp changes are not made) or value <v>t</v>, calls of memoized \u000A functions will collect information that can be displayed by calling <tt><see topic=\"ACL2____MEMSUM\">memsum</see></tt>.  But if <v>:stats</v> is <v>nil</v>, this information will not be \u000A collected, possibly resulting in better performance for the memoized \u000A function.  As of this writing, built-in memoized functions use <v>:stats nil</v> \u000A to benefit performance.</p> \u000A \u000A <p>If <v>:ideal-okp</v> is supplied and not <v>nil</v>, then it is permitted to \u000A memoize an ``ideal-mode'' function: one in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode whose \u000A <see topic=\"ACL2____GUARD\">guard</see>s have not been verified.  However, this might not have the effect \u000A you desire, because you will be memoizing the raw Lisp version of the \u000A function, not the safe (so-called ``*1*'') function that is executed in the \u000A ACL2 loop and on behalf of the prover.  Thus, if you memoize an ideal-mode \u000A function and then call it at the top-level of the ACL2 loop (or, for example, \u000A it is called to evaluate a ground term arising in a proof or in the evaluation \u000A of a <see topic=\"ACL2____META\">meta</see>function in a proof), the effects of memoization will not be \u000A felt because the raw Lisp code is not run unless guards are verified.</p> \u000A \u000A <p>There are circumstances in which the raw Lisp code of an ideal-mode function \u000A is called.  For example, if the ideal-mode function is called by a \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function, evaluation can transfer to raw Lisp where \u000A the effects of memoization will be felt.</p> \u000A \u000A <p>A trick, described below, with <tt><see topic=\"ACL2____EC-CALL\">ec-call</see></tt> can provide some of the \u000A benefit of memoizing an ideal-mode function.  The trick exploits the fact that \u000A <v>ec-call</v> allows you to call an ideal-mode function within a <see topic=\"ACL2____GUARD\">guard</see>-verified (``Common Lisp compliant'') <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode function \u000A without having to verify guards for the ideal-mode function.  The following \u000A edited log illustrates the points above.</p> \u000A \u000A <code> ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fib (n)\u000A\u0009  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____NATP\">natp</see> n) :verify-guards nil))\u000A\u0009  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A\u0009      0\u000A\u0009    (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____EQL\">eql</see> n 1)\u000A\u0009\u00091\u000A\u0009      (<see topic=\"COMMON-LISP_____B2\">+</see> (fib (<see topic=\"COMMON-LISP____-\">-</see> n 1)) (fib (<see topic=\"COMMON-LISP____-\">-</see> n 2))))))\u000A [[ .. output omitted .. ]]\u000A  FIB\u000A ACL2 !&gt;(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'fib :ideal-okp t)\u000A [[ .. output omitted .. ]]\u000A  FIB\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib 38)) ; slow, since *1*fib never calls fib\u000A\u000A ACL2 Warning [Guards] in TOP-LEVEL:  Guard-checking will be inhibited\u000A on recursive calls of the executable counterpart (i.e., in the ACL2\u000A logic) of FIB.  To check guards on all recursive calls:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :all)\u000A To leave behavior unchanged except for inhibiting this message:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :nowarn)\u000A\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 3.91 seconds realtime, 3.90 seconds runtime\u000A ; (416 bytes allocated).\u000A 39088169\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib 38)) ; still slow; no results were stored before\u000A\u000A ACL2 Warning [Guards] in TOP-LEVEL:  Guard-checking will be inhibited\u000A on recursive calls of the executable counterpart (i.e., in the ACL2\u000A logic) of FIB.  To check guards on all recursive calls:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :all)\u000A To leave behavior unchanged except for inhibiting this message:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :nowarn)\u000A\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 3.92 seconds realtime, 3.91 seconds runtime\u000A ; (416 bytes allocated).\u000A 39088169\u000A ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fib-logic-wrapper (n) ; guard-verified\u000A\u0009  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____NATP\">natp</see> n)))\u000A\u0009  (<see topic=\"ACL2____EC-CALL\">ec-call</see> (fib n)))\u000A [[ .. output omitted .. ]]\u000A  FIB-LOGIC-WRAPPER\u000A ACL2 !&gt;(<see topic=\"ACL2____MEMOIZE\">memoize</see> 'fib-logic-wrapper)\u000A [[ .. output omitted .. ]]\u000A  FIB-LOGIC-WRAPPER\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib-logic-wrapper 38)) ; slow; no fib results are stored\u000A\u000A ACL2 Warning [Guards] in TOP-LEVEL:  Guard-checking will be inhibited\u000A on recursive calls of the executable counterpart (i.e., in the ACL2\u000A logic) of FIB.  To check guards on all recursive calls:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :all)\u000A To leave behavior unchanged except for inhibiting this message:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :nowarn)\u000A\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 3.92 seconds realtime, 3.91 seconds runtime\u000A ; (2,128 bytes allocated).\u000A 39088169\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib-logic-wrapper 38)) ; fast; fib-logic-wrapper result was stored\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 0.00 seconds realtime, 0.00 seconds runtime\u000A ; (16 bytes allocated).\u000A 39088169\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib-logic-wrapper 37)) ; slow; result only for 38 was stored\u000A\u000A ACL2 Warning [Guards] in TOP-LEVEL:  Guard-checking will be inhibited\u000A on recursive calls of the executable counterpart (i.e., in the ACL2\u000A logic) of FIB.  To check guards on all recursive calls:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :all)\u000A To leave behavior unchanged except for inhibiting this message:\u000A   (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :nowarn)\u000A\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 2.42 seconds realtime, 2.42 seconds runtime\u000A ; (416 bytes allocated).\u000A 24157817\u000A ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fib-program-wrapper (n) ; program mode function\u000A\u0009  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____NATP\">natp</see> n) :mode :program))\u000A\u0009  (fib n))\u000A\u000A Summary\u000A Form:  ( DEFUN FIB-PROGRAM-WRAPPER ...)\u000A Rules: NIL\u000A Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A  FIB-PROGRAM-WRAPPER\u000A ACL2 !&gt;(<see topic=\"ACL2____TIME_42\">time$</see> (fib-program-wrapper 100)) ; fast because raw-Lisp fib is called\u000A ; (EV-REC *RETURN-LAST-ARG3* ...) took \u000A ; 0.00 seconds realtime, 0.00 seconds runtime\u000A ; (7,600 bytes allocated).\u000A 354224848179261915075\u000A ACL2 !&gt;</code> \u000A \u000A <p>Two non-<v>nil</v> values are allowed for keyword parameter <v>:ideal-okp</v>: \u000A <v>:warn</v> and <v>t</v>.  Both of these values allow memoization of ideal-mode \u000A functions, but if <v>:warn</v> is supplied then a warning will take place at \u000A memoization time, specifically for the resluting <see topic=\"ACL2____TABLE\">table</see> event.  Note \u000A that you may set the key <v>:memoize-ideal-okp</v> of the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> to value <v>t</v> or <v>:warn</v> to change the default, but \u000A if parameter <v>:ideal-okp</v> is supplied, the <tt><see topic=\"ACL2____ACL2-DEFAULTS-TABLE\">ACL2-defaults-table</see></tt> \u000A value is ignored.</p> \u000A \u000A <p>If <v>:verbose</v> is supplied, it should either be <v>nil</v>, which will \u000A inhibit proof, event, and summary output (see <see topic=\"ACL2____WITH-OUTPUT\">with-output</see>), or else \u000A <v>t</v> (the default), which does not inhibit output.  If the output baffles \u000A you, try</p> \u000A \u000A <code>:trans1 (<see topic=\"ACL2____MEMOIZE\">memoize</see> ...)</code> \u000A \u000A <p>to see the single-step macroexpansion of your <v>memoize</v> call.</p> \u000A \u000A <p>The default for <v>:forget</v> is <v>nil</v>.  If <v>:forget</v> is supplied, and \u000A not <v>nil</v>, then it must be <v>t</v>, which causes all memoization done for a \u000A top-level call of <v>fn</v> to be forgotten when that top-level call \u000A exits.</p>"],

 "COMMON-LISP____LET":[["Basics","ACL2-built-ins"],"ACL2 Sources","ACL2","<h3>Introduction</h3> \u000A \u000A <p>Example</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((x (<see topic=\"COMMON-LISP_____A2\">*</see> x x))\u000A      (y (<see topic=\"COMMON-LISP_____A2\">*</see> 2 x)))\u000A (<see topic=\"COMMON-LISP____LIST\">list</see> x y))</code> \u000A \u000A <p>If the form above is executed in an environment in which <v>x</v> has the \u000A value <v>-2</v>, then the result is <v>'(4 -4)</v>.</p> \u000A \u000A <p><v>Let</v> expressions bind variables so that their ``local'' values, the \u000A values they have when the ``body'' of the <v>let</v> is evaluated, are possibly \u000A different than their ``global'' values, the values they have in the context in \u000A which the <v>let</v> expression appears.  In the <v>let</v> expression above, the \u000A local variables bound by the <v>let</v> are <v>x</v> and <v>y</v>.  They are locally \u000A bound to the values delivered by the two forms <v>(<see topic=\"COMMON-LISP_____A2\">*</see> x x)</v> and <v>(<see topic=\"COMMON-LISP_____A2\">*</see> 2 x)</v>, \u000A respectively, that appear in the ``bindings'' of the <v>let</v>.  The body of \u000A the <v>let</v> is <v>(<see topic=\"COMMON-LISP____LIST\">list</see> x y)</v>.</p> \u000A \u000A <p>Suppose that the <v>let</v> expression above occurs in a context in which \u000A <v>x</v> has the value <v>-2</v>.  (The global value of <v>y</v> is irrelevant to \u000A this example.)  For example, one might imagine that the <v>let</v> form above \u000A occurs as the body of some function, <v>fn</v>, with the formal parameter <v>x</v> \u000A and we are evaluating <v>(fn -2)</v>.</p> \u000A \u000A <p>To evaluate the <v>let</v> above in a context in which <v>x</v> is <v>-2</v>, we \u000A first evaluate the two forms specifying the local values of the variables. \u000A Thus, <v>(<see topic=\"COMMON-LISP_____A2\">*</see> x x)</v> is evaluated and produces <v>4</v> (because <v>x</v> is \u000A <v>-2</v>) and <v>(<see topic=\"COMMON-LISP_____A2\">*</see> 2 x)</v> is evaluated and produces <v>-4</v> (because <v>x</v> is \u000A <v>-2</v>).  Then <v>x</v> and <v>y</v> are bound to these values and the body of \u000A the <v>let</v> is evaluated.  Thus, when the body, <v>(<see topic=\"COMMON-LISP____LIST\">list</see> x y)</v> is evaluated, \u000A <v>x</v> is <v>4</v> and <v>y</v> is <v>-4</v>.  Thus, the body produces <v>'(4\u000A -4)</v>.</p> \u000A \u000A <p>Note that the binding of <v>y</v>, which is written after the binding of \u000A <v>x</v> and which mentions <v>x</v>, nevertheless uses the global value of \u000A <v>x</v>, not the new local value.  That is, the local variables of the <v>let</v> \u000A are bound ``in parallel'' rather than ``sequentially.'' In contrast, if \u000A the example <v>let*</v> form:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET_A2\">let*</see> ((x (<see topic=\"COMMON-LISP_____A2\">*</see> x x))\u000A       (y (<see topic=\"COMMON-LISP_____A2\">*</see> 2 x)))\u000A (<see topic=\"COMMON-LISP____LIST\">list</see> x y))</code> \u000A \u000A <p>is evaluated when the global value of <v>x</v> is <v>-2</v>, then the result is \u000A <v>'(4 8)</v>, because the local value of <v>y</v> is computed after <v>x</v> has \u000A been bound to <v>4</v>.  <tt><see topic=\"COMMON-LISP____LET_A2\">Let*</see></tt> binds its local variables \u000A ``sequentially.''</p> \u000A \u000A <p>General <v>let</v> forms</p> \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((var1 term1) ... (varn termn)) body)\u000Aand\u000A(<see topic=\"COMMON-LISP____LET\">let</see> ((var1 term1) ... (varn termn))\u000A (<see topic=\"COMMON-LISP____DECLARE\">declare</see> ...) ... (<see topic=\"COMMON-LISP____DECLARE\">declare</see> ...)\u000A body)</code> \u000A \u000A <p>where the <v>vari</v> are distinct variables, the <v>termi</v> are terms \u000A involving only variables bound in the environment containing the <v>let</v>, and \u000A <v>body</v> is a term involving only the <v>vari</v> plus the variables bound in \u000A the environment containing the <v>let</v>.  Each <v>vari</v> must be used in \u000A <v>body</v> or else <see topic=\"COMMON-LISP____DECLARE\">declare</see>d ignored.</p> \u000A \u000A <p>A <v>let</v> form is evaluated by first evaluating each of the <v>termi</v>, \u000A obtaining for each a <v>vali</v>.  Then, each <v>vari</v> is bound to the \u000A corresponding <v>vali</v> and <v>body</v> is evaluated.</p> \u000A \u000A <p>Actually, <v>let</v> forms are just abbreviations for certain uses of \u000A <v>lambda</v> notation.  In particular</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((var1 term1) ... (varn termn)) (<see topic=\"COMMON-LISP____DECLARE\">declare</see> ...) body)</code> \u000A \u000A <p>is equivalent to</p> \u000A \u000A <code>((<see topic=\"COMMON-LISP____LAMBDA\">lambda</see> (var1 ... varn)\u000A   (<see topic=\"COMMON-LISP____DECLARE\">declare</see> ...)\u000A   body)\u000A term1 ... termn).</code> \u000A \u000A <p><tt><see topic=\"COMMON-LISP____LET_A2\">Let*</see></tt> forms are used when it is desired to bind the <v>vari</v> \u000A sequentially, i.e., when the local values of preceding <v>varj</v> are to be \u000A used in the computation of the local value for <v>vari</v>.</p> \u000A \u000A <p>General <v>let*</v> forms:</p> \u000A <code>(<see topic=\"COMMON-LISP____LET_A2\">let*</see> ((var1 term1) ... (varn termn)) body)\u000Aand\u000A(<see topic=\"COMMON-LISP____LET_A2\">let*</see> ((var1 term1) ... (varn termn))\u000A (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> x1 ... xm))\u000A body)</code> \u000A \u000A <p>where the <v>vari</v> are variables (not necessarily distinct), the \u000A <v>termi</v> are terms involving only variables bound in the environment \u000A containing the <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> and those <v>varj</v> such that <v>j&lt;i</v>, and \u000A <v>body</v> is a term involving only the <v>vari</v> plus the variables bound in \u000A the environment containing the <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>.  Each <v>vari</v> must be used \u000A either in some subsequent <v>termj</v> or in <v>body</v>, except that in the \u000A second form above we make an exception when <v>vari</v> is among the <v>xk</v>, in \u000A which case <v>vari</v> must not be thus used.  Note that <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> does not \u000A permit the inclusion of any <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> forms other than one as shown \u000A above.  In the second general form above, every <v>xk</v> must be among the \u000A <v>vari</v>, and furthermore, <v>xk</v> may not equal <v>vari</v> and <v>varj</v> for \u000A distinct <v>i</v>, <v>j</v>.</p> \u000A \u000A <p>The first <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> above is equivalent to</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((var1 term1))\u000A ...\u000A (<see topic=\"COMMON-LISP____LET\">let</see> ((varn termn)) body)...)</code> \u000A \u000A <p>Thus, the <v>termi</v> are evaluated successively and after each evaluation \u000A the corresponding <v>vali</v> is bound to the value of <v>termi</v>.  The second \u000A <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> is similarly expanded, except that each for each <v>vari</v> that \u000A is among the <v>(x1 ... xm)</v>, the form <v>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> vari))</v> is \u000A inserted immediately after <v>(vari termi)</v>.</p> \u000A \u000A <p>Each <v>(vari termi)</v> pair in a <v>let</v> or <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> form is called a \u000A ``binding'' of <v>vari</v> and the <v>vari</v> are called the ``local variables'' \u000A of the <v>let</v> or <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>.  The common use of <v>let</v> and <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> \u000A is to save the values of certain expressions (the <v>termi</v>) so that they may \u000A be referenced several times in the body without suggesting their \u000A recomputation.</p> \u000A \u000A <p><v>Let</v> is part of Common Lisp.  See any Common Lisp documentation for \u000A more information.</p>"],

 "ACL2____SIGNATURE":[["Encapsulate"],"ACL2 Sources","ACL2","<p>We start with a gentle introduction to signatures, where we pretend \u000A that there are no single-threaded objects (more on that below &mdash; for now, \u000A if you don't know anything about single-threaded objects, that's fine!).  Here \u000A are some simple examples of signatures.</p> \u000A \u000A <code>((hd *) =&gt; *)\u000A((pair * *) =&gt; *)\u000A((foo * *) =&gt; (<see topic=\"ACL2____MV\">mv</see> * * *))</code> \u000A \u000A <p>The first of these says that <v>hd</v> is a function of one argument, while \u000A the other two say that <v>pair</v> and <v>foo</v> are functions that each take two \u000A arguments.  The first two say that <v>hd</v> and <v>pair</v> return a single \u000A value.  The third says that <v>foo</v> returns three values, much as the \u000A following definition returns three values:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> bar (x y)\u000A  (<see topic=\"ACL2____MV\">mv</see> y x (<see topic=\"COMMON-LISP____CONS\">cons</see> x y)))</code> \u000A \u000A <p>Corresponding ``old-style'' signatures are as follows.  In each case, a \u000A function symbol is followed by a list of formal parameters and then either \u000A <v>t</v>, to denote a single value return, or <v>(<see topic=\"ACL2____MV\">mv</see> t t t)</v>, to denote a \u000A multiple value return (in this case, returning three values).</p> \u000A \u000A <code>(hd (x) t)\u000A(pair (x y) t)\u000A(foo (x y) (<see topic=\"ACL2____MV\">mv</see> t t t))</code> \u000A \u000A <p>That concludes our gentle introduction.  The documentation below is more \u000A general, for example covering single-threaded objects and keyword values such \u000A as <v>:guard</v>.  When reading what follows below, it is sufficient to know \u000A about single-threaded objects (or ``stobjs'') that each has a unique symbolic \u000A name and that <tt><see topic=\"ACL2____STATE\">state</see></tt> is the name of the only built-in single-threaded \u000A object.  All other stobjs are introduced by the user via <tt><see topic=\"ACL2____DEFSTOBJ\">defstobj</see></tt> or \u000A <tt><see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see></tt>.  An object that is not a single-threaded object is said \u000A to be ``ordinary.''  For a discussion of single-threaded objects, see <see topic=\"ACL2____STOBJ\">stobj</see>.</p> \u000A \u000A <code>Examples:\u000A((hd *) =&gt; *)\u000A((hd *) =&gt; * :formals (x) :guard (<see topic=\"COMMON-LISP____CONSP\">consp</see> x))\u000A((printer * state) =&gt; (<see topic=\"ACL2____MV\">mv</see> * * state))\u000A((mach * mach-state * state) =&gt; (<see topic=\"ACL2____MV\">mv</see> * mach-state))\u000A\u000AGeneral Form:\u000A((fn ...) =&gt; *)\u000A((fn ...) =&gt; stobj)\u000Aor\u000A((fn ...) =&gt; (<see topic=\"ACL2____MV\">mv</see> ...))\u000Aor for part1 and part2 as above,\u000A(part1 =&gt; part2 :kwd1 val1 ... :kwdn valn)</code> \u000A \u000A <p>where <v>fn</v> is the constrained function symbol, <v>...</v> is a list of \u000A asterisks and/or the names of single-threaded objects, <v>stobj</v> is a \u000A single-threaded object name, and the optional <v>:kwdi</v> and <v>:vali</v> are as \u000A described below.  ACL2 also supports an older style of signature, described \u000A below after we describe the preferred style.</p> \u000A \u000A <p>Signatures specify three syntactic aspects of a function symbol: (1) the \u000A ``arity'' or how many arguments the function takes, (2) the ``multiplicity'' \u000A or how many results it returns via <v>MV</v>, and (3) which of those arguments \u000A and results are single-threaded objects and which objects they are.</p> \u000A \u000A <p>A signature typically has the form <v>((fn x1 ... xn) =&gt; val)</v>.  Such a \u000A signature has two parts, separated by the symbol ``=&gt;''.  The first part, \u000A <v>(fn x1 ... xn)</v>, is suggestive of a call of the constrained function.  The \u000A number of ``arguments,'' <v>n</v>, indicates the arity of <v>fn</v>.  Each <v>xi</v> \u000A must be a symbol.  If a given <v>xi</v> is the symbol ``*'' then the \u000A corresponding argument must be ordinary.  If a given <v>xi</v> is any other \u000A symbol, that symbol must be the name of a single-threaded object and the \u000A corresponding argument must be that object.  No stobj name may occur twice \u000A among the <v>xi</v>.</p> \u000A \u000A <p>The second part, <v>val</v>, of a signature is suggestive of a term and \u000A indicates the ``shape'' of the output of <v>fn</v>.  If <v>val</v> is a symbol \u000A then it must be either the symbol ``*'' or the name of a single-threaded \u000A object.  In either case, the multiplicity of <v>fn</v> is 1 and <v>val</v> \u000A indicates whether the result is ordinary or a stobj.  Otherwise, <v>val</v> is \u000A of the form <v>(<see topic=\"ACL2____MV\">mv</see> y1 ... yk)</v>, where <v>k</v> &gt; 1.  Each <v>yi</v> must be \u000A either the symbol ``*'' or the name of a stobj.  Such a <v>val</v> indicates \u000A that <v>fn</v> has multiplicity <v>k</v> and the <v>yi</v> indicate which results \u000A are ordinary and which are stobjs.  No stobj name may occur twice among the \u000A <v>yi</v>, and a stobj name may appear in <v>val</v> only if appears among the \u000A <v>xi</v>.</p> \u000A \u000A <p>A signature may have the form <v>((fn x1 ... xn) =&gt; val . k)</v>, where \u000A <v>k</v> is a <tt><see topic=\"ACL2____KEYWORD-VALUE-LISTP\">keyword-value-listp</see></tt>, i.e., an alternating list of keywords \u000A and values starting with a keyword.  In this case <v>((fn x1 ... xn) =&gt; val)</v> \u000A must be a legal signature as described above.  The legal keywords in <v>k</v> \u000A are <v>:GUARD</v> and <v>:FORMALS</v> (except that for ACL2(r), also see the \u000A remark about <v>:CLASSICALP</v> later in this topic).  The value following \u000A <v>:FORMALS</v> is to be the list of formal parameters of <v>fn</v>, while the \u000A value following <v>:GUARD</v> is a term that is to be the <see topic=\"ACL2____GUARD\">guard</see> of \u000A <v>fn</v>.  Note that this guard is never actually evaluated, and is not subject \u000A to the guard verification performed on functions introduced by <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> \u000A (see <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see>).  Said differently: this guard need not itself have \u000A a guard of <v>t</v>.  Indeed, the guard is only used for attachments; see <see topic=\"ACL2____DEFATTACH\">defattach</see>.  Note that if <v>:GUARD</v> is supplied then <v>:FORMALS</v> must also \u000A be supplied (in order to related the variables occurring in the guard to the \u000A parameters of <v>fn</v>).  One final observation about guards: if the \u000A <v>:GUARD</v> keyword is omitted, then the guard defaults to <v>T</v>.</p> \u000A \u000A <p>Before ACL2 supported user-declared single-threaded objects there was only \u000A one single-threaded object: ACL2's built-in notion of <tt><see topic=\"ACL2____STATE\">state</see></tt>.  The \u000A notion of signature supported then gave a special role to the symbol \u000A <v>state</v> and all other symbols were considered to denote ordinary objects. \u000A ACL2 still supports the old form of signature, but it is limited to functions \u000A that operate on ordinary objects or ordinary objects and <v>state</v>.</p> \u000A \u000A <code>Old-Style General Form:\u000A(fn formals result . k)</code> \u000A \u000A <p>where <v>fn</v> is the constrained function symbol, <v>formals</v> is a \u000A suitable list of formal parameters for it, <v>k</v> is an optional <tt><see topic=\"ACL2____KEYWORD-VALUE-LISTP\">keyword-value-listp</see></tt> (see below), and <v>result</v> is either a symbol denoting \u000A that the function returns one result or else <v>result</v> is an <tt><see topic=\"ACL2____MV\">mv</see></tt> \u000A expression, <v>(<see topic=\"ACL2____MV\">mv</see> s1 ... sn)</v>, where <v>n&gt;1</v>, each <v>si</v> is a symbol, \u000A indicating that the function returns <v>n</v> results.  At most one of the \u000A formals may be the symbol <v>STATE</v>, indicating that corresponding argument \u000A must be ACL2's built-in <tt><see topic=\"ACL2____STATE\">state</see></tt>.  If <v>state</v> appears in <v>formals</v> \u000A then <v>state</v> may appear once in <v>result</v>.  All ``variable symbols'' \u000A other than <v>state</v> in old style signatures denote ordinary objects, \u000A regardless of whether the symbol has been defined to be a single-threaded \u000A object name!</p> \u000A \u000A <p>The optional <v>k</v> is as described above for newer-style signatures, \u000A except that the user is also allowed to declare which symbols (besides \u000A <v>state</v>) are to be considered single-threaded object names.  Thus \u000A <v>:STOBJS</v> is also a legal keyword.  The form</p> \u000A \u000A <code>(fn formals result ... :stobjs names ...)</code> \u000A \u000A <p>specifies that <v>names</v> is either the name of a single-threaded object or \u000A else is a list of such names.  Every name in <v>names</v> must have been \u000A previously defined as a stobj via <tt><see topic=\"ACL2____DEFSTOBJ\">defstobj</see></tt> or <tt><see topic=\"ACL2____DEFABSSTOBJ\">defabsstobj</see></tt>.</p> \u000A \u000A <p>As promised above, we conclude with a remark about an additional keyword, \u000A <v>:CLASSICALP</v>, that is legal for ACL2(r) (see <see topic=\"COMMON-LISP____REAL\">real</see>).  The value of \u000A this keyword must be <v>t</v> (the default) or <v>nil</v>, indicating respectively \u000A whether <v>fn</v> is classical or not.</p>"],

 "ACL2____TRACE_42":[["Trace"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see> foo bar)     ; trace foo and bar\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see>)             ; return current trace info (no new tracing specified)\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see> (foo :entry  ; trace foo, printing first actual parameter upon entry\u000A             (<see topic=\"COMMON-LISP____CAR\">car</see> arglist)))\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see> (foo :exit   ; trace foo, using fmt to print upon exit\u000A             (:fmt (<see topic=\"ACL2____MSG\">msg</see> &quot;Exiting FOO with ~x0&quot;\u000A                        value))))\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see> (foo :native t))\u000A\u000AGeneral Forms:\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see> spec1 spec2 ... specn) ; n &gt;= 1\u000A(<see topic=\"ACL2____TRACE_42\">trace$</see>)</code> \u000A \u000A <p>where the <v>speci</v> are trace specs, as described below.</p> \u000A \u000A <p><v>Trace$</v> installs alternate code for the indicated functions that prints \u000A information upon entry to, and exit from, calls of the functions.  For an \u000A alternate tracing utility used for educational purposes in <a \u000A href='http://acl2s.ccs.neu.edu/acl2s/doc/'>ACL2s</a>, see community book \u000A <v>books/misc/trace-star.lisp</v>.</p> \u000A \u000A <p>From a logical perspective all trace printing is a fiction.  (But see <see topic=\"ACL2____TRACE_12\">trace!</see>  for a way to get around this and modify <see topic=\"ACL2____STATE\">state</see>.)  For a related \u000A fiction, see <see topic=\"ACL2____CW\">cw</see>.  <v>(<see topic=\"ACL2____TRACE_42\">Trace$</see>)</v> returns the list of currently-active \u000A trace specs, while the application of <v>trace$</v> to at least one argument \u000A returns the list of its arguments that are successfully acted on.</p> \u000A \u000A <p>Output from <tt><see topic=\"ACL2____TRACE_42\">trace$</see></tt> normally goes to the screen, i.e., to <tt><see topic=\"ACL2____STANDARD-CO\">standard-co</see></tt>.  But it can be redirected to a file; see <see topic=\"ACL2____OPEN-TRACE-FILE\">open-trace-file</see>.</p> \u000A \u000A <p>See <see topic=\"ACL2____UNTRACE_42\">untrace$</see> for how to undo the effect of <tt><see topic=\"ACL2____TRACE_42\">trace$</see></tt>.  Also see \u000A <see topic=\"COMMON-LISP____TRACE\">trace</see> for mention of modifications made to raw Lisp trace, which is \u000A accessible (as described below) using the <v>:native</v> keyword.</p> \u000A \u000A <p>Note that when <v>trace$</v> is applied to a function without option \u000A <v>:native</v>, that function's declarations and documentation are \u000A discarded.</p> \u000A \u000A <p>Next, we introduce tracing with some examples.  After that, we provide \u000A reference documentation for individual trace options allowed in a trace spec. \u000A Note that although our example focuses on user-defined functions, <v>trace$</v> \u000A can also be applied to built-in functions, though perhaps only system hackers \u000A should take advantage of this observation.</p> \u000A \u000A <p>We begin by illustrating the simplest sort of trace spec: a function \u000A symbol.  For example, the form <v>(<see topic=\"ACL2____TRACE_42\">trace$</see> foo bar)</v> directs the tracing of \u000A functions <v>foo</v> and <v>bar</v> by virtue of the two trace specs <v>foo</v> and \u000A <v>bar</v>.  We can see tracing in action by first defining:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x)\u000A  (<see topic=\"COMMON-LISP____CONS\">cons</see> x x))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x)\u000A  (<see topic=\"COMMON-LISP____LIST\">list</see> (f x) 3))</code> \u000A \u000A <p>The following log then illustrates tracing of these two functions.  Notice \u000A that before <see topic=\"ACL2____GUARD\">guard</see>s have been verified, the so-called ``*1*'' functions \u000A (sometimes called ``executable counterpart functions'' or ``logic functions'') \u000A are called but the corresponding raw Lisp functions are not; but after guard \u000A verification of <v>f</v>, the raw Lisp counterpart of <v>f</v> is indeed called. \u000A (See <see topic=\"ACL2____GUARD\">guard</see> and see <see topic=\"ACL2____GUARD-EVALUATION-EXAMPLES-LOG\">guard-evaluation-examples-log</see>.)</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> f g)\u000A ((F) (G))\u000AACL2 !&gt;(g 7)\u000A1&gt; (ACL2_*1*_ACL2::G 7)\u000A  2&gt; (ACL2_*1*_ACL2::F 7)\u000A  &lt;2 (ACL2_*1*_ACL2::F (7 . 7))\u000A&lt;1 (ACL2_*1*_ACL2::G ((7 . 7) 3))\u000A((7 . 7) 3)\u000AACL2 !&gt;(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> f)\u000A\u000AComputing the guard conjecture for F....\u000A\u000AThe guard conjecture for F is trivial to prove.  F is compliant with\u000ACommon Lisp.\u000A\u000ASummary\u000AForm:  ( VERIFY-GUARDS F)\u000ARules: NIL\u000AWarnings:  None\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A F\u000AACL2 !&gt;(g 7)\u000A1&gt; (ACL2_*1*_ACL2::G 7)\u000A  2&gt; (ACL2_*1*_ACL2::F 7)\u000A    3&gt; (F 7)\u000A    &lt;3 (F (7 . 7))\u000A  &lt;2 (ACL2_*1*_ACL2::F (7 . 7))\u000A&lt;1 (ACL2_*1*_ACL2::G ((7 . 7) 3))\u000A((7 . 7) 3)\u000AACL2 !&gt;</code> \u000A \u000A <p>The following example introduces trace specs other than function symbols. \u000A Consider the following definition.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____NATP\">natp</see> n)))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A      1\u000A    (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n)))))</code> \u000A \u000A <p>The following log illustrates the use of trace options <v>:cond</v> \u000A (condition for entering trace), <v>:entry</v> (what to print on entry), and \u000A <v>:exit</v> (what to print on exit).  The reason for two calls on argument 4 is \u000A that we are seeing such calls for the executable counterpart of <v>fact</v> and \u000A also its raw Lisp function.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> (fact :cond (<see topic=\"COMMON-LISP____EVENP\">evenp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> arglist))\u000A                     :entry (<see topic=\"COMMON-LISP____CONS\">cons</see> 'factorial-call arglist)\u000A                     :exit (<see topic=\"COMMON-LISP____CAR\">car</see> values)))\u000A ((FACT :COND (<see topic=\"COMMON-LISP____EVENP\">EVENP</see> (<see topic=\"COMMON-LISP____CAR\">CAR</see> ARGLIST))\u000A        :ENTRY (<see topic=\"COMMON-LISP____CONS\">CONS</see> 'FACTORIAL-CALL ARGLIST)\u000A        :EXIT (<see topic=\"COMMON-LISP____CAR\">CAR</see> VALUES)))\u000AACL2 !&gt;(fact 4)\u000A1&gt; (FACTORIAL-CALL 4)\u000A  2&gt; (FACTORIAL-CALL 4)\u000A    3&gt; (FACTORIAL-CALL 2)\u000A      4&gt; (FACTORIAL-CALL 0)\u000A      &lt;4 1\u000A    &lt;3 2\u000A  &lt;2 24\u000A&lt;1 24\u000A24\u000AACL2 !&gt;</code> \u000A \u000A <p>Notice that <v>VALUES</v> above is the list of all values returned, which is \u000A a one-element list unless <tt><see topic=\"ACL2____MV\">mv</see></tt> return is used, as illustrated in the \u000A following example, after defining: <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> two-vals (x) (<see topic=\"ACL2____MV\">mv</see> x 7))</v>.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> two-vals)\u000A ((TWO-VALS))\u000AACL2 !&gt;(two-vals 3)\u000A1&gt; (ACL2_*1*_ACL2::TWO-VALS 3)\u000A&lt;1 (ACL2_*1*_ACL2::TWO-VALS 3 7)\u000A(3 7)\u000AACL2 !&gt;(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> two-vals)\u000A\u000AComputing the guard conjecture for TWO-VALS....\u000A\u000AThe guard conjecture for TWO-VALS is trivial to prove, given the :executable-\u000Acounterpart of CONS.  TWO-VALS is compliant with Common Lisp.\u000A\u000ASummary\u000AForm:  ( VERIFY-GUARDS TWO-VALS)\u000ARules: ((:EXECUTABLE-COUNTERPART CONS))\u000AWarnings:  None\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A TWO-VALS\u000AACL2 !&gt;(two-vals 3)\u000A1&gt; (ACL2_*1*_ACL2::TWO-VALS 3)\u000A  2&gt; (TWO-VALS 3)\u000A  &lt;2 (TWO-VALS 3 7)\u000A&lt;1 (ACL2_*1*_ACL2::TWO-VALS 3 7)\u000A(3 7)\u000AACL2 !&gt;</code> \u000A \u000A <p>We now document all of the options that may appear in a trace spec.  A \u000A trace spec with options is of the form</p> \u000A \u000A <code>(fn :kwd1 val1 :kwd2 val2 ... :kwdn valn)</code> \u000A \u000A <p>and here we document each legal keyword <v>:kwdi</v> and corresponding \u000A expected value <v>vali</v>.  Note that <v>trace$</v> is intended primarily for \u000A functions defined in the ACL2 command loop (see <see topic=\"ACL2____LP\">lp</see>).  If you want to \u000A trace a function that is defined in raw Lisp, then you can use option \u000A <v>:native</v> (see below), but then many other <v>trace$</v> options will not be \u000A available to you: all of them except <v>:multiplicity</v> and <v>:native</v> \u000A itself will be passed directly to the <v>trace</v> utility of the underlying \u000A Common Lisp.</p> \u000A \u000A <p><v>:COND</v>, <v>:ENTRY</v>, and <v>:EXIT</v></p> \u000A \u000A <p><b>Introduction</b>.  For each of these three options, the value is a \u000A (user-level) term, except that for <v>:entry</v> and <v>:exit</v> the value can be \u000A of the form <v>(:fmt u)</v> or <v>(:fmt! u)</v>, where <v>u</v> is a user-level \u000A term.  We skip these two latter cases for now and return to them later.  Then \u000A the indicated term is evaluated as indicated in the next paragraph, and if the \u000A <v>:cond</v> term is omitted or evaluates to non-<v>nil</v>, then the value of the \u000A <v>:entry</v> term is printed on entry and the value of the <v>:exit</v> term is \u000A printed on exit.  By default, where <v>:entry</v> is omitted or is specified as \u000A <v>nil</v>, the value printed for <v>:entry</v> is the list obtained by consing \u000A the calling function symbol onto the list of actual parameters: in the \u000A notation described below, this is <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> TRACED-FN ARGLIST)</v>.  Similarly, \u000A the default for printing at the exit of the function call, i.e. where \u000A <v>:exit</v> is omitted or is specified as <v>nil</v>, is <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> TRACED-FN\u000A VALUES)</v> where <v>VALUES</v> is the list of values returned as described \u000A below.</p> \u000A \u000A <p><b>Available Variables</b>.  In the evaluations of the term described below \u000A upon a call of <v>fn</v>, each formal parameter of the definition of <v>fn</v> \u000A will be bound to the corresponding actual of the call, the variable \u000A <v>ARGLIST</v> will be bound to the list of actuals, and the variable \u000A <v>TRACED-FN</v> will be bound to the function being called (either <v>fn</v> or \u000A its executable counterpart function; see above).  Additionally in the case of \u000A <v>:exit</v>, the variable <v>VALUES</v> will be bound to the multiple values \u000A returned (thus, a one-element list if <tt><see topic=\"ACL2____MV\">mv</see></tt> is not used in the return). \u000A Also for <v>:exit</v>, we bind <v>VALUE</v> to the logical value returned, i.e., \u000A to the suitable list of values returned in the <tt><see topic=\"ACL2____MV\">mv</see></tt> case and otherwise \u000A to the single value returned.  So in the <v>mv</v> case, <v>VALUE</v> is the same \u000A as <v>VALUES</v>, and otherwise <v>VALUE</v> is <v>(<see topic=\"COMMON-LISP____CAR\">car</see> VALUES)</v>.  Other than \u000A these variables and <tt><see topic=\"ACL2____STATE\">state</see></tt>, no other variable may occur in the term, \u000A whose value must be a single non-<tt><see topic=\"ACL2____STOBJ\">stobj</see></tt> value, unless there is an \u000A active trust tag (see <see topic=\"ACL2____DEFTTAG\">defttag</see>).</p> \u000A \u000A <p>Now suppose <v>fn</v> is called.  First: If <v>:cond</v> is supplied and the \u000A result of evaluating the <v>:cond</v> term is <v>nil</v>, then no tracing is done. \u000A Otherwise tracing proceeds as follows.  First the <v>:entry</v> form is \u000A evaluated, and the result is printed.  Then the call of <v>fn</v> is evaluated. \u000A Finally the <v>:exit</v> term is evaluated and the result is printed.  As \u000A indicated above, the default for the <v>:entry</v> term if omitted or explicitly \u000A <v>nil</v> is <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> TRACED-FN ARGLIST)</v>, and the default for the <v>:exit</v> \u000A term if omitted or explicitly <v>nil</v> is <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> TRACED-FN VALUES)</v>.</p> \u000A \u000A <p>Note that if the function has a formal named <v>ARGLIST</v>, then \u000A <v>ARGLIST</v> will nevertheless refer to the entire list of formals, not the \u000A single formal named <v>ARGLIST</v>; similarly for <v>TRACED-FN</v>, and \u000A additionally for <v>VALUE</v> and <v>VALUES</v> in the case of <v>:exit</v>.</p> \u000A \u000A <p>As mentioned above, for each of <v>:entry</v> and <v>:exit</v>, a value of \u000A <v>nil</v> specifies the default behavior.  If you really want a value of \u000A <v>nil</v>, use a non-<v>nil</v> form that evaluates to <v>nil</v>, for example \u000A <v>(<see topic=\"COMMON-LISP____CAR\">car</see> nil)</v> or <v>'nil</v>.  However, for <v>:cond</v> a value of <v>nil</v> \u000A means what it says: do not evaluate the <v>:entry</v> or <v>:exit</v> forms.</p> \u000A \u000A <p>Finally we discuss the case that the <v>:entry</v> or <v>:exit</v> term is of \u000A the form <v>(:fmt u)</v> or <v>(:fmt! u)</v>.  In these cases, the term <v>u</v> is \u000A evaluated as described above to produce a value, say <v>msg</v>, but instead of \u000A printing <v>msg</v> directly, ACL2 calls <v>fmt1</v> using the string <v>&quot;~@0&quot;</v> \u000A and the alist that binds just character <v>#\\0</v> to <v>msg</v>.  The following \u000A example illustrates this point, where <v>fact</v> is defined as above.  Also see \u000A <see topic=\"ACL2____FMT\">fmt</see>.  Note that <v>(<see topic=\"ACL2____MSG\">msg</see> string . vals)</v> produces a value suitable for \u000A a <v>&quot;~@&quot;</v> directive to the <v>fmt</v> family of print functions.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see>\u000A        (fact\u000A         :entry (:fmt (<see topic=\"ACL2____MSG\">msg</see> &quot;Tracing ~x0 on ~x1&quot; traced-fn arglist))\u000A         :exit (<see topic=\"COMMON-LISP____CAR\">car</see> values)))\u000A ((FACT :ENTRY (:FMT (<see topic=\"ACL2____MSG\">MSG</see> &quot;Tracing ~x0 on ~x1&quot; TRACED-FN ARGLIST))\u000A        :EXIT (<see topic=\"COMMON-LISP____CAR\">CAR</see> VALUES)))\u000AACL2 !&gt;(fact 3)\u000A1&gt; Tracing ACL2_*1*_ACL2::FACT on (3)\u000A  2&gt; Tracing FACT on (3)\u000A    3&gt; Tracing FACT on (2)\u000A      4&gt; Tracing FACT on (1)\u000A        5&gt; Tracing FACT on (0)\u000A        &lt;5 1\u000A      &lt;4 1\u000A    &lt;3 2\u000A  &lt;2 6\u000A&lt;1 6\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p>If <v>:fmt!</v> is used instead of <v>:fmt</v>, then indentation as is the \u000A prefix string, <v>&quot;n&gt; &quot;</v> or <v>&quot;&lt;n &quot;</v>.  The following example \u000A illustrates the use of <v>:fmt!</v>.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see>\u000A        (fact\u000A         :entry (:fmt! (<see topic=\"ACL2____MSG\">msg</see> &quot;Tracing ~x0 on ~x1&quot; traced-fn arglist))\u000A         :exit (:fmt! (<see topic=\"ACL2____MSG\">msg</see> &quot;From input ~x0: ~x1&quot;\u000A                           (<see topic=\"COMMON-LISP____CAR\">car</see> arglist) (<see topic=\"COMMON-LISP____CAR\">car</see> values)))))\u000A ((FACT :ENTRY (:FMT! (<see topic=\"ACL2____MSG\">MSG</see> &quot;Tracing ~x0 on ~x1&quot; TRACED-FN ARGLIST))\u000A        :EXIT (:FMT! (<see topic=\"ACL2____MSG\">MSG</see> &quot;From input ~x0: ~x1&quot; (<see topic=\"COMMON-LISP____CAR\">CAR</see> ARGLIST)\u000A                          (<see topic=\"COMMON-LISP____CAR\">CAR</see> VALUES)))))\u000AACL2 !&gt;(fact 3)\u000ATracing ACL2_*1*_ACL2::FACT on (3)\u000ATracing FACT on (3)\u000ATracing FACT on (2)\u000ATracing FACT on (1)\u000ATracing FACT on (0)\u000AFrom input 0: 1\u000AFrom input 1: 1\u000AFrom input 2: 2\u000AFrom input 3: 6\u000AFrom input 3: 6\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p>Here is the same example, with user-managed indentation.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see>\u000A        (fact\u000A         :entry (:fmt! (<see topic=\"ACL2____MSG\">msg</see> &quot;~t0Tracing ~x1 on ~x2&quot;\u000A                            (<see topic=\"COMMON-LISP_____B2\">+</see> 3 (<see topic=\"COMMON-LISP_____A2\">*</see> 2 (<see topic=\"ACL2_____04\">@</see> trace-level)))\u000A                            traced-fn arglist))\u000A         :exit (:fmt! (<see topic=\"ACL2____MSG\">msg</see> &quot;~t0From input ~x1: ~x2&quot;\u000A                           (<see topic=\"COMMON-LISP____1_B2\">1+</see> (<see topic=\"COMMON-LISP_____A2\">*</see> 2 (<see topic=\"ACL2_____04\">@</see> trace-level)))\u000A                           (<see topic=\"COMMON-LISP____CAR\">car</see> arglist) (<see topic=\"COMMON-LISP____CAR\">car</see> values)))))\u000A ((FACT :ENTRY (:FMT! (<see topic=\"ACL2____MSG\">MSG</see> &quot;~t0Tracing ~x1 on ~x2&quot;\u000A                           (<see topic=\"COMMON-LISP_____B2\">+</see> 3 (<see topic=\"COMMON-LISP_____A2\">*</see> 2 (<see topic=\"ACL2_____04\">@</see> TRACE-LEVEL)))\u000A                           TRACED-FN ARGLIST))\u000A        :EXIT (:FMT! (<see topic=\"ACL2____MSG\">MSG</see> &quot;~t0From input ~x1: ~x2&quot;\u000A                          (<see topic=\"COMMON-LISP____1_B2\">1+</see> (<see topic=\"COMMON-LISP_____A2\">*</see> 2 (<see topic=\"ACL2_____04\">@</see> TRACE-LEVEL)))\u000A                          (<see topic=\"COMMON-LISP____CAR\">CAR</see> ARGLIST)\u000A                          (<see topic=\"COMMON-LISP____CAR\">CAR</see> VALUES)))))\u000AACL2 !&gt;(fact 3)\u000A   Tracing ACL2_*1*_ACL2::FACT on (3)\u000A     Tracing FACT on (3)\u000A       Tracing FACT on (2)\u000A         Tracing FACT on (1)\u000A           Tracing FACT on (0)\u000A           From input 0: 1\u000A         From input 1: 1\u000A       From input 2: 2\u000A     From input 3: 6\u000A   From input 3: 6\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p><b>ADVANCED OPTIONS</b> (alphabetical list)</p> \u000A \u000A <p><v>:COMPILE</v></p> \u000A \u000A <p>The tracing of <v>fn</v> installs a substitute definition of <v>fn</v> that \u000A prints trace information.  If the <v>:compile</v> option is omitted or has value \u000A <v>:same</v>, then the new definition will be compiled if and only if the \u000A existing definition is already compiled.  Otherwise, the new definition will \u000A be compiled exactly when the value of <v>:compile</v> is not <v>nil</v>.</p> \u000A \u000A <p><v>:DEF</v>, <v>:MULTIPLICITY</v></p> \u000A \u000A <p>ACL2's <v>trace$</v> mechanism often needs to know the number of outputs of a \u000A traced function, in the sense of <tt><see topic=\"ACL2____MV\">mv</see></tt>.  If you trace a function that was \u000A not defined inside the ACL2 loop (hence you are using the <v>:native</v> \u000A option), or if you provide an alternative definition using option <v>:def</v> \u000A (see below) and the new definition changes the number of values returned, then \u000A a natural number value for <v>:multiplicity</v> informs the trace utility of the \u000A number of expected outputs of the function being traced.  In the case that \u000A <v>:native</v> is supplied, the effect of a non-<v>nil</v> <v>:multiplicity</v> \u000A value depends on the host Lisp.  In the case of Lisps for which ACL2 uses the \u000A built-in Lisp mechanism for returning multiple values (see <see topic=\"ACL2____MV\">mv</see>), which \u000A are CCL and threaded SBCL as of June, 2010, <v>:multiplicity</v> is not needed \u000A and is ignored with <v>:native t</v>.  For GCL and Allegro CL, \u000A <v>:multiplicity</v> is used to generate a suitable <v>:exit</v> form if the \u000A <v>:exit</v> keyword was not already supplied.  For the other Lisps, the \u000A <v>:multiplicity</v> value is treated essentially as 1 whether it is supplied or \u000A not, because we do not know how to pass suitable information based on this \u000A value to the host Lisp's built-in tracing mechanism.</p> \u000A \u000A <p>Note that even supplying a <v>:multiplicity</v> option does not change the \u000A meaning of the variable <v>values</v>.  See the discussion of <v>:native</v> \u000A below.</p> \u000A \u000A <p>A useful option can be to supply a definition as the value of <v>:def</v>. \u000A (Again, note that if <v>:native</v> is used, then all options other than \u000A <v>:multiplicity</v> are passed directly to the underlying Lisp; in particular, \u000A <v>:def</v> will have no effect with <v>:native</v> except in the unlikely case \u000A that the raw Lisp provides some sort of support for <v>:def</v>.)  Note that \u000A this definition should be like a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> form, but without the leading \u000A <v>defun</v> symbol; and it should define the function symbol being traced, with \u000A the same formal parameter list.  However, tracing of the so-called \u000A ``executable counterpart'' of a function (sometimes referred to as the ``*1* \u000A function'', for evaluation in the ACL2 loop; see <see topic='ACL2____Guards_02in_02ACL2'>guards</see> for related discussion) is not sensitive to \u000A the <v>:def</v> option; rather, if a function has an executable counterpart then \u000A that executable counterpart is traced.</p> \u000A \u000A <p><v>:EVISC-TUPLE</v></p> \u000A \u000A <p>The printing described above is, by default, done using the current default \u000A trace evisc-tuple, which can be set using <tt><see topic=\"ACL2____SET-TRACE-EVISC-TUPLE\">set-trace-evisc-tuple</see></tt> (for \u000A the shape of this tuple, see <see topic=\"ACL2____EVISC-TUPLE\">evisc-tuple</see>); see <see topic=\"ACL2____SET-TRACE-EVISC-TUPLE\">set-trace-evisc-tuple</see>.  This tuple is based by default on the raw Lisp \u000A variables <v>*print-level*</v> and <v>*print-length*</v>, and will hide the ACL2 \u000A <v>world</v> and handle <see topic=\"ACL2____STOBJ\">stobj</see>s appropriately.  You may override this \u000A default by supplying an evisc tuple with the <v>:evisc-tuple</v> argument in \u000A your trace spec.  Be careful to supply a valid evisc-tuple, or you may get a \u000A raw Lisp error!</p> \u000A \u000A <p>A special value, <v>:print</v>, is useful if you are doing system hacking \u000A that can produce objects that are not valid ACL2 objects, such as raw Lisp \u000A arrays or objects in supporting packages not visible in the ACL2 \u000A read-eval-print loop.  If you supply <v>:evisc-tuple :print</v>, then the \u000A printing described above will be done with raw Lisp printing rather than ACL2 \u000A printing: specifically, with <v>(format *trace-output* &quot;s%&quot; x)</v>, where \u000A <v>x</v> is the value to be printed.</p> \u000A \u000A <p>A second special value for <v>:evisc-tuple</v>, <v>:no-print</v>, avoids \u000A printing the values of the <v>:entry</v> and <v>:exit</v> forms (or their \u000A defaults, if not specified).  This option is of use for side effects; for an \u000A example see community book <v>books/misc/wet.lisp</v>.</p> \u000A \u000A <p>Note that if <v>:evisc-tuple X</v> is supplied, then the form <v>X</v> will be \u000A evaluated before the function body is entered.  You can thus pull some tricks \u000A to print extra information before the <v>:entry</v> form is evaluated, for \u000A example as follows for a factorial function, <v>fact</v>.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> (fact :evisc-tuple\u000A                     (<see topic=\"ACL2____PROG2_42\">prog2$</see> (<see topic=\"ACL2____CW\">cw</see> &quot;~|**** HERE IS CW ****~|&quot;)\u000A                             nil)))\u000A ((FACT :EVISC-TUPLE (<see topic=\"ACL2____PROG2_42\">PROG2$</see> (<see topic=\"ACL2____CW\">CW</see> &quot;~|**** HERE IS CW ****~|&quot;)\u000A                             NIL)))\u000AACL2 !&gt;(fact 3)\u000A**** HERE IS CW ****\u000A1&gt; (ACL2_*1*_ACL2::FACT 3)\u000A**** HERE IS CW ****\u000A  2&gt; (ACL2_*1*_ACL2::FACT 2)\u000A**** HERE IS CW ****\u000A    3&gt; (ACL2_*1*_ACL2::FACT 1)\u000A**** HERE IS CW ****\u000A      4&gt; (ACL2_*1*_ACL2::FACT 0)\u000A      &lt;4 (ACL2_*1*_ACL2::FACT 1)\u000A    &lt;3 (ACL2_*1*_ACL2::FACT 1)\u000A  &lt;2 (ACL2_*1*_ACL2::FACT 2)\u000A&lt;1 (ACL2_*1*_ACL2::FACT 6)\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p><v>:FORMALS</v></p> \u000A \u000A <p>Normally ACL2 can figure out the formals for a given function.  This is \u000A always the case for functions defined in the ACL2 command loop and when option \u000A <v>:def</v> is supplied.  If neither of these cases applies then you can still \u000A trace a function (even without using the <v>:native</v> option) by supplying \u000A option <v>:notinline :fncall</v>, but you will still need to supply the list of \u000A formal parameters.  The value of the <v>:formals</v> option should be the list \u000A of formals in this case.</p> \u000A \u000A <p><v>:HIDE</v></p> \u000A \u000A <p>The default value for this advanced option is <v>t</v>, which causes <see topic=\"ACL2____STOBJ\">stobj</see>s and the logical <see topic=\"ACL2____WORLD\">world</see> to be printed as single symbols, along \u000A with certain large structures of interest to developers (rewrite contants, \u000A enabled structures, and event and command index structures).  If however the \u000A value <v>nil</v> is supplied, then this default behavior is defeated.  In that \u000A case, you can still arrange to print the logical world as a symbol and to \u000A print <see topic=\"ACL2____STOBJ\">stobj</see>s without breaking the trace printing: see <see topic=\"ACL2____SET-TRACE-EVISC-TUPLE\">set-trace-evisc-tuple</see> for how to do this globally, or similarly use the \u000A <v>:evisc-tuple</v> option to <v>trace$</v> to do this with a single trace spec. \u000A Note however that with value <v>nil</v> specified for <v>:hide</v>, such use of an \u000A evisc-tuple will not deal properly with local stobjs (see <see topic=\"ACL2____WITH-LOCAL-STOBJ\">with-local-stobj</see>) or stobjs bound by <tt><see topic=\"ACL2____STOBJ-LET\">stobj-let</see></tt>, or with the \u000A aforementioned large structures other than the logical <see topic=\"ACL2____WORLD\">world</see>.</p> \u000A \u000A <p><v>:NATIVE</v></p> \u000A \u000A <p>If <v>:native</v> is supplied with a non-<v>nil</v> value, then the trace spec \u000A is passed to the native Lisp trace (after removing the <v>:native</v> option). \u000A A trust tag (see <see topic=\"ACL2____DEFTTAG\">defttag</see>) is required in order to use this option, \u000A because no syntactic check is made on the <v>:cond</v>, <v>:entry</v>, or \u000A <v>:exit</v> forms -- arbitrary raw Lisp may occur in them!</p> \u000A \u000A <p>Note that by ``native Lisp trace'' we mean the currently installed \u000A <v>trace</v>.  As discussed briefly elsewhere (see <see topic=\"COMMON-LISP____TRACE\">trace</see>), ACL2 has \u000A modified that trace to be more useful if the underlying host Lisp is GCL, \u000A Allegro CL, or CCL (OpenMCL).  If you need the original trace utility supplied \u000A for those Lisps, quit the ACL2 loop with <v>:q</v> and call <v>old-trace</v> and \u000A <v>old-untrace</v> in raw Lisp where you would otherwise call <v>trace</v> and \u000A <v>untrace</v>.  Note that the original trace utility supplied with a given Lisp \u000A will not hide the ACL2 logical <see topic=\"ACL2____WORLD\">world</see> or give special treatment to <see topic=\"ACL2____STOBJ\">stobj</see>s.</p> \u000A \u000A <p>It is important to understand that if <v>:native t</v> is specified, then all \u000A other options are interpreted by the native Lisp trace.  For example, that \u000A trace probably has no understanding of the use of <v>:fmt</v> described above \u000A for <v>:entry</v> or <v>:exit</v>.  Indeed, the native trace may not even accept \u000A any of <v>:cond</v>, <v>:entry</v> or <v>:exit</v>, let alone any of the advanced \u000A options!  Moreover, if <v>:native t</v> is specified, then even a \u000A <v>:multiplicity</v> option does not provide the meaning of the variable \u000A <v>values</v> that one might desire.  In GCL for example, in the case of an \u000A <tt><see topic=\"ACL2____MV\">mv</see></tt> return of a function defined only in raw Lisp (not in ACL2), this \u000A variable will be bound to a list containing only the first result.</p> \u000A \u000A <p><v>:NOTINLINE</v></p> \u000A \u000A <p>By default, a new definition installed by <v>trace$</v> will include a \u000A <v>notinline</v> declaration so that recursive calls will always be traced.  To \u000A avoid this declaration, supply value <v>nil</v>.</p> \u000A \u000A <p>A special value for <v>:notinline</v>, <v>:fncall</v>, will cause the traced \u000A function to call its original definition.  Without this special value, the new \u000A installed definition for the traced function will include the body of the \u000A original definition.  This <v>:fncall</v> behavior is the default only in the \u000A following cases:</p> \u000A \u000A <ul> \u000A \u000A <li>for functions whose definitions are built into ACL2;</li> \u000A \u000A <li>for functions that have been added (using a trust tag, an advanced \u000A feature, so most users can probably ignore this case) to either of the <tt><see topic=\"ACL2____STATE\">state</see></tt> global variables <v>program-fns-with-raw-code</v> or \u000A <v>logic-fns-with-raw-code</v>;</li> \u000A \u000A <li>(<see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> ACL2 executables only) for <tt><see topic=\"ACL2____MEMOIZE\">memoize</see></tt>d \u000A functions.</li> \u000A \u000A </ul> \u000A \u000A <p>The legal values for <v>:notinline</v> are <v>t</v> (the default for other than \u000A the cases displayed above), <v>nil</v>, and <v>:fncall</v>.  (Except: For the \u000A <see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> ACL2 executables, only <v>:fncall</v> is legal.)</p> \u000A \u000A <p><b>Remarks</b>.</p> \u000A \u000A <p>(1) If some of the given trace specs have errors, then <v>trace$</v> will \u000A generally print error messages for those but will still process those that do \u000A not have errors.  The value returned will indicate the trace specs that were \u000A processed successfully.</p> \u000A \u000A <p>(2) If you certify or include a book that redundantly defines a function \u000A that is currently traced, then tracing behavior may disappear if a compiled \u000A definition is installed for the function or its in-the-logic (so-called `*1*') \u000A counterpart.</p> \u000A \u000A <p>(3) Some predefined functions are called during tracing.  In order to avoid \u000A infinite loops, such calls of traced predefined functions will be made using \u000A the original predefined functions, not using their code installed by \u000A <v>trace$</v>.</p>"],

 "ACL2____TAU-SYSTEM":[["Rule-classes"],"ACL2 Sources","ACL2","<p>This documentation topic describes the syntactic form of \u000A ``tau-system'' rules; these rules extend ACL2's ``type checker.''  For an \u000A introduction to the tau system, see <see topic=\"ACL2____INTRODUCTION-TO-THE-TAU-SYSTEM\">introduction-to-the-tau-system</see>.</p> \u000A \u000A <p>There happens to be a <i>function</i> named <v>tau-system</v>, defined as the \u000A identity function.  Its only role is to provide the rune \u000A <v>(:EXECUTABLE-COUNTERPART TAU-SYSTEM)</v>, which is used to enable and disable \u000A the tau system.  Otherwise the function <v>tau-system</v> has no purpose and we \u000A recommend that you avoid using it so you are free to enable and disable the \u000A tau system.</p> \u000A \u000A <p>When in the default (``greedy'') mode (see <tt><see topic=\"ACL2____SET-TAU-AUTO-MODE\">set-tau-auto-mode</see></tt>), \u000A every <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> and every <v>:corollary</v> (see <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt>) \u000A of every <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> stored as a rule <i>of any</i> <v>:rule-class</v> is \u000A inspected to determine if it is of one of the forms below.  Rules of these \u000A forms are added to the tau database, even if they are not labeled as \u000A <v>:tau-system</v> rules, e.g., a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule might contribute to \u000A the tau database!  To add a rule to the tau database without adding any other \u000A kind of rule, tag it with <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> <v>:tau-system</v>.  If a \u000A theorem has <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> <v>nil</v>, it is not considered for the \u000A tau database.</p> \u000A \u000A <code>General Forms: \u000A<i>Boolean</i>: \u000A(booleanp (p v)) \u000A \u000A<i>Eval</i>: \u000A(p 'const) or \u000A(p *const*) \u000A \u000A<i>Simple</i>: \u000A(implies (p v) (q v)) \u000A \u000A<i>Conjunctive</i>: \u000A(implies (and (p1 v) ... (pk v)) (q v)), ; Here k must exceed 1. \u000A \u000A<i>Signature Form 1</i>: \u000A(implies (and (p1 x1) (p2 x2) ...) \u000A         (q (fn x1 x2 ...))) \u000A \u000A<i>Signature Form 2</i>: \u000A(implies (and (p1 x1) (p2 x2) ...) \u000A         (q (mv-nth 'n (fn x1 x2 ...)))) \u000A \u000A<i>Bounder Form 1 (or Form 2)</i>: \u000A(implies (and (tau-intervalp i1) \u000A              ... \u000A              (or (equal (tau-interval-dom i1) 'dom1-1) \u000A                  ...) \u000A              ... \u000A              (in-tau-intervalp x1 i1) \u000A              ...) \u000A         (and (tau-intervalp (bounder-fn i1 ...)) \u000A              (in-tau-intervalp <i>target</i> \u000A                                (bounder-fn i1 ...)))) \u000A \u000Awhere <i>target</i> is \u000A(fn x1 ... y1 ...)             in <i>Form 1</i>, and \u000A(mv-nth 'n (fn x1 ... y1 ...)) in <i>Form 2</i> \u000A \u000A<i>Big Switch</i>: \u000A(equal (fn . formals) body) \u000A \u000A<i>MV-NTH Synonym</i>: \u000A(equal (nth-alt x y) (mv-nth x y)) or \u000A(equal (mv-nth x y) (nth-alt x y)) \u000A</code> \u000A \u000A <p>The symbols <v>p</v>, <v>q</v>, <v>p1</v>, etc., denote monadic (one-argument) \u000A Boolean-valued function symbols, or equalities in which one argument is \u000A constant, arithmetic comparisons in which one argument is a rational or \u000A integer constant, or the logical negations of such terms.  By ``equalities'' \u000A we allow <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt>, <tt><see topic=\"COMMON-LISP____EQ\">eq</see></tt>, <tt><see topic=\"COMMON-LISP____EQL\">eql</see></tt>, and <tt><see topic=\"COMMON-LISP_____D3\">=</see></tt>.  By \u000A ``arithmetic comparison'' we mean <tt><see topic=\"COMMON-LISP_____C3\">&lt;</see></tt>, <tt><see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see></tt>, <tt><see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see></tt>, or <tt><see topic=\"COMMON-LISP_____E3\">&gt;</see></tt>.  Any of these tau predicates may appear negated.</p> \u000A \u000A <p>The notation <v>(p v)</v> above might stand for any one of:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____INTEGERP\">INTEGERP</see> X)\u000A(<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> V 'MONDAY)\u000A(<see topic=\"COMMON-LISP_____C3_D3\">&lt;=</see> I 16)\u000A(<see topic=\"COMMON-LISP____NOT\">NOT</see> (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> X 'SUNDAY))</code> \u000A \u000A <p>The different rule forms above affect different aspects of the tau system. \u000A We discuss each form in more detail below.</p> \u000A \u000A <p>The documentation below is written as though the tau system is in auto \u000A mode!  To insure that the only rules added to the tau system are those \u000A explicitly assigned to <v>:rule-class</v> <v>:tau-system</v>, you should use \u000A <tt><see topic=\"ACL2____SET-TAU-AUTO-MODE\">set-tau-auto-mode</see></tt> to select manual mode.</p> \u000A \u000A <code>General Form: <i>Boolean</i>: \u000A(booleanp (p v)) \u000A</code> \u000A \u000A <p>Here <v>p</v> must be a function symbol and <v>v</v> must be a variable.  Such \u000A a <v>:tau-system</v> rule adds <v>p</v> to the list of tau predicates.  If <v>p</v> \u000A was recognized as Boolean when it was defined, there is no need to state this \u000A rule.  This form is needed if you define a monadic Boolean function in such a \u000A way that the system does not recognize that it is Boolean.</p> \u000A \u000A <code>General Form: <i>Eval</i>: \u000A(p 'const) or \u000A(p *const*) \u000A</code> \u000A \u000A <p>Here <v>p</v> must be a function symbol.  In addition, recall that these \u000A general tau predicate forms may appear negated.  So the form above includes \u000A such theorems as <v>(<see topic=\"COMMON-LISP____NOT\">NOT</see> (GOOD-STATEP *INITIAL-STATE*))</v>.  A theorem of this \u000A form thus records whether a named predicate is true or false on the given \u000A constant.</p> \u000A \u000A <p>Generally, when the tau system must determine whether an enabled tau \u000A predicate is true or false on a constant, it simply evaluates the predicate on \u000A the constant.  This can be impossible or very inefficient if <v>p</v> is not \u000A defined but constrained, or if <v>p</v> is defined in a hard-to-compute way \u000A (e.g., <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> p (x) (<see topic=\"COMMON-LISP____EVENP\">evenp</see> (ack x x)))</v> where <v>ack</v> is the Ackermann \u000A function), or perhaps if the constant is very large.  By proving a \u000A <v>:tau-system</v> rule of Eval form, you cause the tau system to note the value \u000A of the predicate on the constant and henceforth to look it up instead of \u000A evaluating the definition.</p> \u000A \u000A <p>A difficulty, however, is determining that a slow down is due to the \u000A evaluation of tau predicates and not some other reason.  The first step is \u000A determining that tau is slowing the proof down.  See <tt><see topic=\"ACL2____TIME-TRACKER-TAU\">time-tracker-tau</see></tt> \u000A for an explanation of <v>TIME-TRACKER-NOTE</v>s output during some proofs \u000A involving tau reasoning.  These notes can alert you to the fact that \u000A significant amounts of time are being spent in the tau system.  <tt><see topic=\"ACL2____TIME-TRACKER-TAU\">Time-tracker-tau</see></tt> gives some ways of determining whether tau predicate \u000A evaluation is involved.  (If worse comes to worst, consider the following \u000A hack: In the ACL2 source file <v>tau.lisp</v>, immediately after the definition \u000A of the system function <v>ev-fncall-w-tau-recog</v>, there is a comment which \u000A contains some raw Lisp code that can be used to investigate whether tau's use \u000A of evaluation on constants is causing a problem.)  However, once a recognizer \u000A and the constants on which it is being evaluated are identified, the tau \u000A system can be sped up by proving Eval rules to pre-compute and store the \u000A values of the recognizer on those constants.  Alternatively, at the possible \u000A loss of some completeness in the tau system, the executable counterpart of the \u000A recognizer can be disabled.</p> \u000A \u000A <code>General Form: <i>Simple</i>: \u000A(implies (p v) (q v)) \u000A</code> \u000A \u000A <p>Here <v>v</v> must be a variable symbol.  This rule builds-in the information \u000A that anything satisfying <v>p</v> must also satisfy <v>q</v>, i.e., the ``type'' \u000A <v>q</v> includes the ``type'' <v>p</v>.  Recall that the forms may be negated. \u000A Most of the time, <v>p</v> and <v>q</v> will be predicate symbols but it is \u000A possible they will be equalities- or inequalities-with-constants.  Examples of \u000A Simple rules include the following, which are in fact built-in:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____NATP\">natp</see> x) (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x))\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x) (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> x))\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x) (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)))\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____NATP\">natp</see> x) (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP_____C3\">&lt;</see> x 0)))\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____SYMBOL-ALISTP\">symbol-alistp</see> x) (<see topic=\"ACL2____ALISTP\">alistp</see> x))</code> \u000A \u000A <p>Because the tau system records the transitive closure of the Simple rules, \u000A any time a term is known to satisfy <v>natp</v> it is also known to satisfy \u000A <v>integerp</v> and <v>rationalp</v>, and known not to satisfy <v>true-listp</v>, \u000A and known to be non-negative.</p> \u000A \u000A <code>General Form: <i>Conjunctive</i>: \u000A(implies (and (p1 v) ... (pk v)) (q v)), ; Here k must exceed 1. \u000A</code> \u000A \u000A <p>The <v>pi</v> and <v>q</v> may be any tau predicates or their negations, <v>v</v> \u000A must be a variable symbol, and <v>i</v> must exceed 1 or else this is a Simple \u000A rule.  An obvious operational interpretation of this rule is that if an object \u000A is known to satisfy all of the <v>pi</v>, then it is known to satisfy <v>q</v>. \u000A However, the actual interpretation is more general.  For example, if an object \u000A is known to satisfy all but one of the <v>pi</v> and is known not to satisfy \u000A <v>q</v>, then the object is known not to satisfy the ``missing'' <v>pi</v>.</p> \u000A \u000A <p>For example, the following Conjunctive rule allows tau to conclude that if \u000A weekday <v>D</v> is not <v>MON</v>, <v>TUE</v>, <v>THU</v> or <v>FRI</v>, then it is \u000A <v>WED</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (weekdayp d)\u000A              (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQ\">eq</see> d 'MON))\u000A              (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQ\">eq</see> d 'TUE))\u000A              (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQ\">eq</see> d 'WED))\u000A              (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQ\">eq</see> d 'THU)))\u000A         (<see topic=\"COMMON-LISP____EQ\">eq</see> d 'FRI))</code> \u000A \u000A <p>The tau database is not closed under conjunctive rules; they are applied \u000A dynamically.</p> \u000A \u000A <code>General Form: <i>Signature Form 1</i>: \u000A(implies (and (p1 x1) (p2 x2) ... (pn xn) dep-hyp) \u000A         (q (fn x1 x2 ... xn))) \u000A</code> \u000A \u000A <p>The <v>pi</v> and <v>q</v> may be any tau predicates or their negations, \u000A <v>fn</v> must be a function symbol of arity <v>n</v>, the <v>xi</v> must be \u000A distinct variable symbols and <v>dep-hyp</v> may be any term, provided it is not \u000A of the <v>(pi xi)</v> shape and the only the variables in it are the \u000A <v>xi</v>.</p> \u000A \u000A <p>The Signature form actually allows multiple tau predicates to be applied to \u000A each variable, e.g., x1 might be required to be both an <v>INTEGERP</v> and \u000A <v>EVENP</v>.  The Signature form allows there to be multiple hypotheses \u000A classified as <v>dep-hyp</v>s, i.e., not fitting any of the previous shapes, and \u000A they are implicitly just conjoined.  The name ``dep-hyp'' is an abbreviation \u000A of ``dependent hypothesis'' and stems from the fact they often express \u000A relations between several of the function's inputs rather than type-like \u000A constraints on individual inputs.</p> \u000A \u000A <p>A Signature rule informs tau that the function <v>fn</v> returns an object \u000A satisfying <v>q</v> provided that the arguments satisfy the respective <v>pi</v> \u000A and provided that <v>dep-hyp</v> occurs in the current context.  Note: to be \u000A precise, dependent hypotheses are relieved only by applying ACL2's most \u000A primitive form of reasoning, <see topic=\"ACL2____TYPE-SET\">type-set</see>.  In particular, tau reasoning is \u000A not used to establish dependent hypotheses.  The presence of a <v>dep-hyp</v> in \u000A a signature rule may severely restrict its applicability.  We discuss this \u000A after showing a few mundane examples.</p> \u000A \u000A <p>An example Signature rule is</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> x)\u000A              (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> y))\u000A         (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x y)))</code> \u000A \u000A <p>Of course, a function may have multiple signatures:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> x)\u000A              (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> y))\u000A         (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> x y)))</code> \u000A \u000A <p>Here is a Signature rule for the function <v>pairlis$</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> x)\u000A              (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> y))\u000A         (<see topic=\"ACL2____SYMBOL-ALISTP\">symbol-alistp</see> (<see topic=\"ACL2____PAIRLIS_42\">pairlis$</see> x y)))</code> \u000A \u000A <p>The tau system can consequently check this theorem by composing the last \u000A two rules shown and exploiting Simple rule stating that symbol-alists are also \u000A alists:</p> \u000A \u000A <code>(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> a)\u000A                   (<see topic=\"ACL2____SYMBOL-LISTP\">symbol-listp</see> b)\u000A                   (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> y))\u000A              (<see topic=\"ACL2____ALISTP\">alistp</see> (<see topic=\"ACL2____PAIRLIS_42\">pairlis$</see> (<see topic=\"COMMON-LISP____APPEND\">append</see> a b) y))))</code> \u000A \u000A <p>Since <v>a</v> and <v>b</v> are known to be lists of symbols and a signature \u000A for <v>append</v> is that it preserves that predicate, the first argument to the \u000A <v>pairlis$</v> expression is known to be a list of symbols.  This means the \u000A Signature rule for <v>pairlis$</v> tells us the result is a <v>symbol-alistp</v>, \u000A but the previously mentioned Simple rule, <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"ACL2____SYMBOL-ALISTP\">symbol-alistp</see> x)\u000A (<see topic=\"ACL2____ALISTP\">alistp</see> x))</v>, tells us the result is also an <v>alistp</v>.</p> \u000A \u000A <p>When a Signature rule has an <v>dep-hyp</v>, that hypothesis is not an \u000A expression in the tau system.  Tau is not used to check that hypothesis. \u000A Instead, tau uses the more primitive <see topic=\"ACL2____TYPE-SET\">type-set</see> mechanism of ACL2.  Here \u000A is an example of a Signature rule with a <v>dep-hyp</v>:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____NATP\">natp</see> n)\u000A              (<see topic=\"ACL2____INTEGER-LISTP\">integer-listp</see> a)\u000A              (<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> a)))\u000A         (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n a)))</code> \u000A \u000A <p>Note that the last hypothesis is a dependent hypothesis: it is not a tau \u000A predicate but a relationship between <v>n</v> and <v>a</v>.  It is relieved by \u000A <see topic=\"ACL2____TYPE-SET\">type-set</see>.  If one is trying to compute the signature of an <v>(<see topic=\"COMMON-LISP____NTH\">nth</see> n\u000A a)</v> expression in a context in which <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> a))</v> is explicitly \u000A assumed, then this mechanism would establish the dependent hypothesis.  But \u000A one can easily imagine an almost identical context where, say <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see>\u000A (rev a)))</v> is explicitly assumed.  In that context, the Signature rule would \u000A not be fired because <tt><see topic=\"ACL2____TYPE-SET\">type-set</see></tt> cannot establish <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> a))</v> from \u000A <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> n (<see topic=\"ACL2____LEN\">len</see> (rev a)))</v>, even though it would be easily proved by rewriting \u000A using the theorem <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____LEN\">len</see> (rev a)) (<see topic=\"ACL2____LEN\">len</see> a))</v>.</p> \u000A \u000A <p>Note also that if this signature could be phrased in a way that eliminates \u000A the dependency between <v>n</v> and <v>a</v> it would be more effective.  For \u000A example, here is a related Signature rule without a dependent hypothesis:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____NATP\">natp</see> n)\u000A              (register-filep a)\u000A              (<see topic=\"COMMON-LISP_____C3\">&lt;</see> n 16))\u000A         (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n a)))</code> \u000A \u000A <p>In this theorem we require only that <v>n</v> be less than 16, which is a tau \u000A predicate and hence just an additional tau constraint on <v>n</v>.</p> \u000A \u000A <code>General Form: <i>Signature Form 2</i>: \u000A(implies (and (p1 x1) (p2 x2) ... (pn xn) dep-hyp) \u000A \u000A         (q (mv-nth 'n (fn x1 x2 ... xn)))) \u000A</code> \u000A \u000A <p>This form of signature rule is just like form 1 except that it is useful \u000A for functions that return multiple-values and allows us to ``type-check'' \u000A their individual outputs.</p> \u000A \u000A <code>General Form: <i>Bounder Forms 1 and 2</i>: \u000A(implies (and (tau-intervalp i1) \u000A              ... \u000A              (or (equal (tau-interval-dom i1) 'dom1-1) \u000A                  ...) \u000A              ... \u000A              (in-tau-intervalp x1 i1) \u000A              ...) \u000A         (and (tau-intervalp (bounder-fn i1 ...)) \u000A              (in-tau-intervalp <i>target</i> \u000A                                (bounder-fn i1 ...)))) \u000A</code> \u000A \u000A <p>where <i>target</i> is either <v>(fn x1 ... y1 ...)</v> in <i>Form 1</i> or \u000A <v>(<see topic=\"ACL2____MV-NTH\">mv-nth</see> 'n (fn x1 ... y1 ...))</v> in <i>Form 2</i>.</p> \u000A \u000A <p>This form is for advanced users only and the schema given above is just a \u000A reminder of the general shape.  A ``bounder'' for a given function symbol, \u000A <v>fn</v>, is a function symbol <v>bounder-fn</v> that computes an interval \u000A containing <v>(fn x1 ... y1 ...)</v> (or its <v>n</v>th component in the case of \u000A Form 2 rules) from the intervals containing certain of the arguments of \u000A <v>fn</v>.  The correctness theorem for a bounder function informs the tau \u000A system that bounds for <v>fn</v> are computed by <v>bounder-fn</v> and sets up the \u000A correspondence between the relevant arguments, <v>xi</v>, of <v>fn</v> and the \u000A intervals containing those arguments, <v>ii</v> to which <v>bounder-fn</v> is \u000A applied.  When the tau system computes the tau for a call of <v>fn</v>, it \u000A computes the tau of the relevant arguments and applies the bounder to the \u000A intervals of those tau.  This provides a domain and upper and/or lower bounds \u000A for the value of the term.  The tau system then further augments that with \u000A signature rules.  See <see topic=\"ACL2____BOUNDERS\">bounders</see> for details on intervals, bounders, and \u000A bounder correctness theorems.</p> \u000A \u000A <code>General Form: <i>Big Switch</i>: \u000A(equal (fn . formals) body) \u000A</code> \u000A \u000A <p>In the Big Switch form, <v>fn</v> must be a function symbol, <v>formals</v> \u000A must be a list of distinct variable symbols, and <v>body</v> must be a ``big \u000A switch'' term, i.e., one that case splits on tau predicates about a single \u000A variable and produces a term not involving that variable.  An example of a Big \u000A Switch rule is</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (conditional-type x y)\u000A       (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A           (<see topic=\"COMMON-LISP____CONSP\">consp</see> y)\u000A           (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> y)))</code> \u000A \u000A <p>The idea is that the tau system can treat calls of <v>conditional-type</v> as \u000A a tau-predicate after determining the tau of an argument.</p> \u000A \u000A <p>Since equality-to-constants are tau predicates, a more common example of a \u000A Big Switch rule is</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (dtypep x expr)\u000A       (<see topic=\"COMMON-LISP____CASE\">case</see> x\u000A             (STMT (stmt-typep expr))\u000A             (EXPR (expr-typep expr))\u000A             (MODULE (module-typep expr))\u000A             (otherwise nil)))</code> \u000A \u000A <p>This is because <v>(<see topic=\"COMMON-LISP____CASE\">case</see> x (STMT ...) ...)</v> macroexpands in ACL2 to <v>(<see topic=\"COMMON-LISP____IF\">if</see>\u000A (<see topic=\"COMMON-LISP____EQL\">eql</see> x 'STMT) ... ...)</v> and <v>(<see topic=\"COMMON-LISP____EQL\">eql</see> x 'STMT)</v> is a tau predicate about \u000A <v>x</v>.</p> \u000A \u000A <p>Big Switch rules are recognized when a function is defined (if tau is in \u000A automatic mode).  They generally do not have to be proved explicitly, though \u000A they might be when mutual recursion is involved.  Only the first detected Big \u000A Switch rule about a function <v>fn</v> is recognized.</p> \u000A \u000A <code>General Form: <i>MV-NTH Synonym</i>: \u000A(equal (nth-alt x y) (mv-nth x y)) or \u000A(equal (mv-nth x y) (nth-alt x y)) \u000A</code> \u000A \u000A <p>Rules of this form just tell the tau system that the user-defined function \u000A <v>nth-alt</v> is synonymous with the ACL2 primitive function <v>mv-nth</v>. \u000A Because ACL2's rewriter gives special handling to <v>mv-nth</v>, users sometimes \u000A define their own versions of that function so they can disable them and \u000A control rewriting better.  By revealing to the tau system that such a synonym \u000A has been introduced you allow Signature rules of Form 2 to be used.</p>"],

 "ACL2____CHARACTERS":[["Programming"],"ACL2 Sources","ACL2","<p>ACL2 accepts 256 distinct characters, which are the characters \u000A obtained by applying the function <tt><see topic=\"COMMON-LISP____CODE-CHAR\">code-char</see></tt> to each integer from \u000A <v>0</v> to <v>255</v>.  Among these, Common Lisp designates certain ones as \u000A <i>standard characters</i>, namely those of the form <v>(<see topic=\"COMMON-LISP____CODE-CHAR\">code-char</see> n)</v> where \u000A <v>n</v> is from <v>33</v> to <v>126</v>, together with <v>#\\Newline</v> and \u000A <v>#\\Space</v>.  The actual standard characters may be viewed by evaluating the \u000A <tt><see topic=\"ACL2____DEFCONST\">defconst</see></tt> <v>*standard-chars*</v>.</p> \u000A \u000A <p>To be more precise, Common Lisp does not specify the precise relationship \u000A between <tt><see topic=\"COMMON-LISP____CODE-CHAR\">code-char</see></tt> and the standard characters.  However, we check that \u000A the underlying Common Lisp implementation uses a particular relationship that \u000A extends the usual ASCII coding of characters.  We also check that Space, Tab, \u000A Newline, Page, and Rubout correspond to characters with respective <tt><see topic=\"COMMON-LISP____CHAR-CODE\">char-code</see></tt>s <v>32</v>, <v>9</v>, <v>10</v>, <v>12</v>, and <v>127</v>.</p> \u000A \u000A <p><tt><see topic=\"COMMON-LISP____CODE-CHAR\">Code-char</see></tt> has an inverse, <tt><see topic=\"COMMON-LISP____CHAR-CODE\">char-code</see></tt>.  Thus, when <tt><see topic=\"COMMON-LISP____CHAR-CODE\">char-code</see></tt> is applied to an ACL2 character, <v>c</v>, it returns a number <v>n</v> \u000A between <v>0</v> and <v>255</v> inclusive such that <v>(<see topic=\"COMMON-LISP____CODE-CHAR\">code-char</see> n)</v> = \u000A <v>c</v>.</p> \u000A \u000A <p>The preceding paragraph implies that there is only one ACL2 character with \u000A a given character code.  CLTL allows for ``attributes'' for characters, which \u000A could allow distinct characters with the same code, but ACL2 does not allow \u000A this.</p> \u000A \u000A <p><i>The Character Reader</i></p> \u000A \u000A <p>ACL2 supports the `<v>#\\</v>' notation for characters provided by Common \u000A Lisp, with some restrictions.  First of all, for every character <v>c</v>, the \u000A notation</p> \u000A \u000A <code>#\\c</code> \u000A \u000A <p>may be used to denote the character object <v>c</v>.  That is, the user may \u000A type in this notation and ACL2 will read it as denoting the character object \u000A <v>c</v>.  In this case, the character immediately following <v>c</v> must be one \u000A of the following ``terminating characters'': a Tab, a Newline, a Page \u000A character, a space, or one of the characters:</p> \u000A \u000A <code>&quot;  '  (  )  ;  `  ,</code> \u000A \u000A <p>Other than the notation above, ACL2 accepts alternate notation for five \u000A characters.</p> \u000A \u000A <code>#\\Space\u000A#\\Tab\u000A#\\Newline\u000A#\\Page\u000A#\\Rubout</code> \u000A \u000A <p>Again, in each of these cases the next character must be from among the set \u000A of ``terminating characters'' described in the single-character case.  Our \u000A implementation is consistent with IS0-8859, even though we don't provide \u000A <v>#\\</v> syntax for entering characters other than that described above.</p> \u000A \u000A <p>Finally, we note that it is our intention that any object printed by ACL2's \u000A top-level-loop may be read back into ACL2.  Please notify the implementors if \u000A you find a counterexample to this claim.</p>"],

 "ACL2____PROGRAMMING-WITH-STATE":[["State","Programming"],"ACL2 Sources","ACL2","<p>This <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> section introduces some common techniques \u000A for programming using the ACL2 state object.  A prerequisite is thus a basic \u000A understanding of that object; see <see topic=\"ACL2____STATE\">state</see>.  We hope this section is \u000A useful, and we invite suggestions for improvements and additions.</p> \u000A \u000A <p>A supplement to this section is the ACL2 source code, which uses most (and \u000A probably all) of the techniques discussed here.  That code is thus a source of \u000A many examples, which can serve as ``templates'' to guide one's own programming \u000A with state.</p> \u000A \u000A <p>Recall that ``ACL2'' stands for ``A Computational Logic for Applicative \u000A Common Lisp''.  In particular, the language is applicative: there are no \u000A global variables or side effects.  For many purposes this does not feel \u000A restrictive; for example, an ACL2 user who is programming in raw Lisp may well \u000A be more comfortable coding a factorial function applicatively, using \u000A recursion, rather than using iteration with repeated assignment to the same \u000A variable.</p> \u000A \u000A <p>However, there are situations that call for reading or modifying the system \u000A state, such as performing input and output, signalling errors, saving \u000A information from one computation for use in a later one, or reading and \u000A updating system-level or environmental data.  This section provides an \u000A introductory guide for writing functions that traffic in state.  We emphasize \u000A that this guide is intended as an introduction; more complete documentation \u000A may often be found by following links to documentation of individual \u000A utilities, and again, more examples may be found by searching the ACL2 source \u000A code for uses of the functions and macros mentioned below.  The rest of this \u000A section is organized as follows.</p> \u000A \u000A <code>ENABLING PROGRAMMING WITH STATE\u000ASTATE GLOBALS AND THE ACL2 LOGICAL WORLD\u000AA REMARK ON GUARDS\u000AERRORS AND ERROR TRIPLES\u000ASEQUENTIAL PROGRAMMING\u000ABINDING VARIABLES USING ERROR TRIPLES\u000ABINDING STATE GLOBAL VARIABLES\u000AINPUT AND OUTPUT\u000ATIMINGS\u000AENVIRONMENT AND SYSTEM\u000AREMARKS ON EVENTS AND LD\u000AADVANCED TOPICS</code> \u000A \u000A <p>ENABLING PROGRAMMING WITH STATE</p> \u000A \u000A <p>In order to submit a definition that takes <tt><see topic=\"ACL2____STATE\">state</see></tt> as a formal \u000A parameter, you must either declare <v>state</v> as a <v>:</v><tt><see topic=\"ACL2____STOBJ\">stobj</see></tt> (see \u000A <see topic=\"ACL2____XARGS\">xargs</see>) or first evaluate the following form at the top level: \u000A <v>(<see topic=\"ACL2____SET-STATE-OK\">set-state-ok</see> t)</v>.</p> \u000A \u000A <p>Consider for example the following trivial definition.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (<see topic=\"ACL2____STATE\">state</see>)\u000A  (<see topic=\"ACL2____MV\">mv</see> 3 state))</code> \u000A \u000A <p>If you submit the above definition in a fresh ACL2 session, you will get \u000A this error message.</p> \u000A \u000A <code>ACL2 Error in ( DEFUN FOO ...):  The variable symbol STATE should not\u000Abe used as a formal parameter of a defined function unless you are\u000Aaware of its unusual status and the restrictions enforced on its use.\u000ASee :DOC set-state-ok.</code> \u000A \u000A <p>If first you evaluate <v>(<see topic=\"ACL2____SET-STATE-OK\">set-state-ok</see> t)</v>, you can admit the above \u000A definition.  Alternatively, you can declare <v>state</v> as a <v>:</v><tt><see topic=\"ACL2____STOBJ\">stobj</see></tt>, as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (<see topic=\"ACL2____STATE\">state</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :stobjs state))\u000A  (<see topic=\"ACL2____MV\">mv</see> 3 state))</code> \u000A \u000A <p>A difference in the two approaches is that for the latter, a <see topic=\"ACL2____GUARD\">guard</see> \u000A proof obligation is generated by default.  See the section below entitled ``A \u000A remark on guards''.</p> \u000A \u000A <p>STATE GLOBALS AND THE ACL2 LOGICAL WORLD</p> \u000A \u000A <p>Recall (see <see topic=\"ACL2____STATE\">state</see>) that one of the fields of the ACL2 state object \u000A is the global-table, which logically is an alist associating symbols, known as \u000A ``state globals'' or ``state global variables'', with values.  But no such \u000A alist actually exists in the implementation.  Instead, ACL2 provides utilities \u000A for reading state globals &mdash; see <see topic=\"ACL2_____04\">@</see> and see <see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> \u000A &mdash; and utilities for writing them &mdash; see <see topic=\"ACL2____ASSIGN\">assign</see> and see <see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see>.  The following log shows how they work; further explanation \u000A follows below.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSIGN\">assign</see> my-var (<see topic=\"COMMON-LISP_____B2\">+</see> 3 4))\u000A 7\u000AACL2 !&gt;(<see topic=\"ACL2_____04\">@</see> my-var)\u000A7\u000AACL2 !&gt;(<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'my-var (<see topic=\"COMMON-LISP_____B2\">+</see> 1 5) state)\u000A&lt;state&gt;\u000AACL2 !&gt;(<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'my-var state)\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p>Note that the first result is indented by one space.  This is ACL2's way to \u000A indicate that the <tt><see topic=\"ACL2____ASSIGN\">assign</see></tt> expression returned an ``error triple'' and \u000A that no error was signalled.  We discuss error triples in more detail below; \u000A also see <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>.</p> \u000A \u000A <p>As illustrated above, the output signatures of the utilities for assigning \u000A to state globals differ from each other as follows: <tt><see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see></tt> \u000A returns <v>state</v>, but <tt><see topic=\"ACL2____ASSIGN\">assign</see></tt> returns an error triple <v>(<see topic=\"ACL2____MV\">mv</see> nil val\u000A state)</v> where <v>val</v> is the value assigned to the state global.  The output \u000A signatures of the utilities for reading, <v>@</v> and <v>f-get-global</v>, are \u000A identical.  In fact, the form <v>(<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'my-var state)</v> is the \u000A single-step macroexpansion of the form <v>(<see topic=\"ACL2_____04\">@</see> my-var)</v>, as can be confirmed \u000A using <tt><see topic=\"ACL2____TRANS1\">trans1</see></tt>.</p> \u000A \u000A <code>ACL2 !&gt;:trans1 (<see topic=\"ACL2_____04\">@</see> my-var)\u000A (<see topic=\"ACL2____F-GET-GLOBAL\">F-GET-GLOBAL</see> 'MY-VAR STATE)\u000AACL2 !&gt;</code> \u000A \u000A <p>State globals are useful for conveying persistent state information. \u000A Consider for example the utility <tt><see topic=\"ACL2____SET-INHIBIT-OUTPUT-LST\">set-inhibit-output-lst</see></tt>.  The form \u000A <v>(<see topic=\"ACL2____SET-INHIBIT-OUTPUT-LST\">set-inhibit-output-lst</see> '(prove proof-tree))</v> is approximately equivalent \u000A to (assign inhibit-output-lst '(prove proof-tree)).  We say ``approximately'' \u000A because <v>set-inhibit-output-lst</v> additionally does some error checking to \u000A insure that all the tokens in the new list are legal.  When deciding whether \u000A to print output, the ACL2 system reads the value of state global variable \u000A <v>inhibit-output-lst</v>.</p> \u000A \u000A <p>A particularly useful state global is <v>current-acl2-world</v>, whose value \u000A is the ACL2 logical <see topic=\"ACL2____WORLD\">world</see>.  Because the ACL2 world is commonly accessed \u000A in applications that use the ACL2 state, ACL2 provides a function that returns \u000A the world: <v>(w state) = (<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'current-acl2-world state)</v>.  While \u000A it is common to read the world, only functions <v>set-w</v> and <v>set-w!</v> are \u000A available to write the world, but these are untouchable and these should \u000A generally be avoided except by system implementors \u000A (pl[remove-untouchable]).</p> \u000A \u000A <p>A REMARK ON GUARDS</p> \u000A \u000A <p>For a function definition (see <see topic=\"COMMON-LISP____DEFUN\">defun</see>), if <v>state</v> is specified as \u000A a <see topic=\"ACL2____STOBJ\">stobj</see> as with the form <v>(<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :stobjs state))</v>, then the \u000A <see topic=\"ACL2____GUARD\">guard</see> for that function is considered to include the condition \u000A <v>(state-p state)</v>.  By default, <see topic=\"ACL2____GUARD\">guard</see> verification will then be \u000A performed.</p> \u000A \u000A <p>We can illustrate this point by modifying the example above as follows, to \u000A read the value of state global <v>gag-mode</v>.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (<see topic=\"ACL2____STATE\">state</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :stobjs state))\u000A  (<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'gag-mode state))</code> \u000A \u000A <p>If you try this in a fresh ACL2 session, the proof will fail with the \u000A following key checkpoint, which says that the state global <v>gag-mode</v> is \u000A bound in the global-table of the state.</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (STATE-P1 STATE)\u000A         (<see topic=\"ACL2____ASSOC-EQUAL\">ASSOC-EQUAL</see> 'GAG-MODE (<see topic=\"COMMON-LISP____NTH\">NTH</see> 2 STATE)))</code> \u000A \u000A <p>How can we deal with this proof failure?  One way is simply to ignore the \u000A issue by defining the function in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode, as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (<see topic=\"ACL2____STATE\">state</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :stobjs state\u000A                  :mode :program))\u000A  (<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'gag-mode state))</code> \u000A \u000A <p>Perhaps a better way is to strengthen the guard to assert that the \u000A indicated state global is bound, as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (<see topic=\"ACL2____STATE\">state</see>)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (boundp-global 'gag-mode state)\u000A                  :stobjs state))\u000A  (<see topic=\"ACL2____F-GET-GLOBAL\">f-get-global</see> 'gag-mode state))</code> \u000A \u000A <p>Also see <see topic=\"ACL2____GUARD-MISCELLANY\">guard-miscellany</see> for a discussion of how guards are \u000A generated from <tt><see topic=\"ACL2____XARGS\">xargs</see></tt> fields of <see topic=\"COMMON-LISP____DECLARE\">declare</see> forms, specifically, for \u000A keywords <v>:guard</v> and <v>:stobjs</v>.</p> \u000A \u000A <p>ERRORS AND ERROR TRIPLES</p> \u000A \u000A <p>When evaluation returns three values, where the first two are ordinary \u000A objects and the third is the ACL2 state, the result may be called an ``error \u000A triple''.  (Whether it is treated as an error triple depends on the \u000A programmer.)  Error triples are often denoted <v>(<see topic=\"ACL2____MV\">mv</see> erp val state)</v>, and \u000A common ACL2 programming idioms treat <v>erp</v> as a flag indicating whether an \u000A error is being signalled and <v>val</v> as the ``value'' computed.  Also see \u000A <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>.</p> \u000A \u000A <p>Even ACL2 users who are not programmers encounter error triples, because \u000A these are the values returned by evaluation of ACL2 <see topic=\"ACL2____EVENTS\">events</see>.  Consider \u000A the following log, where the only user input is the <v>defun</v> form following \u000A the <see topic=\"ACL2____PROMPT\">prompt</see>.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)\u000A\u000ASince FOO is non-recursive, its admission is trivial.  We observe that\u000Athe type of FOO is described by the theorem (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (FOO X) X).\u000A\u000ASummary\u000AForm:  ( DEFUN FOO ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A FOO\u000AACL2 !&gt;</code> \u000A \u000A <p>All output above results from explicit calls of output functions, except \u000A for the next-to-last line, which contains <v>FOO</v>.  Notice the single-space \u000A indentation preceding <v>FOO</v>.  That space indicates that in fact, the value \u000A returned by evaluation of the <v>defun</v> form is the error triple whose error \u000A flag is <v>nil</v> and whose computed value is <v>FOO</v>.  By default, ACL2 \u000A prints any error triple <v>(<see topic=\"ACL2____MV\">mv</see> nil val state)</v> by inserting a space before \u000A printing <v>val</v>.  You can change the default by setting state global <tt><see topic=\"ACL2____LD-POST-EVAL-PRINT\">ld-post-eval-print</see></tt> to <v>t</v>; notice how the same result is printed \u000A below.</p> \u000A \u000A <code>ACL2 !&gt;:u\u000A          0:x(<see topic=\"ACL2____EXIT-BOOT-STRAP-MODE\">EXIT-BOOT-STRAP-MODE</see>)\u000AACL2 !&gt;(set-ld-post-eval-print t state)\u000A(NIL T &lt;state&gt;)\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x) x)\u000A\u000ASince FOO is non-recursive, its admission is trivial.  We observe that\u000Athe type of FOO is described by the theorem (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (FOO X) X).\u000A\u000ASummary\u000AForm:  ( DEFUN FOO ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A(NIL FOO &lt;state&gt;)\u000AACL2 !&gt;</code> \u000A \u000A <p>The way error triples are printed by <v>ld</v> is controlled not only by \u000A state global <v>ld-post-eval-print</v>, but also by state global \u000A <v>ld-error-triples</v>.  These are examples of ``ld specials''; see <see topic=\"ACL2____LD\">ld</see>, \u000A see <see topic=\"ACL2____LD-POST-EVAL-PRINT\">ld-post-eval-print</see>, and see <see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see>.</p> \u000A \u000A <p>It is so common to produce an error triple whose first (error flag) \u000A component is <v>nil</v> that ACL2 provides a handy macro, <v>value</v>, for this \u000A purpose.  Thus, <v>(value &lt;expression&gt;)</v> is equivalent to <v>(<see topic=\"ACL2____MV\">mv</see> nil\u000A &lt;expression&gt; state)</v>.  Also see <see topic=\"ACL2____VALUE-TRIPLE\">value-triple</see> for a similar construct \u000A that is a legal event form.</p> \u000A \u000A <p>We turn now to the topic of errors.  The macro <tt><see topic=\"ACL2____ER\">er</see></tt> ``causes'' an \u000A error, but there are really two quite different kinds of errors: ``soft'' and \u000A ``hard'' errors.  We use the term ``soft error'' to refer to a form that \u000A returns an error triple <v>(<see topic=\"ACL2____MV\">mv</see> erp val state)</v> for which <v>erp</v> is \u000A non-<v>nil</v>.  Soft errors do not interrupt the normal flow of evaluation: the \u000A error triple is returned to the caller which interprets the <v>erp</v> flag and \u000A <v>val</v> as directed by the programmer.  Macros discussed below make it \u000A convenient to think about soft errors as short-circuiting the computation. \u000A Hard errors, on the other hand, do actually rip control away from the current \u000A evaluation and return it to the top-level loop.  Logically speaking, \u000A expressions that cause hard errors return <v>nil</v> in the error case, but the \u000A <v>nil</v> is never seen in actual evaluation because control does not return to \u000A the caller.</p> \u000A \u000A <p>Note that the function <tt><see topic=\"ACL2____ABORT_12\">abort!</see></tt>, which you can invoke by typing \u000A <v>:</v><tt><see topic=\"ACL2____A_12\">a!</see></tt>, always returns to the top level.  Note that ACL2 can prove \u000A that <v>(<see topic=\"ACL2____ABORT_12\">abort!</see>)</v> returns <v>nil</v> but that this cannot be confirmed by \u000A computation.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____ABORT_12\">abort!</see>) nil))\u000A\u000AQ.E.D.\u000A\u000ASummary\u000AForm:  ( THM ...)\u000ARules: ((:FAKE-RUNE-FOR-TYPE-SET NIL)\u000A        (:TYPE-PRESCRIPTION ABORT!))\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A\u000AProof succeeded.\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____ABORT_12\">abort!</see>) nil)\u000AAbort to ACL2 top-level\u000A...\u000AACL2 !&gt;</code> \u000A \u000A <p>(What actually happens with a hard error, including non-default cases, is a \u000A bit subtle; most readers will probably want to skip this paragraph.  The \u000A read-eval-print loop implemented by <tt><see topic=\"ACL2____LD\">ld</see></tt> is implemented by a call of the \u000A ACL2 evaluator function, <v>trans-eval</v>, on each input form.  If a hard error \u000A occurs during evaluation of an input form, its <v>trans-eval</v> call will \u000A return with a soft error.  <tt><see topic=\"ACL2____LD\">Ld</see></tt>, in turn handles that soft error \u000A appropriately; see <see topic=\"ACL2____LD-ERROR-ACTION\">ld-error-action</see>.)</p> \u000A \u000A <p>The most common way to signal errors is the macro <tt><see topic=\"ACL2____ER\">er</see></tt>, which prints \u000A a formatted error message and returns a soft or hard error as specified by the \u000A call.  Note however that soft errors are signalled using <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> \u000A mode functions.</p> \u000A \u000A <p>Since the output signatures of soft and hard errors are different &mdash; \u000A hard errors ``return'' a single value while soft errors return a triple \u000A &mdash; mixing them in an expression requires embedding the hard error form in \u000A (an irrelevant) triple, as illustrated below.  All branches of the expression \u000A must produce an error triple if any branch does.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> chk-find-or-abort (e x state)\u000A         (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :mode :program))\u000A         (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____ENDP\">endp</see> x)\u000A             (value                          ; Note use of VALUE!\u000A               (<see topic=\"ACL2____ER\">er</see> hard 'chk-find-or-abort\u000A                   &quot;Did not find ~x0!&quot;\u000A                    e))\u000A             (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x)))\u000A                 (<see topic=\"ACL2____ER\">er</see> soft 'chk-find-or-abort\u000A                     &quot;Non-integer, ~x0, in list!&quot;\u000A                     (<see topic=\"COMMON-LISP____CAR\">car</see> x))\u000A                 (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____EQL\">eql</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) e)\u000A                     (value x)\u000A                     (chk-find-or-abort e (<see topic=\"COMMON-LISP____CDR\">cdr</see> x) state)))))\u000A\u000ASummary\u000AForm:  ( DEFUN CHK-FIND-OR-ABORT ...)\u000ARules: NIL\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A CHK-FIND-OR-ABORT\u000AACL2 !&gt;(chk-find-or-abort 3 '(1 2 3 4 5) state)\u000A (3 4 5)\u000AACL2 !&gt;(chk-find-or-abort 3 '(1 A 3 4 5) state)\u000A\u000AACL2 Error in CHK-FIND-OR-ABORT:  Non-integer, A, in list!\u000A\u000AACL2 !&gt;(chk-find-or-abort 3 '(1 2 4 5) state)\u000A\u000AHARD ACL2 ERROR in CHK-FIND-OR-ABORT:  Did not find 3!\u000A...\u000AACL2 !&gt;</code> \u000A \u000A <p>See <see topic=\"ACL2____ER\">er</see> for further discussion of errors.  For some other individual \u000A topics related to errors see <see topic=\"ACL2____ASSERT_42\">assert$</see>, see <see topic=\"ACL2____BREAK-ON-ERROR\">break-on-error</see>, see \u000A <see topic=\"ACL2____ERROR1\">error1</see>, see <see topic=\"ACL2____HARD-ERROR\">hard-error</see>, see <see topic=\"ACL2____ILLEGAL\">illegal</see>, and see <see topic=\"ACL2____LD-ERROR-TRIPLES\">ld-error-triples</see>.</p> \u000A \u000A <p>In the next section we discuss soft errors further, in the context of \u000A programming.</p> \u000A \u000A <p>SEQUENTIAL PROGRAMMING</p> \u000A \u000A <p>This section describes handy ways to modify state in steps, using macros \u000A that implement a sequence of <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> or <tt><see topic=\"ACL2____MV-LET\">mv-let</see></tt> bindings.  For \u000A example, suppose you want to assign the values 1 and 2 to two state globals \u000A <v>one-var</v> and <v>two-var</v>, respectively.  Because of ACL2's syntactic \u000A restrictions on <tt><see topic=\"ACL2____STATE\">state</see></tt>, it is not legal simply to write \u000A <v>(<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'two-var 2 (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'one-var 1 state))</v>.  However, \u000A <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> comes to the rescue as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____LET\">let</see> ((<see topic=\"ACL2____STATE\">state</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'one-var 1 state)))\u000A  (<see topic=\"COMMON-LISP____LET\">let</see> ((<see topic=\"ACL2____STATE\">state</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'two-var 2 state)))\u000A    state))</code> \u000A \u000A <p>It is so common to bind state successively in such a manner that ACL2 \u000A provides a macro, <tt><see topic=\"ACL2____PPROGN\">pprogn</see></tt>, for this purpose.  Thus, an equivalent \u000A solution to the problem above is</p> \u000A \u000A <code>(<see topic=\"ACL2____PPROGN\">pprogn</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'one-var 1 state)\u000A        (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'two-var 2 state)\u000A        state)</code> \u000A \u000A <p>or, more simply, as follows.</p> \u000A \u000A <code>(<see topic=\"ACL2____PPROGN\">pprogn</see> (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'one-var 1 state)\u000A        (<see topic=\"ACL2____F-PUT-GLOBAL\">f-put-global</see> 'two-var 2 state))</code> \u000A \u000A <p>See <see topic=\"ACL2____PPROGN\">pprogn</see>.  Note that the last form is allowed to return multiple \u000A values; the only requirement on the last form is that its value include \u000A <v>state</v>.</p> \u000A \u000A <p>It is also common to update the state using a sequence of forms such that \u000A each returns an error triple, where the intention is for evaluation to \u000A short-circuit immediately if a soft error is encountered.  Suppose \u000A <v>&lt;expr1&gt;</v> and <v>&lt;expr2&gt;</v> are expressions that return error triples, where \u000A the <v>state</v> components of the error triples might be updated, and one \u000A wishes to evaluate <v>&lt;expr1&gt;</v> and then <v>&lt;expr2&gt;</v>, returning the \u000A (multiple) values returned by <v>&lt;expr2&gt;</v> unless the error triple returned by \u000A <v>&lt;expr1&gt;</v> is a soft error, in which case that error triple is returned. \u000A One can of course do so as follows.</p> \u000A \u000A <code>(<see topic=\"ACL2____MV-LET\">mv-let</see> (erp val state)\u000A        &lt;expr1&gt;\u000A        (<see topic=\"COMMON-LISP____COND\">cond</see> (erp (<see topic=\"ACL2____MV\">mv</see> erp val state))\u000A              (t &lt;expr2&gt;)))</code> \u000A \u000A <p>But ACL2 provides a handy macro, <tt><see topic=\"ACL2____ER-PROGN\">er-progn</see></tt>, for this purpose.  The \u000A following code is equivalent to the code just above.</p> \u000A \u000A <code>(<see topic=\"ACL2____ER-PROGN\">er-progn</see> &lt;expr1&gt; &lt;expr2&gt;)</code> \u000A \u000A <p>See <see topic=\"ACL2____ER-PROGN\">er-progn</see> for more details.  Note that unlike <tt><see topic=\"ACL2____PPROGN\">pprogn</see></tt>, the \u000A return <see topic=\"ACL2____SIGNATURE\">signature</see> for the last expression must be the same as that of \u000A the others: an error triple.</p> \u000A \u000A <p>Let's consider how to use <v>pprogn</v> and <v>er-progn</v> together.  In the \u000A following example <v>f1</v> and <v>f2</v> both return <v>state</v>, while each of \u000A <v>g1</v> and <v>g2</v> returns an error triple.  The following code modifies \u000A state by executing these in the order <v>f1</v>, <v>g1</v>, <v>f2</v>, and finally \u000A <v>g2</v>, returning <v>(<see topic=\"ACL2____MV\">mv</see> nil val state)</v> where <v>val</v> is the value \u000A component of the error triple returned by <v>g2</v> &mdash; except we return a \u000A soft error if <v>g1</v> or <v>g2</v> returns a soft error.</p> \u000A \u000A <code>(<see topic=\"ACL2____PPROGN\">pprogn</see> (f1 x state)\u000A        (<see topic=\"ACL2____ER-PROGN\">er-progn</see> (g1 x state)\u000A                  (<see topic=\"ACL2____PPROGN\">pprogn</see> (f2 x state)\u000A                          (g2 x state))))</code> \u000A \u000A <p>Finally, consider the <see topic=\"ACL2____EVENTS\">events</see> <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> and <tt><see topic=\"ACL2____PROGN_12\">progn!</see></tt>. \u000A These have similar behavior to that of <tt><see topic=\"ACL2____ER-PROGN\">er-progn</see></tt>.  However, <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> and <tt><see topic=\"ACL2____PROGN_12\">progn!</see></tt> may only be used in event contexts, for example at \u000A the top level or immediately underneath a call of <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> or \u000A <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt>, while <tt><see topic=\"ACL2____ER-PROGN\">er-progn</see></tt> has no such restriction.  So when \u000A writing code, use <v>er-progn</v> rather than <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt> or <tt><see topic=\"ACL2____PROGN_12\">progn!</see></tt>. \u000A In particular, the body of a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> must not have any calls of \u000A <v>progn</v> (or of <v>progn!</v>  either), and the same restriction holds for any \u000A code to be executed, such as the body of a <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> form.</p> \u000A \u000A <p>BINDING VARIABLES USING ERROR TRIPLES</p> \u000A \u000A <p>In this section we discuss the macro <v>er-let*</v>, which is a variant of \u000A the special form, <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>, that is useful when programming with \u000A state.</p> \u000A \u000A <p>The macro <v>er-let*</v> is useful when binding variables to the value \u000A components of error triples.  It is actually quite similar to <v>er-progn</v>, \u000A described above, except that <v>er-let*</v> binds variables.  First consider the \u000A following example.</p> \u000A \u000A <code>(er-let* ((x1 (f1 state))\u000A          (x2 (f2 x1 state)))\u000A  (value (<see topic=\"COMMON-LISP____CONS\">cons</see> x1 x2)))</code> \u000A \u000A <p>The code just above is essentially equivalent to writing the following.</p> \u000A \u000A <code>(<see topic=\"ACL2____MV-LET\">mv-let</see> (erp x1 state)\u000A        (f1 state)\u000A        (<see topic=\"COMMON-LISP____COND\">cond</see> (erp (<see topic=\"ACL2____MV\">mv</see> erp x1 state))\u000A              (t (<see topic=\"ACL2____MV-LET\">mv-let</see> (erp x2 state)\u000A                         (f2 x1 state)\u000A                         (<see topic=\"COMMON-LISP____COND\">cond</see> (erp (<see topic=\"ACL2____MV\">mv</see> erp x2 state))\u000A                               (t (value (<see topic=\"COMMON-LISP____CONS\">cons</see> x1 x2))))))))</code> \u000A \u000A <p>As suggested by the example above, <v>er-let*</v> has the same syntax as \u000A <v>let*</v>, except that declarations are not supported.  (But note that \u000A <v>ignore</v> declarations are not needed; all variables that are bound are also \u000A used, at least in the error case.  Consider replacing <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> x1 x2)</v> by \u000A <v>nil</v> in the example displayed immediately above, and note that <v>x1</v> and \u000A <v>x2</v> are still used.)  However, unlike <v>let*</v>, <v>er-let*</v> requires \u000A that for each binding <v>(var expr)</v>, the expression <v>expr</v> must evaluate \u000A to an error triple and, moreover, it requires that the second argument (the \u000A ``body'') of <v>er-let*</v> must evaluate to an error triple.  If one of the \u000A variable expressions (e.g., the <v>f1</v> and <v>f2</v> calls above) signals an \u000A error, its error triple is returned as the value of the <v>er-let*</v>.</p> \u000A \u000A <p>Of course, soft errors can be ``caught'' by using <tt><see topic=\"ACL2____MV-LET\">mv-let</see></tt> instead of \u000A <v>er-let*</v> and simply ignoring the error flag or, more generally, by \u000A returning a non-erroneous error triple even if the error flag was on.</p> \u000A \u000A <p>BINDING STATE GLOBAL VARIABLES</p> \u000A \u000A <p>In this section we introduce a utility, <tt><see topic=\"ACL2____STATE-GLOBAL-LET_A2\">state-global-let*</see></tt>, that is \u000A an analogue of <v>let*</v> for state global variables.  Consider the following \u000A example.</p> \u000A \u000A <code>(<see topic=\"ACL2____STATE-GLOBAL-LET_A2\">state-global-let*</see>\u000A ((inhibit-output-lst (<see topic=\"ACL2____ADD-TO-SET-EQ\">add-to-set-eq</see> 'summary (<see topic=\"ACL2_____04\">@</see> inhibit-output-lst))))\u000A (<see topic=\"ACL2____THM\">thm</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x x)))</code> \u000A \u000A <p>This form binds state global variable <v>inhibit-output-lst</v> to the result \u000A of adding the symbol, <v>summary</v>, to the current value of that state global. \u000A Thus (see <see topic=\"ACL2____SET-INHIBIT-OUTPUT-LST\">set-inhibit-output-lst</see>), the usual summary is not printed \u000A when evaluating this call of <tt><see topic=\"ACL2____THM\">thm</see></tt>.</p> \u000A \u000A <p>See <see topic=\"ACL2____STATE-GLOBAL-LET_A2\">state-global-let*</see> for more complete <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.</p> \u000A \u000A <p>INPUT AND OUTPUT</p> \u000A \u000A <p>In ACL2, most input and output involves the ACL2 state.  See <see topic=\"ACL2____IO\">io</see>.</p> \u000A \u000A <p>TIMINGS</p> \u000A \u000A <p>For how to obtain the time elapsed since the start of the ACL2 session, see \u000A <see topic=\"ACL2____READ-RUN-TIME\">read-run-time</see>.</p> \u000A \u000A <p>For a utility for saving times into the ACL2 state and for printing those \u000A saved times, see the community book <v>misc/save-time.lisp</v>.</p> \u000A \u000A <p>To time an evaluation (though this really isn't about state), see <see topic=\"ACL2____TIME_42\">time$</see>.</p> \u000A \u000A <p>ENVIRONMENT AND SYSTEM</p> \u000A \u000A <p>Next, we mention briefly some ways in which ACL2 interacts with its \u000A environment using the ACL2 state.</p> \u000A \u000A <p>For how to read and write environment variables, see <see topic=\"ACL2____GETENV_42\">getenv$</see> and see \u000A <see topic=\"ACL2____SETENV_42\">setenv$</see>.</p> \u000A \u000A <p>For how to run a command in the host operating system, see <see topic=\"ACL2____SYS-CALL\">sys-call</see> and <see topic=\"ACL2____SYS-CALL_B2\">sys-call+</see>.</p> \u000A \u000A <p>REMARKS ON EVENTS AND LD</p> \u000A \u000A <p>In general, undefined or surprising behavior may occur when using ACL2 \u000A <see topic=\"ACL2____EVENTS\">events</see> or calling <see topic=\"ACL2____LD\">ld</see> in your programs.  In some cases ACL2 \u000A enforces restrictions against these uses.  We strongly discourage using <tt><see topic=\"ACL2____LD\">ld</see></tt> in programs, as it has been designed to be called only at the top level of \u000A a read-eval-print loop.  However, you may wish to read or write <tt><see topic=\"ACL2____LD\">ld</see></tt> \u000A specials in your programs; see <see topic=\"ACL2____LD\">ld</see>.</p> \u000A \u000A <p>There is also a restriction on contexts in which <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> may be \u000A called: it may only be called in a context where an event is expected, such as \u000A the top level, in a book, or as an argument of <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> or <tt><see topic=\"COMMON-LISP____PROGN\">progn</see></tt>.  The reason is that ACL2 does very subtle and careful tracking of \u000A <tt><see topic=\"ACL2____MAKE-EVENT\">make-event</see></tt> expansions; and it is only able to do this in event \u000A contexts, where it is able to carry out such tracking accurately.</p> \u000A \u000A <p>ADVANCED TOPICS</p> \u000A \u000A <p>ACL2 provides the function <v>trans-eval</v> to evaluate an arbitrary form \u000A (after translating it to a <see topic=\"ACL2____TERM\">term</see>, i.e., into internal form).  For more \u000A information, we refer to reader to comments in the definition of \u000A <v>trans-eval</v> in the ACL2 source code.  There are also many examples of its \u000A use in the ACL2 sources.</p> \u000A \u000A <p>For a function that provides the true absolute filename, with soft links \u000A resolved, see <see topic=\"ACL2____CANONICAL-PATHNAME\">canonical-pathname</see>.</p> \u000A \u000A <p>For a function that returns a check-sum on the characters in a channel, see \u000A <see topic=\"ACL2____CHECK-SUM\">check-sum</see>.</p> \u000A \u000A <p>To obtain a random number, see <see topic=\"ACL2____RANDOM_42\">random$</see>.</p> \u000A \u000A <p>If you are programming in raw-mode (see <see topic=\"ACL2____SET-RAW-MODE\">set-raw-mode</see>) or in raw \u000A Lisp, use the variable <v>*the-live-state*</v> in place of the variable \u000A <v>state</v>.</p> \u000A \u000A <p>We invite suggestions for additional advanced topics.</p>"],

 "ACL2____MBE":[["Guard","Programming","ACL2-built-ins"],"ACL2 Sources","ACL2","<p>The macro <v>mbe</v> (``must be equal'') can be used in function \u000A definitions in order to cause evaluation to use alternate code to that \u000A provided for the logic.  An example is given below.  However, the use of \u000A <v>mbe</v> can lead to non-terminating computations.  See <see topic=\"ACL2____DEFEXEC\">defexec</see>, \u000A perhaps after reading the present documentation, for a way to prove \u000A termination.</p> \u000A \u000A <p>In the ACL2 logic, <v>(<see topic=\"ACL2____MBE\">mbe</see> :exec exec-code :logic logic-code)</v> equals \u000A <v>logic-code</v>; the value of <v>exec-code</v> is ignored.  However, in raw Lisp \u000A it is the other way around: this form macroexpands simply to <v>exec-code</v>. \u000A ACL2's <see topic=\"ACL2____GUARD\">guard</see> verification mechanism ensures that the raw Lisp code is \u000A only evaluated when appropriate, since the guard proof obligations generated \u000A for (the macroexpansion of) this call of <v>mbe</v> include not only the guard \u000A proof obligations from <v>exec-code</v>, but also, under suitable contextual \u000A assumptions, the term <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> exec-code logic-code)</v>.  See <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> (in particular, for discussion of the contextual assumptions \u000A from the <v>:guard</v> and <tt><see topic=\"COMMON-LISP____IF\">if</see></tt>-tests) and, for general discussion of \u000A guards, see <see topic=\"ACL2____GUARD\">guard</see>.</p> \u000A \u000A <p>Normally, during evaluation of an <v>mbe</v> call, only the <v>:logic</v> code \u000A is evaluated unless the call is in the body of a <see topic=\"ACL2____GUARD\">guard</see>-verified \u000A function or under a call of a <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode function; in those \u000A cases only the <v>:exec</v> code is evaluated.  This implies that equality of \u000A <v>:exec</v> and <v>:logic</v> code is never checked at runtime. (Rather, such \u000A equality is proved when verifying guards.)  We qualified with ``normally'' \u000A above because there are two exceptions.  During a ``safe mode'', which is used \u000A in macroexpansion and evaluation of <tt><see topic=\"ACL2____DEFCONST\">defconst</see></tt> forms, the <v>:logic</v> \u000A and <v>:exec</v> code are both evaluated and their equality is checked.  Second, \u000A when guard-checking is set to <v>:all</v> or <v>:none</v>, then for any <v>mbe</v> \u000A call in the body of a <v>:logic</v> mode definition, only the <v>:logic</v> code \u000A will be evaluated.</p> \u000A \u000A <p>Note that the <v>:exec</v> and the <v>:logic</v> code in an <v>mbe</v> call must \u000A have the same output signature.  For example, one cannot return <v>(</v><tt><see topic=\"ACL2____MV\">mv</see></tt><v> * *)</v> while the other returns just a single value.</p> \u000A \u000A <p>Also see <see topic=\"ACL2____MBT\">mbt</see>, which stands for ``must be true.''  You may find it \u000A more natural to use <tt><see topic=\"ACL2____MBT\">mbt</see></tt> for certain applications, as described in its \u000A <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.</p> \u000A \u000A <p>Here is an example of the use of <v>mbe</v>.  Suppose that you want to define \u000A factorial in the usual recursive manner, as follows.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A      1\u000A    (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n)))))</code> \u000A \u000A <p>But perhaps you want to be able to execute calls of <v>fact</v> on large \u000A arguments that cause stack overflows, perhaps during proofs.  (This isn't a \u000A particularly realistic example, but it should serve.)  So, instead you can \u000A define this tail-recursive version of factorial:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact1 (n acc)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n) (<see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see> n 0) (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> acc))))\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A      acc\u000A    (fact1 (<see topic=\"COMMON-LISP____1-\">1-</see> n) (<see topic=\"COMMON-LISP_____A2\">*</see> n acc))))</code> \u000A \u000A <p>We are now ready to define <v>fact</v> using <v>mbe</v>.  Our intention is that \u000A logically, <v>fact</v> is as shown in the first definition above, but that \u000A <v>fact</v> should be executed by calling <v>fact1</v>.  Notice that we defer \u000A <see topic=\"ACL2____GUARD\">guard</see> verification, since we are not ready to prove the correspondence \u000A between <v>fact1</v> and <v>fact</v>.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> fact (n)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n) (<see topic=\"COMMON-LISP_____E3_D3\">&gt;=</see> n 0))\u000A                  :verify-guards nil))\u000A  (<see topic=\"ACL2____MBE\">mbe</see> :exec  (fact1 n 1)\u000A       :logic (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"ACL2____ZP\">zp</see> n)\u000A                  1\u000A                (<see topic=\"COMMON-LISP_____A2\">*</see> n (fact (<see topic=\"COMMON-LISP____1-\">1-</see> n))))))</code> \u000A \u000A <p>Next, we prove the necessary correspondence lemmas.  Notice the inclusion \u000A of a community book to help with the arithmetic reasoning.</p> \u000A \u000A <code>(<see topic=\"ACL2____INCLUDE-BOOK\">include-book</see> &quot;books/arithmetic/top-with-meta&quot;)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fact1-fact\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> acc)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (fact1 n acc)\u000A                  (<see topic=\"COMMON-LISP_____A2\">*</see> acc (fact n)))))</code> \u000A \u000A <p>We may now do guard verification for <v>fact</v>, which will allow the \u000A execution of the raw Lisp <v>fact</v> function, where the above <v>mbe</v> call \u000A expands simply to <v>(fact1 n 1)</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> fact)</code> \u000A \u000A <p>Now that guards have been verified, a trace of function calls illustrates \u000A that the evaluation of calls of <v>fact</v> is passed to evaluation of calls of \u000A <v>fact1</v>.  The outermost call below is of the logical function stored for \u000A the definition of <v>fact</v>; all the others are of actual raw Common Lisp \u000A functions.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> fact fact1)\u000ANIL\u000AACL2 !&gt;(fact 3)\u000A1&gt; (ACL2_*1*_ACL2::FACT 3)\u000A  2&gt; (FACT 3)\u000A    3&gt; (FACT1 3 1)\u000A      4&gt; (FACT1 2 3)\u000A        5&gt; (FACT1 1 6)\u000A          6&gt; (FACT1 0 6)\u000A          &lt;6 (FACT1 6)\u000A        &lt;5 (FACT1 6)\u000A      &lt;4 (FACT1 6)\u000A    &lt;3 (FACT1 6)\u000A  &lt;2 (FACT 6)\u000A&lt;1 (ACL2_*1*_ACL2::FACT 6)\u000A6\u000AACL2 !&gt;</code> \u000A \u000A <p>You may occasionally get warnings when you compile functions defined using \u000A <v>mbe</v>.  (For commands that invoke the compiler, see <see topic=\"ACL2____COMPILATION\">compilation</see>.) \u000A These can be inhibited by using an <v>ignorable</v> <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> form.  Here \u000A is a simple but illustrative example.  Note that the declarations can \u000A optionally be separated into two <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> forms.</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x y)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORABLE\">ignorable</see> x)\u000A           (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____EQUAL\">equal</see> x y)))\u000A  (<see topic=\"ACL2____MBE\">mbe</see> :logic x :exec y))</code> \u000A \u000A <p>Finally, we observe that when the body of a function contains a term of the \u000A form <v>(<see topic=\"ACL2____MBE\">mbe</see> :exec exec-code :logic logic-code)</v>, the user would be unlikely \u000A to notice any difference in the theorem prover if this term were replaced by \u000A <v>logic-code</v>.  ACL2 takes various steps to ensure this.  For example, the \u000A proof obligations generated for admitting a function treat the above <v>mbe</v> \u000A term simply as <v>logic-code</v>.  Function expansion, <v>:use</v> <see topic=\"ACL2____HINTS\">hints</see>, \u000A <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> rules, generation of <see topic=\"ACL2____CONSTRAINT\">constraint</see>s for \u000A functional instantiation, and creation of rules of class <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> \u000A and <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt> also treat <v>mbe</v> calls as their \u000A <v>:logic</v> code.</p>"],

 "ACL2____SET-GUARD-CHECKING":[["Guard"],"ACL2 Sources","ACL2","<p>Detailed comments about the arguments of this function may be found \u000A elsewhere: see <see topic=\"ACL2____GUARD-EVALUATION-TABLE\">guard-evaluation-table</see>.  Here we provide an introduction \u000A to the use of <v>set-guard-checking</v>.</p> \u000A \u000A <p>New users are encouraged to execute one of the following forms in order to \u000A avoid evaluation errors due to <see topic=\"ACL2____GUARD\">guard</see>s:</p> \u000A \u000A <code>(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :none)\u000A(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> nil)</code> \u000A \u000A <p>The former avoids all guard-checking on user-defined functions and should \u000A generally work fine for new users, the only drawback being efficiency loss on \u000A compute-intensive problems.  All settings other than <v>:none</v> check guards, \u000A but a value of <v>nil</v> allows evaluation to continue in the logic when guards \u000A fail (avoiding the raw Lisp definition in that case).</p> \u000A \u000A <p>You may put one of the above forms in the <v>&quot;acl2-customization.lsp&quot;</v> \u000A file in your current directory (see <see topic=\"ACL2____CBD\">cbd</see>) or your home directory; see \u000A <see topic=\"ACL2____ACL2-CUSTOMIZATION\">ACL2-customization</see>.</p> \u000A \u000A <p>Note that <see topic=\"ACL2____GUARD\">guard</see>s are not part of the ACL2 logic, and hence new users \u000A can completely ignore the notion of <see topic=\"ACL2____GUARD\">guard</see> (and the rest of this \u000A documentation section after this paragraph!).  For example, <v>(<see topic=\"COMMON-LISP____CAR\">car</see> 3)</v> and \u000A <v>nil</v> can be proved equal in the ACL2 logic, as follows, even though the \u000A <see topic=\"ACL2____GUARD\">guard</see> on <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> requires its first argument to be a <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> \u000A pair or <v>nil</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> 3) nil))</code> \u000A \u000A <p>Moreover, unless your functions or top-level forms call built-in ACL2 \u000A functions that are defined in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode, the following \u000A property will hold.</p> \u000A \u000A <blockquote><p>Evaluation of <v>(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :none)</v> will allow \u000A evaluation of forms such as <v>(<see topic=\"COMMON-LISP____CAR\">car</see> 3)</v> to take place without error in the \u000A top level loop, not only when proving theorems.</p></blockquote> \u000A \u000A <p>If you feel bold, then you may wish to read the rest of this documentation \u000A topic; also see <see topic=\"ACL2____GUARD\">guard</see>.</p> \u000A \u000A <p>See <see topic=\"ACL2____GUARD-EVALUATION-TABLE\">guard-evaluation-table</see> for a succinct table, with associated \u000A discussion, that covers in detail the material presented in the rest of the \u000A present topic.</p> \u000A \u000A <p>The top-level ACL2 loop has a variable which controls which sense of \u000A execution is provided.  To turn ``<see topic=\"ACL2____GUARD\">guard</see> checking on,'' by which we mean \u000A that <see topic=\"ACL2____GUARD\">guard</see>s are checked at runtime, execute the top-level form \u000A <v>:set-guard-checking t</v>.  To allow guard violations, do \u000A <v>:set-guard-checking nil</v>, or do <v>:set-guard-checking :none</v> to turn off \u000A all guard-checking, so that raw Lisp definitions of user-defined functions are \u000A avoided unless their <see topic=\"ACL2____GUARD\">guard</see> is <v>t</v>. The status of guard-checking is \u000A reflected in the <see topic=\"ACL2____PROMPT\">prompt</see>.</p> \u000A \u000A <code>ACL2 !&gt;</code> \u000A \u000A <p>means <see topic=\"ACL2____GUARD\">guard</see> checking is on and</p> \u000A \u000A <code>ACL2 &gt;</code> \u000A \u000A <p>means <see topic=\"ACL2____GUARD\">guard</see> checking is off.  The exclamation mark can be thought of \u000A as ``barring'' certain computations.  The absence of the mark suggests the \u000A absence of error messages or unbarred access to the logical axioms.  Thus, for \u000A example</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____CAR\">car</see> 'abc)</code> \u000A \u000A <p>will signal an error, while</p> \u000A \u000A <code>ACL2 &gt;(<see topic=\"COMMON-LISP____CAR\">car</see> 'abc)</code> \u000A \u000A <p>will return <v>nil</v>.</p> \u000A \u000A <p>We will return at the end of this documentation topic to discuss two other \u000A values, <v>:all</v> and <v>:nowarn</v>, for <v>:set-guard-checking</v>.  We also \u000A note that evaluation of built-in <v>:program</v> mode functions always takes \u000A place in raw Lisp.</p> \u000A \u000A <p>Whether <see topic=\"ACL2____GUARD\">guard</see>s are checked during evaluation is independent of the \u000A <tt><see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see></tt>.  We note this simply because it is easy to confuse \u000A ``<v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode'' with ``evaluation in Common Lisp'' and thus \u000A with ``<see topic=\"ACL2____GUARD\">guard</see> checking on;'' and it is easy to confuse ``<v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode'' with ``evaluation in the logic'' and with ``<see topic=\"ACL2____GUARD\">guard</see> \u000A checking off.''  But the <tt><see topic=\"ACL2____DEFAULT-DEFUN-MODE\">default-defun-mode</see></tt> determines whether newly \u000A submitted definitions introduce programs or add logical axioms.  That mode is \u000A independent of whether evaluation checks <see topic=\"ACL2____GUARD\">guard</see>s or not.  You can \u000A operate in <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> mode with runtime <see topic=\"ACL2____GUARD\">guard</see> checking on or \u000A off.  Analogously, you can operate in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode with runtime \u000A <see topic=\"ACL2____GUARD\">guard</see> checking on or off.</p> \u000A \u000A <p>For further discussion on evaluation and guards see <see topic=\"ACL2____GUARDS-AND-EVALUATION\">guards-and-evaluation</see>, in particular the exception for safe-mode in the \u000A ``Aside'' there.  See <see topic=\"ACL2____GUARD\">guard</see> for a general discussion of <see topic=\"ACL2____GUARD\">guard</see>s.</p> \u000A \u000A <p>Now we fulfill our promise above to discuss two other values for \u000A <v>:set-guard-checking</v>:</p> \u000A \u000A <code>:set-guard-checking :nowarn\u000A:set-guard-checking :all</code> \u000A \u000A <p>The meaning of these values is perhaps best described by the following \u000A example provided by David Rager.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> my-test (expr)\u000A         (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> expr)\u000A                         :verify-guards nil))\u000A         (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____ATOM\">atom</see> expr)\u000A             expr\u000A           (<see topic=\"COMMON-LISP____CONS\">cons</see> (my-test (<see topic=\"COMMON-LISP____CAR\">car</see> expr))\u000A                 (my-test (<see topic=\"COMMON-LISP____CDR\">cdr</see> expr)))))\u000A\u000AThe admission of MY-TEST is trivial, using the relation O&lt; (which is\u000Aknown to be well-founded on the domain recognized by O-P) and the measure\u000A(<see topic=\"ACL2____ACL2-COUNT\">ACL2-COUNT</see> EXPR).  We could deduce no constraints on the type of MY-\u000ATEST.  However, in normalizing the definition we used primitive type\u000Areasoning.\u000A\u000ASummary\u000AForm:  ( DEFUN MY-TEST ...)\u000ARules: ((:FAKE-RUNE-FOR-TYPE-SET NIL))\u000AWarnings:  None\u000ATime:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)\u000A MY-TEST\u000AACL2 !&gt;(my-test '(a b c))\u000A\u000AACL2 Warning [Guards] in TOP-LEVEL:  Guard-checking will be inhibited\u000Aon recursive calls of the executable counterpart (i.e., in the ACL2\u000Alogic) of MY-TEST.  To check guards on all recursive calls:\u000A  (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :all)\u000ATo leave behavior unchanged except for inhibiting this message:\u000A  (<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :nowarn)\u000A\u000A(A B C)\u000AACL2 !&gt;</code> \u000A \u000A <p>If you think about evaluation of <v>(my-test '(a b c))</v>, you will see that \u000A it leads to the recursive call <v>(my-test 'a)</v>, which one might expect to \u000A cause a guard violation since the symbol <v>a</v> is not a <tt><see topic=\"ACL2____TRUE-LISTP\">true-listp</see></tt>. \u000A However, as the warning above explains, we do not by default check guards on \u000A recursive calls.  The reason is efficiency &mdash; imagine a simple definition \u000A with a guard that is slow to evaluate.  The values <v>:nowarn</v> and <v>:all</v> \u000A for <v>:set-guard-checking</v> have been introduced as ways of dealing with the \u000A above warning.  The value <v>:nowarn</v> simply turns off the warning above. \u000A The value <v>:all</v> causes all guards to be checked, even on recursive calls \u000A and even on all calls of non-built-in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode functions \u000A &mdash; unless, of course, a call is made of a function whose guard has been \u000A verified (see <see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see>), where the arguments satisfy the guard, in \u000A which case the corresponding call is made in raw Lisp without subsidiary \u000A guard-checking.  We still say that ``guard-checking is on'' after \u000A <v>:set-guard-checking</v> is invoked with values <v>t</v>, <v>:nowarn</v>, and \u000A <v>:all</v>, otherwise (after value <v>nil</v>) we say ``guard-checking is \u000A off.</p> \u000A \u000A <p>For technical reasons, <v>:all</v> does not have its advertised effect in the \u000A case of built-in <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt>-mode functions.  If you are interested \u000A in this technical detail, see the comment ``In the boot-strap world...'' in \u000A source function <v>oneify-cltl-code</v>.</p> \u000A \u000A <p>We conclude with a remark about the use of <v>:set-guard-checking</v> for \u000A experimenting with ACL2 as a logic or as a programming language.  If one views \u000A ACL2 as a logic, one may wish to use <v>:set-guard-checking :none</v>, while if \u000A instead one views ACL2 as a functional programming language, one may wish to \u000A use <v>:set-guard-checking :all</v>.  The following transcript illustrates this \u000A distinction by way of example.  Specifically, <v>(<see topic=\"COMMON-LISP____CAR\">car</see> 3)</v> is equal to \u000A <v>nil</v> in the ACL2 logic, but may be viewed as a programming error.  The \u000A default of <v>:set-guard-checking t</v> is problematic for learning ACL2 using \u000A <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode functions, since one can get raw Lisp errors.  In \u000A the example below, the raw Lisp error occurs because <v>foo</v> implicitly has a \u000A <see topic=\"ACL2____GUARD\">guard</see> of <v>t</v>, hence <v>(foo 3)</v> is evaluated in raw Lisp, which \u000A leads to a raw Lisp call of c[(car 3)].</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> foo (x)\u000A         (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :mode :program))\u000A         (<see topic=\"COMMON-LISP____CAR\">car</see> x))\u000A\u000ASummary\u000AForm:  ( DEFUN FOO ...)\u000ARules: NIL\u000AWarnings:  None\u000ATime:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)\u000A FOO\u000AACL2 !&gt;(foo 3)\u000AError: Attempt to take the car of 3 which is not listp.\u000A  [condition type: TYPE-ERROR]\u000A\u000ARestart actions (select using :continue):\u000A 0: Abort entirely from this (lisp) process.\u000A[Current process: Initial Lisp Listener]\u000A[1] ACL2(1): [RAW LISP] :pop\u000AACL2 !&gt;:set-guard-checking :none\u000A\u000ATurning off guard checking entirely.  To allow execution in raw Lisp\u000Afor functions with guards other than T, while continuing to mask guard\u000Aviolations, :SET-GUARD-CHECKING NIL.  See :DOC set-guard-checking.\u000A\u000AACL2 &gt;(foo 3)\u000ANIL\u000AACL2 &gt;:set-guard-checking :all\u000A\u000ATurning guard checking on, value :ALL.\u000A\u000AACL2 !&gt;(foo 3)\u000A\u000AACL2 Error in TOP-LEVEL:  The guard for the function symbol CAR, which\u000Ais (<see topic=\"COMMON-LISP____OR\">OR</see> (<see topic=\"COMMON-LISP____CONSP\">CONSP</see> X) (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> X NIL)), is violated by the arguments in the\u000Acall (<see topic=\"COMMON-LISP____CAR\">CAR</see> 3).  See :DOC trace for a useful debugging utility.  See :DOC\u000Aset-guard-checking for information about suppressing this check with\u000A(<see topic=\"ACL2____SET-GUARD-CHECKING\">set-guard-checking</see> :none), as recommended for new users.\u000A\u000AACL2 !&gt;</code>"],

 "ACL2____PROOF-CHECKER":[["ACL2","Debugging"],"ACL2 Sources","ACL2","<p>Call this up with <v>(<see topic=\"ACL2____VERIFY\">verify</see> ...)</v>.</p> \u000A \u000A <p>This is an interactive system for checking ACL2 theorems, or at least \u000A exploring their proofs.  One enters it using the <v>VERIFY</v> command (see \u000A <see topic=\"ACL2____VERIFY\">verify</see>), and then invokes commands at the resulting prompt to operate \u000A on a stack of goals, starting with the single goal that was supplied to \u000A <v>VERIFY</v>.  The final command (or ``instruction'') can be an <v>exit</v> \u000A command, which can print out a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event if the goal stack is \u000A empty; see <see topic=\"ACL2____PROOF-CHECKER-COMMANDS\">proof-checker-commands</see>, in particular the <v>exit</v> command. \u000A That resulting <v>defthm</v> event includes an <v>:</v><tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt> \u000A parameter, which directs replay of the proof-checker commands (for example \u000A during certification of a book containing that event; see <see topic=\"ACL2____BOOKS\">books</see>).</p> \u000A \u000A <p>If you exit the proof-checker interactive loop, you may re-enter that \u000A session at the same point using the command <v>(<see topic=\"ACL2____VERIFY\">verify</see>)</v>, i.e., with no \u000A arguments.  The commands <v>save</v> and <v>retrieve</v> may be invoked to manage \u000A more than one session.</p> \u000A \u000A <p>The proof-checker can be invoked on a specific subgoal, and the resulting \u000A <v>:instructions</v> can be given as a hint to the theorem prover for that \u000A subgoal.  See <see topic=\"ACL2____INSTRUCTIONS\">instructions</see>.</p> \u000A \u000A <p>A tutorial is available on the world-wide web:<br></br> \u000A \u000A <a href='http://www.cs.utexas.edu/users/kaufmann/tutorial/rev3.html'>http://www.cs.utexas.edu/users/kaufmann/tutorial/rev3.html</a>.<br></br> \u000A \u000A The tutorial illustrates more than just the proof-checker.  The portion \u000A relevant to the proof-checker may be accessed directly:<br></br> \u000A \u000A <a \u000A href='http://www.cs.utexas.edu/users/kaufmann/tutorial/rev3.html#slide29'>http://www.cs.utexas.edu/users/kaufmann/tutorial/rev3.html#slide29</a></p> \u000A \u000A <p>See <see topic=\"ACL2____SET-EVISC-TUPLE\">set-evisc-tuple</see> for how to arrange that output is printed in \u000A abbreviated form.  In general, the proof-checker uses the <v>:TERM</v> <see topic=\"ACL2____EVISC-TUPLE\">evisc-tuple</see> described in that documentation.</p> \u000A \u000A <p>Individual proof-checker commands are documented in subsection <see topic=\"ACL2____PROOF-CHECKER-COMMANDS\">proof-checker-commands</see>.</p>"],

 "ACL2____DEFUN-SK":[["Events"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> exists-x-p0-and-q0 (y z)\u000A  (<see topic=\"ACL2____EXISTS\">exists</see> x\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z))))\u000A\u000A(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> exists-x-p0-and-q0 (y z) ; equivalent to the above\u000A  (<see topic=\"ACL2____EXISTS\">exists</see> (x)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z))))\u000A\u000A(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> forall-x-y-p0-and-q0 (z)\u000A  (<see topic=\"ACL2____FORALL\">forall</see> (x y)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z)))\u000A  :strengthen t)\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> fn (var1 ... varn) body\u000A  &amp;key rewrite doc quant-ok skolem-name thm-name witness-dcls strengthen)</code> \u000A \u000A <p>where <v>fn</v> is the symbol you wish to define and is a new symbolic name \u000A (see <see topic=\"ACL2____NAME\">name</see>), <v>(var1 ... varn)</v> is its list of formal parameters (see \u000A <see topic=\"ACL2____NAME\">name</see>), and <v>body</v> is its body, which must be quantified as described \u000A below.  The <v>&amp;key</v> argument <v>doc</v>, if non-<v>nil</v>, is an optional \u000A string that can provide documentation but is essentially ignored by ACL2.  In \u000A the case that <v>n</v> is 1, the list <v>(var1)</v> may be replaced by simply \u000A <v>var1</v>.  The other arguments are explained below.</p> \u000A \u000A <p>For a simple example, see <see topic=\"ACL2____DEFUN-SK-EXAMPLE\">defun-sk-example</see>.  For a more elaborate \u000A example, see <see topic=\"ACL2____TUTORIAL4-DEFUN-SK-EXAMPLE\">Tutorial4-Defun-Sk-Example</see>.  See <see topic=\"ACL2____QUANTIFIER-TUTORIAL\">quantifier-tutorial</see> for a careful beginner's introduction that takes you \u000A through typical kinds of quantifier-based reasoning in ACL2.  Also see <see topic=\"ACL2____QUANTIFIERS\">quantifiers</see> for an example illustrating how the use of recursion, rather than \u000A explicit quantification with <v>defun-sk</v>, may be preferable.</p> \u000A \u000A <p>Below we describe the <v>defun-sk</v> event precisely.  First, let us \u000A consider the examples above.  The first example, again, is:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> exists-x-p0-and-q0 (y z)\u000A  (<see topic=\"ACL2____EXISTS\">exists</see> x\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z))))</code> \u000A \u000A <p>It is intended to represent the predicate with formal parameters <v>y</v> and \u000A <v>z</v> that holds when for some <v>x</v>, <v>(<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))</v> \u000A holds.  In fact <v>defun-sk</v> is a macro that adds the following two <see topic=\"ACL2____EVENTS\">events</see>, as shown just below.  The first event guarantees that if this new \u000A predicate holds of <v>y</v> and <v>z</v>, then the term shown, \u000A <v>(exists-x-p0-and-q0-witness y z)</v>, is an example of the <v>x</v> that is \u000A therefore supposed to exist.  (Intuitively, we are axiomatizing \u000A <v>exists-x-p0-and-q0-witness</v> to pick a witness if there is one.  We comment \u000A below on the use of <tt><see topic=\"ACL2____DEFUN-NX\">defun-nx</see></tt>; for now, consider <v>defun-nx</v> to be \u000A <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.)  Conversely, the second event below guarantees that if there \u000A is any <v>x</v> for which the term in question holds, then the new predicate \u000A does indeed hold of <v>y</v> and <v>z</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-NX\">defun-nx</see> exists-x-p0-and-q0 (y z)\u000A  (<see topic=\"COMMON-LISP____LET\">let</see> ((x (exists-x-p0-and-q0-witness y z)))\u000A    (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))))\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> exists-x-p0-and-q0-suff\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))\u000A           (exists-x-p0-and-q0 y z)))</code> \u000A \u000A <p>Now let us look at the third example from the introduction above:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> forall-x-y-p0-and-q0 (z)\u000A  (<see topic=\"ACL2____FORALL\">forall</see> (x y)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z))))</code> \u000A \u000A <p>The intention is to introduce a new predicate <v>(forall-x-y-p0-and-q0 z)</v> \u000A which states that the indicated conjunction holds of all <v>x</v> and all <v>y</v> \u000A together with the given <v>z</v>.  This time, the axioms introduced are as shown \u000A below.  The first event guarantees that if the application of function \u000A <v>forall-x-y-p0-and-q0-witness</v> to <v>z</v> picks out values <v>x</v> and <v>y</v> \u000A for which the given term <v>(<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))</v> holds, then the new \u000A predicate <v>forall-x-y-p0-and-q0</v> holds of <v>z</v>.  Conversely, the \u000A (contrapositive of) the second axiom guarantees that if the new predicate \u000A holds of <v>z</v>, then the given term holds for all choices of <v>x</v> and \u000A <v>y</v> (and that same <v>z</v>).</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-NX\">defun-nx</see> forall-x-y-p0-and-q0 (z)\u000A  (<see topic=\"ACL2____MV-LET\">mv-let</see> (x y)\u000A          (forall-x-y-p0-and-q0-witness z)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))))\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> forall-x-y-p0-and-q0-necc\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z)))\u000A           (<see topic=\"COMMON-LISP____NOT\">not</see> (forall-x-y-p0-and-q0 z))))</code> \u000A \u000A <p>The examples above suggest the critical property of <v>defun-sk</v>: it \u000A indeed does introduce the quantified notions that it claims to introduce.</p> \u000A \u000A <p>Notice that the <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event just above, \u000A <v>forall-x-y-p0-and-q0-necc</v>, may not be of optimal form as a rewrite rule. \u000A Users sometimes find that when the quantifier is <v>forall</v>, it is useful to \u000A state this rule in a form where the new quantified predicate is a hypothesis \u000A instead.  In this case that form would be as follows:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> forall-x-y-p0-and-q0-necc\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (forall-x-y-p0-and-q0 z)\u000A           (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z) (q0 x y z))))</code> \u000A \u000A <p>ACL2 will turn this into one <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule for each conjunct, \u000A <v>(p0 x y z)</v> and <v>(q0 x y z)</v>, with hypothesis <v>(forall-x-y-p0-and-q0\u000A z)</v> in each case.  In order to get this effect, use <v>:rewrite :direct</v>, in \u000A this case as follows.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> forall-x-y-p0-and-q0 (z)\u000A  (<see topic=\"ACL2____FORALL\">forall</see> (x y)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (p0 x y z)\u000A               (q0 x y z)))\u000A  :rewrite :direct)</code> \u000A \u000A <p>We now turn to a detailed description of <v>defun-sk</v>, starting with a \u000A discussion of its arguments as shown in the \"General Form\" above.</p> \u000A \u000A <p>The third argument, <v>body</v>, must be of the form</p> \u000A \u000A <code>(<see topic=\"ACL2____Q\">Q</see> bound-vars term)</code> \u000A \u000A <p>where: <v>Q</v> is the symbol <tt><see topic=\"ACL2____FORALL\">forall</see></tt> or <tt><see topic=\"ACL2____EXISTS\">exists</see></tt> (in the \u000A \"ACL2\" package), <v>bound-vars</v> is a variable or true list of variables \u000A disjoint from <v>(var1 ... varn)</v> and not including <tt><see topic=\"ACL2____STATE\">state</see></tt>, and \u000A <v>term</v> is a term.  The case that <v>bound-vars</v> is a single variable \u000A <v>v</v> is treated exactly the same as the case that <v>bound-vars</v> is \u000A <v>(v)</v>.</p> \u000A \u000A <p>The result of this event is to introduce a ``Skolem function,'' whose name \u000A is the keyword argument <v>skolem-name</v> if that is supplied, and otherwise is \u000A the result of modifying <v>fn</v> by suffixing \"-WITNESS\" to its name.  The \u000A following definition and one of the following two theorems (as indicated) are \u000A introduced for <v>skolem-name</v> and <v>fn</v> in the case that <v>bound-vars</v> \u000A (see above) is a single variable <v>v</v>.  The name of the <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> event \u000A may be supplied as the value of the keyword argument <v>:thm-name</v>; if it is \u000A not supplied, then it is the result of modifying <v>fn</v> by suffixing \u000A \"-SUFF\" to its name in the case that the quantifier is <tt><see topic=\"ACL2____EXISTS\">exists</see></tt>, and \u000A \"-NECC\" in the case that the quantifier is <tt><see topic=\"ACL2____FORALL\">forall</see></tt>.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-NX\">defun-nx</see> fn (var1 ... varn)\u000A  (<see topic=\"COMMON-LISP____LET\">let</see> ((v (skolem-name var1 ... varn)))\u000A    term))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-suff ;in case the quantifier is EXISTS\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> term\u000A           (fn var1 ... varn)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-necc ;in case the quantifier is FORALL\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NOT\">not</see> term)\u000A           (<see topic=\"COMMON-LISP____NOT\">not</see> (fn var1 ... varn))))</code> \u000A \u000A <p>In the <v>forall</v> case, however, the keyword pair <v>:rewrite :direct</v> \u000A may be supplied after the body of the <v>defun-sk</v> form, in which case the \u000A contrapositive of the above form is used instead:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> fn-necc ;in case the quantifier is FORALL\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (fn var1 ... varn)\u000A           term))</code> \u000A \u000A <p>This is often a better choice for the \"-NECC\" rule, provided ACL2 can \u000A parse <v>term</v> as a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule.  A second possible value of \u000A the <v>:rewrite</v> argument of <v>defun-sk</v> is <v>:default</v>, which gives the \u000A same behavior as when <v>:rewrite</v> is omitted.  Otherwise, the value of \u000A <v>:rewrite</v> should be the term to use as the body of the <v>fn-necc</v> \u000A theorem shown above; ACL2 will attempt to do the requisite proof in this case. \u000A If that term is weaker than the default, the properties introduced by \u000A <v>defun-sk</v> may of course be weaker than they would be otherwise.  Finally, \u000A note that the <v>:rewrite</v> keyword argument for <v>defun-sk</v> only makes \u000A sense if the quantifier is <v>forall</v>; it is thus illegal if the quantifier \u000A is <v>exists</v>.  Enough said about <v>:rewrite</v>!</p> \u000A \u000A <p>In the case that <v>bound-vars</v> is a list of at least two variables, say \u000A <v>(bv1 ... bvk)</v>, the definition above (with no keywords) is the following \u000A instead, but the theorem remains unchanged.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-NX\">defun-nx</see> fn (var1 ... varn)\u000A  (<see topic=\"ACL2____MV-LET\">mv-let</see> (bv1 ... bvk)\u000A          (skolem-name var1 ... varn)\u000A          term))</code> \u000A \u000A <p>In order to emphasize that the last element of the list, <v>body</v>, is a \u000A term, <v>defun-sk</v> checks that the symbols <tt><see topic=\"ACL2____FORALL\">forall</see></tt> and <tt><see topic=\"ACL2____EXISTS\">exists</see></tt> \u000A do not appear anywhere in it.  However, on rare occasions one might \u000A deliberately choose to violate this convention, presumably because <tt><see topic=\"ACL2____FORALL\">forall</see></tt> or <tt><see topic=\"ACL2____EXISTS\">exists</see></tt> is being used as a variable or because a macro call \u000A will be eliminating ``calls of'' <tt><see topic=\"ACL2____FORALL\">forall</see></tt> and <tt><see topic=\"ACL2____EXISTS\">exists</see></tt>.  In these \u000A cases, the keyword argument <v>quant-ok</v> may be supplied a non-<v>nil</v> \u000A value.  Then <v>defun-sk</v> will permit <tt><see topic=\"ACL2____FORALL\">forall</see></tt> and <tt><see topic=\"ACL2____EXISTS\">exists</see></tt> in \u000A the body, but it will still cause an error if there is a real attempt to use \u000A these symbols as quantifiers.</p> \u000A \u000A <p>The use of <tt><see topic=\"ACL2____DEFUN-NX\">defun-nx</see></tt> above, rather than <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, disables \u000A certain checks that are required for evaluation, in particular the \u000A single-threaded use of <tt><see topic=\"ACL2____STOBJ\">stobj</see></tt>s.  However, there is a price: calls of \u000A these defined functions cannot be evaluated; see <see topic=\"ACL2____DEFUN-NX\">defun-nx</see>.  Normally \u000A that is not a problem, since these notions involve quantifiers.  But you are \u000A welcome to replace this <tt><see topic=\"COMMON-LISP____DECLARE\">declare</see></tt> form with your own, as follows: if you \u000A supply a list of <v>declare</v> forms to keyword argument <v>:witness-dcls</v>, \u000A these will become the declare forms in the generated <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.  Note that \u000A if your value of <v>witness-dcls</v> does not contain the form <v>(<see topic=\"COMMON-LISP____DECLARE\">declare</see>\u000A (<see topic=\"ACL2____XARGS\">xargs</see> :non-executable t))</v>, then the appropriate wrapper for non-executable \u000A functions will not be added automatically, i.e., <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> will be used in \u000A place of <v>defun-nx</v>.  Note also that if <see topic=\"ACL2____GUARD\">guard</see> verification is \u000A attempted, then it will likely fail with an error message complaining that \u000A ``guard verification may depend on local properties.''  In that case, you may \u000A wish to delay guard verification, as in the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A ()\u000A (<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> foo (x)\u000A   (<see topic=\"ACL2____EXISTS\">exists</see> n (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> n)\u000A                  (<see topic=\"COMMON-LISP_____C3\">&lt;</see> n x)))\u000A   :witness-dcls ((<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x)\u000A                                  :verify-guards nil))))\u000A (<see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see> foo))</code> \u000A \u000A <p><v>Defun-sk</v> is a macro implemented using <tt><see topic=\"ACL2____DEFCHOOSE\">defchoose</see></tt>.  Hence, it \u000A should only be executed in <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>; see <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> and see <see topic=\"ACL2____DEFCHOOSE\">defchoose</see>.  Advanced feature: If argument \u000A <v>:strengthen t</v> is passed to <v>defun-sk</v>, then <v>:strengthen t</v> will \u000A generate the extra constraint that that is generated for the corresponding \u000A <v>defchoose</v> event; see <see topic=\"ACL2____DEFCHOOSE\">defchoose</see>.  You can use the command \u000A <v>:</v><tt><see topic=\"ACL2____PCB_12\">pcb!</see></tt> to see the event generated by a call of the <v>defun-sk</v> \u000A macro.</p> \u000A \u000A <p>If you find that the rewrite rules introduced with a particular use of \u000A <v>defun-sk</v> are not ideal, even when using the <v>:rewrite</v> keyword \u000A discussed above (in the <v>forall</v> case), then at least two reasonable \u000A courses of action are available for you.  Perhaps the best option is to prove \u000A the <tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules you want.  If you see a pattern for creating rewrite \u000A rules from your <v>defun-sk</v> events, you might want to write a macro that \u000A executes a <v>defun-sk</v> followed by one or more <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> events. \u000A Another option is to write your own variant of the <v>defun-sk</v> macro, say, \u000A <v>my-defun-sk</v>, for example by modifying a copy of the definition of \u000A <v>defun-sk</v> from the ACL2 sources.</p> \u000A \u000A <p>If you want to represent nested quantifiers, you can use more than one \u000A <v>defun-sk</v> event.  For example, in order to represent</p> \u000A \u000A <code>(<see topic=\"ACL2____FORALL\">forall</see> x (<see topic=\"ACL2____EXISTS\">exists</see> y (p x y z)))</code> \u000A \u000A <p>you can use <v>defun-sk</v> twice, for example as follows.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> exists-y-p (x z)\u000A  (<see topic=\"ACL2____EXISTS\">exists</see> y (p x y z)))\u000A\u000A(<see topic=\"ACL2____DEFUN-SK\">defun-sk</see> forall-x-exists-y-p (z)\u000A  (<see topic=\"ACL2____FORALL\">forall</see> x (exists-y-p x z)))</code> \u000A \u000A <p>Some distracting and unimportant warnings are inhibited during \u000A <v>defun-sk</v>.</p> \u000A \u000A <p>Note for ACL2(r) users (see <see topic=\"COMMON-LISP____REAL\">real</see>): In ACL2(r), the keyword \u000A <v>:CLASSICALP</v> is also supported.  Its legal values are <v>t</v> (the default) \u000A and <v>nil</v>, and it determines whether or not (respectively) ACL2(r) will \u000A consider <v>fn</v> to be a classical function.  It must be the case that the \u000A value is <v>t</v> (perhaps implicitly, by default) if and only if <v>body</v> is \u000A classical.</p> \u000A \u000A <p>Note that this way of implementing quantifiers is not a new idea.  Hilbert \u000A was certainly aware of it 60 years ago!  Also see <see topic=\"ACL2____CONSERVATIVITY-OF-DEFCHOOSE\">conservativity-of-defchoose</see> for a technical argument that justifies the \u000A logical conservativity of the <tt><see topic=\"ACL2____DEFCHOOSE\">defchoose</see></tt> event in the sense of the \u000A paper by Kaufmann and Moore entitled ``Structured Theory Development for a \u000A Mechanized Logic'' (Journal of Automated Reasoning 26, no. 2 (2001), \u000A pp. 161-203).</p>"],

 "ACL2____DEFATTACH":[["Events"],"ACL2 Sources","ACL2","<p>This <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic is organized into the following \u000A sections:</p> \u000A \u000A <p><b>Introductory example.</b><br></br> \u000A \u000A <b>Syntax and semantics of defattach.</b><br></br> \u000A \u000A <b>Three primary uses of defattach.</b><br></br> \u000A \u000A <b>Miscellaneous remarks, with discussion of possible user errors.</b></p> \u000A \u000A <p>Please see <see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> if you intend to use <v>defattach</v> but are \u000A not already familiar with the use of <v>encapsulate</v> to introduce constrained \u000A functions.</p> \u000A \u000A <p>See community book <v>books/misc/defattach-example.lisp</v> for a small \u000A example.  it illustrates how <v>defattach</v> may be used to build something \u000A like ``higher-order'' programs, in which constrained functions may be refined \u000A to different executable functions.  More uses of <v>defattach</v> may be found \u000A in the ACL2 source code, specifically, file <v>boot-strap-pass-2.lisp</v>.</p> \u000A \u000A <p>The argument <v>:skip-checks t</v> enables easy experimentation with \u000A <v>defattach</v>, by permitting use of <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt> mode functions and \u000A the skipping of semantic checks.  Also permitted is <v>:skip-checks nil</v> (the \u000A default) and <v>:skip-checks :cycles</v>, which turns off only the update of the \u000A extended ancestor relation (see below) and hence the check for cycles in this \u000A relation; see below.  We do not make any logical claims when the value of \u000A <v>:skip-checks</v> is non-<v>nil</v>; indeed, a trust tag is required in this \u000A case (see <see topic=\"ACL2____DEFTTAG\">defttag</see>).  Remark for <see topic=\"ACL2____HONS-ENABLED\">hons-enabled</see> ACL2 executables \u000A (built by default): the interaction of memoization and attachments is not \u000A tracked for attachments introduced with a non-<v>nil</v> value of \u000A <v>:skip-checks</v>.  For more discussion of <v>:skip-checks t</v>, see <see topic=\"ACL2____DEFPROXY\">defproxy</see>; we do not discuss <v>:skip-checks</v> further, here.</p> \u000A \u000A <p><b>Introductory example.</b></p> \u000A \u000A <p>We begin with a short log illustrating the use of <v>defattach</v>.  Notice \u000A that after evaluating the event <v>(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)</v>, a call of the \u000A constrained function <v>f</v> is evaluated by instead calling <v>g</v> on the \u000A arguments.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see>\u000A        ((f (x) t :guard (<see topic=\"ACL2____TRUE-LISTP\">true-listp</see> x)))\u000A        (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (x) x))\u000A        (<see topic=\"ACL2____DEFTHM\">defthm</see> f-property\u000A          (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____CONSP\">consp</see> (f x)))))\u000A[... output omitted ...]\u000A T\u000AACL2 !&gt;(<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x)\u000A         (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____NULL\">null</see> x))))\u000A         (<see topic=\"COMMON-LISP____CONS\">cons</see> 17 (<see topic=\"COMMON-LISP____CAR\">car</see> x)))\u000A[... output omitted ...]\u000A G\u000AACL2 !&gt;(f '(3 4)) ; undefined function error\u000A\u000AACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function\u000AF on argument list:\u000A\u000A((3 4))\u000A\u000ATo debug see :DOC print-gv, see :DOC trace, and see :DOC wet.\u000A\u000AACL2 !&gt;(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)\u000A[... output omitted ...]\u000A :ATTACHMENTS-RECORDED\u000AACL2 !&gt;(f '(3 4)) ; f is evaluated using g\u000A(17 . 3)\u000AACL2 !&gt;(<see topic=\"ACL2____TRACE_42\">trace$</see> f g)\u000A ((F) (G))\u000AACL2 !&gt;(f '(3 4)) ; f is evaluated using g\u000A1&gt; (ACL2_*1*_ACL2::F (3 4))\u000A  2&gt; (ACL2_*1*_ACL2::G (3 4))\u000A    3&gt; (G (3 4))\u000A    &lt;3 (G (17 . 3))\u000A  &lt;2 (ACL2_*1*_ACL2::G (17 . 3))\u000A&lt;1 (ACL2_*1*_ACL2::F (17 . 3))\u000A(17 . 3)\u000AACL2 !&gt;(<see topic=\"ACL2____DEFATTACH\">defattach</see> f nil) ; unattach f (<see topic=\"COMMON-LISP____REMOVE\">remove</see> its attachment)\u000A[... output omitted ...]\u000A :ATTACHMENTS-RECORDED\u000AACL2 !&gt;(f '(3 4)) ; undefined function error once again\u000A1&gt; (ACL2_*1*_ACL2::F (3 4))\u000A\u000AACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function\u000AF on argument list:\u000A\u000A((3 4))\u000A\u000ATo debug see :DOC print-gv, see :DOC trace, and see :DOC wet.\u000A\u000AACL2 !&gt;</code> \u000A \u000A <p><b>Syntax and semantics of defattach.</b></p> \u000A \u000A <p>The log above shows that the event <v>(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)</v> allows <v>g</v> to be \u000A used for evaluating calls of <v>f</v>.  From a logical perspective, the \u000A evaluation takes place in the addition to the current session of an \u000A ``attachment equation'' axiom (universally quantified over all <v>x</v>) for \u000A each <v>defattach</v> event:</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f x) (g x)) ;;; attachment equation axiom for (<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)</code> \u000A \u000A <p>Below we explain <v>defattach</v> in some detail.  But it is important to \u000A keep in mind that evaluation with the attachment equations takes place in an \u000A extension of the logical theory of the session.  ACL2 guarantees that this \u000A so-called ``evaluation theory'' remains consistent, assuming the absence of \u000A <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> <see topic=\"ACL2____EVENTS\">events</see> from the user.  This guarantee is a consequence \u000A of a more general guarantee: an ACL2 logical <see topic=\"ACL2____WORLD\">world</see> exists in which \u000A (loosely speaking) the attachment equation for <v>(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)</v>, as \u000A <v>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> f (...) (g ...))</v>, takes the place of the original defining event \u000A for <v>f</v>, for each <v>defattach</v> event.  This more general guarantee holds \u000A even if there are <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> events, though as explained below, no \u000A function symbol that syntactically supports a <v>defaxiom</v> formula is allowed \u000A to get an attachment.  A deeper discussion of the logical issues is available \u000A (but not intended to be read by most users) in a long comment in the ACL2 \u000A source code labeled ``Essay on Defattach.''</p> \u000A \u000A <code>Example Forms:\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)   ; call g in place of calling constrained function f\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g)) ; same as just above\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> foo)))))\u000A                  ; equivalent to first form above, except with hints for the\u000A                  ; proof that the guard of f implies the guard of g\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> foo)))\u000A                :otf-flg t))\u000A                  ; as above, except with an :otf-flg of t for the proof that\u000A                  ; the guard of f implies the guard of g\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g)\u000A           :hints ((&quot;Goal&quot; :use my-thm)))\u000A                  ; equivalent to first form above, except with hints for the\u000A                  ; proof that the constraints on f hold for g\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g)\u000A           :hints ((&quot;Goal&quot; :use my-thm))\u000A           :otf-flg t)\u000A                  ; as above, except with an :otf-flg of t for the proof that\u000A                  ; the constraints on f hold for g\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g)\u000A           (h j)) ; Attach g to f and attach j to h\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g :attach nil)\u000A           (h j)) ; Same as just above, including the same proof obligations,\u000A                  ; except for one difference: because of :attach nil, calls\u000A                  ; of f will not be evaluated, i.e., there will be no\u000A                  ; executable attachment of g to f\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f nil)\u000A           (h j)) ; Attach j to h and unattach f\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> foo))))\u000A           (h j :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> bar))))\u000A           :hints ((&quot;Goal&quot; :use my-thm)))\u000A                  ; Attach g to f and attach j to h, with hints:\u000A                  ; - For proving that the guard of f implies the guard of g,\u000A                  ;   enable foo;\u000A                  ; - For proving that the guard of h implies the guard of j,\u000A                  ;   enable bar; and\u000A                  ; - For proving that the constraints on f and h hold for\u000A                  ;   g and j (respectively), use theorem my-thm.\u000A\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f nil)   ; remove the attachment of f, if any (e.g., g above)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f nil)) ; same as just above\u000A\u000AGeneral Forms:\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)   ; single attach or, if g is nil, unattach\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f1 g1 :kwd val ...)\u000A           ...\u000A           (fk gk :kwd' val' ...)\u000A           :kwd'' val'' ...)</code> \u000A \u000A <p>where each indicated keyword-value pair is optional and each keyword is one \u000A of <v>:ATTACH</v>, <v>:HINTS</v>, <v>:OTF-FLG</v>, or <v>:INSTRUCTIONS</v>.  The value \u000A of each <v>:ATTACH</v> keyword is either <v>t</v> or <v>nil</v>, with default <v>t</v> \u000A except that the value of <v>:ATTACH</v> at the ``top level,'' after each entry \u000A <v>(fi gi ...)</v>, is the default for each <v>:ATTACH</v> keyword supplied in \u000A such an entry.  We discuss the <v>:ATTACH</v> keyword later in this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic.  The associated values for the other keywords have the \u000A usual meanings for the proof obligations described below: the guard proof \u000A obligation for keywords within each <v>(fi gi ...)</v> entry, and the constraint \u000A proof obligation for keywords at the top level.  No keyword may occur twice in \u000A the same context, i.e., within the same <v>(fi gi ...)</v> entry or at the top \u000A level; and <v>:INSTRUCTIONS</v> may not occur in the same context with \u000A <v>:HINTS</v> or <v>:OTF-FLG</v>.</p> \u000A \u000A <p>The first General Form above is simply an abbreviation for the form \u000A <v>(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f g))</v>, which is an instance of the second General Form above. \u000A For the second General Form we say that <v>gi</v> is ``attached to'' <v>fi</v> (by \u000A the <v>defattach</v> event) if <v>gi</v> is not <v>nil</v>, and otherwise we say \u000A that <v>fi</v> is ``unattached'' (by the <v>defattach</v> event).  It is also \u000A convenient to refer to <v>&lt;fi,gi&gt;</v> as an ``attachment pair'' (of the event) \u000A if <v>gi</v> is not <v>nil</v>.  We may refer to the set of <v>fi</v> as the \u000A ``attachment nest'' of each <v>fi</v>.</p> \u000A \u000A <p>We start with a brief introduction to the first General Form in the case \u000A that <v>g</v> is not <v>nil</v>.  This form arranges that during evaluation, with \u000A exceptions noted below, every call of the constrained function symbol <v>f</v> \u000A will in essence be replaced by a call of the function symbol <v>g</v> on the \u000A same arguments.  We may then refer to <v>g</v> as the ``attachment of'' <v>f</v>, \u000A or say that ``<v>g</v> is attached to <v>f</v>.''  Notable exceptions, where we do \u000A not use attachments during evaluation, are for macroexpansion, evaluation of \u000A <tt><see topic=\"ACL2____DEFCONST\">defconst</see></tt> and <tt><see topic=\"ACL2____DEFPKG\">defpkg</see></tt> terms, evaluation during <tt><see topic=\"ACL2____TABLE\">table</see></tt> \u000A events, some <see topic=\"ACL2____STOBJ\">stobj</see> operations including all <see topic='ACL2____STOBJ'>updates</see>, and especially evaluation of ground terms (terms \u000A without free variables) during proofs.  However, even for these cases we allow \u000A the use of attachments in the first argument of <tt><see topic=\"ACL2____PROG2_42\">prog2$</see></tt> and, more \u000A generally, the next-to-last (i.e., second) argument of <tt><see topic=\"ACL2____RETURN-LAST\">return-last</see></tt> \u000A when its first argument is not of the form <v>'m</v> for some macro, <v>m</v>.</p> \u000A \u000A <p>To see why attachments are disallowed during evaluation of ground terms \u000A during proofs (except for the <tt><see topic=\"ACL2____PROG2_42\">prog2$</see></tt> and <tt><see topic=\"ACL2____RETURN-LAST\">return-last</see></tt> cases \u000A mentioned above), consider the following example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTUB\">defstub</see> f (x) t)\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x) (<see topic=\"COMMON-LISP_____B2\">+</see> 3 x))\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)</code> \u000A \u000A <p>If the form <v>(f 2)</v> is submitted at the ACL2 prompt, the result will be \u000A <v>5</v> because the attachment <v>g</v> of <v>f</v> is called on the argument, \u000A <v>2</v>.  However, during a proof the term <v>(f 2)</v> will not be simplified to \u000A <v>5</v>, since that would be unsound, as there are no axioms about <v>f</v> that \u000A would justify such a simplification.</p> \u000A \u000A <p>For the case that <v>g</v> is <v>nil</v> in the first General Form above, the \u000A result is the removal of the existing attachment to <v>f</v>, if any.  After \u000A this removal, calls of <v>f</v> will once again cause errors saying that ``ACL2 \u000A cannot ev the call of undefined function <v>f</v> ...''.  In this case not only \u000A is the previous attachment to <v>f</v> removed; moreover, for every function \u000A symbol <v>f'</v> in the attachment nest of <v>f</v> in the <v>defattach</v> event \u000A that introduced the existing attachment to <v>f</v>, then <v>f'</v> is unattached. \u000A (An example near the end of this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic shows why this \u000A unattachment needs to be done.) Such removal takes place before the current \u000A <v>defattach</v> is processed, but is restored if the new event fails to be \u000A admitted.</p> \u000A \u000A <p>We focus henceforth on the second General Form.  There must be at least one \u000A attachment, i.e., <v>i</v> must be at least 1.  All keywords are optional; their \u000A role is described below.  The <v>fi</v> must be distinct constrained function \u000A symbols, that is, function symbols all introduced in <see topic=\"ACL2____SIGNATURE\">signature</see>s of \u000A <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> <see topic=\"ACL2____EVENTS\">events</see> (or macros such as <tt><see topic=\"ACL2____DEFSTUB\">defstub</see></tt> that \u000A generate <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> events).  Each non-<v>nil</v> <v>gi</v> is a \u000A <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt>-mode function symbol that has had its guards verified, \u000A with the same <see topic=\"ACL2____SIGNATURE\">signature</see> as <v>fi</v> (though formal parameters for \u000A <v>fi</v> and <v>gi</v> may have different names).  (Note: The macro \u000A <v>defattach!</v>, defined in community book <v>books/misc/defattach-bang</v>, \u000A avoids this restriction.)  This event generates proof obligations and an \u000A ordering check, both described below.  The effect of this event is first to \u000A remove any existing attachments for all the function symbols <v>fi</v>, as \u000A described above for the first General Form, and then to attach each <v>gi</v> to \u000A <v>fi</v>.</p> \u000A \u000A <p>Proof obligations must be checked before making attachments.  For this \u000A discussion we assume that each <v>gi</v> is non-<v>nil</v> (otherwise first remove \u000A all attachment pairs <v>&lt;fi,gi&gt;</v> for which <v>gi</v> is nil).  Let <v>s</v> be \u000A the functional substitution mapping each <v>fi</v> to <v>gi</v>.  For any term \u000A <v>u</v>, we write <v>u\\s</v> for the result of applying <v>s</v> to <v>u</v>; that \u000A is, <v>u\\s</v> is the ``functional instance'' obtained by replacing each \u000A <v>fi</v> by <v>gi</v> in <v>u</v>.  Let <v>G_fi</v> and <v>G_gi</v> be the guards of \u000A <v>fi</v> and <v>gi</v>, respectively.  Let <v>G_fi'</v> be the result of replacing \u000A each formal of <v>fi</v> by the corresponding formal of <v>gi</v> in <v>G_fi</v>. \u000A ACL2 first proves, for each <v>i</v> (in order), the formula <v>(<see topic=\"ACL2____IMPLIES\">implies</see> G_fi'\u000A G_gi)\\s</v>.  If this sequence of proofs succeeds, then the remaining formula \u000A to prove is the functional instance <v>C\\s</v> of the conjunction <v>C</v> of the \u000A constraints on the symbols <v>fi</v>; see <see topic=\"ACL2____CONSTRAINT\">constraint</see>.  This last proof \u000A obligation is thus similar to the one generated by functional instantiation \u000A (see <see topic=\"ACL2____CONSTRAINT\">constraint</see>).  As with functional instantiation, ACL2 stores the \u000A fact that such proofs have been done so that they are avoided in future events \u000A (see <see topic=\"ACL2____LEMMA-INSTANCE\">lemma-instance</see>).  Thus, you will likely avoid some proofs with the \u000A sequence</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f nil)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f nil)\u000A...</code> \u000A \u000A <p>rather than the sequence:</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)\u000A:u\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g)\u000A:u\u000A...</code> \u000A \u000A <p>It remains to describe an ordering check.  We begin with the following \u000A motivating example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTUB\">defstub</see> f (x) t) ; constrained function with no constraints\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x) (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t)) (<see topic=\"COMMON-LISP____NOT\">not</see> (f x)))\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f g) ; ILLEGAL!</code> \u000A \u000A <p>Were the above <v>defattach</v> event to succeed, the evaluation theory \u000A (discussed above) would be inconsistent: <v>(f x)</v> equals <v>(g x)</v> by the \u000A new attachment equation, which in turn equals <v>(<see topic=\"COMMON-LISP____NOT\">not</see> (f x))</v> by definition \u000A of <v>g</v>.  The evaluation would therefore be meaningless.  Also, from a \u000A practical perspective, there would be an infinite loop resulting from any call \u000A of <v>f</v>.</p> \u000A \u000A <p>We consider a function symbol <v>g</v> to be an ``extended immediate ancestor \u000A of'' a function symbol <v>f</v> if either of the following two criteria is met: \u000A (a) <v>g</v> occurs in the formula that introduces <v>f</v> (i.e., definition body \u000A or constraint) and <v>g</v> is introduced by an event different from (earlier \u000A than) the event introducing <v>f</v>; or (b) <v>g</v> is attached to <v>f</v>.  For \u000A a proposed <v>defattach</v> event, we check that this relation has no cycles, \u000A where for condition (b) we include all attachment pairs that would result, \u000A including those remaining from earlier <v>defattach</v> events.</p> \u000A \u000A <p>Of course, a special case is that no function symbol may be attached to \u000A itself.  Similarly, no function symbol may be attached to any of its \u000A ``siblings'' &mdash; function symbols introduced by the same event &mdash; as \u000A siblings are considered equivalent for purposes of the acyclicity check.</p> \u000A \u000A <p><b>Three primary uses of defattach.</b><br></br></p> \u000A \u000A <p>We anticipate three uses of <v>defattach</v>:</p> \u000A \u000A <p>(1) Constrained function execution</p> \u000A \u000A <p>(2) Sound modification of the ACL2 system</p> \u000A \u000A <p>(3) Program refinement</p> \u000A \u000A <p>We discuss these in turn.</p> \u000A \u000A <p>(1) The example at the beginning of this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> illustrates \u000A constrained function execution.</p> \u000A \u000A <p>(2) ACL2 is written essentially in itself.  Thus, there is an opportunity \u000A to attaching to system functions.  For example, encapsulated function \u000A <v>too-many-ifs-post-rewrite</v>, in the ACL2 source code, receives an \u000A attachment of <v>too-many-ifs-post-rewrite-builtin</v>, which implements a \u000A heuristic used in the rewriter.  To find all such examples, search the source \u000A code for the string `-builtin'.</p> \u000A \u000A <p>Over time, we expect to continue replacing ACL2 source code in a similar \u000A manner.  We invite the ACL2 community to assist in this ``open architecture'' \u000A enterprise; feel free to email the ACL2 implementors if you are interested in \u000A such activity.</p> \u000A \u000A <p>(3) Recall that for an attachment pair <v>&lt;f,g&gt;</v>, a proof obligation is \u000A (speaking informally) that <v>g</v> satisfies the constraint on <v>f</v>.  Yet \u000A more informally speaking, <v>g</v> is ``more defined'' than <v>f</v>; we can think \u000A of <v>g</v> as ``refining'' <v>f</v>.  With these informal notions as motivation, \u000A we can view defattach as providing refinement though the following formal \u000A observation: the evaluation theory extends the theory of the ACL2 session, \u000A specifically by the addition of all attachment equations.  For the \u000A logic-inclined, it may be useful to think model-theoretically: The class of \u000A models of the evaluation theory is non-empty but is a subset of the class of \u000A models of the current session theory.</p> \u000A \u000A <p><b>Miscellaneous remarks, with discussion of possible user errors.</b></p> \u000A \u000A <p>We conclude with remarks on some details.</p> \u000A \u000A <p>A <v>defattach</v> event is never redundant (see <see topic=\"ACL2____REDUNDANT-EVENTS\">redundant-events</see>); in \u000A that sense it is analogous to <tt><see topic=\"ACL2____IN-THEORY\">in-theory</see></tt>.</p> \u000A \u000A <p>As mentioned above, the use of attachments is disabled for evaluation of \u000A ground terms during proofs.  However, attachments can be used on code during \u000A the proof process, essentially when the ``program refinement'' is on theorem \u000A prover code rather than on functions we are reasoning about.  The attachment \u000A to <v>too-many-ifs-post-rewrite</v> described above provides one example of such \u000A attachments.  Meta functions and clause-processor functions can also have \u000A attachments, with the restriction that no common ancestor with the evaluator \u000A can have an attachment; see <see topic=\"ACL2____EVALUATOR-RESTRICTIONS\">evaluator-restrictions</see>.</p> \u000A \u000A <p>For an attachment pair <v>&lt;f,g&gt;</v>, evaluation of <v>f</v> never consults the \u000A <see topic=\"ACL2____GUARD\">guard</see> of <v>f</v>.  Rather, control passes to <v>g</v>, whose guard is \u000A checked if necessary.  The proof obligation related to guards, as described \u000A above, guarantees that any legal call of <v>f</v> is also a legal call of \u000A <v>g</v>.  Thus for guard-verified code that results in calls of <v>f</v> in raw \u000A Lisp, it is sound to replace these calls with corresponding calls of \u000A <v>g</v>.</p> \u000A \u000A <p><v>Defattach</v> events are illegal inside any <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> event with \u000A a non-empty <see topic=\"ACL2____SIGNATURE\">signature</see> unless they are <see topic=\"ACL2____LOCAL\">local</see> to the <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>.</p> \u000A \u000A <p>We next discuss a restriction based on a notion of a function symbol \u000A syntactically supporting an event.  Function symbol <v>f</v> is <i>ancestral</i> \u000A in event <v>E</v> if either <v>f</v> occurs in <v>E</v>, or (recursively) <v>f</v> \u000A occurs in an event <v>E'</v> that introduces some function symbol <v>g</v> that is \u000A ancestral in <v>E</v>.  We require that no function symbol ancestral in the \u000A formula of a <tt><see topic=\"ACL2____DEFAXIOM\">defaxiom</see></tt> event may have an attachment.  Theoretical \u000A reasons are discussed in comments in the ACL2 source code, but here we give a \u000A little example showing the need for some such restriction: without it, we show \u000A how to prove <v>nil</v>!</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFN\">defn</see> g1 () 1)\u000A(<see topic=\"ACL2____DEFN\">defn</see> g2 () 2)\u000A(<see topic=\"ACL2____DEFSTUB\">defstub</see> f1 () t)\u000A(<see topic=\"ACL2____DEFSTUB\">defstub</see> f2 () t)\u000A(<see topic=\"ACL2____DEFUND\">defund</see> p (x)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> x))\u000A  t)\u000A(<see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see> evl evl-list\u000A  ((p x)))\u000A(<see topic=\"ACL2____DEFAXIOM\">defaxiom</see> f1-is-f2\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f1) (f2)))\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> meta-fn (x)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f1) (f2))\u000A         x)\u000A        (t *nil*)))\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> bad-meta-rule\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (evl x a)\u000A         (evl (meta-fn x) a))\u000A  :rule-classes ((:meta :trigger-fns (p))))\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f1 g1)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> f2 g2)\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> contradiction\u000A  nil\u000A  :hints ((&quot;Goal&quot; :use ((:instance (:theorem (<see topic=\"COMMON-LISP____NOT\">not</see> (p x)))\u000A                                   (x t)))))\u000A  :rule-classes nil)</code> \u000A \u000A <p>To see all attachments: <v>(all-attachments (w state))</v>.  (Note that \u000A attachments introduced with a non-<v>nil</v> value of <v>:skip-checks</v> will be \u000A omitted from this list.)</p> \u000A \u000A <p>Next we discuss the <v>:ATTACH</v> keyword.  There is rarely if ever a reason \u000A to specify <v>:ATTACH T</v>, but the following (admittedly contrived) example \u000A shows why it may be necessary to specify <v>:ATTACH NIL</v>.  First we introduce \u000A three new function symbols.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTUB\">defstub</see> f (x) t)\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> g (x)\u000A  (f x))\u000A\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> ((h (x) t))\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> h (x) (g x)))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> h-prop\u000A    (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (h x) (g x))))</code> \u000A \u000A <p>Now suppose we want to attach the function <tt><see topic=\"ACL2____ACL2-NUMBERP\">ACL2-numberp</see></tt> to both \u000A <v>f</v> and <v>h</v>.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f acl2-numberp) (h acl2-numberp))</code> \u000A \u000A <p>Such an attempt fails, because the following constraint is generated but is \u000A not a theorem: <v>(<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"ACL2____ACL2-NUMBERP\">ACL2-NUMBERP</see> X) (G X))</v>.  Clearly we also need to \u000A attach to <v>g</v> as well.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f acl2-numberp) (h acl2-numberp) (g acl2-numberp))</code> \u000A \u000A <p>But this fails for a different reason, as explained by the error \u000A message:</p> \u000A \u000A <code>ACL2 Error in ( DEFATTACH (F ACL2-NUMBERP) ...):  It is illegal to\u000Aattach to function symbol G, because it was introduced with DEFUN.\u000ASee :DOC defattach.</code> \u000A \u000A <p>That is: logically, we need to attach <v>acl2-numberp</v> to <v>g</v>, but we \u000A cannot actually attach to <v>g</v> because it was introduced with <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>, \u000A not with <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt>.  So we specify <v>:ATTACH NIL</v> for the \u000A attachment to <v>g</v>, saying that no actual attachment should be made to the \u000A code for <v>g</v>, even though for logical purposes we should consider that \u000A <v>g</v> has been given the indicated attachment.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f acl2-numberp) (h acl2-numberp) (g acl2-numberp :attach nil))</code> \u000A \u000A <p>Finally, we can check that <v>f</v>, <v>g</v>, and <v>h</v> execute as \u000A expected.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____ASSERT-EVENT\">assert-event</see> (<see topic=\"COMMON-LISP____AND\">and</see> (f 3)\u000A                   (<see topic=\"COMMON-LISP____NOT\">not</see> (f t))\u000A                   (g 3)\u000A                   (<see topic=\"COMMON-LISP____NOT\">not</see> (g t))\u000A                   (h 3)\u000A                   (<see topic=\"COMMON-LISP____NOT\">not</see> (h t))))\u000A :PASSED\u000AACL2 !&gt;</code> \u000A \u000A <p>We conclude with an example promised above, showing why it is necessary in \u000A general to unattach all function symbols in an existing attachment nest when \u000A unattaching any one of those function symbols.  Consider the following \u000A example.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTUB\">defstub</see> f1 () t)\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> ((f2 () t))\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f2 () (f1)))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> f2=f1 (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f2) (f1))))\u000A(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> ((f3 () t))\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> f3 () (f1)))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> f3=f1 (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (f3) (f1))))\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> four () (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t)) 4)\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> five () (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t)) 5)\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f1 four) (f2 four))\u000A(<see topic=\"ACL2____DEFATTACH\">defattach</see> (f1 five) (f3 five))</code> \u000A \u000A <p>The second <v>defattach</v> replaces erases the existing attachment pair \u000A <v>&lt;f1,four&gt;</v> before installing the new attachment pairs <v>&lt;f1,five&gt;</v> and \u000A <v>&lt;f3,five&gt;</v>.  After the second defattach, both <v>(f1)</v> and <v>(f3)</v> \u000A evaluate to 5.  Now suppose that the attachment pair <v>&lt;f2,four&gt;</v> were not \u000A erased.  Then we would have <v>(f1)</v> evaluating to 5 and <v>(f2)</v> evaluating \u000A to 4, contradicting the constraint <v>f2=f1</v>.  The evaluation theory would \u000A thus be inconsistent, and at a more concrete level, the user might well be \u000A surprised by evaluation results if the code were written with the assumption \u000A specified in the constraint <v>f2=f1</v>.</p>"],

 "ACL2____MONITOR":[["Break-rewrite"],"ACL2 Sources","ACL2","<code>Example:\u000A(<see topic=\"ACL2____MONITOR\">monitor</see> '(:rewrite assoc-of-app) 't)\u000A:monitor (:rewrite assoc-of-app) t\u000A:monitor (:definition app) (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____BRR_04\">brr@</see> :target) '(app c d))\u000A:monitor (:linear rule3) t\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____MONITOR\">monitor</see> rune term)</code> \u000A \u000A <p>where <v>rune</v> is a <see topic=\"ACL2____RUNE\">rune</see> and <v>term</v> is a term, called the \u000A ``break condition.'' <v>Rune</v> must be a rune corresponding to a rule of class \u000A <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt>, <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt>, or <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt>.</p> \u000A \u000A <p>When a <see topic=\"ACL2____RUNE\">rune</see> is <see topic=\"ACL2____MONITOR\">monitor</see>ed any attempt to apply it may result \u000A in an interactive break in an ACL2 ``<see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see>.'' There you \u000A will get a chance to see how the application proceeds.  See <see topic=\"ACL2____BREAK-REWRITE\">break-rewrite</see> for a description of the interactive loop entered.  Whether an \u000A interactive break occurs depends on the value of the break condition \u000A expression associated with the <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>.</p> \u000A \u000A <p>NOTE: Some <v>:rewrite</v> rules are considered ``simple abbreviations''; see \u000A <see topic=\"ACL2____SIMPLE\">simple</see>.  These can be be monitored, but only at certain times during \u000A the proof.  Monitoring is carried out by code inside the rewriter but \u000A abbreviation rules may be applied by a special purpose simplifier inside the \u000A so-called <i>preprocess</i> phase of a proof.  If you desire to monitor an \u000A abbreviation rule, a warning will be printed suggesting that you may want to \u000A supply the hint <v>:DO-NOT '(PREPROCESS)</v>; see <see topic=\"ACL2____HINTS\">hints</see>.  Without such a \u000A hint, an abbreviation rule can be applied during the preprocess phase of a \u000A proof, and no such application will cause an interactive break.</p> \u000A \u000A <p>To remove a <see topic=\"ACL2____RUNE\">rune</see> from the list of <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s, use \u000A <v>unmonitor</v>.  To see which <see topic=\"ACL2____RUNE\">rune</see>s are <see topic=\"ACL2____MONITOR\">monitor</see>ed and what their \u000A break conditions are, evaluate <v>(<see topic=\"ACL2____MONITORED-RUNES\">monitored-runes</see>)</v>.</p> \u000A \u000A <p><v>Monitor</v>, <v>unmonitor</v> and <v>monitored-runes</v> are macros that \u000A expand into expressions involving <v>state</v>.  While these macros appear to \u000A return the list of <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s this is an illusion.  They \u000A all print <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see> information to the comment window and \u000A then return error triples (see <see topic=\"ACL2____ERROR-TRIPLES\">error-triples</see>) instructing <v>ld</v> to \u000A print nothing.  It is impossible to return the list of <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s because it exists only in the <see topic=\"ACL2____WORMHOLE\">wormhole</see> <see topic=\"ACL2____STATE\">state</see> with which \u000A you interact when a break occurs.  This allows you to change the <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see>s and their conditions during the course of a proof \u000A attempt without changing the <see topic=\"ACL2____STATE\">state</see> in which the the proof is being \u000A constructed.</p> \u000A \u000A <p>Unconditional break points are obtained by using the break condition \u000A <v>t</v>.  We now discuss conditional break points.  The break condition, \u000A <v>expr</v>, must be a term that contains no free variables other than \u000A <v>state</v> and that returns a single non-<v>state</v> result.  In fact, the \u000A result should be <v>nil</v>, <v>t</v>, or a true list of commands to be fed to the \u000A resulting interactive break.  Whenever the system attempts to use the \u000A associated rule, <v>expr</v> is evaluated in the <see topic=\"ACL2____WORMHOLE\">wormhole</see> interaction \u000A <see topic=\"ACL2____STATE\">state</see>.  A break occurs only if the result of evaluating <v>expr</v> is \u000A non-<v>nil</v>.  If the result is a true list, that list is appended to the \u000A front of <v>standard-oi</v> and hence is taken as the initial user commands \u000A issued to the interactive break.</p> \u000A \u000A <p>In order to develop effective break conditions it must be possible to \u000A access context sensitive information, i.e., information about the context in \u000A which the <see topic=\"ACL2____MONITOR\">monitor</see>ed <see topic=\"ACL2____RUNE\">rune</see> is being tried.  The <tt><see topic=\"ACL2____BRR_04\">brr@</see></tt> macro \u000A may be used in break conditions to access such information as the term being \u000A rewritten and the current governing assumptions.  This information is not \u000A stored in the proof <see topic=\"ACL2____STATE\">state</see> but is transferred into the <see topic=\"ACL2____WORMHOLE\">wormhole</see> \u000A <see topic=\"ACL2____STATE\">state</see> when breaks occur.  The macro form is <v>(<see topic=\"ACL2____BRR_04\">brr@</see> :sym)</v> where \u000A <v>:sym</v> is one of several keyword symbols, including <v>:target</v> (the term \u000A being rewritten), <v>:unify-subst</v> (the substitution that instantiates the \u000A left-hand side of the conclusion of the rule so that it is the target term), \u000A and <v>:</v><tt><see topic=\"ACL2____TYPE-ALIST\">type-alist</see></tt> (the governing assumptions).  See <see topic=\"ACL2____BRR_04\">brr@</see>.</p> \u000A \u000A <p>For example,</p> \u000A \u000A <code>ACL2 !&gt;:monitor (:rewrite assoc-of-app)\u000A                (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____BRR_04\">brr@</see> :target) '(app a (app b c)))</code> \u000A \u000A <p>will monitor <v>(:rewrite assoc-of-app)</v> but will cause an interactive \u000A break only when the target term, the term being rewritten, is <v>(app a (app b\u000A c))</v>.</p> \u000A \u000A <p>Because break conditions are evaluated in the interaction environment, the \u000A user developing a break condition for a given <see topic=\"ACL2____RUNE\">rune</see> can test candidate \u000A break conditions before installing them.  For example, suppose an \u000A unconditional break has been installed on a <see topic=\"ACL2____RUNE\">rune</see>, that an interactive \u000A break has occurred and that the user has determined both that this particular \u000A application is uninteresting and that many more such applications will likely \u000A occur.  An appropriate response would be to develop an expression that \u000A recognizes such applications and returns <v>nil</v>.  Of course, the hard task \u000A is figuring out what makes the current application uninteresting.  But once a \u000A candidate expression is developed, the user can evaluate it in the current \u000A context simply to confirm that it returns <v>nil</v>.</p> \u000A \u000A <p>Recall that when a break condition returns a non-<v>nil</v> true list that \u000A list is appended to the front of <v>standard-oi</v>.  For example,</p> \u000A \u000A <code>ACL2 !&gt;:monitor (:rewrite assoc-of-app) '(:go)</code> \u000A \u000A <p>will cause <v>(:rewrite assoc-of-app)</v> to be <see topic=\"ACL2____MONITOR\">monitor</see>ed and will \u000A make the break condition be <v>'(:go)</v>.  This break condition always \u000A evaluates the non-<v>nil</v> true list <v>(:go)</v>.  Thus, an interactive break \u000A will occur every time <v>(:rewrite assoc-of-app)</v> is tried.  The break is fed \u000A the command <v>:go</v>.  Now the command <v>:go</v> causes <v>break-rewrite</v> to \u000A (a) evaluate the attempt to apply the lemma, (b) print the result of that \u000A attempt, and (c) exit from the interactive break and let the proof attempt \u000A continue.  Thus, in effect, the above <v>:monitor</v> merely ``traces'' the \u000A attempted applications of the <see topic=\"ACL2____RUNE\">rune</see> but never causes an interactive \u000A break requiring input from the user.</p> \u000A \u000A <p>It is possible to use this feature to cause a conditional break where the \u000A effective break condition is tested <b>after</b> the lemma has been tried. \u000A For example:</p> \u000A \u000A <code>ACL2 !&gt;:monitor (:rewrite lemma12)\u000A                '(:unify-subst\u000A                  :eval$ nil\u000A                  :ok-if (<see topic=\"COMMON-LISP____OR\">or</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"ACL2____BRR_04\">brr@</see> :wonp))\u000A                             (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____BRR_04\">brr@</see> :rewritten-rhs) '(foo a))))\u000A                  :rewritten-rhs)</code> \u000A \u000A <p>causes the following behavior when <v>(:rewrite lemma12)</v> is tried.  A \u000A break always occurs, but it is fed the commands above.  The first, \u000A <v>:unify-subst</v>, causes <v>break-rewrite</v> to print out the unifying \u000A substitution.  Then in response to <v>:eval$</v> <v>nil</v> the lemma is tried but \u000A with all <see topic=\"ACL2____RUNE\">rune</see>s temporarily <see topic=\"ACL2____UNMONITOR\">unmonitor</see>ed.  Thus no breaks will \u000A occur during the rewriting of the hypotheses of the lemma.  When the attempt \u000A has been made, control returns to <v>break-rewrite</v> (which will print the \u000A results of the attempt, i.e., whether the lemma was applied, if so what the \u000A result is, if not why it failed).  The next command, the <v>:ok-if</v> with its \u000A following expression, is a conditional exit command.  It means exit \u000A <v>break-rewrite</v> if either the attempt was unsuccessful, <v>(<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"ACL2____BRR_04\">brr@</see>\u000A :wonp))</v>, or if the result of the rewrite is any term other than <v>(foo\u000A a)</v>.  If this condition is met, the break is exited and the remaining break \u000A commands are irrelevant.  If this condition is not met then the next command, \u000A <v>:rewritten-rhs</v>, prints the result of the application (which in this \u000A contrived example is known to be <v>(foo a)</v>).  Finally, the list of supplied \u000A commands is exhausted but <v>break-rewrite</v> expects more input.  Therefore, \u000A it begins prompting the user for input.  The end result, then, of the above \u000A <v>:monitor</v> command is that the <see topic=\"ACL2____RUNE\">rune</see> in question is elaborately \u000A traced and interactive breaks occur whenever it rewrites its target to <v>(foo\u000A a)</v>.</p> \u000A \u000A <p>We recognize that the above break condition is fairly arcane.  We suspect \u000A that with experience we will develop some useful idioms.  For example, it is \u000A straightforward now to define macros that monitor <see topic=\"ACL2____RUNE\">rune</see>s in the ways \u000A suggested by the following names: <v>trace-rune</v>, <v>break-if-target-is</v>, \u000A and <v>break-if-result-is</v>.  For example, the last could be defined as</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see> break-if-result-is (<see topic=\"ACL2____RUNE\">rune</see> term)\u000A  `(<see topic=\"ACL2____MONITOR\">monitor</see> ',rune\u000A            '(<see topic=\"COMMON-LISP____QUOTE\">quote</see> (:eval :ok-if\u000A                           (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"ACL2____BRR_04\">brr@</see> :rewritten-rhs) ',term))))))</code> \u000A \u000A <p>(Note however that the submitted term must be in translated form.)</p> \u000A \u000A <p>Since we don't have any experience with this kind of control on lemmas we \u000A thought it best to provide a general (if arcane) mechanism and hope that the \u000A ACL2 community will develop the special cases that we find most \u000A convenient.</p>"],

 "ACL2____FORWARD-CHAINING":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <code>Examples:\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> p-and-r-forward           ; When (p a) appears in a formula to be\u000A (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p x) (r x))       ; simplified, try to establish (p a) and\u000A          (<see topic=\"ACL2____Q\">q</see> (f x)))              ; (r a) and, if successful, add (<see topic=\"ACL2____Q\">q</see> (f a))\u000A :rule-classes :forward-chaining) ; to the known assumptions.\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> p-and-r-forward           ; as above with most defaults filled in\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p x) (r x))\u000A           (<see topic=\"ACL2____Q\">q</see> (f x)))\u000A  :rule-classes ((:forward-chaining :trigger-terms ((p x))\u000A                                    :corollary (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p x) (r x))\u000A                                                        (<see topic=\"ACL2____Q\">q</see> (f x)))\u000A                                    :match-free :all)))</code> \u000A \u000A <p>To specify the triggering terms provide a non-empty list of terms as the \u000A value of the <v>:trigger-terms</v> field of the rule class object.</p> \u000A \u000A <code>General Form:\u000AAny theorem, provided an acceptable triggering term exists.</code> \u000A \u000A <p>The structure of this documentation is as follows.  First we give a brief \u000A overview of forward chaining and contrast it to backchaining (rewriting). \u000A Then we lay out the syntactic restrictions on <v>:forward-chaining</v> rules. \u000A Then we give more details about the process and point to a tool to assist you \u000A in debugging your <v>:forward-chaining</v> rules.</p> \u000A \u000A <p><i>Overview and When to Use Forward Chaining</i></p> \u000A \u000A <p>Forward chaining is performed as part of the simplification process: before \u000A the goal is rewritten a <i>context</i> is established.  The context tells the \u000A theorem prover what may be assumed during rewriting, in particular, to \u000A establish hypotheses of rewrite rules.  Forward chaining is used to extend the \u000A context before rewriting begins.  For example, the <v>:forward-chaining</v> rule \u000A <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (p x) (p1 x))</v> would add <v>(p1 A)</v> to the context, where <v>A</v> \u000A is some term, if <v>(p A)</v> is already in the context.</p> \u000A \u000A <p>Forward chaining and backchaining are duals.  If a rewrite rule requires \u000A that <v>(p1 A)</v> be established and <v>(p A)</v> is known, it could be done \u000A either by making <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (p x) (p1 x))</v> a <v>:forward-chaining</v> rule or \u000A a <v>:rewrite</v> rule.  Which should you choose?</p> \u000A \u000A <p>As a rule of thumb, if a conclusion like <v>(p1 A)</v> is expected to be \u000A widely needed, it is better to derive it via forward chaining because then it \u000A is available ``for free'' during the rewriting after paying the one-time cost \u000A of forward chaining.  Alternatively, if <v>(p1 A)</v> is a rather special \u000A hypothesis of key importance to only a few rewrite rules, it is best to derive \u000A it only when needed.  Thus forward chaining is pro-active and backward \u000A chaining (rewriting) is reactive.</p> \u000A \u000A <p><i>Syntactic Restrictions</i></p> \u000A \u000A <p>Forward chaining rules are generated from the corollary term (see <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see>) as follows.  First, every <tt><see topic=\"COMMON-LISP____LET\">let</see></tt> expression is expanded \u000A away (hence, so is every <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt> and <tt><see topic=\"COMMON-LISP____LAMBDA\">lambda</see></tt> expression), and \u000A trivial ``guard holders'' are removed; see <see topic=\"ACL2____GUARD-HOLDERS\">guard-holders</see>.  If the \u000A resulting term has the form <v>(<see topic=\"ACL2____IMPLIES\">implies</see> hyp concl)</v>, then <v>concl</v> is \u000A treated as a conjunction, with one forward chaining rule with hypothesis \u000A <v>hyp</v> created for each conjunct.  In the other case, where the corollary \u000A term is not an <tt><see topic=\"ACL2____IMPLIES\">implies</see></tt>, we process it as we process the conclusion in \u000A the first case.</p> \u000A \u000A <p>Note that unlike rewrite rules, a nested implication is not folded into a \u000A single implication.  Consider for example the following term.</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (p1 x)\u000A         (<see topic=\"ACL2____IMPLIES\">implies</see> (p2 x)\u000A                  (p3 x)))</code> \u000A \u000A <p>Although this term is parsed for a rewrite rule as <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p1 x)\u000A (p2 x)) (p3 x))</v>, that is not the case when this term is parsed for a \u000A forward-chaining rule, in which case <v>(p1 x)</v> is treated as the hypothesis \u000A and <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (p2 x) (p3 x))</v> is treated as the conclusion.</p> \u000A \u000A <p>The <v>:trigger-terms</v> field of a <v>:forward-chaining</v> rule class object \u000A should be a non-empty list of terms, if provided, and should have certain \u000A properties described below.  If the <v>:trigger-terms</v> field is not provided, \u000A it defaults to the singleton list containing the ``atom'' of the first \u000A hypothesis of the formula.  (The atom of <v>(<see topic=\"COMMON-LISP____NOT\">not</see> x)</v> is <v>x</v>; the atom of \u000A any other term is the term itself.)  If there are no hypotheses and no \u000A <v>:trigger-terms</v> were provided, an error is caused.</p> \u000A \u000A <p>A triggering term is acceptable if it is not a variable, a quoted constant, \u000A a lambda application, a <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>- (or <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>-) expression, or a \u000A <tt><see topic=\"COMMON-LISP____NOT\">not</see></tt>-expression, and every variable symbol in the conclusion of the \u000A theorem either occurs in the hypotheses or occurs in the trigger.</p> \u000A \u000A <p><i>More Details about Forward Chaining</i></p> \u000A \u000A <p><v>:Forward-chaining</v> rules are used by the simplifier <i>before</i> it \u000A begins to rewrite the literals of the goal.  (Forward chaining is thus carried \u000A out from scratch for each goal.)  If any term in the goal is an instance of a \u000A trigger of some forward chaining rule, we try to establish the hypotheses of \u000A that forward chaining theorem (from the negation of the goal).  To relieve a \u000A hypothesis we only use type reasoning, evaluation of ground terms, and \u000A presence among our known assumptions.  We do not use rewriting.  So-called \u000A free variables in hypotheses are treated specially; see <see topic=\"ACL2____FREE-VARIABLES\">free-variables</see>. \u000A If all hypotheses are relieved, and certain heuristics approve of the newly \u000A derived conclusion, we add the instantiated conclusion to our known \u000A assumptions.  Since this might introduce new terms into the assumptions, \u000A forward chaining is repeated.  Heuristic approval of each new addition is \u000A necessary to avoid infinite looping as would happen with the rule <v>(<see topic=\"ACL2____IMPLIES\">implies</see>\u000A (p x) (p (f x)))</v>, which might otherwise forward chain from <v>(p A)</v> to \u000A <v>(p (f A))</v> to <v>(p (f (f A)))</v>, etc.</p> \u000A \u000A <p><i>Caution</i>.  Forward chaining does not actually add terms to the goals \u000A displayed during proof attempts.  Instead, it extends an associated \u000A <i>context</i>, called ``assumptions'' in the preceding paragraph, that ACL2 \u000A builds from the goal currently being proved.  (For insiders: forward chaining \u000A extends the <tt><see topic=\"ACL2____TYPE-ALIST\">type-alist</see></tt>.)  The context starts out with ``obvious'' \u000A consequences of the negation of the goal.  For example, if the goal is</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p A) (<see topic=\"ACL2____Q\">q</see> (f A)))\u000A         (c A))</code> \u000A \u000A <p>then the context notes that <v>(p A)</v> and <v>(<see topic=\"ACL2____Q\">q</see> (f A))</v> are non-<v>nil</v> \u000A and <v>(c A)</v> is <v>nil</v>.  Forward chaining is then used to expand the \u000A context.  For example, if a forward chaining rule has <v>(f x)</v> as a trigger \u000A term and has body <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (p x) (r (f x)))</v>, then the context is extended \u000A by binding <v>(r (f A))</v> to non-<v>nil</v>, provided the heuristics approve of \u000A this extension.  Note however that since <v>(r (f A))</v> is put into the \u000A context, not the goal, you will not see it in the goal formula.  Furthermore, \u000A the assumption added to the context is just the instantiation of the \u000A conclusion of the rule, with no simplification or rewriting applied.  Thus, \u000A for example, if it contains an enabled non-recursive function symbol it is \u000A unlikely ever to match a (rewritten) term arising during subsequent \u000A simplification of the goal.</p> \u000A \u000A <p>However, forward-chaining does support the linear arithmetic reasoning \u000A package.  For example, suppose that forward-chaining puts <v>(<see topic=\"COMMON-LISP_____C3\">&lt;</see> (f x) (g x))</v> \u000A into the context.  Then this inequality also goes into the linear arithmetic \u000A database, together with suitable instances of linear lemmas whose trigger term \u000A is a call of <v>g</v>.  See <see topic=\"ACL2____LINEAR\">linear</see>.</p> \u000A \u000A <p>Debugging <v>:forward-chaining</v> rules can be difficult since their effects \u000A are not directly visible on the goal being simplified.  Tools are available to \u000A help you discover what forward chaining has occurred see <see topic=\"ACL2____FORWARD-CHAINING-REPORTS\">forward-chaining-reports</see>.</p>"],

 "ACL2____TYPE-SET":[["Miscellaneous"],"ACL2 Sources","ACL2","<p>To help you experiment with type-sets we briefly note the following \u000A utility functions.</p> \u000A \u000A <p><v>(type-set-quote x)</v> will return the type-set of the object <v>x</v>.  For \u000A example, <v>(type-set-quote &quot;test&quot;)</v> is <v>2048</v> and <v>(type-set-quote\u000A '(a b c))</v> is <v>512</v>.</p> \u000A \u000A <p><v>(<see topic=\"ACL2____TYPE-SET\">type-set</see> 'term nil nil nil (ens state) (w state) nil nil nil)</v> will \u000A return the type-set of <v>term</v>.  For example,</p> \u000A \u000A <code>(<see topic=\"ACL2____TYPE-SET\">type-set</see> '(<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> x) nil nil nil (ens state) (w state) nil nil nil)</code> \u000A \u000A <p>will return (mv 192 nil).  192, otherwise known as <v>*ts-boolean*</v>, is \u000A the type-set containing <v>t</v> and <v>nil</v>.  The second result may be ignored \u000A in these experiments.  <v>Term</v> must be in the <v>translated</v>, internal form \u000A shown by <v>:</v><tt><see topic=\"ACL2____TRANS\">trans</see></tt>.  See <see topic=\"ACL2____TRANS\">trans</see> and see <see topic=\"ACL2____TERM\">term</see>.</p> \u000A \u000A <p><v>(type-set-implied-by-term 'x nil 'term (ens state)(w state) nil)</v> will \u000A return the type-set deduced for the variable symbol <v>x</v> assuming the \u000A <v>translated</v> term, <v>term</v>, true.  The second result may be ignored in \u000A these experiments.  For example,</p> \u000A \u000A <code>(type-set-implied-by-term 'v nil '(<see topic=\"COMMON-LISP____INTEGERP\">integerp</see> v)\u000A                          (ens state) (w state) nil)</code> \u000A \u000A <p>returns <v>11</v>.</p> \u000A \u000A <p><v>(convert-type-set-to-term 'x ts (ens state) (w state) nil)</v> will return \u000A a term whose truth is equivalent to the assertion that the term <v>x</v> has \u000A type-set <v>ts</v>.  The second result may be ignored in these experiments.  For \u000A example</p> \u000A \u000A <code>(convert-type-set-to-term 'v 523 (ens state) (w state) nil)</code> \u000A \u000A <p>returns a term expressing the claim that <v>v</v> is either an integer or a \u000A non-<v>nil</v> true-list.  <v>523</v> is the <v>logical-or</v> of <v>11</v> (which \u000A denotes the integers) with <v>512</v> (which denotes the non-<v>nil</v> \u000A true-lists).</p> \u000A \u000A <p>The ``actual primitive types'' of ACL2 are listed in \u000A <v>*actual-primitive-types*</v>, whose elements are shown below.  Each actual \u000A primitive type denotes a set &mdash; sometimes finite and sometimes not \u000A &mdash; of ACL2 objects and these sets are pairwise disjoint.  For example, \u000A <v>*ts-zero*</v> denotes the set containing 0 while <v>*ts-positive-integer*</v> \u000A denotes the set containing all of the positive integers.</p> \u000A \u000A <code>*TS-ZERO*                  ;;; {0}\u000A*TS-POSITIVE-INTEGER*      ;;; positive integers\u000A*TS-POSITIVE-RATIO*        ;;; positive non-integer rationals\u000A*TS-NEGATIVE-INTEGER*      ;;; negative integers\u000A*TS-NEGATIVE-RATIO*        ;;; negative non-integer rationals\u000A*TS-COMPLEX-RATIONAL*      ;;; complex rationals\u000A*TS-NIL*                   ;;; {nil}\u000A*TS-T*                     ;;; {t}\u000A*TS-NON-T-NON-NIL-SYMBOL*  ;;; symbols other than nil, t\u000A*TS-PROPER-CONS*           ;;; null-terminated non-empty lists\u000A*TS-IMPROPER-CONS*         ;;; conses that are not proper\u000A*TS-STRING*                ;;; strings\u000A*TS-CHARACTER*             ;;; characters</code> \u000A \u000A <p>The actual primitive types were chosen by us to make theorem proving \u000A convenient.  Thus, for example, the actual primitive type <v>*ts-nil*</v> \u000A contains just <v>nil</v> so that we can encode the hypothesis ``<v>x</v> is \u000A <v>nil</v>'' by saying ``<v>x</v> has type <v>*ts-nil*</v>'' and the hypothesis \u000A ``<v>x</v> is non-<v>nil</v>'' by saying ``<v>x</v> has type complement of \u000A <v>*ts-nil*</v>.''  We similarly devote a primitive type to <v>t</v>, <v>*ts-t*</v>, \u000A and to a third type, <v>*ts-non-t-non-nil-symbol*</v>, to contain all the other \u000A ACL2 symbols.</p> \u000A \u000A <p>Let <v>*ts-other*</v> denote the set of all Common Lisp objects other than \u000A those in the actual primitive types.  Thus, <v>*ts-other*</v> includes such \u000A things as floating point numbers and CLTL array objects.  The actual primitive \u000A types together with <v>*ts-other*</v> constitute what we call <v>*universe*</v>. \u000A Note that <v>*universe*</v> is a finite set containing one more object than \u000A there are actual primitive types; that is, here we are using <v>*universe*</v> \u000A to mean the finite set of primitive types, not the infinite set of all objects \u000A in all of those primitive types.  <v>*Universe*</v> is a partitioning of the set \u000A of all Common Lisp objects: every object belongs to exactly one of the sets in \u000A <v>*universe*</v>.</p> \u000A \u000A <p>Abstractly, a ``type-set'' is a subset of <v>*universe*</v>.  To say that a \u000A term, <v>x</v>, ``has type-set <v>ts</v>'' means that under all possible \u000A assignments to the variables in <v>x</v>, the value of <v>x</v> is a member of \u000A some member of <v>ts</v>.  Thus, <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> x y)</v> has type-set \u000A <v>{*ts-proper-cons* *ts-improper-cons*}</v>.  A term can have more than one \u000A type-set.  For example, <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> x y)</v> also has the type-set \u000A <v>{*ts-proper-cons* *ts-improper-cons* *ts-nil*}</v>.  Extraneous types can be \u000A added to a type-set without invalidating the claim that a term ``has'' that \u000A type-set.  Generally we are interested in the smallest type-set a term has, \u000A but because the entire theorem-proving problem for ACL2 can be encoded as a \u000A type-set question, namely, ``Does <v>p</v> have type-set complement of \u000A <v>*ts-nil*</v>?,'' finding the smallest type-set for a term is an undecidable \u000A problem.  When we speak informally of ``the'' type-set we generally mean ``the \u000A type-set found by our heuristics'' or ``the type-set assumed in the current \u000A context.''</p> \u000A \u000A <p>Note that if a type-set, <v>ts</v>, does not contain <v>*ts-other*</v> as an \u000A element then it is just a subset of the actual primitive types.  If it does \u000A contain <v>*ts-other*</v> it can be obtained by subtracting from <v>*universe*</v> \u000A the complement of <v>ts</v>.  Thus, every type-set can be written as a (possibly \u000A complemented) subset of the actual primitive types.</p> \u000A \u000A <p>By assigning a unique bit position to each actual primitive type we can \u000A encode every subset, <v>s</v>, of the actual primitive types by the nonnegative \u000A integer whose ith bit is on precisely if <v>s</v> contains the ith actual \u000A primitive type.  The type-sets written as the complement of <v>s</v> are encoded \u000A as the <v>twos-complement</v> of the encoding of <v>s</v>.  Those type-sets are \u000A thus negative integers.  The bit positions assigned to the actual primitive \u000A types are enumerated from <v>0</v> in the same order as the types are listed in \u000A <v>*actual-primitive-types*</v>.  At the concrete level, a type-set is an \u000A integer between <v>*min-type-set*</v> and <v>*max-type-set*</v>, inclusive.</p> \u000A \u000A <p>For example, <v>*ts-nil*</v> has bit position <v>6</v>.  The type-set \u000A containing just <v>*ts-nil*</v> is thus represented by <v>64</v>.  If a term has \u000A type-set <v>64</v> then the term is always equal to <v>nil</v>.  The type-set \u000A containing everything but <v>*ts-nil*</v> is the twos-complement of <v>64</v>, \u000A which is <v>-65</v>.  If a term has type-set <v>-65</v>, it is never equal to \u000A <v>nil</v>.  By ``always'' and ``never'' we mean under all, or under no, \u000A assignments to the variables, respectively.</p> \u000A \u000A <p>Here is a more complicated example.  Let <v>s</v> be the type-set containing \u000A all of the symbols and the natural numbers.  The relevant actual primitive \u000A types, their bit positions and their encodings are:</p> \u000A \u000A <code>actual primitive type       bit    value\u000A\u000A*ts-zero*                    0       1\u000A*ts-positive-integer*        1       2\u000A*ts-nil*                     6      64\u000A*ts-t*                       7     128\u000A*ts-non-t-non-nil-symbol*    8     256</code> \u000A \u000A <p>Thus, the type-set <v>s</v> is represented by <v>(<see topic=\"COMMON-LISP_____B2\">+</see> 1 2 64 128 256)</v> = \u000A <v>451</v>.  The complement of <v>s</v>, i.e., the set of all objects other than \u000A the natural numbers and the symbols, is <v>-452</v>.</p>"],

 "ACL2____FREE-VARIABLES":[["Rule-classes","Rewrite"],"ACL2 Sources","ACL2","<p>As described elsewhere (see <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see>), ACL2 rules are \u000A treated as implications for which there are zero or more hypotheses <v>hj</v> to \u000A prove.  In particular, rules of class <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> may look like \u000A this:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> h1 ... hn)\u000A         (fn lhs rhs))</code> \u000A \u000A <p>Variables of <v>hi</v> are said to occur <i>free</i> in the above \u000A <v>:rewrite</v> rule if they do not occur in <v>lhs</v> or in any <v>hj</v> with \u000A <v>j&lt;i</v>.  (To be precise, here we are only discussing those variables that \u000A are not in the scope of a <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>/<tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>/<v>lambda</v> that binds \u000A them.)  We also refer to these as the <i>free variables</i> of the rule.  ACL2 \u000A may issue a warning or error when there are free variables in a rule, as \u000A described below.  (Variables of <v>rhs</v> may be considered free if they do not \u000A occur in <v>lhs</v> or in any <v>hj</v>.  But we do not consider those in this \u000A discussion.)</p> \u000A \u000A <p>In general, the <i>free variables</i> of rules are those variables \u000A occurring in their hypotheses (not <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>/<tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>/<v>lambda</v>-bound) \u000A that are not bound when the rule is applied.  For rules of class <v>:</v><tt><see topic=\"ACL2____LINEAR\">linear</see></tt> and <v>:</v><tt><see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see></tt>, variables are bound by a trigger \u000A term.  (See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a discussion of the <v>:trigger-terms</v> \u000A field).  For rules of class <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt>, variables are \u000A bound by the <v>:typed-term</v> field.</p> \u000A \u000A <p>Let us discuss the method for relieving hypotheses of <see topic=\"ACL2____REWRITE\">rewrite</see> rules \u000A with free variables.  Similar considerations apply to <see topic=\"ACL2____LINEAR\">linear</see> and <see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see> rules, and <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules.</p> \u000A \u000A <p>See <see topic=\"ACL2____FREE-VARIABLES-EXAMPLES\">free-variables-examples</see> for more examples of how this all works, \u000A including illustration of how the user can exercise some control over it.  In \u000A particular, see <see topic=\"ACL2____FREE-VARIABLES-EXAMPLES-REWRITE\">free-variables-examples-rewrite</see> for an explanation of \u000A output from the <see topic=\"ACL2____BREAK-REWRITE\">break-rewrite</see> facility in the presence of rewriting \u000A failures involving free variables, as well as an example exploring ``binding \u000A hypotheses'' as described below.</p> \u000A \u000A <p>Note that the <v>:match-free</v> mechanism discussed below does not apply to \u000A <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules.  See <see topic=\"ACL2____FREE-VARIABLES-TYPE-PRESCRIPTION\">free-variables-type-prescription</see> \u000A for a discussion of how to control free-variable matchng for <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules.</p> \u000A \u000A <p>We begin with an example.  Does the proof of the <tt><see topic=\"ACL2____THM\">thm</see></tt> below \u000A succeed?</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFSTUB\">defstub</see> p2 (x y) t)\u000A\u000A(<see topic=\"ACL2____DEFAXIOM\">defaxiom</see> p2-trans\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p2 x y)\u000A                (p2 y z))\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (p2 x z) t))\u000A  :rule-classes ((:rewrite :match-free :all)))\u000A\u000A(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p2 a c)\u000A                   (p2 a b)\u000A                   (p2 c d))\u000A              (p2 a d)))</code> \u000A \u000A <p>Consider what happens when the proof of the <v>thm</v> is attempted.  The \u000A ACL2 rewriter attempts to apply rule <v>p2-trans</v> to the conclusion, <v>(p2 a\u000A d)</v>.  So, it binds variables <v>x</v> and <v>z</v> from the left-hand side of the \u000A conclusion of <v>p2-trans</v> to terms <v>a</v> and <v>d</v>, respectively, and then \u000A attempts to relieve the hypotheses of <v>p2-trans</v>.  The first hypothesis of \u000A <v>p2-trans</v>, <v>(p2 x y)</v>, is considered first.  Variable <v>y</v> is free in \u000A that hypothesis, i.e., it has not yet been bound.  Since <v>x</v> is bound to \u000A <v>a</v>, the rewriter looks through the context for a binding of <v>y</v> such \u000A that <v>(p2 a y)</v> is true, and it so happens that it first finds the term \u000A <v>(p2 a b)</v>, thus binding <v>y</v> to <v>b</v>.  Now it goes on to the next \u000A hypothesis, <v>(p2 y z)</v>.  At this point <v>y</v> and <v>z</v> have already been \u000A bound to <v>b</v> and <v>d</v>; but <v>(p2 b d)</v> cannot be proved.</p> \u000A \u000A <p>So, in order for the proof of the <tt><see topic=\"ACL2____THM\">thm</see></tt> to succeed, the rewriter \u000A needs to backtrack and look for another way to instantiate the first \u000A hypothesis of <v>p2-trans</v>.  Because <v>:match-free :all</v> has been \u000A specified, backtracking does take place.  This time <v>y</v> is bound to <v>c</v>, \u000A and the subsequent instantiated hypothesis becomes <v>(p2 c d)</v>, which is \u000A true.  The application of rule <v>(p2-trans)</v> succeeds and the theorem is \u000A proved.</p> \u000A \u000A <p>If instead <v>:match-free :all</v> had been replaced by <v>:match-free\u000A :once</v> in rule <v>p2-trans</v>, then backtracking would not occur, and the \u000A proof of the <tt><see topic=\"ACL2____THM\">thm</see></tt> would fail.</p> \u000A \u000A <p>Next we describe in detail the steps used by the rewriter in dealing with \u000A free variables.</p> \u000A \u000A <p>ACL2 uses the following sequence of steps to relieve a hypothesis with free \u000A variables, except that steps (1) and (3) are skipped for \u000A <v>:forward-chaining</v> rules and step (3) is skipped for \u000A <v>:type-prescription</v> rules.  First, if the hypothesis is of the form \u000A <v>(<see topic=\"ACL2____FORCE\">force</see> hyp0)</v> or <v>(<see topic=\"ACL2____CASE-SPLIT\">case-split</see> hyp0)</v>, then replace it with \u000A <v>hyp0</v>.</p> \u000A \u000A <blockquote><p>(1) Suppose the hypothesis has the form <v>(equiv var term)</v> \u000A where <v>var</v> is free and no variable of <v>term</v> is free, and either \u000A <v>equiv</v> is <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt> or else <v>equiv</v> is a known <see topic=\"ACL2____EQUIVALENCE\">equivalence</see> \u000A relation and <v>term</v> is a call of <tt><see topic=\"ACL2____DOUBLE-REWRITE\">double-rewrite</see></tt>.  We call this a \u000A ``binding hypothesis.''  Then bind <v>var</v> to the result of rewriting \u000A <v>term</v> in the current context.</p> \u000A \u000A <p>(2) Look for a binding of the free variables of the hypothesis so that the \u000A corresponding instance of the hypothesis is known to be true in the current \u000A context.</p> \u000A \u000A <p>(3) Search all <tt><see topic=\"ACL2____ENABLE\">enable</see></tt>d, hypothesis-free rewrite rules of the form \u000A <v>(equiv lhs rhs)</v>, where <v>lhs</v> has no variables (other than those bound \u000A by <tt><see topic=\"COMMON-LISP____LET\">let</see></tt>, <tt><see topic=\"COMMON-LISP____LET_A2\">let*</see></tt>, or <v>lambda</v>), <v>rhs</v> is known to be true in \u000A the current context, and <v>equiv</v> is typically <v>equal</v> but can be any \u000A equivalence relation appropriate for the current context (see <see topic=\"ACL2____CONGRUENCE\">congruence</see>); then attempt to bind the free variables so that the instantiated \u000A hypothesis is <v>lhs</v>.</p></blockquote> \u000A \u000A <p>If all attempts fail and the original hypothesis is a call of <tt><see topic=\"ACL2____FORCE\">force</see></tt> \u000A or <tt><see topic=\"ACL2____CASE-SPLIT\">case-split</see></tt>, where forcing is enabled (see <see topic=\"ACL2____FORCE\">force</see>) then the \u000A hypothesis is relieved, but in the split-off goals, all free variables are \u000A bound to unusual names that call attention to this odd situation.</p> \u000A \u000A <p>When a <see topic=\"ACL2____REWRITE\">rewrite</see> or <see topic=\"ACL2____LINEAR\">linear</see> rule has free variables in the \u000A hypotheses, the user generally needs to specify whether to consider only the \u000A first instance found in steps (2) and (3) above, or instead to consider them \u000A all.  Below we discuss how to specify these two options as ``<v>:once</v>'' or \u000A ``<v>:all</v>'' (the default), respectively.</p> \u000A \u000A <p>Is it better to specify <v>:once</v> or <v>:all</v>?  We believe that <v>:all</v> \u000A is generally the better choice because of its greater power, provided the user \u000A does not introduce a large number of rules with free variables, which has been \u000A known to slow down the prover due to combinatorial explosion in the search \u000A (Steps (2) and (3) above).</p> \u000A \u000A <p>Either way, it is good practice to put the ``more substantial'' hypotheses \u000A first, so that the most likely bindings of free variables will be found first \u000A (in the case of <v>:all</v>) or found at all (in the case of <v>:once</v>).  For \u000A example, a rewrite rule like</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (p1 x y)\u000A              (p2 x y))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar x) (bar-prime x)))</code> \u000A \u000A <p>may never succeed if <v>p1</v> is nonrecursive and enabled, since we may well \u000A not find calls of <v>p1</v> in the current context.  If however <v>p2</v> is \u000A disabled or recursive, then the above rule may apply if the two hypotheses are \u000A switched.  For in that case, we can hope for a match of <v>(p2 x y)</v> in the \u000A current context that therefore binds <v>x</v> and <v>y</v>; then the rewriter's \u000A full power may be brought to bear to prove <v>(p1 x y)</v> for that <v>x</v> and \u000A <v>y</v>.</p> \u000A \u000A <p>Moreover, the ordering of hypotheses can affect the efficiency of the \u000A rewriter.  For example, the rule</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> y)\u000A              (foo x y))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar x) (bar-prime x)))</code> \u000A \u000A <p>may well be sub-optimal.  Presumably the intention is to rewrite <v>(bar\u000A x)</v> to <v>(bar-prime x)</v> in a context where <v>(foo x y)</v> is explicitly \u000A known to be true for some rational number <v>y</v>.  But <v>y</v> will be bound \u000A first to the first term found in the current context that is known to \u000A represent a rational number.  If the 100th such <v>y</v> that is found is the \u000A first one for which <v>(foo x y)</v> is known to be true, then wasted work will \u000A have been done on behalf of the first 99 such terms <v>y</v> &mdash; unless \u000A <v>:once</v> has been specified, in which case the rule will simply fail after \u000A the first binding of <v>y</v> for which <v>(<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> y)</v> is known to be true. \u000A Thus, a better form of the above rule is almost certainly the following.</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (foo x y)\u000A              (<see topic=\"COMMON-LISP____RATIONALP\">rationalp</see> y))\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (bar x) (bar-prime x)))</code> \u000A \u000A <p><i>Specifying `once' or `all'.</i></p> \u000A \u000A <p>As noted above, the following discussion applies only to <see topic=\"ACL2____REWRITE\">rewrite</see>, \u000A <see topic=\"ACL2____LINEAR\">linear</see>, and <see topic=\"ACL2____FORWARD-CHAINING\">forward-chaining</see> rules.  See <see topic=\"ACL2____FREE-VARIABLES-TYPE-PRESCRIPTION\">free-variables-type-prescription</see> for a discussion of analogous considerations \u000A for <see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see> rules.</p> \u000A \u000A <p>One method for specifying <v>:once</v> or <v>:all</v> for free-variable \u000A matching is to provide the <v>:match-free</v> field of the <v>:rule-classes</v> of \u000A the rule, for example, <v>(:rewrite :match-free :all)</v>.  See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see>.  However, there are global events that can be used to specify \u000A <v>:once</v> or <v>:all</v>; see <see topic=\"ACL2____SET-MATCH-FREE-DEFAULT\">set-match-free-default</see> and see <see topic=\"ACL2____ADD-MATCH-FREE-OVERRIDE\">add-match-free-override</see>.  Here are some examples.</p> \u000A \u000A <code>(<see topic=\"ACL2____SET-MATCH-FREE-DEFAULT\">set-match-free-default</see> :once)    ; future rules without a :match-free field\u000A                                  ; are stored as :match-free :once (but this\u000A                                  ; behavior is local to a book)\u000A(<see topic=\"ACL2____ADD-MATCH-FREE-OVERRIDE\">add-match-free-override</see> :once t) ; existing rules are treated as\u000A                                  ; :match-free :once regardless of their\u000A                                  ; original :match-free fields\u000A(<see topic=\"ACL2____ADD-MATCH-FREE-OVERRIDE\">add-match-free-override</see> :once (:rewrite foo) (:rewrite bar . 2))\u000A                                  ; the two indicated rules are treated as\u000A                                  ; :match-free :once regardless of their\u000A                                  ; original :match-free fields</code> \u000A \u000A <p><i>Some history.</i> Before Version 2.7 the ACL2 rewriter performed Step \u000A (2) above first.  More significantly, it always acted as though <v>:once</v> had \u000A been specified.  That is, if Step (2) did not apply, then the rewriter took \u000A the first binding it found using either Steps (1) or (3), in that order, and \u000A proceeded to relieve the remaining hypotheses without trying any other \u000A bindings of the free variables of that hypothesis.</p>"],

 "ACL2____CLAUSE-PROCESSOR":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <p>We will introduce clause-processor rules by way of the following example. \u000A But note that the clause-processor utility is more general than this example \u000A may suggest; for example, the second argument of <v>evl0</v> in the hypothesis \u000A need not be the same as its second argument in the conclusion.</p> \u000A \u000A <code>; Example (which we'll return to, below):\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> correctness-of-note-fact-clause-processor\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (pseudo-term-listp cl)\u000A                (<see topic=\"ACL2____ALISTP\">alistp</see> a)\u000A                (evl0 (conjoin-clauses\u000A                       (note-fact-clause-processor cl term))\u000A                      a))\u000A           (evl0 (disjoin cl) a))\u000A  :rule-classes :clause-processor)</code> \u000A \u000A <p>We begin this documentation with an introduction, focusing on the example \u000A above, and then conclude with a detailed general discussion of \u000A clause-processor rules.  You might find it most useful simply to look at the \u000A examples in community books directory <v>books/clause-processors/</v>; see file \u000A <v>Readme.lsp</v> in that directory.</p> \u000A \u000A <p>Also see <see topic=\"ACL2____DEFINE-TRUSTED-CLAUSE-PROCESSOR\">define-trusted-clause-processor</see> for documentation of an \u000A analogous utility that does not require the clause-processor to be proved \u000A correct.  But please read the present documentation before reading about that \u000A utility.  Both utilities designate functions as ``clause-processors''.  Such \u000A functions must be executable &mdash; hence not constrained by virtue of being \u000A introduced in the <see topic=\"ACL2____SIGNATURE\">signature</see> of an <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> &mdash; and must \u000A respect <see topic=\"ACL2____STOBJ\">stobj</see> and output arity restrictions.  For example, something \u000A like <v>(<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"ACL2____MV\">mv</see> ...))</v> is illegal; also see <see topic=\"ACL2____SIGNATURE\">signature</see>.</p> \u000A \u000A <h4>INTRODUCTION</h4> \u000A \u000A <p>A <v>:clause-processor</v> rule installs a simplifier at the level of goals, \u000A where a goal is represented as a <i>clause</i>: a list of <see topic=\"ACL2____TERM\">term</see>s that is \u000A implicitly viewed as a disjunction (the application of <tt><see topic=\"COMMON-LISP____OR\">or</see></tt>).  For \u000A example, if ACL2 prints a goal in the form <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> p q) r)</v>, then \u000A the clause might be the one-element list containing the internal \u000A representation of this term &mdash; <v>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____IF\">if</see> p q 'nil) r)</v> &mdash; but \u000A more likely, the corresponding clause is <v>((<see topic=\"COMMON-LISP____NOT\">not</see> p) (<see topic=\"COMMON-LISP____NOT\">not</see> q) r)</v>.  Note that \u000A the members of a clause are <i>translated</i> terms; see <see topic=\"ACL2____TERM\">term</see>.  For \u000A example, they do not contain calls of the macro <v>AND</v>, and constants are \u000A quoted.  The result of running a clause-processor must be a list of legal \u000A clauses; see <see topic=\"ACL2____META\">meta</see> for a discussion of translated terms, and for related \u000A discussion about ``forbidden'' function symbols, <see topic=\"ACL2____SET-SKIP-META-TERMP-CHECKS\">set-skip-meta-termp-checks</see>.</p> \u000A \u000A <p>Note that clause-processor simplifiers are similar to metafunctions, and \u000A similar efficiency considerations apply.  See <see topic=\"ACL2____META\">meta</see>, in particular the \u000A discussion on how to ``make a metafunction maximally efficient.''</p> \u000A \u000A <p>Unlike rules of class <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt>, rules of class \u000A <v>:clause-processor</v> must be applied by explicit <v>:clause-processor</v> \u000A <see topic=\"ACL2____HINTS\">hints</see>; they are not applied automatically (unless by way of computed \u000A hints; see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>).  But <v>:clause-processor</v> rules can be \u000A useful in situations for which it is more convenient to code a simplifier that \u000A manipulates the entire goal clause rather than individual subterms of terms in \u000A the clause.</p> \u000A \u000A <p>We begin with a simple illustrative example: a clause-processor that \u000A assumes an alleged fact (named <v>term</v> in the example) and creates a \u000A separate goal to prove that fact.  We can extend the hypotheses of the current \u000A goal (named <v>cl</v> in the example) with a term by adding the negation of that \u000A term to the clause (disjunctive) representation of that goal.  So the \u000A following returns a list of two clauses: the result of adding <v>term</v> as a \u000A hypothesis to the input clause, as just described, and a second clause \u000A consisting only of that term.  This list of two clauses can be viewed as the \u000A conjunction of the first clause and the second clause (where again, each \u000A clause is viewed as a disjunction).</p> \u000A \u000A <code>(<see topic=\"COMMON-LISP____DEFUN\">defun</see> note-fact-clause-processor (cl term)\u000A  (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"ACL2____XARGS\">xargs</see> :guard t)) ; optional, for better efficiency\u000A  (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____LIST\">list</see> 'not term)\u000A              cl)\u000A        (<see topic=\"COMMON-LISP____LIST\">list</see> term)))</code> \u000A \u000A <p>As with <v>:</v><tt><see topic=\"ACL2____META\">meta</see></tt> rules, we need to introduce a suitable \u000A evaluator; see <see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see> if you want details.  Since we expect to \u000A reason about the function <tt><see topic=\"COMMON-LISP____NOT\">not</see></tt>, because of its role in \u000A <v>note-fact-clause-processor</v> as defined above, we include <v>NOT</v> in the \u000A set of functions known to this evaluator.  We also include <v>IF</v>, as is \u000A often a good idea.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFEVALUATOR\">defevaluator</see> evl0 evl0-list\u000A  ((<see topic=\"COMMON-LISP____NOT\">not</see> x) (<see topic=\"COMMON-LISP____IF\">if</see> x y z)))</code> \u000A \u000A <p>ACL2 can now prove the following theorem automatically.  (This is the \u000A example displayed at the outset of this <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see> topic.)  Of \u000A course, <v>:clause-processor</v> rules about clause-processor functions less \u000A trivial than <v>note-fact-clause-processor</v> may require lemmas to be proved \u000A first!  The function <v>disjoin</v> takes a clause and returns its disjunction \u000A (the result of applying <tt><see topic=\"COMMON-LISP____OR\">or</see></tt> to its members), and <v>conjoin-clauses</v> \u000A applies <v>disjoin</v> to every element of a given list of clauses and then \u000A conjoins (applies <v>AND</v>) to the corresponding list of resulting terms.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> correctness-of-note-fact-clause-processor\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (pseudo-term-listp cl)\u000A                (<see topic=\"ACL2____ALISTP\">alistp</see> a)\u000A                (evl0 (conjoin-clauses\u000A                       (note-fact-clause-processor cl term))\u000A                      a))\u000A           (evl0 (disjoin cl) a))\u000A  :rule-classes :clause-processor)</code> \u000A \u000A <p>Now let us submit a silly but illustrative example theorem to ACL2, to show \u000A how a corresponding <v>:clause-processor</v> hint is applied.  The hint says to \u000A apply the clause-processor function, <v>note-fact-clause-processor</v>, to the \u000A current goal clause and a ``user hint'' as the second argument of that \u000A function, in this case <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> a a)</v>.  Thus, a specific variable, \u000A <v>clause</v>, is always bound to the current goal clause for the evaluation of \u000A the <v>:clause-processor</v> hint, to produce a list of clauses.  Since two \u000A subgoals are created below, we know that this list contained two clauses. \u000A Indeed, these are the clauses returned when <v>note-fact-clause-processor</v> is \u000A applied to two arguments: the current clause, which is the one-element list \u000A <v>((<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> x y)) x))</v>, and the user hint, <v>(<see topic=\"COMMON-LISP____EQUAL\">equal</see> a a)</v>.</p> \u000A \u000A <code>ACL2 !&gt;(<see topic=\"ACL2____THM\">thm</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> x y))\u000A                   x)\u000A            :hints\u000A            ((&quot;Goal&quot;\u000A              :clause-processor\u000A              (note-fact-clause-processor clause '(<see topic=\"COMMON-LISP____EQUAL\">equal</see> a a)))))\u000A\u000A[Note:  A hint was supplied for our processing of the goal above.\u000AThanks!]\u000A\u000AWe now apply the verified :CLAUSE-PROCESSOR function NOTE-FACT-CLAUSE-\u000APROCESSOR to produce two new subgoals.\u000A\u000ASubgoal 2\u000A(<see topic=\"ACL2____IMPLIES\">IMPLIES</see> (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> A A)\u000A         (<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> (<see topic=\"COMMON-LISP____CAR\">CAR</see> (<see topic=\"COMMON-LISP____CONS\">CONS</see> X Y)) X)).\u000A\u000ABut we reduce the conjecture to T, by the :executable-counterpart of\u000AIF and the simple :rewrite rule CAR-CONS.\u000A\u000ASubgoal 1\u000A(<see topic=\"COMMON-LISP____EQUAL\">EQUAL</see> A A).\u000A\u000ABut we reduce the conjecture to T, by primitive type reasoning.\u000A\u000AQ.E.D.\u000A\u000ASummary\u000AForm:  ( THM ...)\u000ARules: ((:EXECUTABLE-COUNTERPART IF)\u000A        (:EXECUTABLE-COUNTERPART NOT)\u000A        (:FAKE-RUNE-FOR-TYPE-SET NIL)\u000A        (:REWRITE CAR-CONS))\u000AWarnings:  None\u000ATime:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)\u000A\u000AProof succeeded.\u000AACL2 !&gt;</code> \u000A \u000A <p>That concludes our introduction to clause-processor rules and hints.  We \u000A turn now to detailed documentation.</p> \u000A \u000A <h4>DETAILED DOCUMENTATION</h4> \u000A \u000A <p>The <see topic=\"ACL2____SIGNATURE\">signature</see> of a clause-processor function, <v>CL-PROC</v>, must \u000A have one of the following forms.  Here, each <v>st_i</v> is a <see topic=\"ACL2____STOBJ\">stobj</see> \u000A (possibly <v>state</v>) while the other parameters and results are not stobjs \u000A (see <see topic=\"ACL2____STOBJ\">stobj</see>).  Note that there need not be input stobjs in [3] &mdash; \u000A i.e., <v>k</v> can be 0 &mdash; and even if there are, there need not be output \u000A stobjs.</p> \u000A \u000A <code>[1]  ((CL-PROC cl) =&gt; cl-list)\u000A\u000A[2]  ((CL-PROC cl hint) =&gt; cl-list)\u000A\u000A[3]  ((CL-PROC cl hint st_1 ... st_k) =&gt; (<see topic=\"ACL2____MV\">mv</see> erp cl-list st_i1 ... st_in))</code> \u000A \u000A <p>In [3], we think of the first component of the result as an error flag. \u000A Indeed, a proof will instantly abort if that error flag is not <v>nil</v>.</p> \u000A \u000A <p>We next discuss the legal forms of <v>:clause-processor</v> rules, followed \u000A below by a discussion of <v>:clause-processor</v> <see topic=\"ACL2____HINTS\">hints</see>.  In the \u000A discussion below, we use lower-case names to represent specific symbols, for \u000A example <v>implies</v>, and we use upper-case names to represent more arbitrary \u000A pieces of syntax (which we will describe), for example, <v>CL</v>.</p> \u000A \u000A <p>If a <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> specification includes \u000A <v>:clause-processor</v>, then the corresponding term must have the following \u000A form.  (Additional ``meta-extract'' hypotheses, not shown or discussed below, \u000A may be included as desired in order to use facts from the logical <tt><see topic=\"ACL2____WORLD\">world</see></tt> to help prove the rule; see <see topic=\"ACL2____META-EXTRACT\">meta-extract</see> for explanation of this \u000A advanced feature.)</p> \u000A \u000A <code>; General Form (omitting possible meta-extract hypotheses)\u000A(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (pseudo-term-listp CL)\u000A              (<see topic=\"ACL2____ALISTP\">alistp</see> A)\u000A              (EVL (conjoin-clauses &lt;CL-LIST&gt;)\u000A                    B))\u000A         (EVL (disjoin CL) A))</code> \u000A \u000A <p>Here <v>EVL</v> is a known evaluator; <v>CL</v> and <v>A</v> are distinct \u000A non-stobj variables; and <v>&lt;CL-LIST&gt;</v> is an expression representing the \u000A clauses returned by the clause-processor function <v>CL-PROC</v>, whose form \u000A depends on the <see topic=\"ACL2____SIGNATURE\">signature</see> of that function, as follows.  Typically \u000A <v>B</v> is <v>A</v>, but it can be any term (useful when generalization is \u000A occurring; see the example ``Test generalizing alist'' in community book \u000A <v>books/clause-processors/basic-examples.lisp</v>).  For cases [1] and [2] \u000A above, <v>&lt;CL-LIST&gt;</v> is of the form <v>(CL-PROC CL)</v> or <v>(CL-PROC CL\u000A HINT)</v>, respectively, where in the latter case <v>HINT</v> is a non-stobj \u000A variable distinct from the variables <v>CL</v> and <v>A</v>.  For case [3], \u000A <v>&lt;CL-LIST&gt;</v> is of the form</p> \u000A \u000A <code>(clauses-result (CL-PROC CL HINT st_1 ... st_k))</code> \u000A \u000A <p>where the <v>st_i</v> are the specific stobj names mentioned in [3]. \u000A Logically, <v>clauses-result</v> returns the <tt><see topic=\"COMMON-LISP____CADR\">cadr</see></tt> if the <tt><see topic=\"COMMON-LISP____CAR\">car</see></tt> is \u000A <v>NIL</v>, and otherwise (for the error case) returns a list containing the \u000A empty (false) clause.  So in the non-error case, <v>clauses-result</v> picks out \u000A the second result, denoted <v>cl-list</v> in [3] above, and in the error case \u000A the implication above trivially holds.</p> \u000A \u000A <p>In the above theorem, we are asked to prove <v>(EVL (disjoin CL) A)</v> \u000A assuming that the conjunction of all clauses produced by the clause processor \u000A evaluates to a non-<v>nil</v> value under some alist <v>B</v>.  In fact, we can \u000A choose <v>B</v> so as to allow us to assume evaluations of the generated clauses \u000A over many different alists.  This technique is discussed in the community book \u000A <v>books/clause-processors/multi-env-trick.lisp</v>, which introduces some \u000A macros that may be helpful in accomplishing proofs of this type.</p> \u000A \u000A <p>The clause-processor function, <v>CL</v>, must have a guard that ACL2 can \u000A trivially prove from the hypotheses that the first argument of <v>CL</v> is \u000A known to be a <v>pseudo-term-listp</v> and any <see topic=\"ACL2____STOBJ\">stobj</see> arguments are \u000A assumed to satisfy their stobj predicates.</p> \u000A \u000A <p>Next we specify the legal forms for <v>:clause-processor</v> <see topic=\"ACL2____HINTS\">hints</see>. \u000A These depend on the signature as described in [1] through [3] above.  Below, \u000A as above, <v>CL-PROC</v> is the clause-processor function, and references to \u000A ``<v>clause</v>'' refer to that exact variable (not, for example, to <v>cl</v>). \u000A In each of the three cases, the forms shown for that case are equivalent; in \u000A particular, the <v>:function</v> syntax is simply a convenience for the final \u000A form in each case.</p> \u000A \u000A <p>Signature [1], <v>((cl-proc cl) =&gt; cl-list)</v>:</p> \u000A \u000A <code>:clause-processor CL-PROC\u000A:clause-processor (:function CL-PROC)\u000A:clause-processor (CL-PROC clause)</code> \u000A \u000A <p>or any term macroexpanding to <v>(CL-PROC clause)</v>.</p> \u000A \u000A <p>Signature [2], ((cl-proc cl hint) =&gt; cl-list):</p> \u000A \u000A <code>:clause-processor (:function CL-PROC :hint HINT)\u000A:clause-processor (CL-PROC clause HINT)</code> \u000A \u000A <p>or any term macroexpanding to <v>(CL-PROC clause HINT)</v>, where <v>HINT</v> \u000A is any term with at most <v>CLAUSE</v> free.</p> \u000A \u000A <p>Signature [3], ((CL-PROC cl hint ...) =&gt; (mv erp cl-list ...))</p> \u000A \u000A <code>:clause-processor (:function CL-PROC :hint HINT)\u000A:clause-processor (CL-PROC clause HINT st_1 ... st_k)</code> \u000A \u000A <p>or any term macroexpanding to <v>(CL-PROC clause HINT st_1 ... st_k)</v>, \u000A where <v>HINT</v> is any term with at most <v>CLAUSE</v> free.</p> \u000A \u000A <p>A <v>:clause-processor</v> hint causes the proof to abort if the result \u000A returned by evaluating the suitable <v>CL-PROC</v> call, as above, is not a list \u000A of clauses, i.e., a list of (translated) <see topic=\"ACL2____TERM\">term</see> lists.  The proof also \u000A aborts if in case [3] the first (<v>erp</v>) value returned is not <v>nil</v>, in \u000A which case <v>erp</v> is used for printing an error message as follows: if it is \u000A a string, then that string is printed; but if it is a non-empty true list \u000A whose first element is a string, then it is printed as though by <v>(<see topic=\"ACL2____FMT\">fmt</see> ~@0\u000A (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CONS\">cons</see> #\\0 erp)) ...)</v> (see <see topic=\"ACL2____FMT\">fmt</see>).  Otherwise, a non-<v>nil</v> \u000A <v>erp</v> value causes a generic error message to be printed.</p> \u000A \u000A <p>If there is no error as above, but the <v>CL-PROC</v> call returns clause \u000A list whose single element is equal to the input clause, then the hint is \u000A ignored since we are left with the goal with which we started.  In that case, \u000A the other prover processes are then applied as usual.</p> \u000A \u000A <p>You can see all current <v>:clause-processor</v> rules by issuing the \u000A following command: <v>(print-clause-processor-rules)</v>.</p> \u000A \u000A <p>The following paper discusses ACL2 clause-processors at a high level \u000A suitable for a non-ACL2 audience:</p> \u000A \u000A <blockquote> \u000A \u000A <p>M. Kaufmann, J S. Moore, S. Ray, and E. Reeber, ``Integrating External \u000A Deduction Tools with ACL2.''  <i>Journal of Applied Logic</i> (Special Issue: \u000A Empirically Successful Computerized Reasoning), Volume 7, Issue 1, March 2009, \u000A pp. 3--25.  Also published online (DOI <v>10.1016/j.jal.2007.07.002</v>). \u000A Preliminary version in: Proceedings of the 6th International Workshop on the \u000A Implementation of Logics (IWIL 2006) (C. Benzmueller, B. Fischer, and \u000A G. Sutcliffe, editors), <a href='http://ceur-ws.org/Vol-212/'>CEUR Workshop \u000A Proceedings Vol. 212</a>, Phnom Penh, Cambodia, pp. 7-26, November \u000A 2006.</p></blockquote> \u000A \u000A "],

 "ACL2____OVERRIDE-HINTS":[["Hints"],"ACL2 Sources","ACL2","<p>This is an advanced feature, originally implemented to help system \u000A designers to create ``modes'' that control the way hints are supplied to the \u000A theorem prover.  Please see <see topic=\"ACL2____DEFAULT-HINTS\">default-hints</see> for the much more usual way \u000A to install hints that may be applied by default.</p> \u000A \u000A <code>Examples:\u000AACL2 !&gt;(<see topic=\"ACL2____OVERRIDE-HINTS\">override-hints</see> (w state))\u000A((computed-hint-1 clause keyword-alist processor)\u000A (computed-hint-2 clause keyword-alist stable-under-simplificationp))</code> \u000A \u000A <p><v>Override-hints</v> returns a list of computed hints (see <see topic=\"ACL2____COMPUTED-HINTS\">computed-hints</see>) which, unlike other computed hints, may mention the variable \u000A <v>KEYWORD-ALIST</v>.</p> \u000A \u000A <p>Before reading further, please see <see topic=\"ACL2____HINTS-AND-THE-WATERFALL\">hints-and-the-waterfall</see> to review \u000A the basics of how <see topic=\"ACL2____HINTS\">hints</see> are applied during a proof.  In particular, we \u000A assume familiarity with the notion of selecting a hint to be applied to the \u000A current goal.  If there are override-hints, that hint selection is tentative, \u000A because if it reduced to <v>nil</v> after the application of override-hints, \u000A then that hint will be skipped and the attempt will continue for selecting an \u000A applicable hint.  (Craft your override-hints so that <v>:no-op t</v> is returned \u000A in such cases instead of <v>nil</v>, if you don't want the hint to be skipped.) \u000A But we must explain what is meant by ``the application of override-hints'', \u000A and we do that now.</p> \u000A \u000A <p>Suppose that there are override-hints when a hint is selected for the \u000A current goal.  That selected hint is a keyword-alist, which is an alternating \u000A list of hint keywords and their values, whose source is either an explicit \u000A hint <v>(goal-name :key1 val1 ... :keyn valn)</v> where the <v>:keyi</v> are \u000A allowed to be custom hint keywords (which are expanded away; see <see topic=\"ACL2____CUSTOM-KEYWORD-HINTS\">custom-keyword-hints</see>), or else is the non-<v>nil</v> keyword-alist produced by \u000A evaluating a computed hint.  Then the override-hints are applied to that \u000A keyword-alist as follows, one at a time, in order of their occurrence in the \u000A list of override-hints (as determined by the use of <tt><see topic=\"ACL2____SET-OVERRIDE-HINTS\">set-override-hints</see></tt> \u000A and <tt><see topic=\"ACL2____ADD-OVERRIDE-HINTS\">add-override-hints</see></tt>).  The first override-hint is evaluated, in the \u000A usual manner of evaluating computed hints but with the variable \u000A <v>KEYWORD-ALIST</v> bound to the above keyword-alist.  That evaluation produces \u000A a result that should also be a keyword-alist, or else an error occurs.  Any \u000A custom keyword hints are then eliminated from that keyword-alist.  The \u000A resulting keyword-alist must not contain the <v>:ERROR</v> hint keyword and must \u000A not start with the <v>:COMPUTED-HINT-REPLACEMENT</v> keyword; otherwise an error \u000A occurs.  With <v>KEYWORD-ALIST</v> bound to this result, the second \u000A override-hint is similarly evaluated.  This process continues, and the \u000A keyword-alist returned by the final override-hint is the one used when \u000A processing the goal at hand.  Except: If that keyword-alist is <v>nil</v>, then \u000A the next hint among the pending hints is tentatively selected and the process \u000A repeats, applying each override hint to that new tentative selection.  Of \u000A course we might obtain <v>nil</v> again, in which case we tentatively select the \u000A next pending hint; and so on.</p> \u000A \u000A <p>If finally no hint is selected for the current goal, then \u000A <v>KEYWORD-ALIST</v> is bound to <v>nil</v> and the override-hints are applied as \u000A described above.  But note that this final step is skipped if hint selection \u000A is being performed because <v>stable-under-simplificationp</v> has just become \u000A true, rather than at the top of the waterfall.  (Otherwise the override-hints \u000A could easily keep firing uselessly yet putting us back at the top of the \u000A waterfall, with no change to the given goal, resulting in an infinite \u000A loop.)</p> \u000A \u000A <p>As mentioned above, the <v>:COMPUTED-HINT-REPLACEMENT</v> keyword is illegal \u000A for the value of an override-hint.  But a selected hint may be a computed hint \u000A that evaluates to a keyword-alist beginning with prefix \u000A <v>:COMPUTED-HINT-REPLACEMENT val</v>.  What value does ACL2 return for such a \u000A computed hint in the presence of override-hints?  First, this prefix is \u000A stripped off before passing the resulting keyword-alist to the override-hints \u000A as described above.  If the result of applying override-hints to that \u000A keyword-alist is not <v>nil</v>, then the prefix is put back on the front of \u000A that resulting keyword-alist after doing internal processing of the hint, \u000A including expansion of any custom keyword hints.  Otherwise, the application \u000A of override-hints to the computed hint is <v>nil</v>, so this hint is not \u000A selected after all.</p> \u000A \u000A <p><b>WARNING</b>: Unlike ordinary computed hints, a value of <v>nil</v> for an \u000A override-hint is not ignored.  That is: When an ordinary computed hint \u000A evaluates to <v>nil</v>, it is deemed not to apply, and the next available hint \u000A is consulted.  But when an override-hint is evaluated, the result is always \u000A supplied for the next binding of the variable <v>KEYWORD-ALIST</v>, even if that \u000A result is <v>nil</v>.  If you want an override-hint to be a no-op, return as the \u000A expression the variable <v>KEYWORD-ALIST</v> rather than an expression that \u000A evaluates to <v>nil</v>.</p> \u000A \u000A <p>This feature can be used in order to implement a form of additive hints. \u000A Suppose for example that you want a hint that turns off generalization.  A \u000A simple but inadequate solution is:</p> \u000A \u000A <code>(<see topic=\"ACL2____ADD-DEFAULT-HINTS\">add-default-hints</see> '((<see topic=\"COMMON-LISP____QUOTE\">quote</see> (:do-not '(<see topic=\"ACL2____GENERALIZE\">generalize</see>)))))</code> \u000A \u000A <p>The problem is that if there is any explicit hint supplied for a given \u000A goal, then it will be the one selected, and the above will be ignored.  But \u000A suppose that the explicit hint supplied is of the form <v>(&quot;Subgoal x.y&quot;\u000A :do-not '(fertilize))</v>.  What we would really want in this case is to \u000A generate the hint for the indicated subgoal that binds <v>:do-not</v> to a list \u000A indicating that both fertilization _and_ generalization are disabled for that \u000A goal.  A solution is to merge, for example as follows.  (The use of <tt><see topic=\"ACL2____PROG2_42\">prog2$</see></tt> and <tt><see topic=\"ACL2____CW\">cw</see></tt> is of course optional, included here to provide debug \u000A printing.)</p> \u000A \u000A <code>(<see topic=\"ACL2____ADD-OVERRIDE-HINTS\">add-override-hints</see>\u000A '((<see topic=\"COMMON-LISP____LET_A2\">let*</see> ((tmp (<see topic=\"ACL2____ASSOC-KEYWORD\">assoc-keyword</see> :do-not KEYWORD-ALIST))\u000A          (new-keyword-alist\u000A           (<see topic=\"COMMON-LISP____COND\">cond</see> (tmp (<see topic=\"COMMON-LISP____LIST_A2\">list*</see> :do-not\u000A                             `(<see topic=\"COMMON-LISP____CONS\">cons</see> 'generalize ,(<see topic=\"COMMON-LISP____CADR\">cadr</see> tmp))\u000A                             (remove-keyword :do-not KEYWORD-ALIST)))\u000A                 (t (<see topic=\"COMMON-LISP____LIST_A2\">list*</see> :do-not ''(<see topic=\"ACL2____GENERALIZE\">generalize</see>) KEYWORD-ALIST)))))\u000A     (<see topic=\"ACL2____PROG2_42\">prog2$</see> (<see topic=\"ACL2____CW\">cw</see> &quot;New: ~x0~|&quot; new-keyword-alist)\u000A             new-keyword-alist))))</code> \u000A \u000A <p>REMARKS</p> \u000A \u000A <p>(1) The utilities <tt><see topic=\"ACL2____ADD-OVERRIDE-HINTS\">add-override-hints</see></tt>, <tt><see topic=\"ACL2____ADD-OVERRIDE-HINTS_12\">add-override-hints!</see></tt>, \u000A <tt><see topic=\"ACL2____SET-OVERRIDE-HINTS\">set-override-hints</see></tt>, <tt><see topic=\"ACL2____SET-OVERRIDE-HINTS_12\">set-override-hints!</see></tt>, <tt><see topic=\"ACL2____REMOVE-OVERRIDE-HINTS\">remove-override-hints</see></tt>, and <tt><see topic=\"ACL2____REMOVE-OVERRIDE-HINTS_12\">remove-override-hints!</see></tt> are also available, \u000A in complete analogy to their default-hints versions.</p> \u000A \u000A <p>(2) The community book <v>hints/basic-tests.lisp</v> illustrates the use of \u000A override-hints and illuminates a number of corner cases; search in that file \u000A for ``Test override-hints.''</p> \u000A \u000A <p>(3) The community book <v>hints/merge-hint.lisp</v> provides support for \u000A merging hints that might be useful for writers of override-hint expressions \u000A (see the examples at the end of that file).</p> \u000A \u000A <p>(4) Override-hints are used in the processing of <v>:BACKTRACK</v> hints (see \u000A <see topic=\"ACL2____HINTS\">hints</see>).</p>"],

 "ACL2____LD-SKIP-PROOFSP":[["Ld"],"ACL2 Sources","ACL2","<code>Examples:\u000AACL2 !&gt;(<see topic=\"ACL2____SET-LD-SKIP-PROOFSP\">set-ld-skip-proofsp</see> t state)\u000A T\u000AACL2 !s&gt;(<see topic=\"ACL2____SET-LD-SKIP-PROOFSP\">set-ld-skip-proofsp</see> nil state)\u000A NIL\u000AACL2 !&gt;(<see topic=\"ACL2____SET-LD-SKIP-PROOFSP\">set-ld-skip-proofsp</see> 'include-book state)\u000A INCLUDE-BOOK\u000AACL2 !s&gt;</code> \u000A \u000A <p>A global variable in the ACL2 <tt><see topic=\"ACL2____STATE\">state</see></tt>, called <v>'ld-skip-proofsp</v>, \u000A determines the thoroughness with which ACL2 processes your <see topic=\"ACL2____COMMAND\">command</see>s. \u000A This variable may take on one of three values: <v>t</v>, <v>nil</v> or \u000A <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.  When <v>ld-skip-proofsp</v> is non-<v>nil</v>, the \u000A system assumes that which ought to be proved and is thus unsound.  The form \u000A <v>(<see topic=\"ACL2____SET-LD-SKIP-PROOFSP\">set-ld-skip-proofsp</see> flg state)</v> is the general-purpose way of setting \u000A <v>ld-skip-proofsp</v>.  This global variable is an ``<tt><see topic=\"ACL2____LD\">ld</see></tt> special,'' \u000A which is to say, you may call <tt><see topic=\"ACL2____LD\">ld</see></tt> in such a way as to ``bind'' this \u000A variable for the dynamic extent of the <tt><see topic=\"ACL2____LD\">ld</see></tt>.</p> \u000A \u000A <p>When <v>ld-skip-proofsp</v> is non-<v>nil</v>, the default <see topic=\"ACL2____PROMPT\">prompt</see> \u000A displays the character <v>s</v>.  Thus, the <see topic=\"ACL2____PROMPT\">prompt</see></p> \u000A \u000A <code>ACL2 !s&gt;</code> \u000A \u000A <p>means that the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> is <v>:</v><tt><see topic=\"ACL2____LOGIC\">logic</see></tt> (otherwise \u000A the character <v>p</v>, for <v>:</v><tt><see topic=\"ACL2____PROGRAM\">program</see></tt>, would also be printed; see \u000A <see topic=\"ACL2____DEFAULT-PRINT-PROMPT\">default-print-prompt</see>) but ``proofs are being skipped.''</p> \u000A \u000A <p>Observe that there are two legal non-<v>nil</v> values, <v>t</v> and \u000A <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.  When <v>ld-skip-proofsp</v> is <v>t</v>, ACL2 skips \u000A all proof obligations but otherwise performs all other required analysis of \u000A input <see topic=\"ACL2____EVENTS\">events</see>.  When <v>ld-skip-proofsp</v> is <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, \u000A ACL2 skips not only proof obligations but all analysis except that required to \u000A compute the effect of successfully executed <see topic=\"ACL2____EVENTS\">events</see>.  To explain the \u000A distinction, let us consider one particular event, say a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt>.  Very \u000A roughly speaking, a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> event normally involves a check of the \u000A syntactic well-formedness of the submitted definition, the generation and \u000A proof of the termination conditions, and the computation and storage of \u000A various rules such as a <v>:</v><tt><see topic=\"ACL2____DEFINITION\">definition</see></tt> rule and some <v>:</v><tt><see topic=\"ACL2____TYPE-PRESCRIPTION\">type-prescription</see></tt> rules.  By ``normally'' above we mean when \u000A <v>ld-skip-proofsp</v> is <v>nil</v>.  How does a <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> behave when \u000A <v>ld-skip-proofsp</v> is non-<v>nil</v>?</p> \u000A \u000A <p>If <v>ld-skip-proofsp</v> is <v>t</v>, then <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> performs the \u000A syntactic well-formedness checks and computes and stores the various rules, \u000A but it does not actually carry out the termination proofs.  If \u000A <v>ld-skip-proofsp</v> is <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> does not do \u000A the syntactic well-formedness check nor does it carry out the termination \u000A proof.  Instead, it merely computes and stores the rules under the assumption \u000A that the checks and proofs would all succeed.  Observe that a setting of \u000A <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> is ``stronger'' than a setting of <v>t</v> in the \u000A sense that <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> causes <tt><see topic=\"COMMON-LISP____DEFUN\">defun</see></tt> to assume even more \u000A about the admissibility of the event than <v>t</v> does.</p> \u000A \u000A <p>As one might infer from the choice of name, the <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> event \u000A sets <v>ld-skip-proofsp</v> to <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> when processing the \u000A <see topic=\"ACL2____EVENTS\">events</see> in a book being loaded.  Thus, <tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> does the \u000A miminal work necessary to carry out the effects of every event in the book. \u000A The syntactic checks and proof obligations were, presumably, successfully \u000A carried out when the book was certified.</p> \u000A \u000A <p>A non-<v>nil</v> value for <v>ld-skip-proofsp</v> also affects the system's \u000A output messages.  Event summaries (the paragraphs that begin ``Summary'' and \u000A display the event forms, rules used, etc.) are not printed when \u000A <v>ld-skip-proofsp</v> is non-<v>nil</v>.  Warnings and observations are printed \u000A when <v>ld-skip-proofsp</v> is <v>t</v> but are not printed when it is \u000A <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.</p> \u000A \u000A <p>Intuitively, <v>ld-skip-proofsp</v> <v>t</v> means skip just the proofs and \u000A otherwise do all the work normally required for an event; while \u000A <v>ld-skip-proofsp</v> <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> is ``stronger'' and means do \u000A as little as possible to process <see topic=\"ACL2____EVENTS\">events</see>.  In accordance with this \u000A intuition, <tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> are processed when <v>ld-skip-proofsp</v> \u000A is <v>t</v> but are skipped when <v>ld-skip-proofsp</v> is <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>.</p> \u000A \u000A <p>The ACL2 system itself uses only two settings, <v>nil</v> and <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt>, the latter being used only when executing the <see topic=\"ACL2____EVENTS\">events</see> \u000A inside of a book being included.  The <v>ld-skip-proofsp</v> setting of <v>t</v> \u000A is provided as a convenience to the user.  For example, suppose one has a file \u000A of <see topic=\"ACL2____EVENTS\">events</see>.  By loading it with <tt><see topic=\"ACL2____LD\">ld</see></tt> with <v>ld-skip-proofsp</v> set \u000A to <v>t</v>, the <see topic=\"ACL2____EVENTS\">events</see> can all be checked for syntactic correctness and \u000A assumed without proof.  This is a convenient way to recover a state lost by a \u000A system crash or to experiment with a modification of an <see topic=\"ACL2____EVENTS\">events</see> \u000A file.</p> \u000A \u000A <p>The foregoing discussion is actually based on a lie.  <v>ld-skip-proofsp</v> \u000A is allowed two other values, <v>'initialize-acl2</v> and \u000A <v>'include-book-with-locals</v>.  The first causes behavior similar to <v>t</v> \u000A but skips <tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see> and avoids some error checks that would \u000A otherwise prevent ACL2 from properly booting.  The second is identical to \u000A <v>'</v><tt><see topic=\"ACL2____INCLUDE-BOOK\">include-book</see></tt> but also executes <tt><see topic=\"ACL2____LOCAL\">local</see></tt> <see topic=\"ACL2____EVENTS\">events</see>. \u000A These additional values are not intended for use by the user, but no barriers \u000A to their use have been erected.</p> \u000A \u000A <p>We close by reminding the user that ACL2 is potentially unsound if \u000A <v>ld-skip-proofsp</v> is ever set by the user.  We provide access to it simply \u000A to allow experimentation and rapid reconstruction of lost or modified logical \u000A <see topic=\"ACL2____WORLD\">world</see>s.</p>"],

 "ACL2____EVENTS":[["ACL2"],"ACL2 Sources","ACL2","<p>Any extension of the syntax of ACL2 (i.e., the definition of a new \u000A constant or macro), the axioms (i.e., the definition of a function), or the \u000A rule database (i.e., the proof of a theorem), constitutes a logical ``event.'' \u000A Events change the ACL2 logical world (see <see topic=\"ACL2____WORLD\">world</see>).  Indeed, the only way \u000A to change the ACL2 <see topic=\"ACL2____WORLD\">world</see> is via the successful evaluation of an event \u000A function.  Every time the <see topic=\"ACL2____WORLD\">world</see> is changed by an event, a landmark is \u000A left on the <see topic=\"ACL2____WORLD\">world</see> and it is thus possible to identify the <see topic=\"ACL2____WORLD\">world</see> \u000A ``as of'' the evaluation of a given event.  An event may introduce new logical \u000A names.  Some events introduce no new names (e.g., <tt><see topic=\"ACL2____VERIFY-GUARDS\">verify-guards</see></tt>), some \u000A introduce exactly one (e.g., <tt><see topic=\"COMMON-LISP____DEFMACRO\">defmacro</see></tt> and <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt>), and some \u000A may introduce many (e.g., <tt><see topic=\"ACL2____ENCAPSULATE\">encapsulate</see></tt> ).</p> \u000A \u000A <p>ACL2 typically completes processing of an event by printing a summary. \u000A Unless proofs are skipped (see <see topic=\"ACL2____LD-SKIP-PROOFSP\">ld-skip-proofsp</see>) or summary output is \u000A inhibited (see <see topic=\"ACL2____SET-INHIBIT-OUTPUT-LST\">set-inhibit-output-lst</see>), information about the proof \u000A attempt (if any) is printed that includes a list of rules used, a summary of \u000A warnings, and the number of ``prover steps'' (if any; see <see topic=\"ACL2____WITH-PROVER-STEP-LIMIT\">with-prover-step-limit</see>).  A breakdown of the time used is also printed, which \u000A by default is runtime (cpu time), but can be changed to realtime (wall clock \u000A time); see <see topic=\"ACL2____GET-INTERNAL-TIME\">get-internal-time</see>.</p> \u000A \u000A <p>See <see topic=\"ACL2____EMBEDDED-EVENT-FORM\">embedded-event-form</see> for a discussion of events permitted in \u000A <see topic=\"ACL2____BOOKS\">books</see>.</p>"],

 "ACL2____EQUIVALENCE":[["Rule-classes"],"ACL2 Sources","ACL2","<p>See <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see> for a general discussion of rule classes, \u000A including how they are used to build rules from formulas and a discussion of \u000A the various keywords in a rule class description.</p> \u000A \u000A <code>Example:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> r-equal-is-an-equivalence ; assumes that r-equal has been defined\u000A  (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____BOOLEANP\">booleanp</see> (r-equal x y))\u000A       (r-equal x x)\u000A       (<see topic=\"ACL2____IMPLIES\">implies</see> (r-equal x y) (r-equal y x))\u000A       (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (r-equal x y)\u000A                     (r-equal y z))\u000A                (r-equal x z)))\u000A  :rule-classes :equivalence)</code> \u000A \u000A <p>Also see <see topic=\"ACL2____DEFEQUIV\">defequiv</see>.</p> \u000A \u000A <code>General Form:\u000A(<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"ACL2____BOOLEANP\">booleanp</see> (equiv x y))\u000A     (equiv x x)\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (equiv x y) (equiv y x))\u000A     (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (equiv x y)\u000A                   (equiv y z))\u000A              (equiv x z)))</code> \u000A \u000A <p>except that the order of the conjuncts and terms and the choice of variable \u000A symbols is unimportant.  The effect of such a rule is to identify <v>equiv</v> \u000A as an equivalence relation.  Note that only Boolean 2-place function symbols \u000A can be treated as equivalence relations.  See <see topic=\"ACL2____CONGRUENCE\">congruence</see> and see <see topic=\"ACL2____REFINEMENT\">refinement</see> for closely related concepts.</p> \u000A \u000A <p>The macro form <v>(<see topic=\"ACL2____DEFEQUIV\">defequiv</see> equiv)</v> is an abbreviation for a <tt><see topic=\"ACL2____DEFTHM\">defthm</see></tt> of rule-class <v>:equivalence</v> that establishes that <v>equiv</v> is an \u000A equivalence relation.  It generates the formula shown above.  See <see topic=\"ACL2____DEFEQUIV\">defequiv</see>.</p> \u000A \u000A <p>When <v>equiv</v> is marked as an equivalence relation, its reflexivity, \u000A symmetry, and transitivity are built into the system in a deeper way than via \u000A <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules.  More importantly, after <v>equiv</v> has been \u000A shown to be an equivalence relation, lemmas about <v>equiv</v>, e.g.,</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> hyps (equiv lhs rhs)),</code> \u000A \u000A <p>when stored as <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules, cause the system to rewrite \u000A certain occurrences of (instances of) <v>lhs</v> to (instances of) <v>rhs</v>. \u000A Roughly speaking, an occurrence of <v>lhs</v> in the <v>kth</v> argument of some \u000A <v>fn</v>-expression, <v>(fn ... lhs' ...)</v>, can be rewritten to produce <v>(fn\u000A ...  rhs' ...)</v>, provided the system ``knows'' that the value of <v>fn</v> is \u000A unaffected by <v>equiv</v>-substitution in the <v>kth</v> argument.  Such \u000A knowledge is communicated to the system via ``congruence lemmas.''</p> \u000A \u000A <p>For example, suppose that <v>r-equal</v> is known to be an equivalence \u000A relation.  The <v>:</v><tt><see topic=\"ACL2____CONGRUENCE\">congruence</see></tt> lemma</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (r-equal s1 s2)\u000A         (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (fn s1 n) (fn s2 n)))</code> \u000A \u000A <p>informs the rewriter that, while rewriting the first argument of \u000A <v>fn</v>-expressions, it is permitted to use <v>r-equal</v> rewrite-rules.  See \u000A <see topic=\"ACL2____CONGRUENCE\">congruence</see> for details about <v>:</v><tt><see topic=\"ACL2____CONGRUENCE\">congruence</see></tt> lemmas. \u000A Interestingly, congruence lemmas are automatically created when an equivalence \u000A relation is stored, saying that either of the equivalence relation's arguments \u000A may be replaced by an equivalent argument.  That is, if the equivalence \u000A relation is <v>fn</v>, we store congruence rules that state the following \u000A fact:</p> \u000A \u000A <code>(<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (fn x1 y1)\u000A              (fn x2 y2))\u000A         (<see topic=\"ACL2____IFF\">iff</see> (fn x1 x2) (fn y1 y2)))</code> \u000A \u000A <p>Another aspect of equivalence relations is that of ``refinement.''  We say \u000A <v>equiv1</v> ``refines'' <v>equiv2</v> iff <v>(equiv1 x y)</v> implies <v>(equiv2 x\u000A y)</v>.  <v>:</v><tt><see topic=\"ACL2____REFINEMENT\">refinement</see></tt> rules permit you to establish such connections \u000A between your equivalence relations.  The value of refinements is that if the \u000A system is trying to rewrite something while maintaining <v>equiv2</v> it is \u000A permitted to use as a <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rule any refinement of \u000A <v>equiv2</v>.  Thus, if <v>equiv1</v> is a refinement of <v>equiv2</v> and there \u000A are <v>equiv1</v> rewrite-rules available, they can be brought to bear while \u000A maintaining <v>equiv2</v>.  See <see topic=\"ACL2____REFINEMENT\">refinement</see>.</p> \u000A \u000A <p>The system initially has knowledge of two equivalence relations, equality, \u000A denoted by the symbol <tt><see topic=\"COMMON-LISP____EQUAL\">equal</see></tt>, and propositional equivalence, denoted by \u000A <tt><see topic=\"ACL2____IFF\">iff</see></tt>.  <tt><see topic=\"COMMON-LISP____EQUAL\">Equal</see></tt> is known to be a refinement of all equivalence \u000A relations and to preserve equality across all arguments of all functions.</p> \u000A \u000A <p>Typically there are five steps involved in introducing and using a new \u000A equivalence relation, equiv.</p> \u000A \u000A <blockquote> \u000A \u000A <p>(1) Define <v>equiv</v>,</p> \u000A \u000A <p>(2) prove the <v>:equivalence</v> lemma about <v>equiv</v>,</p> \u000A \u000A <p>(3) prove the <v>:</v><tt><see topic=\"ACL2____CONGRUENCE\">congruence</see></tt> lemmas that show where <v>equiv</v> \u000A can be used to maintain known relations,</p> \u000A \u000A <p>(4) prove the <v>:</v><tt><see topic=\"ACL2____REFINEMENT\">refinement</see></tt> lemmas that relate <v>equiv</v> to \u000A known relations other than equal, and</p> \u000A \u000A <p>(5) develop the theory of conditional <v>:</v><tt><see topic=\"ACL2____REWRITE\">rewrite</see></tt> rules that \u000A drive equiv rewriting.</p> \u000A \u000A </blockquote> \u000A \u000A <p>More will be written about this as we develop the techniques.  For now, \u000A here is an example that shows how to make use of equivalence relations in \u000A rewriting.</p> \u000A \u000A <p>Among the theorems proved below is</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> insert-sort-is-id\u000A  (perm (insert-sort x) x))</code> \u000A \u000A <p>Here <v>perm</v> is defined as usual with <v>delete</v> and is proved to be an \u000A equivalence relation and to be a congruence relation for <tt><see topic=\"COMMON-LISP____CONS\">cons</see></tt> and \u000A <tt><see topic=\"COMMON-LISP____MEMBER\">member</see></tt>.</p> \u000A \u000A <p>Then we prove the lemma</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> insert-is-cons\u000A  (perm (insert a x) (<see topic=\"COMMON-LISP____CONS\">cons</see> a x)))</code> \u000A \u000A <p>which you must think of as you would <v>(insert a x) = (<see topic=\"COMMON-LISP____CONS\">cons</see> a x)</v>.</p> \u000A \u000A <p>Now prove <v>(perm (insert-sort x) x)</v>.  The base case is trivial.  The \u000A induction step is</p> \u000A \u000A <code>   (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A &amp; (perm (insert-sort (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))\u000A\u000A-&gt; (perm (insert-sort x) x).</code> \u000A \u000A <p>Opening <v>insert-sort</v> makes the conclusion be</p> \u000A \u000A <code>(perm (insert (<see topic=\"COMMON-LISP____CAR\">car</see> x) (insert-sort (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))) x).</code> \u000A \u000A <p>Then apply the induction hypothesis (rewriting <v>(insert-sort (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))</v> \u000A to <v>(<see topic=\"COMMON-LISP____CDR\">cdr</see> x)</v>), to make the conclusion be</p> \u000A \u000A <code>(perm (insert (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) x)</code> \u000A \u000A <p>Then apply <v>insert-is-cons</v> to get <v>(perm (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) x)</v>. \u000A But we know that <v>(<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> x))</v> is <v>x</v>, so we get <v>(perm x\u000A x)</v> which is trivial, since <v>perm</v> is an equivalence relation.</p> \u000A \u000A <p>Here are the events.</p> \u000A \u000A <code>(<see topic=\"ACL2____ENCAPSULATE\">encapsulate</see> (((lt * *) =&gt; *))\u000A  (<see topic=\"ACL2____LOCAL\">local</see> (<see topic=\"COMMON-LISP____DEFUN\">defun</see> lt (x y) (<see topic=\"COMMON-LISP____DECLARE\">declare</see> (<see topic=\"COMMON-LISP____IGNORE\">ignore</see> x y)) nil))\u000A  (<see topic=\"ACL2____DEFTHM\">defthm</see> lt-non-symmetric (<see topic=\"ACL2____IMPLIES\">implies</see> (lt x y) (<see topic=\"COMMON-LISP____NOT\">not</see> (lt y x)))))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> insert (x lst)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ATOM\">atom</see> lst) (<see topic=\"COMMON-LISP____LIST\">list</see> x))\u000A        ((lt x (<see topic=\"COMMON-LISP____CAR\">car</see> lst)) (<see topic=\"COMMON-LISP____CONS\">cons</see> x lst))\u000A        (t (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> lst) (insert x (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst))))))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> insert-sort (lst)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ATOM\">atom</see> lst) nil)\u000A        (t (insert (<see topic=\"COMMON-LISP____CAR\">car</see> lst) (insert-sort (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst))))))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> del (x lst)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ATOM\">atom</see> lst) nil)\u000A        ((<see topic=\"COMMON-LISP____EQUAL\">equal</see> x (<see topic=\"COMMON-LISP____CAR\">car</see> lst)) (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst))\u000A        (t (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> lst) (del x (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst))))))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> mem (x lst)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ATOM\">atom</see> lst) nil)\u000A        ((<see topic=\"COMMON-LISP____EQUAL\">equal</see> x (<see topic=\"COMMON-LISP____CAR\">car</see> lst)) t)\u000A        (t (mem x (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst)))))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> perm (lst1 lst2)\u000A  (<see topic=\"COMMON-LISP____COND\">cond</see> ((<see topic=\"COMMON-LISP____ATOM\">atom</see> lst1) (<see topic=\"COMMON-LISP____ATOM\">atom</see> lst2))\u000A        ((mem (<see topic=\"COMMON-LISP____CAR\">car</see> lst1) lst2)\u000A         (perm (<see topic=\"COMMON-LISP____CDR\">cdr</see> lst1) (del (<see topic=\"COMMON-LISP____CAR\">car</see> lst1) lst2)))\u000A        (t nil)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-reflexive\u000A  (perm x x))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-cons\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (mem a x)\u000A           (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (perm x (<see topic=\"COMMON-LISP____CONS\">cons</see> a y))\u000A                  (perm (del a x) y)))\u000A  :hints ((&quot;Goal&quot; :induct (perm x y))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-symmetric\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (perm x y) (perm y x)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> mem-del\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (mem a (del b x)) (mem a x)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-mem\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (perm x y)\u000A                (mem a x))\u000A           (mem a y)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> mem-del2\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (mem a x)\u000A                (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> a b)))\u000A           (mem a (del b x))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> comm-del\u000A  (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (del a (del b x)) (del b (del a x))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-del\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (perm x y)\u000A           (perm (del a x) (del a y))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> perm-transitive\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____AND\">and</see> (perm x y) (perm y z)) (perm x z)))\u000A\u000A(<see topic=\"ACL2____DEFEQUIV\">defequiv</see> perm)\u000A\u000A(<see topic=\"ACL2____IN-THEORY\">in-theory</see> (<see topic=\"ACL2____DISABLE\">disable</see> perm\u000A                    perm-reflexive\u000A                    perm-symmetric\u000A                    perm-transitive))\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> perm perm (<see topic=\"COMMON-LISP____CONS\">cons</see> x y) 2)\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> perm iff (mem x y) 2)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> atom-perm\u000A  (<see topic=\"ACL2____IMPLIES\">implies</see> (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)) (perm x nil))\u000A  :rule-classes :forward-chaining\u000A  :hints ((&quot;Goal&quot; :in-theory (<see topic=\"ACL2____ENABLE\">enable</see> perm))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> insert-is-cons\u000A  (perm (insert a x) (<see topic=\"COMMON-LISP____CONS\">cons</see> a x)))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> insert-sort-is-id\u000A  (perm (insert-sort x) x))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> app (x y) (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (<see topic=\"COMMON-LISP____CONS\">cons</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (app (<see topic=\"COMMON-LISP____CDR\">cdr</see> x) y)) y))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> rev (x)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) (app (rev (<see topic=\"COMMON-LISP____CDR\">cdr</see> x)) (<see topic=\"COMMON-LISP____LIST\">list</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x))) nil))\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> perm perm (app x y) 2)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> app-cons\u000A  (perm (app a (<see topic=\"COMMON-LISP____CONS\">cons</see> b c)) (<see topic=\"COMMON-LISP____CONS\">cons</see> b (app a c))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> app-commutes\u000A  (perm (app a b) (app b a)))\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> perm perm (app x y) 1\u000A  :hints ((&quot;Goal&quot; :induct (app y x))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> rev-is-id (perm (rev x) x))\u000A\u000A(<see topic=\"COMMON-LISP____DEFUN\">defun</see> == (x y)\u000A  (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> x)\u000A      (<see topic=\"COMMON-LISP____IF\">if</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> y)\u000A          (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (<see topic=\"COMMON-LISP____CAR\">car</see> x) (<see topic=\"COMMON-LISP____CAR\">car</see> y))\u000A               (== (<see topic=\"COMMON-LISP____CDR\">cdr</see> x) (<see topic=\"COMMON-LISP____CDR\">cdr</see> y)))\u000A          nil)\u000A      (<see topic=\"COMMON-LISP____NOT\">not</see> (<see topic=\"COMMON-LISP____CONSP\">consp</see> y))))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> ==-reflexive (== x x))\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> ==-symmetric (<see topic=\"ACL2____IMPLIES\">implies</see> (== x y) (== y x)))\u000A\u000A(<see topic=\"ACL2____DEFEQUIV\">defequiv</see> ==)\u000A\u000A(<see topic=\"ACL2____IN-THEORY\">in-theory</see> (<see topic=\"ACL2____DISABLE\">disable</see> ==-symmetric ==-reflexive))\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> == == (<see topic=\"COMMON-LISP____CONS\">cons</see> x y) 2)\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> == iff (<see topic=\"COMMON-LISP____CONSP\">consp</see> x) 1)\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> == == (app x y) 2)\u000A\u000A(<see topic=\"ACL2____DEFCONG\">defcong</see> == == (app x y) 1)\u000A\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> rev-rev (== (rev (rev x)) x))</code>"],

 "ACL2____DEFTHM":[["Events"],"ACL2 Sources","ACL2","<code>Examples:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> assoc-of-app\u000A        (<see topic=\"COMMON-LISP____EQUAL\">equal</see> (app (app a b) c)\u000A               (app a (app b c))))</code> \u000A \u000A <p>The following nonsensical example illustrates all the optional arguments \u000A but is illegal because not all combinations are permitted.  See <see topic=\"ACL2____HINTS\">hints</see> \u000A for a complete list of <see topic=\"ACL2____HINTS\">hints</see>.</p> \u000A \u000A <code>(<see topic=\"ACL2____DEFTHM\">defthm</see> main\u000A        (<see topic=\"ACL2____IMPLIES\">implies</see> (hyps x y z) (concl x y z))\u000A       :rule-classes (:REWRITE :GENERALIZE)\u000A       :instructions (<see topic=\"ACL2____INDUCT\">induct</see> prove promote (dive 1) x\u000A                             (dive 2) = top (drop 2) prove)\u000A       :hints ((&quot;Goal&quot;\u000A                :do-not '(<see topic=\"ACL2____GENERALIZE\">generalize</see> fertilize)\u000A                :in-theory (<see topic=\"ACL2____SET-DIFFERENCE-THEORIES\">set-difference-theories</see>\u000A                             (<see topic=\"ACL2____CURRENT-THEORY\">current-theory</see> :here)\u000A                             '(<see topic=\"COMMON-LISP____ASSOC\">assoc</see>))\u000A                :induct (<see topic=\"COMMON-LISP____AND\">and</see> (<see topic=\"COMMON-LISP____NTH\">nth</see> n a) (<see topic=\"COMMON-LISP____NTH\">nth</see> n b))\u000A                :use ((:instance assoc-of-append\u000A                                 (x a) (y b) (z c))\u000A                      (:functional-instance\u000A                        (:instance p-f (x a) (y b))\u000A                        (p consp)\u000A                        (f assoc)))))\u000A       :otf-flg t)\u000A\u000AGeneral Form:\u000A(<see topic=\"ACL2____DEFTHM\">defthm</see> name term\u000A        :rule-classes rule-classes\u000A        :instructions instructions\u000A        :hints        hints\u000A        :otf-flg      otf-flg\u000A        :doc          doc-string)</code> \u000A \u000A <p>where <v>name</v> is a new symbolic name (see <see topic=\"ACL2____NAME\">name</see>), <v>term</v> is a \u000A term alleged to be a theorem, and <tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt>, <tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt>, \u000A <tt><see topic=\"ACL2____HINTS\">hints</see></tt>, and <tt><see topic=\"ACL2____OTF-FLG\">otf-flg</see></tt> are as described in their respective <see topic=\"COMMON-LISP____DOCUMENTATION\">documentation</see>.  <v>Doc-string</v>, if non-<v>nil</v>, is an optional string that \u000A can provide documentation but is essentially ignored by ACL2.  The five \u000A keyword arguments above are all optional, however you may not supply both \u000A <v>:</v><tt><see topic=\"ACL2____INSTRUCTIONS\">instructions</see></tt> and <v>:</v><tt><see topic=\"ACL2____HINTS\">hints</see></tt>, since one drives the proof \u000A checker and the other drives the theorem prover.  If <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> is not specified, the list <v>(:rewrite)</v> is used; if you wish \u000A the theorem to generate no rules, specify <v>:</v><tt><see topic=\"ACL2____RULE-CLASSES\">rule-classes</see></tt> \u000A <v>nil</v>.</p> \u000A \u000A <p>When ACL2 processes a <v>defthm</v> event, it first tries to prove the <see topic=\"ACL2____TERM\">term</see> using the indicated hints (see <see topic=\"ACL2____HINTS\">hints</see>) or <see topic=\"ACL2____INSTRUCTIONS\">instructions</see> (see \u000A <see topic=\"ACL2____PROOF-CHECKER\">proof-checker</see>).  If it is successful, it stores the rules described by \u000A the rule-classes (see <see topic=\"ACL2____RULE-CLASSES\">rule-classes</see>), proving the necessary \u000A corollaries.</p>"],

 "ACL2____PROGRAM":[["Defun-mode"],"ACL2 Sources","ACL2","<code>Example:\u000AACL2 !&gt;:program\u000AACL2 p!&gt;</code> \u000A \u000A <p>Typing the keyword <v>:program</v> sets the default <see topic=\"ACL2____DEFUN-MODE\">defun-mode</see> to \u0