/* main.c */
#include "main.h"

/* Main data structures */
/* Global Variables */
Boolean displaying = FALSE;
char rcFileName[MAXSTRLEN];
int dichrome = 0;

main(int argc, char *argv[]) {
  int i, j;
  size_t len;
  String path;
  char *env;
  
  if( (env = getenv( "PWD" )) ) {
    if( sscanf( env, "%s/SignalSim", path ) != 1 ) {
      printf( "The current working directory is %s\n", env );
      printf( "If the script file to be used contains relative path names\n" );
      printf( " signalsim must be run from the top directory SignalSim/\n" );
      exit(1);
    }      
  }
  strcpy( rcFileName, "scripts/net.tcl" );
  /* Assume first argument is name of a script to be run or help */
  if( argc > 1 ) {
    len = strlen( argv[1] );
    if( !strncmp( "-help", argv[1], len ) ) {
      printf( "Usage:  signalsim [scripts/script.tcl]\n" );
      printf( "If script.tcl contains relative path names, SignalSim\n" );
      printf( "  must be run from the top directory SignalSim/\n" );
      exit(1);
    } else {
      strcpy( rcFileName, argv[1] );
    }
    argc--;
    argv++;
  }
  if( access( rcFileName, F_OK ) < 0 ) {
    printf( "script file %s does not exist\n", rcFileName );
    exit(1);
  }

  /* Assume second argument is color option */
  if( argc > 1 ) {
    dichrome = atoi( argv[1] );
    argc--;
    argv++;
  }
    
  printf( "Using script %s\n", rcFileName );
  Tk_Main(argc, argv, Tcl_AppInit);
  exit(0);
}

/*
 * Tcl_AppInit is called from Tcl_Main
 * after the Tcl interpreter has been created,
 * and before the script file
 * or interactive command loop is entered.
 */
int
Tcl_AppInit(Tcl_Interp *interp) {
   /*
    * Initialize packages
    * Tcl_Init sets up the Tcl library facility.
    */
   if (Tcl_Init(interp) == TCL_ERROR) {
      return TCL_ERROR;
   }
   /* Assume X is up */
   displaying = TRUE;
   if (Tk_Init(interp) == TCL_ERROR) {
     if( !strncmp(interp->result, "no display name", 15) )
       displaying = 0;
     else
       return TCL_ERROR;
   }
   /* Add BLT extension
   if (Blt_Init(interp) == TCL_ERROR) {
     return TCL_ERROR;
   } */

   /*
    * Define application-specific commands here.
    */

   Tcl_CreateCommand(interp, "neuron", NeuronCmd, 
		     (ClientData)Tk_MainWindow(interp),
		     (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateCommand(interp, "network", NetworkCmd, 
		     (ClientData)Tk_MainWindow(interp),
		     (Tcl_CmdDeleteProc *)NULL);

   /*
    * Define startup filename. This file is read in
    * case the program is run interactively. */

   Tcl_SetVar(interp, "tcl_rcFileName", rcFileName, TCL_GLOBAL_ONLY);

   srand( 113 );
   init_rgbtab();
   alloc_col(Tk_MainWindow(interp));

   return TCL_OK;
}

static void
init_rgbtab() {
/* calculates values for the linear color spectrum black-red-yellow-white
   and stores them in rbgtab */
  double f, r, u, v;
  int i;

  if( dichrome ) {
    for( i = 0; i < MAXCOLORS; i++ ) {
      rgbtab[i].red = (65535.0 * i) / 255;
      rgbtab[i].blue = (65535.0 * i) / 255;
      rgbtab[i].green = (65535.0 * i) / 255;
    }
  } else {
    /* make a spectrum */

    f = 191.25;
    r = 65535.0 / 1036335.9375;
    
    for( i = 0; i < MAXCOLORS; i++ ) {
      rgbtab[i].red = 256*i;
      rgbtab[i].green = (int) (r*(i*i*i - 2*f*i*i + f*f*i));
      u = sqrt( (double) i );
      v = - cos(3*u*M_PI/16);
      rgbtab[i].blue = 65536 * (.5 + .5 * v);
    }
  }
}

static void
alloc_col (Tk_Window tkwin) {
/* allocate colors from rgbtab until no more free cells,
   using existing colors if they match what we want */
  int start = MAXCOLORS / 2;		/* starting offset in an alloc sweep */
  int d = MAXCOLORS;			/* increment in an alloc sweep */
  int j,				/* index to the linear spectrum */
    k;					/* number of colors allocated */
  Display *display = Tk_Display(tkwin);
  Colormap colormap = Tk_Colormap(tkwin);

  for (j = 0; j < MAXCOLORS; j++)
    cmap[j] = NONE;
  k = 0;

  /* add colors to cmap, keep them uniformly distributed in the range,
     and gradually make the spectrum more refined */
  while (d > 1)
    {
      /* add colors to cmap with d as the current distance
	 between new colors in the spectrum and start as the first location */
      j = start;
      while (j < MAXCOLORS)		/* completed a sweep of new colors */
	{
	  colors[k].flags = DoRed | DoGreen | DoBlue;	/* use all planes */
	  colors[k].red = rgbtab[j].red;
	  colors[k].green = rgbtab[j].green;
	  colors[k].blue = rgbtab[j].blue;
	  /* colors[cmap[j+1]] is "darker" then colors[cmap[j]] */
	  cmap[j] = k;
	  if (XAllocColor (display, colormap, &(colors[k])) == 0) {
	    cmap[j] = NONE;
	    clean_color_map(k);
	    return;
	  }
	  k++;				/* allocated one new color */
	  j += d;			/* next location in the spectrum */
	}
      d /= 2;				/* set up a tighter distance */
      start /= 2;			/* start lower in the spectrum */
    }
  clean_color_map(k);	                /* set # of colors, clean up */
}

static void
clean_color_map(int k) {
/* set the number of colors, print message, and clean up the map */
  int i, m;			/* counters for cleaning up cmap */

  /* colors[k-1] is the last valid colorcell */
  actual_color_range = k;

  if (actual_color_range < MINCOLORS)
    {
      fprintf (stderr, "Warning: obtained only %d colors\n", k);
      fprintf (stderr, "(consider using a private colormap)\n");
    }
  else
    printf ("Obtained %d colors.\n", k);

  /* clean up cmap; move all entries to the beginning */
  m = 0;
  while (m < MAXCOLORS && cmap[m] != NONE)
    ++m;
  for (i = m + 1; i < MAXCOLORS; i++)
    if (cmap[i] == NONE)	/* no colorcell */
      continue;
    else
      cmap[m] = cmap[i], ++m;
}

XColor 
trans_to_color( float val, float lo, float hi ) {
/* translate an activation in range [lo,hi] into color index in range [0,1] */
  int idx;
  float value;

  value = (val - lo) / (hi - lo);
  if( value > 0.0 )
    value = (log(value)+5.0) / 5.0;
  idx = (int) (actual_color_range - 1) * value + 0.49999999;
  if( idx < 0 ) idx = 0;
  return colors[cmap[idx]];
}
