#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <values.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "tcl.h"
#include "tk.h"
#include "tkCanvas.h"

/* General definitions */
#define MAXSTRLEN      1000
#define TOLERANCE         0.0001
#define DBLSIZE         sizeof(double)
#define UNDEFINED        -1 

#ifndef min
#define min(x,y) (x < y) ? x : y
#endif
#ifndef max
#define max(x,y) (x > y) ? x : y
#endif

/* color parameters */
#define UNDEFINED -1 
#define MINCOLORS        10	 /* if fewer free colors, use existing */
#define MAXCOLORS       256	 /* max # of colors */
#define MAXCOLGRAN    65535	 /* granularity of color values */
#define NONE            (-1)

typedef enum {
  FALSE, TRUE
} Boolean;

/* colormap entry */
typedef struct RGB
  {
    int red, green, blue;	/* hold possible rgb values in XColor struct */
  }
RGB;

/* Color declarations */
static XColor colors[MAXCOLORS];
static int actual_color_range;	/* number of colors in use */
/* Array of rgb values that represents a linear color spectrum */
static RGB rgbtab[MAXCOLORS];
/* the weight/unit value colormap */
static int cmap[MAXCOLORS];

/* Widget commands */

int NeuronCmd(ClientData clientData,
	      Tcl_Interp *interp,
	      int argc, char *argv[]);

int NetworkCmd(ClientData clientData,
	      Tcl_Interp *interp,
	      int argc, char *argv[]);

/* Some typedefs */
typedef char String[MAXSTRLEN];           /* String */

/*** global parameters, assumed the same for all neurons ***/
#define SPIKEPOTENTIAL          70.0
#define RESTPOTENTIAL         (-70.0)
#define REFRACTORYPOTENTIAL   (-90.0)
#define FIRING_THRESHOLD      (-50.0)
#define SIMULTANEOUS_EPSILON    0.01 /* PSPs within s._e. are simultaneous */

/*** synapses and neurons ***/
#define MAXINPSYN 50            /* max number of input synapses per neuron */
typedef struct InpsynStruct
{
  float efficacy,		/* efficacy of synapse, i.e. PSP (mV) */
  distance,			/* distance from the axon hillock (um) */
  first,			/* time of first input (ms from start) */
  interval;			/* interval of inputs (ms) */
  int connected;		/* 1=connected to another neuron, 0=abstract */
} InpsynStruct;

#define MAXOUTCON 10            /* max number of output connections  */
typedef struct OutconStruct
{
  int neuronidx,		/* connection to this neuron */
      inpsynidx;		/* and to this input synapse of that neuron */
  float delay;			/* transmission delay (ms) */
} OutconStruct;

#define MAXNEURON  10           /* maximum number of neurons */
typedef struct Neuron
{
  Tcl_Interp *interp;		/* Interpreter associated with obj. */
  Tcl_Command objCmd;	        /* Token for net's obj command. */
  TkCanvas *canvas;             /* Pointer to canvas where neuron is */
  int widgetId;	                /* Id of associated canvas neuron widget */
  String widgetTag;             /* Tag of associated canvas neuron widgets */
  Tk_Item *itemPtr;             /* Pointer to item on canvas */
  float potential;		/* membrane potential at the axon hillock(mV)*/
  float preveventt;		/* time of previous event (ms from start) */
  int ninpsyn;		        /* number of input synapses */
  InpsynStruct *inpsyn[MAXINPSYN];
  int noutcon;		        /* number of output connections */
  OutconStruct *outcon[MAXOUTCON];
} Neuron;

#define EVENTSIZE 16		/* size of the event structure (bytes)*/
typedef struct Event
{
  int eventidx;                 /* one-up count of events */
  float eventt;			/* time of the event (ms from start)*/
  int neuronidx,		/* neuron where it occurs */
      inpsynidx;	        /* input synapse where it occurs */
  struct Event *nextevent;      /* pointer to the next event in the queue */
} Event;

typedef struct Network
{
  Tcl_Interp *interp;		/* Interpreter associated with obj. */
  Tcl_Command objCmd;	        /* Token for net's obj command. */
  int nneuron;                  /* Number of neurons in network */
  int tend;                     /* Time limit (ms) */
  int timestep;                 /* Current time */
  float decayfact;	        /* spontaneous potential decrease factor */
  float attenfact;	        /* potential attenuation factor */
  int queuelen;                 /* Length of event queue */
  int eventcnt;                 /* Number of events allocated so far */
  Neuron *neuron[MAXNEURON];    /* Pointer to allocated neuron */
  int thisneuron;               /* current neuron */
  float thistime;               /* current time */
  Event *headevent;             /* pointer to the head of the queue */
  Event *curevent;              /* pointer to the current event */
  Event *thisevent;             /* pointer to the current event */
  Event *prevevent;             /* pointer to the previous event */
  FILE *fp;                     /* FP to output file */
  TkCanvas *canvas;             /* Pointer to canvas where neurons are */
} Network;

/*
 * The structure below defines the record for each polygon item.
 */

typedef struct PolygonItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    int numPoints;		/* Number of points in polygon (always >= 3).
				 * Polygon is always closed. */
    int pointsAllocated;	/* Number of points for which space is
				 * allocated at *coordPtr. */
    double *coordPtr;		/* Pointer to malloc-ed array containing
				 * x- and y-coords of all points in polygon.
				 * X-coords are even-valued indices, y-coords
				 * are corresponding odd-valued indices. */
    int width;			/* Width of outline. */
    XColor *outlineColor;	/* Color for outline. */
    GC outlineGC;		/* Graphics context for drawing outline. */
    XColor *fillColor;		/* Foreground color for polygon. */
    Pixmap fillStipple;		/* Stipple bitmap for filling polygon. */
    GC fillGC;			/* Graphics context for filling polygon. */
    int smooth;			/* Non-zero means draw shape smoothed (i.e.
				 * with Bezier splines). */
    int splineSteps;		/* Number of steps in each spline segment. */
    int autoClosed;		/* Zero means the given polygon was closed,
				   one means that we auto closed it. */
} PolygonItem;

/* Main procedures */
static void  init_rgbtab _ANSI_ARGS_((void));
static void  alloc_col _ANSI_ARGS_((Tk_Window tkwin));
static void  clean_color_map _ANSI_ARGS_((int k));
XColor       trans_to_color _ANSI_ARGS_((float val, float lo, float hi));
extern void  DeleteNeuron _ANSI_ARGS_((ClientData clientData));
extern void  NeuronDisplay( Neuron *neuronPtr );
