#include "main.h"

/* Network data struct defined in main.h because the structure is
   referenced globally */

static int   NetworkObjCmd(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[]);
static void  NetworkConfigure(Network *netPtr, int argc, char *argv[]);
static void  DeleteNetwork(ClientData clientData);
static void  ReadParms(Network *netPtr, char *parmfile);
void         ClearQueue(Network *netPtr);
void         NewNetwork(Network *netPtr);
void         InitNetwork(Network *netPtr);
Event        *NewEvent(Network *netPtr, float eventt, int neuronidx, 
		       int inpsynidx, Event *nextevent);
void         FreeEvent(Event *eventPtr);
void         AddEvent(Network *netPtr, Event *ptr, float eventt, 
		       int neuronidx, int inpsynidx);
int          GetCurrentEvent(Network *netPtr);
float        DecayPotential(Network *netPtr);
float        IntegratePsp(Network *netPtr);
int          GenerateSpikeEvents(Network *netPtr);
int          Hyperpolarize(Network *netPtr);
void         print_event_queue(FILE *qp, Event *headevent);
