#include "neuron.h"

/**************************** Neuron Commands *******************************/
int 
NeuronCmd(ClientData clientData, Tcl_Interp *interp,
	     int argc, char *argv[]) {
  Neuron *neuronPtr;
  int i, j;

  neuronPtr = (Neuron *) ckalloc(sizeof(Neuron));
  neuronPtr->interp = interp;
  interp->result = Tk_GetUid(argv[1]);  /* @#$970517 TK non-window stuff */
  neuronPtr->objCmd = Tcl_CreateCommand(interp, interp->result, NeuronObjCmd,
				     (ClientData) neuronPtr,  DeleteNeuron);
  neuronPtr->canvas = NULL;
  neuronPtr->widgetId = 0;
  strcpy( neuronPtr->widgetTag, "" );
  neuronPtr->itemPtr = NULL;
  neuronPtr->potential = RESTPOTENTIAL;
  neuronPtr->preveventt = 0.0;
  neuronPtr->ninpsyn = 0;
  for (i = 0; i < MAXINPSYN; i++ )
    neuronPtr->inpsyn[i] = NULL;
  neuronPtr->noutcon = 0;
  for (i = 0; i < MAXOUTCON; i++ )
    neuronPtr->outcon[i] = NULL;

  NeuronConfigure( neuronPtr, argc-2, argv+2 );
  return TCL_OK;
}

int 
NeuronObjCmd(ClientData clientData, Tcl_Interp *interp,
	     int argc, char *argv[]) {
  Neuron *neuronPtr = (Neuron *) clientData;
  int i;
  int result = TCL_OK;
  size_t length;
  char c;

  Tcl_Preserve((ClientData) neuronPtr);
  c = argv[1][0];
  length = strlen(argv[1]);

  /* Create a layer for the neuron object */
  if ((c == 's') && (!strncmp(argv[1], "synapse", length))
      && (length >= 4)) {
    int idx;
    InpsynStruct *inpsynPtr;
    
    if (argc < 3 || (argc > 3 && argc < 7)) {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], 
	     " synapse Index (Efficacy Distance First Interval)\"",
		       (char *) NULL);
      goto error;
    }
    idx = atoi( argv[2] );
    inpsynPtr = neuronPtr->inpsyn[idx];
    if( argc == 3 ) {  /* Query */
      if( inpsynPtr )
	sprintf( neuronPtr->interp->result, "%f %f %f %f %d", 
		 inpsynPtr->efficacy, inpsynPtr->distance, inpsynPtr->first, 
		 inpsynPtr->interval, inpsynPtr->connected );
      else
	sprintf( neuronPtr->interp->result, "-1" );
    } else {
      if( idx > neuronPtr->ninpsyn ) {
	printf( "synapse %d > %d (number of allocated synapses)\n", idx,
		neuronPtr->ninpsyn );
      } else {
	if( !inpsynPtr ) {
	  inpsynPtr = (InpsynStruct *) ckalloc(sizeof(InpsynStruct));
	  neuronPtr->inpsyn[idx] = inpsynPtr;
	  neuronPtr->ninpsyn++;
	}
	inpsynPtr->efficacy  = atof( argv[3] );
	inpsynPtr->distance  = atof( argv[4] );
	inpsynPtr->first     = atof( argv[5] );
	inpsynPtr->interval  = atof( argv[6] );
	inpsynPtr->connected = 0;
      }
    }

  } else if ((c == 'o') && (!strncmp(argv[1], "outcon", length))
	     && (length >= 4)) {
    int idx;
    OutconStruct *outconPtr;
    
    if (argc < 3 || (argc > 3 && argc < 6)) {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " outcon Index (Neuron Synapse Delay)\"",
		       (char *) NULL);
      goto error;
    }
    idx = atoi( argv[2] );
    outconPtr = neuronPtr->outcon[idx];
    if( argc == 3 ) {  /* Query */
      if( outconPtr )
	sprintf( neuronPtr->interp->result, "%d %d %f", 
		 outconPtr->neuronidx, outconPtr->inpsynidx,
		 outconPtr->delay );
      else
	sprintf( neuronPtr->interp->result, "-1" );
    } else {
      if( idx > neuronPtr->noutcon ) {
	printf( "outcon %d > %d (number of allocated outcons)\n", idx,
		neuronPtr->noutcon );
      } else {
	if( !outconPtr ) {
	  outconPtr = (OutconStruct *) ckalloc(sizeof(OutconStruct));
	  neuronPtr->outcon[idx] = outconPtr;
	  neuronPtr->noutcon++;
	}
	outconPtr->neuronidx = atoi( argv[3] );
	outconPtr->inpsynidx = atoi( argv[4] );
	outconPtr->delay     = atof( argv[5] );
      }
    }

  } else if ((c == 'n') && (!strncmp(argv[1], "ninpsyn", length))
	     && (length >= 4)) {
    
    sprintf( neuronPtr->interp->result, "%d", neuronPtr->ninpsyn );

  } else if ((c == 'n') && (!strncmp(argv[1], "noutcon", length))
	     && (length >= 4)) {
    
    sprintf( neuronPtr->interp->result, "%d", neuronPtr->noutcon );

  } else if ((c == 'i') && (!strncmp(argv[1], "id", length))
	     && (length >= 2)) {
    
    sprintf( neuronPtr->interp->result, "%d", neuronPtr->widgetId );

  } else if ((c == 't') && (!strncmp(argv[1], "tag", length))
	     && (length >= 3)) {
    
    sprintf( neuronPtr->interp->result, "%d", neuronPtr->widgetTag );

  } else if ((c == 'c') && (!strncmp(argv[1], "config", length))
	     && (length >= 4)) {
    InpsynStruct *inpsynPtr;
    OutconStruct *outconPtr;

    if( argc > 2 )
      NeuronConfigure( neuronPtr, argc-2, argv+2 );
    else {
      printf( "  neuronPtr      0x%x\n", neuronPtr );
      printf( "  interp         0x%x\n", neuronPtr->interp );
      printf( "  objCmd         0x%x\n", neuronPtr->objCmd );
      printf( "  widgetId       %d\n", neuronPtr->widgetId );
      printf( "  widgetTag      %s\n", neuronPtr->widgetTag );
      printf( "  itemPtr        0x%x\n", neuronPtr->itemPtr );
      printf( "  potential      %f\n", neuronPtr->potential );
      printf( "  preveventt     %f\n", neuronPtr->preveventt );
      printf( "  ninpsyn        %d\n", neuronPtr->ninpsyn );
      for( i = 0; i < neuronPtr->ninpsyn; i++ ) {
	inpsynPtr = neuronPtr->inpsyn[i];
	printf( "  inpsyn         0x%x\n", inpsynPtr );
	printf( "    efficacy     %f\n", inpsynPtr->efficacy );
	printf( "    distance     %f\n", inpsynPtr->distance );
	printf( "    first        %f\n", inpsynPtr->first );
	printf( "    interval     %f\n", inpsynPtr->interval );
	printf( "    connected    %d\n", inpsynPtr->connected );
      }
      printf( "  noutcon        %d\n", neuronPtr->noutcon );
      for( i = 0; i < neuronPtr->noutcon; i++ ) {
	outconPtr = neuronPtr->outcon[i];
	printf( "  outcon         0x%x\n", outconPtr );
	printf( "    to_neuron    %d\n", outconPtr->neuronidx );
	printf( "    to_synapse   %d\n", outconPtr->inpsynidx );
	printf( "    delay        %f\n", outconPtr->delay );
      }
    }

  } else {

    Tcl_AppendResult(interp, "Neuron: bad option \"", argv[1],
		     "\":  must be config",
		     (char *) NULL);
    goto error;
  }

  Tcl_Release((ClientData) neuronPtr);
  return result;
  
error:
  Tcl_Release((ClientData) neuronPtr);
  return TCL_ERROR;
}

void
NeuronConfigure( Neuron *neuronPtr, int argc, char **argv ) {
  size_t length;
  int i = 0;
  char c;

  while( i < argc ) {
    if( argv[i][0] != '-' ) {
      fprintf( stderr, "NeuronConfigure:  Can't process arg <%s>; skipping\n", 
	       argv[i] );
      i++;
      continue;
    }
    c = argv[i][1];
    length = strlen(argv[i]);

    if ((c == 'p') && (!strncmp(argv[i], "-potential", length))
	       && (length >= 4)) {
      neuronPtr->potential = atof( argv[i+1] );
    } else if ((c == 'p') && (!strncmp(argv[i], "-preveventt", length))
	       && (length >= 4)) {
      neuronPtr->preveventt = atof( argv[i+1] );
    } else if ((c == 'n') && (!strncmp(argv[i], "-ninpsyn", length))
	       && (length >= 4)) {
      neuronPtr->ninpsyn = atoi( argv[i+1] );
    } else if ((c == 'n') && (!strncmp(argv[i], "-noutcon", length))
	       && (length >= 4)) {
      neuronPtr->noutcon = atoi( argv[i+1] );
    } else if ((c == 'i') && (!strncmp(argv[i], "-id", length))
	       && (length >= 3)) {
      neuronPtr->widgetId = atoi( argv[i+1] );
    } else if ((c == 't') && (!strncmp(argv[i], "-tag", length))
	       && (length >= 4)) {
      strcpy( neuronPtr->widgetTag, argv[i+1] );
    }
    i += 2;
  }
}

void 
DeleteNeuron(ClientData clientData) {
  Neuron *neuronPtr = (Neuron *) clientData;
  int i;
  /*  String cmd;

      Delete items on canvas before
      sprintf( cmd, "%s delete %s", 
      Tk_PathName(Tk_CanvasTkwin((Tk_Canvas) neuronPtr->canvas)),
      neuronPtr->widgetTag );
      Tcl_Eval( neuronPtr->interp, cmd ); */
  for( i = 0; i < neuronPtr->ninpsyn; i++ )
    ckfree( neuronPtr->inpsyn[i] );
  for( i = 0; i < neuronPtr->noutcon; i++ )
    ckfree( neuronPtr->outcon[i] );
  ckfree((char *) clientData);
}

void
NeuronDisplay( Neuron *neuronPtr ) {
  TkCanvas *canvasPtr = (TkCanvas *) neuronPtr->canvas;
  Tk_Window tkwin = canvasPtr->tkwin;
  Tk_Item *itemPtr = neuronPtr->itemPtr;
  PolygonItem *polyPtr = (PolygonItem *) itemPtr;
  Pixmap pixmap;
  XColor color;
  float potential = neuronPtr->potential;

  /* Check this range later */
  if( potential < REFRACTORYPOTENTIAL ) potential = REFRACTORYPOTENTIAL;
  if( potential > SPIKEPOTENTIAL ) potential = SPIKEPOTENTIAL;
  color = trans_to_color( potential, REFRACTORYPOTENTIAL, SPIKEPOTENTIAL);
  XSetForeground( Tk_Display(tkwin), polyPtr->fillGC, color.pixel );
  pixmap = Tk_GetPixmap(Tk_Display(tkwin), Tk_WindowId(tkwin),
	     (itemPtr->x2 - itemPtr->x1), (itemPtr->y2 - itemPtr->y1),
			Tk_Depth(tkwin));
  (*itemPtr->typePtr->displayProc)((Tk_Canvas) canvasPtr, itemPtr, 
				   Tk_Display(tkwin), pixmap, 0, 0, 0, 0);
  XFreePixmap(Tk_Display(tkwin), pixmap);
}
