/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn;

import edu.utexas.cs.nn.Point;

public class PathSegment {
    public Point start;
    public Point end;

    public PathSegment(Point start, Point end) {
        this.start = start;
        this.end = end;
    }

    public PathSegment join(PathSegment other) {
        if (this.end.getIndex() + 1 == other.start.getIndex()) {
            return new PathSegment(this.start, other.end);
        }
        if (this.start.getIndex() - 1 == other.end.getIndex()) {
            return new PathSegment(other.start, this.end);
        }
        throw new IllegalArgumentException("Cannot join segments " + this + " and " + other);
    }

    public void prepend(Point p) {
        if (p.getIndex() + 1 != this.start.getIndex()) {
            throw new IllegalArgumentException("Cannot prepend point " + p);
        }
        this.start = p;
    }

    public void append(Point p) {
        if (p.getIndex() - 1 != this.end.getIndex()) {
            throw new IllegalArgumentException("Cannot append point " + p);
        }
        this.end = p;
    }
}

