/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.bots;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.Point;
import edu.utexas.cs.nn.bots.BaseBot;
import edu.utexas.cs.nn.retrace.PoseSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

@AgentScoped
public class HumanRetraceBot
extends BaseBot {
    public static final double TIME_DISCONTINUITY = 5.0;
    public static final double SPACE_DISCONTINUITY = 250.0;
    private List<PoseSequence> sequences = new LinkedList<PoseSequence>();
    private boolean initialized = false;
    private Iterator<PoseSequence> sequenceIter = null;
    private PoseSequence sequence = null;
    private double lastTime = -1.0;

    public void prepareBot(UT2004Bot bot) throws PogamutException {
        super.prepareBot(bot);
    }

    private void myInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        File traceHome = new File(Constants.HUMAN_DATA_PATH.get());
        if (this.game == null || this.game.getMapName() == null) {
            this.getLog().severe("Could not find level-specific pose data");
            return;
        }
        File levelSpecificTraceHome = new File(traceHome, this.game.getMapName());
        if (!levelSpecificTraceHome.exists()) {
            this.getLog().log(Level.SEVERE, "Could not find level-specific pose data for " + this.game.getMapName());
            return;
        }
        File[] subdirs = levelSpecificTraceHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subdirs == null) {
            return;
        }
        for (File subdir : subdirs) {
            File[] dataFiles = subdir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".dat");
                }
            });
            if (dataFiles != null) {
                for (File dataFile : dataFiles) {
                    System.out.println(dataFile.getName());
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
                        this.sequences.addAll(PoseSequence.readSequences(reader));
                    }
                    catch (FileNotFoundException ex) {
                        this.getLog().log(Level.SEVERE, "Data file not found", (Throwable)ex);
                    }
                    catch (IOException ioe) {
                        this.getLog().log(Level.SEVERE, "Error while reading pose data file", (Throwable)ioe);
                    }
                }
            }
            System.out.println("done reading sequences: " + this.sequences.size() + " in subdir " + subdir);
        }
    }

    @Override
    public void logic() throws PogamutException {
        super.logic();
        this.myInitialize();
        double levelTime = this.game.getTime();
        double speed = this.bot.getVelocity().size();
        double skipTime = 0.0;
        if (this.lastTime > 0.0) {
            skipTime = levelTime - this.lastTime;
        }
        double distance_estimate = skipTime * speed;
        if (this.sequence != null && this.sequence.hasNext()) {
            Point pose = distance_estimate > 0.0 ? this.sequence.nextByDistance(distance_estimate) : this.sequence.nextByTime(skipTime);
            Location current = this.getAgentMemory().getAgentLocation().getLocation();
            Location next = pose.getLocation();
            if (next.getDistance(current) > 250.0) {
                System.out.println("RESPAWN: space discontinuity");
                this.body.getAction().respawn((ILocated)pose.getLocation(), pose.getRotation());
            } else {
                this.move.moveTo((ILocated)pose.getLocation());
            }
            System.out.println("current: " + current + " next: " + next);
            System.out.println("level: " + levelTime + " data: " + pose.getT() + " skip: " + skipTime);
        } else {
            if (this.sequenceIter == null) {
                this.sequenceIter = this.sequences.iterator();
            }
            if (this.sequenceIter.hasNext()) {
                this.sequence = this.sequenceIter.next();
                if (this.sequence.hasNext()) {
                    Point pose = this.sequence.nextByTime(skipTime);
                    this.body.getAction().respawn((ILocated)pose.getLocation(), pose.getRotation());
                }
            }
        }
        this.lastTime = levelTime;
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HumanRetraceBot.class, "HumanRetraceBot").setMain(true).startAgent();
    }
}

