/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.bots;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.agent.utils.UT2004BotDescriptor;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.MultipleUT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.bots.BaseBot;
import edu.utexas.cs.nn.bots.HumanRetraceBot;
import edu.utexas.cs.nn.retrace.HumanRetraceController;
import edu.utexas.cs.nn.weapons.WeaponPreferenceTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.ActionLog;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.EmptyAction;
import utopia.agentmodel.actions.GotoItemAction;
import utopia.agentmodel.actions.QuickTurnAction;
import utopia.agentmodel.actions.StillAction;
import utopia.controllers.TWEANN.TWEANNController;
import utopia.controllers.scripted.ChasingController;
import utopia.controllers.scripted.DistantPathController;
import utopia.controllers.scripted.JudgingController;
import utopia.controllers.scripted.ObservingController;
import utopia.controllers.scripted.PathController;
import utopia.controllers.scripted.ShieldGunController;
import utopia.controllers.scripted.UnstuckController;
import utopia.controllers.scripted.WaterController;
import wox.serial.Easy;

@AgentScoped
public class UT2
extends BaseBot {
    private String cachedName = null;
    private String cachedMap = null;
    private PrintWriter actionLog = null;
    private static final String DEFAULT_FILE = "candidates/FRONT-DM-1on1-Albatross-vs-1Native_98_7.xml";
    private String actionLogFilename = null;
    private boolean logAtEnd = false;
    private PathController pathController;
    public TWEANNController battleController;
    private UnstuckController unstuckController;
    private ObservingController observingController;
    private HumanRetraceController humanTraceController;
    private ChasingController chaseController;
    private JudgingController judgingController = null;
    private ShieldGunController shieldGunController;
    private WaterController waterController = null;
    private Action action;
    public static WeaponPreferenceTable weaponPreferences;
    private int notMoving;
    private static final int MAX_STILL_TIME = 8;
    private static final int INTERESTING_HEALTH_ITEM = 5;
    private static final int OFF_GRID_DISTANCE = 600;
    private static final double TIME_BETWEEN_QUICK_TURNS = 2.5;
    private static boolean printActions;
    public static final int CONSECUTIVE_OBSERVE_ALLOWANCE = 10;
    private double lastRetraceFailure = 0.0;
    private ActionLog actions = new ActionLog("UT^2");
    private ActionLog stuckTriggers = new ActionLog("Stuck Trigger");
    private boolean ANONYMOUS_NAME = true;
    private Player lastTargetObserved = null;
    private int consecutiveObservations = 0;
    public static final double START_OBSERVING_CHANCE = 0.75;
    public static final double BREAK_OBSERVING_CHANCE = 0.15;
    public static final double BROKEN_OBSERVATION_PAUSE = 5.0;
    public static final double JUDGE_THEN_OBSERVE_PAUSE = 10.0;
    IWorldObjectEventListener<Player, WorldObjectDisappearedEvent<Player>> playerDisappeared = new IWorldObjectEventListener<Player, WorldObjectDisappearedEvent<Player>>(){

        public void notify(WorldObjectDisappearedEvent<Player> event) {
            if (event != null) {
                Player disappeared = (Player)event.getObject();
                Player lastCombatTarget = UT2.this.getAgentMemory().lastCombatTarget;
                Location agent = UT2.this.info.getLocation();
                if (disappeared != null) {
                    UT2.this.getAgentMemory().playerDisappearedTimes.put(disappeared.getId(), UT2.this.game.getTime());
                    if (lastCombatTarget != null && disappeared.getId().equals((Object)lastCombatTarget.getId())) {
                        Location enemy = disappeared.getLocation();
                        if (agent != null && enemy != null && (agent = new Location(agent.x, agent.y, 0.0)).getDistance(enemy = new Location(enemy.x, enemy.y, 0.0)) < 600.0) {
                            UT2.this.quickTurn("Disappeared While Close");
                        }
                        UT2.this.getAgentMemory().lastCombatTarget = null;
                    }
                }
            }
        }
    };
    IWorldEventListener<AddInventoryMsg> addInventoryHandler = new IWorldEventListener<AddInventoryMsg>(){

        public void notify(AddInventoryMsg add) {
            if (printActions) {
                System.out.println(UT2.this.getIdentifier() + ":Added " + add.getType());
            }
            if (add.getDescriptor().getItemCategory().equals((Object)ItemType.Category.WEAPON)) {
                ((DistantPathController)((UT2)UT2.this).pathController).focused = false;
                UT2.this.equipBestWeapon(true);
            }
        }
    };
    IWorldEventListener<PlayerKilled> playerKilledHandler = new IWorldEventListener<PlayerKilled>(){

        public void notify(PlayerKilled pk) {
            UnrealId dead = pk.getId();
            UT2.this.getAgentMemory().targetDies(dead);
            UT2.this.chaseController.enemyDies(dead);
        }
    };
    IWorldEventListener<BotDamaged> botDamagedHandler = new IWorldEventListener<BotDamaged>(){

        public void notify(BotDamaged bd) {
            ((DistantPathController)((UT2)UT2.this).pathController).focused = false;
            Player p = UT2.this.getAgentMemory().getCombatTarget();
            if (p == null && bd.getInstigator() == null && UT2.this.getAgentMemory().getCombatTarget() == null && UT2.this.canFight()) {
                UT2.this.quickTurn("Unseen Damager");
            }
        }
    };
    public static final boolean RECORDING;
    public static final boolean TIMING;
    private long[] timing = new long[10];
    public static final boolean UNSTUCK = true;
    public static final boolean SHIELD_GUN = true;
    public static final boolean IMPORTANT = true;
    public static final boolean OBSERVE = false;
    public static final boolean JUDGE = true;
    public static final boolean BATTLE = true;
    public static final boolean PURSUIT = true;
    public static boolean RETRACE;
    public static final boolean PATH = true;
    public static final int STUCK_INDEX_SAME_NAV = 0;
    public static final int STUCK_INDEX_STILL = 1;
    public static final int STUCK_INDEX_COLLIDING = 2;
    public static final int STUCK_INDEX_BUMPING = 3;
    public static final int STUCK_INDEX_UNKNOWN = 4;
    public static final int STUCK_INDEX_OFF_GRID = 5;
    public static final int STUCK_INDEX_NO_PROGRESS = 6;
    public static final int STUCK_INDEX_WATER_REPEAT = 7;
    public static final int STUCK_INDEX_COLLISION_FREQUENCY = 8;
    public static final int STUCK_INDEX_UNDER_ELEVATOR = 9;
    public static final int STUCK_IN_WATER = 10;
    public static final boolean USE_UNDER_ELEVATOR = true;
    public static final boolean USE_SAME_NAV = true;
    public static final boolean USE_STILL = true;
    public static final boolean USE_COLLIDING = true;
    public static final boolean USE_BUMPING = false;
    public static final boolean USE_OFF_GRID = true;
    public static final boolean USE_COLLISION_FREQUENCY = true;
    private ItemType testing_desiredWeapon = null;

    private boolean grendelKeepRim() {
        String id;
        NavPoint nearest;
        Location botLoc;
        if (this.game.getMapName().equals("DM-DE-GrendelKeep") && (botLoc = this.bot.getLocation()) != null && botLoc.z < -398.1 && (nearest = this.info.getNearestNavPoint()) != null && ((id = nearest.getId().getStringId()).equals("DM-DE-GrendelKeep.InventorySpot521") || id.equals("DM-DE-GrendelKeep.InventorySpot518") || id.equals("DM-DE-GrendelKeep.InventorySpot517") || id.equals("DM-DE-GrendelKeep.InventorySpot538") || id.equals("DM-DE-GrendelKeep.InventorySpot562") || id.equals("DM-DE-GrendelKeep.InventorySpot506") || id.equals("DM-DE-GrendelKeep.PathNode25") || id.equals("DM-DE-GrendelKeep.PathNode34") || id.equals("DM-DE-GrendelKeep.PathNode27") || id.equals("DM-DE-GrendelKeep.PathNode28") || id.equals("DM-DE-GrendelKeep.PathNode29") || id.equals("DM-DE-GrendelKeep.PathNode30") || id.equals("DM-DE-GrendelKeep.PathNode32"))) {
            System.out.println("\tGrendelKeep Rim");
            return true;
        }
        return false;
    }

    public static boolean canJudge() {
        return !evolving;
    }

    public void prepareBot(UT2004Bot bot) {
        UT2Parameters params = (UT2Parameters)bot.getParams();
        this.battleController = params.getBattleController();
        this.server = params.getServer();
        this.initActionLog(this.battleController.filename);
        if (!evolving || Constants.LOG_CONTROLLER_EVALUATIONS.getBoolean()) {
            this.logAtEnd = true;
            this.actions.register("Quick Turn");
            this.actions.register("Unstuck");
            this.actions.register("Observe");
            this.actions.register("Get Dropped Weapon");
            this.actions.register("Important Item");
            this.actions.register("Get Weapon");
            this.actions.register("Trace To Weapon");
            this.actions.register("Judge");
            this.actions.register("Shield Gun");
            this.actions.register("Battle");
            this.actions.register("Chase");
            this.actions.register("Retrace");
            this.actions.register("Path");
            this.actions.register("Empty");
            this.actions.register("Die");
            this.stuckTriggers.register("Same Navpoint");
            this.stuckTriggers.register("Collision Frequency");
            this.stuckTriggers.register("Still");
            this.stuckTriggers.register("Collision");
            this.stuckTriggers.register("Agent Bump");
            this.stuckTriggers.register("Off Grid");
            this.stuckTriggers.register("Unknown");
            this.stuckTriggers.register("Under Elevator");
            this.stuckTriggers.register("Water Trap");
        }
        if (weaponPreferences == null) {
            weaponPreferences = new WeaponPreferenceTable();
        }
        this.humanTraceController = evolving ? null : new HumanRetraceController();
        this.unstuckController = new UnstuckController(this.humanTraceController);
        this.observingController = new ObservingController(this.battleController);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName(Constants.BOT_NAME.get());
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.getLog().setLevel(Level.OFF);
        this.getMapName();
        if (!evolving) {
            this.judgingController = new JudgingController(this.getAgentMemory(), this.battleController);
        }
        this.chaseController = new ChasingController(this.bot, this.getAgentMemory());
        this.pathController = new DistantPathController(this.bot, this.getAgentMemory().itemPathExecutor, this.getAgentMemory().pathPlanner, this.getAgentMemory());
        this.shieldGunController = new ShieldGunController(this.pathController);
        String map = this.game.getMapName();
        if (map.toLowerCase().equals("DM-GoatswoodPlay".toLowerCase()) || map.toLowerCase().equals("DM-IceHenge".toLowerCase())) {
            this.waterController = new WaterController();
        }
        if (this.humanTraceController != null) {
            this.humanTraceController.onBotInitialized(this.getAgentMemory());
        }
        this.unstuckController.onBotInitialized(this.getAgentMemory());
        this.battleController.registerActions();
        this.battleController.prepareSensorModel(this.getAgentBody());
        this.getAgentBody().finalAutoTraceDecision();
        this.getWorldView().addEventListener(PlayerKilled.class, this.playerKilledHandler);
        this.getWorldView().addEventListener(AddInventoryMsg.class, this.addInventoryHandler);
        this.getWorldView().addEventListener(BotDamaged.class, this.botDamagedHandler);
        this.getWorldView().addObjectListener(Player.class, WorldObjectDisappearedEvent.class, this.playerDisappeared);
    }

    public boolean quickTurn(String reason) {
        if (this.game.getTime() - this.getAgentMemory().lastQuickTurn > 2.5 && !this.actions.lastActionLabel().equals("Chase")) {
            this.pathController.stop();
            this.getAgentMemory().lastQuickTurn = this.game.getTime();
            this.actions.takeAction("Quick Turn");
            if (printActions) {
                String label = this.getIdentifier() + ":QUICK_TURN:" + reason;
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label);
                }
            }
            new QuickTurnAction(this.getAgentMemory()).execute(this.getAgentBody());
            return true;
        }
        return false;
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.notMoving = 0;
        this.resetControllers();
    }

    @Override
    public void logic() throws PogamutException {
        boolean turned;
        this.timingStart();
        super.logic();
        this.timingStep();
        this.getAgentMemory().seeEnemy();
        this.getAgentMemory().consecutiveJudgeActions = this.actions.lastActionLabel().equals("Judge") ? ++this.getAgentMemory().consecutiveJudgeActions : 0;
        if (this.getAgentBody().veryCloseFrontWall() && (turned = this.quickTurn("Facing Wall"))) {
            return;
        }
        if (!this.getAgentBody().isMoving()) {
            ++this.notMoving;
        }
        this.timingStep();
        this.chaseController.countdown();
        this.chaseController.updateEnemyMemory(this.getAgentMemory());
        this.timingStep();
        if (!this.usingLinkGun()) {
            this.equipBestWeapon();
        }
        this.timingStep();
        this.action = this.getAction();
        if (this.humanTraceController != null && !this.actions.lastActionLabel().equals("Retrace") && !this.actions.lastActionLabel().equals("Unstuck")) {
            this.humanTraceController.reset();
        }
        this.timingStep();
        if (this.action instanceof StillAction) {
            this.notMoving = 0;
            this.sameNavInstances = 0;
        }
        this.timingStep();
        this.action.execute(this.getAgentBody());
        if (TIMING) {
            this.timingStep();
            this.timingEnd();
        }
        this.getAgentMemory().updatePosition();
    }

    private String getMapName() {
        if (this.cachedMap == null) {
            this.cachedMap = this.game.getMapName();
            System.out.println("Map is: " + this.cachedMap);
        }
        return this.cachedMap;
    }

    private String getIdentifier() {
        if (this.cachedName == null || this.cachedName.startsWith(Constants.BOT_NAME.get())) {
            this.cachedName = this.info.getName();
            this.cachedName = this.cachedName == null || this.cachedName.startsWith(Constants.BOT_NAME.get()) ? Constants.BOT_NAME.get() : this.cachedName;
        }
        return this.cachedName;
    }

    private Action getAction() {
        String id;
        Map shields;
        String id2;
        boolean shouldJudge;
        Item closest;
        Action result;
        Location botLoc;
        StringBuilder label = new StringBuilder();
        label.append(this.getIdentifier());
        label.append(":");
        Player target = this.getAgentMemory().getCombatTarget();
        if (target == null || !target.isVisible()) {
            Weapon w = this.weaponry.getCurrentWeapon();
            if (w != null && w.getType().equals((Object)ItemType.BIO_RIFLE) && !this.info.isSecondaryShooting().booleanValue() && this.weaponry.getCurrentAlternateAmmo() >= 9) {
                this.body.getShooting().shootSecondary();
            }
            if (this.info.isShooting().booleanValue()) {
                this.getAgentBody().stopShoot();
            }
        }
        if ((botLoc = this.info.getLocation()) == null) {
            System.out.println("\tDon't know where bot is");
            return new EmptyAction();
        }
        double nearestNavDistance = Double.MAX_VALUE;
        NavPoint nearestNav = this.info.getNearestNavPoint();
        if (nearestNav != null && nearestNav.getLocation() != null) {
            nearestNavDistance = nearestNav.getLocation().getDistance(botLoc);
        }
        this.unstuckController.decay();
        if (this.getAgentMemory().underElevator() || this.sameNavInstances > 15 || this.waterController != null && this.actions.lastActionLabel().equals("Unstuck") && this.getAgentMemory().inWater() || this.notMoving > 8 || this.senses.isColliding() && !this.actions.lastActionLabel().equals("Retrace") || this.unstuckController.stuckFromFrequentCollisions() || nearestNavDistance > 600.0) {
            int stuckReason;
            if (this.getAgentMemory().underElevator()) {
                stuckReason = 9;
                this.stuckTriggers.takeAction("Under Elevator");
            } else if (this.waterController != null && this.getAgentMemory().inWater()) {
                stuckReason = 10;
                this.stuckTriggers.takeAction("Water Trap");
            } else if (this.sameNavInstances > 15) {
                stuckReason = 0;
                this.stuckTriggers.takeAction("Same Navpoint");
            } else if (this.unstuckController.stuckFromFrequentCollisions()) {
                stuckReason = 8;
                this.stuckTriggers.takeAction("Collision Frequency");
            } else if (this.notMoving > 8) {
                stuckReason = 1;
                this.stuckTriggers.takeAction("Still");
            } else if (this.senses.isColliding() && !this.actions.lastActionLabel().equals("Retrace")) {
                stuckReason = 2;
                this.stuckTriggers.takeAction("Collision");
            } else if (nearestNavDistance > 600.0) {
                stuckReason = 5;
                this.stuckTriggers.takeAction("Off Grid");
            } else {
                stuckReason = 4;
                this.stuckTriggers.takeAction("Unknown");
            }
            this.chaseController.wasStuck = true;
            this.pathController.wasStuck = true;
            this.getAgentMemory().stopPathExecutors();
            this.notMoving = 0;
            result = stuckReason == 10 ? this.waterController.control(this.getAgentMemory()) : this.unstuckController.control(this.getAgentMemory(), stuckReason);
            if (result != null) {
                this.actions.takeAction("Unstuck");
                if (printActions) {
                    label.append(this.unstuckController.consecutiveStuckActions);
                    label.append(":UNSTUCK:");
                    label.append(this.stuckTriggers.lastActionLabel());
                    label.append(":");
                    label.append(result);
                    System.out.println(label);
                    if (!this.ANONYMOUS_NAME) {
                        this.config.setName(label.toString());
                    }
                }
                return result;
            }
        }
        this.unstuckController.tick(this.getAgentMemory());
        this.unstuckController.reset();
        if (this.waterController != null) {
            this.waterController.reset();
        }
        Map weapons = this.items.getVisibleItems(ItemType.Category.WEAPON);
        for (Item weapon : weapons.values()) {
            if (!weapon.isDropped() || !weapon.isVisible() || !(weapon.getLocation().getDistance(botLoc) < (double)Constants.NEAR_ITEM_DISTANCE.getInt())) continue;
            result = new GotoItemAction(this.getAgentMemory(), weapon, true, false, false);
            this.actions.takeAction("Get Dropped Weapon");
            if (printActions) {
                label.append("GET_DROPPED_WEAPON:");
                label.append(weapon.getType().getName());
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        Collection<Item> important = this.getAllVeryImportantItems(this.getAgentMemory());
        if (!important.isEmpty() && (closest = (Item)DistanceUtils.getNearest(important, (ILocated)botLoc)).getLocation().getDistance(botLoc) < (double)Constants.NEAR_ITEM_DISTANCE.getInt() && closest.getLocation().getDistanceZ(botLoc) < (double)Constants.NEAR_ITEM_HEIGHT.getInt()) {
            result = ((DistantPathController)this.pathController).getItem(this.getAgentMemory(), closest);
            this.actions.takeAction("Important Item");
            if (printActions) {
                label.append("IMPORTANT:");
                label.append(closest.getType().getName());
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        boolean hasGoodWeapon = weaponPreferences.hasGoodWeapon(this.weaponry.getLoadedRangedWeapons(), this.players, this.getAgentMemory());
        if (!hasGoodWeapon && this.itemPathControllerNotDoingAnythingImportant() && (result = ((DistantPathController)this.pathController).getNeededWeapon(this.getAgentMemory())) != null) {
            this.actions.takeAction("Get Weapon");
            String name = this.pathController.itemName();
            if (printActions) {
                label.append("GET_WEAPON:");
                label.append(this.pathController.lastActionLabel());
                label.append(":");
                label.append(name);
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        Weapon current = this.weaponry.getCurrentWeapon();
        double distance = Double.MAX_VALUE;
        if (target != null && target.getLocation() != null) {
            distance = target.getLocation().getDistance(this.info.getLocation());
        }
        boolean canFight = this.canFight();
        boolean bl = shouldJudge = this.judgingController.shouldJudge(this.getAgentMemory()) || this.consecutiveObservations > 10;
        if (target != null && UT2.canJudge() && !this.info.hasUDamage().booleanValue() && canFight && shouldJudge && (result = this.judgingController.control(this.getAgentMemory())) != null) {
            this.chaseController.abort();
            this.pathController.stop();
            this.actions.takeAction("Judge");
            if (printActions) {
                label.append("JUDGE:");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        this.consecutiveObservations = 0;
        if (this.actions.lastActionLabel().equals("Observe")) {
            this.equipBestWeapon(true);
        }
        if (this.usingShieldGun() && (result = this.shieldGunController.control(this.getAgentMemory())) != null) {
            this.actions.takeAction("Shield Gun");
            if (printActions) {
                label.append("SHIELD_GUN:");
                label.append(this.weaponry.getCurrentAmmo());
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        this.shieldGunController.reset();
        if (this.shouldFight(target) && !this.shouldChase(target) && !this.usingLinkGun() && target != null && this.canFight() && (result = this.battleController.control(this.getAgentMemory())) != null) {
            this.chaseController.abort();
            this.pathController.stop();
            this.actions.takeAction("Battle");
            Weapon w = this.weaponry.getCurrentWeapon();
            if (printActions) {
                label.append("BATTLE:");
                label.append(w.getType().getName());
                label.append(":");
                label.append(this.weaponry.getCurrentPrimaryAmmo());
                label.append(":");
                label.append(this.weaponry.getCurrentAlternateAmmo());
                label.append(":");
                label.append(this.getAgentMemory().getCombatTarget().getName());
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        if (this.shouldFight(target) && this.chaseController.enemyAvailable() && (result = this.chaseController.control(this.getAgentMemory())) != null) {
            this.pathController.stop();
            this.actions.takeAction("Chase");
            if (printActions) {
                label.append("CHASE:");
                label.append(this.chaseController.timeOut);
                label.append(":");
                label.append(this.chaseController.lastActionLabel());
                label.append(":");
                label.append(this.chaseController.chaseTargetName(this.getAgentMemory()));
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        NavPoint nearest = this.info.getNearestNavPoint();
        String map = this.game.getMapName();
        if (map.toLowerCase().equals("DM-Curse4".toLowerCase()) && nearest != null) {
            NavPoint navTarget;
            id2 = nearest.getId().getStringId();
            if (id2.equals(map + ".InventorySpot93") || id2.equals(map + ".InventorySpot92") || id2.equals(map + ".PathNode48")) {
                System.out.println("By secret UDamage in Curse4");
                Map uDamage = this.items.getSpawnedItems(ItemType.U_DAMAGE_PACK);
                if (!uDamage.isEmpty()) {
                    for (Item i : uDamage.values()) {
                        System.out.println("SPECIAL:Setting up door shoot");
                        this.getBody().getLocomotion().strafeTo((ILocated)this.getAgentMemory().getNavPoint(map + ".InventorySpot93"), (ILocated)i.getLocation());
                        if (!this.getInfo().isFacing((ILocated)i.getLocation()).booleanValue()) continue;
                        System.out.println("SPECIAL:Shoot open UDamage door");
                        this.getBody().getShooting().shootPrimary((ILocated)i.getLocation());
                    }
                    return new EmptyAction();
                }
            }
            if (id2.equals(map + ".LiftCenter1") && botLoc.z > 450.0) {
                System.out.println("SPECIAL:Step off elevator");
                navTarget = this.getAgentMemory().getNavPoint(map + ".PathNode44");
                this.getBody().getLocomotion().strafeTo((ILocated)navTarget, (ILocated)navTarget);
                return new EmptyAction();
            }
            if (id2.equals(map + ".LiftExit2") || id2.equals(map + ".PathNode44")) {
                System.out.println("SPECIAL:Move further from elevator");
                navTarget = this.getAgentMemory().getNavPoint(map + ".PathNode16");
                this.getBody().getLocomotion().strafeTo((ILocated)navTarget, (ILocated)navTarget);
                return new EmptyAction();
            }
            if ((id2.equals(map + ".PathNode57") || id2.equals(map + ".PathNode90") || id2.equals(map + ".InventorySpot54") && this.getAgentMemory().facingNavPoint(map + ".PathNode57", 45.0)) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot99")) != null) {
                System.out.println("SPECIAL:Path through Curse4 shaft");
                return result;
            }
        }
        if (map.toLowerCase().equals("DM-Antalus".toLowerCase()) && nearest != null && ((id2 = nearest.getId().getStringId()).equals(map + ".PlayerStart0") || id2.equals(map + ".PathNode39") || id2.equals(map + ".PathNode21") || id2.equals(map + ".PathNode38"))) {
            shields = this.items.getSpawnedItems(ItemType.SUPER_SHIELD_PACK);
            if (!shields.isEmpty()) {
                for (Item i : shields.values()) {
                    this.getBody().getLocomotion().strafeTo((ILocated)i.getLocation(), (ILocated)i.getLocation());
                    result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot97");
                    if (result == null) continue;
                    System.out.println("SPECIAL:Get the shield pack in Antalus cave");
                    return result;
                }
            }
            if ((result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot103")) != null) {
                System.out.println("SPECIAL:Path to UDamage in Antalus");
                return result;
            }
        }
        if (map.toLowerCase().equals("DM-DE-GrendelKeep".toLowerCase()) && nearest != null && ((id2 = nearest.getId().getStringId()).equals(map + ".LiftCenter3") || id2.equals(map + ".LiftExit10") || id2.equals(map + ".InventorySpot532"))) {
            System.out.println("Exiting problem elevator in GrendelKeep");
            shields = this.items.getSpawnedItems(ItemType.SUPER_SHIELD_PACK);
            if (!shields.isEmpty()) {
                for (Item i : shields.values()) {
                    System.out.println("SPECIAL:Get the shield pack");
                    this.getBody().getLocomotion().strafeTo((ILocated)i.getLocation(), (ILocated)i.getLocation());
                }
                return new EmptyAction();
            }
            result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot558");
            if (result != null) {
                System.out.println("SPECIAL:Path from GrendelKeep platform");
                return result;
            }
        }
        if (map.toLowerCase().equals("DM-DE-Osiris2".toLowerCase()) && nearest != null) {
            NavPoint liftCenter2 = this.getAgentMemory().getNavPoint(map + ".LiftCenter2");
            Map uDamages = this.items.getSpawnedItems(ItemType.U_DAMAGE_PACK);
            if (!uDamages.isEmpty() && liftCenter2.isVisible() && this.info.isFacing((ILocated)liftCenter2).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot17")) != null) {
                System.out.println("SPECIAL:Goto elevator to get UDamage in Osiris2");
                return result;
            }
            id = nearest.getId().getStringId();
            if (botLoc.z > -90.0 && (id.equals(map + ".LiftCenter3") || id.equals(map + ".LiftCenter2") || id.equals(map + ".LiftExit3") || id.equals(map + ".LiftExit4")) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot17")) != null) {
                System.out.println("SPECIAL:Goto UDamage from elevator in Osiris2");
                return result;
            }
            if ((id.equals(map + ".PathNode13") && this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode14"), 60.0).booleanValue() || id.equals(map + ".PathNode68") && this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode69"), 60.0).booleanValue()) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot11")) != null) {
                System.out.println("SPECIAL:Goto underground Lightning Gun in Osiris2");
                return result;
            }
            if (id.equals(map + ".PathNode13") && this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode9"), 60.0).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot12")) != null) {
                System.out.println("SPECIAL:Goto Flak Cannon in Osiris2");
                return result;
            }
            if (id.equals(map + ".PathNode68") && this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode65"), 60.0).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot13")) != null) {
                System.out.println("SPECIAL:Goto Shock Rifle in Osiris2");
                return result;
            }
        }
        if (map.toLowerCase().equals("DM-Asbestos".toLowerCase()) && nearest != null) {
            NavPoint pathNode180 = this.getAgentMemory().getNavPoint(map + ".PathNode180");
            NavPoint rocketLauncherInWater = this.getAgentMemory().getNavPoint(map + ".InventorySpot18");
            id = nearest.getId().getStringId();
            if ((id.equals(map + ".LiftExit3") || id.equals(map + ".LiftCenter1") && botLoc.z > 700.0) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot16")) != null) {
                System.out.println("SPECIAL:Goto Lightning Gun after leaving elevator in Asbestos");
                return result;
            }
            if ((id.equals(map + ".LiftExit1") || id.equals(map + ".LiftCenter0") && botLoc.z > 440.0) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot29")) != null) {
                System.out.println("SPECIAL:Goto UDamage after leaving elevator in Asbestos");
                return result;
            }
            if (id.equals(map + ".PathNode177") && this.info.isFacing((ILocated)pathNode180, 60.0).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot57")) != null) {
                System.out.println("SPECIAL:Round corner of ditch in Asbestos");
                return result;
            }
            if ((id.equals(map + ".PlayerStart11") || id.equals(map + ".PlayerStart57")) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".PathNode37")) != null) {
                System.out.println("SPECIAL:Escape ditch in Asbestos");
                return result;
            }
            if (id.equals(map + ".PathNode185")) {
                if (this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode92"), 60.0).booleanValue()) {
                    result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot28");
                    if (result != null) {
                        System.out.println("SPECIAL:Go up stairs1 in Asbestos");
                        return result;
                    }
                } else if (this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode25"), 60.0).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot27")) != null) {
                    System.out.println("SPECIAL:Go down stairs1 in Asbestos");
                    return result;
                }
            }
            if (id.equals(map + ".PathNode10")) {
                if (this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode11"), 60.0).booleanValue()) {
                    result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot28");
                    if (result != null) {
                        System.out.println("SPECIAL:Go up stairs2 in Asbestos");
                        return result;
                    }
                } else if (this.info.isFacing((ILocated)this.getAgentMemory().getNavPoint(map + ".PathNode9"), 60.0).booleanValue() && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".PathNode2")) != null) {
                    System.out.println("SPECIAL:Go down stairs2 in Asbestos");
                    return result;
                }
            }
            if ((id.equals(map + ".PathNode184") || id.equals(map + ".PathNode92")) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".PathNode11")) != null) {
                System.out.println("SPECIAL:Avoid corner at top of stairs in Asbestos");
                return result;
            }
            if (rocketLauncherInWater.isVisible()) {
                if (id.equals(map + ".InventorySpot37")) {
                    result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".PathNode122");
                    if (result != null) {
                        System.out.println("SPECIAL:Go left around water pool in Asbestos");
                        return result;
                    }
                } else if ((id.equals(map + ".InventorySpot38") || id.equals(map + ".PathNode0")) && (result = ((DistantPathController)this.pathController).proceedToNavPoint(map + ".InventorySpot8")) != null) {
                    System.out.println("SPECIAL:Go right around water pool in Asbestos");
                    return result;
                }
            }
        }
        if (RETRACE && this.humanTraceController != null && !this.grendelKeepRim() && !this.getPlayers().canSeeEnemies() && !this.getAgentMemory().nearElevator() && !this.getAgentMemory().underElevator() && this.game.getTime() - this.lastRetraceFailure > Constants.RETRACE_REBOOT_DELAY.getDouble() && this.itemPathControllerNotDoingAnythingImportant()) {
            result = this.humanTraceController.control(this.getAgentMemory());
            if (result != null) {
                if (!this.actions.lastActionLabel().equals("Retrace")) {
                    this.pathController.stop();
                    ((DistantPathController)this.pathController).pathEvent(true);
                }
                this.actions.takeAction("Retrace");
                if (printActions) {
                    label.append("RETRACE:");
                    label.append(this.humanTraceController.lastActionLabel());
                    label.append(":");
                    label.append(result);
                    System.out.println(label);
                    if (!this.ANONYMOUS_NAME) {
                        this.config.setName(label.toString());
                    }
                }
                return result;
            }
            if (printActions) {
                label.append("ABORT RETRACE:");
                label.append(this.humanTraceController.lastActionLabel());
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
                label = new StringBuilder();
                label.append(this.getIdentifier());
                label.append(":");
            }
        }
        if (this.actions.lastActionLabel().equals("Retrace")) {
            this.pathController.retraceFailed = true;
        }
        result = this.pathController.control(this.getAgentMemory());
        if (this.waterController != null && this.getAgentMemory().inWater() && !(result instanceof EmptyAction) && (result = this.waterController.control(this.getAgentMemory())) != null) {
            this.actions.takeAction("Path");
            if (printActions) {
                label.append("WATER:");
                label.append("Escape Water");
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        if (result != null) {
            String name;
            this.actions.takeAction("Path");
            String string = name = this.pathController.getItem() == null ? "" : this.pathController.getItem().getType().getName();
            if (printActions) {
                label.append("PATH:");
                label.append(this.pathController.lastActionLabel());
                label.append(":");
                label.append(name);
                label.append(":");
                label.append(result);
                System.out.println(label);
                if (!this.ANONYMOUS_NAME) {
                    this.config.setName(label.toString());
                }
            }
            return result;
        }
        this.actions.takeAction("Empty");
        result = new EmptyAction();
        if (printActions) {
            label.append("EMPTY:");
            label.append(result);
            System.out.println(label);
            if (!this.ANONYMOUS_NAME) {
                this.config.setName(label.toString());
            }
        }
        return result;
    }

    public boolean usingShieldGun() {
        Weapon current = this.weaponry.getCurrentWeapon();
        return current != null && current.getType().equals((Object)ItemType.SHIELD_GUN);
    }

    public boolean usingLinkGun() {
        Weapon current = this.weaponry.getCurrentWeapon();
        return current != null && current.getType().equals((Object)ItemType.LINK_GUN);
    }

    public boolean equipBestWeapon() {
        return this.equipBestWeapon(false);
    }

    public boolean equipBestWeapon(boolean added) {
        boolean hasGoodWeapon = weaponPreferences.hasGoodWeapon(this.weaponry.getLoadedRangedWeapons(), this.players, this.getAgentMemory());
        Weapon recommendation = UT2.weaponPreferences.savedRec;
        Weapon current = this.getAgentMemory().weaponry.getCurrentWeapon();
        double distance = 2499.0;
        if (this.players.canSeeEnemies() && this.getAgentMemory().getCombatTarget() != null && this.getAgentMemory().getCombatTarget().getLocation() != null && this.info.getLocation() != null) {
            distance = Triple.distanceInSpace(this.getAgentMemory().getCombatTarget().getLocation(), this.info.getLocation());
        }
        if (!(added || current == null || current.getType().equals((Object)ItemType.LINK_GUN) || current.getType().equals((Object)ItemType.BIO_RIFLE) || current.getType().equals((Object)ItemType.ASSAULT_RIFLE) || current.getType().equals((Object)ItemType.LIGHTNING_GUN) || current.getType().equals((Object)ItemType.SNIPER_RIFLE) || current.getType().equals((Object)ItemType.SHIELD_GUN) || this.getAgentBody().isSecondaryChargingWeapon(current) && this.info.isSecondaryShooting().booleanValue() || !this.getAgentMemory().isThreatened() && !this.getAgentMemory().isThreatening(this.getAgentMemory().getCombatTarget()) && !this.info.isShooting().booleanValue() && !(distance < 600.0) || !this.weaponry.hasAmmoForWeapon(current.getType()))) {
            return hasGoodWeapon;
        }
        if (this.testing_desiredWeapon != null) {
            if (current != null && !current.getType().equals((Object)this.testing_desiredWeapon) && this.weaponry.hasWeapon(this.testing_desiredWeapon)) {
                this.weaponry.changeWeapon(this.testing_desiredWeapon);
            }
            return hasGoodWeapon;
        }
        if (!(recommendation == null || recommendation == null || current != null && current.getType().equals((Object)recommendation.getType()))) {
            this.weaponry.changeWeapon(recommendation);
            this.getAgentMemory().weaponSwitchTime = this.game.getTime();
        }
        if ((current = this.weaponry.getCurrentWeapon()) == null || this.weaponry.getCurrentAmmo() == 0) {
            Map loadedWeapons = this.weaponry.getLoadedWeapons();
            for (Weapon x : loadedWeapons.values()) {
                ItemType t = x.getType();
                if (t.equals((Object)ItemType.LINK_GUN) || t.equals((Object)ItemType.SHIELD_GUN) || t.equals((Object)ItemType.ONS_GRENADE_LAUNCHER) || this.weaponry.getAmmo(t) <= 0 || (current = this.weaponry.getCurrentWeapon()) != null && current.getType().equals((Object)t)) continue;
                this.weaponry.changeWeapon(t);
                if (this.weaponry.getCurrentAmmo() <= 0 && this.weaponry.getAmmo(t) <= 0) continue;
                return hasGoodWeapon;
            }
        }
        if ((current = this.weaponry.getCurrentWeapon()) != null && this.weaponry.getCurrentAmmo() == 0 && this.weaponry.getAmmo(current.getType()) == 0) {
            this.weaponry.changeWeapon(ItemType.SHIELD_GUN);
            return false;
        }
        return hasGoodWeapon;
    }

    public void botKilled(BotKilled event) {
        this.lastTargetObserved = null;
        super.botKilled(event);
        if (event.isCausedByWorld() && this.pathController.getItem() != null) {
            this.pathController.tabooItems.add((Object)this.pathController.getItem(), 30.0);
        }
        this.getAgentMemory().lastCombatTarget = null;
        this.actions.takeAction("Die");
        this.resetControllers();
    }

    @Override
    public void botShutdown() {
        if (this.humanTraceController != null) {
            this.humanTraceController.onBotShutdown(this.getAgentMemory());
        }
        if (this.unstuckController != null) {
            this.unstuckController.onBotShutdown(this.getAgentMemory());
        }
        if (!evolving && this.logAtEnd) {
            this.saveActionLog();
        }
        super.botShutdown();
    }

    public void saveActionLog() {
        String map = this.getMapName();
        String name = this.getIdentifier();
        if (map == null || name == null) {
            return;
        }
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        try {
            this.actionLog = new PrintWriter(new FileOutputStream(new File(df.format(date) + "-" + map + "-" + name + "-" + this.actionLogFilename)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(UT2.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("COULD NOT CREATE LOG!");
        }
        this.actionLog.println("Log for " + name);
        this.actionLog.println("Using: " + this.battleController.filename);
        this.actionLog.println("Map: " + map);
        this.actionLog.println("Score: " + this.info.getScore());
        this.actionLog.println("Suicides: " + this.info.getSuicides());
        this.actionLog.println("Deaths: " + this.info.getDeaths());
        this.actionLog.println("Kills: " + this.info.getKills());
        this.actionLog.println();
        this.actionLog.println("PLAYER SCORES");
        Set<String> keys = this.judgingController.playerScores.keySet();
        for (String p : keys) {
            this.actionLog.println("PLAYER:" + p + " has " + this.judgingController.playerScores.get(p));
        }
        this.actionLog.println();
        this.actions.logActionChoices(this.actionLog);
        this.stuckTriggers.logActionChoices(this.actionLog);
        this.unstuckController.logActionChoices(this.actionLog);
        this.battleController.logActionChoices(this.actionLog);
        this.shieldGunController.logActionChoices(this.actionLog);
        this.pathController.logActionChoices(this.actionLog);
        this.chaseController.logActionChoices(this.actionLog);
        if (this.humanTraceController != null) {
            this.humanTraceController.logActionChoices(this.actionLog);
        }
        this.actionLog.close();
    }

    public void resetControllers() {
        this.getAgentMemory().consecutiveJudgeActions = 0;
        this.getAgentMemory().resetWaterMemory();
        this.unstuckController.reset();
        this.observingController.reset();
        if (this.humanTraceController != null) {
            this.humanTraceController.reset();
        }
        this.battleController.reset();
        this.pathController.stop();
        this.chaseController.reset();
        if (this.judgingController != null) {
            this.judgingController.reset();
        }
        if (this.waterController != null) {
            this.waterController.reset();
        }
        this.getAgentMemory().itemPathExecutor.stop();
        this.getAgentMemory().playerPathExecutor.stop();
    }

    private Collection<Item> getAllVeryImportantItems(AgentMemory memory) {
        HashMap tempMap = new HashMap();
        tempMap.putAll(memory.items.getSpawnedItems(ItemType.U_DAMAGE_PACK));
        tempMap.putAll(memory.items.getSpawnedItems(ItemType.SUPER_HEALTH_PACK));
        tempMap.putAll(memory.items.getSpawnedItems(ItemType.SUPER_SHIELD_PACK));
        tempMap.putAll(memory.items.getSpawnedItems(ItemType.Category.ARMOR));
        tempMap.putAll(memory.items.getSpawnedItems(ItemType.Category.WEAPON));
        if (memory.info.getHealth() < Constants.MINIMUM_BATTLE_HEALTH.getInt()) {
            Map healths = memory.items.getSpawnedItems(ItemType.Category.HEALTH);
            tempMap.putAll(healths);
        }
        Collection<Item> result = tempMap.values();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            Item item = (Item)itr.next();
            if (!(item.getLocation().getDistance(this.getInfo().getLocation()) > (double)Constants.NEAR_ITEM_DISTANCE.getInt() || this.getAgentMemory().isBeneathMe((ILocated)item) || UT2.canJudge() && item.getType().equals((Object)ItemType.LINK_GUN) || memory.hasWeaponOfType(item.getType())) && (item.getNavPointId() == null || !(item.getNavPointId().getStringId().equals("DM-Antalus.InventorySpot127") || item.getNavPointId().getStringId().equals("DM-DE-GrendelKeep.InventorySpot561") || item.getNavPointId().getStringId().equals("DM-Asbestos.InventorySpot18") && !this.info.getNearestNavPoint().getId().getStringId().equals("DM-Asbestos.PathNode122") && !this.info.getNearestNavPoint().getId().getStringId().equals("DM-Asbestos.PathNode196") && !this.info.getNearestNavPoint().getId().getStringId().equals("DM-Asbestos.PathNode198") && !this.info.getNearestNavPoint().getId().getStringId().equals("DM-Asbestos.PathNode119") || item.getNavPointId().getStringId().equals("DM-Curse4.InventorySpot81") && !item.isVisible() && this.info.isFacing((ILocated)item.getLocation(), 110.0) != false || item.getNavPointId().getStringId().equals("DM-Asbestos.InventorySpot45")) && !item.getNavPointId().getStringId().equals("DM-Compressed.InventorySpot98"))) continue;
            itr.remove();
        }
        return result;
    }

    public boolean shouldChase(Player currentTarget) {
        Player chasingEnemy = this.chaseController.getLastEnemy();
        if (currentTarget != null && chasingEnemy != null && currentTarget.getId().equals((Object)chasingEnemy.getId())) {
            return false;
        }
        Player nearest = this.getAgentMemory().getSeeEnemy();
        if (this.getAgentMemory().numVisibleOpponents() > 2 && nearest != null && nearest.getLocation().getDistance(this.info.getLocation()) < 2500.0) {
            return false;
        }
        return this.getAgentMemory().canFocusOn(chasingEnemy);
    }

    public boolean shouldFight(Player target) {
        boolean result;
        boolean bl = result = this.equipBestWeapon() || this.info.hasUDamage() != false;
        if (target != null && target.getLocation() != null && this.info.getLocation() != null) {
            ItemType myWeaponType;
            double distance = target.getLocation().getDistance(this.info.getLocation());
            ItemType enemyWeaponType = this.getAgentMemory().enemyWeaponType(target);
            Weapon myWeapon = this.getAgentMemory().weaponry.getCurrentWeapon();
            ItemType itemType = myWeaponType = myWeapon == null ? null : myWeapon.getType();
            if (myWeaponType == null) {
                return false;
            }
            if (myWeaponType != null && enemyWeaponType != null && enemyWeaponType.equals((Object)myWeaponType)) {
                return true;
            }
            boolean enemyWeaponBetter = weaponPreferences.betterWeapon(myWeaponType, enemyWeaponType, distance);
            if (!enemyWeaponBetter) {
                return true;
            }
            if (distance > 2500.0 || (myWeaponType.equals((Object)ItemType.ASSAULT_RIFLE) || myWeaponType.equals((Object)ItemType.BIO_RIFLE)) && distance > 600.0) {
                System.out.println("Should not fight, weapons/distance unfavorable");
                return false;
            }
        }
        return result;
    }

    public boolean itemPathControllerNotDoingAnythingImportant() {
        return !this.getAgentMemory().itemPathExecutor.inState(PathExecutorState.FOLLOW_PATH_CALLED, PathExecutorState.PATH_COMPUTED) && !((DistantPathController)this.pathController).focused;
    }

    public boolean canFight() {
        Player targetEnemy = this.getAgentMemory().getCombatTarget();
        Location agentLocation = this.info.getLocation();
        Weapon w = this.weaponry.getCurrentWeapon();
        if (agentLocation == null) {
            return false;
        }
        if (this.weaponry.getCurrentAmmo() == 0) {
            return false;
        }
        if (targetEnemy != null && targetEnemy.getLocation() != null) {
            double distance = targetEnemy.getLocation().getDistance(agentLocation);
            if (distance > 2500.0 && this.getAgentBody().isGetCloseWeapon(w)) {
                return false;
            }
            if (distance > 2500.0 && this.getAgentBody().isSnipingWeapon(w)) {
                return true;
            }
        }
        return targetEnemy == null || !this.getAgentMemory().isAboveMe((ILocated)targetEnemy.getLocation());
    }

    public static void main(String[] args) throws PogamutException {
        if (args.length > 0 && args[0].equals("retrace")) {
            new UT2004BotRunner(HumanRetraceBot.class, "HumanRetraceBot").startAgent();
        } else {
            switch (args.length) {
                case 0: {
                    while (true) {
                        try {
                            while (true) {
                                System.out.println("Launch bot");
                                UT2.launchBot();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Connection broken, try resetting bot");
                            continue;
                        }
                        break;
                    }
                }
                case 1: {
                    while (true) {
                        try {
                            while (true) {
                                System.out.println("Launch bot");
                                UT2.launchBot(DEFAULT_FILE, 0, args[0]);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Connection broken, try resetting bot");
                            continue;
                        }
                        break;
                    }
                }
                case 4: {
                    UT2.launchBot(args[0], Integer.parseInt(args[1]), args[2], Integer.parseInt(args[3]));
                    break;
                }
                default: {
                    System.out.println("Improper number of arguments");
                    System.out.println("Test one bot:");
                    System.out.println("       java -jar 04-Hunter.jar [battleController.xml [numOpponents [host [port]]]]");
                    System.out.println("Evolve bots:");
                    System.out.println("       java -jar 04-Hunter.jar evolve generations:int population:int repetitions:int controller:EvolvableController descriptor:<BaseExperimentDescriptor> [descriptor args]");
                }
            }
        }
    }

    public static void launchBot() {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(DEFAULT_FILE, 0, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(String battleControllerFile) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleControllerFile, 0, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(String battleControllerFile, int opponents) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleControllerFile, opponents, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(String battleControllerFile, int opponents, String host) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleControllerFile, opponents, host, pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(String battleControllerFile, int opponents, String host, int port) {
        System.out.println("Loading from file: " + battleControllerFile);
        TWEANNController controller = (TWEANNController)Easy.load((String)battleControllerFile);
        controller.filename = battleControllerFile;
        UT2.launchBot(controller, opponents, host, port);
    }

    public static void launchBot(TWEANNController battleController) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleController, 0, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(TWEANNController battleController, int opponents) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleController, opponents, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(TWEANNController battleController, int opponents, String host, int port) {
        UT2.launchBot(battleController, null, opponents, host, port);
    }

    public static void launchBot(TWEANNController battleController, Class<? extends IUT2004BotController> opponentClass, int opponents) {
        UT2.launchBot(battleController, opponentClass, opponents, 0, null);
    }

    public static void launchBot(TWEANNController battleController, Class<? extends IUT2004BotController> opponentClass, int opponents, int nativeBots, IUT2004Server server) {
        PogamutPlatform pl = Pogamut.getPlatform();
        UT2.launchBot(battleController, opponentClass, opponents, nativeBots, server, pl.getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), pl.getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public static void launchBot(TWEANNController battleController, Class<? extends IUT2004BotController> opponentClass, int opponents, String host, int port) {
        UT2.launchBot(battleController, opponentClass, opponents, 0, null, host, port);
    }

    public static void launchBot(TWEANNController battleController, Class<? extends IUT2004BotController> opponentClass, int opponents, int nativeBots, IUT2004Server server, String host, int port) {
        long start = System.currentTimeMillis();
        System.out.println(port + ":launchBot at: " + start);
        UT2004BotDescriptor ut2 = new UT2004BotDescriptor().setController(UT2.class).addParams(new IRemoteAgentParameters[]{new UT2Parameters(battleController, server).setAgentId((IAgentId)new AgentId(Constants.BOT_NAME.get()))});
        UT2004BotDescriptor opps = new UT2004BotDescriptor().setController(opponentClass);
        for (int i = 0; i < opponents; ++i) {
            opps.addParams(new IRemoteAgentParameters[]{new UT2004AgentParameters().setAgentId((IAgentId)new AgentId(opponentClass.getSimpleName() + "(" + i + ")"))});
        }
        MultipleUT2004BotRunner runner = new MultipleUT2004BotRunner("Multiple").setHost(host).setPort(port);
        System.out.println("Launch single bot: UT^2");
        try {
            runner.setMain(true).startAgents(new IAgentDescriptor[]{ut2});
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in launchBot()");
        }
    }

    private void initActionLog(String battleControllerFile) {
        this.actionLogFilename = null;
        this.battleController.init();
        if (battleControllerFile != null && !battleControllerFile.equals("")) {
            String filename;
            this.actionLogFilename = filename = battleControllerFile.replace('/', '_').replace('\\', '_') + ".log";
        }
    }

    static {
        printActions = Constants.PRINT_ACTIONS.getBoolean();
        RECORDING = Constants.RECORDING.getBoolean();
        TIMING = Constants.TIMING.getBoolean();
        RETRACE = false;
    }

    private static class UT2Parameters
    extends UT2004BotParameters {
        private TWEANNController battleController;
        private IUT2004Server server;

        public UT2Parameters(TWEANNController cont, IUT2004Server server) {
            this.battleController = cont;
            this.server = server;
        }

        public TWEANNController getBattleController() {
            return this.battleController;
        }

        public IUT2004Server getServer() {
            return this.server;
        }
    }
}

