/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.logs;

import edu.utexas.cs.nn.logs.LogEntry;
import edu.utexas.cs.nn.logs.LogProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogEventSequence {
    private Map<Integer, Sequence> sequences = new HashMap<Integer, Sequence>();

    public void addEvent(int sequence, LogEntry e) {
        Sequence s;
        if (!this.sequences.containsKey(sequence)) {
            s = new Sequence();
            this.sequences.put(sequence, s);
        } else {
            s = this.sequences.get(sequence);
        }
        s.addEvent(e);
    }

    public int size() {
        int s = 0;
        for (Integer i : this.sequences.keySet()) {
            s += this.sequences.get(i).size();
        }
        return s;
    }

    public static void main(String[] args) {
        String[] filenames = new String[]{"DM-DG-Colosseum-001.log", "DM-GoatswoodPlay-002.log", "DM-GoatswoodPlay-001.log", "DM-IceHenge-001.log"};
        LogEventSequence sequence = new LogEventSequence();
        for (String filename : filenames) {
            try {
                FileReader fileReader = new FileReader(filename);
                BufferedReader lineReader = new BufferedReader(fileReader);
                LogProcessor processor = new LogProcessor();
                List<LogEntry> events = processor.parseLogEntries(lineReader);
                for (LogEntry event : events) {
                    sequence.addEvent(1, event);
                }
                lineReader.close();
                fileReader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LogProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("there are a total of " + sequence.size() + " events");
    }

    public class Sequence {
        SortedMap<Double, LogEntry> timeSeq = new TreeMap<Double, LogEntry>();
        HashMap<Integer, LogEntry> indexSeq = new HashMap();

        public int size() {
            return this.timeSeq.size();
        }

        public LogEntry get(int i) {
            return this.indexSeq.get(i);
        }

        public LogEntry getNext(double t) {
            try {
                Double at = this.timeSeq.tailMap(t).firstKey();
                return (LogEntry)this.timeSeq.get(at);
            }
            catch (IllegalArgumentException e) {
                System.err.println("No next event for " + t);
                return null;
            }
        }

        public void addEvent(LogEntry e) {
            this.indexSeq.put(this.indexSeq.size(), e);
            this.timeSeq.put(e.getTime(), e);
        }
    }
}

