/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.retrace;

import edu.utexas.cs.nn.Point;
import edu.utexas.cs.nn.retrace.PoseSequence;
import edu.utexas.cs.nn.retrace.VoronoiRegion;

public class NavpointRetraceLink {
    private VoronoiRegion from;
    private VoronoiRegion to;
    private PoseSequence path;
    private Point startingPoint;
    private Point endPoint;
    private double length;

    private NavpointRetraceLink() {
    }

    public static NavpointRetraceLink CreateLink(VoronoiRegion from, VoronoiRegion to, PoseSequence path, int startPoint, int endPoint) {
        NavpointRetraceLink link = new NavpointRetraceLink();
        link.from = from;
        link.to = to;
        link.path = path;
        link.startingPoint = path.allPoints.get(startPoint);
        link.endPoint = path.allPoints.get(endPoint);
        link.length = link.endPoint.getDistance() - link.startingPoint.getDistance();
        return link;
    }

    public double getLength() {
        return this.length;
    }

    public PoseSequence getPath() {
        this.path.jump(this.startingPoint.getIndex());
        return this.path;
    }

    public Point getEndPoint() {
        return this.endPoint;
    }
}

