/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.retrace;

import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.Point;
import edu.utexas.cs.nn.db.DbLogger;
import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoseSequence
extends DbLogger
implements Iterable<Point> {
    private List<Point> sequence = new ArrayList<Point>();
    private int current = -1;
    private boolean jumpFlag = false;
    public Map<Integer, KDTree<Point>> navpointIds = new HashMap<Integer, KDTree<Point>>();
    public Map<Integer, Point> allPoints = new HashMap<Integer, Point>();
    public List<Integer> orderOfNavpoints = new LinkedList<Integer>();
    public List<Integer> entryPoints = new LinkedList<Integer>();
    public List<Integer> exitPoints = new LinkedList<Integer>();
    public static final double TIME_DISCONTINUITY = 5.0;
    public static final double SPACE_DISCONTINUITY = 250.0;

    private PoseSequence(List<Point> points) {
        this.sequence.addAll(points);
        int i = 0;
        for (Point p : points) {
            KDTree<Object> subset;
            p.setIndex(i++);
            p.setIndexBefore(i - 1);
            p.setIndexAfter(i + 1);
            this.allPoints.put(p.getIndex(), p);
            int id = p.getNavpointId();
            if (id < 0) continue;
            if (this.navpointIds.containsKey(id)) {
                subset = this.navpointIds.get(id);
            } else {
                subset = new KDTree(3);
                this.navpointIds.put(id, subset);
            }
            if (this.orderOfNavpoints.isEmpty() || this.orderOfNavpoints.get(this.orderOfNavpoints.size() - 1) != id) {
                this.orderOfNavpoints.add(id);
                this.exitPoints.add(p.getIndexBefore());
                this.entryPoints.add(p.getIndex());
            }
            try {
                subset.insert(p.asArray(), p);
            }
            catch (KeySizeException ex) {
                PoseSequence.logException("Wrong key size when adding points to PoseSequence", ex);
            }
            catch (KeyDuplicateException ex) {}
        }
        if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
            System.out.println("This path goes through " + this.navpointIds.size() + " navpoints");
        }
    }

    KDTree<Point> getPointsInRegion(int id) {
        if (this.navpointIds.containsKey(id)) {
            return this.navpointIds.get(id);
        }
        return new KDTree<Point>(3);
    }

    public static List<PoseSequence> readSequences(BufferedReader reader) throws IOException {
        LinkedList<PoseSequence> sequences = new LinkedList<PoseSequence>();
        while (true) {
            String line;
            LinkedList<Point> sequence = new LinkedList<Point>();
            double distance = 0.0;
            Point prev = null;
            while ((line = reader.readLine()) != null) {
                Point pose = Point.parsePose(line);
                if (pose == null) continue;
                if (prev != null) {
                    if (pose.getT() - prev.getT() > 5.0) {
                        if (!Constants.VIEW_HRTC_MESSAGES.getBoolean()) break;
                        System.out.println("Time discontinuity between: " + prev + " and " + pose);
                        break;
                    }
                    prev.setDistance(distance);
                    double d = pose.getLocation().getDistance(prev.getLocation());
                    if (d <= 0.0) {
                        System.err.println("distance step <= 0! " + prev + " and " + pose);
                    }
                    assert (d > 0.0);
                    assert ((distance += d) > 0.0);
                    if (d > 250.0) {
                        if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                            System.out.println();
                        }
                        if (!(d <= 0.0)) break;
                        Logger.getLogger(PoseSequence.class.getName()).log(Level.WARNING, "Space discontinuity between: {0} and {1}", new Object[]{prev, pose});
                        break;
                    }
                }
                sequence.add(pose);
                prev = pose;
            }
            if (sequence.size() <= 1) break;
            sequences.add(new PoseSequence(sequence));
            sequence.clear();
        }
        return sequences;
    }

    public boolean hasNext() {
        if (this.current < 0) {
            this.current = 0;
        }
        return this.current < this.sequence.size();
    }

    public void jump(int to) {
        if (to >= 0 && to < this.sequence.size() - 1) {
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println("jump: " + this.sequence.get(to));
            }
            this.current = to;
        }
    }

    public Point nextByTime(double skipTime) {
        if (this.current < 0) {
            this.current = 0;
        }
        if (this.current >= this.sequence.size()) {
            return null;
        }
        double startTime = this.sequence.get(this.current).getT();
        while (this.current < this.sequence.size() && this.sequence.get(this.current).getT() - startTime < skipTime) {
            ++this.current;
        }
        if (this.current >= this.sequence.size()) {
            return null;
        }
        return this.sequence.get(this.current);
    }

    public Point peekByTime(double skipTime) {
        int peek_i;
        if (this.current < 0) {
            this.current = 0;
        }
        if (this.current >= this.sequence.size()) {
            return null;
        }
        double startTime = this.sequence.get(peek_i).getT();
        for (peek_i = this.current; peek_i < this.sequence.size() && this.sequence.get(peek_i).getT() - startTime < skipTime; ++peek_i) {
        }
        if (peek_i >= this.sequence.size()) {
            return null;
        }
        return this.sequence.get(peek_i);
    }

    public boolean getJumpFlag() {
        return this.jumpFlag;
    }

    public void resetJumpFlag() {
        this.jumpFlag = false;
    }

    public Point nextByDistance(double distance) {
        double startDistance;
        if (this.current == 0) {
            this.current = 0;
        }
        if (this.current >= this.sequence.size()) {
            return null;
        }
        this.resetJumpFlag();
        Point pose = this.sequence.get(this.current);
        double currentDistance = startDistance = pose.getDistance();
        while (currentDistance - startDistance < distance && this.current < this.sequence.size()) {
            Point next;
            if ((next = this.sequence.get(this.current++)).isStartOfJump()) {
                this.jumpFlag = true;
            }
            currentDistance = next.getDistance();
            pose = next;
        }
        if (this.current >= this.sequence.size()) {
            return null;
        }
        return pose;
    }

    public Point peekByDistance(double distance) {
        double startDistance;
        int peek_i = this.current;
        if (peek_i == 0) {
            peek_i = 0;
        }
        if (peek_i >= this.sequence.size()) {
            return null;
        }
        Point pose = this.sequence.get(peek_i);
        double currentDistance = startDistance = pose.getDistance();
        while (currentDistance - startDistance < distance && peek_i < this.sequence.size()) {
            Point next = this.sequence.get(peek_i++);
            currentDistance = next.getDistance();
            pose = next;
        }
        if (peek_i >= this.sequence.size()) {
            return null;
        }
        return pose;
    }

    public int size() {
        return this.sequence.size();
    }

    @Override
    public Iterator<Point> iterator() {
        return this.sequence.iterator();
    }

    public Point getCurrent() {
        return this.sequence.get(this.current);
    }

    public Point getEnd() {
        return this.sequence.get(this.sequence.size() - 1);
    }
}

