/*
 * Decompiled with CFR 0.152.
 */
package machinelearning.networks;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import machinelearning.Tools;
import machinelearning.evolution.evolvables.Evolvable;
import machinelearning.networks.FunctionApproximator;
import utopia.Utils;

public class TWEANN
implements Evolvable,
Serializable,
FunctionApproximator {
    private static TWEANN initialMember = null;
    private static final transient double LINK_MUTATE_POWER = 1.0;
    private static final transient double LINK_MUTATE_RATE = 0.2;
    private static final transient double ADD_NODE_RATE = 0.2;
    private static final transient double ADD_LINK_RATE = 0.3;
    private static final transient double GENE_TOGGLE_RATE = 0.2;
    private static final transient int ADD_LINK_TRIES = 10;
    private static final transient int GENE_TOGGLE_TIMES = 5;
    public static Vector<Innovation> innovations = new Vector();
    public static double cur_innov_num = 1.0;
    public static int cur_node_id = 1;
    public static int cur_net_id = 1;
    public static final transient int ACTIVATION_FUNCTION_SIGMOID = 0;
    public static final transient int ACTIVATION_FUNCTION_TANH = 1;
    public static final transient int NODE_TYPE_NEURON = 2;
    public static final transient int NODE_TYPE_SENSOR = 3;
    public static final transient int NODE_LABEL_INPUT = 4;
    public static final transient int NODE_LABEL_OUTPUT = 5;
    public static final transient int NODE_LABEL_HIDDEN = 6;
    public static final transient int NODE_LABEL_BIAS = 7;
    public static final transient int MUTATION_TYPE_PERTURB = 8;
    public static final transient int MUTATION_TYPE_REPLACE = 9;
    public static final transient int INNOVATION_TYPE_NEWNODE = 10;
    public static final transient int INNOVATION_TYPE_NEWLINK = 11;
    Vector<Gene> genes;
    transient Vector<NNode> inputs;
    transient Vector<NNode> outputs;
    Vector<NNode> allnodes;
    int net_id;

    public static double getCurr_innov_num_and_increment() {
        double d = cur_innov_num;
        cur_innov_num = d + 1.0;
        return d;
    }

    public static int getCur_node_id_and_increment() {
        return cur_node_id++;
    }

    public static int getCur_net_id_and_increment() {
        return cur_net_id++;
    }

    @Override
    public void mutate() {
        this.mutate_link_weight(1.0, 0.2, 8);
        if (Utils.randomFloat() < 0.2) {
            this.mutate_add_node();
        }
        if (Utils.randomFloat() < 0.3) {
            this.mutate_add_link(10);
        }
        if (Utils.randomFloat() < 0.2) {
            this.mutate_toggle_enable(5);
        }
    }

    private static double randomWeight() {
        return (double)Utils.randposneg() * Utils.randomFloat() * 10.0;
    }

    @Override
    public String toString() {
        String ret = "";
        ret = ret + "TWEANN:" + this.net_id + ":" + this.allnodes.size() + "\n";
        ret = ret + "Genes:\n";
        for (Gene g : this.genes) {
            ret = ret + " " + g + "\n";
        }
        ret = ret + "Nodes:\n";
        for (NNode n : this.allnodes) {
            ret = ret + " " + n + "\n";
        }
        ret = ret + "InputNodes:\n";
        for (NNode n : this.inputs) {
            ret = ret + " " + n + "\n";
        }
        ret = ret + "OutputNodes:\n";
        for (NNode n : this.outputs) {
            ret = ret + " " + n + "\n";
        }
        return ret;
    }

    public TWEANN(Vector<NNode> in, Vector<NNode> out, Vector<NNode> all, int xnet_id, Vector<Gene> _genes) {
        this.rebuild(in, out, all, xnet_id, _genes);
    }

    private void rebuild(Vector<NNode> in, Vector<NNode> out, Vector<NNode> all, int xnet_id, Vector<Gene> _genes) {
        this.inputs = in;
        this.outputs = out;
        this.allnodes = all;
        this.net_id = xnet_id;
        this.genes = _genes;
    }

    public TWEANN(Vector<NNode> all, Vector<Gene> the_genes, int xnet_id) {
        this.rebuild(all, the_genes, xnet_id);
    }

    private void rebuild(Vector<NNode> all, Vector<Gene> the_genes, int xnet_id) {
        this.rebuild(null, null, all, xnet_id, the_genes);
        this.stripLinks(all);
        this.fillInputsAndOutputs(all);
        this.fillInLinks(the_genes);
    }

    public void rebuild() {
        this.rebuild(this.allnodes, this.genes, this.net_id);
    }

    public TWEANN(int numInputs, int numOutputs) {
        this(numInputs, numOutputs, false);
    }

    public TWEANN(int numInputs, int numOutputs, boolean featureSelective) {
        int first_output;
        NNode newnode = null;
        int totalnodes = numInputs + numOutputs;
        this.inputs = new Vector(numInputs);
        this.outputs = new Vector(numOutputs);
        this.allnodes = new Vector(totalnodes);
        this.genes = new Vector(totalnodes);
        int count = 0;
        for (count = 1; count <= numInputs; ++count) {
            newnode = count < numInputs ? new NNode(3, TWEANN.getCur_node_id_and_increment(), 4) : new NNode(3, TWEANN.getCur_node_id_and_increment(), 7);
            this.allnodes.add(newnode);
            this.inputs.add(newnode);
        }
        for (count = first_output = totalnodes - numOutputs + 1; count <= totalnodes; ++count) {
            newnode = new NNode(2, TWEANN.getCur_node_id_and_increment(), 5);
            this.allnodes.add(newnode);
            this.outputs.add(newnode);
        }
        if (featureSelective) {
            for (NNode out_node : this.outputs) {
                int inputNode = Utils.randomInt(0, this.inputs.size() - 1);
                NNode in_node = this.inputs.get(inputNode);
                double new_weight = (double)Utils.randposneg() * Utils.randomFloat();
                TWEANN.linkNodes(new_weight, in_node, out_node, this.genes);
            }
        } else {
            for (NNode in_node : this.inputs) {
                for (NNode out_node : this.outputs) {
                    double new_weight = (double)Utils.randposneg() * Utils.randomFloat();
                    TWEANN.linkNodes(new_weight, in_node, out_node, this.genes);
                }
            }
        }
        this.net_id = TWEANN.getCur_net_id_and_increment();
        if (initialMember == null) {
            initialMember = this;
        }
    }

    public static Link linkNodes(double weight, NNode from, NNode into) {
        return TWEANN.linkNodes(weight, from, into, null, false, -1.0);
    }

    public static Link linkNodes(double weight, NNode from, NNode into, Vector<Gene> the_genes) {
        return TWEANN.linkNodes(weight, from, into, the_genes, true, -1.0);
    }

    public static Link linkNodes(double weight, NNode from, NNode into, Vector<Gene> the_genes, boolean innovate, double innovation_num) {
        Link newlink = new Link(weight, from, into);
        into.incoming.add(newlink);
        from.outgoing.add(newlink);
        if (the_genes != null) {
            int i;
            for (i = the_genes.size() - 1; i >= 0 && the_genes.elementAt((int)i).lnk.out_node.node_id != from.node_id; --i) {
            }
            if (innovate) {
                TWEANN.addInnovativeLinkGene(newlink, i, the_genes);
            } else {
                TWEANN.addUninnovativeLinkGene(newlink, i, the_genes, innovation_num);
            }
        }
        return newlink;
    }

    public Link add_link(double weight, NNode from, NNode into) {
        Link link = null;
        for (Innovation _innov : innovations) {
            if (_innov.innovation_type != 11 || _innov.node_in_id != from.node_id || _innov.node_out_id != into.node_id) continue;
            _innov.new_weight = weight;
            link = TWEANN.linkNodes(weight, from, into, this.genes, false, _innov.innovation_num1);
            break;
        }
        if (link == null) {
            link = TWEANN.linkNodes(weight, from, into, this.genes, true, -1.0);
        }
        this.rebuild();
        return link;
    }

    public Link add_link(double weight, int from_pos, int into_pos) {
        return this.add_link(weight, this.allnodes.elementAt(from_pos), this.allnodes.elementAt(into_pos));
    }

    private static void addUninnovativeLinkGene(Link newlink, int gene_pos, Vector<Gene> the_genes, double innovation_num) {
        Gene newGene = new Gene(newlink, innovation_num, 0.0);
        the_genes.insertElementAt(newGene, gene_pos + 1);
    }

    private static void addInnovativeLinkGene(Link newlink, int gene_pos, Vector<Gene> the_genes) {
        Gene newGene = new Gene(newlink, TWEANN.getCurr_innov_num_and_increment(), 0.0);
        innovations.add(new Innovation(newGene));
        the_genes.insertElementAt(newGene, gene_pos + 1);
    }

    private void fillInputsAndOutputs(Vector<NNode> the_nodes) {
        this.inputs = new Vector();
        this.outputs = new Vector();
        for (NNode _node : the_nodes) {
            if (_node.gen_node_label == 4) {
                this.inputs.add(_node);
            }
            if (_node.gen_node_label == 7) {
                this.inputs.add(_node);
            }
            if (_node.gen_node_label != 5) continue;
            this.outputs.add(_node);
        }
    }

    public int indexOfLinkInGenes(Link link) {
        for (int i = 0; i < this.genes.size(); ++i) {
            if (!this.genes.elementAt((int)i).lnk.equals(link)) continue;
            return i;
        }
        return -1;
    }

    private void stripLinks(Vector<NNode> all) {
        for (NNode node : all) {
            node.incoming = new Vector();
            node.outgoing = new Vector();
        }
    }

    private void fillInLinks(Vector<Gene> the_genes) {
        for (Gene gene : the_genes) {
            if (!gene.enable) continue;
            Link curlink = gene.lnk;
            NNode inode = curlink.in_node;
            NNode onode = curlink.out_node;
            if (inode == null || onode == null) {
                System.out.println("ERROR: A Gene has a null node in the link");
                System.out.println("IN: " + inode);
                System.out.println("OUT: " + onode);
                System.out.println("Link: " + curlink);
                System.out.println("Net:\n" + this);
                System.exit(1);
            }
            TWEANN.linkNodes(curlink.weight, inode, onode);
        }
    }

    public boolean activate() {
        boolean onetime = false;
        int abortcount = 0;
        while (this.outputsoff() || !onetime) {
            if (++abortcount >= 30) {
                System.out.print("\n *ERROR* Inputs disconnected from output!");
                System.out.println(this);
                System.exit(1);
                return false;
            }
            for (NNode _node : this.allnodes) {
                _node.activate();
            }
            onetime = true;
        }
        return true;
    }

    public void flush() {
        for (NNode _node : this.allnodes) {
            _node.resetNNode();
        }
    }

    public void load_sensors(double[] sensvals) {
        int counter = 0;
        for (NNode _node : this.inputs) {
            if (_node.type != 3) continue;
            _node.sensor_load(sensvals[counter++]);
        }
    }

    public int max_depth() {
        int cur_depth = 0;
        int max = 0;
        for (NNode _node : this.allnodes) {
            _node.inner_level = 0;
            _node.is_traversed = false;
        }
        for (NNode _node : this.outputs) {
            cur_depth = _node.depth(0, this, max);
            if (cur_depth <= max) continue;
            max = cur_depth;
        }
        return max;
    }

    public boolean outputsoff() {
        for (NNode _node : this.outputs) {
            if (_node.activation_count != 0.0) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfGenes() {
        return this.genes.size();
    }

    @Override
    public double[] propagate(double[] doubles) {
        return this.processInputsToOutputs(doubles);
    }

    public double[] processInputsToOutputs(double[] doubles) {
        if (doubles.length != this.getNumberOfInputs()) {
            System.out.println("Incorrect number of outputs!");
            System.exit(1);
        }
        this.load_sensors(doubles);
        this.activate();
        double[] output = new double[this.outputs.size()];
        for (int i = 0; i < this.outputs.size(); ++i) {
            output[i] = this.outputs.get(i).get_active_out();
        }
        return output;
    }

    @Override
    public int getNumberOfInputs() {
        return this.inputs.size();
    }

    @Override
    public int getNumberOfOutputs() {
        return this.outputs.size();
    }

    public boolean verify() {
        int i1 = 0;
        int o1 = 0;
        boolean disab = false;
        int last_id = 0;
        Iterator<Gene> itr_Gene = this.genes.iterator();
        Iterator<Gene> itr_Gene1 = this.genes.iterator();
        if (this.genes.size() == 0) {
            return false;
        }
        if (this.allnodes.size() == 0) {
            return false;
        }
        for (Gene _Gene : this.genes) {
            NNode inode = _Gene.lnk.in_node;
            NNode onode = _Gene.lnk.out_node;
            if (inode == null) {
                System.out.println(" *ERROR* inode = null in TWEANNGenome #" + this.net_id);
                return false;
            }
            if (onode == null) {
                System.out.println(" *ERROR* onode = null in TWEANNGenome #" + this.net_id);
                return false;
            }
            if (!this.allnodes.contains(inode)) {
                System.out.println("Missing inode:  node defined in Gene not found in Vector nodes of TWEANNGenome #" + this.net_id);
                System.out.print("\n the inode is=" + inode.node_id);
                return false;
            }
            if (this.allnodes.contains(onode)) continue;
            System.out.println("Missing onode:  node defined in Gene not found in Vector nodes of TWEANNGenome #" + this.net_id);
            System.out.print("\n the onode is=" + onode.node_id);
            return false;
        }
        for (NNode _node : this.allnodes) {
            if (_node.node_id < last_id) {
                System.out.println("ALERT: NODES OUT OF ORDER : ");
                System.out.println(" last node_id is= " + last_id + " , current node_id=" + _node.node_id);
                return false;
            }
            last_id = _node.node_id;
        }
        itr_Gene = this.genes.iterator();
        while (itr_Gene.hasNext()) {
            Gene _Gene = itr_Gene.next();
            i1 = _Gene.lnk.in_node.node_id;
            o1 = _Gene.lnk.out_node.node_id;
            itr_Gene1 = itr_Gene;
            while (itr_Gene1.hasNext()) {
                Gene _Gene1 = itr_Gene1.next();
                if (_Gene1.lnk.in_node.node_id != i1 || _Gene1.lnk.out_node.node_id != o1) continue;
                System.out.print(" \n  ALERT: DUPLICATE GeneS :");
                System.out.print("  inp_node=" + i1 + " out_node=" + o1);
                System.out.print("  in TWEANNGenome id -->" + this.net_id);
                System.out.print("  Gene1 is : ");
                System.out.print("  Gene2 is : ");
                return false;
            }
        }
        if (this.allnodes.size() >= 500) {
            disab = false;
            for (Gene _Gene : this.genes) {
                if (!_Gene.enable && disab) {
                    System.out.print("\n ALERT: 2 DISABLES IN A ROW: " + _Gene.lnk.in_node.node_id);
                    System.out.print(" inp node=" + _Gene.lnk.in_node.node_id);
                    System.out.print(" out node=" + _Gene.lnk.out_node.node_id);
                    System.out.print(" for TWEANN " + this.net_id);
                    System.out.print("\n Gene is :");
                }
                if (!_Gene.enable) {
                    disab = true;
                    continue;
                }
                disab = false;
            }
        }
        return true;
    }

    public TWEANN duplicateWithNewID() {
        Vector<NNode> nodes_dup = new Vector<NNode>(this.allnodes.size());
        Vector<Gene> genes_dup = new Vector<Gene>(this.genes.size());
        for (NNode _node : this.allnodes) {
            NNode newnode;
            _node.dup = newnode = new NNode(_node);
            nodes_dup.add(newnode);
        }
        for (Gene _gene : this.genes) {
            NNode inode = _gene.lnk.in_node.dup;
            NNode onode = _gene.lnk.out_node.dup;
            Gene new_gene = new Gene(_gene, inode, onode);
            genes_dup.add(new_gene);
        }
        for (NNode _node : this.allnodes) {
            _node.dup = null;
        }
        TWEANN newTWEANN = new TWEANN(nodes_dup, genes_dup, TWEANN.getCur_net_id_and_increment());
        return newTWEANN;
    }

    public void mutate_link_weight(double power, double rate, int mutation_type) {
        boolean severe = Utils.randomFloat() > 0.5;
        double num = 0.0;
        double gene_total = this.genes.size();
        double endpart = gene_total * 0.8;
        double powermod = 1.0;
        for (Gene _gene : this.genes) {
            double change_threshold;
            double alter_threshold;
            if (severe) {
                alter_threshold = 0.3;
                change_threshold = 0.1;
            } else if (gene_total >= 10.0 && num > endpart) {
                alter_threshold = 0.5;
                change_threshold = 0.3;
            } else if (Utils.randomFloat() > 0.5) {
                alter_threshold = 1.0 - rate;
                change_threshold = 1.0 - rate - 0.1;
            } else {
                alter_threshold = 1.0 - rate;
                change_threshold = 1.0 - rate;
            }
            double weight_amount = (double)Utils.randposneg() * Utils.randomFloat() * power * powermod;
            this.mutate_gene_weight(_gene, weight_amount, mutation_type, alter_threshold, change_threshold);
            num += 1.0;
        }
        this.rebuild();
    }

    private void mutate_gene_weight(Gene _gene, double weight_amount, int mutation_type, double alter_threshold, double change_threshold) {
        if (mutation_type == 8) {
            double randchoice = Utils.randomFloat();
            this.mutate_gene_weight(_gene, randchoice, alter_threshold, change_threshold, weight_amount);
        } else if (mutation_type == 9) {
            this.guarranteed_replace_gene_weight(_gene, weight_amount);
        }
    }

    public double get_gene_weight(int gene_pos) {
        return this.genes.elementAt((int)gene_pos).lnk.weight;
    }

    public void guarranteed_replace_gene_weight(int gene_pos, double new_weight) {
        this.guarranteed_replace_gene_weight(this.genes.elementAt(gene_pos), new_weight);
    }

    public void guarranteed_perturb_gene_weight(int gene_pos, double weight_amount) {
        this.mutate_gene_weight(this.genes.elementAt(gene_pos), 1.0, 0.9, 0.0, weight_amount);
    }

    public void mutate_gene_weight(int gene_pos, double randchoice, double alter_threshold, double change_threshold, double weight_amount) {
        this.mutate_gene_weight(this.genes.elementAt(gene_pos), randchoice, alter_threshold, change_threshold, weight_amount);
    }

    private void guarranteed_replace_gene_weight(Gene _gene) {
        this.guarranteed_replace_gene_weight(_gene, TWEANN.randomWeight());
    }

    private void guarranteed_replace_gene_weight(Gene _gene, double new_weight) {
        this.mutate_gene_weight(_gene, 0.5, 1.0, 0.0, new_weight);
    }

    private void mutate_gene_weight(Gene _gene, double randchoice, double alter_threshold, double change_threshold, double weight_amount) {
        if (randchoice > alter_threshold) {
            _gene.lnk.weight += weight_amount;
        } else if (randchoice > change_threshold) {
            _gene.lnk.weight = weight_amount;
        }
        _gene.mutation_num = _gene.lnk.weight;
    }

    public static void node_insert(Vector<NNode> nlist, NNode n, int after) {
        for (int j = 0; j < nlist.size(); ++j) {
            if (nlist.elementAt((int)j).node_id != after) continue;
            nlist.insertElementAt(n, j + 1);
            break;
        }
    }

    public boolean mutate_add_link(int tries) {
        Iterator<NNode> itr_node = null;
        int trycount = 0;
        itr_node = this.allnodes.iterator();
        int first_nonsensor = 0;
        NNode thenode1 = null;
        NNode thenode2 = null;
        boolean found = false;
        while (itr_node.hasNext()) {
            thenode1 = itr_node.next();
            if (thenode1.type != 3) break;
            ++first_nonsensor;
        }
        found = false;
        while (trycount < tries) {
            int nodenum1 = Utils.randomInt(0, this.allnodes.size() - 1);
            int nodenum2 = Utils.randomInt(first_nonsensor, this.allnodes.size() - 1);
            thenode1 = this.allnodes.elementAt(nodenum1);
            thenode2 = this.allnodes.elementAt(nodenum2);
            boolean bypass = false;
            for (Gene _gene : this.genes) {
                if (thenode2.type == 3) {
                    bypass = true;
                    break;
                }
                if (_gene.lnk.in_node != thenode1 || _gene.lnk.out_node != thenode2) continue;
                bypass = true;
                break;
            }
            if (!bypass) {
                trycount = tries;
                found = true;
                continue;
            }
            ++trycount;
        }
        if (found) {
            double new_weight = TWEANN.randomWeight();
            this.add_link(new_weight, thenode1, thenode2);
            return true;
        }
        return false;
    }

    public int mutate_add_node() {
        Gene newGene1 = null;
        Gene newGene2 = null;
        NNode new_node = null;
        boolean found = false;
        Gene _Gene = null;
        int Genenum = -1;
        for (int trycount = 0; trycount < 20 && !found; ++trycount) {
            Genenum = Utils.randomInt(0, this.genes.size() - 1);
            _Gene = this.genes.elementAt(Genenum);
            if (!_Gene.enable || _Gene.lnk.in_node.gen_node_label == 7) continue;
            found = true;
        }
        if (!found) {
            return -1;
        }
        _Gene.enable = false;
        Link thelink = _Gene.lnk;
        double oldweight = thelink.weight;
        NNode in_node = thelink.in_node;
        NNode out_node = thelink.out_node;
        boolean done = false;
        Iterator<Innovation> itr_innovation = innovations.iterator();
        while (!done) {
            if (!itr_innovation.hasNext()) {
                int curnode_id = TWEANN.getCur_node_id_and_increment();
                new_node = new NNode(2, curnode_id, 6);
                double Gene_innov1 = TWEANN.getCurr_innov_num_and_increment();
                newGene1 = new Gene(1.0, in_node, new_node, Gene_innov1, 0.0);
                double Gene_innov2 = TWEANN.getCurr_innov_num_and_increment();
                newGene2 = new Gene(oldweight, new_node, out_node, Gene_innov2, 0.0);
                innovations.add(new Innovation(in_node.node_id, out_node.node_id, Gene_innov1, Gene_innov2, new_node.node_id, _Gene.innovation_num));
                done = true;
                continue;
            }
            Innovation _innov = itr_innovation.next();
            if (_innov.innovation_type != 10 || _innov.node_in_id != in_node.node_id || _innov.node_out_id != out_node.node_id || _innov.old_innov_num != _Gene.innovation_num) continue;
            new_node = new NNode(2, _innov.newnode_id, 6);
            newGene1 = new Gene(1.0, in_node, new_node, _innov.innovation_num1, 0.0);
            newGene2 = new Gene(oldweight, new_node, out_node, _innov.innovation_num2, 0.0);
            done = true;
        }
        this.genes.insertElementAt(newGene1, Genenum + 1);
        this.genes.insertElementAt(newGene2, Genenum + 2);
        TWEANN.node_insert(this.allnodes, new_node, newGene1.lnk.in_node.node_id);
        this.rebuild();
        return Genenum;
    }

    public double compatibility(TWEANN g) {
        double num_disjoint = 0.0;
        double num_excess = 0.0;
        double mut_diff_total = 0.0;
        double num_matching = 0.0;
        Gene _Gene1 = null;
        Gene _Gene2 = null;
        int size1 = this.genes.size();
        int size2 = g.genes.size();
        double max_TWEANNGenome_size = Math.max(size1, size2);
        int j = 0;
        int j1 = 0;
        int j2 = 0;
        j = 0;
        while ((double)j < max_TWEANNGenome_size) {
            if (j1 >= size1) {
                num_excess += 1.0;
                ++j2;
            } else if (j2 >= size2) {
                num_excess += 1.0;
                ++j1;
            } else {
                _Gene1 = this.genes.elementAt(j1);
                _Gene2 = g.genes.elementAt(j2);
                double p1innov = _Gene1.innovation_num;
                double p2innov = _Gene2.innovation_num;
                if (p1innov == p2innov) {
                    num_matching += 1.0;
                    double mut_diff = Math.abs(_Gene1.mutation_num - _Gene2.mutation_num);
                    mut_diff_total += mut_diff;
                    ++j1;
                    ++j2;
                } else if (p1innov < p2innov) {
                    ++j1;
                    num_disjoint += 1.0;
                } else if (p2innov < p1innov) {
                    ++j2;
                    num_disjoint += 1.0;
                }
            }
            ++j;
        }
        double p_disjoint_coeff = 1.0;
        double p_excess_coeff = 1.0;
        double p_mutdiff_coeff = 0.4;
        return p_disjoint_coeff * (num_disjoint / 1.0) + p_excess_coeff * (num_excess / 1.0) + p_mutdiff_coeff * (mut_diff_total / num_matching);
    }

    public boolean mutate_gene_reenable() {
        for (int i = 0; i < this.genes.size(); ++i) {
            if (!this.enable_gene(i)) continue;
            return true;
        }
        return false;
    }

    public void mutate_toggle_enable(int times) {
        for (int count = 1; count <= times; ++count) {
            int gene_num = Utils.randomInt(0, this.genes.size() - 1);
            this.toggle_gene(gene_num);
        }
    }

    public boolean toggle_gene(int position) {
        return this.genes.elementAt((int)position).enable ? this.disable_gene(position) : this.enable_gene(position);
    }

    public boolean enable_gene(int position) {
        Gene _gene = this.genes.elementAt(position);
        if (!_gene.enable) {
            _gene.enable = true;
            this.rebuild();
            return true;
        }
        return false;
    }

    public boolean hard_disable_gene(int position) {
        return this.disable_gene(position, true);
    }

    public boolean disable_gene(int position) {
        return this.disable_gene(position, false);
    }

    public boolean disable_gene(int position, boolean hard) {
        Gene _gene = this.genes.elementAt(position);
        if (_gene.enable) {
            for (int j = 0; j < this.genes.size(); ++j) {
                Gene second_pass_gene = this.genes.elementAt(j);
                if (!hard && (_gene.lnk.out_node.incoming.size() <= 1 || _gene.lnk.in_node != second_pass_gene.lnk.in_node || !second_pass_gene.enable || second_pass_gene.innovation_num == _gene.innovation_num)) continue;
                _gene.enable = false;
                this.rebuild();
                return true;
            }
            return false;
        }
        return false;
    }

    private static TWEANN changeAllWeights(TWEANN net) {
        TWEANN dup = net.duplicateWithNewID();
        for (Gene _gene : dup.genes) {
            dup.guarranteed_replace_gene_weight(_gene);
        }
        dup.rebuild();
        return dup;
    }

    @Override
    public Evolvable getNewInstance() {
        if (initialMember == null) {
            throw new UnsupportedOperationException("No initial TWEANN was available");
        }
        return TWEANN.changeAllWeights(initialMember);
    }

    @Override
    public Evolvable copy() {
        return this.duplicateWithNewID();
    }

    @Override
    public void reset() {
        this.flush();
    }

    public static class Link
    implements Serializable {
        protected double weight;
        protected NNode in_node;
        protected NNode out_node;
        protected transient boolean is_traversed = false;

        public boolean equals(Object obj) {
            if (obj instanceof Link) {
                Link link = (Link)obj;
                return this.in_node == link.in_node && this.out_node == link.out_node && this.weight == link.weight;
            }
            return false;
        }

        public String toString() {
            return "Link:" + this.in_node.node_id + "->(" + this.weight + ")->" + this.out_node.node_id;
        }

        public Link(double w, NNode inode, NNode onode) {
            this.weight = w;
            this.in_node = inode;
            this.out_node = onode;
        }
    }

    public static class NNode
    implements Serializable {
        protected int ftype;
        protected int type;
        protected double activation = 0.0;
        protected Vector<Link> incoming = new Vector();
        protected Vector<Link> outgoing = new Vector();
        protected int node_id;
        protected int gen_node_label;
        protected double activation_count;
        protected double last_activation = 0.0;
        protected double last_activation2 = 0.0;
        protected NNode dup;
        public int inner_level;
        public boolean is_traversed;

        public String toString() {
            String ret = "NNode:id:" + this.node_id + ",activation_count:" + this.activation_count + ",node_type:" + this.type + ",node_label:" + this.gen_node_label + "\n";
            ret = ret + "In\n";
            for (Link l : this.incoming) {
                ret = ret + "   (" + l.in_node.activation + ")" + l + "\n";
            }
            ret = ret + "Out (" + this.activation + ")\n";
            for (Link l : this.outgoing) {
                ret = ret + "   " + l + "\n";
            }
            return ret;
        }

        public NNode(int ntype, int nodeid) {
            this(ntype, nodeid, 6);
        }

        public NNode(int ntype, int nodeid, int placement) {
            this.type = ntype;
            this.activation_count = 0.0;
            this.node_id = nodeid;
            this.ftype = 1;
            this.gen_node_label = placement;
            this.dup = null;
            this.is_traversed = false;
            this.inner_level = 0;
        }

        public NNode(NNode n) {
            this(n.type, n.node_id, n.gen_node_label);
        }

        public void activate() {
            if (this.type != 3) {
                double activesum = 0.0;
                double add_amount = 0.0;
                for (Link _link : this.incoming) {
                    add_amount = _link.weight * _link.in_node.get_active_out();
                    activesum += add_amount;
                }
                this.last_activation2 = this.last_activation;
                this.last_activation = this.activation;
                if (this.ftype == 0) {
                    this.activation = Tools.sigmoid(activesum);
                } else if (this.ftype == 1) {
                    this.activation = Tools.tanh(activesum);
                }
                this.activation_count += 1.0;
            }
        }

        public int depth(int xlevel, TWEANN mynet, int xmax_level) {
            if (xlevel > 100) {
                System.out.print("\n ** DEPTH NOT DETERMINED FOR NETWORK WITH LOOP ");
                System.out.println(mynet);
                System.exit(1);
                return 10;
            }
            if (this.type == 3) {
                return xlevel;
            }
            ++xlevel;
            int cur_depth = 0;
            for (Link _link : this.incoming) {
                NNode _ynode = _link.in_node;
                if (!_ynode.is_traversed) {
                    _ynode.is_traversed = true;
                    cur_depth = _ynode.depth(xlevel, mynet, xmax_level);
                    _ynode.inner_level = cur_depth - xlevel;
                } else {
                    cur_depth = xlevel + _ynode.inner_level;
                }
                if (cur_depth <= xmax_level) continue;
                xmax_level = cur_depth;
            }
            return xmax_level;
        }

        public double get_active_out() {
            if (this.activation_count > 0.0) {
                return this.activation;
            }
            return 0.0;
        }

        public double get_active_out_td() {
            if (this.activation_count > 1.0) {
                return this.last_activation;
            }
            return 0.0;
        }

        public boolean sensor_load(double value) {
            if (this.type == 3) {
                this.last_activation2 = this.last_activation;
                this.last_activation = this.activation;
                this.activation_count += 1.0;
                this.activation = value;
                return true;
            }
            return false;
        }

        public void resetNNode() {
            this.activation_count = 0.0;
            this.activation = 0.0;
            this.last_activation = 0.0;
            this.last_activation2 = 0.0;
            for (Link _link : this.incoming) {
                _link.is_traversed = false;
            }
            for (Link _link : this.outgoing) {
                _link.is_traversed = false;
            }
        }
    }

    public static class Gene
    implements Serializable {
        protected Link lnk;
        protected double innovation_num;
        protected double mutation_num;
        protected boolean enable;

        public String toString() {
            return "Gene:(" + (this.enable ? "on" : "off") + ")Inno:" + this.innovation_num + "," + this.lnk;
        }

        public Gene(Gene g, NNode inode, NNode onode) {
            this(g.lnk.weight, inode, onode, g.innovation_num, g.mutation_num, g.enable);
        }

        public Gene(Link l, double innov, double mnum) {
            this(l.weight, l.in_node, l.out_node, innov, mnum);
        }

        public Gene(double w, NNode inode, NNode onode, double innov, double mnum) {
            this(w, inode, onode, innov, mnum, true);
        }

        public Gene(double w, NNode inode, NNode onode, double innov, double mnum, boolean _enable) {
            this.lnk = new Link(w, inode, onode);
            this.innovation_num = innov;
            this.mutation_num = mnum;
            this.enable = _enable;
        }
    }

    public static class Innovation
    implements Serializable {
        int innovation_type;
        int node_in_id;
        int node_out_id;
        double innovation_num1;
        double innovation_num2;
        double new_weight;
        int newnode_id;
        double old_innov_num;

        public String toString() {
            String ret = "Innovation:";
            switch (this.innovation_type) {
                case 11: {
                    ret = ret + "link:(" + this.innovation_num1 + ") " + this.node_in_id + "->(" + this.new_weight + ")->" + this.node_out_id;
                    break;
                }
                case 10: {
                    ret = ret + "node:(" + this.innovation_num1 + "," + this.innovation_num2 + ") " + this.node_in_id + "->|" + this.newnode_id + "|->" + this.node_out_id;
                }
            }
            return ret;
        }

        public Innovation(int nin, int nout, double num1, double w) {
            this(11, nin, nout, num1, 0.0, 0, 0.0, w);
        }

        public Innovation(int nin, int nout, double num1, double num2, int newid, double oldinnov) {
            this(10, nin, nout, num1, num2, newid, oldinnov, 0.0);
        }

        public Innovation(Gene gene) {
            this(gene.lnk.in_node.node_id, gene.lnk.out_node.node_id, gene.innovation_num, gene.lnk.weight);
        }

        public Innovation(int itype, int nin, int nout, double num1, double num2, int newid, double oldinnov, double nweight) {
            this.innovation_type = itype;
            this.node_in_id = nin;
            this.node_out_id = nout;
            this.innovation_num1 = num1;
            this.innovation_num2 = num2;
            this.newnode_id = newid;
            this.old_innov_num = oldinnov;
            this.new_weight = nweight;
        }
    }
}

