/*
 * Decompiled with CFR 0.152.
 */
package mockcz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.List;
import java.util.logging.Logger;
import mockcz.cuni.pogamut.Client.AgentBody;

public class MyUTPathExecutor
implements IUnrealPathExecutor<ILocated> {
    private IUnrealPathExecutor<ILocated> executor;
    private final AgentBody body;
    private ILocated lastDestination = null;

    public MyUTPathExecutor(IUnrealPathExecutor executor, AgentBody body) {
        this.executor = executor;
        this.body = body;
    }

    public ImmutableFlag<IPathExecutorState> getState() {
        return this.executor.getState();
    }

    public IPathFuture<ILocated> getPathFuture() {
        return this.executor.getPathFuture();
    }

    public List<ILocated> getPath() {
        return this.executor.getPath();
    }

    public int getPathElementIndex() {
        return this.executor.getPathElementIndex();
    }

    public Integer remainingPathSize() {
        List<ILocated> path = this.getPath();
        if (path == null) {
            return null;
        }
        int start = this.getPathElementIndex();
        int result = path.size() - (start + 1);
        return result;
    }

    public boolean inState(PathExecutorState ... states) {
        return this.executor.inState(states);
    }

    public boolean notInState(PathExecutorState ... states) {
        return this.executor.notInState(states);
    }

    public boolean isExecuting() {
        return this.executor.isExecuting();
    }

    public boolean isTargetReached() {
        return this.executor.isTargetReached();
    }

    public boolean isStuck() {
        return this.executor.isStuck();
    }

    public boolean isPathUnavailable() {
        return this.executor.isPathUnavailable();
    }

    public void stop() {
        this.executor.stop();
    }

    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.executor.addStuckDetector(stuckDetector);
    }

    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.executor.removeStuckDetector(stuckDetector);
    }

    public Logger getLog() {
        return this.executor.getLog();
    }

    public boolean isMoving() {
        return this.body.isMoving();
    }

    public void setFocus(ILocated located) {
        this.executor.setFocus(located);
    }

    public ILocated getFocus() {
        return this.executor.getFocus();
    }

    public void followPath(IPathFuture<? extends ILocated> path) {
        if (this.lastDestination != null && this.lastDestination.getLocation() != null && this.executor.isExecuting() && this.lastDestination.getLocation().equals(((ILocated)path.getPathTo()).getLocation(), 20.0)) {
            return;
        }
        this.lastDestination = (ILocated)path.getPathTo();
        this.executor.followPath(path);
    }

    public ILocated getPathElement() {
        return (ILocated)this.executor.getPathElement();
    }

    public ILocated getPathFrom() {
        return (ILocated)this.executor.getPathFrom();
    }

    public ILocated getPathTo() {
        return (ILocated)this.executor.getPathTo();
    }

    public void removeAllStuckDetectors() {
        this.executor.removeAllStuckDetectors();
    }
}

