/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.actions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.ArrayList;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.Utils;
import utopia.agentmodel.actions.Action;

public abstract class ShootingAction
extends Action {
    private static final double AIM_THRESHOLD = 0.1;
    protected boolean shoot = false;
    protected boolean secondaryFire = false;
    protected Triple agentRotation;
    protected Triple agentLocation;
    private ArrayList<Player> players;

    public ShootingAction(boolean shoot, boolean secondaryFire, Triple agentRotation, Triple agentLocation, ArrayList<Player> players) {
        this.shoot = shoot;
        this.secondaryFire = secondaryFire;
        this.agentRotation = agentRotation;
        this.agentLocation = agentLocation;
        this.players = players;
    }

    public ShootingAction(Triple agentRotation, Triple agentLocation) {
        this(false, false, agentRotation, agentLocation, null);
    }

    @Override
    public void execute(AgentBody body) {
        if (this.shoot) {
            Triple targetVector = Triple.rotationAsVectorUTUnits(this.agentRotation);
            double scale = 10000.0;
            Triple playerTarget = null;
            for (Player p : this.players) {
                double angleToPlayer;
                Triple enemyLocation = Triple.locationToTriple(p.getLocation());
                if (enemyLocation == null || !((angleToPlayer = Utils.relativeAngleToTarget(this.agentLocation, this.agentRotation, enemyLocation)) < 0.1)) continue;
                playerTarget = new Triple(enemyLocation.x, enemyLocation.y, enemyLocation.z);
                break;
            }
            Triple shootTarget = null;
            if (playerTarget == null) {
                targetVector = new Triple(targetVector.x * scale, targetVector.y * scale, this.agentLocation.z);
                shootTarget = Triple.add(this.agentLocation, targetVector);
            } else {
                shootTarget = playerTarget;
            }
            if (this.secondaryFire) {
                body.shootAlternate(shootTarget);
            } else {
                body.shoot(shootTarget);
            }
        } else {
            body.stopShoot();
        }
    }
}

