/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.sensormodel;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import java.util.Map;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.agentmodel.sensormodel.BestSensorModel;

public class MimicSensorModel
extends BestSensorModel {
    public MimicSensorModel(int levelTraces, int airTraces, int groundTraces, double[] sliceLimits, int secondsHistory) {
        super(levelTraces, airTraces, groundTraces, sliceLimits, secondsHistory);
    }

    public MimicSensorModel() {
        this(12, 6, 4, new double[]{0.0, 0.02454369260617026, 0.09817477042468103, 0.7853981633974483, 1.5707963267948966, Math.PI}, 3);
    }

    @Override
    public double[] getMiscSensors(AgentMemory memory) {
        double[] sensors = new double[this.getNumMiscSensors()];
        double[] oldSensors = super.getMiscSensors(memory);
        int numOldMisc = super.getNumMiscSensors();
        System.arraycopy(oldSensors, 0, sensors, 0, numOldMisc);
        int numMisc = 0;
        sensors[numOldMisc + numMisc++] = memory.inWater() ? 1.0 : 0.0;
        Player p = memory.getCombatTarget();
        if (p != null) {
            sensors[numOldMisc + numMisc++] = memory.isAdvancing(p) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = memory.isRetreating(p) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = memory.isStrafing(p, true) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = memory.isStrafing(p, false) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = AgentMemory.isStill(p) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = AgentMemory.isJumping(p) ? 1.0 : 0.0;
            sensors[numOldMisc + numMisc++] = p.getLocation() != null && memory.isAboveMe((ILocated)p.getLocation()) ? 1.0 : 0.0;
            String weapon = p.getWeapon() + "Pickup";
            ItemType weaponType = ItemType.getItemType((String)weapon);
            if (weaponType != null) {
                Map examples = memory.items.getAllItems(weaponType);
                WeaponDescriptor descriptor = null;
                if (!examples.isEmpty()) {
                    Item[] items = new Item[]{};
                    items = examples.values().toArray(items);
                    Item specificWeapon = items[0];
                    descriptor = (WeaponDescriptor)specificWeapon.getDescriptor();
                } else {
                    descriptor = memory.weaponry.getWeaponDescriptor(weaponType);
                }
                if (descriptor != null) {
                    sensors[numOldMisc + numMisc++] = descriptor.getPriDamage() / 100.0;
                    sensors[numOldMisc + numMisc++] = descriptor.getSecDamage() / 100.0;
                    sensors[numOldMisc + numMisc++] = descriptor.isSniping() ? 1.0 : 0.0;
                    sensors[numOldMisc + numMisc++] = descriptor.isPriSplashDamage() || descriptor.isSecSplashDamage() ? 1.0 : 0.0;
                    sensors[numOldMisc + numMisc++] = descriptor.getPriFireRate();
                    sensors[numOldMisc + numMisc++] = descriptor.getPriBotRefireRate();
                    sensors[numOldMisc + numMisc++] = descriptor.getSecFireRate();
                    sensors[numOldMisc + numMisc++] = descriptor.getSecBotRefireRate();
                }
            }
        }
        return sensors;
    }

    @Override
    public int getNumMiscSensors() {
        return super.getNumMiscSensors() + 1 + 7 + 8;
    }
}

