/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.sensormodel;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import javax.vecmath.Vector3d;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.sensormodel.MimicSensorModel;

public class ProjectileSensorModel
extends MimicSensorModel {
    public ProjectileSensorModel(int levelTraces, int airTraces, int groundTraces, double[] sliceLimits, int secondsHistory) {
        super(levelTraces, airTraces, groundTraces, sliceLimits, secondsHistory);
    }

    public ProjectileSensorModel() {
        this(12, 6, 4, new double[]{0.0, 0.02454369260617026, 0.09817477042468103, 0.7853981633974483, 1.5707963267948966, Math.PI}, 3);
    }

    @Override
    public double[] getMiscSensors(AgentMemory memory) {
        IncomingProjectile ip;
        double[] sensors = new double[this.getNumMiscSensors()];
        double[] oldSensors = super.getMiscSensors(memory);
        int numOldMisc = super.getNumMiscSensors();
        System.arraycopy(oldSensors, 0, sensors, 0, numOldMisc);
        int numMisc = 0;
        boolean incoming = memory.senses.seeIncomingProjectile();
        double d = sensors[numOldMisc + numMisc++] = incoming ? 1.0 : 0.0;
        if (incoming && (ip = memory.senses.getLastIncomingProjectile()) != null) {
            Location agent = memory.info.getLocation();
            Location proj = ip.getLocation();
            Vector3d dir = ip.getDirection();
            Location origin = ip.getOrigin();
            Location futureLocation = Triple.add(Triple.locationToTriple(proj), Triple.vector3dToTriple(dir)).getLocation();
            if (proj != null && agent != null && dir != null && origin != null && futureLocation != null) {
                sensors[numOldMisc + numMisc++] = ProjectileSensorModel.scaleDistance(agent.getDistance(proj));
                sensors[numOldMisc + numMisc++] = ProjectileSensorModel.scaleDistance(agent.getDistance(futureLocation) - agent.getDistance(proj));
                sensors[numOldMisc + numMisc++] = ProjectileSensorModel.scaleDistance(agent.getDistance(origin) - agent.getDistance(proj));
            }
        }
        return sensors;
    }

    @Override
    public int getNumMiscSensors() {
        return super.getNumMiscSensors() + 4;
    }
}

