/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.TWEANN;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.io.PrintWriter;
import java.util.HashMap;
import machinelearning.evolution.evolvables.Evolvable;
import machinelearning.networks.TWEANN;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.ActionLog;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.ApproachEnemyAction;
import utopia.agentmodel.actions.AvoidEnemyAction;
import utopia.agentmodel.actions.EmptyAction;
import utopia.agentmodel.actions.EnemyRelativeStrafeAction;
import utopia.agentmodel.actions.GotoItemAction;
import utopia.agentmodel.actions.StillAction;
import utopia.agentmodel.sensormodel.SensorModel;
import utopia.controllers.TWEANN.TWEANNController;

public class AlwaysShootTWEANNController
extends TWEANNController {
    public transient HashMap<String, Double> actionStartTimes = new HashMap();
    public static final transient int CONSECUTIVE_STILL_LIMIT = 10;
    public static final transient int NO_STILL_ZONE = 200;
    public int consecutiveStills = 0;
    public static final transient int ADVANCE_OUTPUT = 0;
    public static final transient int RETREAT_OUTPUT = 1;
    public static final transient int LEFT_OUTPUT = 2;
    public static final transient int RIGHT_OUTPUT = 3;
    public static final transient int ITEM_OUTPUT = 4;
    public static final transient int STILL_OUTPUT = 5;
    public static final transient int JUMP_OUTPUT = 6;
    public static final transient int NUM_OUTPUTS = 7;
    private transient Item nearestVisibleItem = null;
    public static final transient int NUM_BATTLE_ACTIONS = 6;
    public transient int[] forcedActionCount = null;
    public static final transient int NUM_SHOOT_CHOICES = 3;
    public transient int[] shootChoices = null;
    public static final transient int SHOOT_PRIMARY_INDEX = 0;
    public static final transient int SHOOT_SECONDARY_INDEX = 1;
    public static final transient int SHOOT_NOTHING_INDEX = 2;
    public static final transient int NUM_JUMP_CHOICES = 2;
    public transient int[] jumpChoices = null;
    public static final transient int JUMP_YES = 0;
    public static final transient int JUMP_NO = 1;
    public static final transient int NUM_STILL_FORCED_CHOICES = 2;
    public transient int[] stillForcedChoices = null;
    public static final transient int STILL_FORCED_NO = 0;
    public static final transient int STILL_FORCED_YES = 1;
    public static transient double MOMENTUM_TIME = 2.0;

    @Override
    public void init() {
        this.forcedActionCount = new int[6];
        this.shootChoices = new int[3];
        this.jumpChoices = new int[2];
        this.stillForcedChoices = new int[2];
    }

    @Override
    public void logActionChoices(PrintWriter actionLog) {
        super.logActionChoices(actionLog);
        actionLog.println("STILL FORCED CHOICES");
        int totalStillActions = this.stillForcedChoices[1] + this.stillForcedChoices[0];
        actionLog.println("Total Still Actions: " + totalStillActions);
        actionLog.println(ActionLog.actionLogLine(null, "Forced Still ", this.stillForcedChoices[1], totalStillActions));
        actionLog.println(ActionLog.actionLogLine(null, "Natural Still", this.stillForcedChoices[0], totalStillActions));
        actionLog.println();
        actionLog.println("FORCED ACTIONS");
        int totalForcedActions = this.forcedActionCount[0] + this.forcedActionCount[1] + this.forcedActionCount[2] + this.forcedActionCount[3] + this.forcedActionCount[4] + this.forcedActionCount[5];
        actionLog.println("Total Forced Actions: " + totalForcedActions);
        actionLog.println(ActionLog.actionLogLine(null, "Forced Advance    ", this.forcedActionCount[0], totalForcedActions));
        actionLog.println(ActionLog.actionLogLine(null, "Forced Retreat    ", this.forcedActionCount[1], totalForcedActions));
        actionLog.println(ActionLog.actionLogLine(null, "Forced StrafeLeft ", this.forcedActionCount[2], totalForcedActions));
        actionLog.println(ActionLog.actionLogLine(null, "Forced StrafeRight", this.forcedActionCount[3], totalForcedActions));
        actionLog.println(ActionLog.actionLogLine(null, "Forced GotoItem   ", this.forcedActionCount[4], totalForcedActions));
        actionLog.println(ActionLog.actionLogLine(null, "Forced Still      ", this.forcedActionCount[5], totalForcedActions));
        actionLog.println();
        actionLog.println("SHOOT CHOICES");
        int totalShootChoices = this.shootChoices[0] + this.shootChoices[1] + this.shootChoices[2];
        actionLog.println("Total Shoot Choices: " + totalShootChoices);
        actionLog.println(ActionLog.actionLogLine(null, "Primary  ", this.shootChoices[0], totalShootChoices));
        actionLog.println(ActionLog.actionLogLine(null, "Secondary", this.shootChoices[1], totalShootChoices));
        actionLog.println(ActionLog.actionLogLine(null, "None     ", this.shootChoices[2], totalShootChoices));
        actionLog.println();
        actionLog.println("JUMP CHOICES");
        int totalJumpChoices = this.jumpChoices[0] + this.jumpChoices[1];
        actionLog.println("Total Jump Choices: " + totalJumpChoices);
        actionLog.println(ActionLog.actionLogLine(null, "Jump   ", this.jumpChoices[0], totalJumpChoices));
        actionLog.println(ActionLog.actionLogLine(null, "No Jump", this.jumpChoices[1], totalJumpChoices));
        actionLog.println();
    }

    public AlwaysShootTWEANNController(TWEANN tweann, SensorModel model) {
        super(tweann, model);
        this.numNonSensory = 1;
    }

    @Override
    public void registerActions() {
        this.register("Still");
        this.register("Advance");
        this.register("Retreat");
        this.register("Strafe Left");
        this.register("Strafe Right");
        this.register("Goto Item");
        this.register("Empty");
    }

    public AlwaysShootTWEANNController(SensorModel model) {
        this(new TWEANN(model.getNumSensors() + 1, 7, true), model);
    }

    @Override
    public Action control(AgentMemory memory) {
        if (this.actionStartTimes == null) {
            this.actionStartTimes = new HashMap();
        }
        double[] outputs = this.processInputsToOutputs(memory);
        double[] actionchoices = new double[outputs.length - 1];
        System.arraycopy(outputs, 0, actionchoices, 0, actionchoices.length);
        int choice = this.actionChoiceFilter(memory, AlwaysShootTWEANNController.argmax(actionchoices), actionchoices);
        boolean shoot = true;
        boolean jump = outputs[6] > 0.0;
        return this.getActionDecision(memory, choice, shoot, jump);
    }

    protected int actionChoiceFilter(AgentMemory memory, int choice, double[] actionchoices) {
        boolean sniping;
        boolean notFacing;
        double lastDamagedTime;
        double currentTime;
        boolean damagedSelf;
        boolean farWithCloseWeapon;
        this.nearestVisibleItem = memory.info.getNearestVisibleItem();
        if (this.nearestVisibleItem == null || !GotoItemAction.willGoto(memory, this.nearestVisibleItem)) {
            actionchoices[4] = -1.7976931348623157E308;
            if (choice == 4) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
        }
        boolean disallowRetreat = false;
        if (!this.actionAllowed("Retreat", memory) || memory.backWallClose() || memory.onElevator()) {
            disallowRetreat = true;
            actionchoices[1] = -1.7976931348623157E308;
            if (choice == 1) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
        }
        boolean disallowAdvance = false;
        if (!this.actionAllowed("Advance", memory)) {
            actionchoices[0] = -1.7976931348623157E308;
            disallowAdvance = true;
            if (choice == 0) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
        }
        Weapon w = memory.getCurrentWeapon();
        boolean snipingWeapon = memory.body.isSnipingWeapon(w);
        Player enemy = memory.getCombatTarget();
        Location loc = memory.info.getLocation();
        ItemType enemyWeaponType = memory.enemyWeaponType(enemy);
        if (enemy != null) {
            double distance = loc.getDistance(enemy.getLocation());
            if (enemyWeaponType != null && enemyWeaponType.equals((Object)ItemType.SHIELD_GUN) && memory.isAdvancing(enemy) || snipingWeapon && distance < 2500.0 || w != null && w.getType().equals((Object)ItemType.ROCKET_LAUNCHER) && distance < 1250.0 && !memory.isRetreating(enemy) || distance < 600.0) {
                actionchoices[0] = -1.7976931348623157E308;
                disallowAdvance = true;
                if (choice == 0) {
                    choice = AlwaysShootTWEANNController.argmax(actionchoices);
                }
            }
            if (!disallowRetreat && (distance < 200.0 && snipingWeapon || memory.frontWallClose() && distance > 150.0)) {
                this.forcedActionCount[1] = this.forcedActionCount[1] + 1;
                System.out.println("\tForced RETREAT");
                if (distance < 200.0 && snipingWeapon) {
                    System.out.println("\tToo close to snipe, so RETREAT");
                }
                if (memory.frontWallClose() && distance > 150.0) {
                    System.out.println("\tStaring at wall, so RETREAT");
                }
                return 1;
            }
        }
        Player nearestEnemy = memory.getSeeEnemy();
        double distance = Double.MAX_VALUE;
        if (nearestEnemy != null) {
            distance = loc.getDistance(nearestEnemy.getLocation());
        }
        boolean getCloseWeapon = memory.body.isGetCloseWeapon(w);
        boolean generalThreatened = memory.isThreatened();
        boolean enemyThreatened = enemy != null && memory.isThreatening(enemy) || nearestEnemy != null && memory.isThreatening(nearestEnemy);
        boolean threatened = generalThreatened || enemyThreatened;
        boolean highGround = memory.botHasHighGround();
        boolean bl = farWithCloseWeapon = getCloseWeapon && distance > 600.0;
        if (!disallowAdvance && (w != null && w.getType().equals((Object)ItemType.BIO_RIFLE) && memory.info.isSecondaryShooting() != false && distance >= 600.0 || farWithCloseWeapon)) {
            this.forcedActionCount[0] = this.forcedActionCount[0] + 1;
            System.out.println("\tForced ADVANCE");
            System.out.println("\tADVANCE for Bio Rifle charge");
            return 0;
        }
        boolean disallowLeft = false;
        if (!this.actionAllowed("Strafe Left", memory)) {
            actionchoices[2] = -1.7976931348623157E308;
            if (choice == 2) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
            disallowLeft = true;
        }
        boolean disallowRight = false;
        if (!this.actionAllowed("Strafe Right", memory)) {
            actionchoices[3] = -1.7976931348623157E308;
            if (choice == 3) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
            disallowRight = true;
        }
        boolean disallowStrafe = false;
        if (distance < 300.0) {
            actionchoices[2] = -1.7976931348623157E308;
            actionchoices[3] = -1.7976931348623157E308;
            disallowStrafe = true;
            if (choice == 2 || choice == 3) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
            }
        }
        BotDamaged damaged = memory.senses.getLastDamage();
        boolean damagedRecently = false;
        boolean bl2 = damagedSelf = damaged != null && damaged.getInstigator() != null && damaged.getInstigator().equals((Object)memory.info.getId());
        if (damagedSelf) {
            System.out.println("DAMAGED SELF:" + damaged.getWeaponName() + ":" + damaged.getDamageType());
        }
        if (damaged != null && !damaged.isCausedByWorld() && damaged.getInstigator() != null && !damaged.getInstigator().equals((Object)memory.info.getId()) && (currentTime = memory.info.getTime()) - (lastDamagedTime = (double)damaged.getSimTime()) < 1.25) {
            damagedRecently = true;
        }
        boolean snipingEnemy = memory.enemyIsSniping(enemy);
        boolean onElevator = memory.onElevator();
        boolean closeThreat = threatened && distance < 600.0;
        boolean disallowStill = false;
        boolean bl3 = notFacing = memory.info.isFacing((ILocated)enemy, 30.0) == false;
        if (this.consecutiveStills > 10 || notFacing && !highGround || damagedRecently || snipingEnemy || closeThreat || onElevator || distance < 200.0 || farWithCloseWeapon) {
            actionchoices[5] = -1.7976931348623157E308;
            disallowStill = true;
            System.out.println((this.consecutiveStills > 10 ? "Still Limit, " : "") + (notFacing && !highGround ? "won't shoot " : "") + (damagedRecently ? "damagedRecently, " : "") + (snipingEnemy ? "snipingEnemy, " : "") + (closeThreat ? "closeThreat, " : "") + (generalThreatened ? "generalThreatened, " : "") + (enemyThreatened ? "enemyThreatened, " : "") + (onElevator ? "onElevator, " : "") + (distance < 200.0 ? "Too Close, " : "") + (farWithCloseWeapon ? "farWithCloseWeapon, " : ""));
            if (choice == 5) {
                choice = AlwaysShootTWEANNController.argmax(actionchoices);
                System.out.println("\tSwap STILL with " + choice);
            }
        }
        boolean safeWithFarWeapon = !threatened && !getCloseWeapon;
        boolean safeWithCloseWeapon = !threatened && getCloseWeapon && nearestEnemy != null && distance < 2500.0 && distance > 300.0;
        boolean bl4 = sniping = snipingWeapon && nearestEnemy != null && distance > 1250.0 && (highGround || !threatened || Math.random() < 0.5);
        if (!disallowStill && choice != 5 && (choice != 0 || highGround || !getCloseWeapon) && (safeWithFarWeapon || safeWithCloseWeapon || sniping)) {
            this.stillForcedChoices[1] = this.stillForcedChoices[1] + 1;
            this.forcedActionCount[5] = this.forcedActionCount[5] + 1;
            System.out.println("\tForced STILL");
            System.out.println((safeWithFarWeapon ? "safeWithFarWeapon " : "") + (safeWithCloseWeapon ? "safeWithCloseWeapon " : "") + (sniping ? "sniping " : ""));
            return 5;
        }
        if (choice == 5) {
            this.stillForcedChoices[0] = this.stillForcedChoices[0] + 1;
        }
        if (!disallowStrafe && choice == 2 && memory.sideWallClose(true)) {
            this.forcedActionCount[3] = this.forcedActionCount[3] + 1;
            System.out.println("\tForced RIGHT");
            System.out.println("\tRIGHT away from close wall");
            return 3;
        }
        if (!disallowStrafe && choice == 3 && memory.sideWallClose(false)) {
            this.forcedActionCount[2] = this.forcedActionCount[2] + 1;
            System.out.println("\tForced LEFT");
            System.out.println("\tLEFT away from close wall");
            return 2;
        }
        return choice;
    }

    public void takeAction(String key, AgentMemory memory) {
        String previous = this.lastActionLabel();
        if (!previous.equals(key)) {
            this.actionStartTimes.put(key, memory.game.getTime());
        }
        this.takeAction(key);
    }

    private boolean actionAllowed(String key, AgentMemory memory) {
        double time;
        Double actionTime = this.actionStartTimes.get(key);
        if (actionTime == null) {
            actionTime = 0.0;
        }
        return (time = memory.game.getTime() - actionTime) > MOMENTUM_TIME;
    }

    public Action getActionDecision(AgentMemory memory, int choice, boolean shoot, boolean jump) {
        this.firePrimary = Utils.randomBool();
        Action result = null;
        if (choice == 5) {
            jump = false;
            shoot = true;
            this.takeAction("Still", memory);
            result = new StillAction(memory, true, !this.firePrimary, false);
        } else if (choice == 0) {
            this.takeAction("Advance", memory);
            result = new ApproachEnemyAction(memory, shoot, !this.firePrimary, jump, false);
        } else if (choice == 1) {
            this.takeAction("Retreat", memory);
            result = new AvoidEnemyAction(memory, shoot, !this.firePrimary, jump);
        } else if (choice == 2) {
            this.takeAction("Strafe Left", memory);
            result = new EnemyRelativeStrafeAction(memory, shoot, !this.firePrimary, true, jump);
        } else if (choice == 3) {
            this.takeAction("Strafe Right", memory);
            result = new EnemyRelativeStrafeAction(memory, shoot, !this.firePrimary, false, jump);
        } else if (choice == 4 && this.nearestVisibleItem != null) {
            this.takeAction("Goto Item", memory);
            result = new GotoItemAction(memory, this.nearestVisibleItem, shoot, !this.firePrimary, jump);
        } else {
            this.takeAction("Empty", memory);
            result = new EmptyAction();
        }
        this.logShootAndJump(shoot, jump);
        this.consecutiveStills = result instanceof StillAction ? ++this.consecutiveStills : 0;
        return result;
    }

    @Override
    public Evolvable getNewInstance() {
        return new AlwaysShootTWEANNController((TWEANN)this.tweann.getNewInstance(), this.model);
    }

    @Override
    public Evolvable copy() {
        return new AlwaysShootTWEANNController((TWEANN)this.tweann.copy(), this.model);
    }

    protected void logShootAndJump(boolean shoot, boolean jump) {
        if (shoot) {
            if (this.firePrimary) {
                this.shootChoices[0] = this.shootChoices[0] + 1;
            } else {
                this.shootChoices[1] = this.shootChoices[1] + 1;
            }
        } else {
            this.shootChoices[2] = this.shootChoices[2] + 1;
        }
        if (jump) {
            this.jumpChoices[0] = this.jumpChoices[0] + 1;
        } else {
            this.jumpChoices[1] = this.jumpChoices[1] + 1;
        }
    }

    @Override
    public void reset() {
        super.reset();
    }
}

