/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.TWEANN;

import machinelearning.networks.FunctionApproximator;
import machinelearning.networks.TWEANN;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.Controller;
import utopia.agentmodel.EvolvableController;
import utopia.agentmodel.sensormodel.SensorModel;

public abstract class TWEANNController
extends EvolvableController {
    protected transient boolean firePrimary = true;
    private static final transient double TURNING_THRESHOLD = 0.35;
    public TWEANN tweann;
    protected int numOutputs;
    protected int numNonSensory;
    public static final transient boolean featureSelective = true;

    public void init() {
    }

    @Override
    public FunctionApproximator getFunctionApproximator() {
        return this.tweann;
    }

    public double turnAmountFromNetOutput(double turning) {
        turning = Math.abs(turning) < 0.35 ? 0.0 : (turning - Math.signum(turning) * 0.35) / 0.65;
        return turning;
    }

    protected double[] processInputsToOutputs(AgentMemory memory) {
        double[] sensors = this.model.getSensors(memory);
        double[] inputs = new double[this.getNumInputs()];
        inputs[0] = 1.0;
        System.arraycopy(sensors, 0, inputs, this.numNonSensory, sensors.length);
        double[] outputs = this.tweann.propagate(inputs);
        return outputs;
    }

    public static int argmax(double[] values) {
        int x = Utils.randomInt(0, values.length - 1);
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > values[x])) continue;
            x = i;
        }
        return x;
    }

    public TWEANNController() {
        this.model = null;
    }

    public TWEANNController(TWEANN tweann, SensorModel model) {
        this.tweann = tweann;
        this.numOutputs = tweann.getNumberOfOutputs();
        this.model = model;
    }

    @Override
    public void reset() {
        this.tweann.flush();
    }

    @Override
    public void mutate() {
        this.tweann.mutate();
    }

    protected int getNumInputs() {
        return this.model.getNumSensors() + this.numNonSensory;
    }

    @Override
    public final Controller clone() {
        return (Controller)((Object)this.copy());
    }
}

