/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.utexas.cs.nn.bots.UT2;
import mockcz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import mockcz.cuni.amis.pogamut.ut2004.agent.navigation.MyUTPathExecutor;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.Controller;

public abstract class PathController
extends Controller {
    public static final double TARGET_REACHED_DISTANCE = 30.0;
    public TabooSet<Item> tabooItems;
    public TabooSet<NavPoint> tabooNavPoints;
    public final MyUTPathExecutor pathExecutor;
    public final PathPlanner pathPlanner;
    protected Item item;
    public boolean retraceFailed = false;

    public PathController(UT2004Bot bot, MyUTPathExecutor pathExecutor, PathPlanner pathPlanner) {
        this.pathExecutor = pathExecutor;
        this.pathPlanner = pathPlanner;
        this.item = null;
        this.tabooItems = new TabooSet(bot);
        this.tabooNavPoints = new TabooSet(bot);
    }

    public static boolean wantItem(AgentMemory memory, Item i) {
        if (i.getType().getName().equals("XPickups.AdrenalinePickup") || i.getType().equals((Object)ItemType.ADRENALINE_PACK) || i.getType().getCategory().equals((Object)ItemType.Category.ADRENALINE)) {
            return false;
        }
        if (UT2.canJudge() && (i.getType().equals((Object)ItemType.LINK_GUN_AMMO) || i.getType().equals((Object)ItemType.LINK_GUN))) {
            return false;
        }
        ItemType.Category cat = i.getDescriptor().getItemCategory();
        if (cat.equals((Object)ItemType.Category.AMMO)) {
            return !UT2.canJudge() || !i.getDescriptor().getPickupType().equals((Object)ItemType.LINK_GUN_AMMO);
        }
        if (cat.equals((Object)ItemType.Category.WEAPON)) {
            if (UT2.canJudge() && i.getDescriptor().getPickupType().equals((Object)ItemType.LINK_GUN)) {
                return false;
            }
            if (i.getDescriptor().getPickupType().equals((Object)ItemType.ONS_GRENADE_LAUNCHER)) {
                return false;
            }
            if (memory.weaponry.getCurrentWeapon() == null) {
                return true;
            }
            boolean canSeeEnemies = memory.players.canSeeEnemies();
            if (!canSeeEnemies) {
                return true;
            }
            ItemType current = memory.weaponry.getCurrentWeapon().getType();
            ItemType other = i.getType();
            double distance = 2501.0;
            if (canSeeEnemies && memory.getCombatTarget() != null && memory.getCombatTarget().getLocation() != null && memory.info.getLocation() != null) {
                distance = Triple.distanceInSpace(memory.getCombatTarget().getLocation(), memory.info.getLocation());
            }
            return !memory.weaponry.hasWeapon(other) && UT2.weaponPreferences.betterWeapon(current, other, distance);
        }
        if (cat.equals((Object)ItemType.Category.SHIELD)) {
            return true;
        }
        if (cat.equals((Object)ItemType.Category.HEALTH)) {
            if (i.getType().equals((Object)ItemType.SUPER_HEALTH_PACK)) {
                return true;
            }
            ItemType current = memory.weaponry.getCurrentWeapon().getType();
            return memory.info.getHealth() == null || memory.info.getHealth() < 90 || !current.equals((Object)ItemType.ASSAULT_RIFLE) && !current.equals((Object)ItemType.SHIELD_GUN) && !current.equals((Object)ItemType.LINK_GUN);
        }
        if (cat.equals((Object)ItemType.Category.ARMOR)) {
            if (i.getType().equals((Object)ItemType.SUPER_SHIELD_PACK)) {
                return true;
            }
            ItemType current = memory.weaponry.getCurrentWeapon().getType();
            return memory.info.getHealth() == null || memory.info.getHealth() < 90 || !current.equals((Object)ItemType.ASSAULT_RIFLE) && !current.equals((Object)ItemType.SHIELD_GUN) && !current.equals((Object)ItemType.LINK_GUN);
        }
        if (cat.equals((Object)ItemType.Category.OTHER)) {
            return !i.getType().equals((Object)ItemType.ADRENALINE_PACK);
        }
        return true;
    }

    public Item getItem() {
        return this.item;
    }

    public String itemName() {
        return this.item == null ? "" : this.item.getType().getName();
    }

    @Override
    public void reset() {
        this.pathExecutor.setFocus(null);
        if (this.item != null) {
            this.tabooItems.add((Object)this.item);
        }
        this.item = null;
        this.wasStuck = false;
        this.retraceFailed = false;
    }

    public void stop() {
        this.pathExecutor.stop();
        this.reset();
    }
}

