/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.utexas.cs.nn.retrace.HumanRetraceController;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.Utils;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.DodgeShootAction;
import utopia.agentmodel.actions.GotoItemAction;
import utopia.agentmodel.actions.MoveAwayFromLocationAction;
import utopia.agentmodel.actions.MoveForwardAction;
import utopia.agentmodel.actions.MoveToLocationAction;
import utopia.controllers.scripted.NeedyController;

public final class UnstuckController
extends NeedyController {
    public static final int HUMAN_TRACES_NOT_WORKING = 15;
    public static final int STANDARD_UNSTUCK_CHANCES = 3;
    public int consecutiveStuckActions;
    private int stuckReason;
    public static final double COLlISION_ACCUMULATOR_DECAY_RATE = 0.1;
    public static final double COLLISION_ACCUMULATION_TOLERANCE = 2.0;
    public static final double STUCK_ACCUMULATOR_DECAY_RATE = 0.1;
    public static final double STUCK_ACCUMULATION_TOLERANCE = 3.0;
    private double collisionAccumulator = 0.0;
    private double stuckAccumulator = 0.0;
    private HumanRetraceController humanRetraceController;
    public static boolean USE_HUMAN_TRACES = true;

    public UnstuckController(HumanRetraceController hrc) {
        this.reset();
        this.humanRetraceController = hrc;
        this.register("Human Trace");
        this.register("Goto Item");
        this.register("Move Away");
        this.register("Dodge");
        this.register("Forward");
        this.register("Move To");
    }

    public Action control(AgentMemory memory, int reason) {
        this.setStuckReason(reason);
        return this.control(memory);
    }

    public boolean stuckFromFrequentCollisions() {
        return this.collisionAccumulator > 2.0;
    }

    public void setStuckReason(int reason) {
        if (reason == 2) {
            this.collisionAccumulator += 1.0;
        }
        this.stuckAccumulator += 1.0;
        this.stuckReason = reason;
    }

    public Action humanAction(AgentMemory memory) {
        Action a;
        if (!USE_HUMAN_TRACES || this.stuckReason == 9) {
            return null;
        }
        if (this.consecutiveStuckActions > 15) {
            if (this.humanRetraceController != null) {
                this.humanRetraceController.reset();
            }
            return null;
        }
        if (this.humanRetraceController != null && (a = this.humanRetraceController.control(memory)) != null) {
            this.takeAction("Human Trace");
            return a;
        }
        return null;
    }

    @Override
    public Action control(AgentMemory memory) {
        double p;
        Action human;
        ++this.consecutiveStuckActions;
        if (this.consecutiveStuckActions > 3 || this.stuckAccumulator > 3.0) {
            human = this.humanAction(memory);
            if (human != null) {
                return human;
            }
        } else {
            if (this.stuckReason == 9) {
                Item item = memory.info.getNearestItem();
                Location loc = memory.info.getLocation();
                String map = memory.game.getMapName();
                System.out.println("\tUnder elevator in " + map);
                if (map.toUpperCase().equals("DM-CURSE4")) {
                    NavPoint nearestLiftExit = memory.nearestLiftExit();
                    System.out.println("\tNearest Exit:" + nearestLiftExit.getId().getStringId());
                    if (nearestLiftExit.getId().getStringId().toUpperCase().equals("DM-CURSE4.LIFTEXIT2")) {
                        System.out.println("\tEscape Curse4 Elevator Trap");
                        this.takeAction("Move Away");
                        return new MoveToLocationAction(memory, new Location(1125.0, -584.0, -105.0), memory.getCombatTarget(), true);
                    }
                }
                if (item != null && loc != null && item.getLocation() != null && item.getLocation().z <= loc.z + 30.0) {
                    return this.gotoItem(memory);
                }
                return this.dodgeAction(memory);
            }
            if (this.stuckReason == 0 && (human = this.humanAction(memory)) != null) {
                return human;
            }
            if (this.stuckReason == 5 && (human = this.humanAction(memory)) != null) {
                return human;
            }
            if (this.stuckReason == 6 && (human = this.humanAction(memory)) != null) {
                return human;
            }
            if (this.stuckReason == 8) {
                return this.dodgeAction(memory);
            }
            if (this.stuckReason == 1) {
                human = this.humanAction(memory);
                if (human != null) {
                    return human;
                }
                return this.forwardAction();
            }
            if (this.stuckReason == 2 && memory.senses.getCollisionLocation() != null) {
                return this.moveAway(memory, memory.senses.getCollisionLocation().getLocation());
            }
            if (this.stuckReason == 3 && memory.senses.getBumpLocation() != null) {
                return this.moveAway(memory, memory.senses.getBumpLocation().getLocation());
            }
            if (this.stuckReason == 4) {
                return this.dodgeAction(memory);
            }
        }
        if ((p = Math.random()) < 0.25) {
            return this.dodgeAction(memory);
        }
        if (p < 0.5) {
            return this.forwardAction();
        }
        if (p < 0.75) {
            return this.moveAway(memory, null);
        }
        return this.gotoItem(memory);
    }

    public Action gotoItem(AgentMemory memory) {
        this.takeAction("Goto Item");
        return new GotoItemAction(memory, memory.info.getNearestItem());
    }

    @Override
    public void reset() {
        this.consecutiveStuckActions = 0;
        this.stuckReason = 4;
    }

    @Override
    public void tick(AgentMemory memory) {
        if (this.humanRetraceController != null) {
            this.humanRetraceController.tick(memory);
        }
    }

    public void decay() {
        this.collisionAccumulator *= 0.9;
        this.stuckAccumulator *= 0.9;
    }

    @Override
    public boolean isStillInterested(AgentMemory agent) {
        return false;
    }

    private Action moveAway(AgentMemory memory, Location hitLoc) {
        this.takeAction("Move Away");
        if (hitLoc == null || Math.random() < 0.5) {
            Triple longest = memory.getLongestTraceToWall();
            return new MoveToLocationAction(memory, memory.info.getLocation().add(longest.getLocation()), memory.getCombatTarget());
        }
        return new MoveAwayFromLocationAction(memory, hitLoc);
    }

    private Action dodgeAction(AgentMemory memory) {
        this.takeAction("Dodge");
        Triple longest = memory.getLongestTraceToWall();
        if (longest != null && this.consecutiveStuckActions < 6) {
            return new DodgeShootAction(longest, memory.getAgentLocation(), memory.getAgentRotation());
        }
        return new DodgeShootAction((double)Utils.randposneg() * Math.random(), memory.getAgentLocation(), memory.getAgentRotation());
    }

    private Action forwardAction() {
        this.takeAction("Forward");
        return new MoveForwardAction();
    }

    @Override
    public void onBotInitialized(AgentMemory memory) {
    }

    @Override
    public void onBotShutdown(AgentMemory memory) {
    }
}

