
#include <mex.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdint.h>
#include <math.h>
#include <time.h>
//#include "fastonebigheader.h"
#include <sys/time.h>


class Timer {
     timeval timer[2];
	   public:
		        timeval StartTimer(void) {
			             gettimeofday(&this->timer[0], NULL);
				          return this->timer[0];
				       }
	        timeval StopTimer(void) {
		             gettimeofday(&this->timer[1], NULL);
			          return this->timer[1];
			       }
	         double ElapsedTime(void) const {
			          double secs(this->timer[1].tv_sec - this->timer[0].tv_sec);
       double usecs(this->timer[1].tv_usec - this->timer[0].tv_usec);
	             if(usecs < 0) {
			              --secs;
			               usecs += 1000000;
			            }
		          return (secs * 1000 + usecs / 1000.0);
		       }
};



void exit_with_help()
{
	mexPrintf(
 "[score_predict] = Prediction(X, w, numiter)\n"
 "input arguments: \n"
 "      X   : the d by n dense data  matrix. \n"
 "      w      : the model. \n"
 "      numiter: number of iterations goes. \n"
 "output arguments: \n"
 "      score_predict: the prediction score (n)\n"
	);
}


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

	long argIdx = 0;

	if (!mxIsDouble(prhs[argIdx])) {
		mexErrMsgIdAndTxt("GG:Type",
				"Expected a double matrix. (Arg. %d)", argIdx + 1);
	}
	double* X = mxGetPr(prhs[argIdx]);
	int num_ftr = (int)mxGetM(prhs[argIdx]);
	int num_tp = (int)mxGetN(prhs[argIdx]);

	argIdx++;
	double* w = mxGetPr(prhs[argIdx]);
	argIdx++;
	int niter = (int)mxGetScalar(prhs[argIdx]);

	double *pred = NULL;
	mxArray *tmp = mxCreateDoubleMatrix(num_tp, 1, mxREAL);
	pred = (double*)mxGetPr(tmp);
	memset(pred, 0, sizeof(double)*num_tp);
	plhs[0] = tmp;
	

	//Doing the prediction stuff
	double sum_tp[num_tp];
	struct timeval timer[2];
	double p_time[niter];
	double p_time_sq[niter];
	double p_time_sum=0;
	double p_time_sq_sum=0;
	int vld;
	
	for(vld=0;vld<niter;vld++){
		gettimeofday(&timer[0], NULL);
		double tmpsum = 0;
		for(int i = 0; i<num_tp;i++)
		{
			tmpsum = 0;
			for(int k = 0; k<num_ftr; k++)
			{
				tmpsum = tmpsum+X[i*num_ftr+k]*w[k];
			}
			pred[i] = tmpsum;	
		}
		gettimeofday(&timer[1], NULL);
		double secs = (timer[1].tv_sec - timer[0].tv_sec);
		double usecs = (timer[1].tv_usec - timer[0].tv_usec);
		if(usecs < 0) {
			--secs;
			usecs += 1000000;
		}
		double prediction_time= (secs * 1000 + usecs / 1000.0);
		printf("Prediction Time: %f mili seconds, exp: %d\n",prediction_time,vld);
		p_time[vld]=prediction_time;
		p_time_sum+=prediction_time;
		p_time_sq_sum+=prediction_time*prediction_time;
		p_time_sq[vld]=prediction_time*prediction_time;
	}
	p_time_sum=p_time_sum/niter;
	p_time_sq_sum=p_time_sq_sum/niter;
	plhs[0] = mxCreateDoubleScalar(p_time_sum);	
	double std=sqrt(p_time_sq_sum-p_time_sum*p_time_sum);
	printf("Mean Prediction Time is: %f mili seconds and std dev is: %f\n",p_time_sum,std);
	

}
