function [labels time] = dcpred_predict(y, X, dcpred_model, gamma)
%
%    Usage:
%
%    [labels] = dcpred_predict(X, dcpred_model, gamma)
%

fprintf('DCPred: start the prediction procedure, # testing samples=%g\n', size(X,1));
timebegin = cputime;
[idx innerproducts] = hkmeans_predict(X', dcpred_model.levels, dcpred_model.hyperplanes);
ncluster = 2^(dcpred_model.levels);
labels = zeros(size(X,1),1);
for i=1:ncluster
	subset = find(idx==i);
	if ( numel(subset) == 0 )
		continue;
	end
	if (dcpred_model.isoneclass{i} ==1 )
		labels(subset) = 1;
		continue;
	end
	if (dcpred_model.isoneclass{i} == -1 )
		labels(subset) = -1;
		continue;
	end
	nowX = X(subset, :);
	nowinnerproducts = innerproducts(1:dcpred_model.num_map(i), subset);
%	nowinnerproducts = [];
	[nowlabels dec_values] = comp_predict(nowX', gamma, dcpred_model.landmarks{i}, exp(-gamma*nowinnerproducts), dcpred_model.quad{i}, dcpred_model.w{i});
	labels(subset) = nowlabels;
end

time = cputime - timebegin;
fprintf('DCPred: Time %g secs.\n', time);
