clear all;
gamma = 2^(-4);
C = 2^(-1);
levels = 7;
NRun = 5;

maxNumCompThreads(1);
rand('seed',0);
addpath('../data');
addpath('../libsvm-3.14-nobias/matlab');

[ytrain, Xtrain] = libsvmread('../data/a9a');
[ytest, Xtest] = libsvmread('../data/a9a.t');
Xtrain = Xtrain(:,1:122);

Xtest = repmat(Xtest, 10, 1);
ytest = repmat(ytest, 10, 1);
XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
dcpred_acc = [];
dcpred_time = [];
dcpred_time_norm = [];
for i = 1:NRun,
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 0.1);
	[labels,dcpred_time(i)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(i) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(i) = dcpred_time(i)/linearTime
end
fprintf('DC-Pred++ Prediction accuracy on test data mean: %f  std: %f\n', mean(dcpred_acc), std(dcpred_acc));

fprintf('DC-Pred++ Prediction time in mili-seconds mean: %f  std: %f \n', mean(dcpred_time), std(dcpred_time));

fprintf('DC-Pred++ normalized Prediction time: %f  std: %f \n', mean(dcpred_time_norm), std(dcpred_time_norm));



