clear all;
gamma = 2^(-5);% 2^-4
C = 2^-1; % 2^-1
levels = 7;

maxNumCompThreads(1);
begin = cputime;
rand('seed',0);
addpath('../data');
addpath('../libsvm-3.14-nobias/matlab');

[ytrain, Xtrain] = libsvmread('../data/a9a');
[ytest, Xtest] = libsvmread('../data/a9a.t');
Xtrain = Xtrain(:,1:122);

Xtest = repmat(Xtest, 10, 1);
ytest = repmat(ytest, 10, 1);

% Xtest = repmat(Xtest, 10, 1);
% ytest = repmat(ytest, 10, 1);
XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
llist = [4:8];
for li = 1:numel(llist),
	levels = llist(li)
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 0.1);
	[labels,dcpred_time(li)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(li) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(li) = dcpred_time(li)/linearTime
end
%save a9a_result dcpred_time_norm dcpred_acc dcpred_time linearTime llist

