clear all;
gamma = 32;
C = 32;
levels = 13;
NRun = 5;

maxNumCompThreads(1);
rand('seed',0);
randn('seed',0);
addpath('../data');
addpath('../libsvm-3.14-nobias/matlab');

[y X] = libsvmread('../data/covtype.libsvm.binary.scale');
y(y==1) = -1;
y(y==2) = 1;
l = size(X,1);
p = randperm(l);
a = floor(l/5);
Xtest = X(p(1:a),:); ytest = y(p(1:a));
Xtrain = X(p(a+1:end),:); ytrain = y(p(a+1:end));

Xtest = repmat(Xtest, 10, 1);
ytest = repmat(ytest, 10, 1);

XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
dcpred_acc = [];
dcpred_time = [];
dcpred_time_norm = [];
for i = 1:NRun,
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 1, 0.0001);
	[labels,dcpred_time(i)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(i) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(i) = dcpred_time(i)/linearTime
end
fprintf('DC-Pred++ Prediction accuracy on test data mean: %f  std: %f\n', mean(dcpred_acc), std(dcpred_acc));

fprintf('DC-Pred++ Prediction time in mili-seconds mean: %f  std: %f \n', mean(dcpred_time), std(dcpred_time));

fprintf('DC-Pred++ normalized Prediction time: %f  std: %f \n', mean(dcpred_time_norm), std(dcpred_time_norm));


