clear all;
gamma = 32;
C = 32;
levels = 13;

maxNumCompThreads(1);
begin = cputime;
rand('seed',0);
randn('seed',0);
addpath('../data');
addpath('../libsvm-3.14-nobias/matlab');

[y X] = libsvmread('../data/covtype.libsvm.binary.scale');
y(y==1) = -1;
y(y==2) = 1;
l = size(X,1);
p = randperm(l);
a = floor(l/5);
Xtest = X(p(1:a),:); ytest = y(p(1:a));
Xtrain = X(p(a+1:end),:); ytrain = y(p(a+1:end));

Xtest = repmat(Xtest, 10, 1);
ytest = repmat(ytest, 10, 1);
XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
llist = [11:14];
for li = 1:numel(llist),
	levels = llist(li)
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 1, 0.0001);
	[labels,dcpred_time(li)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(li) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(li) = dcpred_time(li)/linearTime
%	fprintf('DCPred: Accuracy: %g\n', nnz(labels==ytest)/numel(ytest));
end
%save covtype_result dcpred_time_norm dcpred_acc dcpred_time linearTime llist

