clear all;
gamma = 0.008;
C = 8;
levels = 4;
NRun = 5;

maxNumCompThreads(1);
begin = cputime;
rand('seed',0);
randn('seed',0);
addpath('../data');

load ../data/usps_new;
Xtest = repmat(Xtest, 100, 1);
ytest = repmat(ytest, 100, 1);

XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
dcpred_acc = [];
dcpred_time = [];
dcpred_time_norm = [];
for i = 1:NRun,
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 0.5, 0.0005);
	[labels,dcpred_time(i)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(i) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(i) = dcpred_time(i)/linearTime
end
fprintf('DC-Pred++ Prediction accuracy on test data mean: %f  std: %f\n', mean(dcpred_acc), std(dcpred_acc));

fprintf('DC-Pred++ Prediction time in mili-seconds mean: %f  std: %f \n', mean(dcpred_time), std(dcpred_time));

fprintf('DC-Pred++ normalized Prediction time: %f  std: %f \n', mean(dcpred_time_norm), std(dcpred_time_norm));

