clear all;
gamma = 0.006; % 0.008
C = 32; % 32
levels = 4;

maxNumCompThreads(1);
begin = cputime;
rand('seed',0);
randn('seed',0);
addpath('../data');

load ../data/usps_new;
Xtest = repmat(Xtest, 100, 1);
ytest = repmat(ytest, 100, 1);


XtestTras = full(Xtest)';
tt = rand(size(Xtest,2),1);
linearTime = Prediction(XtestTras,tt,10);
%
llist = [3:6];
for li = 1:numel(llist),
	levels = llist(li)
	dcpred_model = dcpred_train(ytrain, Xtrain, levels, gamma, C, 0.5, 0.0005);
	[labels,dcpred_time(li)] = dcpred_predict_dense(ytest, XtestTras, dcpred_model, gamma);
	dcpred_acc(li) =  nnz(labels==ytest)/numel(ytest)
	dcpred_time_norm(li) = dcpred_time(li)/linearTime
end
%save usps_result dcpred_time_norm dcpred_acc dcpred_time linearTime llist
