// 
// Invocation form within Matlab:
// [newC quad] = gen_pseudo(oldC, numpairs)
// 
// input arguments: 
// 		oldC: original C matrix (n by m)
// 		numpairs: number of new pairs
//
// output arguments: 
// 		newC: new C matrix after adding the pairs
// 		quad: (2 by m1) matrix

#include "mex.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vector>

#define MAXDIS 1000000000000000.0
using namespace std;

void exit_with_help()
{
	mexPrintf(
" [newC quad] = gen_pseudo(oldC, numpairs)\n"
" \n"
" input arguments: \n"
" 		oldC: original C matrix (n by m)\n"
" 		numpairs: number of new pairs \n"
" output arguments: \n"
" 		newC: new C matrix for new pairs\n"
" 		quad: (2 by m1) matrix\n"
	);
}

static void fake_answer(mxArray *plhs[])
{
	plhs[0] = mxCreateDoubleMatrix(0, 0, mxREAL);
	plhs[1] = mxCreateDoubleMatrix(0, 0, mxREAL);
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	srand(0);
    if (nrhs !=2 ) {
		exit_with_help();
		fake_answer(plhs);
    } 
	else
	{
		double *oldC = mxGetPr(prhs[0]);
		int n = (int)mxGetM(prhs[0]);
		int m = (int)mxGetN(prhs[0]);

		int m1 = (int)mxGetScalar(prhs[1]);
		
		plhs[0] = mxCreateDoubleMatrix(n, m1, mxREAL);
		double *newC = mxGetPr(plhs[0]);
		plhs[1] = mxCreateDoubleMatrix(2, m1, mxREAL);
		double *quad = mxGetPr(plhs[1]);

		int MAX = 10000;
		vector<int> tmp(m*m);
		int nowlen = 0;

		for ( int i=0 ; i<m ; i++ )
			for ( int j=i+1 ; j<m ; j++ )
			{
				tmp[nowlen] = i*MAX+j;
				nowlen++;
			}

		// Random permutation
		int tmpval = 0;
		for ( int i=0 ; i<nowlen ; i++ )
		{
			int j = rand()%(nowlen-i) + i;
			if ( i!= j )
			{
				tmpval = tmp[i];
				tmp[i] = tmp[j];
				tmp[j] = tmpval;
			}
		}


		for ( int i=0 ; i<m1 ; i++ )
		{
			int a = tmp[i]/MAX;
			int b= tmp[i]%MAX;
			quad[i*2] = a+1;
			quad[i*2+1] = b+1;
			double *Ca = &(oldC[a*n]);
			double *Cb = &(oldC[b*n]);
			double *newCi = &(newC[i*n]);
			for ( int j=0 ; j<n ; j++ )
			{
				newCi[j] = Ca[j]*Cb[j];
			}
		}
	}
}
