function [samples] = gen_samples(trainy, trainX, kernelmodel, num, C, gamma)
%{
SVs = kernelmodel.SVs;
A = rbf(SVs, trainX, gamma);

cmd = sprintf('-c %g -s 2 -B -1', C);
trainl = size(trainX, 1);
now_residual = ones(trainl, 1) ;

nowidx = [];
for iter=1:num
	aa = 2*C*trainy.*now_residual;
	g = A*aa;
	g(nowidx) = 0;
	[val, idx] = max(abs(g));
	nowidx = [nowidx idx];
	Ctrain = A(nowidx, :)';
	model = train(trainy, sparse(Ctrain), cmd);
	w = model.w*model.Label(1);
	now_residual = max(1-trainy.*(Ctrain*w'), 0);
end
samples = SVs(nowidx, :);
%}
[val ind] = sort(abs(kernelmodel.sv_coef), 'descend');
samples = kernelmodel.SVs(ind(1:num),:);
