/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.jmx.JEMBean;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class JEMonitor
extends JEMBean
implements DynamicMBean {
    public static final String ATT_ENV_HOME = "environmentHome";
    public static final String ATT_IS_READ_ONLY = "isReadOnly";
    public static final String ATT_IS_TRANSACTIONAL = "isTransactional";
    public static final String ATT_CACHE_SIZE = "cacheSize";
    public static final String ATT_CACHE_PERCENT = "cachePercent";
    public static final String ATT_LOCK_TIMEOUT = "lockTimeout";
    public static final String ATT_IS_SERIALIZABLE = "isSerializableIsolation";
    public static final String ATT_TXN_TIMEOUT = "transactionTimeout";
    private static final MBeanAttributeInfo[] COMMON_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("environmentHome", "java.lang.String", "Environment home directory.", true, false, false)};
    private static final MBeanAttributeInfo[] OPEN_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("isReadOnly", "java.lang.Boolean", "true if this Environment is read only.", true, false, true), new MBeanAttributeInfo("isTransactional", "java.lang.Boolean", "true if this Environment supports transactions.", true, false, true), new MBeanAttributeInfo("cacheSize", "java.lang.Long", "Cache size, in bytes.", true, true, false), new MBeanAttributeInfo("cachePercent", "java.lang.Integer", "By default, cache size is (cachePercent * JVM maximum memory). To change the cache size using a percentage of the heap size, set the cache size to 0 and cachePercent to the desired percentage value.", true, true, false), new MBeanAttributeInfo("lockTimeout", "java.lang.Long", "Lock timeout, in microseconds.", true, false, false)};
    private static final MBeanAttributeInfo[] TRANSACTIONAL_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("isSerializableIsolation", "java.lang.Boolean", "true if this environment provides Serializable (degree 3) isolation. The default is RepeatableRead isolation.", true, false, true), new MBeanAttributeInfo("transactionTimeout", "java.lang.Long", "Transaction timeout, in seconds. A value of 0 means there is no timeout.", true, false, false)};
    static final String OP_CLEAN = "cleanLog";
    static final String OP_EVICT = "evictMemory";
    static final String OP_CHECKPOINT = "checkpoint";
    static final String OP_SYNC = "sync";
    static final String OP_TXN_STAT = "getTxnStats";
    static final String OP_DB_NAMES = "getDatabaseNames";
    static final String OP_DB_STAT = "getDatabaseStats";
    static final String OP_ENV_CONFIG = "getEnvConfig";
    public static final String OP_ENV_STAT = "getEnvironmentStats";
    public static final String OP_GET_TIPS = "getTips";
    private static final MBeanOperationInfo OP_CLEAN_INFO = new MBeanOperationInfo("cleanLog", "Remove obsolete environment log files. Zero or more log files will be cleaned as necessary to bring the disk space utilization of the environment above the configured minimum utilization threshold as determined by the setting je.cleaner.minUtilization. Returns the number of files cleaned. These will be deleted at the next qualifying checkpoint.", new MBeanParameterInfo[0], "java.lang.Integer", 3);
    private static final MBeanOperationInfo OP_EVICT_INFO = new MBeanOperationInfo("evictMemory", "Reduce cache usage to the threshold determined by the setting je.evictor.useMemoryFloor. ", new MBeanParameterInfo[0], "void", 3);
    private static final MBeanParameterInfo[] checkpointParams = new MBeanParameterInfo[]{new MBeanParameterInfo("force", "java.lang.Boolean", "If true, force a checkpoint even if there has been no activity since the last checkpoint. Returns true if a checkpoint executed.")};
    private static final MBeanOperationInfo OP_CHECKPOINT_INFO = new MBeanOperationInfo("checkpoint", "Checkpoint the environment.", checkpointParams, "void", 3);
    private static final MBeanOperationInfo OP_SYNC_INFO = new MBeanOperationInfo("sync", "Flush the environment to stable storage.", new MBeanParameterInfo[0], "void", 3);
    private static final MBeanOperationInfo OP_ENV_STAT_INFO = new MBeanOperationInfo("getEnvironmentStats", "Get environment statistics.", statParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_TXN_STAT_INFO = new MBeanOperationInfo("getTxnStats", "Get transactional statistics.", statParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_DB_NAMES_INFO = new MBeanOperationInfo("getDatabaseNames", "Get the names of databases in the environment.", new MBeanParameterInfo[0], "java.util.ArrayList", 0);
    private static final MBeanParameterInfo[] dbStatParams = new MBeanParameterInfo[]{new MBeanParameterInfo("clear", "java.lang.Boolean", "If true, reset statistics after reading."), new MBeanParameterInfo("fast", "java.lang.Boolean", "If true, only return statistics which do not require expensive computation. Currently all database stats are not fast."), new MBeanParameterInfo("databaseName", "java.lang.String", "database name")};
    private static final MBeanOperationInfo OP_DB_STAT_INFO = new MBeanOperationInfo("getDatabaseStats", "Get database statistics.", dbStatParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_ENV_CONFIG_INFO = new MBeanOperationInfo("getEnvConfig", "Get environment configuration.", new MBeanParameterInfo[0], "java.lang.String", 0);

    protected JEMonitor(Environment env) {
        super(env);
    }

    public JEMonitor() {
    }

    protected void initClassFields() {
        this.currentClass = JEMonitor.class;
        this.className = "JEMonitor";
        this.DESCRIPTION = "Monitor an open Berkeley DB, Java Edition Environment.";
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException {
        if (attributeName == null) {
            throw new AttributeNotFoundException("Attribute name can't be null.");
        }
        try {
            EnvironmentConfig envConfig = this.env.getConfig();
            if (attributeName.equals(ATT_ENV_HOME)) {
                return this.env.getHome().getCanonicalPath();
            }
            if (attributeName.equals(ATT_IS_READ_ONLY)) {
                return new Boolean(envConfig.getReadOnly());
            }
            if (attributeName.equals(ATT_IS_TRANSACTIONAL)) {
                return new Boolean(envConfig.getTransactional());
            }
            if (attributeName.equals(ATT_CACHE_SIZE)) {
                return new Long(envConfig.getCacheSize());
            }
            if (attributeName.equals(ATT_CACHE_PERCENT)) {
                return new Integer(envConfig.getCachePercent());
            }
            if (attributeName.equals(ATT_LOCK_TIMEOUT)) {
                return new Long(envConfig.getLockTimeout());
            }
            if (attributeName.equals(ATT_IS_SERIALIZABLE)) {
                return new Boolean(envConfig.getTxnSerializableIsolation());
            }
            if (attributeName.equals(ATT_TXN_TIMEOUT)) {
                return new Long(envConfig.getTxnTimeout());
            }
            throw new AttributeNotFoundException("Attribute " + attributeName + " is not valid.");
        }
        catch (DatabaseException e) {
            throw new MBeanException(new RuntimeException(e.getMessage()));
        }
        catch (Exception e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        block8: {
            if (attribute == null) {
                throw new AttributeNotFoundException("Attribute can't be null.");
            }
            String name = attribute.getName();
            Object value = attribute.getValue();
            if (name == null) {
                throw new AttributeNotFoundException("Attribute name can't be null.");
            }
            if (value == null) {
                throw new InvalidAttributeValueException("Attribute value for attribute " + name + " can't be null");
            }
            try {
                EnvironmentMutableConfig mutableConfig = this.env.getMutableConfig();
                if (name.equals(ATT_CACHE_SIZE)) {
                    mutableConfig.setCacheSize(((Long)value).longValue());
                    this.env.setMutableConfig(mutableConfig);
                    break block8;
                }
                if (name.equals(ATT_CACHE_PERCENT)) {
                    mutableConfig.setCachePercent(((Integer)value).intValue());
                    this.env.setMutableConfig(mutableConfig);
                    break block8;
                }
                throw new AttributeNotFoundException("Attribute " + name + " is not valid.");
            }
            catch (NumberFormatException e) {
                throw new InvalidAttributeValueException("Attribute value for attribute " + name + " is not valid.");
            }
            catch (DatabaseException e) {
                throw new InvalidAttributeValueException("Setting value for attribute " + name + "is invalid because of " + e.getMessage());
            }
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes can't be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                results.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attribute list can't be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object newValue = this.getAttribute(name);
                results.add(new Attribute(name, newValue));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        if (actionName == null) {
            throw new IllegalArgumentException("ActionName can't be null.");
        }
        try {
            if (actionName.equals(OP_CLEAN)) {
                int numFiles = this.env.cleanLog();
                return new Integer(numFiles);
            }
            if (actionName.equals(OP_EVICT)) {
                this.env.evictMemory();
                return null;
            }
            if (actionName.equals(OP_CHECKPOINT)) {
                CheckpointConfig ckptConfig = new CheckpointConfig();
                if (params != null && params.length > 0) {
                    Boolean force = (Boolean)params[0];
                    ckptConfig.setForce(force.booleanValue());
                }
                this.env.checkpoint(ckptConfig);
                return null;
            }
            if (actionName.equals(OP_SYNC)) {
                this.env.sync();
                return null;
            }
            if (actionName.equals(OP_ENV_STAT)) {
                return this.env.getStats(this.getStatsConfig(params)).toString();
            }
            if (actionName.equals(OP_TXN_STAT)) {
                return this.env.getTransactionStats(this.getStatsConfig(params)).toString();
            }
            if (actionName.equals(OP_DB_NAMES)) {
                return this.env.getDatabaseNames();
            }
            if (actionName.equals(OP_DB_STAT)) {
                DatabaseStats stats = this.getDatabaseStats(params);
                return stats != null ? stats.toString() : null;
            }
            if (actionName.equals(OP_GET_TIPS)) {
                return this.env.getStats(this.getStatsConfig(new Object[]{false, true})).getTips();
            }
            if (actionName.equals(OP_ENV_CONFIG)) {
                return this.env.getConfig().toString();
            }
            return new IllegalArgumentException("ActionName: " + actionName + " is not valid.");
        }
        catch (DatabaseException e) {
            throw new MBeanException(new RuntimeException(e.getMessage() + LoggerUtils.getStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseStats getDatabaseStats(Object[] params) throws IllegalArgumentException, DatabaseException {
        DatabaseStats databaseStats;
        block3: {
            if (params == null || params.length < 3) {
                return null;
            }
            String dbName = (String)params[2];
            Database db = null;
            try {
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReadOnly(true);
                DbInternal.setUseExistingConfig((DatabaseConfig)dbConfig, (boolean)true);
                db = this.env.openDatabase(null, dbName, dbConfig);
                databaseStats = db.getStats(this.getStatsConfig(params));
                Object var7_6 = null;
                if (db == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (db == null) break block4;
                    db.close();
                }
                throw throwable;
            }
            db.close();
        }
        return databaseStats;
    }

    protected void doRegisterMBean(Environment env) throws Exception {
        this.server.registerMBean(new JEMonitor(env), this.jeName);
    }

    protected MBeanAttributeInfo[] getAttributeList() {
        int i;
        ArrayList<MBeanAttributeInfo> attrList = new ArrayList<MBeanAttributeInfo>();
        if (this.env == null) {
            return null;
        }
        for (i = 0; i < COMMON_ATTR.length; ++i) {
            attrList.add(COMMON_ATTR[i]);
        }
        for (i = 0; i < OPEN_ATTR.length; ++i) {
            attrList.add(OPEN_ATTR[i]);
        }
        try {
            EnvironmentConfig config = this.env.getConfig();
            if (config.getTransactional()) {
                for (int i2 = 0; i2 < TRANSACTIONAL_ATTR.length; ++i2) {
                    attrList.add(TRANSACTIONAL_ATTR[i2]);
                }
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return attrList.toArray(new MBeanAttributeInfo[attrList.size()]);
    }

    protected void addOperations() {
        if (this.env == null) {
            return;
        }
        this.operationList.add(OP_CLEAN_INFO);
        this.operationList.add(OP_EVICT_INFO);
        this.operationList.add(OP_ENV_STAT_INFO);
        this.operationList.add(OP_DB_NAMES_INFO);
        this.operationList.add(OP_DB_STAT_INFO);
        this.operationList.add(OP_ENV_CONFIG_INFO);
        try {
            if (this.env.getConfig().getTransactional()) {
                this.operationList.add(OP_CHECKPOINT_INFO);
                this.operationList.add(OP_TXN_STAT_INFO);
            } else {
                this.operationList.add(OP_SYNC_INFO);
            }
        }
        catch (DatabaseException e) {
            this.operationList = new ArrayList();
            return;
        }
    }
}

