/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.jmx;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.jmx.JEMonitor;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class RepJEMonitor
extends JEMonitor {
    public static final String OP_DUMP_REPSTATS = "getReplicationStats";
    public static final String OP_GET_REP_TIPS = "getRepTips";
    static final String OP_DUMP_STATE = "dumpReplicationState";
    private static final MBeanOperationInfo OP_DUMP_REPSTATS_INFO = new MBeanOperationInfo("getReplicationStats", "Dump environment's replicated stats.", statParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_DUMP_STATE_INFO = new MBeanOperationInfo("dumpReplicationState", "Dump replicated environment state, including current position in replication stream and replication group database.", new MBeanParameterInfo[0], "java.lang.String", 0);

    protected RepJEMonitor(Environment env) {
        super(env);
    }

    public RepJEMonitor() {
    }

    protected void initClassFields() {
        this.currentClass = RepJEMonitor.class;
        this.className = "RepJEMonitor";
        this.DESCRIPTION = "Monitor an open replicated Berkeley DB, Java Edition environment.";
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        if (actionName == null) {
            throw new IllegalArgumentException("ActionName can't be null.");
        }
        try {
            if (actionName.equals(OP_DUMP_REPSTATS)) {
                return ((ReplicatedEnvironment)this.env).getRepStats(this.getStatsConfig(params)).toString();
            }
            if (actionName.equals(OP_GET_REP_TIPS)) {
                return ((ReplicatedEnvironment)this.env).getRepStats(this.getStatsConfig(new Object[]{false, true})).getTips();
            }
            if (actionName.equals(OP_DUMP_STATE)) {
                return RepInternal.getRepImpl((ReplicatedEnvironment)((ReplicatedEnvironment)this.env)).dumpState();
            }
        }
        catch (DatabaseException e) {
            throw new MBeanException(new RuntimeException(e.getMessage()));
        }
        return super.invoke(actionName, params, signature);
    }

    protected void doRegisterMBean(Environment useEnv) throws Exception {
        this.server.registerMBean(new RepJEMonitor(useEnv), this.jeName);
    }

    protected void addOperations() {
        super.addOperations();
        this.operationList.add(OP_DUMP_REPSTATS_INFO);
        this.operationList.add(OP_DUMP_STATE_INFO);
    }
}

