/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTree
implements Loggable {
    public static final DatabaseId ID_DB_ID = new DatabaseId(0);
    public static final DatabaseId NAME_DB_ID = new DatabaseId(1);
    private static final String ID_DB_NAME = "_jeIdMap";
    private static final String NAME_DB_NAME = "_jeNameMap";
    public static final String UTILIZATION_DB_NAME = "_jeUtilization";
    public static final String REP_GROUP_DB_NAME = "_jeRepGroupDB";
    public static final String VLSN_MAP_DB_NAME = "_jeVlsnMapDb";
    private static final String[] RESERVED_DB_NAMES = new String[]{"_jeIdMap", "_jeNameMap", "_jeUtilization", "_jeRepGroupDB", "_jeVlsnMapDb"};
    public static final int NEG_DB_ID_START = -256;
    private final AtomicInteger lastAllocatedLocalDbId;
    private final AtomicInteger lastAllocatedReplicatedDbId;
    private final DatabaseImpl idDatabase;
    private final DatabaseImpl nameDatabase;
    private byte flags;
    private static final byte REPLICATED_BIT = 1;
    private static final byte CONVERTED_BIT = 2;
    private EnvironmentImpl envImpl;

    public DbTree() {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.idDatabase.setDebugDatabaseName(ID_DB_NAME);
        this.idDatabase.clearKeyPrefixing();
        this.nameDatabase = new DatabaseImpl();
        this.nameDatabase.clearKeyPrefixing();
        this.nameDatabase.setDebugDatabaseName(NAME_DB_NAME);
        this.lastAllocatedLocalDbId = new AtomicInteger();
        this.lastAllocatedReplicatedDbId = new AtomicInteger();
    }

    public DbTree(EnvironmentImpl env, boolean replicationIntended) throws DatabaseException {
        this.envImpl = env;
        this.lastAllocatedLocalDbId = new AtomicInteger(1);
        this.lastAllocatedReplicatedDbId = new AtomicInteger(-256);
        DatabaseConfig idConfig = new DatabaseConfig();
        DbInternal.setReplicated(idConfig, false);
        idConfig.setKeyPrefixing(false);
        this.idDatabase = new DatabaseImpl(ID_DB_NAME, new DatabaseId(0), env, idConfig);
        this.idDatabase.clearKeyPrefixing();
        DatabaseConfig nameConfig = new DatabaseConfig();
        nameConfig.setKeyPrefixing(false);
        this.nameDatabase = new DatabaseImpl(NAME_DB_NAME, new DatabaseId(1), env, nameConfig);
        this.nameDatabase.clearKeyPrefixing();
        if (replicationIntended) {
            this.setIsReplicated();
        }
    }

    public int getLastLocalDbId() {
        return this.lastAllocatedLocalDbId.get();
    }

    public int getLastReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.get();
    }

    private int getNextLocalDbId() {
        return this.lastAllocatedLocalDbId.incrementAndGet();
    }

    private int getNextReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.decrementAndGet();
    }

    public void setLastDbId(int lastReplicatedDbId, int lastLocalDbId) {
        this.lastAllocatedReplicatedDbId.set(lastReplicatedDbId);
        this.lastAllocatedLocalDbId.set(lastLocalDbId);
    }

    private boolean isReplicatedId(int id) {
        return id < -256;
    }

    public void updateFromReplay(DatabaseId replayDbId) {
        assert (!this.envImpl.isMaster());
        int replayVal = replayDbId.getId();
        if (replayVal > 0 && !this.envImpl.isConverted()) {
            throw EnvironmentFailureException.unexpectedState("replay database id is unexpectedly positive " + replayDbId);
        }
        if (replayVal < this.lastAllocatedReplicatedDbId.get()) {
            this.lastAllocatedReplicatedDbId.set(replayVal);
        }
    }

    void initExistingEnvironment(EnvironmentImpl eImpl) throws DatabaseException {
        eImpl.checkRulesForExistingEnv(this.isReplicated());
        this.envImpl = eImpl;
        this.idDatabase.setEnvironmentImpl(eImpl);
        this.nameDatabase.setEnvironmentImpl(eImpl);
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, databaseHandle, null, null);
    }

    public DatabaseImpl createInternalDb(Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.setKeyPrefixing(false);
        DatabaseImpl ret = this.doCreateDb(locker, databaseName, dbConfig, null, null, null);
        ret.clearKeyPrefixing();
        return ret;
    }

    public DatabaseImpl createReplicaDb(Locker locker, String databaseName, DatabaseConfig dbConfig, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, null, replicatedLN, repContext);
    }

    private synchronized DatabaseImpl doCreateDb(Locker nameLocker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        DatabaseId newId = null;
        newId = replicatedLN != null ? replicatedLN.getId() : (this.envImpl.isReplicated() && DbInternal.getReplicated(dbConfig) ? new DatabaseId(this.getNextReplicatedDbId()) : new DatabaseId(this.getNextLocalDbId()));
        DatabaseImpl newDb = null;
        CursorImpl idCursor = null;
        CursorImpl nameCursor = null;
        boolean operationOk = false;
        Locker idDbLocker = null;
        try {
            newDb = new DatabaseImpl(databaseName, newId, this.envImpl, dbConfig);
            nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
            NameLN nameLN = null;
            nameLN = replicatedLN != null ? replicatedLN : new NameLN(newId, this.envImpl, newDb.isReplicated());
            ReplicationContext useRepContext = repContext;
            if (repContext == null) {
                useRepContext = newDb.getOperationRepContext(DbOperationType.CREATE);
            }
            nameCursor.putLN(databaseName.getBytes("UTF-8"), nameLN, null, false, useRepContext);
            if (databaseHandle != null) {
                nameLocker.addToHandleMaps(nameLN.getNodeId(), databaseHandle);
            }
            idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
            idCursor = new CursorImpl(this.idDatabase, idDbLocker);
            idCursor.putLN(newId.getBytes(), new MapLN(newDb), null, false, ReplicationContext.NO_REPLICATE);
            newDb.incrementUseCount();
            operationOk = true;
        }
        catch (UnsupportedEncodingException UEE) {
            throw EnvironmentFailureException.unexpectedException(UEE);
        }
        finally {
            if (idCursor != null) {
                idCursor.close();
            }
            if (nameCursor != null) {
                nameCursor.close();
            }
            if (idDbLocker != null) {
                idDbLocker.operationEnd(operationOk);
            }
            if (!operationOk) {
                if (this.envImpl.isReplicated() && DbInternal.getReplicated(dbConfig)) {
                    this.lastAllocatedReplicatedDbId.incrementAndGet();
                } else {
                    this.lastAllocatedLocalDbId.decrementAndGet();
                }
            }
        }
        return newDb;
    }

    public void optionalModifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.isDeferredWriteMode()) {
            return;
        }
        this.modifyDbRoot(db);
    }

    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        this.modifyDbRoot(db, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDbRoot(DatabaseImpl db, long ifBeforeLsn, boolean mustExist) throws DatabaseException {
        if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
            this.envImpl.logMapTreeRoot();
        } else {
            DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
            while (true) {
                BasicLocker idDbLocker = null;
                CursorImpl cursor = null;
                boolean operationOk = false;
                try {
                    boolean searchOk;
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    cursor = new CursorImpl(this.idDatabase, idDbLocker);
                    boolean bl = searchOk = (cursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                    if (!searchOk) {
                        if (!mustExist) break;
                        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Can't find database ID: " + db.getId());
                    }
                    if (ifBeforeLsn != -1L && DbLsn.compareTo(cursor.getBIN().getLsn(cursor.getIndex()), ifBeforeLsn) >= 0) break;
                    MapLN mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                    assert (mapLN != null);
                    RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                    mapLN.getDatabase().getTree().withRootLatchedExclusive(writeMapLN);
                    operationOk = true;
                    break;
                }
                catch (LockConflictException e) {}
                continue;
                finally {
                    if (cursor != null) {
                        cursor.releaseBIN();
                        cursor.close();
                    }
                    if (idDbLocker == null) continue;
                    ((Locker)idDbLocker).operationEnd(operationOk);
                    continue;
                }
                break;
            }
        }
    }

    private NameLockResult lockNameLN(Locker locker, String databaseName, String action) throws DatabaseNotFoundException {
        NameLockResult result = new NameLockResult();
        result.dbImpl = this.getDb(locker, databaseName, null);
        if (result.dbImpl == null) {
            throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
        }
        boolean success = false;
        try {
            boolean found;
            result.nameCursor = new CursorImpl(this.nameDatabase, locker);
            DatabaseEntry key = new DatabaseEntry(databaseName.getBytes("UTF-8"));
            boolean bl = found = (result.nameCursor.searchAndPosition(key, null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
            if (!found) {
                throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
            }
            result.nameLN = (NameLN)result.nameCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
            assert (result.nameLN != null);
            if (locker.getImportunate()) {
                String msg = "Database " + databaseName + " has been forcibly closed in order to apply a" + " replicated " + action + " operation.  This Database" + " and all associated Cursors must be closed.  All" + " associated Transactions must be aborted.";
                for (Database db : result.dbImpl.getReferringHandles()) {
                    DbInternal.setPreempted(db, databaseName, msg);
                }
            } else {
                int handleCount = result.dbImpl.getReferringHandleCount();
                if (handleCount > 0) {
                    throw new IllegalStateException("Can't " + action + " database " + databaseName + ", " + handleCount + " open Database handles exist");
                }
            }
            success = true;
        }
        catch (UnsupportedEncodingException UEE) {
            throw EnvironmentFailureException.unexpectedException(UEE);
        }
        finally {
            if (!success) {
                this.releaseDb(result.dbImpl);
                if (result.nameCursor != null) {
                    result.nameCursor.releaseBIN();
                    result.nameCursor.close();
                }
            }
        }
        return result;
    }

    private void doRenameDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        NameLockResult result = this.lockNameLN(locker, databaseName, "rename");
        CursorImpl nameCursor = result.nameCursor;
        DatabaseImpl dbImpl = result.dbImpl;
        try {
            nameCursor.latchBIN();
            nameCursor.delete(ReplicationContext.NO_REPLICATE);
            DbOpReplicationContext useRepContext = repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.RENAME);
            NameLN useLN = replicatedLN != null ? replicatedLN : new NameLN(dbImpl.getId(), this.envImpl, dbImpl.isReplicated());
            nameCursor.reset();
            nameCursor.putLN(newName.getBytes("UTF-8"), useLN, null, false, useRepContext);
            dbImpl.setDebugDatabaseName(newName);
        }
        catch (UnsupportedEncodingException UEE) {
            throw EnvironmentFailureException.unexpectedException(UEE);
        }
        finally {
            this.releaseDb(dbImpl);
            nameCursor.releaseBIN();
            nameCursor.close();
        }
    }

    public void dbRename(Locker locker, String databaseName, String newName) throws DatabaseNotFoundException {
        this.doRenameDb(locker, databaseName, newName, null, null);
    }

    public void renameReplicaDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        this.doRenameDb(locker, databaseName, newName, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveDb(Locker locker, String databaseName, DatabaseId checkId, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        CursorImpl nameCursor = null;
        NameLockResult result = this.lockNameLN(locker, databaseName, "remove");
        try {
            nameCursor = result.nameCursor;
            if (checkId != null && !checkId.equals(result.nameLN.getId())) {
                throw new DatabaseNotFoundException("ID mismatch: " + databaseName);
            }
            nameCursor.latchBIN();
            DbOpReplicationContext useRepContext = repContext != null ? repContext : result.dbImpl.getOperationRepContext(DbOperationType.REMOVE);
            nameCursor.delete(useRepContext);
            locker.markDeleteAtTxnEnd(result.dbImpl, true);
        }
        finally {
            if (nameCursor != null) {
                nameCursor.releaseBIN();
                nameCursor.close();
            }
        }
    }

    public void dbRemove(Locker locker, String databaseName, DatabaseId checkId) throws DatabaseNotFoundException {
        this.doRemoveDb(locker, databaseName, checkId, null);
    }

    public void removeReplicaDb(Locker locker, String databaseName, DatabaseId checkId, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        this.doRemoveDb(locker, databaseName, checkId, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doTruncateDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        assert (replicatedLN == null || repContext != null);
        NameLockResult result = this.lockNameLN(locker, databaseName, "truncate");
        CursorImpl nameCursor = result.nameCursor;
        try {
            DatabaseImpl oldDb = result.dbImpl;
            DatabaseId newId = replicatedLN != null ? replicatedLN.getId() : new DatabaseId(this.isReplicatedId(oldDb.getId().getId()) ? this.getNextReplicatedDbId() : this.getNextLocalDbId());
            DatabaseImpl newDb = oldDb.cloneDatabase();
            newDb.incrementUseCount();
            newDb.setId(newId);
            newDb.setTree(new Tree(newDb));
            BasicLocker idDbLocker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                idCursor.putLN(newId.getBytes(), new MapLN(newDb), null, false, ReplicationContext.NO_REPLICATE);
                operationOk = true;
            }
            finally {
                if (idCursor != null) {
                    idCursor.close();
                }
                if (idDbLocker != null) {
                    ((Locker)idDbLocker).operationEnd(operationOk);
                }
            }
            result.nameLN.setId(newDb.getId());
            long recordCount = returnCount ? oldDb.count() : 0L;
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            DbOpReplicationContext useRepContext = repContext != null ? repContext : newDb.getOperationRepContext(DbOperationType.TRUNCATE, oldDb.getId());
            nameCursor.putCurrent(dataDbt, null, null, null, -1L, useRepContext);
            locker.markDeleteAtTxnEnd(oldDb, true);
            locker.markDeleteAtTxnEnd(newDb, false);
            long l = recordCount;
            return l;
        }
        finally {
            nameCursor.releaseBIN();
            nameCursor.close();
        }
    }

    public long truncate(Locker locker, String databaseName, boolean returnCount) throws DatabaseNotFoundException {
        return this.doTruncateDb(locker, databaseName, returnCount, null, null);
    }

    public long truncateReplicaDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        return this.doTruncateDb(locker, databaseName, returnCount, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMapLN(DatabaseId id) throws DatabaseException {
        boolean done = false;
        while (!done) {
            BasicLocker idDbLocker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                boolean found;
                idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                boolean bl = found = (idCursor.searchAndPosition(new DatabaseEntry(id.getBytes()), null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                if (found) {
                    MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                    assert (mapLN != null);
                    DatabaseImpl dbImpl = mapLN.getDatabase();
                    if (!dbImpl.isInUseDuringDbRemove()) {
                        idCursor.latchBIN();
                        idCursor.delete(ReplicationContext.NO_REPLICATE);
                        done = true;
                    }
                } else {
                    done = true;
                }
                operationOk = true;
            }
            catch (LockConflictException e) {}
            continue;
            finally {
                if (idCursor != null) {
                    idCursor.releaseBIN();
                    idCursor.close();
                }
                if (idDbLocker == null) continue;
                ((Locker)idDbLocker).operationEnd(operationOk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, Database databaseHandle) throws DatabaseException {
        try {
            if (databaseName.equals(ID_DB_NAME)) {
                return this.idDatabase;
            }
            if (databaseName.equals(NAME_DB_NAME)) {
                return this.nameDatabase;
            }
            CursorImpl nameCursor = null;
            DatabaseId id = null;
            try {
                boolean found;
                nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                if (found) {
                    NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockType.READ);
                    assert (nameLN != null);
                    id = nameLN.getId();
                    if (databaseHandle != null) {
                        nameLocker.addToHandleMaps(nameLN.getNodeId(), databaseHandle);
                    }
                }
            }
            finally {
                if (nameCursor != null) {
                    nameCursor.releaseBIN();
                    nameCursor.close();
                }
            }
            if (id == null) {
                return null;
            }
            return this.getDb(id, -1L, databaseName);
        }
        catch (UnsupportedEncodingException UEE) {
            throw EnvironmentFailureException.unexpectedException(UEE);
        }
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        return this.getDb(dbId, lockTimeout, (String)null);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        if (dbCache.containsKey(dbId)) {
            return dbCache.get(dbId);
        }
        DatabaseImpl db = this.getDb(dbId, lockTimeout, (String)null);
        dbCache.put(dbId, db);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, String dbNameIfAvailable) throws DatabaseException {
        if (dbId.equals(this.idDatabase.getId())) {
            return this.idDatabase;
        }
        if (dbId.equals(this.nameDatabase.getId())) {
            return this.nameDatabase;
        }
        DatabaseImpl foundDbImpl = null;
        while (true) {
            BasicLocker locker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                DatabaseEntry keyDbt;
                boolean found;
                locker = BasicLocker.createBasicLocker(this.envImpl);
                if (lockTimeout != -1L) {
                    locker.setLockTimeout(lockTimeout);
                }
                boolean bl = found = ((idCursor = new CursorImpl(this.idDatabase, locker)).searchAndPosition(keyDbt = new DatabaseEntry(dbId.getBytes()), new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                if (found) {
                    MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.READ);
                    assert (mapLN != null);
                    foundDbImpl = mapLN.getDatabase();
                    foundDbImpl.incrementUseCount();
                }
                operationOk = true;
                break;
            }
            catch (LockConflictException e) {}
            continue;
            finally {
                if (idCursor != null) {
                    idCursor.releaseBIN();
                    idCursor.close();
                }
                if (locker == null) continue;
                ((Locker)locker).operationEnd(operationOk);
                continue;
            }
            break;
        }
        if (this.envImpl.isValid()) {
            this.setDebugNameForDatabaseImpl(foundDbImpl, dbNameIfAvailable);
        }
        return foundDbImpl;
    }

    public void releaseDb(DatabaseImpl db) {
        if (db != null && db != this.idDatabase && db != this.nameDatabase) {
            db.decrementUseCount();
        }
    }

    public void releaseDbs(Map<DatabaseId, DatabaseImpl> dbCache) {
        if (dbCache != null) {
            Iterator<DatabaseImpl> i = dbCache.values().iterator();
            while (i.hasNext()) {
                this.releaseDb(i.next());
            }
        }
    }

    private void setDebugNameForDatabaseImpl(DatabaseImpl dbImpl, String dbName) throws DatabaseException {
        if (dbImpl != null) {
            if (dbName != null) {
                dbImpl.setDebugDatabaseName(dbName);
            } else if (dbImpl.getDebugName() == null) {
                dbImpl.setDebugDatabaseName(this.getDbName(dbImpl.getId()));
            }
        }
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(final VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = true;
        try {
            boolean ok = this.idDatabase.verify(config, this.idDatabase.getEmptyStats());
            if (!ok) {
                ret = false;
            }
            if (!(ok = this.nameDatabase.verify(config, this.nameDatabase.getEmptyStats()))) {
                ret = false;
            }
        }
        catch (DatabaseException DE) {
            ret = false;
        }
        INCompressor iNCompressor = this.envImpl.getINCompressor();
        synchronized (iNCompressor) {
            final LockType lockType = LockType.NONE;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Traversal
            implements CursorImpl.WithCursor {
                boolean allOk = true;

                Traversal() {
                }

                @Override
                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    DatabaseImpl dbImpl;
                    boolean ok;
                    MapLN mapLN = (MapLN)cursor.getCurrentLN(lockType);
                    if (mapLN != null && !mapLN.isDeleted() && !(ok = (dbImpl = mapLN.getDatabase()).verify(config, dbImpl.getEmptyStats()))) {
                        this.allOk = false;
                    }
                    return true;
                }
            }
            Traversal traversal = new Traversal();
            CursorImpl.traverseDbWithCursor(this.idDatabase, lockType, true, traversal);
            if (!traversal.allOk) {
                ret = false;
            }
        }
        return ret;
    }

    public String getDbName(final DatabaseId id) throws DatabaseException {
        if (id.equals(ID_DB_ID)) {
            return ID_DB_NAME;
        }
        if (id.equals(NAME_DB_ID)) {
            return NAME_DB_NAME;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            String name = null;

            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                if (nameLN != null && nameLN.getId().equals(id)) {
                    try {
                        this.name = new String(key.getData(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    return false;
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return traversal.name;
    }

    public Map<DatabaseId, String> getDbNamesAndIds() throws DatabaseException {
        final HashMap<DatabaseId, String> nameMap = new HashMap<DatabaseId, String>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                DatabaseId id = nameLN.getId();
                try {
                    nameMap.put(id, new String(key.getData(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return nameMap;
    }

    public List<String> getDbNames() throws DatabaseException {
        final ArrayList<String> nameList = new ArrayList<String>();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                try {
                    String name = new String(key.getData(), "UTF-8");
                    if (!DbTree.isReservedDbName(name)) {
                        nameList.add(name);
                    }
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
            }
        });
        return nameList;
    }

    public List<String> getInternalNoLookupDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ID_DB_NAME);
        names.add(NAME_DB_NAME);
        return names;
    }

    public List<String> getInternalNoRepDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(UTILIZATION_DB_NAME);
        return names;
    }

    public List<String> getInternalRepDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(REP_GROUP_DB_NAME);
        names.add(VLSN_MAP_DB_NAME);
        return names;
    }

    public static boolean isReservedDbName(String name) {
        for (int i = 0; i < RESERVED_DB_NAMES.length; ++i) {
            if (!RESERVED_DB_NAMES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getHighestLevel() throws DatabaseException {
        int idHighLevel = this.getHighestLevel(this.idDatabase);
        int nameHighLevel = this.getHighestLevel(this.nameDatabase);
        return nameHighLevel > idHighLevel ? nameHighLevel : idHighLevel;
    }

    public int getHighestLevel(DatabaseImpl dbImpl) throws DatabaseException {
        RootLevel getLevel = new RootLevel(dbImpl);
        dbImpl.getTree().withRootLatchedShared(getLevel);
        return getLevel.getRootLevel();
    }

    boolean isReplicated() {
        return (this.flags & 1) != 0;
    }

    void setIsReplicated() {
        this.flags = (byte)(this.flags | 1);
    }

    boolean isConverted() {
        return (this.flags & 2) != 0;
    }

    void setIsConverted() {
        this.flags = (byte)(this.flags | 2);
    }

    public void close() {
        this.idDatabase.releaseTreeAdminMemory();
        this.nameDatabase.releaseTreeAdminMemory();
    }

    long getTreeAdminMemory() {
        return this.idDatabase.getTreeAdminMemory() + this.nameDatabase.getTreeAdminMemory();
    }

    @Override
    public int getLogSize() {
        return LogUtils.getIntLogSize() + LogUtils.getIntLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize() + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeInt(logBuffer, this.lastAllocatedLocalDbId.get());
        LogUtils.writeInt(logBuffer, this.lastAllocatedReplicatedDbId.get());
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
        logBuffer.put(this.flags);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.lastAllocatedLocalDbId.set(LogUtils.readInt(itemBuffer));
        if (entryVersion >= 6) {
            this.lastAllocatedReplicatedDbId.set(LogUtils.readInt(itemBuffer));
        }
        this.idDatabase.readFromLog(itemBuffer, entryVersion);
        this.nameDatabase.readFromLog(itemBuffer, entryVersion);
        this.flags = entryVersion >= 6 ? itemBuffer.get() : (byte)0;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<dbtree lastLocalDbId = \"");
        sb.append(this.lastAllocatedLocalDbId);
        sb.append("\" lastReplicatedDbId = \"");
        sb.append(this.lastAllocatedReplicatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    String dumpString(int nSpaces) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedLocalDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    private static class RootLevel
    implements WithRootLatched {
        private final DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    private static class NameLockResult {
        CursorImpl nameCursor;
        DatabaseImpl dbImpl;
        NameLN nameLN;

        private NameLockResult() {
        }
    }

    private static class RewriteMapLN
    implements WithRootLatched {
        private final CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.putCurrent(dataDbt, null, null, null, -1L, ReplicationContext.NO_REPLICATE);
            return null;
        }
    }
}

