/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.incomp;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.incomp.INCompStatDefinition;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INCompressor
extends DaemonThread {
    private static final boolean DEBUG = false;
    private EnvironmentImpl env;
    private final long lockTimeout;
    private StatGroup stats;
    private LongStat splitBins;
    private LongStat dbClosedBins;
    private LongStat cursorsBins;
    private LongStat nonEmptyBins;
    private LongStat processedBins;
    private LongStat compQueueSize;
    private int splitBinsThisRun = 0;
    private int dbClosedBinsThisRun = 0;
    private int cursorsBinsThisRun = 0;
    private int nonEmptyBinsThisRun = 0;
    private int processedBinsThisRun = 0;
    private int lazyProcessed = 0;
    private int lazyEmpty = 0;
    private int lazySplit = 0;
    private int wokenUp = 0;
    private Map<Long, BINReference> binRefQueue;
    private final Object binRefQueueSync;
    private TestHook beforeFlushTrackerHook;

    public INCompressor(EnvironmentImpl env, long waitTime, String name) {
        super(waitTime, name, env);
        this.env = env;
        this.lockTimeout = env.getConfigManager().getDuration(EnvironmentParams.COMPRESSOR_LOCK_TIMEOUT);
        this.binRefQueue = new HashMap<Long, BINReference>();
        this.binRefQueueSync = new Object();
        this.stats = new StatGroup("Node Compression", "Removal and compression of internal btree nodes.");
        this.splitBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_SPLIT_BINS);
        this.dbClosedBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_DBCLOSED_BINS);
        this.cursorsBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_CURSORS_BINS);
        this.nonEmptyBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_NON_EMPTY_BINS);
        this.processedBins = new LongStat(this.stats, INCompStatDefinition.INCOMP_PROCESSED_BINS);
        this.compQueueSize = new LongStat(this.stats, INCompStatDefinition.INCOMP_QUEUE_SIZE);
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    public void setBeforeFlushTrackerHook(TestHook hook) {
        this.beforeFlushTrackerHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyCursors() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ArrayList<BINReference> queueSnapshot = null;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            queueSnapshot = new ArrayList<BINReference>(this.binRefQueue.values());
        }
        DbTree dbTree = this.env.getDbTree();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        try {
            for (BINReference binRef : queueSnapshot) {
                DatabaseImpl db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
                BIN bin = this.searchForBIN(db, binRef);
                if (bin == null) continue;
                bin.verifyCursors();
                bin.releaseLatch();
            }
        }
        finally {
            dbTree.releaseDbs(dbCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBinRefQueueSize() {
        int size = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            size = this.binRefQueue.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinKeyToQueue(BIN bin, Key deletedKey, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinKeyToQueueAlreadyLatched(bin, deletedKey);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinRefToQueue(BINReference binRef, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinRefToQueueAlreadyLatched(binRef);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultipleBinRefsToQueue(Collection<BINReference> binRefs, boolean doWakeup) {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            for (BINReference binRef : binRefs) {
                this.addBinRefToQueueAlreadyLatched(binRef);
            }
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    private void addBinRefToQueueAlreadyLatched(BINReference binRef) {
        Long node = binRef.getNodeId();
        BINReference existingRef = this.binRefQueue.get(node);
        if (existingRef != null) {
            existingRef.addDeletedKeys(binRef);
        } else {
            this.binRefQueue.put(node, binRef);
        }
    }

    private void addBinKeyToQueueAlreadyLatched(BIN bin, Key deletedKey) {
        Long node = bin.getNodeId();
        BINReference existingRef = this.binRefQueue.get(node);
        if (existingRef != null) {
            if (deletedKey != null) {
                existingRef.addDeletedKey(deletedKey);
            }
        } else {
            BINReference binRef = bin.createReference();
            if (deletedKey != null) {
                binRef.addDeletedKey(deletedKey);
            }
            this.binRefQueue.put(node, binRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(long nodeId) {
        Long node = nodeId;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            return this.binRefQueue.get(node) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BINReference removeCompressibleBinReference(long nodeId) {
        Long node = nodeId;
        BINReference foundRef = null;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            BINReference target = this.binRefQueue.remove(node);
            if (target != null) {
                if (target.deletedKeysExist()) {
                    foundRef = target;
                } else {
                    this.binRefQueue.put(node, target);
                }
            }
        }
        return foundRef;
    }

    public StatGroup loadStats(StatsConfig config) {
        this.compQueueSize.set(Long.valueOf(this.getBinRefQueueSize()));
        if (config.getClear()) {
            this.lazyProcessed = 0;
            this.lazyEmpty = 0;
            this.lazySplit = 0;
            this.wokenUp = 0;
        }
        return this.stats.cloneGroup(config.getClear());
    }

    @Override
    protected long nDeadlockRetries() {
        return this.env.getConfigManager().getInt(EnvironmentParams.COMPRESSOR_RETRY);
    }

    @Override
    public synchronized void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ++this.wokenUp;
        this.doCompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCompress() throws DatabaseException {
        Map<Long, BINReference> queueSnapshot = null;
        int binQueueSize = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            binQueueSize = this.binRefQueue.size();
            if (binQueueSize > 0) {
                queueSnapshot = this.binRefQueue;
                this.binRefQueue = new HashMap<Long, BINReference>();
            }
        }
        if (binQueueSize > 0) {
            this.resetPerRunCounters();
            LoggerUtils.fine(this.logger, this.envImpl, "InCompress.doCompress called, queue size: " + binQueueSize);
            assert (LatchSupport.countLatchesHeld() == 0);
            LocalUtilizationTracker localTracker = new LocalUtilizationTracker(this.env);
            HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
            DbTree dbTree = this.env.getDbTree();
            BINSearch binSearch = new BINSearch();
            try {
                Iterator<BINReference> it = queueSnapshot.values().iterator();
                while (it.hasNext()) {
                    if (this.env.isClosed()) {
                        return;
                    }
                    BINReference binRef = it.next();
                    if (!this.findDBAndBIN(binSearch, binRef, dbTree, dbCache)) continue;
                    if (binRef.deletedKeysExist()) {
                        boolean requeued = this.compressBin(binSearch.db, binSearch.bin, binRef, localTracker);
                        if (requeued) continue;
                        this.checkForRelocatedSlots(binSearch.db, binRef, localTracker);
                        continue;
                    }
                    BIN foundBin = binSearch.bin;
                    byte[] idKey = foundBin.getIdentifierKey();
                    boolean isDBIN = foundBin.containsDuplicates();
                    byte[] dupKey = null;
                    if (isDBIN) {
                        dupKey = ((DBIN)foundBin).getDupKey();
                    }
                    foundBin.releaseLatch();
                    this.pruneBIN(binSearch.db, binRef, idKey, isDBIN, dupKey, localTracker);
                }
                assert (TestHookExecute.doHookIfSet(this.beforeFlushTrackerHook));
                this.env.getUtilizationProfile().flushLocalTracker(localTracker);
            }
            finally {
                dbTree.releaseDbs(dbCache);
                assert (LatchSupport.countLatchesHeld() == 0);
                this.accumulatePerRunCounters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compressBin(DatabaseImpl db, BIN bin, BINReference binRef, LocalUtilizationTracker localTracker) throws DatabaseException {
        boolean empty = false;
        boolean requeued = false;
        byte[] idKey = bin.getIdentifierKey();
        byte[] dupKey = null;
        boolean isDBIN = bin.containsDuplicates();
        try {
            int nCursors = bin.nCursors();
            if (nCursors > 0) {
                this.addBinRefToQueue(binRef, false);
                requeued = true;
                ++this.cursorsBinsThisRun;
            } else {
                requeued = bin.compress(binRef, true, localTracker);
                if (!requeued) {
                    boolean bl = empty = bin.getNEntries() == 0;
                    if (empty && isDBIN) {
                        dupKey = ((DBIN)bin).getDupKey();
                    }
                }
            }
        }
        finally {
            bin.releaseLatch();
        }
        if (empty) {
            requeued = this.pruneBIN(db, binRef, idKey, isDBIN, dupKey, localTracker);
        }
        return requeued;
    }

    private boolean pruneBIN(DatabaseImpl dbImpl, BINReference binRef, byte[] idKey, boolean containsDups, byte[] dupKey, LocalUtilizationTracker localTracker) throws DatabaseException {
        boolean requeued = false;
        try {
            Tree tree = dbImpl.getTree();
            if (containsDups) {
                tree.deleteDup(idKey, dupKey, localTracker);
            } else {
                tree.delete(idKey, localTracker);
            }
            ++this.processedBinsThisRun;
        }
        catch (NodeNotEmptyException NNEE) {
            ++this.nonEmptyBinsThisRun;
        }
        catch (CursorsExistException e) {
            this.addBinRefToQueue(binRef, false);
            ++this.cursorsBinsThisRun;
            requeued = true;
        }
        return requeued;
    }

    private void checkForRelocatedSlots(DatabaseImpl db, BINReference binRef, LocalUtilizationTracker localTracker) throws DatabaseException {
        Iterator<Key> iter = binRef.getDeletedKeyIterator();
        if (iter != null) {
            boolean isDup;
            byte[] mainKey = binRef.getKey();
            boolean bl = isDup = binRef.getData() != null;
            while (iter.hasNext()) {
                Key key = iter.next();
                BIN splitBin = isDup ? this.searchForBIN(db, mainKey, key.getKey()) : this.searchForBIN(db, key.getKey(), null);
                if (splitBin == null) continue;
                BINReference splitBinRef = splitBin.createReference();
                splitBinRef.addDeletedKey(key);
                this.compressBin(db, splitBin, splitBinRef, localTracker);
            }
        }
    }

    public BIN searchForBIN(DatabaseImpl db, BINReference binRef) throws DatabaseException {
        return this.searchForBIN(db, binRef.getKey(), binRef.getData());
    }

    private BIN searchForBIN(DatabaseImpl db, byte[] mainKey, byte[] dupKey) throws DatabaseException {
        Tree tree = db.getTree();
        IN in = tree.search(mainKey, Tree.SearchType.NORMAL, -1L, null, CacheMode.UNCHANGED);
        if (in == null) {
            return null;
        }
        if (dupKey == null) {
            return (BIN)in;
        }
        IN duplicateRoot = null;
        boolean duplicateRootIsLatched = false;
        IN duplicateBin = null;
        BIN bin = (BIN)in;
        boolean binIsLatched = true;
        try {
            int index = bin.findEntry(mainKey, false, true);
            if (index >= 0) {
                Node node = null;
                if (!bin.isEntryKnownDeleted(index)) {
                    node = bin.fetchTarget(index);
                }
                if (node == null) {
                    bin.releaseLatch();
                    binIsLatched = false;
                    return null;
                }
                if (node.containsDuplicates()) {
                    duplicateRoot = (DIN)node;
                    duplicateRoot.latch(CacheMode.UNCHANGED);
                    duplicateRootIsLatched = true;
                    bin.releaseLatch();
                    binIsLatched = false;
                    duplicateBin = (DBIN)tree.searchSubTree(duplicateRoot, dupKey, Tree.SearchType.NORMAL, -1L, null, CacheMode.UNCHANGED);
                    duplicateRootIsLatched = false;
                    return duplicateBin;
                }
                return bin;
            }
            bin.releaseLatch();
            binIsLatched = false;
            return null;
        }
        catch (DatabaseException DBE) {
            if (bin != null && binIsLatched) {
                bin.releaseLatch();
            }
            if (duplicateRoot != null && duplicateRootIsLatched) {
                duplicateRoot.releaseLatch();
            }
            if (duplicateBin != null) {
                duplicateBin.releaseLatch();
            }
            throw DBE;
        }
    }

    private void resetPerRunCounters() {
        this.splitBinsThisRun = 0;
        this.dbClosedBinsThisRun = 0;
        this.cursorsBinsThisRun = 0;
        this.nonEmptyBinsThisRun = 0;
        this.processedBinsThisRun = 0;
    }

    private void accumulatePerRunCounters() {
        this.splitBins.add(this.splitBinsThisRun);
        this.dbClosedBins.add(this.dbClosedBinsThisRun);
        this.cursorsBins.add(this.cursorsBinsThisRun);
        this.nonEmptyBins.add(this.nonEmptyBinsThisRun);
        this.processedBins.add(this.processedBinsThisRun);
    }

    public void lazyCompress(IN in, LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!in.isCompressible()) {
            return;
        }
        assert (in.isLatchOwnerForWrite());
        BIN bin = (BIN)in;
        int nCursors = bin.nCursors();
        if (nCursors > 0) {
            return;
        }
        BINReference binRef = this.removeCompressibleBinReference(bin.getNodeId());
        if (binRef == null || !binRef.deletedKeysExist()) {
            return;
        }
        boolean requeued = bin.compress(binRef, false, localTracker);
        ++this.lazyProcessed;
        if (!requeued && binRef.deletedKeysExist()) {
            this.addBinRefToQueue(binRef, false);
            ++this.lazySplit;
        } else if (bin.getNEntries() == 0) {
            this.addBinRefToQueue(binRef, false);
            ++this.lazyEmpty;
        }
    }

    private boolean findDBAndBIN(BINSearch binSearch, BINReference binRef, DbTree dbTree, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        binSearch.db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
        if (binSearch.db == null || binSearch.db.isDeleted()) {
            ++this.dbClosedBinsThisRun;
            return false;
        }
        this.env.criticalEviction(true);
        binSearch.bin = this.searchForBIN(binSearch.db, binRef);
        if (binSearch.bin == null || binSearch.bin.getNodeId() != binRef.getNodeId()) {
            if (binSearch.bin != null) {
                binSearch.bin.releaseLatch();
            }
            ++this.splitBinsThisRun;
            return false;
        }
        return true;
    }

    private static class BINSearch {
        public DatabaseImpl db;
        public BIN bin;

        private BINSearch() {
        }
    }
}

