/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.locks.ReentrantLock;

public class Latch {
    private final JEReentrantLock lock = new JEReentrantLock(EnvironmentImpl.getFairLatches());
    private String name;
    private final StatGroup stats;
    private final IntStat nAcquiresNoWaiters;
    private final IntStat nAcquiresSelfOwned;
    private final IntStat nAcquiresWithContention;
    private final IntStat nAcquiresNoWaitSuccessful;
    private final IntStat nAcquiresNoWaitUnsuccessful;
    private final IntStat nReleases;

    public Latch(String name) {
        this.name = name;
        this.stats = new StatGroup("Latch", "Latch characteristics");
        this.nAcquiresNoWaiters = new IntStat(this.stats, LatchStatDefinition.LATCH_NO_WAITERS);
        this.nAcquiresSelfOwned = new IntStat(this.stats, LatchStatDefinition.LATCH_SELF_OWNED);
        this.nAcquiresWithContention = new IntStat(this.stats, LatchStatDefinition.LATCH_CONTENTION);
        this.nAcquiresNoWaitSuccessful = new IntStat(this.stats, LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
        this.nAcquiresNoWaitUnsuccessful = new IntStat(this.stats, LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
        this.nReleases = new IntStat(this.stats, LatchStatDefinition.LATCH_RELEASES);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        try {
            if (this.lock.isHeldByCurrentThread()) {
                this.nAcquiresSelfOwned.increment();
                throw EnvironmentFailureException.unexpectedState("Latch already held: " + this.name);
            }
            if (this.lock.isLocked()) {
                this.nAcquiresWithContention.increment();
            } else {
                this.nAcquiresNoWaiters.increment();
            }
            this.lock.lock();
            assert (this.noteLatch());
        }
        finally {
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireNoWait() {
        try {
            if (this.lock.isHeldByCurrentThread()) {
                this.nAcquiresSelfOwned.increment();
                throw EnvironmentFailureException.unexpectedState("Latch already held: " + this.name);
            }
            boolean ret = this.lock.tryLock();
            if (ret) {
                assert (this.noteLatch());
                this.nAcquiresNoWaitSuccessful.increment();
            } else {
                this.nAcquiresNoWaitUnsuccessful.increment();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    public void releaseIfOwner() {
        this.doRelease(false);
    }

    public void release() {
        if (this.doRelease(true)) {
            throw EnvironmentFailureException.unexpectedState("Latch not held: " + this.name);
        }
    }

    private boolean doRelease(boolean checkHeld) {
        try {
            if (!this.lock.isHeldByCurrentThread()) {
                return true;
            }
            this.lock.unlock();
            this.nReleases.increment();
            assert (this.unNoteLatch(checkHeld));
        }
        catch (IllegalMonitorStateException IMSE) {
            return true;
        }
        return false;
    }

    public boolean isOwner() {
        return this.lock.isHeldByCurrentThread();
    }

    public Thread owner() {
        return this.lock.getOwner();
    }

    public int nWaiters() {
        return this.lock.getQueueLength();
    }

    public StatGroup getLatchStats() {
        return this.stats;
    }

    public void clear() {
        this.stats.clear();
    }

    public String toString() {
        return this.lock.toString();
    }

    private boolean noteLatch() {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch(boolean checkHeld) {
        if (checkHeld) {
            return LatchSupport.latchTable.unNoteLatch(this, this.name);
        }
        LatchSupport.latchTable.unNoteLatch(this, this.name);
        return true;
    }

    private static class JEReentrantLock
    extends ReentrantLock {
        JEReentrantLock(boolean fair) {
            super(fair);
        }

        protected Thread getOwner() {
            return super.getOwner();
        }
    }
}

