/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionTimeoutException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThinLockImpl;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TinyHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockManager
implements EnvConfigObserver {
    static final long TOTAL_LOCKIMPL_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    static final long TOTAL_THINLOCKIMPL_OVERHEAD = MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
    private static final long REMOVE_TOTAL_LOCKIMPL_OVERHEAD = 0L - TOTAL_LOCKIMPL_OVERHEAD;
    private static final long REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD = 0L - TOTAL_THINLOCKIMPL_OVERHEAD;
    private static final long THINLOCK_MUTATE_OVERHEAD = MemoryBudget.LOCKIMPL_OVERHEAD - MemoryBudget.THINLOCKIMPL_OVERHEAD + MemoryBudget.LOCKINFO_OVERHEAD;
    private static final List<ThreadLocker> EMPTY_THREAD_LOCKERS = Collections.emptyList();
    int nLockTables = 1;
    Latch[] lockTableLatches;
    private final Map<Long, Lock>[] lockTables;
    private final boolean oldLockExceptions;
    private final EnvironmentImpl envImpl;
    private final MemoryBudget memoryBudget;
    private final StatGroup stats;
    private final LongStat nRequests;
    private final LongStat nWaits;
    private static RangeRestartException rangeRestartException = new RangeRestartException();
    private static boolean lockTableDump = false;
    private final Map<Thread, TinyHashSet<ThreadLocker>> threadLockers;

    public LockManager(EnvironmentImpl envImpl) {
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.nLockTables = configMgr.getInt(EnvironmentParams.N_LOCK_TABLES);
        this.oldLockExceptions = configMgr.getBoolean(EnvironmentParams.LOCK_OLD_LOCK_EXCEPTIONS);
        this.lockTables = new Map[this.nLockTables];
        this.lockTableLatches = new Latch[this.nLockTables];
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTables[i] = new HashMap<Long, Lock>();
            this.lockTableLatches[i] = new Latch("Lock Table " + i);
        }
        this.envImpl = envImpl;
        this.memoryBudget = envImpl.getMemoryBudget();
        this.stats = new StatGroup("Locks", "Locks held by data operations, latching contention on lock table.");
        this.nRequests = new LongStat(this.stats, LockStatDefinition.LOCK_REQUESTS);
        this.nWaits = new LongStat(this.stats, LockStatDefinition.LOCK_WAITS);
        this.envConfigUpdate(configMgr, null);
        envImpl.addConfigObserver(this);
        this.threadLockers = envImpl.isReplicated() ? new ConcurrentHashMap<Thread, TinyHashSet<ThreadLocker>>() : null;
    }

    @Override
    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig ignore) {
        LockInfo.setDeadlockStackTrace(configMgr.getBoolean(EnvironmentParams.TXN_DEADLOCK_STACK_TRACE));
        LockManager.setLockTableDump(configMgr.getBoolean(EnvironmentParams.TXN_DUMPLOCKS));
    }

    static void setLockTableDump(boolean enable) {
        lockTableDump = enable;
    }

    int getLockTableIndex(Long nodeId) {
        return ((int)nodeId.longValue() & Integer.MAX_VALUE) % this.nLockTables;
    }

    int getLockTableIndex(long nodeId) {
        return ((int)nodeId & Integer.MAX_VALUE) % this.nLockTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, DatabaseImpl database) throws LockConflictException, DatabaseException {
        assert (timeout >= 0L);
        if (type == LockType.NONE) {
            return LockGrantType.NONE_NEEDED;
        }
        if (this.envImpl.isReplicated() && database != null && database.isReplicated() && !database.getId().equals(DbTree.NAME_DB_ID) && (locker.getPreemptable() || type.isWriteLock()) && !locker.isReplicationDefined()) {
            throw EnvironmentFailureException.unexpectedState("Locker: " + locker.getClass().getName());
        }
        Locker locker2 = locker;
        synchronized (locker2) {
            LockGrantType ret = null;
            ret = this.lockInternal(nodeId, locker, type, timeout, nonBlockingRequest, database);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockGrantType lockInternal(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, DatabaseImpl database) throws DeadlockException, DatabaseException {
        Long nid = nodeId;
        LockAttemptResult result = this.attemptLock(nid, locker, type, nonBlockingRequest);
        if (result.success || result.lockGrant == LockGrantType.DENIED) {
            assert (nonBlockingRequest || result.success);
            return result.lockGrant;
        }
        assert (this.checkNoLatchesHeld(nonBlockingRequest)) : LatchSupport.countLatchesHeld() + " latches held while trying to lock, lock table =" + LatchSupport.latchesHeldToString();
        assert (!nonBlockingRequest);
        try {
            long startTime;
            boolean doWait = true;
            boolean isImportunate = locker.getImportunate();
            if (locker.isTimedOut()) {
                if (this.validateOwnership(nid, locker, type, !isImportunate, this.memoryBudget)) {
                    doWait = false;
                } else if (isImportunate) {
                    result = this.stealLock(nid, locker, type, this.memoryBudget);
                    if (result.success) {
                        doWait = false;
                    }
                } else {
                    throw this.makeTimeoutMsg(false, locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeout(), locker.getTxnStartMillis(), System.currentTimeMillis(), database);
                }
            }
            boolean keepTime = timeout > 0L;
            long l = startTime = keepTime ? System.currentTimeMillis() : 0L;
            while (doWait) {
                locker.setWaitingFor(result.useLock);
                try {
                    locker.wait(timeout);
                }
                catch (InterruptedException IE) {
                    throw new ThreadInterruptedException(this.envImpl, (Throwable)IE);
                }
                boolean lockerTimedOut = locker.isTimedOut();
                long now = System.currentTimeMillis();
                boolean thisLockTimedOut = keepTime && now - startTime >= timeout;
                boolean isRestart = result.lockGrant == LockGrantType.WAIT_RESTART;
                if (this.validateOwnership(nid, locker, type, (lockerTimedOut || thisLockTimedOut || isRestart) && !isImportunate, this.memoryBudget)) break;
                if (isImportunate) {
                    result = this.stealLock(nid, locker, type, this.memoryBudget);
                    if (!result.success) continue;
                    break;
                }
                if (isRestart) {
                    throw rangeRestartException;
                }
                if (thisLockTimedOut) {
                    throw this.makeTimeoutMsg(true, locker, nodeId, type, result.lockGrant, result.useLock, timeout, startTime, now, database);
                }
                if (!lockerTimedOut) continue;
                throw this.makeTimeoutMsg(false, locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeout(), locker.getTxnStartMillis(), now, database);
            }
            Object var22_18 = null;
            locker.setWaitingFor(null);
        }
        catch (Throwable throwable) {
            Object var22_19 = null;
            locker.setWaitingFor(null);
            assert (EnvironmentImpl.maybeForceYield());
            throw throwable;
        }
        assert (EnvironmentImpl.maybeForceYield());
        locker.addLock(nid, type, result.lockGrant);
        return result.lockGrant;
    }

    abstract Lock lookupLock(Long var1) throws DatabaseException;

    Lock lookupLockInternal(Long nodeId, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        return useLock;
    }

    abstract LockAttemptResult attemptLock(Long var1, Locker var2, LockType var3, boolean var4) throws DatabaseException;

    LockAttemptResult attemptLockInternal(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest, int lockTableIndex) throws DatabaseException {
        this.nRequests.increment();
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        if (useLock == null) {
            useLock = new ThinLockImpl();
            lockTable.put(nodeId, useLock);
            this.memoryBudget.updateLockMemoryUsage(TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
        }
        LockAttemptResult lar = useLock.lock(type, locker, nonBlockingRequest, this.memoryBudget, lockTableIndex);
        if (lar.useLock != useLock) {
            useLock = lar.useLock;
            lockTable.put(nodeId, useLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        LockGrantType lockGrant = lar.lockGrant;
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(nodeId, type, lockGrant);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else if (lockGrant != LockGrantType.DENIED) {
            this.nWaits.increment();
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    abstract LockConflictException makeTimeoutMsg(boolean var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12, DatabaseImpl var14) throws DatabaseException;

    LockConflictException makeTimeoutMsgInternal(boolean isLockNotTxnTimeout, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) {
        if (lockTableDump) {
            System.out.println("++++++++++ begin lock table dump ++++++++++");
            for (int i = 0; i < this.nLockTables; ++i) {
                boolean success = false;
                for (int j = 0; j < 3 && !success; ++j) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        this.dumpToStringNoLatch(sb, i);
                        System.out.println(sb.toString());
                        success = true;
                        break;
                    }
                    catch (ConcurrentModificationException CME) {
                        continue;
                    }
                }
                if (success) continue;
                System.out.println("Couldn't dump locktable " + i);
            }
            System.out.println("++++++++++ end lock table dump ++++++++++");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(isLockNotTxnTimeout ? "Lock" : "Transaction");
        sb.append(" expired. Locker ").append(locker);
        sb.append(": waited for lock");
        if (database != null) {
            sb.append(" on database=").append(database.getDebugName());
        }
        sb.append(" LockAddr:").append(System.identityHashCode(useLock));
        sb.append(" node=").append(nodeId);
        sb.append(" type=").append(type);
        sb.append(" grant=").append(grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start);
        sb.append(" endTime=").append(now);
        Set<LockInfo> owners = useLock.getOwnersClone();
        List<LockInfo> waiters = useLock.getWaitersListClone();
        sb.append("\nOwners: ").append(owners);
        sb.append("\nWaiters: ").append(waiters).append("\n");
        StringBuilder deadlockInfo = this.findDeadlock(useLock, locker);
        if (deadlockInfo != null) {
            sb.append((CharSequence)deadlockInfo);
        }
        LockConflictException ret = isLockNotTxnTimeout ? this.newLockTimeoutException(locker, sb.toString()) : this.newTxnTimeoutException(locker, sb.toString());
        ret.setOwnerTxnIds(this.getTxnIds(owners));
        ret.setWaiterTxnIds(this.getTxnIds(waiters));
        ret.setTimeoutMillis(timeout);
        return ret;
    }

    private long[] getTxnIds(Collection<LockInfo> c) {
        long[] ret = new long[c.size()];
        Iterator<LockInfo> iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LockInfo info = iter.next();
            ret[i++] = info.getLocker().getId();
        }
        return ret;
    }

    private LockConflictException newTxnTimeoutException(Locker locker, String msg) {
        return this.oldLockExceptions ? new DeadlockException(locker, msg) : new TransactionTimeoutException(locker, msg);
    }

    private LockConflictException newLockTimeoutException(Locker locker, String msg) {
        return this.oldLockExceptions ? new DeadlockException(locker, msg) : new LockTimeoutException(locker, msg);
    }

    LockConflictException newLockNotAvailableException(Locker locker, String msg) {
        return this.oldLockExceptions ? new LockNotGrantedException(locker, msg) : new LockNotAvailableException(locker, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(long nodeId, Locker locker) throws DatabaseException {
        Locker locker2 = locker;
        synchronized (locker2) {
            Set<Locker> newOwners = this.releaseAndFindNotifyTargets(nodeId, locker);
            if (newOwners == null) {
                return false;
            }
            if (newOwners.size() > 0) {
                Iterator<Locker> iter = newOwners.iterator();
                while (iter.hasNext()) {
                    Locker lockerToNotify;
                    Locker locker3 = lockerToNotify = iter.next();
                    synchronized (locker3) {
                        lockerToNotify.notifyAll();
                    }
                    assert (EnvironmentImpl.maybeForceYield());
                }
            }
            return true;
        }
    }

    abstract Set<Locker> releaseAndFindNotifyTargets(long var1, Locker var3) throws DatabaseException;

    Set<Locker> releaseAndFindNotifyTargetsInternal(long nodeId, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        if (useLock == null) {
            useLock = lockTable.get(nodeId);
        }
        if (useLock == null) {
            return null;
        }
        Set<Locker> lockersToNotify = useLock.release(locker, this.memoryBudget, lockTableIndex);
        if (lockersToNotify == null) {
            return null;
        }
        if (useLock.nWaiters() == 0 && useLock.nOwners() == 0) {
            this.lockTables[lockTableIndex].remove(nodeId);
            if (useLock.isThin()) {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_THINLOCKIMPL_OVERHEAD, lockTableIndex);
            } else {
                this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_LOCKIMPL_OVERHEAD, lockTableIndex);
            }
        }
        return lockersToNotify;
    }

    abstract void transfer(long var1, Locker var3, Locker var4, boolean var5) throws DatabaseException;

    void transferInternal(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead, int lockTableIndex) throws DatabaseException {
        Lock newLock;
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        assert (useLock != null) : "Transfer, lock " + nodeId + " was null";
        if (demoteToRead) {
            useLock.demote(owningLocker);
        }
        if ((newLock = useLock.transfer(nodeId, owningLocker, destLocker, this.memoryBudget, lockTableIndex)) != useLock) {
            lockTable.put(nodeId, newLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        owningLocker.removeLock(nodeId);
    }

    abstract void transferMultiple(long var1, Locker var3, Locker[] var4) throws DatabaseException;

    void transferMultipleInternal(long nodeId, Locker owningLocker, Locker[] destLockers, int lockTableIndex) throws DatabaseException {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        assert (useLock != null) : "Transfer, lock " + nodeId + " was null";
        useLock.demote(owningLocker);
        Lock newLock = useLock.transferMultiple(nodeId, owningLocker, destLockers, this.memoryBudget, lockTableIndex);
        if (newLock != useLock) {
            lockTable.put(nodeId, newLock);
            this.memoryBudget.updateLockMemoryUsage(THINLOCK_MUTATE_OVERHEAD, lockTableIndex);
        }
        owningLocker.removeLock(nodeId);
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    void demoteInternal(long nodeId, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock useLock = lockTable.get(nodeId);
        useLock.demote(locker);
        locker.moveWriteToReadLock(nodeId, useLock);
    }

    abstract boolean isLocked(Long var1) throws DatabaseException;

    boolean isLockedInternal(Long nodeId, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.nOwners() != 0;
    }

    abstract boolean isOwner(Long var1, Locker var2, LockType var3) throws DatabaseException;

    boolean isOwnerInternal(Long nodeId, Locker locker, LockType type, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isOwner(locker, type);
    }

    abstract boolean isWaiter(Long var1, Locker var2) throws DatabaseException;

    boolean isWaiterInternal(Long nodeId, Locker locker, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isWaiter(locker);
    }

    abstract int nWaiters(Long var1) throws DatabaseException;

    int nWaitersInternal(Long nodeId, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nWaiters();
    }

    abstract int nOwners(Long var1) throws DatabaseException;

    int nOwnersInternal(Long nodeId, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock entry = lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nOwners();
    }

    abstract Locker getWriteOwnerLocker(Long var1) throws DatabaseException;

    Locker getWriteOwnerLockerInternal(Long nodeId, int lockTableIndex) {
        Map<Long, Lock> lockTable = this.lockTables[lockTableIndex];
        Lock lock = lockTable.get(nodeId);
        if (lock == null) {
            return null;
        }
        if (lock.nOwners() > 1) {
            return null;
        }
        return lock.getWriteOwnerLocker();
    }

    abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4, MemoryBudget var5) throws DatabaseException;

    boolean validateOwnershipInternal(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb, int lockTableIndex) {
        Lock entry;
        if (this.isOwnerInternal(nodeId, locker, type, lockTableIndex)) {
            return true;
        }
        if (flushFromWaiters && (entry = this.lockTables[lockTableIndex].get(nodeId)) != null) {
            entry.flushWaiter(locker, mb, lockTableIndex);
        }
        return false;
    }

    protected abstract LockAttemptResult stealLock(Long var1, Locker var2, LockType var3, MemoryBudget var4) throws DatabaseException;

    protected LockAttemptResult stealLockInternal(Long nodeId, Locker locker, LockType lockType, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        Lock entry = this.lockTables[lockTableIndex].get(nodeId);
        assert (entry != null);
        entry.flushWaiter(locker, mb, lockTableIndex);
        entry.stealLock(locker, mb, lockTableIndex);
        return this.attemptLockInternal(nodeId, locker, lockType, false, lockTableIndex);
    }

    public void registerThreadLocker(ThreadLocker locker) {
        if (this.threadLockers == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        if (set != null) {
            boolean added = set.add(locker);
            assert (added);
        } else {
            this.threadLockers.put(thread, new TinyHashSet<ThreadLocker>(locker));
        }
    }

    public void unregisterThreadLocker(ThreadLocker locker) {
        if (this.threadLockers == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        assert (set != null);
        boolean removed = set.remove(locker);
        assert (removed);
        if (this.threadLockers.size() == 0) {
            this.threadLockers.remove(thread);
        }
    }

    public Iterator<ThreadLocker> getThreadLockers(Thread thread) {
        if (this.threadLockers == null) {
            return EMPTY_THREAD_LOCKERS.iterator();
        }
        TinyHashSet<ThreadLocker> set = this.threadLockers.get(thread);
        if (set == null) {
            return EMPTY_THREAD_LOCKERS.iterator();
        }
        return set.iterator();
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        StatGroup latchStats = new StatGroup("Locktable latches", "Shows lock table contention");
        for (int i = 0; i < this.nLockTables; ++i) {
            latchStats.addAll(this.lockTableLatches[i].getLatchStats());
        }
        StatGroup tableStats = new StatGroup("Locktable", "The types of locks held in the lock table");
        if (!config.getFast()) {
            this.dumpLockTable(tableStats, false);
        }
        return new LockStats(this.stats.cloneGroup(config.getClear()), latchStats.cloneGroup(config.getClear()), tableStats.cloneGroup(config.getClear()));
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        StatGroup latchStats = new StatGroup("Locktable latches", "Shows lock table contention");
        for (int i = 0; i < this.nLockTables; ++i) {
            latchStats.addAll(this.lockTableLatches[i].getLatchStats());
            if (!config.getClear()) continue;
            this.lockTableLatches[i].clear();
        }
        copyStats.addAll(latchStats);
        StatGroup tableStats = new StatGroup("Locktable", "The types of locks held in the lock table");
        if (!config.getFast()) {
            this.dumpLockTable(tableStats, config.getClear());
        }
        copyStats.addAll(tableStats);
        return copyStats;
    }

    abstract void dumpLockTable(StatGroup var1, boolean var2) throws DatabaseException;

    void dumpLockTableInternal(StatGroup tableStats, int i, boolean clear) {
        StatGroup oneTable = new StatGroup("Single lock table", "Temporary stat group");
        IntStat totalLocks = new IntStat(oneTable, LockStatDefinition.LOCK_TOTAL);
        IntStat waiters = new IntStat(oneTable, LockStatDefinition.LOCK_WAITERS);
        IntStat owners = new IntStat(oneTable, LockStatDefinition.LOCK_OWNERS);
        IntStat readLocks = new IntStat(oneTable, LockStatDefinition.LOCK_READ_LOCKS);
        IntStat writeLocks = new IntStat(oneTable, LockStatDefinition.LOCK_WRITE_LOCKS);
        Map<Long, Lock> lockTable = this.lockTables[i];
        totalLocks.add(lockTable.size());
        for (Lock lock : lockTable.values()) {
            waiters.add(lock.nWaiters());
            owners.add(lock.nOwners());
            for (LockInfo info : lock.getOwnersClone()) {
                if (info.getLockType().isWriteLock()) {
                    writeLocks.increment();
                    continue;
                }
                readLocks.increment();
            }
        }
        tableStats.addAll(oneTable);
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpToString() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nLockTables; ++i) {
            Object var4_3;
            this.lockTableLatches[i].acquire();
            try {
                this.dumpToStringNoLatch(sb, i);
                var4_3 = null;
                this.lockTableLatches[i].release();
                continue;
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.lockTableLatches[i].release();
                throw throwable;
            }
        }
        return sb.toString();
    }

    private void dumpToStringNoLatch(StringBuilder sb, int whichTable) {
        Map<Long, Lock> lockTable = this.lockTables[whichTable];
        for (Map.Entry<Long, Lock> entry : lockTable.entrySet()) {
            Long nid = entry.getKey();
            Lock lock = entry.getValue();
            sb.append("---- Node Id: ").append(nid).append("----\n");
            sb.append(lock);
            sb.append('\n');
        }
    }

    private boolean checkNoLatchesHeld(boolean nonBlockingRequest) {
        if (nonBlockingRequest) {
            return true;
        }
        return LatchSupport.countLatchesHeld() == 0;
    }

    private StringBuilder findDeadlock(Lock lock, Locker rootLocker) {
        HashSet<Locker> ownerSet = new HashSet<Locker>();
        ownerSet.add(rootLocker);
        StringBuilder ret = this.findDeadlock1(ownerSet, lock, rootLocker);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private StringBuilder findDeadlock1(Set<Locker> ownerSet, Lock lock, Locker rootLocker) {
        for (LockInfo info : lock.getOwnersClone()) {
            Locker locker = info.getLocker();
            Lock waitsFor = locker.getWaitingFor();
            if (ownerSet.contains(locker) || locker == rootLocker) {
                StringBuilder ret = new StringBuilder();
                ret.append("Transaction ").append(locker.toString());
                ret.append(" owns LockAddr:").append(System.identityHashCode(lock));
                ret.append(" ").append(info).append("\n");
                ret.append("Transaction ").append(locker.toString());
                ret.append(" waits for");
                if (waitsFor == null) {
                    ret.append(" nothing");
                } else {
                    ret.append(" LockAddr:");
                    ret.append(System.identityHashCode(waitsFor));
                }
                ret.append("\n");
                return ret;
            }
            if (waitsFor == null) continue;
            ownerSet.add(locker);
            StringBuilder sb = this.findDeadlock1(ownerSet, waitsFor, rootLocker);
            if (sb != null) {
                String waitInfo = "Transaction " + locker + " waits for " + waitsFor + "\n";
                sb.insert(0, waitInfo);
                return sb;
            }
            ownerSet.remove(locker);
        }
        return null;
    }
}

