/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN
implements LoggableObject {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    protected Set cursorSet = new HashSet();
    private long lastDeltaVersion = -1L;
    private int numDeltasSinceLastFull = 0;
    private boolean prohibitNextDelta = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BIN() {
    }

    public BIN(DatabaseImpl db, Key identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getDupKey();
    }

    public LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_BIN_DELTA;
    }

    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    protected void setCompressedSinceLastLog() {
        this.prohibitNextDelta = true;
    }

    public void setCleanedSinceLastLog() {
        this.prohibitNextDelta = true;
    }

    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            if (targetContainsDuplicates && targetIsRoot) {
                long childNid = child.getNodeId();
                ((IN)child).releaseLatch();
                result.keepSearching = false;
                result.exactParentFound = childNid == targetNodeId;
                if (requireExactMatch && !result.exactParentFound) {
                    result.parent = null;
                    this.releaseLatch();
                } else {
                    result.parent = this;
                }
            } else {
                this.releaseLatch();
                result.parent = (IN)child;
            }
        } else {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (!requireExactMatch && targetContainsDuplicates) {
                result.parent = this;
            } else {
                this.releaseLatch();
                result.parent = null;
            }
        }
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return targetContainsDuplicates;
    }

    public boolean isEvictable() {
        if (this.evictionProhibited) {
            return false;
        }
        if (this.nCursors() > 0) {
            return false;
        }
        return this.childrenAreEvictable();
    }

    protected boolean childrenAreEvictable() {
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getTarget(i) == null || this.getTarget(i) instanceof LN) continue;
            return false;
        }
        return true;
    }

    boolean entryZeroKeyComparesLow() {
        return false;
    }

    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        this.updateMemorySize(this.getTarget(index), null);
        super.setTarget(index, null);
        this.setDirty(true);
    }

    public void setKnownDeletedLeaveTarget(int index) {
        super.setKnownDeleted(index);
        this.setDirty(true);
    }

    public void clearKnownDeleted(int index) {
        super.clearKnownDeleted(index);
        this.setDirty(true);
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return 464L + IN.computeArraysOverhead(configManager);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getBINOverhead();
    }

    public Set getCursorSet() {
        return this.cursorSet;
    }

    public void addCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.remove(cursor);
    }

    public int nCursors() {
        return this.cursorSet.size();
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getBIN();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setBIN(bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setIndex(index);
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, Key key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        if (!$assertionsDisabled && !newSibling.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = (CursorImpl)iter.next();
            int cIdx = this.getCursorIndex(cursor);
            BIN cBin = this.getCursorBIN(cursor);
            if (!$assertionsDisabled && cBin != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(newSibling instanceof BIN)) {
                throw new AssertionError();
            }
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    this.setCursorBIN(cursor, ns);
                    iter.remove();
                    ns.addCursor(cursor);
                    continue;
                }
                this.setCursorIndex(cursor, cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            this.setCursorIndex(cursor, cIdx - newSiblingLow);
            this.setCursorBIN(cursor, ns);
            iter.remove();
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                BIN cBin = this.getCursorBIN(cursor);
                if (!$assertionsDisabled && cBin != this) {
                    throw new AssertionError();
                }
            }
        }
    }

    void adjustCursorsForInsert(int insertIndex) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                int cIdx = this.getCursorIndex(cursor);
                if (insertIndex > cIdx) continue;
                this.setCursorIndex(cursor, cIdx + 1);
            }
        }
    }

    void adjustCursorsForMutation(int binIndex, DBIN dupBin, int dupBinIndex, CursorImpl excludeCursor) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                if (cursor == excludeCursor || cursor.getIndex() != binIndex) continue;
                if (!$assertionsDisabled && cursor.getDupBIN() != null) {
                    throw new AssertionError();
                }
                cursor.addCursor(dupBin);
                cursor.updateDBin(dupBin, dupBinIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compress(BINReference binRef) throws DatabaseException {
        boolean ret = false;
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        BasicLocker lockingTxn = new BasicLocker(db.getDbEnvironment());
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                boolean entryIsIdentifierKey;
                boolean deleteEntry = false;
                if (binRef == null || binRef.hasDeletedKey(this.getKey(i))) {
                    Node n = this.fetchTargetIgnoreKnownDeleted(i);
                    if (n == null) {
                        deleteEntry = true;
                    } else if (this.isEntryKnownDeleted(i)) {
                        LockGrantType lockRet = lockingTxn.nonBlockingReadLock(n.getNodeId(), db);
                        if (lockRet == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        deleteEntry = true;
                    } else if (!n.containsDuplicates()) {
                        LN ln = (LN)n;
                        LockGrantType lockRet = lockingTxn.nonBlockingReadLock(ln.getNodeId(), db);
                        if (lockRet == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        if (ln.isDeleted()) {
                            deleteEntry = true;
                        }
                    }
                    if (binRef != null) {
                        binRef.removeDeletedKey(this.getKey(i));
                    }
                }
                if (!deleteEntry) continue;
                Comparator userComparisonFcn = this.getKeyComparator();
                boolean bl = entryIsIdentifierKey = (userComparisonFcn == null ? this.getKey(i).compareTo(this.getIdentifierKey()) : userComparisonFcn.compare(this.getKey(i).getKey(), this.getIdentifierKey().getKey())) == 0;
                if (entryIsIdentifierKey) {
                    setNewIdKey = true;
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                if (!$assertionsDisabled && !deleteSuccess) {
                    throw new AssertionError();
                }
                --i;
            }
        }
        finally {
            if (lockingTxn != null) {
                lockingTxn.operationEnd();
            }
        }
        if (anyLocksDenied && binRef != null) {
            db.getDbEnvironment().addToCompressorQueue(binRef);
            ret = true;
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        return ret;
    }

    public long evictLNs() throws DatabaseException {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError((Object)"BIN must be latched before evicting LNs");
        }
        long removed = 0L;
        if (this.nCursors() == 0) {
            for (int i = 0; i < this.getNEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null || !(n instanceof LN)) continue;
                this.setTarget(i, null);
                removed += n.getMemorySizeIncludedByParent();
            }
            this.updateMemorySize(removed, 0L);
        }
        return removed;
    }

    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidForDelete() throws DatabaseException {
        int validIndex = 0;
        int numValidEntries = 0;
        boolean needToLatch = !this.getLatch().isOwner();
        try {
            int i;
            if (needToLatch) {
                this.latch();
            }
            for (i = 0; i < this.getNEntries(); ++i) {
                if (this.isEntryKnownDeleted(i)) continue;
                ++numValidEntries;
                validIndex = i;
            }
            if (numValidEntries > 1) {
                i = 0;
                return i != 0;
            }
            if (this.nCursors() > 0) {
                i = 0;
                return i != 0;
            }
            if (numValidEntries == 1) {
                Node child = this.fetchTarget(validIndex);
                boolean bl = child.isValidForDelete();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needToLatch && this.getLatch().isOwner()) {
                this.releaseLatch();
            }
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public Comparator getKeyComparator() {
        return this.getDatabase().getBtreeComparator();
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    public String shortClassName() {
        return "BIN";
    }

    protected long logInternal(LogManager logManager, boolean allowDeltas, boolean isProvisional) throws DatabaseException {
        boolean doDeltaLog = false;
        long lastFullVersion = this.getLastFullVersion();
        BINDelta deltaInfo = null;
        if (allowDeltas && lastFullVersion != -1L && !this.prohibitNextDelta) {
            deltaInfo = new BINDelta(this);
            doDeltaLog = this.doDeltaLog(deltaInfo);
        }
        long returnLsn = -1L;
        if (doDeltaLog) {
            this.lastDeltaVersion = logManager.log(deltaInfo);
            returnLsn = -1L;
            ++this.numDeltasSinceLastFull;
        } else {
            returnLsn = logManager.log(new INLogEntry(this), isProvisional, lastFullVersion, false);
            this.setLastFullLsn(returnLsn);
            this.lastDeltaVersion = -1L;
            this.numDeltasSinceLastFull = 0;
            this.setDirty(false);
        }
        this.prohibitNextDelta = false;
        return returnLsn;
    }

    private boolean doDeltaLog(BINDelta deltaInfo) throws DatabaseException {
        int maxDiffs = this.getNEntries() * this.getDatabase().getBinDeltaPercent() / 100;
        return deltaInfo.getNumDeltas() <= maxDiffs && this.numDeltasSinceLastFull < this.getDatabase().getBinMaxDeltas();
    }

    static {
        $assertionsDisabled = !BIN.class.desiredAssertionStatus();
    }
}

