/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;

public class DbSpace {
    private static final String USAGE = "usage: java " + DbSpace.class.getName() + "\n" + "       -h <dir> # environment home directory\n" + "       [-q]     # quiet, print grand totals only\n" + "       [-u]     # sort by utilization\n" + "       [-d]     # dump file summary details\n" + "       [-V]     # print JE version number";
    private File envHome = null;
    private Environment env;
    private boolean quiet = false;
    private boolean sorted = false;
    private boolean details = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws DatabaseException {
        DbSpace space = new DbSpace();
        space.parseArgs(argv);
        try {
            space.print(System.out);
            System.exit(0);
        }
        catch (Throwable T) {
            if (space.quiet) {
                System.exit(1);
            } else {
                T.printStackTrace(System.err);
            }
        }
        finally {
            space.env.close();
        }
    }

    private DbSpace() {
    }

    public DbSpace(Environment env, boolean quiet, boolean sorted) {
        this.env = env;
        this.quiet = quiet;
        this.sorted = sorted;
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-u")) {
                this.sorted = true;
                continue;
            }
            if (thisArg.equals("-d")) {
                this.details = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (!thisArg.equals("-h")) continue;
            if (argc < nArgs) {
                this.envHome = new File(argv[argc++]);
                continue;
            }
            this.printUsage("-h requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    private void openEnv() throws DatabaseException {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(true);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    public void print(PrintStream out) throws DatabaseException {
        this.openEnv();
        UtilizationProfile profile = DbInternal.envGetEnvironmentImpl(this.env).getUtilizationProfile();
        SortedMap map = profile.getFileSummaryMap(false);
        int fileIndex = 0;
        Summary totals = new Summary();
        Object[] summaries = null;
        if (!this.quiet) {
            summaries = new Summary[map.size()];
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Long fileNum = (Long)i.next();
            FileSummary fs = (FileSummary)map.get(fileNum);
            Summary summary = new Summary(fileNum, fs, fileIndex, profile);
            if (summaries != null) {
                summaries[fileIndex] = summary;
            }
            if (this.details) {
                out.println("File 0x" + Long.toHexString(fileNum) + ": " + fs);
            }
            totals.add(summary);
            ++fileIndex;
        }
        if (this.details) {
            out.println();
        }
        out.println("  File    Size (KB)  % Used\n--------  ---------  ------");
        if (summaries != null) {
            if (this.sorted) {
                Arrays.sort(summaries);
            }
            for (int i2 = 0; i2 < summaries.length; ++i2) {
                ((Summary)summaries[i2]).print(out);
            }
        }
        totals.print(out);
    }

    private static class Summary
    implements Comparable {
        static final String HEADER = "  File    Size (KB)  % Used\n--------  ---------  ------";
        Long fileNum;
        long totalSize;
        long obsoleteSize;

        Summary() {
        }

        Summary(Long fileNum, FileSummary summary, int fileIndex, UtilizationProfile profile) throws DatabaseException {
            this.fileNum = fileNum;
            this.totalSize = summary.totalSize;
            this.obsoleteSize = summary.getObsoleteSize(fileIndex, profile);
        }

        public int compareTo(Object other) {
            Summary o = (Summary)other;
            return this.utilization() - o.utilization();
        }

        void add(Summary o) {
            this.totalSize += o.totalSize;
            this.obsoleteSize += o.obsoleteSize;
        }

        void print(PrintStream out) {
            if (this.fileNum != null) {
                this.pad(out, Long.toHexString(this.fileNum), 8, '0');
            } else {
                out.print(" TOTALS ");
            }
            int kb = (int)(this.totalSize / 1024L);
            int util = this.utilization();
            out.print("  ");
            this.pad(out, Integer.toString(kb), 9, ' ');
            out.print("     ");
            this.pad(out, Integer.toString(util), 3, ' ');
            out.println();
        }

        int utilization() {
            return UtilizationProfile.utilization(this.obsoleteSize, this.totalSize);
        }

        private void pad(PrintStream out, String val, int digits, char padChar) {
            int padSize = digits - val.length();
            for (int i = 0; i < padSize; ++i) {
                out.print(padChar);
            }
            out.print(val);
        }
    }
}

