/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ScavengerFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.util.DbDump;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DbScavenger
extends DbDump {
    private int readBufferSize;
    private EnvironmentImpl envImpl;
    private Set committedTxnIdsSeen;
    private Set nodeIdsSeen;
    private Map dbIdToName;
    private Map dbIdToDupSort;
    private Map dbIdToOutputStream;
    private boolean dumpCorruptedBounds = false;

    public DbScavenger(Environment env, PrintStream outputFile, boolean formatUsingPrintable, boolean doAggressiveScavengerRun) {
        super(env, null, outputFile, formatUsingPrintable);
        this.doAggressiveScavengerRun = doAggressiveScavengerRun;
        this.dbIdToName = new HashMap();
        this.dbIdToDupSort = new HashMap();
        this.dbIdToOutputStream = new HashMap();
    }

    public void setDumpCorruptedBounds(boolean dumpCorruptedBounds) {
        this.dumpCorruptedBounds = dumpCorruptedBounds;
    }

    public void dump() throws IOException, DatabaseException {
        this.openEnv(false);
        this.envImpl = DbInternal.envGetEnvironmentImpl(this.env);
        DbConfigManager cm = this.envImpl.getConfigManager();
        try {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        catch (DatabaseException DBE) {
            this.readBufferSize = 8192;
        }
        LastFileReader reader = new LastFileReader(this.envImpl, this.readBufferSize);
        while (reader.readNextEntry()) {
        }
        long lastUsedLsn = reader.getLastValidLsn();
        long nextAvailableLsn = reader.getEndOfLog();
        this.envImpl.getFileManager().setLastPosition(nextAvailableLsn, lastUsedLsn, reader.getPrevOffset());
        this.scavengeDbTree(lastUsedLsn, nextAvailableLsn);
        this.scavenge(lastUsedLsn, nextAvailableLsn);
    }

    private void scavengeDbTree(long lastUsedLsn, long nextAvailableLsn) throws IOException, DatabaseException {
        this.committedTxnIdsSeen = new HashSet();
        this.nodeIdsSeen = new HashSet();
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processDbTreeEntry(entry, entryType);
            }
        };
        scavengerReader.setTargetType(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_MAPLN);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_COMMIT);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_ABORT);
        while (scavengerReader.readNextEntry()) {
        }
    }

    private boolean checkProcessEntry(LogEntry entry, LogEntryType entryType, boolean pass2) {
        boolean isTransactional = entry.isTransactional();
        if (isTransactional) {
            Long txnId = new Long(entry.getTransactionId());
            if (entryType.equals(LogEntryType.LOG_TXN_COMMIT)) {
                this.committedTxnIdsSeen.add(txnId);
                return false;
            }
            if (entryType.equals(LogEntryType.LOG_TXN_ABORT)) {
                return false;
            }
            if (!this.committedTxnIdsSeen.contains(txnId)) {
                return false;
            }
        }
        if (entry instanceof LNLogEntry) {
            boolean isDelDupLN;
            LNLogEntry lnEntry = (LNLogEntry)entry;
            LN ln = lnEntry.getLN();
            Long nodeId = new Long(ln.getNodeId());
            boolean bl = isDelDupLN = entryType.equals(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL) || entryType.equals(LogEntryType.LOG_DEL_DUPLN);
            if (pass2 && this.doAggressiveScavengerRun) {
                return !isDelDupLN;
            }
            if (this.nodeIdsSeen.contains(nodeId)) {
                return false;
            }
            this.nodeIdsSeen.add(nodeId);
            return !isDelDupLN;
        }
        return false;
    }

    private void processDbTreeEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, false);
        if (processThisEntry && entry instanceof LNLogEntry) {
            Integer dbId;
            LNLogEntry lnEntry = (LNLogEntry)entry;
            LN ln = lnEntry.getLN();
            if (ln instanceof NameLN) {
                String name = new String(lnEntry.getKey().getKey());
                dbId = new Integer(((NameLN)ln).getId().getId());
                if (this.dbIdToName.containsKey(dbId) && !((String)this.dbIdToName.get(dbId)).equals(name)) {
                    throw new DatabaseException("Already name mapped for dbId: " + dbId + " changed from " + (String)this.dbIdToName.get(dbId) + " to " + name);
                }
                this.dbIdToName.put(dbId, name);
            }
            if (ln instanceof MapLN) {
                DatabaseImpl db = ((MapLN)ln).getDatabase();
                dbId = new Integer(db.getId().getId());
                Boolean dupSort = db.getSortedDuplicates();
                if (this.dbIdToDupSort.containsKey(dbId)) {
                    throw new DatabaseException("Already saw dupSort entry for dbId: " + dbId);
                }
                this.dbIdToDupSort.put(dbId, dupSort);
            }
        }
    }

    private void scavenge(long lastUsedLsn, long nextAvailableLsn) throws IOException, DatabaseException {
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processRegularEntry(entry, entryType);
            }
        };
        scavengerReader.setTargetType(LogEntryType.LOG_LN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_LN);
        scavengerReader.setTargetType(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_DEL_DUPLN);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_COMMIT);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_ABORT);
        scavengerReader.setDumpCorruptedBounds(this.dumpCorruptedBounds);
        while (scavengerReader.readNextEntry()) {
        }
    }

    private void processRegularEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, true);
        if (processThisEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            Integer dbId = new Integer(lnEntry.getDbId().getId());
            PrintStream out = this.getOutputStream(dbId);
            LN ln = lnEntry.getLN();
            byte[] keyData = lnEntry.getKey().getKey();
            byte[] data = ln.getData();
            if (data != null && data.length > 0) {
                this.dumpOne(out, keyData, this.formatUsingPrintable);
                this.dumpOne(out, data, this.formatUsingPrintable);
            }
        }
    }

    private PrintStream getOutputStream(Integer dbId) throws DatabaseException {
        try {
            PrintStream ret = (PrintStream)this.dbIdToOutputStream.get(dbId);
            if (ret != null) {
                return ret;
            }
            String name = (String)this.dbIdToName.get(dbId);
            if (name == null) {
                name = "db" + dbId;
            }
            File file = new File(this.envHome, name + ".dump");
            ret = new PrintStream(new FileOutputStream(file));
            this.dbIdToOutputStream.put(dbId, ret);
            Boolean dupSort = (Boolean)this.dbIdToDupSort.get(dbId);
            if (dupSort == null) {
                dupSort = false;
            }
            this.printHeader(ret, dupSort, this.formatUsingPrintable);
            return ret;
        }
        catch (IOException IOE) {
            throw new DatabaseException(IOE);
        }
    }
}

