/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;

public class Tracer
implements LoggableObject,
LogReadable {
    public static final String INFO_FILES = "je.info";
    private Timestamp time;
    private String msg;

    public Tracer(String msg) {
        this.time = this.getCurrentTimestamp();
        this.msg = msg;
    }

    public Tracer() {
    }

    public static void trace(Level logLevel, EnvironmentImpl envImpl, String msg) {
        envImpl.getLogger().log(logLevel, msg);
    }

    public static void trace(EnvironmentImpl envImpl, String sourceClass, String sourceMethod, String msg, Throwable t) {
        envImpl.getLogger().logp(Level.SEVERE, sourceClass, sourceMethod, msg + "\n" + Tracer.getStackTrace(t));
    }

    public static Level parseLevel(EnvironmentImpl envImpl, ConfigParam configParam) throws DatabaseException {
        Level level = null;
        try {
            String levelVal = envImpl.getConfigManager().get(configParam);
            level = Level.parse(levelVal);
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException("Problem parsing parameter " + configParam.getName() + ": " + e.getMessage(), e);
        }
        return level;
    }

    public String getMessage() {
        return this.msg;
    }

    private Timestamp getCurrentTimestamp() {
        Calendar cal = Calendar.getInstance();
        return new Timestamp(cal.getTime().getTime());
    }

    public static String getStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        String stackTrace = s.toString();
        stackTrace = stackTrace.replaceAll("<", "&lt;");
        stackTrace = stackTrace.replaceAll(">", "&gt;");
        return stackTrace;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_TRACE;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        return LogUtils.getTimestampLogSize() + LogUtils.getStringLogSize(this.msg);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeString(logBuffer, this.msg);
    }

    public void readFromLog(ByteBuffer itemBuffer) {
        this.time = LogUtils.readTimestamp(itemBuffer);
        this.msg = LogUtils.readString(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<Dbg time=\"");
        sb.append(this.time);
        sb.append("\">");
        sb.append("<msg val=\"");
        sb.append(this.msg);
        sb.append("\"/>");
        sb.append("</Dbg>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public String toString() {
        return this.time + "/" + this.msg;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tracer)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

