/*
 * Decompiled with CFR 0.152.
 */
package rice;

public interface Continuation {
    public void receiveResult(Object var1);

    public void receiveException(Exception var1);

    public static class NamedContinuation
    implements Continuation {
        protected Continuation parent;
        protected String name;

        public NamedContinuation(String name, Continuation command) {
            this.name = name;
            this.parent = command;
        }

        public void receiveResult(Object result) {
            this.parent.receiveResult(result);
        }

        public void receiveException(Exception result) {
            this.parent.receiveException(result);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MultiContinuation {
        protected Object[] result;
        protected boolean[] haveResult;
        protected Continuation parent;
        protected boolean done;

        public MultiContinuation(Continuation parent, int num) {
            this.parent = parent;
            this.result = new Object[num];
            this.haveResult = new boolean[num];
            this.done = false;
        }

        public Continuation getSubContinuation(int index) {
            return new Continuation(this, index){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ MultiContinuation this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                }

                public void receiveResult(Object o) {
                    this.this$0.receive(this.val$index, o);
                }

                public void receiveException(Exception e) {
                    this.this$0.receive(this.val$index, e);
                }
            };
        }

        public boolean isDone() throws Exception {
            for (int i = 0; i < this.haveResult.length; ++i) {
                if (this.haveResult[i]) continue;
                return false;
            }
            return true;
        }

        public Object getResult() {
            return this.result;
        }

        protected void receive(int index, Object o) {
            if (!this.done && !this.haveResult[index]) {
                this.haveResult[index] = true;
                this.result[index] = o;
                try {
                    if (this.isDone()) {
                        this.done = true;
                        this.parent.receiveResult(this.getResult());
                    }
                }
                catch (Exception e) {
                    this.done = true;
                    this.parent.receiveException(e);
                }
            }
        }
    }

    public static class ExternalContinuation
    implements Continuation {
        protected Exception exception;
        protected Object result;
        protected boolean done = false;

        public Object getResult() {
            if (this.exception != null) {
                throw new IllegalArgumentException("Exception was thrown in ExternalContinuation, but getResult() called!");
            }
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }

        public synchronized void receiveResult(Object o) {
            this.result = o;
            this.done = true;
            this.notify();
        }

        public synchronized void receiveException(Exception e) {
            this.exception = e;
            this.done = true;
            this.notify();
        }

        public synchronized void sleep() {
            try {
                if (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.exception = e;
            }
        }

        public boolean exceptionThrown() {
            return this.exception != null;
        }
    }

    public static abstract class SimpleContinuation
    implements Continuation {
        public void receiveException(Exception result) {
            this.receiveResult(result);
        }
    }

    public static class ListenerContinuation
    implements Continuation {
        protected String name;

        public ListenerContinuation(String name) {
            this.name = name;
        }

        public void receiveResult(Object result) {
        }

        public void receiveException(Exception result) {
            System.out.println("ERROR - Received exception " + result + " during task " + this.name);
            result.printStackTrace();
        }
    }

    public static abstract class ErrorContinuation
    implements Continuation {
        protected Continuation parent;

        public ErrorContinuation(Continuation continuation) {
            this.parent = continuation;
        }

        public void receiveResult(Object result) {
            this.parent.receiveResult(result);
        }
    }

    public static abstract class StandardContinuation
    implements Continuation {
        protected Continuation parent;

        public StandardContinuation(Continuation continuation) {
            this.parent = continuation;
        }

        public void receiveException(Exception result) {
            this.parent.receiveException(result);
        }
    }
}

