/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import rice.p2p.aggregation.ObjectDescriptor;
import rice.p2p.commonapi.Id;

class AggregateDescriptor {
    public Id key;
    public long currentLifetime;
    public ObjectDescriptor[] objects;
    public Id[] pointers;
    public boolean marker;
    public int referenceCount;

    public AggregateDescriptor(Id key, long currentLifetime, ObjectDescriptor[] objects, Id[] pointers) {
        this.key = key;
        this.currentLifetime = currentLifetime;
        this.objects = objects;
        this.pointers = pointers;
        this.marker = false;
        this.referenceCount = 0;
    }

    public int lookupNewest(Id id) {
        int result = -1;
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.objects[i].key.equals(id) || result != -1 && this.objects[i].version <= this.objects[result].version) continue;
            result = i;
        }
        return result;
    }

    public int lookupSpecific(Id id, long version) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.objects[i].key.equals(id) || this.objects[i].version != version) continue;
            return i;
        }
        return -1;
    }

    public void addReference() {
        ++this.referenceCount;
    }

    public int objectsAliveAt(long pointInTime) {
        int result = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.objects[i].isAliveAt(pointInTime)) continue;
            ++result;
        }
        return result;
    }

    public int bytesAliveAt(long pointInTime) {
        int result = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.objects[i].isAliveAt(pointInTime)) continue;
            result += this.objects[i].size;
        }
        return result;
    }
}

