/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.p2p.aggregation.Aggregate;
import rice.p2p.aggregation.AggregateDescriptor;
import rice.p2p.aggregation.AggregateList;
import rice.p2p.aggregation.Aggregation;
import rice.p2p.aggregation.AggregationDefaultPolicy;
import rice.p2p.aggregation.AggregationException;
import rice.p2p.aggregation.AggregationImpl;
import rice.p2p.aggregation.AggregationPolicy;
import rice.p2p.aggregation.AggregationStatistics;
import rice.p2p.aggregation.ObjectDescriptor;
import rice.p2p.aggregation.messaging.AggregationMessage;
import rice.p2p.aggregation.messaging.AggregationTimeoutMessage;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.glacier.v2.DebugContent;
import rice.p2p.glacier.v2.GlacierContentHandle;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastImpl;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.util.DebugCommandHandler;
import rice.persistence.StorageManager;

public class AggregationImpl
implements Past,
GCPast,
VersioningPast,
Aggregation,
Application,
DebugCommandHandler {
    protected final Past aggregateStore;
    protected final StorageManager waitingList;
    protected final AggregationPolicy policy;
    protected final AggregateList aggregateList;
    protected final Endpoint endpoint;
    protected final Past objectStore;
    protected final String instance;
    protected final IdFactory factory;
    protected final String debugID;
    protected final Random random;
    protected final Node node;
    private final char tiFlush = '\u0001';
    private final char tiMonitor = (char)2;
    private final char tiConsolidate = (char)3;
    private final char tiStatistics = (char)4;
    private final char tiExpire = (char)5;
    protected Hashtable timers;
    protected Continuation flushWait;
    protected boolean rebuildInProgress;
    protected Vector monitorIDs;
    protected AggregationStatistics stats;
    private int loglevel = 2;
    private final boolean logStatistics = true;
    private final double jitterRange = 0.1;
    public static final boolean verbose = false;
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static final long WEEKS = 604800000L;
    private static final long flushDelayAfterJoin = 30000L;
    private static final long flushStressInterval = 300000L;
    private static long flushInterval = 300000L;
    private static int maxAggregateSize = 0x100000;
    private static int maxObjectsInAggregate = 25;
    private static int maxAggregatesPerRun = 2;
    private static final boolean addMissingAfterRefresh = true;
    private static final int maxReaggregationPerRefresh = 100;
    private static final int nominalReferenceCount = 2;
    private static final int maxPointersPerAggregate = 100;
    private static final long pointerArrayLifetime = 1209600000L;
    private static final long aggregateGracePeriod = 86400000L;
    private static final long aggrRefreshInterval = 900000L;
    private static final long aggrRefreshDelayAfterJoin = 70000L;
    private static long expirationRenewThreshold = 259200000L;
    private static final boolean monitorEnabled = false;
    private static final long monitorRefreshInterval = 900000L;
    private static final long consolidationDelayAfterJoin = 300000L;
    private static long consolidationInterval = 900000L;
    private static long consolidationThreshold = 1209600000L;
    private static int consolidationMinObjectsInAggregate = 20;
    private static double consolidationMinComponentsAlive = 0.8;
    private static int reconstructionMaxConcurrentLookups = 10;
    private static final boolean aggregateLogEnabled = true;
    private static final long statsGranularity = 3600000L;
    private static final long statsRange = 1814400000L;
    private static final long statsInterval = 60000L;

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance) throws IOException {
        this(node, aggregateStore, objectStore, waitingList, configFileName, factory, instance, AggregationImpl.getDefaultPolicy());
    }

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance, AggregationPolicy policy) throws IOException {
        this.endpoint = node.registerApplication(this, instance);
        this.waitingList = waitingList;
        this.instance = instance;
        this.aggregateStore = aggregateStore;
        this.objectStore = objectStore;
        this.node = node;
        this.timers = new Hashtable();
        this.random = new Random();
        this.aggregateList = new AggregateList(configFileName, this.getLocalNodeHandle().getId().toString(), factory, true);
        this.stats = this.aggregateList.getStatistics(3600000L, 1814400000L, 2);
        this.policy = policy;
        this.factory = factory;
        this.flushWait = null;
        this.rebuildInProgress = false;
        this.monitorIDs = new Vector();
        this.debugID = "A" + Character.toUpperCase(instance.charAt(instance.lastIndexOf(45) + 1));
        if (!this.aggregateList.readOK()) {
            this.warn("Failed to read configuration file; aggregate list must be rebuilt!");
        } else {
            this.log(2, "Aggregate list read OK -- current root: " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
        }
        this.removeDeadAggregates();
        this.addTimer(this.jitterTerm(30000L), '\u0001');
        this.addTimer(this.jitterTerm(70000L), '\u0005');
        this.addTimer(this.jitterTerm(300000L), '\u0003');
        this.addTimer(60000L, '\u0004');
    }

    private String getLogPrefix() {
        return "COUNT: " + System.currentTimeMillis() + " " + this.debugID;
    }

    private int getSize(PastContent obj) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(obj);
            objectStream.flush();
            return byteStream.toByteArray().length;
        }
        catch (IOException ioe) {
            this.warn("Cannot serialize object, size unknown: " + ioe);
            return 0;
        }
    }

    public Serializable getHandle() {
        return this.aggregateList.getRoot();
    }

    public NodeHandle getLocalNodeHandle() {
        return this.objectStore.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.objectStore.getReplicationFactor();
    }

    public Past getAggregateStore() {
        return this.aggregateStore;
    }

    public Past getObjectStore() {
        return this.objectStore;
    }

    public int getNumObjectsWaiting() {
        return this.waitingList.scan().numElements();
    }

    public AggregationStatistics getStatistics() {
        return this.stats;
    }

    public void setHandle(Serializable handle, Continuation command) {
        this.log(2, "setHandle(" + handle + ")");
        if (!(handle instanceof Id)) {
            command.receiveException(new AggregationException("Illegal handle"));
            return;
        }
        if (this.aggregateList.getADC((Id)handle) != null) {
            this.log(2, "Rebuild: Handle " + handle + " is already covered by current root");
            command.receiveResult(new Boolean(true));
        }
        this.aggregateList.setRoot((Id)handle);
        this.rebuildAggregateList(command);
    }

    public void setFlushInterval(int flushIntervalSec) {
        flushInterval = (long)flushIntervalSec * 1000L;
    }

    public void setMaxAggregateSize(int maxAggregateSize) {
        AggregationImpl.maxAggregateSize = maxAggregateSize;
    }

    public void setMaxObjectsInAggregate(int maxObjectsInAggregate) {
        AggregationImpl.maxObjectsInAggregate = maxObjectsInAggregate;
    }

    public void setRenewThreshold(int expirationRenewThresholdHrs) {
        expirationRenewThreshold = (long)expirationRenewThresholdHrs * 3600000L;
    }

    public void setConsolidationInterval(long consolidationIntervalSec) {
        consolidationInterval = consolidationIntervalSec * 1000L;
    }

    public void setConsolidationThreshold(long consolidationThresholdSec) {
        consolidationThreshold = consolidationThresholdSec * 1000L;
    }

    public void setConsolidationMinObjectsPerAggregate(int minObjectsInAggregateArg) {
        consolidationMinObjectsInAggregate = minObjectsInAggregateArg;
    }

    public void setConsolidationMinUtilization(double minUtilization) {
        consolidationMinComponentsAlive = minUtilization;
    }

    public void setLogLevel(int newLevel) {
        this.loglevel = newLevel;
    }

    private long jitterTerm(long basis) {
        return (long)(0.9 * (double)basis) + (long)this.random.nextInt((int)(0.2 * (double)basis));
    }

    private void log(int level, String str) {
        if (level <= this.loglevel) {
            // empty if block
        }
    }

    private void warn(String str) {
    }

    private void addTimer(long timeoutMsec, char timeoutID) {
        CancellableTask timer = this.endpoint.scheduleMessage(new AggregationTimeoutMessage(timeoutID, this.getLocalNodeHandle()), timeoutMsec);
        this.timers.put(new Integer(timeoutID), timer);
    }

    private void removeTimer(int timeoutID) {
        CancellableTask timer = (CancellableTask)this.timers.remove(new Integer(timeoutID));
        if (timer != null) {
            timer.cancel();
        }
    }

    private void panic(String s) throws Error {
        System.err.println("PANIC: " + s);
        throw new Error("Panic");
    }

    public String handleDebugCommand(String command) {
        if (command.indexOf(" ") < 0) {
            return null;
        }
        String requestedInstance = command.substring(0, command.indexOf(" "));
        String myInstance = "aggr." + this.instance.substring(this.instance.lastIndexOf("-") + 1);
        String cmd = command.substring(requestedInstance.length() + 1);
        if (!requestedInstance.equals(myInstance) && !requestedInstance.equals("a")) {
            String subResult = null;
            if (subResult == null && this.aggregateStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.aggregateStore)).handleDebugCommand(command);
            }
            if (subResult == null && this.objectStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.objectStore)).handleDebugCommand(command);
            }
            return subResult;
        }
        this.log(2, "Debug command: " + cmd);
        if (cmd.startsWith("status")) {
            return this.stats.numObjectsTotal + " objects total\n" + this.stats.numObjectsAlive + " objects alive\n" + this.stats.numAggregatesTotal + " aggregates total\n" + this.stats.numPointerArrays + " pointer arrays\n" + this.stats.criticalAggregates + " critical aggregates\n" + this.stats.orphanedAggregates + " orphaned aggregates\n";
        }
        if (cmd.startsWith("insert")) {
            int numObjects = Integer.parseInt(cmd.substring(7));
            String result = "";
            for (int i = 0; i < numObjects; ++i) {
                Id randomID = this.factory.buildRandomId(new Random());
                result = result + randomID.toStringFull() + "\n";
                this.insert(new DebugContent(randomID, false, 0L, new byte[0]), System.currentTimeMillis() + 120000L, new Continuation(){

                    public void receiveResult(Object o) {
                    }

                    public void receiveException(Exception e) {
                    }
                });
            }
            return result + numObjects + " object(s) created\n";
        }
        if (cmd.startsWith("set loglevel")) {
            this.loglevel = Integer.parseInt(cmd.substring(13));
            return "Log level set to " + this.loglevel;
        }
        if (cmd.startsWith("show config")) {
            return "flushDelayAfterJoin = 30 sec\nflushInterval = " + (int)(flushInterval / 1000L) + " sec\n" + "maxAggregateSize = " + maxAggregateSize + " bytes\n" + "maxObjectsInAggregate = " + maxObjectsInAggregate + " objects\n" + "maxAggregatesPerRun = " + maxAggregatesPerRun + " aggregates\n" + "addMissingAfterRefresh = " + true + "\n" + "nominalReferenceCount = " + 2 + "\n" + "maxPointersPerAggregate = " + 100 + "\n" + "pointerArrayLifetime = " + 14 + " days\n" + "aggrRefreshInterval = " + 900 + " sec\n" + "aggrRefreshDelayAfterJoin = " + 70 + " sec\n" + "expirationRenewThreshold = " + (int)(expirationRenewThreshold / 3600000L) + " hrs\n" + "consolidationDelayAfterJoin = " + 300 + " sec\n" + "consolidationInterval = " + (int)(consolidationInterval / 1000L) + " sec\n" + "consolidationThreshold = " + (int)(consolidationThreshold / 3600000L) + " hrs\n" + "consolidationMinObjectsInAggregate = " + consolidationMinObjectsInAggregate + "\n" + "consolidationMinComponentsAlive = " + consolidationMinComponentsAlive + "\n";
        }
        if (cmd.startsWith("ls")) {
            Enumeration enumeration = this.aggregateList.elements();
            StringBuffer result = new StringBuffer();
            int numAggr = 0;
            int numObj = 0;
            long now = System.currentTimeMillis();
            if (cmd.indexOf("-r") < 0) {
                now = 0L;
            }
            this.aggregateList.recalculateReferenceCounts(null);
            this.aggregateList.resetMarkers();
            while (enumeration.hasMoreElements()) {
                int i;
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                result.append("***" + aggr.key.toStringFull() + " (" + aggr.objects.length + " obj, " + aggr.pointers.length + " ptr, " + aggr.referenceCount + " ref, exp=" + (aggr.currentLifetime - now) + ")\n");
                for (i = 0; i < aggr.objects.length; ++i) {
                    result.append("    #" + i + " " + aggr.objects[i].key.toStringFull() + "v" + aggr.objects[i].version + ", lt=" + (aggr.objects[i].currentLifetime - now) + ", rt=" + (aggr.objects[i].refreshedLifetime - now) + ", size=" + aggr.objects[i].size + " bytes\n");
                }
                for (i = 0; i < aggr.pointers.length; ++i) {
                    result.append("    Ref " + aggr.pointers[i].toStringFull() + "\n");
                }
                result.append("\n");
                aggr.marker = true;
                ++numAggr;
                numObj += aggr.objects.length;
            }
            result.append(numAggr + " aggregate(s), " + numObj + " object(s)");
            return result.toString();
        }
        if (cmd.startsWith("write list")) {
            this.aggregateList.writeToDisk();
            return "Done, new root is " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.length() >= 5 && cmd.substring(0, 5).equals("reset")) {
            final String[] ret = new String[]{null};
            this.reset(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("flush")) {
            final String[] ret = new String[]{null};
            this.flush(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("get root")) {
            return "root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.startsWith("set root")) {
            final String[] ret = new String[]{null};
            this.setHandle(this.factory.buildIdFromToString(cmd.substring(9)), new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("lookup")) {
            Id id = this.factory.buildIdFromToString(cmd.substring(7));
            final String[] ret = new String[]{null};
            this.lookup(id, false, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "lookup(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("handles")) {
            String args = cmd.substring(8);
            Id id = this.factory.buildIdFromToString(args.substring(args.indexOf(32) + 1));
            int max = Integer.parseInt(args.substring(0, args.indexOf(32)));
            final String[] ret = new String[]{null};
            this.lookupHandles(id, max, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof PastContentHandle[]) {
                        PastContentHandle[] oA = (PastContentHandle[])o;
                        ret[0] = "";
                        for (int i = 0; i < oA.length; ++i) {
                            ret[0] = ret[0] + "#" + i + " " + oA[i] + "\n";
                        }
                        ret[0] = ret[0] + oA.length + " handle(s) returned\n";
                    } else {
                        ret[0] = "result(" + o + ") -- no handles returned!";
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "Handles(" + max + "," + id + "):\n" + ret[0];
        }
        if (cmd.startsWith("refresh all")) {
            String result;
            int i;
            long expiration = System.currentTimeMillis() + Long.parseLong(cmd.substring(12));
            TreeSet<Id> ids = new TreeSet<Id>();
            this.aggregateList.resetMarkers();
            Enumeration enumeration = this.aggregateList.elements();
            while (enumeration.hasMoreElements()) {
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                aggr.marker = true;
                for (i = 0; i < aggr.objects.length; ++i) {
                    ids.add(aggr.objects[i].key);
                }
            }
            if (!ids.isEmpty()) {
                Id[] allIds = ids.toArray(new Id[0]);
                result = "Refreshing " + allIds.length + " keys...\n";
                for (i = 0; i < allIds.length; ++i) {
                    result = result + "#" + i + " " + allIds[i].toStringFull() + "\n";
                }
                final String[] ret = new String[]{null};
                this.refresh(allIds, expiration, new Continuation(){

                    public void receiveResult(Object o) {
                        ret[0] = "result(" + o + ")";
                    }

                    public void receiveException(Exception e) {
                        ret[0] = "exception(" + e + ")";
                    }
                });
                while (ret[0] == null) {
                    Thread.currentThread();
                    Thread.yield();
                }
                result = result + ret[0];
            } else {
                result = "Aggregate list is empty; nothing to refresh!";
            }
            return result;
        }
        if (cmd.startsWith("refresh")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = System.currentTimeMillis() + Long.parseLong(expirationArg);
            final String[] ret = new String[]{null};
            this.refresh(new Id[]{id}, expiration, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "refresh(" + id + ", " + expiration + ")=" + ret[0];
        }
        if (cmd.startsWith("monitor remove")) {
            // empty if block
        }
        if (cmd.startsWith("monitor status")) {
            // empty if block
        }
        if (cmd.startsWith("monitor ls")) {
            // empty if block
        }
        if (cmd.startsWith("monitor check")) {
            // empty if block
        }
        if (cmd.startsWith("monitor add")) {
            // empty if block
        }
        if (cmd.startsWith("killall")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = System.currentTimeMillis() + Long.parseLong(expirationArg);
            AggregateDescriptor aggr = this.aggregateList.getADC(id);
            if (aggr != null) {
                this.aggregateList.setAggregateLifetime(aggr, Math.min(aggr.currentLifetime, expiration));
                for (int i = 0; i < aggr.objects.length; ++i) {
                    this.aggregateList.setObjectCurrentLifetime(aggr, i, Math.min(aggr.objects[i].currentLifetime, expiration));
                    this.aggregateList.setObjectRefreshedLifetime(aggr, i, Math.min(aggr.objects[i].refreshedLifetime, expiration));
                }
                return "OK";
            }
            return "Aggregate " + id + " not found in aggregate list";
        }
        if (cmd.startsWith("waiting")) {
            Iterator iter = this.waitingList.scan().getIterator();
            String result = "";
            result = result + this.waitingList.scan().numElements() + " object(s) waiting\n";
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                result = result + thisId.toStringFull() + " " + this.waitingList.getMetadata(thisId) + "\n";
            }
            return result;
        }
        if (cmd.startsWith("vlookup")) {
            String[] vkeyS = cmd.substring(8).split("v");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            final String[] ret = new String[]{null};
            this.lookup(key, version, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "vlookup(" + key + "v" + version + ")=" + ret[0];
        }
        return null;
    }

    private void removeDeadAggregates() {
        Vector<AggregateDescriptor> toRemove = new Vector<AggregateDescriptor>();
        Enumeration enumeration = this.aggregateList.elements();
        long now = System.currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor adc = (AggregateDescriptor)enumeration.nextElement();
            if (adc.currentLifetime >= now - 86400000L) continue;
            if (!toRemove.contains(adc)) {
                toRemove.add(adc);
            }
            this.warn("Scheduling dead aggregate for removal: " + adc.key.toStringFull() + "(expired " + adc.currentLifetime + ")");
        }
        if (toRemove.size() > 0) {
            this.log(2, "Removing " + toRemove.size() + " dead aggregates...");
            Enumeration rem = toRemove.elements();
            while (rem.hasMoreElements()) {
                this.aggregateList.removeAggregateDescriptor((AggregateDescriptor)rem.nextElement());
            }
        }
    }

    private void storeAggregate(final Aggregate aggr, final long expiration, final ObjectDescriptor[] desc, final Id[] pointers, final Continuation command) {
        this.log(3, "storeAggregate() schedules content hash computation...");
        this.endpoint.process(new Executable(){

            public Object execute() {
                AggregationImpl.this.log(3, "storeAggregate() starts working on content hash...");
                return AggregationImpl.this.factory.buildId(aggr.getContentHash());
            }
        }, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Id) {
                    aggr.setId((Id)o);
                    AggregationImpl.this.log(2, "Storing aggregate, CH=" + aggr.getId() + ", expiration=" + expiration + " (rel " + (expiration - System.currentTimeMillis()) + ") with " + desc.length + " objects:");
                    for (int j = 0; j < desc.length; ++j) {
                        AggregationImpl.this.log(2, "#" + j + ": " + desc[j]);
                    }
                    Continuation c = new Continuation(this){
                        private final /* synthetic */ 14 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void receiveResult(Object o) {
                            AggregateDescriptor adc = new AggregateDescriptor(14.access$800(this.this$1).getId(), 14.access$900(this.this$1), 14.access$1000(this.this$1), 14.access$1100(this.this$1));
                            if (o instanceof Boolean[]) {
                                14.access$1200(this.this$1).aggregateList.addAggregateDescriptor(adc);
                                14.access$1200(this.this$1).aggregateList.setRoot(14.access$800(this.this$1).getId());
                                14.access$1200(this.this$1).aggregateList.writeToDisk();
                                AggregationImpl.access$000(14.access$1200(this.this$1), 3, "Aggregate inserted successfully");
                                14.access$1300(this.this$1).receiveResult(new Boolean(true));
                            } else {
                                AggregationImpl.access$100(14.access$1200(this.this$1), "Unexpected result in aggregate insert (commit): " + o);
                                14.access$1300(this.this$1).receiveException(new AggregationException("Unexpected result (commit): " + o));
                            }
                        }

                        public void receiveException(Exception e) {
                            14.access$1300(this.this$1).receiveException(e);
                        }
                    };
                    if (AggregationImpl.this.aggregateStore instanceof GCPast) {
                        ((GCPast)AggregationImpl.this.aggregateStore).insert(aggr, expiration, c);
                    } else {
                        AggregationImpl.this.aggregateStore.insert(aggr, c);
                    }
                } else {
                    AggregationImpl.this.warn("storeAggregate() cannot determine content hash, received " + o);
                    command.receiveException(new AggregationException("storeAggregate() cannot determine content hash"));
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("storeAggregate() cannot determine content hash, exception " + e);
                e.printStackTrace();
                command.receiveException(e);
            }

            static /* synthetic */ Aggregate access$800(14 x0) {
                return x0.aggr;
            }

            static /* synthetic */ long access$900(14 x0) {
                return x0.expiration;
            }

            static /* synthetic */ ObjectDescriptor[] access$1000(14 x0) {
                return x0.desc;
            }

            static /* synthetic */ Id[] access$1100(14 x0) {
                return x0.pointers;
            }

            static /* synthetic */ AggregationImpl access$1200(14 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Continuation access$1300(14 x0) {
                return x0.command;
            }
        });
    }

    private void flushComplete(Object o) {
        if (this.flushWait != null) {
            Continuation c = this.flushWait;
            this.flushWait = null;
            if (o instanceof Exception) {
                c.receiveException((Exception)o);
            } else {
                c.receiveResult(o);
            }
        }
    }

    private void formAggregates(final Continuation command) {
        ObjectDescriptor[] desc;
        if (this.flushWait != null) {
            this.log(2, "Flush in progress... daisy-chaining continuation");
            final Continuation parent = this.flushWait;
            this.flushWait = new Continuation(){

                public void receiveResult(Object o) {
                    AggregationImpl.this.log(2, "Daisy-chain receiveResult(), restarting " + command);
                    parent.receiveResult(o);
                    AggregationImpl.this.formAggregates(command);
                }

                public void receiveException(Exception e) {
                    AggregationImpl.this.log(2, "Daisy-chain receiveException(), restarting " + command);
                    parent.receiveException(e);
                    AggregationImpl.this.formAggregates(command);
                }
            };
            return;
        }
        this.flushWait = command;
        IdSet waitingKeys = this.waitingList.scan();
        if (waitingKeys.numElements() == 0) {
            this.log(2, "NO BINS TO PACK");
            this.flushComplete(new Boolean(true));
            return;
        }
        this.log(2, "BIN PACKING STARTED");
        Vector<ObjectDescriptor> currentAggregate = new Vector<ObjectDescriptor>();
        Vector<ObjectDescriptor[]> aggregates = new Vector<ObjectDescriptor[]>();
        Vector<Id> deletionVector = new Vector<Id>();
        Iterator iter = waitingKeys.getIterator();
        long currentAggregateSize = 0L;
        int currentObjectsInAggregate = 0;
        while (true) {
            int numObjectsInAggregate;
            ObjectDescriptor thisObject = null;
            boolean mustAddObject = false;
            if (aggregates.size() >= maxAggregatesPerRun) break;
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                thisObject = (ObjectDescriptor)this.waitingList.getMetadata(thisId);
                if (thisObject != null) {
                    thisObject = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, thisObject.refreshedLifetime, thisObject.size);
                    if ((currentAggregateSize + (long)thisObject.size <= (long)maxAggregateSize || currentAggregate.isEmpty()) && currentObjectsInAggregate < maxObjectsInAggregate) {
                        currentAggregateSize += (long)thisObject.size;
                        ++currentObjectsInAggregate;
                        currentAggregate.add(thisObject);
                        continue;
                    }
                    mustAddObject = true;
                    break;
                }
                this.warn("Metadata in waiting object " + thisId.toStringFull() + " appears to be damaged. Scheduling for deletion...");
                deletionVector.add(thisId);
            }
            if ((numObjectsInAggregate = currentAggregate.size()) < 1) {
                this.warn("Waiting list seems to consist entirely of damaged objects -- please remove!");
                this.flushComplete(new Boolean(true));
                return;
            }
            desc = new ObjectDescriptor[numObjectsInAggregate];
            for (int i = 0; i < numObjectsInAggregate; ++i) {
                desc[i] = (ObjectDescriptor)currentAggregate.elementAt(i);
                this.log(3, "#" + i + ": " + desc[i].key + " " + desc[i].size + " bytes");
            }
            aggregates.add(desc);
            currentAggregate.clear();
            currentObjectsInAggregate = 0;
            currentAggregateSize = 0L;
            if (mustAddObject) {
                currentAggregate.add(thisObject);
                currentAggregateSize += (long)thisObject.size;
                continue;
            }
            if (!iter.hasNext()) break;
        }
        Enumeration delenda = deletionVector.elements();
        while (delenda.hasMoreElements()) {
            final Id thisId = (Id)delenda.nextElement();
            this.log(2, "Deleting object " + thisId.toStringFull() + " from waiting list (broken metadata)");
            this.waitingList.unstore(thisId, new Continuation(){

                public void receiveResult(Object o) {
                    AggregationImpl.this.log(3, "Successfully deleted: " + thisId);
                }

                public void receiveException(Exception e) {
                    AggregationImpl.this.warn("Cannot delete: " + thisId + ", e=" + e);
                    e.printStackTrace();
                }
            });
        }
        Continuation.MultiContinuation c = new Continuation.MultiContinuation(new Continuation(){

            public void receiveResult(Object o) {
                AggregationImpl.this.flushComplete(new Boolean(true));
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.flushComplete(e);
            }
        }, aggregates.size());
        for (int i = 0; i < aggregates.size(); ++i) {
            desc = (ObjectDescriptor[])aggregates.elementAt(i);
            final GCPastContent[] obj = new GCPastContent[desc.length];
            final long aggrExpirationF = this.chooseAggregateLifetime(desc, System.currentTimeMillis(), 0L);
            final Continuation thisContinuation = c.getSubContinuation(i);
            final int iF = i;
            this.log(3, "Retrieving #" + i + ".0: " + desc[0].key);
            this.waitingList.getObject(new VersionKey(desc[0].key, desc[0].version), new Continuation(){
                int currentQuery = 0;

                public void receiveResult(Object o) {
                    if (o != null && o instanceof GCPastContent) {
                        obj[this.currentQuery++] = (GCPastContent)o;
                        if (this.currentQuery < desc.length) {
                            AggregationImpl.this.log(3, "Retrieving #" + iF + "." + this.currentQuery + ": " + desc[this.currentQuery].key);
                            AggregationImpl.this.waitingList.getObject(new VersionKey(desc[this.currentQuery].key, desc[this.currentQuery].version), this);
                        } else {
                            Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(2, 100, null);
                            AggregationImpl.this.storeAggregate(new Aggregate(obj, pointers), aggrExpirationF, desc, pointers, new Continuation(this){
                                private final /* synthetic */ 19 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void receiveResult(Object o) {
                                    Continuation.MultiContinuation c2 = new Continuation.MultiContinuation(19.access$1600(this.this$1), 19.access$1700(this.this$1).length);
                                    for (int i = 0; i < 19.access$1700(this.this$1).length; ++i) {
                                        Continuation c2s = c2.getSubContinuation(i);
                                        19.access$1900(this.this$1).waitingList.unstore(new VersionKey(19.access$1700(this.this$1)[i].key, 19.access$1700(this.this$1)[i].version), new Continuation(this, c2s){
                                            private final /* synthetic */ Continuation val$c2s;
                                            private final /* synthetic */ 20 this$2;
                                            {
                                                this.this$2 = this$2;
                                                this.val$c2s = val$c2s;
                                            }

                                            public void receiveResult(Object o) {
                                                this.val$c2s.receiveResult(o);
                                            }

                                            public void receiveException(Exception e) {
                                                AggregationImpl.access$100(19.access$1900(20.access$1800(this.this$2)), "Exception while unstoring aggregate component: " + e);
                                                e.printStackTrace();
                                                this.val$c2s.receiveException(e);
                                            }
                                        });
                                    }
                                }

                                public void receiveException(Exception e) {
                                    AggregationImpl.access$100(19.access$1900(this.this$1), "Exception while storing new aggregate: " + e);
                                    e.printStackTrace();
                                    19.access$1600(this.this$1).receiveException(e);
                                }

                                static /* synthetic */ 19 access$1800(20 x0) {
                                    return x0.this$1;
                                }
                            });
                        }
                    } else {
                        AggregationImpl.this.warn("Aggregation cannot retrieve " + desc[this.currentQuery].key + " (found o=" + o + ")");
                        thisContinuation.receiveException(new AggregationException("Cannot retrieve object from waiting list: " + desc[this.currentQuery].key));
                    }
                }

                public void receiveException(Exception e) {
                    AggregationImpl.this.warn("Exception while building aggregate: " + e);
                    thisContinuation.receiveException(e);
                }

                static /* synthetic */ Continuation access$1600(19 x0) {
                    return x0.thisContinuation;
                }

                static /* synthetic */ ObjectDescriptor[] access$1700(19 x0) {
                    return x0.desc;
                }

                static /* synthetic */ AggregationImpl access$1900(19 x0) {
                    return x0.AggregationImpl.this;
                }
            });
        }
    }

    private long chooseAggregateLifetime(ObjectDescriptor[] components, long now, long currentLifetime) {
        long maxLifetime = 0L;
        for (int i = 0; i < components.length; ++i) {
            if (components[i].refreshedLifetime <= maxLifetime) continue;
            maxLifetime = components[i].refreshedLifetime;
        }
        return maxLifetime;
    }

    private void refreshAggregates() {
        Enumeration enumeration = this.aggregateList.elements();
        long now = System.currentTimeMillis();
        Vector<AggregateDescriptor> removeList = new Vector<AggregateDescriptor>();
        final Vector<AggregateDescriptor> refreshAggregateList = new Vector<AggregateDescriptor>();
        final Vector<Long> refreshLifetimeList = new Vector<Long>();
        this.log(2, "Checking aggregate lifetimes");
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            long newLifetime;
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            boolean isBeingRefreshed = false;
            if (aggr.currentLifetime < now + expirationRenewThreshold && (newLifetime = this.chooseAggregateLifetime(aggr.objects, now, aggr.currentLifetime)) > aggr.currentLifetime) {
                this.log(2, "Refreshing aggregate " + aggr.key.toStringFull() + ", new expiration is " + newLifetime);
                isBeingRefreshed = true;
                refreshAggregateList.add(aggr);
                refreshLifetimeList.add(new Long(newLifetime));
            }
            if (aggr.currentLifetime >= now || isBeingRefreshed) continue;
            this.log(3, "Adding expired aggregate " + aggr.key + " to remove list");
            removeList.add(aggr);
        }
        boolean deletedOne = false;
        while (!removeList.isEmpty()) {
            AggregateDescriptor aggr = (AggregateDescriptor)removeList.elementAt(0);
            this.log(2, "Removing expired aggregate " + aggr.key.toStringFull() + " from list");
            removeList.removeElementAt(0);
            deletedOne = true;
            this.aggregateList.removeAggregateDescriptor(aggr);
        }
        if (deletedOne) {
            this.aggregateList.writeToDisk();
        }
        if (!refreshAggregateList.isEmpty()) {
            this.log(2, "Refreshing " + refreshAggregateList.size() + " aggregate(s)");
            if (this.aggregateStore instanceof GCPast) {
                Id[] ids = new Id[refreshAggregateList.size()];
                long[] lifetimes = new long[refreshAggregateList.size()];
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    ids[i] = ((AggregateDescriptor)refreshAggregateList.elementAt((int)i)).key;
                    lifetimes[i] = (Long)refreshLifetimeList.elementAt(i);
                }
                ((GCPast)this.aggregateStore).refresh(ids, lifetimes, new Continuation(){

                    public void receiveResult(Object o) {
                        Object[] results = (Object[])o;
                        AggregationImpl.this.log(3, "Received refresh results for " + results.length + " aggregates");
                        int numOk = 0;
                        for (int i = 0; i < results.length; ++i) {
                            AggregateDescriptor aggr;
                            if (results[i] instanceof Boolean) {
                                aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                                long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                                AggregationImpl.this.log(3, "Aggregate #" + i + " (" + aggr.key.toStringFull() + "): OK, new lifetime is " + newLifetime);
                                AggregationImpl.this.aggregateList.refreshAggregate(aggr, newLifetime);
                                ++numOk;
                                continue;
                            }
                            aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                            Exception e = (Exception)results[i];
                            AggregationImpl.this.warn("Aggregate #" + i + " (" + aggr.key.toStringFull() + "): Refresh failed, e=" + e);
                            e.printStackTrace();
                        }
                        AggregationImpl.this.aggregateList.writeToDisk();
                        AggregationImpl.this.log(2, "Refresh complete, " + numOk + "/" + results.length + " aggregates refreshed OK");
                    }

                    public void receiveException(Exception e) {
                        AggregationImpl.this.warn("Interface contract broken; exception " + e + " returned directly");
                        e.printStackTrace();
                    }
                });
            } else {
                this.log(3, "Aggregate store does not support GC; refreshing directly");
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    AggregateDescriptor aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                    long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                    this.aggregateList.refreshAggregate(aggr, newLifetime);
                }
            }
        }
    }

    private void consolidateAggregates() {
        AggregateDescriptor[] adc;
        final long now = System.currentTimeMillis();
        Enumeration enumeration = this.aggregateList.elements();
        Vector<AggregateDescriptor> candidateList = new Vector<AggregateDescriptor>();
        this.log(2, "Looking for aggregates to consolidate");
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            if (aggr.currentLifetime <= now + expirationRenewThreshold || aggr.currentLifetime >= now + consolidationThreshold || aggr.objectsAliveAt(now) <= 0) continue;
            float fractionAlive = (float)aggr.objectsAliveAt(now) / (float)aggr.objects.length;
            if (aggr.objects.length >= consolidationMinObjectsInAggregate && !((double)fractionAlive < consolidationMinComponentsAlive)) continue;
            this.log(3, "Can consolidate: " + aggr.key.toStringFull() + ", " + aggr.objectsAliveAt(now) + "/" + aggr.objects.length + " alive");
            candidateList.add(aggr);
        }
        if (candidateList.isEmpty()) {
            this.log(2, "No candidates for consolidation");
            return;
        }
        this.log(3, candidateList.size() + " candidate(s) for consolidation");
        final Vector<AggregateDescriptor[]> componentList = new Vector<AggregateDescriptor[]>();
        Random rand = new Random();
        int objectsSoFar = 0;
        int bytesSoFar = 0;
        while (!candidateList.isEmpty()) {
            adc = (AggregateDescriptor[])candidateList.remove(rand.nextInt(candidateList.size()));
            componentList.add(adc);
            this.log(3, "Picked candidate " + adc.key.toStringFull() + " (" + adc.objectsAliveAt(now) + "/" + adc.objects.length + " objects, " + adc.bytesAliveAt(now) + " bytes alive)");
            objectsSoFar += adc.objectsAliveAt(now);
            bytesSoFar += adc.bytesAliveAt(now);
            int p = 0;
            while (p < candidateList.size()) {
                AggregateDescriptor adx = (AggregateDescriptor)candidateList.elementAt(p);
                if (adx.objectsAliveAt(now) + objectsSoFar > maxObjectsInAggregate || adx.bytesAliveAt(now) + bytesSoFar > maxAggregateSize) {
                    candidateList.removeElementAt(p);
                    continue;
                }
                ++p;
            }
        }
        if (componentList.isEmpty() || objectsSoFar < consolidationMinObjectsInAggregate) {
            this.log(2, "Not enough objects (" + objectsSoFar + " found, " + consolidationMinObjectsInAggregate + " required), postponing...");
            return;
        }
        this.log(3, "Consolidation: Decided to consolidate " + objectsSoFar + " objects from " + componentList.size() + " aggregates (" + bytesSoFar + " bytes)");
        adc = componentList.toArray(new AggregateDescriptor[0]);
        final Aggregate[] aggr = new Aggregate[adc.length];
        final int objectsTotal = objectsSoFar;
        Id firstKey = adc[0].key;
        this.log(3, "Consolidation: Fetching aggregate #0: " + firstKey.toStringFull());
        this.aggregateStore.lookup(firstKey, new Continuation(){
            int currentLookup = 0;

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    aggr[this.currentLookup] = (Aggregate)o;
                    ++this.currentLookup;
                    if (this.currentLookup >= componentList.size()) {
                        GCPastContent[] components = new GCPastContent[objectsTotal];
                        ObjectDescriptor[] desc = new ObjectDescriptor[objectsTotal];
                        int componentIndex = 0;
                        AggregationImpl.this.log(2, "Consolidation: All aggregates fetched OK, forming new aggregate...");
                        for (int i = 0; i < adc.length; ++i) {
                            for (int j = 0; j < adc[i].objects.length; ++j) {
                                if (adc[i].objects[j].isAliveAt(now)) {
                                    components[componentIndex] = aggr[i].components[j];
                                    desc[componentIndex] = adc[i].objects[j];
                                    AggregationImpl.this.log(3, "  #" + componentIndex + ": " + adc[i].objects[j].key.toStringFull());
                                    ++componentIndex;
                                    continue;
                                }
                                AggregationImpl.this.log(3, "Skipped (dead): " + adc[i].objects[j].key.toStringFull());
                            }
                        }
                        Id[] obsoleteAggregates = new Id[adc.length];
                        for (int i = 0; i < adc.length; ++i) {
                            obsoleteAggregates[i] = adc[i].key;
                        }
                        Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(2, 100, obsoleteAggregates);
                        long aggrExpirationF = AggregationImpl.this.chooseAggregateLifetime(desc, System.currentTimeMillis(), 0L);
                        AggregationImpl.this.storeAggregate(new Aggregate(components, pointers), aggrExpirationF, desc, pointers, new Continuation(this){
                            private final /* synthetic */ 23 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void receiveResult(Object o) {
                                AggregationImpl.access$000(23.access$2200(this.this$1), 2, "Consolidated Aggregate stored OK, removing old descriptors...");
                                for (int i = 0; i < 23.access$2300(this.this$1).length; ++i) {
                                    AggregationImpl.access$000(23.access$2200(this.this$1), 3, "Removing " + 23.access$2300(this.this$1)[i].key.toStringFull() + " ...");
                                    23.access$2200(this.this$1).aggregateList.removeAggregateDescriptor(23.access$2300(this.this$1)[i]);
                                }
                                23.access$2200(this.this$1).aggregateList.writeToDisk();
                                AggregationImpl.access$000(23.access$2200(this.this$1), 2, "Consolidation completed, " + 23.access$2400(this.this$1) + " objects from " + 23.access$2500(this.this$1).length + " aggregates consolidated");
                            }

                            public void receiveException(Exception e) {
                                AggregationImpl.access$100(23.access$2200(this.this$1), "Exception during consolidation store: e=" + e + " -- aborting");
                                e.printStackTrace();
                            }
                        });
                    } else {
                        AggregationImpl.this.log(3, "Consolidation: Fetching aggregate #" + this.currentLookup + ": " + adc[this.currentLookup].key.toStringFull());
                        AggregationImpl.this.aggregateStore.lookup(adc[this.currentLookup].key, this);
                    }
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("Exception during consolidation lookup " + adc[this.currentLookup].key.toStringFull() + ": " + e + " -- aborting");
                e.printStackTrace();
            }

            static /* synthetic */ AggregationImpl access$2200(23 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ AggregateDescriptor[] access$2300(23 x0) {
                return x0.adc;
            }

            static /* synthetic */ int access$2400(23 x0) {
                return x0.objectsTotal;
            }

            static /* synthetic */ Aggregate[] access$2500(23 x0) {
                return x0.aggr;
            }
        });
    }

    private void reconnectTree() {
        if (this.rebuildInProgress) {
            this.log(2, "Skipping connectivity check (rebuild in progress)");
            return;
        }
        this.log(2, "Checking for disconnections");
        Id[] disconnected = this.aggregateList.getSomePointers(1, 100, null);
        if (disconnected.length < 2) {
            Id newRoot = disconnected.length == 1 ? disconnected[0] : null;
            Id currentRoot = this.aggregateList.getRoot();
            if (newRoot == null && currentRoot != null || newRoot != null && currentRoot == null || newRoot != null && currentRoot != null && !newRoot.equals(currentRoot)) {
                this.aggregateList.setRoot(newRoot);
            }
            this.log(2, "No aggregates disconnected (n=" + disconnected.length + ")");
            this.log(3, "root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
            return;
        }
        this.log(2, "Found " + disconnected.length + " disconnected aggregates; inserting pointer array");
        this.storeAggregate(new Aggregate(new GCPastContent[0], disconnected), System.currentTimeMillis() + 1209600000L, new ObjectDescriptor[0], disconnected, new Continuation(){

            public void receiveResult(Object o) {
                AggregationImpl.this.log(3, "Successfully inserted pointer array");
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("Error while inserting pointer array: " + e);
                e.printStackTrace();
            }
        });
    }

    private void timerExpired(char timerID) {
        this.log(3, "TIMER EXPIRED: #" + timerID);
        switch (timerID) {
            case '\u0001': {
                this.log(2, "Scheduled flush, waiting list: " + this.waitingList.getSize());
                this.formAggregates(new Continuation(){

                    public void receiveResult(Object o) {
                        AggregationImpl.this.log(3, "Scheduled flush: Success (o=" + o + ")");
                    }

                    public void receiveException(Exception e) {
                        AggregationImpl.this.warn("Scheduled flush: Failure (e=" + e + ")");
                        e.printStackTrace();
                    }
                });
                this.log(2, "Waiting list: " + this.waitingList.getSize() + " Scan: " + this.getNumObjectsWaiting() + " Max: " + maxObjectsInAggregate * maxAggregatesPerRun);
                if (this.getNumObjectsWaiting() >= maxObjectsInAggregate * maxAggregatesPerRun) {
                    this.log(2, "Retrying later");
                    this.addTimer(this.jitterTerm(300000L), '\u0001');
                    break;
                }
                this.log(2, "OK, waiting for next deadline");
                this.addTimer(this.jitterTerm(flushInterval), '\u0001');
                break;
            }
            case '\u0005': {
                this.refreshAggregates();
                this.reconnectTree();
                this.addTimer(this.jitterTerm(900000L), '\u0005');
                break;
            }
            case '\u0003': {
                this.consolidateAggregates();
                this.addTimer(this.jitterTerm(consolidationInterval), '\u0003');
                break;
            }
            case '\u0002': {
                Id[] ids = this.monitorIDs.toArray(new Id[0]);
                this.log(2, "Monitor: Refreshing " + ids.length + " objects");
                this.refresh(ids, System.currentTimeMillis() + 2700000L, new Continuation(){

                    public void receiveResult(Object o) {
                        AggregationImpl.this.log(3, "Monitor: Refresh completed, result=" + o);
                    }

                    public void receiveException(Exception e) {
                        AggregationImpl.this.log(3, "Monitor: Refresh failed, exception=" + e);
                        e.printStackTrace();
                    }
                });
                this.addTimer(900000L, '\u0002');
                break;
            }
            case '\u0004': {
                this.stats = this.aggregateList.getStatistics(3600000L, 1814400000L, 2);
                this.stats.dump();
                this.addTimer(60000L, '\u0004');
                break;
            }
            default: {
                this.panic("Unknown timer expired: " + timerID);
            }
        }
    }

    private void refreshInObjectStore(Id[] ids, long[] expirations, Continuation command) {
        if (this.objectStore instanceof GCPast) {
            ((GCPast)this.objectStore).refresh(ids, expirations, command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void refresh(final Id[] ids, final long[] expirations, final Continuation command) {
        if (ids.length < 1) {
            command.receiveResult(new Boolean[0]);
            return;
        }
        this.log(2, "Refreshing " + ids.length + " keys");
        this.refreshInObjectStore(ids, expirations, new Continuation(){
            Object[] result;

            public void receiveResult(Object o) {
                if (o instanceof Object[]) {
                    this.result = (Object[])o;
                } else {
                    AggregationImpl.this.warn("refresh: ObjectStore result is of incorrect type; expected Object[], got " + o);
                    this.result = new Object[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        this.result[i] = o;
                    }
                }
                this.refreshInAggregates();
            }

            public void receiveException(Exception e) {
                this.result = new Object[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    this.result[i] = e;
                }
                e.printStackTrace();
                this.refreshInAggregates();
            }

            private void refreshInAggregates() {
                Continuation c = new Continuation(this){
                    private final /* synthetic */ 28 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receiveResult(Object o) {
                        28.access$2600(this.this$1).aggregateList.writeToDisk();
                        28.access$2700(this.this$1).receiveResult(o);
                    }

                    public void receiveException(Exception e) {
                        e.printStackTrace();
                        28.access$2700(this.this$1).receiveException(e);
                    }
                };
                AggregationImpl.this.refreshInternal(ids, expirations, this.result, c);
            }

            static /* synthetic */ AggregationImpl access$2600(28 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Continuation access$2700(28 x0) {
                return x0.command;
            }
        });
    }

    public void refresh(Id[] ids, long[] versions, long[] expirations, final Continuation command) {
        final Object[] result = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            this.log(2, "Refresh(" + ids[i] + "v" + versions[i] + ", expiration=" + expirations[i] + ")");
            AggregateDescriptor adc = this.aggregateList.getADC(new VersionKey(ids[i], versions[i]));
            if (adc != null) {
                int objDescIndex = adc.lookupSpecific(ids[i], versions[i]);
                if (objDescIndex < 0) {
                    result[i] = new AggregationException("Inconsistency detected in aggregate list -- try restarting the application");
                    continue;
                }
                if (adc.objects[objDescIndex].refreshedLifetime < expirations[i]) {
                    this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expirations[i]);
                }
                result[i] = new Boolean(true);
                continue;
            }
            result[i] = new AggregationException("Not found");
        }
        if (this.objectStore instanceof VersioningPast) {
            ((VersioningPast)((Object)this.objectStore)).refresh(ids, versions, expirations, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof Object[]) {
                        Object[] subresult = (Object[])o;
                        for (int i = 0; i < result.length; ++i) {
                            if (!(result[i] instanceof Boolean) || subresult[i] instanceof Boolean) continue;
                            result[i] = subresult[i];
                        }
                    } else {
                        AggregationException e = new AggregationException("Object store returns unexpected result: " + o);
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = e;
                        }
                    }
                    command.receiveResult(result);
                }

                public void receiveException(Exception e) {
                    command.receiveException(e);
                }
            });
        } else {
            command.receiveResult(result);
        }
    }

    private void refreshInternal(final Id[] ids, final long[] expirations, final Object[] result, final Continuation command) {
        this.log(2, "refreshInternal: Accepted " + ids.length + " keys, starting with first key...");
        Continuation theContinuation = new Continuation(){
            int objectsMissing = 0;
            int objectsFetched = 0;
            int currentIndex = -1;

            public void receiveResult(Object o) {
                Object lastResult = o;
                while (true) {
                    if (this.currentIndex >= 0) {
                        AggregationImpl.this.log(3, "receiveResult(" + lastResult + ") for index " + this.currentIndex + ", length=" + ids.length);
                        AggregationImpl.this.log(3, "Internal refresh of " + ids[this.currentIndex].toStringFull() + " returned " + lastResult);
                        result[this.currentIndex] = lastResult;
                    }
                    ++this.currentIndex;
                    if (this.currentIndex >= ids.length) {
                        int i;
                        if (this.objectsMissing > 0) {
                            AggregationImpl.this.warn("refresh: " + this.objectsMissing + "/" + ids.length + " objects not in aggregate list, fetched " + this.objectsFetched + " (max " + 100 + ")");
                        }
                        int nOK = 0;
                        for (i = 0; i < ids.length; ++i) {
                            if (!(result[i] instanceof Boolean)) continue;
                            ++nOK;
                        }
                        AggregationImpl.this.log(2, "refreshInternal: Processed " + ids.length + " keys, completed " + nOK);
                        if (AggregationImpl.this.loglevel > 3) {
                            for (i = 0; i < ids.length; ++i) {
                                AggregationImpl.this.log(4, " - " + ids[i].toStringFull() + ": " + result[i]);
                            }
                        }
                        command.receiveResult(result);
                        return;
                    }
                    Id id = ids[this.currentIndex];
                    long expiration = expirations[this.currentIndex];
                    AggregationImpl.this.log(2, "Refresh(" + id.toStringFull() + ", expiration=" + expiration + ") started");
                    AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(id);
                    if (adc != null) {
                        int objDescIndex = adc.lookupNewest(id);
                        if (objDescIndex < 0) {
                            AggregationImpl.this.warn("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < expiration) {
                            AggregationImpl.this.log(3, "Changing expiration date from " + adc.objects[objDescIndex].refreshedLifetime + " to " + expiration);
                            AggregationImpl.this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expiration);
                        } else {
                            AggregationImpl.this.log(3, "Expiration is " + adc.objects[objDescIndex].refreshedLifetime + " already, no update needed");
                        }
                        lastResult = new Boolean(true);
                        continue;
                    }
                    IdSet waitingIds = AggregationImpl.this.waitingList.scan();
                    Iterator iter = waitingIds.getIterator();
                    while (iter.hasNext()) {
                        VersionKey vkey = (VersionKey)iter.next();
                        if (!vkey.getId().equals(id)) continue;
                        ObjectDescriptor thisObject = (ObjectDescriptor)AggregationImpl.this.waitingList.getMetadata(vkey);
                        AggregationImpl.this.log(2, "Refreshing in waiting list: " + vkey.toStringFull());
                        if (thisObject == null) {
                            AggregationImpl.this.warn("Broken object in waiting list: " + vkey.toStringFull() + ", removing...");
                            31 myParent = this;
                            AggregationImpl.this.waitingList.unstore(vkey, new Continuation(this, vkey, myParent){
                                private final /* synthetic */ VersionKey val$vkey;
                                private final /* synthetic */ Continuation val$myParent;
                                private final /* synthetic */ 31 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$vkey = val$vkey;
                                    this.val$myParent = val$myParent;
                                }

                                public void receiveResult(Object o) {
                                    AggregationImpl.access$000(31.access$3000(this.this$1), 2, "Broken object " + this.val$vkey.toStringFull() + " removed successfully");
                                    this.val$myParent.receiveResult(new AggregationException("Object in waiting list, but broken: " + this.val$vkey.toStringFull()));
                                }

                                public void receiveException(Exception e) {
                                    AggregationImpl.access$100(31.access$3000(this.this$1), "Cannot remove broken object " + this.val$vkey.toStringFull() + " from waiting list (exception: " + e + ")");
                                    e.printStackTrace();
                                    this.val$myParent.receiveResult(new AggregationException("Object broken, in waiting list, and cannot remove: " + this.val$vkey.toStringFull() + " (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        if (thisObject.refreshedLifetime < expiration) {
                            ObjectDescriptor newDescriptor = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, expiration, thisObject.size);
                            31 myParent = this;
                            AggregationImpl.this.waitingList.setMetadata(vkey, newDescriptor, new Continuation(this, vkey, myParent){
                                private final /* synthetic */ VersionKey val$vkey;
                                private final /* synthetic */ Continuation val$myParent;
                                private final /* synthetic */ 31 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$vkey = val$vkey;
                                    this.val$myParent = val$myParent;
                                }

                                public void receiveResult(Object o) {
                                    AggregationImpl.access$000(31.access$3000(this.this$1), 3, "Refreshed metadata written ok for " + this.val$vkey.toStringFull());
                                    this.val$myParent.receiveResult(new Boolean(true));
                                }

                                public void receiveException(Exception e) {
                                    AggregationImpl.access$100(31.access$3000(this.this$1), "Cannot refresh waiting object " + this.val$vkey.toStringFull() + ", e=" + e);
                                    e.printStackTrace();
                                    this.val$myParent.receiveResult(new AggregationException("Cannot refresh waiting object " + this.val$vkey.toStringFull() + ", setMetadata() failed (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        AggregationImpl.this.log(3, "Object found in waiting list and no update needed: " + vkey.toStringFull());
                        this.receiveResult(new Boolean(true));
                        return;
                    }
                    ++this.objectsMissing;
                    if (this.objectsFetched < 100) {
                        ++this.objectsFetched;
                        31 myParent = this;
                        AggregationImpl.this.objectStore.lookup(id, false, new Continuation(this, id, expiration, myParent){
                            private final /* synthetic */ Id val$id;
                            private final /* synthetic */ long val$expiration;
                            private final /* synthetic */ Continuation val$myParent;
                            private final /* synthetic */ 31 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$id = val$id;
                                this.val$expiration = val$expiration;
                                this.val$myParent = val$myParent;
                            }

                            public void receiveResult(Object o) {
                                if (o instanceof PastContent) {
                                    PastContent obj = (PastContent)o;
                                    AggregationImpl.access$100(31.access$3000(this.this$1), "Refresh: Found in PAST, but not in aggregate list: " + this.val$id.toStringFull());
                                    long theVersion = o instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
                                    VersionKey vkey = new VersionKey(obj.getId(), theVersion);
                                    long theVersionF = theVersion;
                                    int theSize = AggregationImpl.access$3100(31.access$3000(this.this$1), obj);
                                    if (31.access$3000(this.this$1).policy.shouldBeAggregated(obj, theSize)) {
                                        if (!31.access$3000(this.this$1).waitingList.exists(vkey)) {
                                            AggregationImpl.access$000(31.access$3000(this.this$1), 3, "ADDING MISSING OBJECT AFTER REFRESH: " + obj.getId());
                                            31.access$3000(this.this$1).waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, this.val$expiration, this.val$expiration, theSize), obj, new Continuation(this, obj){
                                                private final /* synthetic */ PastContent val$obj;
                                                private final /* synthetic */ 34 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                    this.val$obj = val$obj;
                                                }

                                                public void receiveResult(Object o) {
                                                    ((PastImpl)31.access$3000(34.access$3400(this.this$2)).objectStore).cache(this.val$obj, new Continuation(this){
                                                        private final /* synthetic */ 35 this$3;
                                                        {
                                                            this.this$3 = this$3;
                                                        }

                                                        public void receiveResult(Object o) {
                                                            AggregationImpl.access$000(31.access$3000(34.access$3400(35.access$3200(this.this$3))), 3, "Refresh: Missing object " + 34.access$3300(35.access$3200(this.this$3)).toStringFull() + " added ok");
                                                            34.access$3500(35.access$3200(this.this$3)).receiveResult(new Boolean(true));
                                                        }

                                                        public void receiveException(Exception e) {
                                                            AggregationImpl.access$100(31.access$3000(34.access$3400(35.access$3200(this.this$3))), "Refresh: Exception while precaching object: " + 34.access$3300(35.access$3200(this.this$3)).toStringFull() + " (e=" + e + ")");
                                                            e.printStackTrace();
                                                            34.access$3500(35.access$3200(this.this$3)).receiveResult(new Boolean(true));
                                                        }
                                                    });
                                                }

                                                public void receiveException(Exception e) {
                                                    AggregationImpl.access$100(31.access$3000(34.access$3400(this.this$2)), "Refresh: Exception while refreshing aggregate: " + 34.access$3300(this.this$2).toStringFull() + " (e=" + e + ")");
                                                    e.printStackTrace();
                                                    34.access$3500(this.this$2).receiveResult(new AggregationException("Cannot store reaggregated object in waiting list: " + 34.access$3300(this.this$2).toStringFull()));
                                                }

                                                static /* synthetic */ 34 access$3200(35 x0) {
                                                    return x0.this$2;
                                                }
                                            });
                                            return;
                                        }
                                        AggregationImpl.access$000(31.access$3000(this.this$1), 3, "Refresh: Missing object already in waiting list: " + this.val$id.toStringFull());
                                        this.val$myParent.receiveResult(new Boolean(true));
                                        return;
                                    }
                                    AggregationImpl.access$000(31.access$3000(this.this$1), 3, "Refresh: Missing object should not be aggregated: " + this.val$id.toStringFull());
                                    this.val$myParent.receiveResult(new Boolean(true));
                                    return;
                                }
                                AggregationImpl.access$100(31.access$3000(this.this$1), "Refresh: Cannot find refreshed object " + this.val$id.toStringFull() + ", lookup returns " + o);
                                this.val$myParent.receiveException(new AggregationException("Object not found during reaggregation: " + this.val$id.toStringFull()));
                            }

                            public void receiveException(Exception e) {
                                AggregationImpl.access$100(31.access$3000(this.this$1), "Refresh: Exception received while reaggregating " + this.val$id.toStringFull() + ", e=" + e);
                                this.val$myParent.receiveException(e);
                            }

                            static /* synthetic */ Id access$3300(34 x0) {
                                return x0.val$id;
                            }

                            static /* synthetic */ 31 access$3400(34 x0) {
                                return x0.this$1;
                            }

                            static /* synthetic */ Continuation access$3500(34 x0) {
                                return x0.val$myParent;
                            }
                        });
                        return;
                    }
                    AggregationImpl.this.log(3, "Refresh: Limit of 100 reaggregations exceeded; postponing id=" + id.toStringFull());
                    lastResult = new Boolean(true);
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("Exception while refreshing " + ids[this.currentIndex].toStringFull() + ", e=" + e);
                e.printStackTrace();
                this.receiveResult(e);
            }

            static /* synthetic */ AggregationImpl access$3000(31 x0) {
                return x0.AggregationImpl.this;
            }
        };
        theContinuation.receiveResult(null);
    }

    private void rebuildRecursive(final Id fromKey, final Vector keysInProgress, final Vector keysPostponed, final Vector keysDone, final Continuation command) {
        keysInProgress.add(fromKey);
        this.log(2, "Rebuild: Fetching handles for aggregate " + fromKey.toStringFull());
        this.aggregateStore.lookupHandles(fromKey, 999, new Continuation(){

            public void receiveResult(Object o) {
                AggregationImpl.this.log(3, "Got handles for " + fromKey);
                if (o instanceof PastContentHandle[]) {
                    PastContentHandle[] pch = (PastContentHandle[])o;
                    PastContentHandle bestHandle = null;
                    for (int i = 0; i < pch.length; ++i) {
                        if (pch[i] == null || pch[i] instanceof GCPastContentHandle && ((GCPastContentHandle)pch[i]).getVersion() != 0L || bestHandle != null) continue;
                        bestHandle = pch[i];
                    }
                    if (bestHandle != null) {
                        PastContentHandle thisHandle = bestHandle;
                        37 outerContinuation = this;
                        AggregationImpl.this.log(3, "Fetching " + thisHandle);
                        AggregationImpl.this.aggregateStore.fetch(thisHandle, new Continuation(this, thisHandle, outerContinuation){
                            private final /* synthetic */ PastContentHandle val$thisHandle;
                            private final /* synthetic */ Continuation val$outerContinuation;
                            private final /* synthetic */ 37 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$thisHandle = val$thisHandle;
                                this.val$outerContinuation = val$outerContinuation;
                            }

                            public void receiveResult(Object o) {
                                if (o instanceof Aggregate) {
                                    37.access$3700(this.this$1).remove(37.access$3600(this.this$1));
                                    37.access$3800(this.this$1).add(37.access$3600(this.this$1));
                                    AggregationImpl.access$000(37.access$3900(this.this$1), 2, "Rebuild: Got aggregate " + 37.access$3600(this.this$1).toStringFull());
                                    Aggregate aggr = (Aggregate)o;
                                    ObjectDescriptor[] objects = new ObjectDescriptor[aggr.components.length];
                                    long aggregateExpiration = this.val$thisHandle instanceof GCPastContentHandle ? ((GCPastContentHandle)this.val$thisHandle).getExpiration() : Long.MAX_VALUE;
                                    for (int i = 0; i < aggr.components.length; ++i) {
                                        objects[i] = new ObjectDescriptor(aggr.components[i].getId(), aggr.components[i].getVersion(), aggregateExpiration, aggregateExpiration, AggregationImpl.access$3100(37.access$3900(this.this$1), aggr.components[i]));
                                        GCPastContent objData = aggr.components[i];
                                        AggregationImpl.access$000(37.access$3900(this.this$1), 3, "Checking whether " + objData.getId() + "v" + objData.getVersion() + " is in object store...");
                                        37.access$3900(this.this$1).objectStore.lookupHandles(objData.getId(), 1, new Continuation(this, objData){
                                            private final /* synthetic */ GCPastContent val$objData;
                                            private final /* synthetic */ 38 this$2;
                                            {
                                                this.this$2 = this$2;
                                                this.val$objData = val$objData;
                                            }

                                            public void receiveResult(Object o) {
                                                PastContentHandle[] result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                                                AggregationImpl.access$000(37.access$3900(38.access$4000(this.this$2)), 3, "Handles for " + this.val$objData.getId() + "v" + this.val$objData.getVersion() + ": " + result + " (" + result.length + ", PCH=" + (o instanceof PastContentHandle[]) + ")");
                                                boolean gotOne = false;
                                                for (int i = 0; i < result.length; ++i) {
                                                    if (result[i] == null) continue;
                                                    AggregationImpl.access$000(37.access$3900(38.access$4000(this.this$2)), 3, "Have v" + ((GCPastContentHandle)result[i]).getVersion());
                                                    if (((GCPastContentHandle)result[i]).getVersion() < this.val$objData.getVersion()) continue;
                                                    gotOne = true;
                                                }
                                                if (gotOne) {
                                                    AggregationImpl.access$000(37.access$3900(38.access$4000(this.this$2)), 3, "Got it");
                                                } else {
                                                    AggregationImpl.access$000(37.access$3900(38.access$4000(this.this$2)), 3, "Ain't got it... reinserting");
                                                    37.access$3900(38.access$4000(this.this$2)).objectStore.insert(this.val$objData, new Continuation(this){
                                                        private final /* synthetic */ 39 this$3;
                                                        {
                                                            this.this$3 = this$3;
                                                        }

                                                        public void receiveResult(Object o) {
                                                            AggregationImpl.access$000(37.access$3900(38.access$4000(39.access$4200(this.this$3))), 3, "Reinsert " + 39.access$4100(this.this$3).getId() + "v" + 39.access$4100(this.this$3).getVersion() + " ok, result=" + o);
                                                        }

                                                        public void receiveException(Exception e) {
                                                            AggregationImpl.access$000(37.access$3900(38.access$4000(39.access$4200(this.this$3))), 3, "Reinsert " + 39.access$4100(this.this$3).getId() + "v" + 39.access$4100(this.this$3).getVersion() + " failed, exception=" + e);
                                                            e.printStackTrace();
                                                        }
                                                    });
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                AggregationImpl.access$000(37.access$3900(38.access$4000(this.this$2)), 3, "Cannot retrieve handles for object " + this.val$objData.getId() + "v" + this.val$objData.getVersion() + " to be restored; e=" + e);
                                                e.printStackTrace();
                                            }

                                            static /* synthetic */ GCPastContent access$4100(39 x0) {
                                                return x0.val$objData;
                                            }

                                            static /* synthetic */ 38 access$4200(39 x0) {
                                                return x0.this$2;
                                            }
                                        });
                                    }
                                    37.access$3900(this.this$1).aggregateList.addAggregateDescriptor(new AggregateDescriptor(37.access$3600(this.this$1), aggregateExpiration, objects, aggr.getPointers()));
                                    Id[] pointers = aggr.getPointers();
                                    int numAdded = 0;
                                    if (pointers != null) {
                                        for (int i = 0; i < pointers.length; ++i) {
                                            if (!(pointers[i] instanceof Id)) continue;
                                            Id thisPointer = pointers[i];
                                            if (37.access$3800(this.this$1).contains(thisPointer) || 37.access$4300(this.this$1).contains(thisPointer) || 37.access$3700(this.this$1).contains(thisPointer)) continue;
                                            if (37.access$3700(this.this$1).size() >= AggregationImpl.access$4400()) {
                                                37.access$4300(this.this$1).add(thisPointer);
                                            } else {
                                                AggregationImpl.access$4600(37.access$3900(this.this$1), thisPointer, 37.access$3700(this.this$1), 37.access$4300(this.this$1), 37.access$3800(this.this$1), 37.access$4500(this.this$1));
                                            }
                                            ++numAdded;
                                        }
                                    }
                                    AggregationImpl.access$000(37.access$3900(this.this$1), 3, "Rebuild: Added " + numAdded + " keys, now " + 37.access$3700(this.this$1).size() + " in progress, " + 37.access$4300(this.this$1).size() + " postponed and " + 37.access$3800(this.this$1).size() + " done");
                                    if (!37.access$3700(this.this$1).isEmpty() || !37.access$4300(this.this$1).isEmpty()) {
                                        AggregationImpl.access$000(37.access$3900(this.this$1), 2, "Rebuild: " + 37.access$3700(this.this$1).size() + " keys in progress, " + 37.access$4300(this.this$1).size() + " postponed, " + 37.access$3800(this.this$1).size() + " done");
                                        while (37.access$3700(this.this$1).size() < AggregationImpl.access$4400() && 37.access$4300(this.this$1).size() > 0) {
                                            Id nextKey = (Id)37.access$4300(this.this$1).firstElement();
                                            AggregationImpl.access$000(37.access$3900(this.this$1), 3, "Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                                            37.access$4300(this.this$1).remove(nextKey);
                                            AggregationImpl.access$4600(37.access$3900(this.this$1), nextKey, 37.access$3700(this.this$1), 37.access$4300(this.this$1), 37.access$3800(this.this$1), 37.access$4500(this.this$1));
                                        }
                                    } else {
                                        37.access$3900(this.this$1).aggregateList.writeToDisk();
                                        37.access$3900(this.this$1).rebuildInProgress = false;
                                        AggregationImpl.access$000(37.access$3900(this.this$1), 2, "Rebuild: Completed; " + 37.access$3800(this.this$1).size() + " aggregates checked");
                                        37.access$4500(this.this$1).receiveResult(new Boolean(true));
                                    }
                                } else {
                                    this.receiveException(new AggregationException("Fetch failed: " + 37.access$3600(this.this$1) + ", returned " + o));
                                }
                            }

                            public void receiveException(Exception e) {
                                this.val$outerContinuation.receiveException(e);
                            }

                            static /* synthetic */ 37 access$4000(38 x0) {
                                return x0.this$1;
                            }
                        });
                    } else {
                        this.receiveException(new AggregationException("LookupHandles did not return any valid handles for " + fromKey));
                    }
                } else {
                    this.receiveException(new AggregationException("LookupHandles for " + fromKey + " failed, returned o=" + o));
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("Rebuild: Exception " + e);
                e.printStackTrace();
                keysInProgress.remove(fromKey);
                keysDone.add(fromKey);
                if (keysInProgress.isEmpty() && keysPostponed.isEmpty()) {
                    AggregationImpl.this.rebuildInProgress = false;
                    if (AggregationImpl.this.aggregateList.isEmpty()) {
                        command.receiveException(new AggregationException("Cannot read root aggregate! -- retry later"));
                    } else {
                        AggregationImpl.this.aggregateList.writeToDisk();
                        command.receiveResult(new Boolean(true));
                    }
                }
                while (keysInProgress.size() < reconstructionMaxConcurrentLookups && keysPostponed.size() > 0) {
                    Id nextKey = (Id)keysPostponed.firstElement();
                    AggregationImpl.this.log(3, "Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                    keysPostponed.remove(nextKey);
                    AggregationImpl.this.rebuildRecursive(nextKey, keysInProgress, keysPostponed, keysDone, command);
                }
            }

            static /* synthetic */ Id access$3600(37 x0) {
                return x0.fromKey;
            }

            static /* synthetic */ Vector access$3700(37 x0) {
                return x0.keysInProgress;
            }

            static /* synthetic */ Vector access$3800(37 x0) {
                return x0.keysDone;
            }

            static /* synthetic */ AggregationImpl access$3900(37 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Vector access$4300(37 x0) {
                return x0.keysPostponed;
            }

            static /* synthetic */ Continuation access$4500(37 x0) {
                return x0.command;
            }
        });
    }

    private void rebuildAggregateList(Continuation command) {
        Vector keysInProgress = new Vector();
        Vector keysPostponed = new Vector();
        Vector keysDone = new Vector();
        this.log(2, "rebuildAggregateList(" + this.aggregateList.getRoot() + ")");
        if (this.aggregateList.getRoot() == null) {
            this.warn("rebuildAggregateList invoked while rootKey is null");
            command.receiveException(new AggregationException("Set handle first!"));
            return;
        }
        this.rebuildInProgress = true;
        this.rebuildRecursive(this.aggregateList.getRoot(), keysInProgress, keysPostponed, keysDone, command);
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void insert(final PastContent obj, long lifetime, final Continuation command) {
        long theVersion = obj instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
        VersionKey vkey = new VersionKey(obj.getId(), theVersion);
        long theVersionF = theVersion;
        int theSize = this.getSize(obj);
        if (this.policy.shouldBeAggregated(obj, theSize)) {
            this.log(2, "AGGREGATE INSERT: " + obj.getId() + " version=" + theVersion + " size=" + theSize + " class=" + obj.getClass().getName());
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, command);
            } else {
                this.objectStore.insert(obj, command);
            }
            this.waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, lifetime, lifetime, theSize), obj, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                    AggregationImpl.this.warn("Exception while storing aggregate: " + obj.getId() + " (e=" + e + ")");
                    e.printStackTrace();
                }
            });
        } else {
            this.log(2, "INSERT WITHOUT AGGREGATION: " + obj.getId() + " version=" + theVersionF + " size=" + theSize + " class=" + obj.getClass().getName());
            Continuation c = new Continuation(){
                boolean otherSucceeded = false;
                boolean otherFailed = false;

                public void receiveResult(Object o) {
                    AggregationImpl.this.log(3, "INSERT " + obj.getId() + " receiveResult(" + o + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    if (this.otherSucceeded) {
                        if (!this.otherFailed) {
                            AggregationImpl.this.log(3, "--reporting Success");
                            command.receiveResult(new Boolean[]{new Boolean(true)});
                        }
                    } else {
                        this.otherSucceeded = true;
                    }
                }

                public void receiveException(Exception e) {
                    AggregationImpl.this.log(3, "INSERT " + obj.getId() + " receiveException(" + e + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    AggregationImpl.this.log(3, "--reporting Failure");
                    command.receiveException(e);
                    this.otherFailed = true;
                }
            };
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, c);
            } else {
                this.objectStore.insert(obj, c);
            }
            if (this.aggregateStore instanceof GCPast) {
                ((GCPast)this.aggregateStore).insert(obj, lifetime, c);
            } else {
                this.aggregateStore.insert(obj, c);
            }
        }
    }

    private void retrieveObjectFromAggregate(final AggregateDescriptor adc, final int objDescIndex, final Continuation command) {
        this.aggregateStore.lookup(adc.key, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    Aggregate aggr = (Aggregate)o;
                    AggregationImpl.this.endpoint.process(new Executable(this, aggr){
                        private final /* synthetic */ Aggregate val$aggr;
                        private final /* synthetic */ 43 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$aggr = val$aggr;
                        }

                        public Object execute() {
                            return 43.access$4700(this.this$1).factory.buildId(this.val$aggr.getContentHash());
                        }
                    }, new Continuation(this, aggr){
                        private final /* synthetic */ Aggregate val$aggr;
                        private final /* synthetic */ 43 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$aggr = val$aggr;
                        }

                        public void receiveResult(Object o) {
                            if (o instanceof Id) {
                                Id aggrNominalKey = (Id)o;
                                if (!aggrNominalKey.equals(43.access$4800(this.this$1).key)) {
                                    AggregationImpl.access$100(43.access$4700(this.this$1), "Cannot validate aggregate " + 43.access$4800(this.this$1).key + ", hash=" + aggrNominalKey);
                                    43.access$4900(this.this$1).receiveException(new AggregationException("Cannot validate aggregate -- retry?"));
                                    return;
                                }
                                AggregationImpl.access$000(43.access$4700(this.this$1), 3, "Object " + 43.access$4800(this.this$1).objects[43.access$5000(this.this$1)].key + " (#" + 43.access$5000(this.this$1) + ") successfully retrieved from " + 43.access$4800(this.this$1).key);
                                43.access$4700(this.this$1).objectStore.insert(this.val$aggr.getComponent(43.access$5000(this.this$1)), new Continuation(this){
                                    private final /* synthetic */ 45 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void receiveResult(Object o) {
                                    }

                                    public void receiveException(Exception e) {
                                    }
                                });
                                43.access$4900(this.this$1).receiveResult(this.val$aggr.getComponent(43.access$5000(this.this$1)));
                            } else {
                                AggregationImpl.access$100(43.access$4700(this.this$1), "retrieveObjectFromAggregate cannot determine content hash, received " + o);
                                43.access$4900(this.this$1).receiveException(new AggregationException("retrieveObjectFromAggregate cannot determine content hash"));
                            }
                        }

                        public void receiveException(Exception e) {
                            AggregationImpl.access$100(43.access$4700(this.this$1), "retrieveObjectFromAggregate cannot determine content hash, exception " + e);
                            e.printStackTrace();
                            43.access$4900(this.this$1).receiveException(e);
                        }
                    });
                } else {
                    AggregationImpl.this.warn("retrieveObjectFromAggregate failed; receiveResult(" + o + ")");
                    command.receiveResult(null);
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("retrieveObjectFromAggregate failed; receiveException(" + e + ")");
                e.printStackTrace();
                command.receiveException(e);
            }

            static /* synthetic */ AggregationImpl access$4700(43 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ AggregateDescriptor access$4800(43 x0) {
                return x0.adc;
            }

            static /* synthetic */ Continuation access$4900(43 x0) {
                return x0.command;
            }

            static /* synthetic */ int access$5000(43 x0) {
                return x0.objDescIndex;
            }
        });
    }

    public void lookup(final Id id, boolean cache, final Continuation command) {
        this.log(2, "lookup(" + id + ", cache=" + cache + ")");
        this.objectStore.lookup(id, cache, new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    AggregationImpl.this.log(3, "NL: Found in PAST: " + id);
                    command.receiveResult(o);
                } else {
                    AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(id);
                    if (adc != null) {
                        AggregationImpl.this.log(3, "NL: Must retrieve from aggregate");
                        int objDescIndex = adc.lookupNewest(id);
                        if (objDescIndex < 0) {
                            AggregationImpl.this.warn("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, command);
                    } else {
                        AggregationImpl.this.warn("NL: LOOKUP FAILED, OBJECT NOT FOUND: " + id);
                        command.receiveResult(null);
                    }
                }
            }

            public void receiveException(Exception e) {
                command.receiveException(e);
            }
        });
    }

    public void lookup(final Id id, final long version, final Continuation command) {
        this.log(2, "lookup(" + id + ", version=" + version + ")");
        AggregateDescriptor adc = this.aggregateList.getADC(new VersionKey(id, version));
        if (adc != null) {
            this.log(3, "VL: Retrieving from aggregate");
            int objDescIndex = adc.lookupSpecific(id, version);
            if (objDescIndex < 0) {
                this.warn("VL: Aggregate found, but object not found in aggregate?!? -- aborted");
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        } else {
            this.log(3, "VL: Not found in aggregate list: " + id + "v" + version);
            if (this.aggregateStore instanceof VersioningPast) {
                VersioningPast vaggr = (VersioningPast)((Object)this.aggregateStore);
                vaggr.lookup(id, version, new Continuation(){

                    public void receiveResult(Object o) {
                        if (o != null) {
                            AggregationImpl.this.log(3, "VL: Found in Aggregate.VersioningPAST: " + id + "v" + version);
                            command.receiveResult(o);
                        } else {
                            AggregationImpl.this.log(3, "VL: Not found in Aggregate.VersioningPAST: " + id + "v" + version);
                            if (AggregationImpl.this.objectStore instanceof VersioningPast) {
                                VersioningPast vpast = (VersioningPast)((Object)AggregationImpl.this.objectStore);
                                vpast.lookup(id, version, new Continuation(this){
                                    private final /* synthetic */ 48 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void receiveResult(Object o) {
                                        if (o != null) {
                                            AggregationImpl.access$000(48.access$5400(this.this$1), 3, "VL: Found in Object.VersioningPAST: " + 48.access$5200(this.this$1) + "v" + 48.access$5300(this.this$1));
                                            48.access$5500(this.this$1).receiveResult(o);
                                        } else {
                                            AggregationImpl.access$100(48.access$5400(this.this$1), "VL: LOOKUP FAILED, OBJECT NOT FOUND: " + 48.access$5200(this.this$1) + "v" + 48.access$5300(this.this$1));
                                            48.access$5500(this.this$1).receiveResult(null);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        48.access$5500(this.this$1).receiveException(e);
                                    }
                                });
                            } else {
                                AggregationImpl.this.log(3, "VL: Object store does not support versioning");
                                command.receiveException(new AggregationException("Cannot find " + id + "v" + version + " -- try rebuilding aggregate list?"));
                            }
                        }
                    }

                    public void receiveException(Exception e) {
                        command.receiveException(new AggregationException("Aggregate.VersioningPAST returned exception for " + id + "v" + version + ": " + e));
                        e.printStackTrace();
                    }

                    static /* synthetic */ Id access$5200(48 x0) {
                        return x0.id;
                    }

                    static /* synthetic */ long access$5300(48 x0) {
                        return x0.version;
                    }

                    static /* synthetic */ AggregationImpl access$5400(48 x0) {
                        return x0.AggregationImpl.this;
                    }

                    static /* synthetic */ Continuation access$5500(48 x0) {
                        return x0.command;
                    }
                });
            } else {
                this.log(3, "VL: Aggregate store does not support versioning");
                if (this.objectStore instanceof VersioningPast) {
                    VersioningPast vpast = (VersioningPast)((Object)this.objectStore);
                    vpast.lookup(id, version, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o != null) {
                                AggregationImpl.this.log(3, "VL: Found in Object.VersioningPAST: " + id + "v" + version);
                                command.receiveResult(o);
                            } else {
                                AggregationImpl.this.warn("VL: LOOKUP FAILED, OBJECT NOT FOUND: " + id + "v" + version);
                                command.receiveResult(null);
                            }
                        }

                        public void receiveException(Exception e) {
                            command.receiveException(e);
                        }
                    });
                }
                this.log(3, "VL: Object store does not support versioning");
                command.receiveResult(null);
            }
        }
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookupHandles(Id id, long version, int max, Continuation command) {
        ((VersioningPast)((Object)this.aggregateStore)).lookupHandles(id, version, max, command);
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Aggregation"));
    }

    public void lookupHandles(final Id id, final int max, final Continuation command) {
        this.log(2, "lookupHandles(" + id + "," + max + ")");
        this.objectStore.lookupHandles(id, max, new Continuation(){

            public void receiveResult(Object o) {
                PastContentHandle[] result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                boolean foundHandle = false;
                for (int i = 0; i < result.length; ++i) {
                    if (result[i] == null) continue;
                    foundHandle = true;
                }
                if (foundHandle) {
                    AggregationImpl.this.log(3, "lookupHandles(" + id + "," + max + ") handled by PAST; ret=" + o);
                    command.receiveResult(o);
                } else {
                    AggregationImpl.this.log(2, "lookupHandles(" + id + "," + max + ") failed, ret=" + o);
                    AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(id);
                    if (adc != null) {
                        AggregationImpl.this.log(3, "lookupHandles: Retrieving from aggregate");
                        int objDescIndex = adc.lookupNewest(id);
                        if (objDescIndex < 0) {
                            AggregationImpl.this.warn("lookupHandles: Aggregate found, but object not found in aggregate?!? -- aborted");
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < System.currentTimeMillis()) {
                            AggregationImpl.this.log(3, "Object " + id + " exists, but has expired -- ignoring");
                            command.receiveResult(new PastContentHandle[]{null});
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, new Continuation(this){
                            private final /* synthetic */ 51 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void receiveResult(Object o) {
                                AggregationImpl.access$000(51.access$5700(this.this$1), 3, "lookupHandles: Retrieved from aggregate: " + 51.access$5600(this.this$1) + ", result=" + o);
                                51.access$5700(this.this$1).objectStore.lookupHandles(51.access$5600(this.this$1), 51.access$5800(this.this$1), 51.access$5900(this.this$1));
                            }

                            public void receiveException(Exception e) {
                                AggregationImpl.access$100(51.access$5700(this.this$1), "lookupHandles: Cannot retrieve from aggregate, exception " + e);
                                51.access$5900(this.this$1).receiveException(e);
                            }
                        });
                    } else {
                        AggregationImpl.this.log(2, "lookupHandles: " + id + " is neither in object store nor in aggregate list");
                        command.receiveResult(new PastContentHandle[]{null});
                    }
                }
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.warn("Exception in lookupHandles: " + e);
                command.receiveException(e);
            }

            static /* synthetic */ Id access$5600(51 x0) {
                return x0.id;
            }

            static /* synthetic */ AggregationImpl access$5700(51 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ int access$5800(51 x0) {
                return x0.max;
            }

            static /* synthetic */ Continuation access$5900(51 x0) {
                return x0.command;
            }
        });
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        if (handle instanceof GlacierContentHandle) {
            this.aggregateStore.fetch(handle, command);
        } else {
            this.objectStore.fetch(handle, command);
        }
    }

    public void flush(Id id, Continuation command) {
        Iterator iter = this.waitingList.scan().getIterator();
        boolean objectIsWaiting = false;
        this.log(2, "flush(" + id + ") invoked");
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            if (!thisKey.getId().equals(id)) continue;
            objectIsWaiting = true;
            break;
        }
        if (objectIsWaiting) {
            this.formAggregates(command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void flush(Continuation command) {
        this.formAggregates(command);
    }

    public void rollback(Id id, Continuation command) {
        AggregateDescriptor adc = this.aggregateList.getADC(id);
        if (adc != null) {
            int objDescIndex = adc.lookupNewest(id);
            if (objDescIndex < 0) {
                this.warn("Rollback: Aggregate found, but object not found in aggregate?!? -- aborted");
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            this.log(3, "Rollback: Found " + adc.objects[objDescIndex].key + "v" + adc.objects[objDescIndex].version);
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        }
        this.log(3, "Rollback: No version of " + id + " found");
        command.receiveResult(null);
    }

    public void reset(Continuation command) {
        this.aggregateList.clear();
        Iterator iter = this.waitingList.scan().getIterator();
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            this.waitingList.unstore(thisKey, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                }
            });
        }
        command.receiveResult(new Boolean(true));
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public void deliver(Id id, Message message) {
        AggregationMessage msg = (AggregationMessage)message;
        this.log(3, "Received message " + msg + " with destination " + id + " from " + msg.getSource().getId());
        if (msg instanceof AggregationTimeoutMessage) {
            AggregationTimeoutMessage gtm = (AggregationTimeoutMessage)msg;
            this.timerExpired((char)gtm.getUID());
            return;
        }
        this.panic("AGGREGATION ERROR - Received message " + msg + " of unknown type.");
    }

    private static AggregationPolicy getDefaultPolicy() {
        return new AggregationDefaultPolicy();
    }

    static /* synthetic */ int access$3100(AggregationImpl x0, PastContent x1) {
        return x0.getSize(x1);
    }
}

