/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.util.Arrays;

public class AggregationStatistics {
    public final long granularity;
    public int numObjectsTotal = 0;
    public int numObjectsAlive = 0;
    public int numAggregatesTotal = 0;
    public int numPointerArrays = 0;
    public int criticalAggregates;
    public int orphanedAggregates;
    public int[] objectLifetimeHisto;
    public int[] aggregateLifetimeHisto;
    public long totalObjectsSize = 0L;
    public long liveObjectsSize = 0L;
    public long time;

    public AggregationStatistics(int histoLength, long granularityArg) {
        this.granularity = granularityArg;
        this.objectLifetimeHisto = new int[histoLength];
        Arrays.fill(this.objectLifetimeHisto, 0);
        this.aggregateLifetimeHisto = new int[histoLength];
        Arrays.fill(this.aggregateLifetimeHisto, 0);
        this.time = System.currentTimeMillis();
    }

    public void dump() {
        System.out.println("@L.AG interval=" + this.time + "-" + System.currentTimeMillis() + " granularity=" + this.granularity);
        System.out.println("@L.AG   objsTotal=" + this.numObjectsTotal + " objsAlive=" + this.numObjectsAlive);
        System.out.println("@L.AG   objBytesTotal=" + this.totalObjectsSize + " objBytesAlive=" + this.liveObjectsSize);
        System.out.println("@L.AG   aggrTotal=" + this.numAggregatesTotal + " ptrArrays=" + this.numPointerArrays + " critical=" + this.criticalAggregates + " orphaned=" + this.orphanedAggregates);
    }
}

