/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.commonapi.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public abstract class CommonAPITest {
    protected Node[] nodes;
    protected PastryNodeFactory factory;
    protected NodeIdFactory idFactory = new RandomNodeIdFactory();
    protected NetworkSimulator simulator = SIMULATOR == -1 ? new SphereNetwork() : new EuclideanNetwork();
    public static int NUM_NODES = 10;
    public static IdFactory FACTORY = new PastryIdFactory();
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    protected static final int PAD_SIZE = 60;
    public static final int PROTOCOL_DIRECT = -138;
    public static final int SIMULATOR_SPHERE = -1;
    public static final int SIMULATOR_EUCLIDEAN = -2;
    public static int PORT = 5009;
    public static String BOOTSTRAP_HOST = "localhost";
    public static int BOOTSTRAP_PORT = 5009;
    public static int PROTOCOL = DistPastryNodeFactory.PROTOCOL_DEFAULT;
    public static int SIMULATOR = -1;
    public static String INSTANCE_NAME = "DistCommonAPITest";

    public CommonAPITest() {
        this.factory = PROTOCOL == -138 ? new DirectPastryNodeFactory(this.idFactory, this.simulator) : DistPastryNodeFactory.getFactory(this.idFactory, PROTOCOL, PORT);
        this.nodes = new Node[NUM_NODES];
    }

    protected NodeHandle getBootstrap() {
        if (PROTOCOL == -138) {
            return ((DirectPastryNode)this.nodes[0]).getLocalHandle();
        }
        InetSocketAddress address = new InetSocketAddress(BOOTSTRAP_HOST, BOOTSTRAP_PORT);
        return ((DistPastryNodeFactory)this.factory).getNodeHandle(address);
    }

    public void createNodes() {
        for (int i = 0; i < NUM_NODES; ++i) {
            this.nodes[i] = this.createNode(i);
            this.simulate();
            this.processNode(i, this.nodes[i]);
            this.simulate();
            System.out.println("Created node " + i + " with id " + ((PastryNode)this.nodes[i]).getNodeId());
        }
    }

    public void start() {
        this.createNodes();
        System.out.println("\nTest Beginning\n");
        this.runTest();
    }

    protected void simulate() {
        if (PROTOCOL == -138) {
            while (this.simulator.simulate()) {
            }
        } else {
            this.pause(500);
        }
    }

    protected Node createNode(int num) {
        if (num == 0) {
            return this.factory.newNode(null);
        }
        return this.factory.newNode(this.getBootstrap());
    }

    protected synchronized void pause(int ms) {
        if (PROTOCOL != -138) {
            try {
                this.wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void kill(int n) {
        if (PROTOCOL == -138) {
            this.simulator.setAlive((NodeId)this.nodes[n].getId(), false);
        }
    }

    protected abstract void processNode(int var1, Node var2);

    protected abstract void runTest();

    protected final void sectionStart(String name) {
        System.out.println(name);
    }

    protected final void sectionDone() {
        System.out.println();
    }

    protected final void stepStart(String name) {
        System.out.print(this.pad("  " + name));
    }

    protected final void stepDone() {
        this.stepDone(SUCCESS);
    }

    protected final void stepDone(String status) {
        this.stepDone(status, "");
    }

    protected final void stepDone(String status, String message) {
        System.out.println("[" + status + "]");
        if (message != null && !message.equals("")) {
            System.out.println("     " + message);
        }
        if (status.equals(FAILURE)) {
            System.exit(0);
        }
    }

    protected final void stepException(Exception e) {
        System.out.println("\nException " + e + " occurred during testing.");
        e.printStackTrace();
        System.exit(0);
    }

    private final String pad(String start) {
        if (start.length() >= 60) {
            return start.substring(0, 60);
        }
        int spaceLength = 60 - start.length();
        char[] spaces = new char[spaceLength];
        Arrays.fill(spaces, '.');
        return start.concat(new String(spaces));
    }

    protected final void assertTrue(String intention, boolean test) {
        if (!test) {
            this.stepDone(FAILURE, "Assertion '" + intention + "' failed.");
        }
    }

    protected final void assertEquals(String description, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            this.stepDone(FAILURE, "Assertion '" + description + "' failed, expected: '" + expected + "' got: " + actual + "'");
        }
    }

    protected static void parseArgs(String[] args) {
        int p;
        int i;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: DistCommonAPITest [-port p] [-protocol (rmi|wire)] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-nodes") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            NUM_NODES = p;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            PORT = p;
            break;
        }
        BOOTSTRAP_PORT = PORT;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bootstrap") || i + 1 >= args.length) continue;
            String str = args[i + 1];
            int index = str.indexOf(58);
            if (index == -1) {
                BOOTSTRAP_HOST = str;
                BOOTSTRAP_PORT = PORT;
                break;
            }
            BOOTSTRAP_HOST = str.substring(0, index);
            BOOTSTRAP_PORT = Integer.parseInt(str.substring(index + 1));
            if (BOOTSTRAP_PORT > 0) break;
            BOOTSTRAP_PORT = PORT;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-protocol") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("socket")) {
                PROTOCOL = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            if (s.equalsIgnoreCase("direct")) {
                PROTOCOL = -138;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + s);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-simulator") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("sphere")) {
                SIMULATOR = -1;
                break;
            }
            if (s.equalsIgnoreCase("euclidean")) {
                SIMULATOR = -2;
                break;
            }
            System.out.println("ERROR: Unsupported simulator: " + s);
            break;
        }
    }

    static {
        try {
            BOOTSTRAP_HOST = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.out.println("Error determining local host: " + e);
        }
    }
}

