/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import rice.p2p.commonapi.Id;
import rice.p2p.glacier.VersionKey;
import rice.p2p.util.MathUtils;

public class FragmentKey
implements Id,
Comparable {
    protected VersionKey key;
    protected int id;
    private static final long serialVersionUID = 5373228569261524536L;

    public FragmentKey(VersionKey key, int id) {
        this.id = id;
        this.key = key;
    }

    public boolean isBetween(Id ccw, Id cw) {
        System.err.println("FragmentKey::isBetween() called");
        System.exit(1);
        return false;
    }

    public VersionKey getVersionKey() {
        return this.key;
    }

    public int getFragmentID() {
        return this.id;
    }

    public FragmentKey getPeerKey(int otherId) {
        return new FragmentKey(this.key, otherId);
    }

    public int getByteArrayLength() {
        return this.key.getByteArrayLength() + 4;
    }

    public boolean equals(Object peer) {
        if (!(peer instanceof FragmentKey)) {
            return false;
        }
        FragmentKey sk = (FragmentKey)peer;
        return sk.key.equals(this.key) && sk.id == this.id;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.getByteArrayLength()];
        this.toByteArray(result, 0);
        return result;
    }

    public void toByteArray(byte[] result, int offset) {
        this.key.toByteArray(result, offset);
        MathUtils.intToByteArray(this.id, result, offset + this.key.getByteArrayLength());
    }

    public String toStringFull() {
        return this.key.toStringFull() + "#" + this.id;
    }

    public String toString() {
        return this.key.toString() + "#" + this.id;
    }

    public Id.Distance longDistanceFromId(Id nid) {
        System.err.println("FragmentKey::longDistanceFromId() called");
        System.exit(1);
        return null;
    }

    public Id.Distance distanceFromId(Id nid) {
        System.err.println("FragmentKey::distanceFromId() called");
        System.exit(1);
        return null;
    }

    public Id addToId(Id.Distance offset) {
        System.err.println("FragmentKey::addToId() called");
        System.exit(1);
        return null;
    }

    public boolean clockwise(Id nid) {
        System.err.println("FragmentKey::clockwise() called");
        System.exit(1);
        return false;
    }

    public int compareTo(Object o) {
        int keyResult = this.key.compareTo(((FragmentKey)o).key);
        if (keyResult != 0) {
            return keyResult;
        }
        if (this.id < ((FragmentKey)o).id) {
            return -1;
        }
        if (this.id > ((FragmentKey)o).id) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.key.hashCode() + this.id;
    }
}

