/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.util.Iterator;
import java.util.SortedMap;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.FragmentKeyRange;
import rice.p2p.util.RedBlackMap;

public class FragmentKeySet
implements IdSet {
    private SortedMap idSet;
    private FragmentKey cachedHash;
    private boolean validHash;

    public FragmentKeySet() {
        this.idSet = new RedBlackMap();
        this.validHash = false;
    }

    public FragmentKeySet(FragmentKeySet o) {
        this.idSet = new RedBlackMap(o.idSet);
        this.cachedHash = o.cachedHash;
        this.validHash = o.validHash;
    }

    protected FragmentKeySet(SortedMap s) {
        this.idSet = s;
        this.validHash = false;
    }

    public boolean isMember(Id id) {
        return this.idSet.containsKey(id);
    }

    public Iterator getIterator() {
        return this.idSet.keySet().iterator();
    }

    public byte[] getHash() {
        System.err.println("FragmentKeySet.getHash() called");
        System.exit(1);
        return null;
    }

    public boolean isMemberId(Id id) {
        return this.isMember(id);
    }

    public int numElements() {
        return this.idSet.size();
    }

    public void addMember(Id id) {
        this.idSet.put(id, null);
        this.validHash = false;
    }

    public void removeMember(Id id) {
        this.idSet.remove(id);
        this.validHash = false;
    }

    public FragmentKey minMember() {
        return (FragmentKey)this.idSet.firstKey();
    }

    public FragmentKey maxMember() {
        return (FragmentKey)this.idSet.lastKey();
    }

    public FragmentKeySet subSet(Id from, Id to) {
        return new FragmentKeySet(this.idSet.subMap(from, to));
    }

    public FragmentKeySet subSet(FragmentKeyRange range) {
        if (range.isEmpty()) {
            return new FragmentKeySet();
        }
        if (range.getCCWId().equals(range.getCWId())) {
            return this;
        }
        return this.subSet(range.getCCWId(), range.getCWId());
    }

    public String toString() {
        Iterator it = this.getIterator();
        String s = "[ IdSet: ";
        while (it.hasNext()) {
            Id key = (Id)it.next();
            s = s + key + ",";
        }
        s = s + " ]";
        return s;
    }

    public void addId(Id id) {
        this.addMember(id);
    }

    public void removeId(Id id) {
        this.removeMember((FragmentKey)id);
    }

    public IdSet subSet(IdRange range) {
        return this.subSet((FragmentKeyRange)range);
    }

    public byte[] hash() {
        return this.getHash();
    }

    public Object clone() {
        return new FragmentKeySet(this);
    }

    public IdSet build() {
        return new FragmentKeySet();
    }

    public Id[] asArray() {
        return this.idSet.keySet().toArray(new Id[0]);
    }
}

