/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.io.Serializable;
import rice.p2p.commonapi.Id;
import rice.p2p.multiring.RingId;
import rice.p2p.util.MathUtils;

public class VersionKey
implements Id,
Serializable,
Comparable {
    protected Id id;
    protected long version;
    private static final long serialVersionUID = -7473630685140924130L;

    public VersionKey(Id id, long version) {
        this.id = id;
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public Id getId() {
        return this.id;
    }

    public int getByteArrayLength() {
        return this.id.getByteArrayLength() + 8;
    }

    public boolean isBetween(Id ccw, Id cw) {
        System.err.println("VersionKey::isBetween() called");
        System.exit(1);
        return false;
    }

    public boolean equals(Object peer) {
        if (!(peer instanceof VersionKey)) {
            return false;
        }
        VersionKey fk = (VersionKey)peer;
        return fk.version == this.version && fk.id.equals(this.id);
    }

    public String toString() {
        return this.id.toString() + "v" + this.version;
    }

    public String toStringFull() {
        return this.id.toStringFull() + "v" + this.version;
    }

    public int compareTo(Object o) {
        int idResult = this.id.compareTo(((VersionKey)o).id);
        if (idResult != 0) {
            return idResult;
        }
        if (this.version - ((VersionKey)o).version < 0L) {
            return -1;
        }
        if (this.version - ((VersionKey)o).version > 0L) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.id.hashCode() + new Long(this.version).hashCode();
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.getByteArrayLength()];
        this.toByteArray(result, 0);
        return result;
    }

    public void toByteArray(byte[] result, int offset) {
        this.id.toByteArray(result, offset);
        MathUtils.longToByteArray(this.version, result, offset + this.id.getByteArrayLength());
    }

    public Id.Distance longDistanceFromId(Id nid) {
        System.err.println("VersionKey::longDistanceFromId() called");
        System.exit(1);
        return null;
    }

    public Id.Distance distanceFromId(Id nid) {
        System.err.println("VersionKey::distanceFromId() called");
        System.exit(1);
        return null;
    }

    public Id addToId(Id.Distance offset) {
        System.err.println("VersionKey::addToId() called");
        System.exit(1);
        return null;
    }

    public boolean clockwise(Id nid) {
        System.err.println("VersionKey::clockwise() called");
        System.exit(1);
        return false;
    }

    public static VersionKey build(String s) {
        String[] sArray = s.split("v");
        return new VersionKey(RingId.build(sArray[0]), Long.parseLong(sArray[1]));
    }
}

