/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.glacier.Fragment;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.FragmentKeySet;
import rice.p2p.glacier.Glacier;
import rice.p2p.glacier.GlacierException;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.glacier.v2.BloomFilter;
import rice.p2p.glacier.v2.FragmentAndManifest;
import rice.p2p.glacier.v2.FragmentMetadata;
import rice.p2p.glacier.v2.GlacierContentHandle;
import rice.p2p.glacier.v2.GlacierContinuation;
import rice.p2p.glacier.v2.GlacierImpl;
import rice.p2p.glacier.v2.GlacierNotEnoughFragmentsException;
import rice.p2p.glacier.v2.GlacierPolicy;
import rice.p2p.glacier.v2.GlacierStatistics;
import rice.p2p.glacier.v2.GlacierStatisticsListener;
import rice.p2p.glacier.v2.Manifest;
import rice.p2p.glacier.v2.messaging.GlacierDataMessage;
import rice.p2p.glacier.v2.messaging.GlacierFetchMessage;
import rice.p2p.glacier.v2.messaging.GlacierMessage;
import rice.p2p.glacier.v2.messaging.GlacierNeighborRequestMessage;
import rice.p2p.glacier.v2.messaging.GlacierNeighborResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierQueryMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeForwardMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeQueryMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshCompleteMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshPatchMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshProbeMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierSyncMessage;
import rice.p2p.glacier.v2.messaging.GlacierTimeoutMessage;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.util.DebugCommandHandler;
import rice.persistence.PersistentStorage;
import rice.persistence.Storage;
import rice.persistence.StorageManager;

public class GlacierImpl
implements Glacier,
Past,
GCPast,
VersioningPast,
Application,
DebugCommandHandler {
    protected final StorageManager fragmentStorage;
    protected final StorageManager neighborStorage;
    protected final GlacierPolicy policy;
    protected final Node node;
    protected final int numFragments;
    protected final String instance;
    protected final int numSurvivors;
    protected final Endpoint endpoint;
    protected final IdFactory factory;
    protected final Hashtable continuations;
    protected final Hashtable pendingTraffic;
    protected final String debugID;
    protected final Random random;
    protected StorageManager trashStorage;
    protected long nextContinuationTimeout;
    protected IdRange responsibleRange;
    protected int nextUID;
    protected CancellableTask timer;
    protected GlacierStatistics statistics;
    protected Vector listeners;
    protected long currentFragmentRequestTimeout;
    protected long tokenBucket;
    protected long bucketLastUpdated;
    protected long bucketMin;
    protected long bucketMax;
    protected long bucketConsumed;
    private int loglevel = 2;
    private final boolean logStatistics = true;
    private final boolean faultInjectionEnabled = false;
    private final long SECONDS = 1000L;
    private final long MINUTES = 60000L;
    private final long HOURS = 3600000L;
    private final long DAYS = 86400000L;
    private final long WEEKS = 604800000L;
    private final long insertTimeout = 30000L;
    private final double minFragmentsAfterInsert = 3.0;
    private final long refreshTimeout = 30000L;
    private final long expireNeighborsDelayAfterJoin = 30000L;
    private final long expireNeighborsInterval = 300000L;
    private long neighborTimeout = 432000000L;
    private final long syncDelayAfterJoin = 30000L;
    private final long syncMinRemainingLifetime = 300000L;
    private final long syncMinQuietTime = 30000L;
    private final int syncBloomFilterNumHashes = 3;
    private final int syncBloomFilterBitsPerKey = 4;
    private final int syncPartnersPerTrial = 1;
    private long syncInterval = 3600000L;
    private final long syncRetryInterval = 180000L;
    private int syncMaxFragments = 100;
    private final int fragmentRequestMaxAttempts = 0;
    private final long fragmentRequestTimeoutDefault = 10000L;
    private final long fragmentRequestTimeoutMin = 10000L;
    private final long fragmentRequestTimeoutMax = 60000L;
    private final long fragmentRequestTimeoutDecrement = 1000L;
    private final long manifestRequestTimeout = 10000L;
    private final long manifestRequestInitialBurst = 3L;
    private final long manifestRequestRetryBurst = 5L;
    private final int manifestAggregationFactor = 5;
    private final long overallRestoreTimeout = 180000L;
    private final long handoffDelayAfterJoin = 45000L;
    private final long handoffInterval = 240000L;
    private final int handoffMaxFragments = 10;
    private final long garbageCollectionInterval = 600000L;
    private final int garbageCollectionMaxFragmentsPerRun = 100;
    private final long localScanInterval = 600000L;
    private final int localScanMaxFragmentsPerRun = 20;
    private final double restoreMaxRequestFactor = 4.0;
    private final int restoreMaxBoosts = 2;
    private final long rateLimitedCheckInterval = 30000L;
    private int rateLimitedRequestsPerSecond = 3;
    private final boolean enableBulkRefresh = true;
    private final long bulkRefreshProbeInterval = 3000L;
    private final double bulkRefreshMaxProbeFactor = 3.0;
    private final long bulkRefreshManifestInterval = 30000L;
    private final int bulkRefreshManifestAggregationFactor = 20;
    private final int bulkRefreshPatchAggregationFactor = 50;
    private final long bulkRefreshPatchInterval = 180000L;
    private final int bulkRefreshPatchRetries = 2;
    private long bucketTokensPerSecond = 100000L;
    private long bucketMaxBurstSize = 200000L;
    private final double jitterRange = 0.1;
    private final long statisticsReportInterval = 60000L;
    private final int maxActiveRestores = 3;
    private int[] numActiveRestores;
    private final char tagNeighbor = '\u0001';
    private final char tagSync = (char)2;
    private final char tagSyncManifests = (char)3;
    private final char tagSyncFetch = (char)4;
    private final char tagHandoff = (char)5;
    private final char tagDebug = (char)6;
    private final char tagRefresh = (char)7;
    private final char tagInsert = (char)8;
    private final char tagLookupHandles = (char)9;
    private final char tagLookup = (char)10;
    private final char tagFetch = (char)11;
    private final char tagLocalScan = (char)12;
    private final char tagMax = (char)13;
    public static final boolean verbose = false;

    public GlacierImpl(Node nodeArg, StorageManager fragmentStorageArg, StorageManager neighborStorageArg, int numFragmentsArg, int numSurvivorsArg, IdFactory factoryArg, String instanceArg, GlacierPolicy policyArg) {
        this.fragmentStorage = fragmentStorageArg;
        this.neighborStorage = neighborStorageArg;
        this.trashStorage = null;
        this.policy = policyArg;
        this.node = nodeArg;
        this.instance = instanceArg;
        this.endpoint = this.node.registerApplication(this, this.instance);
        this.numFragments = numFragmentsArg;
        this.numSurvivors = numSurvivorsArg;
        this.factory = factoryArg;
        this.responsibleRange = null;
        this.nextUID = 0;
        this.continuations = new Hashtable();
        this.pendingTraffic = new Hashtable();
        this.random = new Random();
        this.timer = null;
        this.nextContinuationTimeout = -1L;
        this.statistics = new GlacierStatistics(13);
        this.listeners = new Vector();
        this.numActiveRestores = new int[1];
        this.numActiveRestores[0] = 0;
        this.currentFragmentRequestTimeout = 10000L;
        this.debugID = "G" + Character.toUpperCase(this.instance.charAt(this.instance.lastIndexOf(45) + 1));
        this.tokenBucket = 0L;
        this.bucketLastUpdated = System.currentTimeMillis();
        this.determineResponsibleRange();
    }

    private byte[] getHashInput(VersionKey vkey, long expiration) {
        byte[] a = vkey.toByteArray();
        byte[] b = new byte[a.length + 8];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        b[a.length + 0] = (byte)(0xFFL & expiration >> 56);
        b[a.length + 1] = (byte)(0xFFL & expiration >> 48);
        b[a.length + 2] = (byte)(0xFFL & expiration >> 40);
        b[a.length + 3] = (byte)(0xFFL & expiration >> 32);
        b[a.length + 4] = (byte)(0xFFL & expiration >> 24);
        b[a.length + 5] = (byte)(0xFFL & expiration >> 16);
        b[a.length + 6] = (byte)(0xFFL & expiration >> 8);
        b[a.length + 7] = (byte)(0xFFL & expiration);
        return b;
    }

    private String getLogPrefix() {
        return "COUNT: " + System.currentTimeMillis() + " " + this.debugID;
    }

    protected int getUID() {
        return this.nextUID++;
    }

    private Id getFragmentLocation(Id objectKey, int fragmentNr, long version) {
        double totalOffset = (double)((float)fragmentNr / (float)this.numFragments) + (double)version * 0.36787940442237393;
        return objectKey.addToId(this.factory.buildIdDistance(GlacierImpl.getDistance(totalOffset - Math.floor(totalOffset))));
    }

    private Id getFragmentLocation(FragmentKey fkey) {
        return this.getFragmentLocation(fkey.getVersionKey().getId(), fkey.getFragmentID(), fkey.getVersionKey().getVersion());
    }

    public Id[][] getNeighborRanges() {
        Iterator iter = this.neighborStorage.scan().getIterator();
        Vector<Id> ccwIDs = new Vector<Id>();
        Vector<Id> cwIDs = new Vector<Id>();
        Id myID = this.getLocalNodeHandle().getId();
        while (iter.hasNext()) {
            Id thisNeighbor = (Id)iter.next();
            if (myID.clockwise(thisNeighbor)) {
                cwIDs.add(thisNeighbor);
                continue;
            }
            ccwIDs.add(thisNeighbor);
        }
        for (int j = 0; j < 2; ++j) {
            Vector<Id> v = j == 0 ? cwIDs : ccwIDs;
            boolean madeProgress = true;
            while (madeProgress) {
                madeProgress = false;
                for (int i = 0; i < v.size() - 1; ++i) {
                    if (!((Id)v.elementAt(i + 1)).clockwise((Id)v.elementAt(i))) continue;
                    Object h = v.elementAt(i);
                    v.setElementAt((Id)v.elementAt(i + 1), i);
                    v.setElementAt((Id)h, i + 1);
                    madeProgress = true;
                }
            }
        }
        Vector<Id> allIDs = new Vector<Id>();
        allIDs.addAll(ccwIDs);
        allIDs.add(myID);
        allIDs.addAll(cwIDs);
        Id[][] result = new Id[allIDs.size()][3];
        for (int i = 0; i < allIDs.size(); ++i) {
            Id cwId;
            Id ccwId;
            Id currentElement = (Id)allIDs.elementAt(i);
            if (i > 0) {
                Id previousElement = (Id)allIDs.elementAt(i - 1);
                ccwId = previousElement.addToId(previousElement.distanceFromId(currentElement).shiftDistance(1, 0));
            } else {
                ccwId = currentElement;
            }
            if (i < allIDs.size() - 1) {
                Id nextElement = (Id)allIDs.elementAt(i + 1);
                cwId = currentElement.addToId(currentElement.distanceFromId(nextElement).shiftDistance(1, 0));
            } else {
                cwId = currentElement;
            }
            result[i][0] = ccwId;
            result[i][1] = currentElement;
            result[i][2] = cwId;
        }
        return result;
    }

    public int getReplicationFactor() {
        return 1;
    }

    public NodeHandle getLocalNodeHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public long getTrashSize() {
        if (this.trashStorage == null) {
            return 0L;
        }
        return this.trashStorage.getStorage().getTotalSize();
    }

    public void setTrashcan(StorageManager trashStorage) {
        this.trashStorage = trashStorage;
    }

    private void setTimer(int timeoutMsec) {
        this.timer = this.endpoint.scheduleMessage(new GlacierTimeoutMessage(0, this.getLocalNodeHandle()), timeoutMsec);
    }

    public void setSyncInterval(int syncIntervalSec) {
        this.syncInterval = (long)syncIntervalSec * 1000L;
    }

    public void setSyncMaxFragments(int syncMaxFragments) {
        this.syncMaxFragments = syncMaxFragments;
    }

    public void setRateLimit(int rps) {
        this.rateLimitedRequestsPerSecond = rps;
    }

    public void setNeighborTimeout(long neighborTimeoutMin) {
        this.neighborTimeout = neighborTimeoutMin * 60000L;
    }

    public void setBandwidthLimit(long bytesPerSecond, long maxBurst) {
        this.bucketTokensPerSecond = bytesPerSecond;
        this.bucketMaxBurstSize = maxBurst;
    }

    public void setLogLevel(int newLevel) {
        this.loglevel = newLevel;
    }

    public void startup() {
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Neighbor continuation";
            }

            public void init() {
                NodeHandle localHandle;
                this.nextTimeout = System.currentTimeMillis() + 30000L;
                NodeHandleSet leafSet = GlacierImpl.this.endpoint.neighborSet(999);
                NodeHandle cwExtreme = localHandle = GlacierImpl.this.getLocalNodeHandle();
                NodeHandle ccwExtreme = localHandle;
                for (int i = 0; i < leafSet.size(); ++i) {
                    NodeHandle thisHandle = leafSet.getHandle(i);
                    if (localHandle.getId().clockwise(thisHandle.getId())) {
                        if (!cwExtreme.getId().clockwise(thisHandle.getId())) continue;
                        cwExtreme = thisHandle;
                        continue;
                    }
                    if (!ccwExtreme.getId().clockwise(thisHandle.getId())) continue;
                    ccwExtreme = thisHandle;
                }
                IdRange leafRange = GlacierImpl.this.factory.buildIdRange(ccwExtreme.getId(), cwExtreme.getId());
                for (int k = 0; k < leafSet.size(); ++k) {
                    if (leafSet.getHandle(k).getId().equals(GlacierImpl.this.getLocalNodeHandle().getId())) continue;
                    GlacierImpl.this.neighborSeen(leafSet.getHandle(k).getId(), System.currentTimeMillis());
                    GlacierImpl.this.log(2, "Asking " + leafSet.getHandle(k).getId() + " about neighbors in " + leafRange);
                    GlacierImpl.this.sendMessage(null, new GlacierNeighborRequestMessage(this.getMyUID(), leafRange, GlacierImpl.this.getLocalNodeHandle(), leafSet.getHandle(k).getId(), '\u0001'), leafSet.getHandle(k));
                }
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierNeighborResponseMessage) {
                    GlacierNeighborResponseMessage gnrm = (GlacierNeighborResponseMessage)o;
                    GlacierImpl.this.log(3, "NeighborResponse from " + gnrm.getSource() + " with " + gnrm.numNeighbors() + " neighbors");
                    for (int i = 0; i < gnrm.numNeighbors(); ++i) {
                        GlacierImpl.this.neighborSeen(gnrm.getNeighbor(i), gnrm.getLastSeen(i));
                    }
                } else {
                    GlacierImpl.this.warn("Unknown response in neighbor continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception in neighbor continuation: " + e);
                e.printStackTrace();
                this.terminate();
            }

            public void timeoutExpired() {
                this.nextTimeout = System.currentTimeMillis() + 300000L;
                long earliestAcceptableDate = System.currentTimeMillis() - GlacierImpl.this.neighborTimeout;
                IdSet allNeighbors = GlacierImpl.this.neighborStorage.scan();
                Iterator iter = allNeighbors.getIterator();
                NodeHandleSet leafSet = GlacierImpl.this.endpoint.neighborSet(999);
                GlacierImpl.this.log(2, "Checking neighborhood for expired certificates...");
                while (iter.hasNext()) {
                    Id thisNeighbor = (Id)iter.next();
                    if (leafSet.memberHandle(thisNeighbor)) {
                        GlacierImpl.this.log(3, "CNE: Refreshing current neighbor: " + thisNeighbor);
                        GlacierImpl.this.neighborSeen(thisNeighbor, System.currentTimeMillis());
                        continue;
                    }
                    GlacierImpl.this.log(3, "CNE: Retrieving " + thisNeighbor);
                    GlacierImpl.this.neighborStorage.getObject(thisNeighbor, new Continuation(this, thisNeighbor, earliestAcceptableDate){
                        private final /* synthetic */ Id val$thisNeighbor;
                        private final /* synthetic */ long val$earliestAcceptableDate;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$thisNeighbor = val$thisNeighbor;
                            this.val$earliestAcceptableDate = val$earliestAcceptableDate;
                        }

                        public void receiveResult(Object o) {
                            if (o == null) {
                                GlacierImpl.access$100(1.access$300(this.this$1), "CNE: Cannot retrieve neighbor " + this.val$thisNeighbor);
                                return;
                            }
                            long lastSeen = (Long)o;
                            if (lastSeen < this.val$earliestAcceptableDate) {
                                GlacierImpl.access$000(1.access$300(this.this$1), 2, "CNE: Removing expired neighbor " + this.val$thisNeighbor + " (" + lastSeen + "<" + this.val$earliestAcceptableDate + ")");
                                1.access$300(this.this$1).neighborStorage.unstore(this.val$thisNeighbor, new Continuation(this){
                                    private final /* synthetic */ 2 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void receiveResult(Object o) {
                                        GlacierImpl.access$000(1.access$300(2.access$500(this.this$2)), 3, "CNE unstore successful: " + 2.access$400(this.this$2) + ", returned " + o);
                                    }

                                    public void receiveException(Exception e) {
                                        GlacierImpl.access$100(1.access$300(2.access$500(this.this$2)), "CNE unstore failed: " + 2.access$400(this.this$2) + ", returned " + e);
                                    }
                                });
                            } else {
                                GlacierImpl.access$000(1.access$300(this.this$1), 2, "CNE: Neighbor " + this.val$thisNeighbor + " still active, last seen " + lastSeen);
                            }
                        }

                        public void receiveException(Exception e) {
                            GlacierImpl.access$000(1.access$300(this.this$1), 1, "CNE: Exception while retrieving neighbor " + this.val$thisNeighbor + ", e=" + e);
                        }

                        static /* synthetic */ Id access$400(2 x0) {
                            return x0.val$thisNeighbor;
                        }

                        static /* synthetic */ 1 access$500(2 x0) {
                            return x0.this$1;
                        }
                    });
                }
                GlacierImpl.this.determineResponsibleRange();
            }

            static /* synthetic */ GlacierImpl access$300(1 x0) {
                return x0.GlacierImpl.this;
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;
            int offset;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Sync continuation";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 30000L;
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierRangeResponseMessage) {
                    GlacierRangeResponseMessage grrm = (GlacierRangeResponseMessage)o;
                    Id ccwId = GlacierImpl.this.getFragmentLocation(grrm.getCommonRange().getCCWId(), GlacierImpl.this.numFragments - this.offset, 0L);
                    Id cwId = GlacierImpl.this.getFragmentLocation(grrm.getCommonRange().getCWId(), GlacierImpl.this.numFragments - this.offset, 0L);
                    IdRange originalRange = GlacierImpl.this.factory.buildIdRange(ccwId, cwId);
                    GlacierImpl.this.log(2, "Range response (offset: " + this.offset + "): " + grrm.getCommonRange() + ", original=" + originalRange);
                    IdSet keySet = GlacierImpl.this.fragmentStorage.scan();
                    GlacierImpl.this.endpoint.process(new Executable(this, keySet, originalRange){
                        private final /* synthetic */ IdSet val$keySet;
                        private final /* synthetic */ IdRange val$originalRange;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$keySet = val$keySet;
                            this.val$originalRange = val$originalRange;
                        }

                        public Object execute() {
                            BloomFilter bv = new BloomFilter((2 * this.val$keySet.numElements() + 5) * 4, 3);
                            Iterator iter = this.val$keySet.getIterator();
                            while (iter.hasNext()) {
                                FragmentKey fkey = (FragmentKey)iter.next();
                                Id thisPos = GlacierImpl.access$900(4.access$800(this.this$1), fkey);
                                if (!this.val$originalRange.containsId(thisPos)) continue;
                                FragmentMetadata metadata = (FragmentMetadata)4.access$800(this.this$1).fragmentStorage.getMetadata(fkey);
                                if (metadata != null) {
                                    long currentExp = metadata.getCurrentExpiration();
                                    long prevExp = metadata.getPreviousExpiration();
                                    GlacierImpl.access$000(4.access$800(this.this$1), 4, " - Adding " + fkey + " as " + fkey.getVersionKey().getId() + ", ecur=" + currentExp + ", eprev=" + prevExp);
                                    bv.add(GlacierImpl.access$1000(4.access$800(this.this$1), fkey.getVersionKey(), currentExp));
                                    bv.add(GlacierImpl.access$1000(4.access$800(this.this$1), fkey.getVersionKey(), prevExp));
                                    continue;
                                }
                                GlacierImpl.access$100(4.access$800(this.this$1), "SYNC Cannot read metadata of object " + fkey.toStringFull() + ", storage returned null");
                            }
                            return bv;
                        }
                    }, new Continuation(this, keySet, grrm){
                        private final /* synthetic */ IdSet val$keySet;
                        private final /* synthetic */ GlacierRangeResponseMessage val$grrm;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$keySet = val$keySet;
                            this.val$grrm = val$grrm;
                        }

                        public void receiveResult(Object o) {
                            if (o instanceof BloomFilter) {
                                BloomFilter bv = (BloomFilter)o;
                                GlacierImpl.access$000(4.access$800(this.this$1), 3, "Got " + bv);
                                GlacierImpl.access$000(4.access$800(this.this$1), 2, this.val$keySet.numElements() + " keys added, sending sync request...");
                                4.access$800(this.this$1).sendMessage(null, new GlacierSyncMessage(4.access$800(this.this$1).getUID(), this.val$grrm.getCommonRange(), this.this$1.offset, bv, 4.access$800(this.this$1).getLocalNodeHandle(), this.val$grrm.getSource().getId(), '\u0002'), this.val$grrm.getSource());
                            } else {
                                GlacierImpl.access$100(4.access$800(this.this$1), "While processing range response: Result is of unknown type: " + o + " -- discarding request");
                            }
                        }

                        public void receiveException(Exception e) {
                            GlacierImpl.access$100(4.access$800(this.this$1), "Exception while processing range response: " + e + " -- discarding request");
                            e.printStackTrace();
                        }
                    });
                } else {
                    GlacierImpl.this.warn("Unknown result in sync continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception in sync continuation: " + e);
                e.printStackTrace();
                this.terminate();
            }

            public void timeoutExpired() {
                if (GlacierImpl.this.numActiveRestores[0] > 0) {
                    GlacierImpl.this.log(2, "Sync postponed; " + GlacierImpl.this.numActiveRestores[0] + " fetches pending");
                    this.nextTimeout = System.currentTimeMillis() + GlacierImpl.this.jitterTerm(180000L);
                } else {
                    this.nextTimeout = System.currentTimeMillis() + GlacierImpl.this.jitterTerm(GlacierImpl.this.syncInterval);
                    this.offset = 1 + GlacierImpl.this.random.nextInt(GlacierImpl.this.numFragments - 1);
                    Id dest = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.getLocalNodeHandle().getId(), this.offset, 0L);
                    Id ccwId = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.responsibleRange.getCCWId(), this.offset, 0L);
                    Id cwId = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.responsibleRange.getCWId(), this.offset, 0L);
                    IdRange requestedRange = GlacierImpl.this.factory.buildIdRange(ccwId, cwId);
                    GlacierImpl.this.log(2, "Sending range query for (" + requestedRange + ") to " + dest);
                    GlacierImpl.this.sendMessage(dest, new GlacierRangeQueryMessage(this.getMyUID(), requestedRange, GlacierImpl.this.getLocalNodeHandle(), dest, '\u0002'), null);
                }
            }

            static /* synthetic */ GlacierImpl access$800(4 x0) {
                return x0.GlacierImpl.this;
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Handoff continuation";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 45000L;
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierResponseMessage) {
                    GlacierResponseMessage grm = (GlacierResponseMessage)o;
                    GlacierImpl.this.log(3, "Received handoff response from " + grm.getSource().getId() + " with " + grm.numKeys() + " keys");
                    for (int i = 0; i < grm.numKeys(); ++i) {
                        FragmentKey thisKey = grm.getKey(i);
                        if (grm.getAuthoritative(i)) {
                            if (grm.getHaveIt(i)) {
                                Id thisPos = GlacierImpl.this.getFragmentLocation(thisKey);
                                if (!GlacierImpl.this.responsibleRange.containsId(thisPos)) {
                                    GlacierImpl.this.log(3, "Deleting fragment " + thisKey);
                                    GlacierImpl.this.deleteFragment(thisKey, new Continuation(this, thisKey){
                                        private final /* synthetic */ FragmentKey val$thisKey;
                                        private final /* synthetic */ 7 this$1;
                                        {
                                            this.this$1 = this$1;
                                            this.val$thisKey = val$thisKey;
                                        }

                                        public void receiveResult(Object o) {
                                            GlacierImpl.access$000(7.access$1400(this.this$1), 3, "Handed off fragment deleted: " + this.val$thisKey + " (o=" + o + ")");
                                        }

                                        public void receiveException(Exception e) {
                                            GlacierImpl.access$100(7.access$1400(this.this$1), "Delete failed during handoff: " + this.val$thisKey + ", returned " + e);
                                            e.printStackTrace();
                                        }
                                    });
                                    continue;
                                }
                                GlacierImpl.this.warn("Handoff response for " + thisKey + ", for which I am still responsible (attack?) -- ignored");
                                continue;
                            }
                            GlacierImpl.this.fragmentStorage.getObject(thisKey, new Continuation(this, thisKey, grm){
                                private final /* synthetic */ FragmentKey val$thisKey;
                                private final /* synthetic */ GlacierResponseMessage val$grm;
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$thisKey = val$thisKey;
                                    this.val$grm = val$grm;
                                }

                                public void receiveResult(Object o) {
                                    if (o != null) {
                                        GlacierImpl.access$000(7.access$1400(this.this$1), 2, "Fragment " + this.val$thisKey + " found (" + o + "), handing off...");
                                        FragmentAndManifest fam = (FragmentAndManifest)o;
                                        7.access$1400(this.this$1).sendMessage(null, new GlacierDataMessage(this.val$grm.getUID(), this.val$thisKey, fam.fragment, fam.manifest, 7.access$1400(this.this$1).getLocalNodeHandle(), this.val$grm.getSource().getId(), true, '\u0005'), this.val$grm.getSource());
                                    } else {
                                        GlacierImpl.access$100(7.access$1400(this.this$1), "Handoff failed; fragment " + this.val$thisKey + " not found in fragment store");
                                    }
                                }

                                public void receiveException(Exception e) {
                                    GlacierImpl.access$100(7.access$1400(this.this$1), "Handoff failed; exception while fetching " + this.val$thisKey + ", e=" + e);
                                    e.printStackTrace();
                                }
                            });
                            continue;
                        }
                        GlacierImpl.this.log(3, "Ignoring fragment " + thisKey + " (haveIt=" + grm.getHaveIt(i) + ", authoritative=" + grm.getAuthoritative(i) + ")");
                    }
                } else if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    for (int i = 0; i < gdm.numKeys(); ++i) {
                        FragmentKey thisKey = gdm.getKey(i);
                        Fragment thisFragment = gdm.getFragment(i);
                        Manifest thisManifest = gdm.getManifest(i);
                        if (thisFragment != null && thisManifest != null) {
                            GlacierImpl.this.log(2, "Handoff: Received Fragment+Manifest for " + thisKey);
                            if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey))) {
                                GlacierImpl.this.warn("Handoff: Not responsible for " + thisKey + " (at " + GlacierImpl.this.getFragmentLocation(thisKey) + ") -- discarding");
                                continue;
                            }
                            if (!GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                GlacierImpl.this.warn("Handoff: Manifest is not signed properly");
                                continue;
                            }
                            if (!thisManifest.validatesFragment(thisFragment, thisKey.getFragmentID())) {
                                GlacierImpl.this.warn("Handoff: Manifest does not validate this fragment");
                                continue;
                            }
                            if (!GlacierImpl.this.fragmentStorage.exists(thisKey)) {
                                GlacierImpl.this.log(3, "Handoff: Verified ok. Storing locally.");
                                FragmentAndManifest fam = new FragmentAndManifest(thisFragment, thisManifest);
                                GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, System.currentTimeMillis()), fam, new Continuation(this, thisKey, gdm, thisManifest){
                                    private final /* synthetic */ FragmentKey val$thisKey;
                                    private final /* synthetic */ GlacierDataMessage val$gdm;
                                    private final /* synthetic */ Manifest val$thisManifest;
                                    private final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$thisKey = val$thisKey;
                                        this.val$gdm = val$gdm;
                                        this.val$thisManifest = val$thisManifest;
                                    }

                                    public void receiveResult(Object o) {
                                        GlacierImpl.access$000(7.access$1400(this.this$1), 2, "Handoff: Stored OK, sending receipt: " + this.val$thisKey);
                                        7.access$1400(this.this$1).sendMessage(null, new GlacierResponseMessage(this.val$gdm.getUID(), this.val$thisKey, true, this.val$thisManifest.getExpiration(), 7.access$1400(this.this$1).responsibleRange.containsId(GlacierImpl.access$900(7.access$1400(this.this$1), this.val$thisKey)), 7.access$1400(this.this$1).getLocalNodeHandle(), this.val$gdm.getSource().getId(), true, '\u0005'), this.val$gdm.getSource());
                                    }

                                    public void receiveException(Exception e) {
                                        GlacierImpl.access$100(7.access$1400(this.this$1), "Handoff: receiveException(" + e + ") while storing a fragment -- unexpected, ignored (key=" + this.val$thisKey + ")");
                                    }
                                });
                                continue;
                            }
                            GlacierImpl.this.warn("Handoff: We already have a fragment with this key! -- sending response");
                            GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), true, GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, '\u0005'), gdm.getSource());
                            continue;
                        }
                        GlacierImpl.this.warn("Handoff: Either fragment or manifest are missing!");
                    }
                } else {
                    GlacierImpl.this.warn("Unexpected response in handoff continuation: " + o + " -- ignored");
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception in handoff continuation: " + e);
                e.printStackTrace();
            }

            public void timeoutExpired() {
                this.nextTimeout = System.currentTimeMillis() + GlacierImpl.this.jitterTerm(240000L);
                GlacierImpl.this.log(2, "Checking fragment storage for fragments to hand off...");
                GlacierImpl.this.log(3, "Currently responsible for: " + GlacierImpl.this.responsibleRange);
                Iterator iter = GlacierImpl.this.fragmentStorage.scan().getIterator();
                Vector<FragmentKey> handoffs = new Vector<FragmentKey>();
                Id destination = null;
                while (iter.hasNext()) {
                    FragmentKey fkey = (FragmentKey)iter.next();
                    Id thisPos = GlacierImpl.this.getFragmentLocation(fkey);
                    if (GlacierImpl.this.responsibleRange.containsId(thisPos)) continue;
                    GlacierImpl.this.log(3, "Must hand off " + fkey + " @" + thisPos);
                    handoffs.add(fkey);
                    if (handoffs.size() >= 10) {
                        GlacierImpl.this.log(3, "Limit of 10 reached for handoff");
                        break;
                    }
                    if (destination != null) continue;
                    destination = thisPos;
                }
                if (destination == null) {
                    GlacierImpl.this.log(3, "Nothing to hand off -- returning");
                    return;
                }
                int numHandoffs = Math.min(handoffs.size(), 10);
                GlacierImpl.this.log(2, "Handing off " + numHandoffs + " fragments (out of " + handoffs.size() + ")");
                FragmentKey[] keys = new FragmentKey[numHandoffs];
                for (int i = 0; i < numHandoffs; ++i) {
                    keys[i] = (FragmentKey)handoffs.elementAt(i);
                }
                GlacierImpl.this.sendMessage(destination, new GlacierQueryMessage(this.getMyUID(), keys, GlacierImpl.this.getLocalNodeHandle(), destination, '\u0005'), null);
            }

            static /* synthetic */ GlacierImpl access$1400(7 x0) {
                return x0.GlacierImpl.this;
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Garbage collector";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 600000L;
            }

            public void receiveResult(Object o) {
                GlacierImpl.this.warn("GC received object: " + o);
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("GC received exception: " + e);
                e.printStackTrace();
            }

            public void timeoutExpired() {
                this.nextTimeout = System.currentTimeMillis() + 600000L;
                long now = System.currentTimeMillis();
                IdSet fragments = GlacierImpl.this.fragmentStorage.scan();
                int doneSoFar = 0;
                int candidates = 0;
                GlacierImpl.this.log(2, "Garbage collection started at " + now + ", scanning " + fragments.numElements() + " fragment(s)...");
                Iterator iter = fragments.getIterator();
                while (iter.hasNext()) {
                    Id thisKey = (Id)iter.next();
                    FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(thisKey);
                    if (metadata != null) {
                        if (metadata.getCurrentExpiration() >= now) continue;
                        ++candidates;
                        if (doneSoFar >= 100) continue;
                        ++doneSoFar;
                        GlacierImpl.this.deleteFragment(thisKey, new Continuation(this, thisKey, now, metadata){
                            private final /* synthetic */ Id val$thisKey;
                            private final /* synthetic */ long val$now;
                            private final /* synthetic */ FragmentMetadata val$metadata;
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$thisKey = val$thisKey;
                                this.val$now = val$now;
                                this.val$metadata = val$metadata;
                            }

                            public void receiveResult(Object o) {
                                GlacierImpl.access$000(11.access$1600(this.this$1), 2, "GC collected " + this.val$thisKey.toStringFull() + ", expired " + (this.val$now - this.val$metadata.getCurrentExpiration()) + " msec ago");
                            }

                            public void receiveException(Exception e) {
                                GlacierImpl.access$000(11.access$1600(this.this$1), 3, "GC cannot collect " + this.val$thisKey.toStringFull());
                            }
                        });
                        continue;
                    }
                    GlacierImpl.this.warn("GC cannot read metadata in object " + thisKey.toStringFull() + ", storage returned null");
                }
                GlacierImpl.this.log(2, "Garbage collection completed at " + System.currentTimeMillis());
                GlacierImpl.this.log(2, "Found " + candidates + " candidate(s), collected " + doneSoFar);
            }

            static /* synthetic */ GlacierImpl access$1600(11 x0) {
                return x0.GlacierImpl.this;
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Local scan";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 600000L;
            }

            public void receiveResult(Object o) {
                GlacierImpl.this.warn("Local scan received object: " + o);
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Local scan received exception: " + e);
                e.printStackTrace();
            }

            public void timeoutExpired() {
                this.nextTimeout = System.currentTimeMillis() + GlacierImpl.this.jitterTerm(600000L);
                IdSet fragments = GlacierImpl.this.fragmentStorage.scan();
                long now = System.currentTimeMillis();
                TreeSet<VersionKey> queries = new TreeSet<VersionKey>();
                GlacierImpl.this.log(2, "Performing local scan over " + fragments.numElements() + " fragment(s)...");
                Iterator iter = fragments.getIterator();
                while (iter.hasNext()) {
                    FragmentKey thisKey = (FragmentKey)iter.next();
                    FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(thisKey);
                    if (metadata != null && metadata.currentExpirationDate >= now) {
                        Id thisObjectKey = thisKey.getVersionKey().getId();
                        long thisVersion = thisKey.getVersionKey().getVersion();
                        int thisFragmentID = thisKey.getFragmentID();
                        int fidLeft = (thisFragmentID + GlacierImpl.this.numFragments - 1) % GlacierImpl.this.numFragments;
                        int fidRight = (thisFragmentID + 1) % GlacierImpl.this.numFragments;
                        if (GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisObjectKey, fidLeft, thisVersion)) && !fragments.isMemberId(thisKey.getPeerKey(fidLeft))) {
                            GlacierImpl.this.log(4, "Missing: " + thisKey + " L=" + fidLeft);
                            queries.add(thisKey.getVersionKey());
                        }
                        if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisObjectKey, fidRight, thisVersion)) || fragments.isMemberId(thisKey.getPeerKey(fidRight))) continue;
                        GlacierImpl.this.log(4, "Missing: " + thisKey + " R=" + fidRight);
                        queries.add(thisKey.getVersionKey());
                        continue;
                    }
                    GlacierImpl.this.log(4, "Expired, ignoring in local scan: " + thisKey);
                }
                if (!queries.isEmpty()) {
                    int queriesSent;
                    int queriesHere;
                    GlacierImpl.this.log(2, "Local scan completed; " + queries.size() + " objects incomplete in local store");
                    iter = queries.iterator();
                    for (queriesSent = 0; iter.hasNext() && queriesSent < 20; queriesSent += queriesHere) {
                        VersionKey thisVKey = (VersionKey)iter.next();
                        int localFragmentID = 0;
                        queriesHere = 0;
                        for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                            FragmentKey keyHere = new FragmentKey(thisVKey, i);
                            if (fragments.isMemberId(keyHere)) {
                                localFragmentID = i;
                                break;
                            }
                            if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(keyHere))) continue;
                            ++queriesHere;
                        }
                        GlacierImpl.this.log(3, "Local scan: Fetching manifest for " + thisVKey + " (" + queriesHere + " pending queries)");
                        GlacierImpl.this.fragmentStorage.getObject(new FragmentKey(thisVKey, localFragmentID), new Continuation(this, thisVKey, fragments){
                            private final /* synthetic */ VersionKey val$thisVKey;
                            private final /* synthetic */ IdSet val$fragments;
                            private final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$thisVKey = val$thisVKey;
                                this.val$fragments = val$fragments;
                            }

                            public void receiveResult(Object o) {
                                if (o instanceof FragmentAndManifest) {
                                    Manifest thisManifest = ((FragmentAndManifest)o).manifest;
                                    for (int i = 0; i < 13.access$1700(this.this$1).numFragments; ++i) {
                                        FragmentKey thisKey = new FragmentKey(this.val$thisVKey, i);
                                        if (!13.access$1700(this.this$1).responsibleRange.containsId(GlacierImpl.access$900(13.access$1700(this.this$1), thisKey)) || this.val$fragments.isMemberId(thisKey)) continue;
                                        GlacierImpl.access$000(13.access$1700(this.this$1), 3, "Local scan: Sending query for " + thisKey);
                                        long tStart = System.currentTimeMillis();
                                        13.access$1700(this.this$1).rateLimitedRetrieveFragment(thisKey, thisManifest, '\f', new GlacierContinuation(this, tStart, thisKey, thisManifest){
                                            private final /* synthetic */ long val$tStart;
                                            private final /* synthetic */ FragmentKey val$thisKey;
                                            private final /* synthetic */ Manifest val$thisManifest;
                                            private final /* synthetic */ 14 this$2;
                                            {
                                                this.this$2 = this$2;
                                                this.val$tStart = val$tStart;
                                                this.val$thisKey = val$thisKey;
                                                this.val$thisManifest = val$thisManifest;
                                            }

                                            public long getTimeout() {
                                                return this.val$tStart + 180000L;
                                            }

                                            public String toString() {
                                                return "Local scan: Fetch fragment: " + this.val$thisKey;
                                            }

                                            public void receiveResult(Object o) {
                                                if (o instanceof Fragment) {
                                                    GlacierImpl.access$000(13.access$1700(14.access$1800(this.this$2)), 2, "Local scan: Received fragment " + this.val$thisKey + " (from primary) matches existing manifest, storing...");
                                                    FragmentAndManifest fam = new FragmentAndManifest((Fragment)o, this.val$thisManifest);
                                                    13.access$1700(14.access$1800(this.this$2)).fragmentStorage.store(this.val$thisKey, new FragmentMetadata(this.val$thisManifest.getExpiration(), 0L, System.currentTimeMillis()), fam, new Continuation(this){
                                                        private final /* synthetic */ 15 this$3;
                                                        {
                                                            this.this$3 = this$3;
                                                        }

                                                        public void receiveResult(Object o) {
                                                            GlacierImpl.access$000(13.access$1700(14.access$1800(15.access$1900(this.this$3))), 3, "Local scan: Recovered fragment stored OK");
                                                        }

                                                        public void receiveException(Exception e) {
                                                            GlacierImpl.access$100(13.access$1700(14.access$1800(15.access$1900(this.this$3))), "Local scan: receiveException(" + e + ") while storing a fragment with existing manifest (key=" + 15.access$2000(this.this$3) + ")");
                                                        }
                                                    });
                                                } else {
                                                    GlacierImpl.access$100(13.access$1700(14.access$1800(this.this$2)), "Local scan: FS received something other than a fragment: " + o);
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                GlacierImpl.access$100(13.access$1700(14.access$1800(this.this$2)), "Local scan: Exception while recovering synced fragment " + this.val$thisKey + ": " + e);
                                                e.printStackTrace();
                                                this.terminate();
                                            }

                                            public void timeoutExpired() {
                                                GlacierImpl.access$100(13.access$1700(14.access$1800(this.this$2)), "Local scan: Timeout while fetching synced fragment " + this.val$thisKey + " -- aborted");
                                                this.terminate();
                                            }

                                            static /* synthetic */ 14 access$1900(15 x0) {
                                                return x0.this$2;
                                            }

                                            static /* synthetic */ FragmentKey access$2000(15 x0) {
                                                return x0.val$thisKey;
                                            }
                                        });
                                    }
                                } else {
                                    GlacierImpl.access$100(13.access$1700(this.this$1), "Local scan: Cannot retrieve " + this.val$thisVKey + " from local store, received o=" + o);
                                }
                            }

                            public void receiveException(Exception e) {
                                GlacierImpl.access$100(13.access$1700(this.this$1), "Local scan: Cannot retrieve " + this.val$thisVKey + " from local store, exception e=" + e);
                                e.printStackTrace();
                            }

                            static /* synthetic */ 13 access$1800(14 x0) {
                                return x0.this$1;
                            }
                        });
                    }
                    GlacierImpl.this.log(2, queriesSent + " queries sent after local scan");
                } else {
                    GlacierImpl.this.log(2, "Local scan completed; no missing fragments");
                }
            }

            static /* synthetic */ GlacierImpl access$1700(13 x0) {
                return x0.GlacierImpl.this;
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Traffic shaper";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 30000L;
            }

            public void receiveResult(Object o) {
                GlacierImpl.this.warn("TS received object: " + o);
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("TS received exception: " + e);
                e.printStackTrace();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeoutExpired() {
                this.nextTimeout = System.currentTimeMillis() + 1000L;
                if (GlacierImpl.this.pendingTraffic.isEmpty()) {
                    GlacierImpl.this.log(3, "Traffic shaper: Idle");
                    this.nextTimeout += 30000L;
                    return;
                }
                int numCurrentRestores = 0;
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    numCurrentRestores = GlacierImpl.this.numActiveRestores[0];
                }
                GlacierImpl.this.log(2, "Traffic shaper: " + GlacierImpl.this.pendingTraffic.size() + " jobs waiting (" + numCurrentRestores + " active jobs, " + GlacierImpl.this.tokenBucket + " tokens)");
                GlacierImpl.this.updateTokenBucket();
                if (numCurrentRestores < 3 && GlacierImpl.this.tokenBucket > 0L) {
                    for (int i = 0; i < GlacierImpl.this.rateLimitedRequestsPerSecond; ++i) {
                        if (GlacierImpl.this.pendingTraffic.isEmpty()) continue;
                        Enumeration keys = GlacierImpl.this.pendingTraffic.keys();
                        Object thisKey = keys.nextElement();
                        GlacierImpl.this.log(3, "Sending request " + thisKey);
                        Continuation c = (Continuation)GlacierImpl.this.pendingTraffic.remove(thisKey);
                        c.receiveResult(new Boolean(true));
                    }
                }
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Statistics";
            }

            public void init() {
                this.nextTimeout = System.currentTimeMillis() + 60000L;
            }

            public void receiveResult(Object o) {
                GlacierImpl.this.warn("STAT received object: " + o);
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("STAT received exception: " + e);
                e.printStackTrace();
            }

            public void timeoutExpired() {
                this.nextTimeout += 60000L;
                if (!GlacierImpl.this.listeners.isEmpty()) {
                    Storage storageT;
                    GlacierImpl.this.statistics.pendingRequests = GlacierImpl.this.pendingTraffic.size();
                    GlacierImpl.this.statistics.numNeighbors = GlacierImpl.this.neighborStorage.scan().numElements();
                    GlacierImpl.this.statistics.numFragments = GlacierImpl.this.fragmentStorage.scan().numElements();
                    GlacierImpl.this.statistics.numContinuations = GlacierImpl.this.continuations.size();
                    GlacierImpl.this.statistics.numObjectsInTrash = GlacierImpl.this.trashStorage == null ? 0 : GlacierImpl.this.trashStorage.scan().numElements();
                    GlacierImpl.this.statistics.responsibleRange = GlacierImpl.this.responsibleRange;
                    GlacierImpl.this.statistics.activeFetches = GlacierImpl.this.numActiveRestores[0];
                    GlacierImpl.this.statistics.bucketMin = GlacierImpl.this.bucketMin;
                    GlacierImpl.this.statistics.bucketMax = GlacierImpl.this.bucketMax;
                    GlacierImpl.this.statistics.bucketConsumed = GlacierImpl.this.bucketConsumed;
                    GlacierImpl.this.statistics.bucketTokensPerSecond = GlacierImpl.this.bucketTokensPerSecond;
                    GlacierImpl.this.statistics.bucketMaxBurstSize = GlacierImpl.this.bucketMaxBurstSize;
                    GlacierImpl.this.bucketMin = GlacierImpl.this.tokenBucket;
                    GlacierImpl.this.bucketMax = GlacierImpl.this.tokenBucket;
                    GlacierImpl.this.bucketConsumed = 0L;
                    Storage storageF = GlacierImpl.this.fragmentStorage.getStorage();
                    if (storageF instanceof PersistentStorage) {
                        GlacierImpl.this.statistics.fragmentStorageSize = ((PersistentStorage)storageF).getTotalSize();
                    }
                    Storage storage = storageT = GlacierImpl.this.trashStorage == null ? null : GlacierImpl.this.trashStorage.getStorage();
                    if (storageT instanceof PersistentStorage) {
                        GlacierImpl.this.statistics.trashStorageSize = ((PersistentStorage)storageT).getTotalSize();
                    }
                    GlacierImpl.this.statistics.dump();
                    Enumeration enumeration = GlacierImpl.this.listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        GlacierStatisticsListener gsl = (GlacierStatisticsListener)enumeration.nextElement();
                        gsl.receiveStatistics(GlacierImpl.this.statistics);
                    }
                }
                GlacierImpl.this.statistics = new GlacierStatistics(13);
            }
        });
    }

    protected void updateTokenBucket() {
        long now = System.currentTimeMillis();
        long contentsBefore = this.tokenBucket;
        while (this.bucketLastUpdated < now) {
            this.bucketLastUpdated += 100L;
            this.tokenBucket += this.bucketTokensPerSecond / 10L;
            if (this.tokenBucket <= this.bucketMaxBurstSize) continue;
            this.tokenBucket = this.bucketMaxBurstSize;
        }
        if (this.bucketMax < this.tokenBucket) {
            this.bucketMax = this.tokenBucket;
        }
        this.log(3, "Token bucket contains " + this.tokenBucket + " tokens (added " + (this.tokenBucket - contentsBefore) + ")");
    }

    private long jitterTerm(long basis) {
        return (long)(0.9 * (double)basis) + (long)this.random.nextInt((int)(0.2 * (double)basis));
    }

    private void deleteFragment(final Id fkey, final Continuation command) {
        if (this.trashStorage != null) {
            this.log(2, "Moving fragment " + fkey.toStringFull() + " to trash");
            this.fragmentStorage.getObject(fkey, new Continuation(){

                public void receiveResult(Object o) {
                    GlacierImpl.this.log(3, "Fragment " + fkey.toStringFull() + " retrieved, storing in trash");
                    if (o != null) {
                        GlacierImpl.this.trashStorage.store(fkey, null, (Serializable)o, new Continuation(this){
                            private final /* synthetic */ 19 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void receiveResult(Object o) {
                                GlacierImpl.access$000(19.access$2500(this.this$1), 3, "Deleting fragment " + 19.access$2400(this.this$1).toStringFull());
                                19.access$2500(this.this$1).fragmentStorage.unstore(19.access$2400(this.this$1), 19.access$2600(this.this$1));
                            }

                            public void receiveException(Exception e) {
                                GlacierImpl.access$100(19.access$2500(this.this$1), "Cannot store in trash: " + 19.access$2400(this.this$1).toStringFull() + ", e=" + e);
                                e.printStackTrace();
                                19.access$2600(this.this$1).receiveException(e);
                            }
                        });
                    } else {
                        this.receiveException(new GlacierException("Move to trash: Fragment " + fkey + " does not exist?!?"));
                    }
                }

                public void receiveException(Exception e) {
                    GlacierImpl.this.warn("Cannot retrieve fragment " + fkey + " for deletion: e=" + e);
                    e.printStackTrace();
                    command.receiveException(new GlacierException("Cannot retrieve fragment " + fkey + " for deletion"));
                }

                static /* synthetic */ Id access$2400(19 x0) {
                    return x0.fkey;
                }

                static /* synthetic */ GlacierImpl access$2500(19 x0) {
                    return x0.GlacierImpl.this;
                }

                static /* synthetic */ Continuation access$2600(19 x0) {
                    return x0.command;
                }
            });
        } else {
            this.log(2, "Deleting fragment " + fkey.toStringFull());
            this.fragmentStorage.unstore(fkey, command);
        }
    }

    public void sendMessage(Id id, GlacierMessage message, NodeHandle hint) {
        String className = message.getClass().getName();
        this.log(2, "Send " + (hint == null ? "OVR" : "DIR") + " T" + message.getTag() + " " + className.substring(className.lastIndexOf(46) + 8));
        char c = message.getTag();
        this.statistics.messagesSentByTag[c] = this.statistics.messagesSentByTag[c] + 1;
        this.endpoint.route(id, message, hint);
    }

    private void addContinuation(GlacierContinuation gc) {
        int thisUID = this.getUID();
        gc.setup(thisUID);
        this.continuations.put(new Integer(thisUID), gc);
        gc.init();
        long thisTimeout = gc.getTimeout();
        long now = System.currentTimeMillis();
        if (this.nextContinuationTimeout == -1L || thisTimeout < this.nextContinuationTimeout) {
            if (this.nextContinuationTimeout != -1L) {
                this.cancelTimer();
            }
            this.nextContinuationTimeout = thisTimeout;
            if (this.nextContinuationTimeout > now) {
                this.setTimer((int)(this.nextContinuationTimeout - now));
            } else {
                this.timerExpired();
            }
        }
    }

    private void determineResponsibleRange() {
        Id cwPeer = null;
        Id ccwPeer = null;
        Id xcwPeer = null;
        Id xccwPeer = null;
        Id myNodeId = this.getLocalNodeHandle().getId();
        this.log(3, "Determining responsible range");
        Iterator iter = this.neighborStorage.scan().getIterator();
        while (iter.hasNext()) {
            Id thisNeighbor = (Id)iter.next();
            this.log(4, "Considering neighbor: " + thisNeighbor);
            if (myNodeId.clockwise(thisNeighbor)) {
                if (cwPeer == null || thisNeighbor.isBetween(myNodeId, cwPeer)) {
                    cwPeer = thisNeighbor;
                }
                if (xcwPeer != null && !xcwPeer.clockwise(thisNeighbor)) continue;
                xcwPeer = thisNeighbor;
                continue;
            }
            if (ccwPeer == null || thisNeighbor.isBetween(ccwPeer, myNodeId)) {
                ccwPeer = thisNeighbor;
            }
            if (xccwPeer != null && xccwPeer.clockwise(thisNeighbor)) continue;
            xccwPeer = thisNeighbor;
        }
        if (ccwPeer == null) {
            ccwPeer = xcwPeer;
        }
        if (cwPeer == null) {
            cwPeer = xccwPeer;
        }
        this.log(3, "XCCW: " + xccwPeer + " CCW: " + ccwPeer + " ME: " + myNodeId + " CW: " + cwPeer + " XCW: " + xcwPeer);
        if (ccwPeer == null || cwPeer == null) {
            this.responsibleRange = this.factory.buildIdRange(myNodeId, myNodeId);
            return;
        }
        Id.Distance ccwHalfDistance = !myNodeId.clockwise(ccwPeer) ? ccwPeer.distanceFromId(myNodeId).shiftDistance(1, 0) : ccwPeer.longDistanceFromId(myNodeId).shiftDistance(1, 0);
        Id.Distance cwHalfDistance = myNodeId.clockwise(cwPeer) ? cwPeer.distanceFromId(myNodeId).shiftDistance(1, 0) : cwPeer.longDistanceFromId(myNodeId).shiftDistance(1, 0);
        this.responsibleRange = this.factory.buildIdRange(ccwPeer.addToId(ccwHalfDistance), myNodeId.addToId(cwHalfDistance));
        this.log(2, "New range: " + this.responsibleRange);
    }

    private void log(int level, String str) {
        if (level <= this.loglevel) {
            // empty if block
        }
    }

    private void warn(String str) {
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void panic(String s) throws Error {
        System.out.println("PANIC: " + s);
        throw new Error("Panic");
    }

    public String handleDebugCommand(String command) {
        if (command.indexOf(" ") < 0) {
            return null;
        }
        String myInstance = "glacier." + this.instance.substring(this.instance.lastIndexOf("-") + 1);
        String requestedInstance = command.substring(0, command.indexOf(" "));
        String cmd = command.substring(requestedInstance.length() + 1);
        if (!requestedInstance.equals(myInstance) && !requestedInstance.equals("g")) {
            return null;
        }
        this.log(2, "Debug command: " + cmd);
        if (cmd.startsWith("ls")) {
            FragmentKeySet keyset = (FragmentKeySet)this.fragmentStorage.scan();
            Iterator iter = keyset.getIterator();
            StringBuffer result = new StringBuffer();
            long now = System.currentTimeMillis();
            if (cmd.indexOf("-r") < 0) {
                now = 0L;
            }
            result.append(keyset.numElements() + " fragment(s)\n");
            while (iter.hasNext()) {
                FragmentKey thisKey = (FragmentKey)iter.next();
                boolean isMine = this.responsibleRange.containsId(this.getFragmentLocation(thisKey));
                FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(thisKey);
                if (metadata == null) continue;
                result.append(thisKey.toStringFull() + " " + (isMine ? "OK" : "MI") + " " + (metadata.getCurrentExpiration() - now) + " " + (metadata.getPreviousExpiration() - now) + "\n");
            }
            return result.toString();
        }
        if (cmd.startsWith("show config")) {
            return "numFragments = " + this.numFragments + "\n" + "numSurvivors = " + this.numSurvivors + "\n" + "insertTimeout = " + 30 + " sec\n" + "minFragmentsAfterInsert = " + 3.0 + "x" + this.numSurvivors + "\n" + "refreshTimeout = " + 30 + " sec\n" + "expireNeighborsDelayAfterJoin = " + 30 + " sec\n" + "expireNeighborsInterval = " + 5 + " min\n" + "neighborTimeout = " + (int)(this.neighborTimeout / 3600000L) + " hrs\n" + "syncDelayAfterJoin = " + 30 + " sec\n" + "syncMinRemainingLifetime = " + 300 + " sec\n" + "syncMinQuietTime = " + 30 + " sec\n" + "syncBloomFilter = " + 3 + " hashes, " + 4 + " bpk\n" + "syncPartnersPerTrial = " + 1 + "\n" + "syncInterval = " + (int)(this.syncInterval / 60000L) + " min\n" + "syncMaxFragments = " + this.syncMaxFragments + "\n" + "fragmentRequestMaxAttempts = " + 0 + "\n" + "fragmentRequestTimeoutDefault = " + 10 + " sec\n" + "manifestRequestTimeout = " + 10 + " sec\n" + "manifestBurst = " + 3L + " -> " + 5L + "\n" + "manifestAggregationFactor = " + 5 + "\n" + "overallRestoreTimeout = " + 180 + " sec\n" + "handoffDelayAfterJoin = " + 45 + " sec\n" + "handoffInterval = " + 240 + " sec\n" + "handoffMaxFragments = " + 10 + "\n" + "garbageCollectionInterval = " + 10 + " min\n" + "garbageCollectionMaxFragmentsPerRun = " + 100 + "\n" + "localScanInterval = " + 10 + " min\n" + "localScanMaxFragmentsPerRun = " + 20 + "\n" + "restoreMaxRequestFactor = " + 4.0 + "\n" + "restoreMaxBoosts = " + 2 + "\n" + "rateLimitedCheckInterval = " + 30 + " sec\n" + "rateLimitedRequestsPerSecond = " + this.rateLimitedRequestsPerSecond + "\n";
        }
        if (cmd.startsWith("flush")) {
            // empty if block
        }
        if (cmd.startsWith("refresh")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = System.currentTimeMillis() + Long.parseLong(expirationArg);
            final String[] ret = new String[]{null};
            this.refresh(new Id[]{id}, expiration, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "refresh(" + id + ", " + expiration + ")=" + ret[0];
        }
        if (cmd.startsWith("neighbors")) {
            final Iterator iter = this.neighborStorage.scan().getIterator();
            final StringBuffer result = new StringBuffer();
            final long now = cmd.indexOf("-r") < 0 ? 0L : System.currentTimeMillis();
            final String[] ret = new String[]{null};
            result.append(this.neighborStorage.scan().numElements() + " neighbor(s)\n");
            Continuation c = new Continuation(){
                Id currentLookup;

                public void receiveResult(Object o) {
                    if (o != null) {
                        result.append(this.currentLookup.toStringFull() + " " + ((Long)o - now) + "\n");
                    }
                    if (iter.hasNext()) {
                        this.currentLookup = (Id)iter.next();
                        GlacierImpl.this.neighborStorage.getObject(this.currentLookup, this);
                    } else {
                        ret[0] = "OK";
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "Exception: " + e;
                }
            };
            c.receiveResult(null);
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            result.append(ret[0] + "\n");
            return result.toString();
        }
        if (cmd.startsWith("status")) {
            String result = "";
            result = result + "Responsible for: " + this.responsibleRange + "\n";
            result = result + "Local time: " + new Date() + "\n\n";
            result = result + this.fragmentStorage.scan().numElements() + " fragments\n";
            result = result + this.neighborStorage.scan().numElements() + " neighbors\n";
            result = result + this.continuations.size() + " active continuations\n";
            result = result + this.pendingTraffic.size() + " pending requests\n";
            if (this.trashStorage != null) {
                result = result + this.trashStorage.scan().numElements() + " fragments in trash\n";
            }
            return result;
        }
        if (cmd.startsWith("insert")) {
            // empty if block
        }
        if (cmd.startsWith("set loglevel")) {
            this.loglevel = Integer.parseInt(cmd.substring(13));
            return "Log level set to " + this.loglevel;
        }
        if (cmd.startsWith("delete")) {
            // empty if block
        }
        if (cmd.startsWith("burst")) {
            // empty if block
        }
        if (cmd.startsWith("manifest")) {
            String[] vkeyS = cmd.substring(9).split("v");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final String[] ret = new String[]{null};
            this.retrieveManifest(vkey, '\u0006', new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = o instanceof Manifest ? ((Manifest)o).toStringFull() : "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "manifest(" + vkey + ")=" + ret[0];
        }
        if (cmd.startsWith("retrieve")) {
            String[] vkeyS = cmd.substring(9).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(id);
            final String[] ret = new String[]{null};
            this.fragmentStorage.getObject(id, new Continuation(){

                public void receiveResult(Object o) {
                    FragmentAndManifest fam = (FragmentAndManifest)o;
                    MessageDigest md = null;
                    try {
                        md = MessageDigest.getInstance("SHA");
                    }
                    catch (NoSuchAlgorithmException e) {
                        // empty catch block
                    }
                    md.reset();
                    md.update(fam.fragment.getPayload());
                    ret[0] = "OK\n\nFragment: " + fam.fragment.getPayload().length + " bytes, Hash=[" + GlacierImpl.dump(md.digest(), false) + "], ID=" + id.getFragmentID() + "\n\nValidation: " + (fam.manifest.validatesFragment(fam.fragment, id.getFragmentID()) ? "OK" : "FAIL") + "\n\n" + fam.manifest.toStringFull() + "\n\nMetadata:\n - Stored since: " + metadata.getStoredSince() + "\n - Current expiration: " + metadata.getCurrentExpiration() + "\n - Previous expiration: " + metadata.getPreviousExpiration() + "\n";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.currentThread();
                Thread.yield();
            }
            return "retrieve(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("validate")) {
            FragmentKeySet keyset = (FragmentKeySet)this.fragmentStorage.scan();
            final Iterator iter = keyset.getIterator();
            final StringBuffer result = new StringBuffer();
            result.append(keyset.numElements() + " fragment(s)\n");
            final String[] ret = new String[]{null};
            if (iter.hasNext()) {
                final FragmentKey thisKey = (FragmentKey)iter.next();
                this.fragmentStorage.getObject(thisKey, new Continuation(){
                    FragmentKey currentKey;
                    int totalChecks;
                    int totalFailures;
                    {
                        this.currentKey = thisKey;
                        this.totalChecks = 1;
                        this.totalFailures = 0;
                    }

                    public void receiveResult(Object o) {
                        FragmentAndManifest fam = (FragmentAndManifest)o;
                        boolean success = fam.manifest.validatesFragment(fam.fragment, this.currentKey.getFragmentID());
                        if (!success) {
                            ++this.totalFailures;
                        }
                        result.append(this.currentKey.toStringFull() + " " + (success ? "OK" : "FAIL") + "\n");
                        this.advance();
                    }

                    public void receiveException(Exception e) {
                        ++this.totalFailures;
                        result.append(this.currentKey.toStringFull() + " EXC: " + e + "\n");
                        this.advance();
                    }

                    public void advance() {
                        if (iter.hasNext()) {
                            this.currentKey = (FragmentKey)iter.next();
                            ++this.totalChecks;
                            GlacierImpl.this.fragmentStorage.getObject(this.currentKey, this);
                        } else {
                            ret[0] = this.totalFailures == 0 ? "OK (" + this.totalChecks + " fragments checked)" : "FAIL, " + this.totalFailures + "/" + this.totalChecks + " fragments damaged";
                        }
                    }
                });
                while (ret[0] == null) {
                    Thread.currentThread();
                    Thread.yield();
                }
                return "validate=" + ret[0] + "\n\n" + result.toString();
            }
            return "validate: no objects\n\n" + result.toString();
        }
        if (cmd.startsWith("fetch")) {
            String[] vkeyS = cmd.substring(6).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final long now = System.currentTimeMillis();
            final Id fragmentLoc = this.getFragmentLocation(id);
            final String[] ret = new String[]{null};
            this.addContinuation(new GlacierContinuation(){

                public long getTimeout() {
                    return now + 5000L;
                }

                public String toString() {
                    return "DebugFetch continuation";
                }

                public void init() {
                    GlacierImpl.this.sendMessage(fragmentLoc, new GlacierFetchMessage(this.getMyUID(), id, 3, GlacierImpl.this.getLocalNodeHandle(), fragmentLoc, '\u0006'), null);
                }

                public void receiveResult(Object o) {
                    if (o instanceof GlacierDataMessage) {
                        GlacierDataMessage gdm = (GlacierDataMessage)o;
                        MessageDigest md = null;
                        try {
                            md = MessageDigest.getInstance("SHA");
                        }
                        catch (NoSuchAlgorithmException e) {
                            // empty catch block
                        }
                        md.reset();
                        md.update(gdm.getFragment(0).getPayload());
                        ret[0] = "\n\nResponse: " + gdm.getKey(0).toStringFull() + " (" + gdm.numKeys() + " keys)\n" + "Holder: " + gdm.getSource() + "\n" + "Fragment: " + gdm.getFragment(0).getPayload().length + " bytes, Hash=[" + GlacierImpl.dump(md.digest(), false) + "]\n\nValidation: " + (gdm.getManifest(0).validatesFragment(gdm.getFragment(0), gdm.getKey(0).getFragmentID()) ? "OK" : "FAIL") + "\n\n" + gdm.getManifest(0).toStringFull();
                        this.terminate();
                    } else {
                        ret[0] = "Received " + o;
                        this.terminate();
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "Exception=" + e;
                    this.terminate();
                }

                public void timeoutExpired() {
                    ret[0] = "Timeout";
                    this.terminate();
                }
            });
            while (ret[0] == null && System.currentTimeMillis() < now + 5000L) {
                Thread.currentThread();
                Thread.yield();
            }
            if (ret[0] == null) {
                ret[0] = "Timeout";
            }
            return "fetch(" + id + "@" + fragmentLoc + ")=" + ret[0];
        }
        return null;
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void refresh(Id[] ids, long[] expirations, Continuation command) {
        long[] versions = new long[ids.length];
        Arrays.fill(versions, 0L);
        this.refresh(ids, versions, expirations, command);
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void refresh(final Id[] ids, final long[] versions, final long[] expirations, final Continuation command) {
        this.addContinuation(new GlacierContinuation(){
            int minAcceptable;
            FragmentKey[][] fragmentKey;
            VersionKey[] versionKey;
            Id[][] fragmentLocation;
            NodeHandle[][] fragmentHolder;
            boolean[][] fragmentChecked;
            Vector holders;
            Manifest[] manifests;
            int[] successes;
            boolean answered;
            long nextTimeout;
            int currentStage;
            int retriesRemaining;
            final int stageProbing = 1;
            final int stageFetchingManifests = 2;
            final int stagePatching = 3;
            {
                this.minAcceptable = (int)((double)GlacierImpl.this.numSurvivors * 3.0);
                this.stageProbing = 1;
                this.stageFetchingManifests = 2;
                this.stagePatching = 3;
            }

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "AggregateRefresh continuation (" + this.fragmentKey.length + " fragments)";
            }

            public void init() {
                GlacierImpl.this.log(2, "Initializing AggregateRefresh continuation");
                this.fragmentKey = new FragmentKey[ids.length][GlacierImpl.this.numFragments];
                this.fragmentLocation = new Id[ids.length][GlacierImpl.this.numFragments];
                this.fragmentHolder = new NodeHandle[ids.length][GlacierImpl.this.numFragments];
                this.fragmentChecked = new boolean[ids.length][GlacierImpl.this.numFragments];
                this.manifests = new Manifest[ids.length];
                this.versionKey = new VersionKey[ids.length];
                this.successes = new int[ids.length];
                this.nextTimeout = System.currentTimeMillis() + 3000L;
                this.currentStage = 1;
                this.holders = new Vector();
                this.retriesRemaining = (int)(3.0 * (double)GlacierImpl.this.numFragments);
                this.answered = false;
                boolean haveFragmentMyself = false;
                for (int i = 0; i < ids.length; ++i) {
                    this.manifests[i] = null;
                    this.versionKey[i] = new VersionKey(ids[i], versions[i]);
                    for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                        this.fragmentKey[i][j] = new FragmentKey(new VersionKey(ids[i], versions[i]), j);
                        this.fragmentLocation[i][j] = GlacierImpl.this.getFragmentLocation(this.fragmentKey[i][j]);
                        this.fragmentChecked[i][j] = false;
                        if (GlacierImpl.this.fragmentStorage.getMetadata(this.fragmentKey[i][j]) != null) {
                            haveFragmentMyself = true;
                            this.fragmentHolder[i][j] = GlacierImpl.this.getLocalNodeHandle();
                            continue;
                        }
                        this.fragmentHolder[i][j] = null;
                    }
                }
                if (haveFragmentMyself) {
                    this.holders.add(GlacierImpl.this.getLocalNodeHandle());
                }
                Arrays.fill(this.successes, 0);
                GlacierImpl.this.log(3, "AR Initialization completed, " + this.fragmentKey.length + " candidate objects. Triggering first probe...");
                this.timeoutExpired();
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierRefreshResponseMessage) {
                    GlacierRefreshResponseMessage grrm = (GlacierRefreshResponseMessage)o;
                    IdRange thisRange = grrm.getRange();
                    NodeHandle holder = grrm.isOnline() ? grrm.getSource() : null;
                    GlacierImpl.this.log(3, "AR got refresh response: range " + thisRange + ", online=" + grrm.isOnline());
                    if (thisRange != null) {
                        for (int i = 0; i < ids.length; ++i) {
                            for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                if (!thisRange.containsId(this.fragmentLocation[i][j])) continue;
                                this.fragmentChecked[i][j] = true;
                                this.fragmentHolder[i][j] = holder;
                            }
                        }
                    }
                    if (!this.holders.contains(holder)) {
                        this.holders.add(holder);
                    }
                } else if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    GlacierImpl.this.log(3, "AR Received data message with " + gdm.numKeys() + " keys");
                    for (int i = 0; i < gdm.numKeys(); ++i) {
                        if (gdm.getManifest(i) == null || gdm.getKey(i) == null) continue;
                        Manifest thisManifest = gdm.getManifest(i);
                        FragmentKey thisKey = gdm.getKey(i);
                        GlacierImpl.this.log(3, "AR Received manifest for " + gdm.getKey(i) + ", checking signature...");
                        if (GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                            GlacierImpl.this.log(3, "AR Signature OK");
                            for (int j = 0; j < ids.length; ++j) {
                                if (this.manifests[j] != null || !this.versionKey[j].equals(thisKey.getVersionKey())) continue;
                                this.manifests[j] = thisManifest;
                                GlacierImpl.this.log(3, "AR Storing under #" + j);
                            }
                            continue;
                        }
                        GlacierImpl.this.warn("AR Invalid signature");
                    }
                } else if (o instanceof GlacierRefreshCompleteMessage) {
                    GlacierRefreshCompleteMessage grcm = (GlacierRefreshCompleteMessage)o;
                    GlacierImpl.this.log(3, "AR Refresh completion reported by " + grcm.getSource());
                    for (int i = 0; i < grcm.numKeys(); ++i) {
                        GlacierImpl.this.log(3, "AR Refresh completion: Key " + grcm.getKey(i) + ", " + grcm.getUpdates(i) + " update(s)");
                        int index = -1;
                        for (int j = 0; j < ids.length; ++j) {
                            if (!grcm.getKey(i).equals(this.versionKey[j])) continue;
                            index = j;
                        }
                        if (index >= 0) {
                            int maxSuccesses = 0;
                            for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                if (this.fragmentChecked[index][j] || this.fragmentHolder[index][j] == null || !this.fragmentHolder[index][j].equals(grcm.getSource())) continue;
                                ++maxSuccesses;
                                this.fragmentChecked[index][j] = true;
                            }
                            if (grcm.getUpdates(i) > (long)maxSuccesses) {
                                GlacierImpl.this.warn("Node " + grcm.getSource() + " reports " + grcm.getUpdates(i) + " for " + grcm.getKey(i) + ", but is responsible for only " + maxSuccesses + " fragments -- duplicate message, or under attack?");
                                int n = index;
                                this.successes[n] = this.successes[n] + maxSuccesses;
                                continue;
                            }
                            int n = index;
                            this.successes[n] = (int)((long)this.successes[n] + grcm.getUpdates(i));
                            continue;
                        }
                        GlacierImpl.this.warn("Node " + grcm.getSource() + " reports completion for " + grcm.getKey(i) + ", but no refresh request matches?!?");
                    }
                    if (!this.answered) {
                        boolean allSuccessful = true;
                        for (int i = 0; i < this.successes.length; ++i) {
                            if (this.successes[i] >= this.minAcceptable) continue;
                            allSuccessful = false;
                        }
                        if (allSuccessful) {
                            GlacierImpl.this.log(3, "AR Reporing success");
                            Object[] result = new Object[ids.length];
                            for (int i = 0; i < ids.length; ++i) {
                                result[i] = new Boolean(true);
                            }
                            this.answered = true;
                            command.receiveResult(result);
                        }
                    }
                } else {
                    GlacierImpl.this.warn("Unexpected result in AR continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception during AggregateRefresh: " + e);
                e.printStackTrace();
                this.terminate();
                if (!this.answered) {
                    Object[] result = new Object[ids.length];
                    GlacierException ee = new GlacierException("Exception during refresh: " + e);
                    for (int i = 0; i < ids.length; ++i) {
                        result[i] = ee;
                    }
                    this.answered = true;
                    command.receiveResult(result);
                }
            }

            public void timeoutExpired() {
                if (this.currentStage == 1) {
                    this.nextTimeout = System.currentTimeMillis() + 3000L;
                    int nextProbe = GlacierImpl.this.random.nextInt(ids.length);
                    int nextFID = GlacierImpl.this.random.nextInt(GlacierImpl.this.numFragments);
                    for (int maxSteps = ids.length * GlacierImpl.this.numFragments; maxSteps > 0 && this.fragmentChecked[nextProbe][nextFID]; --maxSteps) {
                        if (++nextFID < GlacierImpl.this.numFragments) continue;
                        nextFID = 0;
                        nextProbe = (nextProbe + 1) % ids.length;
                    }
                    if (!this.fragmentChecked[nextProbe][nextFID] && this.retriesRemaining > 0) {
                        GlacierImpl.this.log(3, "AR Sending a probe to " + this.fragmentKey[nextProbe][nextFID] + " at " + this.fragmentLocation[nextProbe][nextFID] + " (" + this.retriesRemaining + " probes left)");
                        this.fragmentChecked[nextProbe][nextFID] = true;
                        --this.retriesRemaining;
                        GlacierImpl.this.sendMessage(this.fragmentLocation[nextProbe][nextFID], new GlacierRefreshProbeMessage(this.getMyUID(), this.fragmentLocation[nextProbe][nextFID], GlacierImpl.this.getLocalNodeHandle(), this.fragmentLocation[nextProbe][nextFID], '\u0007'), null);
                    } else {
                        this.currentStage = 2;
                        this.retriesRemaining = 3;
                    }
                }
                if (this.currentStage == 2) {
                    int i;
                    this.nextTimeout = System.currentTimeMillis() + 30000L;
                    boolean[] objectCovered = new boolean[ids.length];
                    boolean allObjectsCovered = true;
                    for (i = 0; i < ids.length; ++i) {
                        objectCovered[i] = this.manifests[i] != null;
                        allObjectsCovered &= objectCovered[i];
                    }
                    if (!allObjectsCovered && this.retriesRemaining-- > 0) {
                        GlacierImpl.this.log(3, "AR Fetching manifests, " + this.retriesRemaining + " attempts remaining");
                        block2: while (true) {
                            int idx = GlacierImpl.this.random.nextInt(ids.length);
                            int maxSteps = ids.length + 2;
                            while (objectCovered[idx] && --maxSteps > 0) {
                                idx = (idx + 1) % ids.length;
                            }
                            if (maxSteps <= 0) break;
                            int fid = GlacierImpl.this.random.nextInt(GlacierImpl.this.numFragments);
                            maxSteps = GlacierImpl.this.numFragments + 2;
                            while (this.fragmentHolder[idx][fid] == null && --maxSteps > 0) {
                                fid = (fid + 1) % GlacierImpl.this.numFragments;
                            }
                            if (this.fragmentHolder[idx][fid] != null) {
                                int i2;
                                NodeHandle thisHolder = this.fragmentHolder[idx][fid];
                                Vector<FragmentKey> idsToQuery = new Vector<FragmentKey>();
                                block5: for (i2 = 0; i2 < ids.length; ++i2) {
                                    if (objectCovered[i2]) continue;
                                    for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                        if (this.fragmentHolder[i2][j] == null || !this.fragmentHolder[i2][j].equals(thisHolder)) continue;
                                        idsToQuery.add(this.fragmentKey[i2][j]);
                                        objectCovered[i2] = true;
                                        continue block5;
                                    }
                                }
                                GlacierImpl.this.log(3, "AR Asking " + thisHolder + " for " + idsToQuery.size() + " manifests");
                                i2 = 0;
                                while (true) {
                                    if (i2 >= idsToQuery.size()) continue block2;
                                    int idsHere = Math.min(idsToQuery.size() - i2, 20);
                                    FragmentKey[] keys = new FragmentKey[idsHere];
                                    for (int j = 0; j < idsHere; ++j) {
                                        keys[j] = (FragmentKey)idsToQuery.elementAt(i2 + j);
                                    }
                                    GlacierImpl.this.log(3, "AR Sending a manifest fetch with " + idsHere + " IDs, starting at " + keys[0]);
                                    GlacierImpl.this.sendMessage(null, new GlacierFetchMessage(this.getMyUID(), keys, 2, GlacierImpl.this.getLocalNodeHandle(), thisHolder.getId(), '\u0007'), thisHolder);
                                    i2 += 20;
                                }
                            }
                            objectCovered[idx] = true;
                        }
                        GlacierImpl.this.log(3, "AR Manifest fetches sent; awaiting responses...");
                    } else {
                        this.currentStage = 3;
                        this.retriesRemaining = 2;
                        GlacierImpl.this.log(3, "AR Patching manifests...");
                        for (i = 0; i < ids.length; ++i) {
                            if (this.manifests[i] == null) continue;
                            this.manifests[i] = GlacierImpl.this.policy.updateManifest(this.versionKey[i], this.manifests[i], expirations[i]);
                        }
                        GlacierImpl.this.log(3, "AR Done patching manifests");
                        for (i = 0; i < ids.length; ++i) {
                            for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                this.fragmentChecked[i][j] = this.fragmentHolder[i][j] == null || this.manifests[i] == null;
                            }
                        }
                    }
                }
                if (this.currentStage == 3) {
                    this.nextTimeout = System.currentTimeMillis() + 180000L;
                    if (this.retriesRemaining-- > 0) {
                        GlacierImpl.this.log(3, "AR Sending patches... (" + this.retriesRemaining + " retries left)");
                        int totalPatchesSent = 0;
                        for (int h = 0; h < this.holders.size(); ++h) {
                            NodeHandle thisHolder = (NodeHandle)this.holders.elementAt(h);
                            boolean[] sendPatchForObject = new boolean[ids.length];
                            int numPatches = 0;
                            for (int i = 0; i < ids.length; ++i) {
                                sendPatchForObject[i] = false;
                                for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                    if (this.fragmentChecked[i][j] || !this.fragmentHolder[i][j].equals(thisHolder)) continue;
                                    sendPatchForObject[i] = true;
                                }
                                if (!sendPatchForObject[i]) continue;
                                ++numPatches;
                            }
                            GlacierImpl.this.log(3, "AR Holder #" + h + " (" + thisHolder + ") should get " + numPatches + " patches");
                            int nextPatch = 0;
                            for (int i = 0; i < numPatches; i += 50) {
                                int patchesHere = Math.min(numPatches - i, 50);
                                VersionKey[] keys = new VersionKey[patchesHere];
                                long[] lifetimes = new long[patchesHere];
                                byte[][] signatures = new byte[patchesHere][];
                                for (int j = 0; j < patchesHere; ++j) {
                                    while (!sendPatchForObject[nextPatch]) {
                                        ++nextPatch;
                                    }
                                    keys[j] = this.versionKey[nextPatch];
                                    lifetimes[j] = expirations[nextPatch];
                                    signatures[j] = this.manifests[nextPatch].signature;
                                    ++nextPatch;
                                }
                                GlacierImpl.this.log(3, "AR Sending a patch with " + patchesHere + " IDs, starting at " + keys[0] + ", to " + thisHolder.getId());
                                totalPatchesSent += patchesHere;
                                GlacierImpl.this.sendMessage(null, new GlacierRefreshPatchMessage(this.getMyUID(), keys, lifetimes, signatures, GlacierImpl.this.getLocalNodeHandle(), thisHolder.getId(), '\u0007'), thisHolder);
                            }
                        }
                        if (totalPatchesSent == 0) {
                            GlacierImpl.this.log(3, "AR No patches sent; refresh seems to be complete...");
                            this.retriesRemaining = 0;
                            this.timeoutExpired();
                        }
                    } else {
                        GlacierImpl.this.log(3, "AR Giving up");
                        this.terminate();
                        Object[] result = new Object[ids.length];
                        for (int i = 0; i < ids.length; ++i) {
                            result[i] = this.successes[i] >= this.minAcceptable ? new Boolean(true) : new GlacierException("Only " + this.successes[i] + " fragments of " + this.versionKey[i] + " refreshed successfully; need " + this.minAcceptable);
                            GlacierImpl.this.log(3, " - AR Result for " + this.versionKey[i] + ": " + (result[i] instanceof Boolean ? "OK" : "Failed") + " (with " + this.successes[i] + "/" + GlacierImpl.this.numFragments + " fragments, " + this.minAcceptable + " acceptable)");
                        }
                        this.answered = true;
                        command.receiveResult(result);
                    }
                }
            }
        });
    }

    private void distribute(final VersionKey key, final Fragment[] fragments, final Manifest[] manifests, final long expiration, final char tag, final Continuation command) {
        final long tStart = System.currentTimeMillis();
        this.addContinuation(new GlacierContinuation(){
            NodeHandle[] holder;
            boolean[] receiptReceived;
            boolean doInsert;
            boolean doRefresh;
            boolean answered;
            boolean inhibitInsertions;
            int minAcceptable;
            {
                this.doInsert = fragments != null;
                this.doRefresh = !this.doInsert;
                this.answered = false;
                this.inhibitInsertions = true;
                this.minAcceptable = (int)((double)GlacierImpl.this.numSurvivors * 3.0);
            }

            public long getTimeout() {
                return tStart + (this.doRefresh ? 30000L : 30000L);
            }

            public String toString() {
                return this.whoAmI() + " continuation for " + key;
            }

            private int numReceiptsReceived() {
                int result = 0;
                for (int i = 0; i < this.receiptReceived.length; ++i) {
                    if (!this.receiptReceived[i]) continue;
                    ++result;
                }
                return result;
            }

            private int numHoldersKnown() {
                int result = 0;
                for (int i = 0; i < this.holder.length; ++i) {
                    if (this.holder[i] == null) continue;
                    ++result;
                }
                return result;
            }

            private String whoAmI() {
                return this.doRefresh ? "Refresh" : "Insert";
            }

            public void init() {
                GlacierImpl.this.log(2, "Initializing " + this.whoAmI() + " continuation for " + key);
                this.holder = new NodeHandle[GlacierImpl.this.numFragments];
                this.receiptReceived = new boolean[GlacierImpl.this.numFragments];
                GlacierImpl.this.log(3, "Sending queries for " + key);
                for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                    Id fragmentLoc = GlacierImpl.this.getFragmentLocation(key.getId(), i, key.getVersion());
                    FragmentKey[] keys = new FragmentKey[]{new FragmentKey(key, i)};
                    GlacierImpl.this.log(3, "Query #" + i + " to " + fragmentLoc);
                    GlacierImpl.this.sendMessage(fragmentLoc, new GlacierQueryMessage(this.getMyUID(), keys, GlacierImpl.this.getLocalNodeHandle(), fragmentLoc, tag), null);
                }
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierResponseMessage) {
                    GlacierResponseMessage grm = (GlacierResponseMessage)o;
                    if (!grm.getKey(0).getVersionKey().equals(key)) {
                        GlacierImpl.this.warn(this.whoAmI() + " response got routed to the wrong key: " + key);
                        return;
                    }
                    int fragmentID = grm.getKey(0).getFragmentID();
                    if (fragmentID < GlacierImpl.this.numFragments) {
                        if (grm.getAuthoritative(0)) {
                            if (this.doInsert && !grm.getHaveIt(0)) {
                                if (this.holder[fragmentID] == null) {
                                    this.holder[fragmentID] = grm.getSource();
                                    if (!this.inhibitInsertions) {
                                        GlacierImpl.this.log(3, "Got insert response, sending fragment " + grm.getKey(0));
                                        GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), grm.getKey(0), fragments[fragmentID], manifests[fragmentID], GlacierImpl.this.getLocalNodeHandle(), grm.getSource().getId(), false, tag), grm.getSource());
                                    } else if (this.numHoldersKnown() >= this.minAcceptable) {
                                        GlacierImpl.this.log(3, "Got " + this.numHoldersKnown() + " insert responses, sending fragments...");
                                        this.inhibitInsertions = false;
                                        for (int i = 0; i < this.holder.length; ++i) {
                                            if (this.holder[i] == null) continue;
                                            GlacierImpl.this.log(3, "Sending fragment #" + i);
                                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), new FragmentKey(key, i), fragments[i], manifests[i], GlacierImpl.this.getLocalNodeHandle(), this.holder[i].getId(), false, tag), this.holder[i]);
                                        }
                                        GlacierImpl.this.log(3, "Done sending fragments, now accepting further responses");
                                    } else {
                                        GlacierImpl.this.log(3, "Got insert response #" + this.numHoldersKnown() + " (" + this.minAcceptable + " needed to start insertion)");
                                    }
                                } else {
                                    GlacierImpl.this.warn("Received two insert responses for the same fragment -- discarded");
                                }
                            } else if (grm.getHaveIt(0) && grm.getExpiration(0) < expiration) {
                                if (this.holder[fragmentID] == null) {
                                    this.holder[fragmentID] = grm.getSource();
                                    GlacierImpl.this.log(3, "Got refresh response (exp=" + grm.getExpiration(0) + "<" + expiration + "), sending manifest " + grm.getKey(0));
                                    GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), grm.getKey(0), null, manifests[fragmentID], GlacierImpl.this.getLocalNodeHandle(), grm.getSource().getId(), false, tag), grm.getSource());
                                    if (this.doRefresh) {
                                        this.receiptReceived[fragmentID] = true;
                                        if (this.numReceiptsReceived() >= this.minAcceptable && !this.answered) {
                                            this.answered = true;
                                            this.reportSuccess();
                                        }
                                    }
                                } else {
                                    GlacierImpl.this.warn("Received two refresh responses for the same fragment -- discarded");
                                }
                            } else if (grm.getHaveIt(0) && grm.getExpiration(0) >= expiration) {
                                GlacierImpl.this.log(3, "Receipt received after " + this.whoAmI() + ": " + grm.getKey(0));
                                this.receiptReceived[fragmentID] = true;
                                if (this.numReceiptsReceived() >= this.minAcceptable && !this.answered) {
                                    this.answered = true;
                                    this.reportSuccess();
                                }
                            }
                        } else {
                            GlacierImpl.this.log(3, this.whoAmI() + " response, but not authoritative -- ignoring");
                        }
                    } else {
                        GlacierImpl.this.warn("Fragment ID too large in " + this.whoAmI() + " response -- discarded");
                    }
                    return;
                }
                GlacierImpl.this.warn("Unknown response to " + this.whoAmI() + " continuation: " + o + " -- discarded");
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception during " + this.whoAmI() + "(" + key + "): " + e);
                e.printStackTrace();
                if (!this.answered) {
                    this.answered = true;
                    command.receiveException(new GlacierException("Exception while inserting/refreshing: " + e));
                }
                this.terminate();
            }

            private void reportSuccess() {
                GlacierImpl.this.log(3, "Reporting success for " + key + ", " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received so far");
                if (this.doInsert) {
                    command.receiveResult(new Boolean[]{new Boolean(true)});
                } else {
                    command.receiveResult(new Boolean(true));
                }
            }

            public void timeoutExpired() {
                if (this.numReceiptsReceived() >= this.minAcceptable) {
                    GlacierImpl.this.log(2, this.whoAmI() + " of " + key + " successful, " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received");
                    if (!this.answered) {
                        this.answered = true;
                        this.reportSuccess();
                    }
                } else {
                    GlacierImpl.this.warn(this.whoAmI() + " " + key + " failed, only " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received");
                    if (!this.answered) {
                        this.answered = true;
                        command.receiveException(new GlacierException(this.whoAmI() + " failed, did not receive enough receipts"));
                    }
                }
                this.terminate();
            }
        });
    }

    public void insert(final PastContent obj, final long expiration, final Continuation command) {
        long theVersion = obj instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
        final VersionKey vkey = new VersionKey(obj.getId(), theVersion);
        this.log(2, "insert(" + obj + " (id=" + vkey.toStringFull() + ", mutable=" + obj.isMutable() + ")");
        this.endpoint.process(new Executable(){

            public Object execute() {
                boolean[] generateFragment = new boolean[GlacierImpl.this.numFragments];
                Arrays.fill(generateFragment, true);
                return GlacierImpl.this.policy.encodeObject(obj, generateFragment);
            }
        }, new Continuation(){

            public void receiveResult(Object o) {
                Fragment[] fragments = (Fragment[])o;
                if (fragments == null) {
                    command.receiveException(new GlacierException("Cannot encode object"));
                    return;
                }
                GlacierImpl.this.log(3, "insert(" + vkey.toStringFull() + ") encoded fragments OK, creating manifests...");
                GlacierImpl.this.endpoint.process(new Executable(this, fragments){
                    private final /* synthetic */ Fragment[] val$fragments;
                    private final /* synthetic */ 37 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$fragments = val$fragments;
                    }

                    public Object execute() {
                        return 37.access$3100(this.this$1).policy.createManifests(37.access$2800(this.this$1), 37.access$2900(this.this$1), this.val$fragments, 37.access$3000(this.this$1));
                    }
                }, new Continuation(this, fragments){
                    private final /* synthetic */ Fragment[] val$fragments;
                    private final /* synthetic */ 37 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$fragments = val$fragments;
                    }

                    public void receiveResult(Object o) {
                        if (o instanceof Manifest[]) {
                            Manifest[] manifests = (Manifest[])o;
                            if (manifests == null) {
                                37.access$3200(this.this$1).receiveException(new GlacierException("Cannot create manifests"));
                                return;
                            }
                            GlacierImpl.access$3300(37.access$3100(this.this$1), 37.access$2800(this.this$1), this.val$fragments, manifests, 37.access$3000(this.this$1), '\b', 37.access$3200(this.this$1));
                        } else {
                            GlacierImpl.access$100(37.access$3100(this.this$1), "insert(" + 37.access$2800(this.this$1).toStringFull() + ") cannot create manifests - returned o=" + o);
                            37.access$3200(this.this$1).receiveException(new GlacierException("Cannot create manifests in insert()"));
                        }
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.access$100(37.access$3100(this.this$1), "insert(" + 37.access$2800(this.this$1).toStringFull() + ") cannot create manifests - exception e=" + e);
                        e.printStackTrace();
                        37.access$3200(this.this$1).receiveException(e);
                    }
                });
            }

            public void receiveException(Exception e) {
                command.receiveException(new GlacierException("EncodeObject failed: e=" + e));
                e.printStackTrace();
            }

            static /* synthetic */ VersionKey access$2800(37 x0) {
                return x0.vkey;
            }

            static /* synthetic */ PastContent access$2900(37 x0) {
                return x0.obj;
            }

            static /* synthetic */ long access$3000(37 x0) {
                return x0.expiration;
            }

            static /* synthetic */ GlacierImpl access$3100(37 x0) {
                return x0.GlacierImpl.this;
            }

            static /* synthetic */ Continuation access$3200(37 x0) {
                return x0.command;
            }
        });
    }

    private void timerExpired() {
        long earliestTimeout;
        int numDelete;
        this.log(3, "Timer expired");
        boolean foundTerminated = false;
        do {
            long now = System.currentTimeMillis();
            int[] deleteList = new int[100];
            numDelete = 0;
            earliestTimeout = -1L;
            this.log(3, "Timer run at " + now);
            Enumeration enu = this.continuations.elements();
            while (enu.hasMoreElements()) {
                GlacierContinuation gc = (GlacierContinuation)enu.nextElement();
                long currentTimeout = gc.getTimeout();
                if (!gc.hasTerminated() && currentTimeout < now + 1000L) {
                    this.log(3, "Timer: Resuming [" + gc + "]");
                    gc.syncTimeoutExpired();
                    if (!gc.hasTerminated() && gc.getTimeout() <= currentTimeout) {
                        this.panic("Continuation does not set new timeout: " + gc);
                    }
                }
                if (!gc.hasTerminated()) {
                    if (earliestTimeout != -1L && gc.getTimeout() >= earliestTimeout) continue;
                    earliestTimeout = gc.getTimeout();
                    continue;
                }
                if (numDelete >= 100) continue;
                deleteList[numDelete++] = gc.getMyUID();
            }
            if (numDelete <= 0) continue;
            this.log(3, "Deleting " + numDelete + " expired continuations");
            for (int i = 0; i < numDelete; ++i) {
                this.continuations.remove(new Integer(deleteList[i]));
            }
        } while (numDelete == 100 || earliestTimeout >= 0L && earliestTimeout < System.currentTimeMillis());
        if (earliestTimeout >= 0L) {
            this.log(3, "Next timeout is at " + earliestTimeout);
            this.setTimer((int)Math.max(earliestTimeout - System.currentTimeMillis(), 1000L));
        } else {
            this.log(3, "No more timeouts");
        }
    }

    public void neighborSeen(Id nodeId, long when) {
        if (nodeId.equals(this.getLocalNodeHandle().getId())) {
            return;
        }
        this.log(3, "Neighbor " + nodeId + " was seen at " + when);
        if (when > System.currentTimeMillis()) {
            this.warn("Neighbor: " + when + " is in the future (now=" + System.currentTimeMillis() + ")");
            when = System.currentTimeMillis();
        }
        final Id fNodeId = nodeId;
        final long fWhen = when;
        this.neighborStorage.getObject(nodeId, new Continuation(){

            public void receiveResult(Object o) {
                GlacierImpl.this.log(3, "Continue: neighborSeen (" + fNodeId + ", " + fWhen + ") after getObject");
                long previousWhen = o != null ? (Long)o : 0L;
                GlacierImpl.this.log(3, "Neighbor: " + fNodeId + " previously seen at " + previousWhen);
                if (previousWhen >= fWhen) {
                    GlacierImpl.this.log(3, "Neighbor: No update needed (new TS=" + fWhen + ")");
                    return;
                }
                GlacierImpl.this.neighborStorage.store(fNodeId, null, new Long(fWhen), new Continuation(this, previousWhen){
                    private final /* synthetic */ long val$previousWhen;
                    private final /* synthetic */ 40 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$previousWhen = val$previousWhen;
                    }

                    public void receiveResult(Object o) {
                        GlacierImpl.access$000(40.access$3600(this.this$1), 3, "Continue: neighborSeen (" + 40.access$3400(this.this$1) + ", " + 40.access$3500(this.this$1) + ") after store");
                        GlacierImpl.access$000(40.access$3600(this.this$1), 3, "Neighbor: Updated " + 40.access$3400(this.this$1) + " from " + this.val$previousWhen + " to " + 40.access$3500(this.this$1));
                        GlacierImpl.access$600(40.access$3600(this.this$1));
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.access$100(40.access$3600(this.this$1), "receiveException(" + e + ") while storing a neighbor (" + 40.access$3400(this.this$1) + ")");
                    }
                });
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("receiveException(" + e + ") while retrieving a neighbor (" + fNodeId + ")");
            }

            static /* synthetic */ Id access$3400(40 x0) {
                return x0.fNodeId;
            }

            static /* synthetic */ long access$3500(40 x0) {
                return x0.fWhen;
            }

            static /* synthetic */ GlacierImpl access$3600(40 x0) {
                return x0.GlacierImpl.this;
            }
        });
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
        this.log(2, "Leafset update: " + handle + " has " + (joined ? "joined" : "left"));
        if (!joined) {
            return;
        }
        this.neighborSeen(handle.getId(), System.currentTimeMillis());
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Glacier"));
    }

    public void lookupHandles(Id id, int num, Continuation command) {
        this.lookupHandles(id, 0L, num, command);
    }

    public void lookupHandles(final Id id, final long version, int num, final Continuation command) {
        this.log(2, "lookupHandles(" + id + "v" + version + ", n=" + num + ")");
        this.retrieveManifest(new VersionKey(id, version), '\t', new Continuation(){
            boolean haveAnswered = false;

            public void receiveResult(Object o) {
                if (this.haveAnswered) {
                    GlacierImpl.this.log(3, "lookupHandles(" + id + "): received manifest " + o + " but has already answered. Discarding...");
                    return;
                }
                if (o instanceof Manifest) {
                    GlacierImpl.this.log(3, "lookupHandles(" + id + "): received manifest " + o + ", returning handle...");
                    this.haveAnswered = true;
                    command.receiveResult(new PastContentHandle[]{new GlacierContentHandle(id, version, GlacierImpl.this.getLocalNodeHandle(), (Manifest)o)});
                } else {
                    GlacierImpl.this.warn("lookupHandles(" + id + "): Cannot retrieve manifest");
                    this.haveAnswered = true;
                    command.receiveResult(new PastContentHandle[]{null});
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("lookupHandles(" + id + "): Exception " + e);
                e.printStackTrace();
                this.haveAnswered = true;
                command.receiveException(e);
            }
        });
    }

    public void lookup(Id id, long version, Continuation command) {
        VersionKey vkey = new VersionKey(id, version);
        this.log(2, "lookup(" + id + "v" + version + ")");
        this.retrieveObject(vkey, null, true, '\n', command);
    }

    public void lookup(Id id, boolean cache, Continuation command) {
        this.lookup(id, 0L, command);
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, 0L, command);
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        this.log(2, "fetch(" + handle.getId() + ")");
        if (!(handle instanceof GlacierContentHandle)) {
            command.receiveException(new GlacierException("Unknown handle type"));
            return;
        }
        GlacierContentHandle gch = (GlacierContentHandle)handle;
        this.log(3, "exact: fetch(" + gch.getId() + "v" + gch.getVersion() + ")");
        this.retrieveObject(new VersionKey(gch.getId(), gch.getVersion()), gch.getManifest(), true, '\u000b', command);
    }

    public void retrieveManifest(final VersionKey key, final char tag, final Continuation command) {
        this.log(3, "retrieveManifest(key=" + key + " tag=" + tag + ")");
        this.addContinuation(new GlacierContinuation(){
            protected boolean[] checkedFragment;
            protected long timeout;

            public long getTimeout() {
                return this.timeout;
            }

            public String toString() {
                return "retrieveManifest(" + key + ")";
            }

            public void init() {
                this.checkedFragment = new boolean[GlacierImpl.this.numFragments];
                Arrays.fill(this.checkedFragment, false);
                this.timeout = System.currentTimeMillis() + 10000L;
                int i = 0;
                while ((long)i < 3L) {
                    this.sendRandomRequest();
                    ++i;
                }
            }

            public int numCheckedFragments() {
                int result = 0;
                for (int i = 0; i < this.checkedFragment.length; ++i) {
                    if (!this.checkedFragment[i]) continue;
                    ++result;
                }
                return result;
            }

            public void sendRandomRequest() {
                int nextID;
                if (this.numCheckedFragments() >= GlacierImpl.this.numFragments) {
                    return;
                }
                while (this.checkedFragment[nextID = GlacierImpl.this.random.nextInt(GlacierImpl.this.numFragments)]) {
                }
                this.checkedFragment[nextID] = true;
                FragmentKey nextKey = new FragmentKey(key, nextID);
                Id nextLocation = GlacierImpl.this.getFragmentLocation(nextKey);
                GlacierImpl.this.log(3, "retrieveManifest: Asking " + nextLocation + " for " + nextKey);
                GlacierImpl.this.sendMessage(nextLocation, new GlacierFetchMessage(this.getMyUID(), nextKey, 2, GlacierImpl.this.getLocalNodeHandle(), nextLocation, tag), null);
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    if (gdm.numKeys() > 0 && gdm.getManifest(0) != null) {
                        GlacierImpl.this.log(3, "retrieveManifest(" + key + ") received manifest");
                        if (GlacierImpl.this.policy.checkSignature(gdm.getManifest(0), key)) {
                            command.receiveResult(gdm.getManifest(0));
                            this.terminate();
                        } else {
                            GlacierImpl.this.warn("retrieveManifest(" + key + "): invalid signature in " + gdm.getKey(0));
                        }
                    } else {
                        GlacierImpl.this.warn("retrieveManifest(" + key + ") retrieved GDM without a manifest?!?");
                    }
                } else if (o instanceof GlacierResponseMessage) {
                    GlacierImpl.this.log(3, "retrieveManifest(" + key + "): Fragment not available:" + ((GlacierResponseMessage)o).getKey(0));
                    if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                        this.sendRandomRequest();
                    } else {
                        GlacierImpl.this.warn("retrieveManifest(" + key + "): giving up");
                        command.receiveResult(null);
                        this.terminate();
                    }
                } else {
                    GlacierImpl.this.warn("retrieveManifest(" + key + ") received unexpected object: " + o);
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("retrieveManifest(" + key + ") received exception: " + e);
                e.printStackTrace();
            }

            public void timeoutExpired() {
                GlacierImpl.this.log(3, "retrieveManifest(" + key + "): Timeout (" + this.numCheckedFragments() + " fragments checked)");
                if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                    GlacierImpl.this.log(3, "retrying...");
                    int i = 0;
                    while ((long)i < 5L) {
                        this.sendRandomRequest();
                        ++i;
                    }
                    this.timeout += 10000L;
                } else {
                    GlacierImpl.this.warn("retrieveManifest(" + key + "): giving up");
                    this.terminate();
                    command.receiveResult(null);
                }
            }
        });
    }

    public void retrieveObject(final VersionKey key, final Manifest manifest, final boolean beStrict, final char tag, final Continuation c) {
        this.addContinuation(new GlacierContinuation(){
            protected boolean[] checkedFragment;
            protected Fragment[] haveFragment;
            protected int attemptsLeft;
            protected long timeout;

            public long getTimeout() {
                return this.timeout;
            }

            public int numHaveFragments() {
                int result = 0;
                for (int i = 0; i < this.haveFragment.length; ++i) {
                    if (this.haveFragment[i] == null) continue;
                    ++result;
                }
                return result;
            }

            public int numCheckedFragments() {
                int result = 0;
                for (int i = 0; i < this.checkedFragment.length; ++i) {
                    if (!this.checkedFragment[i]) continue;
                    ++result;
                }
                return result;
            }

            public String toString() {
                return "retrieveObject(" + key + ")";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void init() {
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    int[] nArray2 = GlacierImpl.this.numActiveRestores;
                    nArray2[0] = nArray2[0] + 1;
                }
                this.checkedFragment = new boolean[GlacierImpl.this.numFragments];
                this.haveFragment = new Fragment[GlacierImpl.this.numFragments];
                for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                    this.checkedFragment[i] = false;
                    this.haveFragment[i] = null;
                }
                this.timeout = System.currentTimeMillis();
                this.attemptsLeft = 2;
                this.timeoutExpired();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void localTerminate() {
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    int[] nArray2 = GlacierImpl.this.numActiveRestores;
                    nArray2[0] = nArray2[0] - 1;
                }
                this.terminate();
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    int fragmentID = gdm.getKey(0).getFragmentID();
                    if (!gdm.getKey(0).getVersionKey().equals(key) || fragmentID < 0 || fragmentID >= GlacierImpl.this.numFragments) {
                        GlacierImpl.this.warn("retrieveObject: Bad data message (contains " + gdm.getKey(0) + ", expected " + key);
                        return;
                    }
                    Fragment thisFragment = gdm.getFragment(0);
                    if (thisFragment == null) {
                        GlacierImpl.this.log(3, "Fragment " + ((GlacierDataMessage)o).getKey(0) + " not available (GDM returned null), sending another request");
                        if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                            this.sendRandomRequest();
                        }
                        return;
                    }
                    if (!this.checkedFragment[fragmentID]) {
                        GlacierImpl.this.warn("retrieveObject: Got fragment #" + fragmentID + ", but we never requested it -- ignored");
                        return;
                    }
                    if (this.haveFragment[fragmentID] != null) {
                        GlacierImpl.this.warn("retrieveObject: Got duplicate fragment #" + fragmentID + " -- discarded");
                        return;
                    }
                    if (manifest != null && !manifest.validatesFragment(thisFragment, fragmentID)) {
                        GlacierImpl.this.warn("Got invalid fragment #" + fragmentID + " -- discarded");
                        return;
                    }
                    GlacierImpl.this.log(3, "retrieveObject: Received fragment #" + fragmentID + " for " + gdm.getKey(0));
                    this.haveFragment[fragmentID] = thisFragment;
                    GlacierImpl.this.currentFragmentRequestTimeout -= 1000L;
                    if (GlacierImpl.this.currentFragmentRequestTimeout < 10000L) {
                        GlacierImpl.this.currentFragmentRequestTimeout = 10000L;
                    }
                    GlacierImpl.this.log(3, "Timeout decreased to " + GlacierImpl.this.currentFragmentRequestTimeout);
                    if (this.numHaveFragments() >= GlacierImpl.this.numSurvivors) {
                        Fragment[] material = new Fragment[GlacierImpl.this.numFragments];
                        int numAdded = 0;
                        for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                            if (this.haveFragment[j] != null && numAdded < GlacierImpl.this.numSurvivors) {
                                material[j] = this.haveFragment[j];
                                ++numAdded;
                                continue;
                            }
                            material[j] = null;
                        }
                        GlacierImpl.this.log(3, "Decode object: " + key);
                        Serializable theObject = GlacierImpl.this.policy.decodeObject(material);
                        GlacierImpl.this.log(3, "Decode complete: " + key);
                        if (theObject == null || !(theObject instanceof PastContent)) {
                            GlacierImpl.this.warn("retrieveObject: Decoder delivered " + theObject + ", unexpected -- failed");
                            c.receiveException(new GlacierException("Decoder delivered " + theObject + ", unexpected -- failed"));
                        } else {
                            c.receiveResult(theObject);
                        }
                        this.localTerminate();
                    }
                } else if (o instanceof GlacierResponseMessage) {
                    GlacierImpl.this.log(3, "Fragment " + ((GlacierResponseMessage)o).getKey(0) + " not available");
                    if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                        this.sendRandomRequest();
                    }
                } else {
                    GlacierImpl.this.warn("retrieveObject: Unexpected result: " + o);
                }
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("retrieveObject: Exception " + e);
                e.printStackTrace();
                c.receiveException(e);
                this.localTerminate();
            }

            public void sendRandomRequest() {
                int nextID;
                while (this.checkedFragment[nextID = GlacierImpl.this.random.nextInt(GlacierImpl.this.numFragments)]) {
                }
                this.checkedFragment[nextID] = true;
                FragmentKey nextKey = new FragmentKey(key, nextID);
                Id nextLocation = GlacierImpl.this.getFragmentLocation(nextKey);
                GlacierImpl.this.log(3, "retrieveObject: Asking " + nextLocation + " for " + nextKey);
                GlacierImpl.this.sendMessage(nextLocation, new GlacierFetchMessage(this.getMyUID(), nextKey, 1, GlacierImpl.this.getLocalNodeHandle(), nextLocation, tag), null);
            }

            public void timeoutExpired() {
                if (this.attemptsLeft > 0) {
                    GlacierImpl.this.log(3, "retrieveObject: Retrying (" + this.attemptsLeft + " attempts left)");
                    if (this.attemptsLeft < 2) {
                        GlacierImpl.this.currentFragmentRequestTimeout *= 2L;
                        if (GlacierImpl.this.currentFragmentRequestTimeout > 60000L) {
                            GlacierImpl.this.currentFragmentRequestTimeout = 60000L;
                        }
                        GlacierImpl.this.log(3, "Timeout increased to " + GlacierImpl.this.currentFragmentRequestTimeout);
                    }
                    this.timeout += GlacierImpl.this.currentFragmentRequestTimeout;
                    --this.attemptsLeft;
                    int numRequests = GlacierImpl.this.numSurvivors - this.numHaveFragments();
                    if (this.attemptsLeft < 1) {
                        numRequests = Math.min(2 * numRequests, GlacierImpl.this.numFragments - this.numCheckedFragments());
                    }
                    if (this.attemptsLeft == 0 && beStrict) {
                        numRequests = GlacierImpl.this.numFragments - this.numCheckedFragments();
                    }
                    for (int i = 0; i < numRequests && this.numCheckedFragments() < GlacierImpl.this.numFragments; ++i) {
                        this.sendRandomRequest();
                    }
                } else {
                    GlacierImpl.this.log(2, "retrieveObject: Giving up on " + key + " (" + 2 + " attempts, " + this.numCheckedFragments() + " checked, " + this.numHaveFragments() + " gotten)");
                    c.receiveException(new GlacierNotEnoughFragmentsException("Maximum number of attempts (2) reached for key " + key, this.numCheckedFragments(), this.numHaveFragments()));
                    this.localTerminate();
                }
            }
        });
    }

    public void retrieveFragment(final FragmentKey key, final Manifest manifest, final char tag, final GlacierContinuation c) {
        Continuation c2 = new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    if (o instanceof FragmentAndManifest) {
                        Fragment thisFragment = ((FragmentAndManifest)o).fragment;
                        if (manifest.validatesFragment(thisFragment, key.getFragmentID())) {
                            GlacierImpl.this.log(3, "retrieveFragment: Found in trash: " + key.toStringFull());
                            c.receiveResult(thisFragment);
                            return;
                        }
                        GlacierImpl.this.warn("Fragment found in trash, but does not match manifest?!? -- fetching normally");
                    } else {
                        GlacierImpl.this.warn("Fragment " + key.toStringFull() + " found in trash, but object is not a FAM (" + o + ")?!? -- ignoring");
                    }
                }
                GlacierImpl.this.addContinuation(new GlacierContinuation(this){
                    protected int attemptsLeft;
                    protected boolean inPhaseTwo;
                    protected long timeout;
                    private final /* synthetic */ 45 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public long getTimeout() {
                        return this.timeout;
                    }

                    public String toString() {
                        return "retrieveFragment(" + 45.access$3700(this.this$1) + ")";
                    }

                    public void init() {
                        this.attemptsLeft = 0;
                        this.timeout = System.currentTimeMillis();
                        this.inPhaseTwo = false;
                        this.timeoutExpired();
                    }

                    public void receiveResult(Object o) {
                        if (o instanceof GlacierResponseMessage) {
                            GlacierResponseMessage grm = (GlacierResponseMessage)o;
                            if (!grm.getKey(0).equals(45.access$3700(this.this$1))) {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Response does not match key " + 45.access$3700(this.this$1) + " -- discarded");
                                return;
                            }
                            if (this.attemptsLeft > 0 && !grm.getHaveIt(0)) {
                                this.attemptsLeft = 0;
                                this.timeoutExpired();
                            } else {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Unexpected GlacierResponseMessage: " + grm + " (key=" + 45.access$3700(this.this$1) + ")");
                            }
                            return;
                        }
                        if (o instanceof GlacierDataMessage) {
                            GlacierDataMessage gdm = (GlacierDataMessage)o;
                            if (!gdm.getKey(0).equals(45.access$3700(this.this$1))) {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Data does not match key " + 45.access$3700(this.this$1) + " -- discarded");
                                return;
                            }
                            Fragment thisFragment = gdm.getFragment(0);
                            if (thisFragment == null) {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: DataMessage does not contain any fragments -- discarded");
                                return;
                            }
                            if (!45.access$3900(this.this$1).validatesFragment(thisFragment, gdm.getKey(0).getFragmentID())) {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "Invalid fragment " + gdm.getKey(0) + " returned by primary -- ignored");
                                return;
                            }
                            45.access$4000(this.this$1).receiveResult(thisFragment);
                            this.terminate();
                            return;
                        }
                        GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Unknown result " + o + " (key=" + 45.access$3700(this.this$1) + ")");
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Exception " + e);
                        e.printStackTrace();
                        45.access$4000(this.this$1).receiveException(e);
                        this.terminate();
                    }

                    public void timeoutExpired() {
                        if (this.attemptsLeft > 0) {
                            GlacierImpl.access$000(45.access$3800(this.this$1), 3, "retrieveFragment: Retrying (" + this.attemptsLeft + " attempts left)");
                            this.timeout += 45.access$3800(this.this$1).currentFragmentRequestTimeout;
                            --this.attemptsLeft;
                            45.access$3800(this.this$1).sendMessage(45.access$3700(this.this$1).getVersionKey().getId(), new GlacierFetchMessage(this.getMyUID(), 45.access$3700(this.this$1), 1, 45.access$3800(this.this$1).getLocalNodeHandle(), 45.access$3700(this.this$1).getVersionKey().getId(), 45.access$4100(this.this$1)), null);
                        } else {
                            this.timeout += 6L * 45.access$3800(this.this$1).currentFragmentRequestTimeout;
                            if (this.inPhaseTwo) {
                                GlacierImpl.access$100(45.access$3800(this.this$1), "retrieveFragment: Already in phase two");
                            }
                            this.inPhaseTwo = true;
                            45.access$3800(this.this$1).retrieveObject(45.access$3700(this.this$1).getVersionKey(), 45.access$3900(this.this$1), false, 45.access$4100(this.this$1), new Continuation(this){
                                private final /* synthetic */ 46 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void receiveResult(Object o) {
                                    if (o == null) {
                                        GlacierImpl.access$100(45.access$3800(46.access$4200(this.this$2)), "retrieveFragment: retrieveObject(" + 45.access$3700(46.access$4200(this.this$2)).getVersionKey() + ") failed, returns null");
                                        45.access$4000(46.access$4200(this.this$2)).receiveException(new GlacierException("Cannot restore either the object or the fragment -- try again later!"));
                                        return;
                                    }
                                    PastContent retrievedObject = (PastContent)o;
                                    45.access$3800(46.access$4200(this.this$2)).endpoint.process(new Executable(this, retrievedObject){
                                        private final /* synthetic */ PastContent val$retrievedObject;
                                        private final /* synthetic */ 47 this$3;
                                        {
                                            this.this$3 = this$3;
                                            this.val$retrievedObject = val$retrievedObject;
                                        }

                                        public Object execute() {
                                            GlacierImpl.access$000(45.access$3800(46.access$4200(47.access$4300(this.this$3))), 3, "Reencode object: " + 45.access$3700(46.access$4200(47.access$4300(this.this$3))).getVersionKey());
                                            boolean[] generateFragment = new boolean[45.access$3800(46.access$4200(47.access$4300(this.this$3))).numFragments];
                                            Arrays.fill(generateFragment, false);
                                            generateFragment[45.access$3700(46.access$4200(47.access$4300(this.this$3))).getFragmentID()] = true;
                                            Fragment[] result = 45.access$3800(46.access$4200(47.access$4300(this.this$3))).policy.encodeObject(this.val$retrievedObject, generateFragment);
                                            GlacierImpl.access$000(45.access$3800(46.access$4200(47.access$4300(this.this$3))), 3, "Reencode complete: " + 45.access$3700(46.access$4200(47.access$4300(this.this$3))).getVersionKey());
                                            return result;
                                        }
                                    }, new Continuation(this){
                                        private final /* synthetic */ 47 this$3;
                                        {
                                            this.this$3 = this$3;
                                        }

                                        public void receiveResult(Object o) {
                                            Fragment[] frag = (Fragment[])o;
                                            if (!45.access$3900(46.access$4200(47.access$4300(this.this$3))).validatesFragment(frag[45.access$3700(46.access$4200(47.access$4300(this.this$3))).getFragmentID()], 45.access$3700(46.access$4200(47.access$4300(this.this$3))).getFragmentID())) {
                                                GlacierImpl.access$100(45.access$3800(46.access$4200(47.access$4300(this.this$3))), "Reconstructed fragment #" + 45.access$3700(46.access$4200(47.access$4300(this.this$3))).getFragmentID() + " does not match manifest ??!?");
                                                45.access$4000(46.access$4200(47.access$4300(this.this$3))).receiveException(new GlacierException("Recovered object, but cannot re-encode it (strange!) -- try again later!"));
                                                return;
                                            }
                                            45.access$4000(46.access$4200(47.access$4300(this.this$3))).receiveResult(frag[45.access$3700(46.access$4200(47.access$4300(this.this$3))).getFragmentID()]);
                                        }

                                        public void receiveException(Exception e) {
                                            45.access$4000(46.access$4200(47.access$4300(this.this$3))).receiveException(new GlacierException("Recovered object, but re-encode failed: " + e));
                                            e.printStackTrace();
                                        }
                                    });
                                }

                                public void receiveException(Exception e) {
                                    45.access$4000(46.access$4200(this.this$2)).receiveException(e);
                                }

                                static /* synthetic */ 46 access$4300(47 x0) {
                                    return x0.this$2;
                                }
                            });
                            this.terminate();
                        }
                    }

                    static /* synthetic */ 45 access$4200(46 x0) {
                        return x0.this$1;
                    }
                });
            }

            public void receiveException(Exception e) {
                GlacierImpl.this.warn("Exception while checking for " + key.toStringFull() + " in trash storage -- ignoring");
            }

            static /* synthetic */ FragmentKey access$3700(45 x0) {
                return x0.key;
            }

            static /* synthetic */ GlacierImpl access$3800(45 x0) {
                return x0.GlacierImpl.this;
            }

            static /* synthetic */ Manifest access$3900(45 x0) {
                return x0.manifest;
            }

            static /* synthetic */ GlacierContinuation access$4000(45 x0) {
                return x0.c;
            }

            static /* synthetic */ char access$4100(45 x0) {
                return x0.tag;
            }
        };
        if (this.trashStorage != null && this.trashStorage.exists(key)) {
            this.log(3, "retrieveFragment: Key " + key.toStringFull() + " found in trash, retrieving...");
            this.trashStorage.getObject(key, c2);
        } else {
            this.log(3, "retrieveFragment: Key " + key.toStringFull() + " not found in trash");
            c2.receiveResult(null);
        }
    }

    public void rateLimitedRetrieveFragment(final FragmentKey key, final Manifest manifest, final char tag, final GlacierContinuation c) {
        this.log(3, "rateLimitedRetrieveFragment(" + key + ")");
        if (this.pendingTraffic.containsKey(key)) {
            this.log(3, "Fragment is already being retrieved -- discarding request");
            return;
        }
        this.log(3, "Added pending job: retrieveFragment(" + key + ")");
        Continuation prev = this.pendingTraffic.put(key, new Continuation.SimpleContinuation(){

            public void receiveResult(Object o) {
                GlacierImpl.this.retrieveFragment(key, manifest, tag, c);
            }
        });
        if (prev != null) {
            prev.receiveException(new GlacierException("Key collision in traffic shaper (rateLimitedRetrieveFragment)"));
        }
    }

    public void deliver(Id id, Message message) {
        int i;
        GlacierDataMessage gdm;
        GlacierMessage msg = (GlacierMessage)message;
        this.log(3, "Received message " + msg + " with destination " + id + " from " + msg.getSource().getId());
        if (msg instanceof GlacierDataMessage) {
            gdm = (GlacierDataMessage)msg;
            long thisSize = 1000L;
            this.updateTokenBucket();
            for (i = 0; i < gdm.numKeys(); ++i) {
                if (gdm.getFragment(i) != null) {
                    thisSize += (long)gdm.getFragment(i).getPayload().length;
                }
                if (gdm.getManifest(i) == null) continue;
                thisSize += (long)(this.numFragments * 21);
            }
            this.tokenBucket -= thisSize;
            this.bucketConsumed += thisSize;
            if (this.bucketMin > this.tokenBucket) {
                this.bucketMin = this.tokenBucket;
            }
            this.log(3, "Token bucket contains " + this.tokenBucket + " tokens (consumed " + thisSize + ")");
        }
        if (msg.isResponse()) {
            GlacierContinuation gc = (GlacierContinuation)this.continuations.get(new Integer(msg.getUID()));
            if (gc != null) {
                if (!gc.terminated) {
                    this.log(3, "Resuming [" + gc + "]");
                    gc.syncReceiveResult(msg);
                    this.log(3, "---");
                } else {
                    this.log(3, "Message UID#" + msg.getUID() + " is response, but continuation has already terminated");
                }
            } else {
                this.log(3, "Unusual: Message UID#" + msg.getUID() + " is response, but continuation not found");
            }
            return;
        }
        if (msg instanceof GlacierQueryMessage) {
            GlacierQueryMessage gqm = (GlacierQueryMessage)msg;
            FragmentKey[] keyA = new FragmentKey[gqm.numKeys()];
            boolean[] haveItA = new boolean[gqm.numKeys()];
            long[] expirationA = new long[gqm.numKeys()];
            boolean[] authoritativeA = new boolean[gqm.numKeys()];
            for (int i2 = 0; i2 < gqm.numKeys(); ++i2) {
                Id fragmentLocation = this.getFragmentLocation(gqm.getKey(i2));
                this.log(2, "Queried for " + gqm.getKey(i2) + " (at " + fragmentLocation + ")");
                keyA[i2] = gqm.getKey(i2);
                haveItA[i2] = this.fragmentStorage.exists(gqm.getKey(i2));
                if (haveItA[i2]) {
                    FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(gqm.getKey(i2));
                    if (metadata != null) {
                        expirationA[i2] = metadata.getCurrentExpiration();
                    } else {
                        this.warn("QUERY cannot read metadata in object " + gqm.getKey(i2).toStringFull() + ", storage returned null");
                        expirationA[i2] = 0L;
                        haveItA[i2] = false;
                    }
                } else {
                    expirationA[i2] = 0L;
                }
                this.log(3, "My range is " + this.responsibleRange);
                this.log(3, "Location is " + fragmentLocation);
                authoritativeA[i2] = this.responsibleRange.containsId(fragmentLocation);
                this.log(3, "Result: haveIt=" + haveItA[i2] + " amAuthority=" + authoritativeA[i2] + " expiration=" + expirationA[i2]);
            }
            this.sendMessage(null, new GlacierResponseMessage(gqm.getUID(), keyA, haveItA, expirationA, authoritativeA, this.getLocalNodeHandle(), gqm.getSource().getId(), true, gqm.getTag()), gqm.getSource());
        } else {
            GlacierMessage grpm;
            if (msg instanceof GlacierNeighborRequestMessage) {
                final GlacierNeighborRequestMessage gnrm = (GlacierNeighborRequestMessage)msg;
                IdSet requestedNeighbors = this.neighborStorage.scan(gnrm.getRequestedRange());
                final int numRequested = requestedNeighbors.numElements();
                if (numRequested < 1) {
                    this.log(3, "No neighbors in that range -- canceled");
                    return;
                }
                this.log(2, "Neighbor request for " + gnrm.getRequestedRange() + ", found " + numRequested + " neighbors");
                final Id[] neighbors = new Id[numRequested];
                final long[] lastSeen = new long[numRequested];
                Iterator iter = requestedNeighbors.getIterator();
                for (int i3 = 0; i3 < numRequested; ++i3) {
                    neighbors[i3] = (Id)iter.next();
                }
                this.neighborStorage.getObject(neighbors[0], new Continuation(){
                    int currentLookup = 0;

                    public void receiveResult(Object o) {
                        GlacierImpl.this.log(3, "Continue: NeighborRequest from " + gnrm.getSource().getId() + " for range " + gnrm.getRequestedRange());
                        if (o == null) {
                            GlacierImpl.this.warn("Problem while retrieving neighbors -- canceled");
                            return;
                        }
                        if (o instanceof Long) {
                            GlacierImpl.this.log(3, "Retr: Neighbor " + neighbors[this.currentLookup] + " was last seen at " + o);
                            lastSeen[this.currentLookup] = (Long)o;
                            ++this.currentLookup;
                            if (this.currentLookup < numRequested) {
                                GlacierImpl.this.neighborStorage.getObject(neighbors[this.currentLookup], this);
                            } else {
                                GlacierImpl.this.log(3, "Sending neighbor response...");
                                GlacierImpl.this.sendMessage(null, new GlacierNeighborResponseMessage(gnrm.getUID(), neighbors, lastSeen, GlacierImpl.this.getLocalNodeHandle(), gnrm.getSource().getId(), gnrm.getTag()), gnrm.getSource());
                            }
                        }
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.this.warn("Problem while retrieving neighbors in range " + gnrm.getRequestedRange() + " for " + gnrm.getSource() + " -- canceled");
                        e.printStackTrace();
                    }
                });
                return;
            }
            if (msg instanceof GlacierSyncMessage) {
                final GlacierSyncMessage gsm = (GlacierSyncMessage)msg;
                this.log(2, "SyncRequest from " + gsm.getSource().getId() + " for " + gsm.getRange() + " offset " + gsm.getOffsetFID());
                this.log(3, "Contains " + gsm.getBloomFilter());
                Iterator iter = this.fragmentStorage.scan().getIterator();
                IdRange range = gsm.getRange();
                final int offset = gsm.getOffsetFID();
                BloomFilter bv = gsm.getBloomFilter();
                long earliestAcceptableExpiration = System.currentTimeMillis() + 300000L;
                long latestAcceptableStoredSince = System.currentTimeMillis() - 30000L;
                final Vector<FragmentKey> missing = new Vector<FragmentKey>();
                while (iter.hasNext()) {
                    FragmentKey fkey = (FragmentKey)iter.next();
                    Id thisPos = this.getFragmentLocation(fkey);
                    if (range.containsId(thisPos)) {
                        FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(fkey);
                        if (metadata != null) {
                            if (!bv.contains(this.getHashInput(fkey.getVersionKey(), metadata.getCurrentExpiration()))) {
                                if (metadata.getCurrentExpiration() >= earliestAcceptableExpiration) {
                                    if (metadata.getStoredSince() <= latestAcceptableStoredSince) {
                                        this.log(4, fkey + " @" + thisPos + " - MISSING");
                                        missing.add(fkey);
                                        if (missing.size() < this.syncMaxFragments) continue;
                                        this.log(2, "Limit of " + this.syncMaxFragments + " missing fragments reached");
                                        break;
                                    }
                                    this.log(3, fkey + " @" + thisPos + " - TOO FRESH (stored " + (System.currentTimeMillis() - metadata.getStoredSince()) + "ms)");
                                    continue;
                                }
                                this.log(3, fkey + " @" + thisPos + " - EXPIRES SOON (in " + (metadata.getCurrentExpiration() - System.currentTimeMillis()) + "ms)");
                                continue;
                            }
                            this.log(4, fkey + " @" + thisPos + " - OK");
                            continue;
                        }
                        this.warn("SYNC RESPONSE cannot read metadata in object " + fkey.toStringFull() + ", storage returned null");
                        continue;
                    }
                    this.log(4, fkey + " @" + thisPos + " - OUT OF RANGE");
                }
                if (missing.isEmpty()) {
                    this.log(2, "No fragments missing. OK. ");
                    return;
                }
                this.log(2, "Sending " + missing.size() + " fragments to " + gsm.getSource().getId());
                this.fragmentStorage.getObject((FragmentKey)missing.elementAt(0), new Continuation(){
                    int currentLookup = 0;
                    int manifestIndex = 0;
                    final int numLookups = missing.size();
                    Manifest[] manifests = new Manifest[Math.min(this.numLookups, 5)];
                    Fragment[] fragments = new Fragment[Math.min(this.numLookups, 5)];
                    FragmentKey[] keys = new FragmentKey[Math.min(this.numLookups, 5)];

                    public void receiveResult(Object o) {
                        FragmentKey thisKey = (FragmentKey)missing.elementAt(this.currentLookup);
                        if (o == null) {
                            GlacierImpl.this.warn("SYN2: Fragment " + thisKey + " not found -- canceled SYN");
                            return;
                        }
                        GlacierImpl.this.log(3, "Retrieved manifest " + thisKey + " (dest=" + gsm.getSource().getId() + ", offset=" + offset + ")");
                        FragmentAndManifest fam = (FragmentAndManifest)o;
                        if (!GlacierImpl.this.policy.checkSignature(fam.manifest, thisKey.getVersionKey())) {
                            GlacierImpl.this.panic("Signature mismatch!!");
                        }
                        this.fragments[this.manifestIndex] = null;
                        this.manifests[this.manifestIndex] = fam.manifest;
                        int hisFID = thisKey.getFragmentID() - offset;
                        if (hisFID < 0) {
                            hisFID += GlacierImpl.this.numFragments;
                        }
                        if (hisFID >= GlacierImpl.this.numFragments) {
                            GlacierImpl.this.panic("Assertion failed: L938");
                        }
                        this.keys[this.manifestIndex] = new FragmentKey(thisKey.getVersionKey(), hisFID);
                        GlacierImpl.this.log(3, "He should have key " + this.keys[this.manifestIndex] + " @" + GlacierImpl.this.getFragmentLocation(this.keys[this.manifestIndex]));
                        ++this.manifestIndex;
                        ++this.currentLookup;
                        if (this.manifestIndex == 5 || this.currentLookup == this.numLookups) {
                            GlacierImpl.this.log(3, "Sending a packet with " + this.keys.length + " manifests to " + gsm.getSource().getId());
                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(GlacierImpl.this.getUID(), this.keys, this.fragments, this.manifests, GlacierImpl.this.getLocalNodeHandle(), gsm.getSource().getId(), false, '\u0003'), gsm.getSource());
                            this.manifestIndex = 0;
                            this.manifests = new Manifest[Math.min(this.numLookups - this.currentLookup, 5)];
                            this.keys = new FragmentKey[Math.min(this.numLookups - this.currentLookup, 5)];
                            this.fragments = new Fragment[Math.min(this.numLookups - this.currentLookup, 5)];
                        }
                        if (this.currentLookup < this.numLookups) {
                            GlacierImpl.this.fragmentStorage.getObject((FragmentKey)missing.elementAt(this.currentLookup), this);
                        }
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.this.warn("SYN2: Exception while retrieving fragment " + missing.elementAt(this.currentLookup) + ", e=" + e + " -- canceled SYN");
                    }
                });
                return;
            }
            if (msg instanceof GlacierRefreshProbeMessage) {
                grpm = (GlacierRefreshProbeMessage)msg;
                Id requestedId = ((GlacierRefreshProbeMessage)grpm).getRequestedId();
                this.log(2, "Refresh probe for " + requestedId + " (RR=" + this.responsibleRange + ")");
                Id[][] ranges = this.getNeighborRanges();
                IdRange returnedRange = null;
                boolean online = false;
                if (this.responsibleRange.containsId(requestedId)) {
                    returnedRange = this.responsibleRange;
                    online = true;
                } else {
                    online = false;
                    for (int i4 = 0; i4 < ranges.length; ++i4) {
                        IdRange thisRange = this.factory.buildIdRange(ranges[i4][0], ranges[i4][2]);
                        this.log(3, " - " + thisRange + " (" + ranges[i4][1] + ")");
                        if (!thisRange.containsId(requestedId)) continue;
                        returnedRange = thisRange;
                    }
                }
                this.sendMessage(null, new GlacierRefreshResponseMessage(grpm.getUID(), returnedRange, online, this.getLocalNodeHandle(), grpm.getSource().getId(), grpm.getTag()), grpm.getSource());
            } else if (msg instanceof GlacierRefreshPatchMessage) {
                grpm = (GlacierRefreshPatchMessage)msg;
                this.log(2, "AR Refresh patches received for " + ((GlacierRefreshPatchMessage)grpm).numKeys() + " keys. Processing...");
                Continuation c = new Continuation((GlacierRefreshPatchMessage)grpm){
                    int[] successes;
                    int currentPhase;
                    FragmentKey currentKey;
                    int currentIndex;
                    int currentFID;
                    static final int phaseFetch = 1;
                    static final int phaseStore = 2;
                    static final int phaseAdvance = 3;
                    private final /* synthetic */ GlacierRefreshPatchMessage val$grpm;
                    {
                        this.val$grpm = val$grpm;
                        this.successes = new int[this.val$grpm.numKeys()];
                        this.currentPhase = 3;
                        this.currentKey = null;
                        this.currentIndex = 0;
                        this.currentFID = -1;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void receiveResult(Object o) {
                        block10: {
                            block11: {
                                if (this.currentPhase != 1) break block10;
                                GlacierImpl.this.log(3, "AR Patch: Got FAM for " + this.currentKey);
                                FragmentAndManifest fam = (FragmentAndManifest)o;
                                fam.manifest.update(this.val$grpm.getLifetime(this.currentIndex), this.val$grpm.getSignature(this.currentIndex));
                                if (!GlacierImpl.this.policy.checkSignature(fam.manifest, this.currentKey.getVersionKey())) break block11;
                                FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(this.currentKey);
                                if (metadata != null) {
                                    if (metadata.currentExpirationDate <= this.val$grpm.getLifetime(this.currentIndex)) {
                                        this.currentPhase = 2;
                                        if (metadata.currentExpirationDate != this.val$grpm.getLifetime(this.currentIndex)) {
                                            FragmentMetadata newMetadata = new FragmentMetadata(this.val$grpm.getLifetime(this.currentIndex), metadata.currentExpirationDate, metadata.storedSince);
                                            GlacierImpl.this.log(3, "AR FAM " + this.currentKey + " updated (" + newMetadata.previousExpirationDate + " -> " + newMetadata.currentExpirationDate + "), writing to disk...");
                                            GlacierImpl.this.fragmentStorage.store(this.currentKey, newMetadata, fam, this);
                                            return;
                                        }
                                        GlacierImpl.this.log(3, "AR Duplicate refresh request (prev=" + metadata.previousExpirationDate + " cur=" + metadata.currentExpirationDate + " updated=" + this.val$grpm.getLifetime(this.currentIndex) + ") -- ignoring");
                                        break block10;
                                    } else {
                                        GlacierImpl.this.warn("RefreshPatch attempts to roll back lifetime from " + metadata.currentExpirationDate + " to " + this.val$grpm.getLifetime(this.currentIndex));
                                        this.currentPhase = 2;
                                    }
                                    break block10;
                                } else {
                                    GlacierImpl.this.warn("Cannot fetch metadata for key " + this.currentKey + ", got 'null'");
                                    this.currentPhase = 3;
                                }
                                break block10;
                            }
                            GlacierImpl.this.warn("RefreshPatch with invalid signature: " + this.currentKey);
                            this.currentPhase = 3;
                        }
                        if (this.currentPhase == 2) {
                            GlacierImpl.this.log(3, "AR Patch: Update completed for " + this.currentKey);
                            int n = this.currentIndex;
                            this.successes[n] = this.successes[n] + 1;
                            this.currentPhase = 3;
                        }
                        if (this.currentPhase == 3) {
                            do {
                                ++this.currentFID;
                                if (this.currentFID >= GlacierImpl.this.numFragments) {
                                    this.currentFID = 0;
                                    ++this.currentIndex;
                                }
                                if (this.currentIndex >= this.val$grpm.numKeys()) {
                                    this.respond();
                                    return;
                                }
                                this.currentKey = new FragmentKey(this.val$grpm.getKey(this.currentIndex), this.currentFID);
                            } while (!GlacierImpl.this.fragmentStorage.exists(this.currentKey));
                            this.currentPhase = 1;
                            GlacierImpl.this.log(3, "AR Patch: Fetching FAM for " + this.currentKey);
                            GlacierImpl.this.fragmentStorage.getObject(this.currentKey, this);
                        }
                    }

                    public void respond() {
                        int totalSuccesses = 0;
                        for (int i = 0; i < this.successes.length; ++i) {
                            totalSuccesses += this.successes[i];
                        }
                        GlacierImpl.this.log(3, "AR Patch: Sending response (" + totalSuccesses + " updates total)");
                        GlacierImpl.this.sendMessage(null, new GlacierRefreshCompleteMessage(this.val$grpm.getUID(), this.val$grpm.getAllKeys(), this.successes, GlacierImpl.this.getLocalNodeHandle(), this.val$grpm.getSource().getId(), this.val$grpm.getTag()), this.val$grpm.getSource());
                    }

                    public void receiveException(Exception e) {
                        GlacierImpl.this.warn("Exception while processing AR patch (key " + this.currentKey + ", phase " + this.currentPhase + "): " + e);
                        e.printStackTrace();
                        this.currentPhase = 3;
                        this.receiveResult(null);
                    }
                };
                c.receiveResult(null);
            } else {
                if (msg instanceof GlacierRangeQueryMessage) {
                    GlacierRangeQueryMessage grqm = (GlacierRangeQueryMessage)msg;
                    IdRange requestedRange = grqm.getRequestedRange();
                    this.log(2, "Range query for " + requestedRange);
                    Id[][] ranges = this.getNeighborRanges();
                    for (i = 0; i < ranges.length; ++i) {
                        IdRange thisRange = this.factory.buildIdRange(ranges[i][0], ranges[i][2]);
                        IdRange intersectRange = requestedRange.intersectRange(thisRange);
                        if (intersectRange.isEmpty()) continue;
                        this.log(3, "     - Intersects: " + intersectRange + ", sending RangeForward");
                        this.sendMessage(ranges[i][1], new GlacierRangeForwardMessage(grqm.getUID(), requestedRange, grqm.getSource(), this.getLocalNodeHandle(), ranges[i][1], grqm.getTag()), null);
                    }
                    this.log(3, "Finished processing range query");
                    return;
                }
                if (msg instanceof GlacierRangeForwardMessage) {
                    GlacierRangeForwardMessage grfm = (GlacierRangeForwardMessage)msg;
                    if (!grfm.getDestination().equals(this.getLocalNodeHandle().getId())) {
                        this.log(1, "GRFM: Not for us (dest=" + grfm.getDestination() + ", we=" + this.getLocalNodeHandle().getId());
                        return;
                    }
                    IdRange commonRange = this.responsibleRange.intersectRange(grfm.getRequestedRange());
                    if (!commonRange.isEmpty()) {
                        this.log(2, "Range forward: Returning common range " + commonRange + " to requestor " + grfm.getRequestor());
                        this.sendMessage(null, new GlacierRangeResponseMessage(grfm.getUID(), commonRange, this.getLocalNodeHandle(), grfm.getRequestor().getId(), grfm.getTag()), grfm.getRequestor());
                    } else {
                        this.warn("Received GRFM by " + grfm.getRequestor() + ", but no common range??!? -- ignored");
                    }
                    return;
                }
                if (msg instanceof GlacierFetchMessage) {
                    final GlacierFetchMessage gfm = (GlacierFetchMessage)msg;
                    this.log(2, "Fetch request for " + gfm.getKey(0) + (gfm.getNumKeys() > 1 ? " and " + (gfm.getNumKeys() - 1) + " other keys" : "") + ", request=" + gfm.getRequest());
                    this.fragmentStorage.getObject(gfm.getKey(0), new Continuation(){
                        int currentLookup = 0;
                        Fragment[] fragment = new Fragment[gfm.getNumKeys()];
                        Manifest[] manifest = new Manifest[gfm.getNumKeys()];
                        int numFragments = 0;
                        int numManifests = 0;

                        public void returnResponse() {
                            GlacierImpl.this.log(3, "Returning response with " + this.numFragments + " fragments, " + this.numManifests + " manifests (" + gfm.getNumKeys() + " queries originally)");
                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(gfm.getUID(), gfm.getAllKeys(), this.fragment, this.manifest, GlacierImpl.this.getLocalNodeHandle(), gfm.getSource().getId(), true, gfm.getTag()), gfm.getSource());
                        }

                        public void receiveResult(Object o) {
                            if (o != null) {
                                GlacierImpl.this.log(2, "Fragment " + gfm.getKey(this.currentLookup) + " found (" + o + ")");
                                FragmentAndManifest fam = (FragmentAndManifest)o;
                                Fragment fragment = this.fragment[this.currentLookup] = (gfm.getRequest() & 1) != 0 ? fam.fragment : null;
                                if (this.fragment[this.currentLookup] != null) {
                                    ++this.numFragments;
                                }
                                Manifest manifest = this.manifest[this.currentLookup] = (gfm.getRequest() & 2) != 0 ? fam.manifest : null;
                                if (this.manifest[this.currentLookup] != null) {
                                    ++this.numManifests;
                                }
                            } else {
                                GlacierImpl.this.log(2, "Fragment " + gfm.getKey(this.currentLookup) + " not found");
                                this.fragment[this.currentLookup] = null;
                                this.manifest[this.currentLookup] = null;
                            }
                            this.nextLookup();
                        }

                        public void nextLookup() {
                            ++this.currentLookup;
                            if (this.currentLookup >= gfm.getNumKeys()) {
                                this.returnResponse();
                            } else {
                                GlacierImpl.this.fragmentStorage.getObject(gfm.getKey(this.currentLookup), this);
                            }
                        }

                        public void receiveException(Exception e) {
                            GlacierImpl.this.warn("Exception while retrieving fragment " + gfm.getKey(this.currentLookup) + " (lookup #" + this.currentLookup + "), e=" + e);
                            e.printStackTrace();
                            this.fragment[this.currentLookup] = null;
                            this.manifest[this.currentLookup] = null;
                            this.nextLookup();
                        }
                    });
                } else {
                    if (msg instanceof GlacierDataMessage) {
                        gdm = (GlacierDataMessage)msg;
                        for (int i5 = 0; i5 < gdm.numKeys(); ++i5) {
                            final FragmentKey thisKey = gdm.getKey(i5);
                            Fragment thisFragment = gdm.getFragment(i5);
                            final Manifest thisManifest = gdm.getManifest(i5);
                            if (thisFragment != null && thisManifest != null) {
                                this.log(2, "Data: Fragment+Manifest for " + thisKey);
                                if (!this.responsibleRange.containsId(this.getFragmentLocation(thisKey))) {
                                    this.warn("Not responsible for " + thisKey + " (at " + this.getFragmentLocation(thisKey) + ") -- discarding");
                                    continue;
                                }
                                if (!this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                    this.warn("Manifest is not signed properly");
                                    continue;
                                }
                                if (!thisManifest.validatesFragment(thisFragment, thisKey.getFragmentID())) {
                                    this.warn("Manifest does not validate this fragment");
                                    continue;
                                }
                                if (!this.fragmentStorage.exists(thisKey)) {
                                    this.log(3, "Verified ok. Storing locally.");
                                    FragmentAndManifest fam = new FragmentAndManifest(thisFragment, thisManifest);
                                    this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, System.currentTimeMillis()), fam, new Continuation(){

                                        public void receiveResult(Object o) {
                                            GlacierImpl.this.log(2, "Stored OK, sending receipt: " + thisKey);
                                            GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey)), GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, gdm.getTag()), gdm.getSource());
                                        }

                                        public void receiveException(Exception e) {
                                            GlacierImpl.this.warn("receiveException(" + e + ") while storing a fragment -- unexpected, ignored (key=" + thisKey + ")");
                                        }
                                    });
                                    continue;
                                }
                                this.warn("We already have a fragment with this key! -- discarding");
                                continue;
                            }
                            if (thisFragment == null && thisManifest != null) {
                                if (!this.responsibleRange.containsId(this.getFragmentLocation(thisKey))) {
                                    this.warn("Not responsible for " + thisKey + " (at " + this.getFragmentLocation(thisKey) + ") -- discarding");
                                    continue;
                                }
                                if (this.fragmentStorage.exists(thisKey)) {
                                    final FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(thisKey);
                                    if (metadata == null || metadata.getCurrentExpiration() < thisManifest.getExpiration()) {
                                        this.log(2, "Replacing old manifest for " + thisKey + " (expires " + (metadata == null ? "(broken)" : "" + metadata.getCurrentExpiration()) + ") by new one (expires " + thisManifest.getExpiration() + ")");
                                        this.fragmentStorage.getObject(thisKey, new Continuation(){

                                            public void receiveResult(Object o) {
                                                if (o instanceof FragmentAndManifest) {
                                                    FragmentAndManifest fam = (FragmentAndManifest)o;
                                                    GlacierImpl.this.log(3, "Got FAM for " + thisKey + ", now replacing old manifest with new one...");
                                                    String fault = null;
                                                    if (!thisManifest.validatesFragment(fam.fragment, thisKey.getFragmentID())) {
                                                        fault = "Update: Manifest does not validate this fragment";
                                                    }
                                                    if (!GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                                        fault = "Update: Manifest is not signed properly";
                                                    }
                                                    if (!Arrays.equals(thisManifest.getObjectHash(), fam.manifest.getObjectHash())) {
                                                        fault = "Update: Object hashes not equal";
                                                    }
                                                    for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                                                        if (Arrays.equals(thisManifest.getFragmentHash(i), fam.manifest.getFragmentHash(i))) continue;
                                                        fault = "Update: Fragment hash #" + i + " does not match";
                                                    }
                                                    if (fault == null) {
                                                        fam.manifest = thisManifest;
                                                        GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), metadata == null ? 0L : metadata.getCurrentExpiration(), System.currentTimeMillis()), fam, new Continuation(this){
                                                            private final /* synthetic */ 56 this$1;
                                                            {
                                                                this.this$1 = this$1;
                                                            }

                                                            public void receiveResult(Object o) {
                                                                GlacierImpl.access$000(56.access$4700(this.this$1), 3, "Old manifest for " + 56.access$4600(this.this$1) + " replaced OK, sending receipt");
                                                                56.access$4700(this.this$1).sendMessage(null, new GlacierResponseMessage(56.access$4800(this.this$1).getUID(), 56.access$4600(this.this$1), true, 56.access$4900(this.this$1).getExpiration(), true, 56.access$4700(this.this$1).getLocalNodeHandle(), 56.access$4800(this.this$1).getSource().getId(), true, 56.access$4800(this.this$1).getTag()), 56.access$4800(this.this$1).getSource());
                                                            }

                                                            public void receiveException(Exception e) {
                                                                GlacierImpl.access$100(56.access$4700(this.this$1), "Cannot store refreshed manifest: " + e);
                                                                e.printStackTrace();
                                                            }
                                                        });
                                                    } else {
                                                        GlacierImpl.this.warn(fault);
                                                    }
                                                } else {
                                                    GlacierImpl.this.warn("Fragment store returns something other than a FAM: " + o);
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                GlacierImpl.this.warn("Cannot retrieve FAM for " + thisKey + ": " + e);
                                                e.printStackTrace();
                                            }

                                            static /* synthetic */ FragmentKey access$4600(56 x0) {
                                                return x0.thisKey;
                                            }

                                            static /* synthetic */ GlacierImpl access$4700(56 x0) {
                                                return x0.GlacierImpl.this;
                                            }

                                            static /* synthetic */ GlacierDataMessage access$4800(56 x0) {
                                                return x0.gdm;
                                            }

                                            static /* synthetic */ Manifest access$4900(56 x0) {
                                                return x0.thisManifest;
                                            }
                                        });
                                        continue;
                                    }
                                    this.warn("We already have exp=" + (metadata == null ? "(broken)" : "" + metadata.getCurrentExpiration()) + ", discarding manifest for " + thisKey + " with exp=" + thisManifest.getExpiration());
                                    continue;
                                }
                                this.log(2, "Data: Manifest for: " + thisKey + ", must fetch");
                                final long tStart = System.currentTimeMillis();
                                this.rateLimitedRetrieveFragment(thisKey, thisManifest, '\u0004', new GlacierContinuation(){

                                    public long getTimeout() {
                                        return tStart + 180000L;
                                    }

                                    public String toString() {
                                        return "Fetch synced fragment: " + thisKey;
                                    }

                                    public void receiveResult(Object o) {
                                        if (o instanceof Fragment) {
                                            if (!GlacierImpl.this.fragmentStorage.exists(thisKey)) {
                                                GlacierImpl.this.log(2, "Received fragment " + thisKey + " (from primary) matches existing manifest, storing...");
                                                FragmentAndManifest fam = new FragmentAndManifest((Fragment)o, thisManifest);
                                                GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, System.currentTimeMillis()), fam, new Continuation(this){
                                                    private final /* synthetic */ 58 this$1;
                                                    {
                                                        this.this$1 = this$1;
                                                    }

                                                    public void receiveResult(Object o) {
                                                        GlacierImpl.access$000(58.access$5000(this.this$1), 3, "Recovered fragment stored OK");
                                                    }

                                                    public void receiveException(Exception e) {
                                                        GlacierImpl.access$100(58.access$5000(this.this$1), "receiveException(" + e + ") while storing a fragment with existing manifest (key=" + 58.access$5100(this.this$1) + ")");
                                                    }
                                                });
                                            } else {
                                                GlacierImpl.this.warn("Received fragment " + thisKey + ", but it already exists in the fragment store");
                                            }
                                        } else {
                                            GlacierImpl.this.warn("FS received something other than a fragment: " + o);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        if (e instanceof GlacierNotEnoughFragmentsException) {
                                            GlacierNotEnoughFragmentsException gnf = (GlacierNotEnoughFragmentsException)e;
                                            GlacierImpl.this.log(2, "Not enough fragments to reconstruct " + thisKey + ": " + gnf.checked + "/" + GlacierImpl.this.numFragments + " checked, " + gnf.found + " found, " + GlacierImpl.this.numSurvivors + " needed");
                                        } else {
                                            GlacierImpl.this.warn("Exception while recovering synced fragment " + thisKey + ": " + e);
                                            e.printStackTrace();
                                        }
                                        this.terminate();
                                    }

                                    public void timeoutExpired() {
                                        GlacierImpl.this.warn("Timeout while fetching synced fragment " + thisKey + " -- aborted");
                                        this.terminate();
                                    }

                                    static /* synthetic */ GlacierImpl access$5000(58 x0) {
                                        return x0.GlacierImpl.this;
                                    }

                                    static /* synthetic */ FragmentKey access$5100(58 x0) {
                                        return x0.thisKey;
                                    }
                                });
                                continue;
                            }
                            this.warn("Case not implemented! -- GDM");
                        }
                        return;
                    }
                    if (msg instanceof GlacierTimeoutMessage) {
                        this.timerExpired();
                        return;
                    }
                    this.panic("GLACIER ERROR - Received message " + msg + " of unknown type.");
                }
            }
        }
    }

    public void emptyTrash(final Continuation c) {
        if (this.trashStorage != null) {
            IdSet trashKeys = this.trashStorage.scan();
            final Iterator iter = trashKeys.getIterator();
            this.log(2, "Emptying trash (removing " + trashKeys.numElements() + " objects)");
            Continuation c2 = new Continuation(){

                public void receiveResult(Object o) {
                    if (!iter.hasNext()) {
                        c.receiveResult(new Boolean(true));
                        return;
                    }
                    Id thisPiece = (Id)iter.next();
                    GlacierImpl.this.trashStorage.unstore(thisPiece, this);
                }

                public void receiveException(Exception e) {
                    this.receiveResult(e);
                }
            };
            c2.receiveResult(null);
        }
    }

    public void addStatisticsListener(GlacierStatisticsListener gsl) {
        this.listeners.add(gsl);
    }

    public void removeStatisticsListener(GlacierStatisticsListener gsl) {
        this.listeners.removeElement(gsl);
    }

    private static byte[] getDistance(double d) {
        byte[] result = new byte[20];
        double c = 0.5;
        for (int i = 19; i >= 0; --i) {
            result[i] = 0;
            for (int j = 7; j >= 0; --j) {
                if (d >= c) {
                    int n = i;
                    result[n] = (byte)(result[n] | 1 << j);
                    d -= c;
                }
                c /= 2.0;
            }
        }
        return result;
    }

    private static String dump(byte[] data, boolean linebreak) {
        String hex = "0123456789ABCDEF";
        String result = "";
        for (int i = 0; i < data.length; ++i) {
            int d = data[i];
            if (d < 0) {
                d += 256;
            }
            int hi = d >> 4;
            int lo = d & 0xF;
            result = result + "0123456789ABCDEF".charAt(hi) + "0123456789ABCDEF".charAt(lo);
            if (linebreak && (i % 16 == 15 || i == data.length - 1)) {
                result = result + "\n";
                continue;
            }
            if (i == data.length - 1) continue;
            result = result + " ";
        }
        return result;
    }

    static /* synthetic */ byte[] access$1000(GlacierImpl x0, VersionKey x1, long x2) {
        return x0.getHashInput(x1, x2);
    }

    static /* synthetic */ void access$3300(GlacierImpl x0, VersionKey x1, Fragment[] x2, Manifest[] x3, long x4, char x5, Continuation x6) {
        x0.distribute(x1, x2, x3, x4, x5, x6);
    }
}

